var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __extends = (this && this.__extends) || (function () {
            var extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
            return function (d, b) {
                extendStatics(d, b);
                function __() { this.constructor = d; }
                d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
            };
        })();
        

//# sourceMappingURL=babylon.types.js.map


var BABYLON;
(function (BABYLON) {
    var KeyboardEventTypes = /** @class */ (function () {
        function KeyboardEventTypes() {
        }
        Object.defineProperty(KeyboardEventTypes, "KEYDOWN", {
            get: function () {
                return KeyboardEventTypes._KEYDOWN;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(KeyboardEventTypes, "KEYUP", {
            get: function () {
                return KeyboardEventTypes._KEYUP;
            },
            enumerable: true,
            configurable: true
        });
        KeyboardEventTypes._KEYDOWN = 0x01;
        KeyboardEventTypes._KEYUP = 0x02;
        return KeyboardEventTypes;
    }());
    BABYLON.KeyboardEventTypes = KeyboardEventTypes;
    var KeyboardInfo = /** @class */ (function () {
        function KeyboardInfo(type, event) {
            this.type = type;
            this.event = event;
        }
        return KeyboardInfo;
    }());
    BABYLON.KeyboardInfo = KeyboardInfo;
    /**
     * This class is used to store keyboard related info for the onPreKeyboardObservable event.
     * Set the skipOnKeyboardObservable property to true if you want the engine to stop any process after this event is triggered, even not calling onKeyboardObservable
     */
    var KeyboardInfoPre = /** @class */ (function (_super) {
        __extends(KeyboardInfoPre, _super);
        function KeyboardInfoPre(type, event) {
            var _this = _super.call(this, type, event) || this;
            _this.skipOnPointerObservable = false;
            return _this;
        }
        return KeyboardInfoPre;
    }(KeyboardInfo));
    BABYLON.KeyboardInfoPre = KeyboardInfoPre;
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.keyboardEvents.js.map


var BABYLON;
(function (BABYLON) {
    var PointerEventTypes = /** @class */ (function () {
        function PointerEventTypes() {
        }
        Object.defineProperty(PointerEventTypes, "POINTERDOWN", {
            get: function () {
                return PointerEventTypes._POINTERDOWN;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PointerEventTypes, "POINTERUP", {
            get: function () {
                return PointerEventTypes._POINTERUP;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PointerEventTypes, "POINTERMOVE", {
            get: function () {
                return PointerEventTypes._POINTERMOVE;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PointerEventTypes, "POINTERWHEEL", {
            get: function () {
                return PointerEventTypes._POINTERWHEEL;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PointerEventTypes, "POINTERPICK", {
            get: function () {
                return PointerEventTypes._POINTERPICK;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PointerEventTypes, "POINTERTAP", {
            get: function () {
                return PointerEventTypes._POINTERTAP;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PointerEventTypes, "POINTERDOUBLETAP", {
            get: function () {
                return PointerEventTypes._POINTERDOUBLETAP;
            },
            enumerable: true,
            configurable: true
        });
        PointerEventTypes._POINTERDOWN = 0x01;
        PointerEventTypes._POINTERUP = 0x02;
        PointerEventTypes._POINTERMOVE = 0x04;
        PointerEventTypes._POINTERWHEEL = 0x08;
        PointerEventTypes._POINTERPICK = 0x10;
        PointerEventTypes._POINTERTAP = 0x20;
        PointerEventTypes._POINTERDOUBLETAP = 0x40;
        return PointerEventTypes;
    }());
    BABYLON.PointerEventTypes = PointerEventTypes;
    var PointerInfoBase = /** @class */ (function () {
        function PointerInfoBase(type, event) {
            this.type = type;
            this.event = event;
        }
        return PointerInfoBase;
    }());
    BABYLON.PointerInfoBase = PointerInfoBase;
    /**
     * This class is used to store pointer related info for the onPrePointerObservable event.
     * Set the skipOnPointerObservable property to true if you want the engine to stop any process after this event is triggered, even not calling onPointerObservable
     */
    var PointerInfoPre = /** @class */ (function (_super) {
        __extends(PointerInfoPre, _super);
        function PointerInfoPre(type, event, localX, localY) {
            var _this = _super.call(this, type, event) || this;
            _this.skipOnPointerObservable = false;
            _this.localPosition = new BABYLON.Vector2(localX, localY);
            return _this;
        }
        return PointerInfoPre;
    }(PointerInfoBase));
    BABYLON.PointerInfoPre = PointerInfoPre;
    /**
     * This type contains all the data related to a pointer event in Babylon.js.
     * The event member is an instance of PointerEvent for all types except PointerWheel and is of type MouseWheelEvent when type equals PointerWheel. The different event types can be found in the PointerEventTypes class.
     */
    var PointerInfo = /** @class */ (function (_super) {
        __extends(PointerInfo, _super);
        function PointerInfo(type, event, pickInfo) {
            var _this = _super.call(this, type, event) || this;
            _this.pickInfo = pickInfo;
            return _this;
        }
        return PointerInfo;
    }(PointerInfoBase));
    BABYLON.PointerInfo = PointerInfo;
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.pointerEvents.js.map

var BABYLON;
(function (BABYLON) {
    BABYLON.ToGammaSpace = 1 / 2.2;
    BABYLON.ToLinearSpace = 2.2;
    BABYLON.Epsilon = 0.001;
    var Color3 = /** @class */ (function () {
        /**
         * Creates a new Color3 object from red, green, blue values, all between 0 and 1.
         */
        function Color3(r, g, b) {
            if (r === void 0) { r = 0; }
            if (g === void 0) { g = 0; }
            if (b === void 0) { b = 0; }
            this.r = r;
            this.g = g;
            this.b = b;
        }
        /**
         * Returns a string with the Color3 current values.
         */
        Color3.prototype.toString = function () {
            return "{R: " + this.r + " G:" + this.g + " B:" + this.b + "}";
        };
        /**
         * Returns the string "Color3".
         */
        Color3.prototype.getClassName = function () {
            return "Color3";
        };
        /**
         * Returns the Color3 hash code.
         */
        Color3.prototype.getHashCode = function () {
            var hash = this.r || 0;
            hash = (hash * 397) ^ (this.g || 0);
            hash = (hash * 397) ^ (this.b || 0);
            return hash;
        };
        // Operators
        /**
         * Stores in the passed array from the passed starting index the red, green, blue values as successive elements.
         * Returns the Color3.
         */
        Color3.prototype.toArray = function (array, index) {
            if (index === undefined) {
                index = 0;
            }
            array[index] = this.r;
            array[index + 1] = this.g;
            array[index + 2] = this.b;
            return this;
        };
        /**
         * Returns a new Color4 object from the current Color3 and the passed alpha.
         */
        Color3.prototype.toColor4 = function (alpha) {
            if (alpha === void 0) { alpha = 1; }
            return new Color4(this.r, this.g, this.b, alpha);
        };
        /**
         * Returns a new array populated with 3 numeric elements : red, green and blue values.
         */
        Color3.prototype.asArray = function () {
            var result = new Array();
            this.toArray(result, 0);
            return result;
        };
        /**
         * Returns the luminance value (float).
         */
        Color3.prototype.toLuminance = function () {
            return this.r * 0.3 + this.g * 0.59 + this.b * 0.11;
        };
        /**
         * Multiply each Color3 rgb values by the passed Color3 rgb values in a new Color3 object.
         * Returns this new object.
         */
        Color3.prototype.multiply = function (otherColor) {
            return new Color3(this.r * otherColor.r, this.g * otherColor.g, this.b * otherColor.b);
        };
        /**
         * Multiply the rgb values of the Color3 and the passed Color3 and stores the result in the object "result".
         * Returns the current Color3.
         */
        Color3.prototype.multiplyToRef = function (otherColor, result) {
            result.r = this.r * otherColor.r;
            result.g = this.g * otherColor.g;
            result.b = this.b * otherColor.b;
            return this;
        };
        /**
         * Boolean : True if the rgb values are equal to the passed ones.
         */
        Color3.prototype.equals = function (otherColor) {
            return otherColor && this.r === otherColor.r && this.g === otherColor.g && this.b === otherColor.b;
        };
        /**
         * Boolean : True if the rgb values are equal to the passed ones.
         */
        Color3.prototype.equalsFloats = function (r, g, b) {
            return this.r === r && this.g === g && this.b === b;
        };
        /**
         * Multiplies in place each rgb value by scale.
         * Returns the updated Color3.
         */
        Color3.prototype.scale = function (scale) {
            return new Color3(this.r * scale, this.g * scale, this.b * scale);
        };
        /**
         * Multiplies the rgb values by scale and stores the result into "result".
         * Returns the unmodified current Color3.
         */
        Color3.prototype.scaleToRef = function (scale, result) {
            result.r = this.r * scale;
            result.g = this.g * scale;
            result.b = this.b * scale;
            return this;
        };
        /**
         * Returns a new Color3 set with the added values of the current Color3 and of the passed one.
         */
        Color3.prototype.add = function (otherColor) {
            return new Color3(this.r + otherColor.r, this.g + otherColor.g, this.b + otherColor.b);
        };
        /**
         * Stores the result of the addition of the current Color3 and passed one rgb values into "result".
         * Returns the unmodified current Color3.
         */
        Color3.prototype.addToRef = function (otherColor, result) {
            result.r = this.r + otherColor.r;
            result.g = this.g + otherColor.g;
            result.b = this.b + otherColor.b;
            return this;
        };
        /**
         * Returns a new Color3 set with the subtracted values of the passed one from the current Color3 .
         */
        Color3.prototype.subtract = function (otherColor) {
            return new Color3(this.r - otherColor.r, this.g - otherColor.g, this.b - otherColor.b);
        };
        /**
         * Stores the result of the subtraction of passed one from the current Color3 rgb values into "result".
         * Returns the unmodified current Color3.
         */
        Color3.prototype.subtractToRef = function (otherColor, result) {
            result.r = this.r - otherColor.r;
            result.g = this.g - otherColor.g;
            result.b = this.b - otherColor.b;
            return this;
        };
        /**
         * Returns a new Color3 copied the current one.
         */
        Color3.prototype.clone = function () {
            return new Color3(this.r, this.g, this.b);
        };
        /**
         * Copies the rgb values from the source in the current Color3.
         * Returns the updated Color3.
         */
        Color3.prototype.copyFrom = function (source) {
            this.r = source.r;
            this.g = source.g;
            this.b = source.b;
            return this;
        };
        /**
         * Updates the Color3 rgb values from the passed floats.
         * Returns the Color3.
         */
        Color3.prototype.copyFromFloats = function (r, g, b) {
            this.r = r;
            this.g = g;
            this.b = b;
            return this;
        };
        /**
         * Updates the Color3 rgb values from the passed floats.
         * Returns the Color3.
         */
        Color3.prototype.set = function (r, g, b) {
            return this.copyFromFloats(r, g, b);
        };
        /**
         * Returns the Color3 hexadecimal code as a string.
         */
        Color3.prototype.toHexString = function () {
            var intR = (this.r * 255) | 0;
            var intG = (this.g * 255) | 0;
            var intB = (this.b * 255) | 0;
            return "#" + BABYLON.Scalar.ToHex(intR) + BABYLON.Scalar.ToHex(intG) + BABYLON.Scalar.ToHex(intB);
        };
        /**
         * Returns a new Color3 converted to linear space.
         */
        Color3.prototype.toLinearSpace = function () {
            var convertedColor = new Color3();
            this.toLinearSpaceToRef(convertedColor);
            return convertedColor;
        };
        /**
         * Converts the Color3 values to linear space and stores the result in "convertedColor".
         * Returns the unmodified Color3.
         */
        Color3.prototype.toLinearSpaceToRef = function (convertedColor) {
            convertedColor.r = Math.pow(this.r, BABYLON.ToLinearSpace);
            convertedColor.g = Math.pow(this.g, BABYLON.ToLinearSpace);
            convertedColor.b = Math.pow(this.b, BABYLON.ToLinearSpace);
            return this;
        };
        /**
         * Returns a new Color3 converted to gamma space.
         */
        Color3.prototype.toGammaSpace = function () {
            var convertedColor = new Color3();
            this.toGammaSpaceToRef(convertedColor);
            return convertedColor;
        };
        /**
         * Converts the Color3 values to gamma space and stores the result in "convertedColor".
         * Returns the unmodified Color3.
         */
        Color3.prototype.toGammaSpaceToRef = function (convertedColor) {
            convertedColor.r = Math.pow(this.r, BABYLON.ToGammaSpace);
            convertedColor.g = Math.pow(this.g, BABYLON.ToGammaSpace);
            convertedColor.b = Math.pow(this.b, BABYLON.ToGammaSpace);
            return this;
        };
        // Statics
        /**
         * Creates a new Color3 from the string containing valid hexadecimal values.
         */
        Color3.FromHexString = function (hex) {
            if (hex.substring(0, 1) !== "#" || hex.length !== 7) {
                //Tools.Warn("Color3.FromHexString must be called with a string like #FFFFFF");
                return new Color3(0, 0, 0);
            }
            var r = parseInt(hex.substring(1, 3), 16);
            var g = parseInt(hex.substring(3, 5), 16);
            var b = parseInt(hex.substring(5, 7), 16);
            return Color3.FromInts(r, g, b);
        };
        /**
         * Creates a new Vector3 from the startind index of the passed array.
         */
        Color3.FromArray = function (array, offset) {
            if (offset === void 0) { offset = 0; }
            return new Color3(array[offset], array[offset + 1], array[offset + 2]);
        };
        /**
         * Creates a new Color3 from integer values ( < 256).
         */
        Color3.FromInts = function (r, g, b) {
            return new Color3(r / 255.0, g / 255.0, b / 255.0);
        };
        /**
         * Creates a new Color3 with values linearly interpolated of "amount" between the start Color3 and the end Color3.
         */
        Color3.Lerp = function (start, end, amount) {
            var r = start.r + ((end.r - start.r) * amount);
            var g = start.g + ((end.g - start.g) * amount);
            var b = start.b + ((end.b - start.b) * amount);
            return new Color3(r, g, b);
        };
        Color3.Red = function () { return new Color3(1, 0, 0); };
        Color3.Green = function () { return new Color3(0, 1, 0); };
        Color3.Blue = function () { return new Color3(0, 0, 1); };
        Color3.Black = function () { return new Color3(0, 0, 0); };
        Color3.White = function () { return new Color3(1, 1, 1); };
        Color3.Purple = function () { return new Color3(0.5, 0, 0.5); };
        Color3.Magenta = function () { return new Color3(1, 0, 1); };
        Color3.Yellow = function () { return new Color3(1, 1, 0); };
        Color3.Gray = function () { return new Color3(0.5, 0.5, 0.5); };
        Color3.Teal = function () { return new Color3(0, 1.0, 1.0); };
        Color3.Random = function () { return new Color3(Math.random(), Math.random(), Math.random()); };
        return Color3;
    }());
    BABYLON.Color3 = Color3;
    var Color4 = /** @class */ (function () {
        /**
         * Creates a new Color4 object from the passed float values ( < 1) : red, green, blue, alpha.
         */
        function Color4(r, g, b, a) {
            if (r === void 0) { r = 0; }
            if (g === void 0) { g = 0; }
            if (b === void 0) { b = 0; }
            if (a === void 0) { a = 1; }
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
        }
        // Operators
        /**
         * Adds in place the passed Color4 values to the current Color4.
         * Returns the updated Color4.
         */
        Color4.prototype.addInPlace = function (right) {
            this.r += right.r;
            this.g += right.g;
            this.b += right.b;
            this.a += right.a;
            return this;
        };
        /**
         * Returns a new array populated with 4 numeric elements : red, green, blue, alpha values.
         */
        Color4.prototype.asArray = function () {
            var result = new Array();
            this.toArray(result, 0);
            return result;
        };
        /**
         * Stores from the starting index in the passed array the Color4 successive values.
         * Returns the Color4.
         */
        Color4.prototype.toArray = function (array, index) {
            if (index === undefined) {
                index = 0;
            }
            array[index] = this.r;
            array[index + 1] = this.g;
            array[index + 2] = this.b;
            array[index + 3] = this.a;
            return this;
        };
        /**
         * Returns a new Color4 set with the added values of the current Color4 and of the passed one.
         */
        Color4.prototype.add = function (right) {
            return new Color4(this.r + right.r, this.g + right.g, this.b + right.b, this.a + right.a);
        };
        /**
         * Returns a new Color4 set with the subtracted values of the passed one from the current Color4.
         */
        Color4.prototype.subtract = function (right) {
            return new Color4(this.r - right.r, this.g - right.g, this.b - right.b, this.a - right.a);
        };
        /**
         * Subtracts the passed ones from the current Color4 values and stores the results in "result".
         * Returns the Color4.
         */
        Color4.prototype.subtractToRef = function (right, result) {
            result.r = this.r - right.r;
            result.g = this.g - right.g;
            result.b = this.b - right.b;
            result.a = this.a - right.a;
            return this;
        };
        /**
         * Creates a new Color4 with the current Color4 values multiplied by scale.
         */
        Color4.prototype.scale = function (scale) {
            return new Color4(this.r * scale, this.g * scale, this.b * scale, this.a * scale);
        };
        /**
         * Multiplies the current Color4 values by scale and stores the result in "result".
         * Returns the Color4.
         */
        Color4.prototype.scaleToRef = function (scale, result) {
            result.r = this.r * scale;
            result.g = this.g * scale;
            result.b = this.b * scale;
            result.a = this.a * scale;
            return this;
        };
        /**
          * Multipy an RGBA Color4 value by another and return a new Color4 object
          * @param color The Color4 (RGBA) value to multiply by
          * @returns A new Color4.
          */
        Color4.prototype.multiply = function (color) {
            return new Color4(this.r * color.r, this.g * color.g, this.b * color.b, this.a * color.a);
        };
        /**
         * Multipy an RGBA Color4 value by another and push the result in a reference value
         * @param color The Color4 (RGBA) value to multiply by
         * @param result The Color4 (RGBA) to fill the result in
         * @returns the result Color4.
         */
        Color4.prototype.multiplyToRef = function (color, result) {
            result.r = this.r * color.r;
            result.g = this.g * color.g;
            result.b = this.b * color.b;
            result.a = this.a * color.a;
            return result;
        };
        /**
         * Returns a string with the Color4 values.
         */
        Color4.prototype.toString = function () {
            return "{R: " + this.r + " G:" + this.g + " B:" + this.b + " A:" + this.a + "}";
        };
        /**
         * Returns the string "Color4"
         */
        Color4.prototype.getClassName = function () {
            return "Color4";
        };
        /**
         * Return the Color4 hash code as a number.
         */
        Color4.prototype.getHashCode = function () {
            var hash = this.r || 0;
            hash = (hash * 397) ^ (this.g || 0);
            hash = (hash * 397) ^ (this.b || 0);
            hash = (hash * 397) ^ (this.a || 0);
            return hash;
        };
        /**
         * Creates a new Color4 copied from the current one.
         */
        Color4.prototype.clone = function () {
            return new Color4(this.r, this.g, this.b, this.a);
        };
        /**
         * Copies the passed Color4 values into the current one.
         * Returns the updated Color4.
         */
        Color4.prototype.copyFrom = function (source) {
            this.r = source.r;
            this.g = source.g;
            this.b = source.b;
            this.a = source.a;
            return this;
        };
        /**
         * Copies the passed float values into the current one.
         * Returns the updated Color4.
         */
        Color4.prototype.copyFromFloats = function (r, g, b, a) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
            return this;
        };
        /**
         * Copies the passed float values into the current one.
         * Returns the updated Color4.
         */
        Color4.prototype.set = function (r, g, b, a) {
            return this.copyFromFloats(r, g, b, a);
        };
        /**
         * Returns a string containing the hexadecimal Color4 code.
         */
        Color4.prototype.toHexString = function () {
            var intR = (this.r * 255) | 0;
            var intG = (this.g * 255) | 0;
            var intB = (this.b * 255) | 0;
            var intA = (this.a * 255) | 0;
            return "#" + BABYLON.Scalar.ToHex(intR) + BABYLON.Scalar.ToHex(intG) + BABYLON.Scalar.ToHex(intB) + BABYLON.Scalar.ToHex(intA);
        };
        /**
         * Returns a new Color4 converted to linear space.
         */
        Color4.prototype.toLinearSpace = function () {
            var convertedColor = new Color4();
            this.toLinearSpaceToRef(convertedColor);
            return convertedColor;
        };
        /**
         * Converts the Color4 values to linear space and stores the result in "convertedColor".
         * Returns the unmodified Color4.
         */
        Color4.prototype.toLinearSpaceToRef = function (convertedColor) {
            convertedColor.r = Math.pow(this.r, BABYLON.ToLinearSpace);
            convertedColor.g = Math.pow(this.g, BABYLON.ToLinearSpace);
            convertedColor.b = Math.pow(this.b, BABYLON.ToLinearSpace);
            convertedColor.a = this.a;
            return this;
        };
        /**
         * Returns a new Color4 converted to gamma space.
         */
        Color4.prototype.toGammaSpace = function () {
            var convertedColor = new Color4();
            this.toGammaSpaceToRef(convertedColor);
            return convertedColor;
        };
        /**
         * Converts the Color4 values to gamma space and stores the result in "convertedColor".
         * Returns the unmodified Color4.
         */
        Color4.prototype.toGammaSpaceToRef = function (convertedColor) {
            convertedColor.r = Math.pow(this.r, BABYLON.ToGammaSpace);
            convertedColor.g = Math.pow(this.g, BABYLON.ToGammaSpace);
            convertedColor.b = Math.pow(this.b, BABYLON.ToGammaSpace);
            convertedColor.a = this.a;
            return this;
        };
        // Statics
        /**
         * Creates a new Color4 from the valid hexadecimal value contained in the passed string.
         */
        Color4.FromHexString = function (hex) {
            if (hex.substring(0, 1) !== "#" || hex.length !== 9) {
                //Tools.Warn("Color4.FromHexString must be called with a string like #FFFFFFFF");
                return new Color4(0.0, 0.0, 0.0, 0.0);
            }
            var r = parseInt(hex.substring(1, 3), 16);
            var g = parseInt(hex.substring(3, 5), 16);
            var b = parseInt(hex.substring(5, 7), 16);
            var a = parseInt(hex.substring(7, 9), 16);
            return Color4.FromInts(r, g, b, a);
        };
        /**
         * Creates a new Color4 object set with the linearly interpolated values of "amount" between the left Color4 and the right Color4.
         */
        Color4.Lerp = function (left, right, amount) {
            var result = new Color4(0.0, 0.0, 0.0, 0.0);
            Color4.LerpToRef(left, right, amount, result);
            return result;
        };
        /**
         * Set the passed "result" with the linearly interpolated values of "amount" between the left Color4 and the right Color4.
         */
        Color4.LerpToRef = function (left, right, amount, result) {
            result.r = left.r + (right.r - left.r) * amount;
            result.g = left.g + (right.g - left.g) * amount;
            result.b = left.b + (right.b - left.b) * amount;
            result.a = left.a + (right.a - left.a) * amount;
        };
        /**
         * Creates a new Color4 from the starting index element of the passed array.
         */
        Color4.FromArray = function (array, offset) {
            if (offset === void 0) { offset = 0; }
            return new Color4(array[offset], array[offset + 1], array[offset + 2], array[offset + 3]);
        };
        /**
         * Creates a new Color4 from the passed integers ( < 256 ).
         */
        Color4.FromInts = function (r, g, b, a) {
            return new Color4(r / 255.0, g / 255.0, b / 255.0, a / 255.0);
        };
        Color4.CheckColors4 = function (colors, count) {
            // Check if color3 was used
            if (colors.length === count * 3) {
                var colors4 = [];
                for (var index = 0; index < colors.length; index += 3) {
                    var newIndex = (index / 3) * 4;
                    colors4[newIndex] = colors[index];
                    colors4[newIndex + 1] = colors[index + 1];
                    colors4[newIndex + 2] = colors[index + 2];
                    colors4[newIndex + 3] = 1.0;
                }
                return colors4;
            }
            return colors;
        };
        return Color4;
    }());
    BABYLON.Color4 = Color4;
    var Vector2 = /** @class */ (function () {
        /**
         * Creates a new Vector2 from the passed x and y coordinates.
         */
        function Vector2(x, y) {
            this.x = x;
            this.y = y;
        }
        /**
         * Returns a string with the Vector2 coordinates.
         */
        Vector2.prototype.toString = function () {
            return "{X: " + this.x + " Y:" + this.y + "}";
        };
        /**
         * Returns the string "Vector2"
         */
        Vector2.prototype.getClassName = function () {
            return "Vector2";
        };
        /**
         * Returns the Vector2 hash code as a number.
         */
        Vector2.prototype.getHashCode = function () {
            var hash = this.x || 0;
            hash = (hash * 397) ^ (this.y || 0);
            return hash;
        };
        // Operators
        /**
         * Sets the Vector2 coordinates in the passed array or Float32Array from the passed index.
         * Returns the Vector2.
         */
        Vector2.prototype.toArray = function (array, index) {
            if (index === void 0) { index = 0; }
            array[index] = this.x;
            array[index + 1] = this.y;
            return this;
        };
        /**
         * Returns a new array with 2 elements : the Vector2 coordinates.
         */
        Vector2.prototype.asArray = function () {
            var result = new Array();
            this.toArray(result, 0);
            return result;
        };
        /**
         *  Sets the Vector2 coordinates with the passed Vector2 coordinates.
         * Returns the updated Vector2.
         */
        Vector2.prototype.copyFrom = function (source) {
            this.x = source.x;
            this.y = source.y;
            return this;
        };
        /**
         * Sets the Vector2 coordinates with the passed floats.
         * Returns the updated Vector2.
         */
        Vector2.prototype.copyFromFloats = function (x, y) {
            this.x = x;
            this.y = y;
            return this;
        };
        /**
         * Sets the Vector2 coordinates with the passed floats.
         * Returns the updated Vector2.
         */
        Vector2.prototype.set = function (x, y) {
            return this.copyFromFloats(x, y);
        };
        /**
         * Returns a new Vector2 set with the addition of the current Vector2 and the passed one coordinates.
         */
        Vector2.prototype.add = function (otherVector) {
            return new Vector2(this.x + otherVector.x, this.y + otherVector.y);
        };
        /**
         * Sets the "result" coordinates with the addition of the current Vector2 and the passed one coordinates.
         * Returns the Vector2.
         */
        Vector2.prototype.addToRef = function (otherVector, result) {
            result.x = this.x + otherVector.x;
            result.y = this.y + otherVector.y;
            return this;
        };
        /**
         * Set the Vector2 coordinates by adding the passed Vector2 coordinates.
         * Returns the updated Vector2.
         */
        Vector2.prototype.addInPlace = function (otherVector) {
            this.x += otherVector.x;
            this.y += otherVector.y;
            return this;
        };
        /**
         * Returns a new Vector2 by adding the current Vector2 coordinates to the passed Vector3 x, y coordinates.
         */
        Vector2.prototype.addVector3 = function (otherVector) {
            return new Vector2(this.x + otherVector.x, this.y + otherVector.y);
        };
        /**
         * Returns a new Vector2 set with the subtracted coordinates of the passed one from the current Vector2.
         */
        Vector2.prototype.subtract = function (otherVector) {
            return new Vector2(this.x - otherVector.x, this.y - otherVector.y);
        };
        /**
         * Sets the "result" coordinates with the subtraction of the passed one from the current Vector2 coordinates.
         * Returns the Vector2.
         */
        Vector2.prototype.subtractToRef = function (otherVector, result) {
            result.x = this.x - otherVector.x;
            result.y = this.y - otherVector.y;
            return this;
        };
        /**
         * Sets the current Vector2 coordinates by subtracting from it the passed one coordinates.
         * Returns the updated Vector2.
         */
        Vector2.prototype.subtractInPlace = function (otherVector) {
            this.x -= otherVector.x;
            this.y -= otherVector.y;
            return this;
        };
        /**
         * Multiplies in place the current Vector2 coordinates by the passed ones.
         * Returns the updated Vector2.
         */
        Vector2.prototype.multiplyInPlace = function (otherVector) {
            this.x *= otherVector.x;
            this.y *= otherVector.y;
            return this;
        };
        /**
         * Returns a new Vector2 set with the multiplication of the current Vector2 and the passed one coordinates.
         */
        Vector2.prototype.multiply = function (otherVector) {
            return new Vector2(this.x * otherVector.x, this.y * otherVector.y);
        };
        /**
         * Sets "result" coordinates with the multiplication of the current Vector2 and the passed one coordinates.
         * Returns the Vector2.
         */
        Vector2.prototype.multiplyToRef = function (otherVector, result) {
            result.x = this.x * otherVector.x;
            result.y = this.y * otherVector.y;
            return this;
        };
        /**
         * Returns a new Vector2 set with the Vector2 coordinates multiplied by the passed floats.
         */
        Vector2.prototype.multiplyByFloats = function (x, y) {
            return new Vector2(this.x * x, this.y * y);
        };
        /**
         * Returns a new Vector2 set with the Vector2 coordinates divided by the passed one coordinates.
         */
        Vector2.prototype.divide = function (otherVector) {
            return new Vector2(this.x / otherVector.x, this.y / otherVector.y);
        };
        /**
         * Sets the "result" coordinates with the Vector2 divided by the passed one coordinates.
         * Returns the Vector2.
         */
        Vector2.prototype.divideToRef = function (otherVector, result) {
            result.x = this.x / otherVector.x;
            result.y = this.y / otherVector.y;
            return this;
        };
        /**
         * Returns a new Vector2 with current Vector2 negated coordinates.
         */
        Vector2.prototype.negate = function () {
            return new Vector2(-this.x, -this.y);
        };
        /**
         * Multiply the Vector2 coordinates by scale.
         * Returns the updated Vector2.
         */
        Vector2.prototype.scaleInPlace = function (scale) {
            this.x *= scale;
            this.y *= scale;
            return this;
        };
        /**
         * Returns a new Vector2 scaled by "scale" from the current Vector2.
         */
        Vector2.prototype.scale = function (scale) {
            return new Vector2(this.x * scale, this.y * scale);
        };
        /**
         * Boolean : True if the passed vector coordinates strictly equal the current Vector2 ones.
         */
        Vector2.prototype.equals = function (otherVector) {
            return otherVector && this.x === otherVector.x && this.y === otherVector.y;
        };
        /**
         * Boolean : True if the passed vector coordinates are close to the current ones by a distance of epsilon.
         */
        Vector2.prototype.equalsWithEpsilon = function (otherVector, epsilon) {
            if (epsilon === void 0) { epsilon = BABYLON.Epsilon; }
            return otherVector && BABYLON.Scalar.WithinEpsilon(this.x, otherVector.x, epsilon) && BABYLON.Scalar.WithinEpsilon(this.y, otherVector.y, epsilon);
        };
        // Properties
        /**
         * Returns the vector length (float).
         */
        Vector2.prototype.length = function () {
            return Math.sqrt(this.x * this.x + this.y * this.y);
        };
        /**
         * Returns the vector squared length (float);
         */
        Vector2.prototype.lengthSquared = function () {
            return (this.x * this.x + this.y * this.y);
        };
        // Methods
        /**
         * Normalize the vector.
         * Returns the updated Vector2.
         */
        Vector2.prototype.normalize = function () {
            var len = this.length();
            if (len === 0)
                return this;
            var num = 1.0 / len;
            this.x *= num;
            this.y *= num;
            return this;
        };
        /**
         * Returns a new Vector2 copied from the Vector2.
         */
        Vector2.prototype.clone = function () {
            return new Vector2(this.x, this.y);
        };
        // Statics
        /**
         * Returns a new Vector2(0, 0)
         */
        Vector2.Zero = function () {
            return new Vector2(0, 0);
        };
        /**
         * Returns a new Vector2(1, 1)
         */
        Vector2.One = function () {
            return new Vector2(1, 1);
        };
        /**
         * Returns a new Vector2 set from the passed index element of the passed array.
         */
        Vector2.FromArray = function (array, offset) {
            if (offset === void 0) { offset = 0; }
            return new Vector2(array[offset], array[offset + 1]);
        };
        /**
         * Sets "result" from the passed index element of the passed array.
         */
        Vector2.FromArrayToRef = function (array, offset, result) {
            result.x = array[offset];
            result.y = array[offset + 1];
        };
        /**
         * Retuns a new Vector2 located for "amount" (float) on the CatmullRom  spline defined by the passed four Vector2.
         */
        Vector2.CatmullRom = function (value1, value2, value3, value4, amount) {
            var squared = amount * amount;
            var cubed = amount * squared;
            var x = 0.5 * ((((2.0 * value2.x) + ((-value1.x + value3.x) * amount)) +
                (((((2.0 * value1.x) - (5.0 * value2.x)) + (4.0 * value3.x)) - value4.x) * squared)) +
                ((((-value1.x + (3.0 * value2.x)) - (3.0 * value3.x)) + value4.x) * cubed));
            var y = 0.5 * ((((2.0 * value2.y) + ((-value1.y + value3.y) * amount)) +
                (((((2.0 * value1.y) - (5.0 * value2.y)) + (4.0 * value3.y)) - value4.y) * squared)) +
                ((((-value1.y + (3.0 * value2.y)) - (3.0 * value3.y)) + value4.y) * cubed));
            return new Vector2(x, y);
        };
        /**
         * Returns a new Vector2 set with same the coordinates than "value" ones if the vector "value" is in the square defined by "min" and "max".
         * If a coordinate of "value" is lower than "min" coordinates, the returned Vector2 is given this "min" coordinate.
         * If a coordinate of "value" is greater than "max" coordinates, the returned Vector2 is given this "max" coordinate.
         */
        Vector2.Clamp = function (value, min, max) {
            var x = value.x;
            x = (x > max.x) ? max.x : x;
            x = (x < min.x) ? min.x : x;
            var y = value.y;
            y = (y > max.y) ? max.y : y;
            y = (y < min.y) ? min.y : y;
            return new Vector2(x, y);
        };
        /**
         * Returns a new Vector2 located for "amount" (float) on the Hermite spline defined by the vectors "value1", "value3", "tangent1", "tangent2".
         */
        Vector2.Hermite = function (value1, tangent1, value2, tangent2, amount) {
            var squared = amount * amount;
            var cubed = amount * squared;
            var part1 = ((2.0 * cubed) - (3.0 * squared)) + 1.0;
            var part2 = (-2.0 * cubed) + (3.0 * squared);
            var part3 = (cubed - (2.0 * squared)) + amount;
            var part4 = cubed - squared;
            var x = (((value1.x * part1) + (value2.x * part2)) + (tangent1.x * part3)) + (tangent2.x * part4);
            var y = (((value1.y * part1) + (value2.y * part2)) + (tangent1.y * part3)) + (tangent2.y * part4);
            return new Vector2(x, y);
        };
        /**
         * Returns a new Vector2 located for "amount" (float) on the linear interpolation between the vector "start" adn the vector "end".
         */
        Vector2.Lerp = function (start, end, amount) {
            var x = start.x + ((end.x - start.x) * amount);
            var y = start.y + ((end.y - start.y) * amount);
            return new Vector2(x, y);
        };
        /**
         * Returns the dot product (float) of the vector "left" and the vector "right".
         */
        Vector2.Dot = function (left, right) {
            return left.x * right.x + left.y * right.y;
        };
        /**
         * Returns a new Vector2 equal to the normalized passed vector.
         */
        Vector2.Normalize = function (vector) {
            var newVector = vector.clone();
            newVector.normalize();
            return newVector;
        };
        /**
         * Returns a new Vecto2 set with the minimal coordinate values from the "left" and "right" vectors.
         */
        Vector2.Minimize = function (left, right) {
            var x = (left.x < right.x) ? left.x : right.x;
            var y = (left.y < right.y) ? left.y : right.y;
            return new Vector2(x, y);
        };
        /**
         * Returns a new Vecto2 set with the maximal coordinate values from the "left" and "right" vectors.
         */
        Vector2.Maximize = function (left, right) {
            var x = (left.x > right.x) ? left.x : right.x;
            var y = (left.y > right.y) ? left.y : right.y;
            return new Vector2(x, y);
        };
        /**
         * Returns a new Vecto2 set with the transformed coordinates of the passed vector by the passed transformation matrix.
         */
        Vector2.Transform = function (vector, transformation) {
            var r = Vector2.Zero();
            Vector2.TransformToRef(vector, transformation, r);
            return r;
        };
        /**
         * Transforms the passed vector coordinates by the passed transformation matrix and stores the result in the vector "result" coordinates.
         */
        Vector2.TransformToRef = function (vector, transformation, result) {
            var x = (vector.x * transformation.m[0]) + (vector.y * transformation.m[4]) + transformation.m[12];
            var y = (vector.x * transformation.m[1]) + (vector.y * transformation.m[5]) + transformation.m[13];
            result.x = x;
            result.y = y;
        };
        /**
         * Boolean : True if the point "p" is in the triangle defined by the vertors "p0", "p1", "p2"
         */
        Vector2.PointInTriangle = function (p, p0, p1, p2) {
            var a = 1 / 2 * (-p1.y * p2.x + p0.y * (-p1.x + p2.x) + p0.x * (p1.y - p2.y) + p1.x * p2.y);
            var sign = a < 0 ? -1 : 1;
            var s = (p0.y * p2.x - p0.x * p2.y + (p2.y - p0.y) * p.x + (p0.x - p2.x) * p.y) * sign;
            var t = (p0.x * p1.y - p0.y * p1.x + (p0.y - p1.y) * p.x + (p1.x - p0.x) * p.y) * sign;
            return s > 0 && t > 0 && (s + t) < 2 * a * sign;
        };
        /**
         * Returns the distance (float) between the vectors "value1" and "value2".
         */
        Vector2.Distance = function (value1, value2) {
            return Math.sqrt(Vector2.DistanceSquared(value1, value2));
        };
        /**
         * Returns the squared distance (float) between the vectors "value1" and "value2".
         */
        Vector2.DistanceSquared = function (value1, value2) {
            var x = value1.x - value2.x;
            var y = value1.y - value2.y;
            return (x * x) + (y * y);
        };
        /**
         * Returns a new Vecto2 located at the center of the vectors "value1" and "value2".
         */
        Vector2.Center = function (value1, value2) {
            var center = value1.add(value2);
            center.scaleInPlace(0.5);
            return center;
        };
        /**
         * Returns the shortest distance (float) between the point "p" and the segment defined by the two points "segA" and "segB".
         */
        Vector2.DistanceOfPointFromSegment = function (p, segA, segB) {
            var l2 = Vector2.DistanceSquared(segA, segB);
            if (l2 === 0.0) {
                return Vector2.Distance(p, segA);
            }
            var v = segB.subtract(segA);
            var t = Math.max(0, Math.min(1, Vector2.Dot(p.subtract(segA), v) / l2));
            var proj = segA.add(v.multiplyByFloats(t, t));
            return Vector2.Distance(p, proj);
        };
        return Vector2;
    }());
    BABYLON.Vector2 = Vector2;
    var Vector3 = /** @class */ (function () {
        /**
         * Creates a new Vector3 object from the passed x, y, z (floats) coordinates.
         * A Vector3 is the main object used in 3D geometry.
         * It can represent etiher the coordinates of a point the space, either a direction.
         */
        function Vector3(x, y, z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
        /**
         * Returns a string with the Vector3 coordinates.
         */
        Vector3.prototype.toString = function () {
            return "{X: " + this.x + " Y:" + this.y + " Z:" + this.z + "}";
        };
        /**
         * Returns the string "Vector3"
         */
        Vector3.prototype.getClassName = function () {
            return "Vector3";
        };
        /**
         * Returns the Vector hash code.
         */
        Vector3.prototype.getHashCode = function () {
            var hash = this.x || 0;
            hash = (hash * 397) ^ (this.y || 0);
            hash = (hash * 397) ^ (this.z || 0);
            return hash;
        };
        // Operators
        /**
         * Returns a new array with three elements : the coordinates the Vector3.
         */
        Vector3.prototype.asArray = function () {
            var result = [];
            this.toArray(result, 0);
            return result;
        };
        /**
         * Populates the passed array or Float32Array from the passed index with the successive coordinates of the Vector3.
         * Returns the Vector3.
         */
        Vector3.prototype.toArray = function (array, index) {
            if (index === void 0) { index = 0; }
            array[index] = this.x;
            array[index + 1] = this.y;
            array[index + 2] = this.z;
            return this;
        };
        /**
         * Returns a new Quaternion object, computed from the Vector3 coordinates.
         */
        Vector3.prototype.toQuaternion = function () {
            var result = new Quaternion(0.0, 0.0, 0.0, 1.0);
            var cosxPlusz = Math.cos((this.x + this.z) * 0.5);
            var sinxPlusz = Math.sin((this.x + this.z) * 0.5);
            var coszMinusx = Math.cos((this.z - this.x) * 0.5);
            var sinzMinusx = Math.sin((this.z - this.x) * 0.5);
            var cosy = Math.cos(this.y * 0.5);
            var siny = Math.sin(this.y * 0.5);
            result.x = coszMinusx * siny;
            result.y = -sinzMinusx * siny;
            result.z = sinxPlusz * cosy;
            result.w = cosxPlusz * cosy;
            return result;
        };
        /**
         * Adds the passed vector to the current Vector3.
         * Returns the updated Vector3.
         */
        Vector3.prototype.addInPlace = function (otherVector) {
            this.x += otherVector.x;
            this.y += otherVector.y;
            this.z += otherVector.z;
            return this;
        };
        /**
         * Returns a new Vector3, result of the addition the current Vector3 and the passed vector.
         */
        Vector3.prototype.add = function (otherVector) {
            return new Vector3(this.x + otherVector.x, this.y + otherVector.y, this.z + otherVector.z);
        };
        /**
         * Adds the current Vector3 to the passed one and stores the result in the vector "result".
         * Returns the current Vector3.
         */
        Vector3.prototype.addToRef = function (otherVector, result) {
            result.x = this.x + otherVector.x;
            result.y = this.y + otherVector.y;
            result.z = this.z + otherVector.z;
            return this;
        };
        /**
         * Subtract the passed vector from the current Vector3.
         * Returns the updated Vector3.
         */
        Vector3.prototype.subtractInPlace = function (otherVector) {
            this.x -= otherVector.x;
            this.y -= otherVector.y;
            this.z -= otherVector.z;
            return this;
        };
        /**
         * Returns a new Vector3, result of the subtraction of the passed vector from the current Vector3.
         */
        Vector3.prototype.subtract = function (otherVector) {
            return new Vector3(this.x - otherVector.x, this.y - otherVector.y, this.z - otherVector.z);
        };
        /**
         * Subtracts the passed vector from the current Vector3 and stores the result in the vector "result".
         * Returns the current Vector3.
         */
        Vector3.prototype.subtractToRef = function (otherVector, result) {
            result.x = this.x - otherVector.x;
            result.y = this.y - otherVector.y;
            result.z = this.z - otherVector.z;
            return this;
        };
        /**
         * Returns a new Vector3 set with the subtraction of the passed floats from the current Vector3 coordinates.
         */
        Vector3.prototype.subtractFromFloats = function (x, y, z) {
            return new Vector3(this.x - x, this.y - y, this.z - z);
        };
        /**
         * Subtracts the passed floats from the current Vector3 coordinates and set the passed vector "result" with this result.
         * Returns the current Vector3.
         */
        Vector3.prototype.subtractFromFloatsToRef = function (x, y, z, result) {
            result.x = this.x - x;
            result.y = this.y - y;
            result.z = this.z - z;
            return this;
        };
        /**
         * Returns a new Vector3 set with the current Vector3 negated coordinates.
         */
        Vector3.prototype.negate = function () {
            return new Vector3(-this.x, -this.y, -this.z);
        };
        /**
         * Multiplies the Vector3 coordinates by the float "scale".
         * Returns the updated Vector3.
         */
        Vector3.prototype.scaleInPlace = function (scale) {
            this.x *= scale;
            this.y *= scale;
            this.z *= scale;
            return this;
        };
        /**
         * Returns a new Vector3 set with the current Vector3 coordinates multiplied by the float "scale".
         */
        Vector3.prototype.scale = function (scale) {
            return new Vector3(this.x * scale, this.y * scale, this.z * scale);
        };
        /**
         * Multiplies the current Vector3 coordinates by the float "scale" and stores the result in the passed vector "result" coordinates.
         * Returns the current Vector3.
         */
        Vector3.prototype.scaleToRef = function (scale, result) {
            result.x = this.x * scale;
            result.y = this.y * scale;
            result.z = this.z * scale;
            return this;
        };
        /**
         * Boolean : True if the current Vector3 and the passed vector coordinates are strictly equal.
         */
        Vector3.prototype.equals = function (otherVector) {
            return otherVector && this.x === otherVector.x && this.y === otherVector.y && this.z === otherVector.z;
        };
        /**
         * Boolean : True if the current Vector3 and the passed vector coordinates are distant less than epsilon.
         */
        Vector3.prototype.equalsWithEpsilon = function (otherVector, epsilon) {
            if (epsilon === void 0) { epsilon = BABYLON.Epsilon; }
            return otherVector && BABYLON.Scalar.WithinEpsilon(this.x, otherVector.x, epsilon) && BABYLON.Scalar.WithinEpsilon(this.y, otherVector.y, epsilon) && BABYLON.Scalar.WithinEpsilon(this.z, otherVector.z, epsilon);
        };
        /**
         * Boolean : True if the current Vector3 coordinate equal the passed floats.
         */
        Vector3.prototype.equalsToFloats = function (x, y, z) {
            return this.x === x && this.y === y && this.z === z;
        };
        /**
         * Muliplies the current Vector3 coordinates by the passed ones.
         * Returns the updated Vector3.
         */
        Vector3.prototype.multiplyInPlace = function (otherVector) {
            this.x *= otherVector.x;
            this.y *= otherVector.y;
            this.z *= otherVector.z;
            return this;
        };
        /**
         * Returns a new Vector3, result of the multiplication of the current Vector3 by the passed vector.
         */
        Vector3.prototype.multiply = function (otherVector) {
            return new Vector3(this.x * otherVector.x, this.y * otherVector.y, this.z * otherVector.z);
        };
        /**
         * Multiplies the current Vector3 by the passed one and stores the result in the passed vector "result".
         * Returns the current Vector3.
         */
        Vector3.prototype.multiplyToRef = function (otherVector, result) {
            result.x = this.x * otherVector.x;
            result.y = this.y * otherVector.y;
            result.z = this.z * otherVector.z;
            return this;
        };
        /**
         * Returns a new Vector3 set witth the result of the mulliplication of the current Vector3 coordinates by the passed floats.
         */
        Vector3.prototype.multiplyByFloats = function (x, y, z) {
            return new Vector3(this.x * x, this.y * y, this.z * z);
        };
        /**
         * Returns a new Vector3 set witth the result of the division of the current Vector3 coordinates by the passed ones.
         */
        Vector3.prototype.divide = function (otherVector) {
            return new Vector3(this.x / otherVector.x, this.y / otherVector.y, this.z / otherVector.z);
        };
        /**
         * Divides the current Vector3 coordinates by the passed ones and stores the result in the passed vector "result".
         * Returns the current Vector3.
         */
        Vector3.prototype.divideToRef = function (otherVector, result) {
            result.x = this.x / otherVector.x;
            result.y = this.y / otherVector.y;
            result.z = this.z / otherVector.z;
            return this;
        };
        /**
         * Updates the current Vector3 with the minimal coordinate values between its and the passed vector ones.
         * Returns the updated Vector3.
         */
        Vector3.prototype.MinimizeInPlace = function (other) {
            if (other.x < this.x)
                this.x = other.x;
            if (other.y < this.y)
                this.y = other.y;
            if (other.z < this.z)
                this.z = other.z;
            return this;
        };
        /**
         * Updates the current Vector3 with the maximal coordinate values between its and the passed vector ones.
         * Returns the updated Vector3.
         */
        Vector3.prototype.MaximizeInPlace = function (other) {
            if (other.x > this.x)
                this.x = other.x;
            if (other.y > this.y)
                this.y = other.y;
            if (other.z > this.z)
                this.z = other.z;
            return this;
        };
        Object.defineProperty(Vector3.prototype, "isNonUniform", {
            /**
             * Return true is the vector is non uniform meaning x, y or z are not all the same.
             */
            get: function () {
                var absX = Math.abs(this.x);
                var absY = Math.abs(this.y);
                if (absX !== absY) {
                    return true;
                }
                var absZ = Math.abs(this.z);
                if (absX !== absZ) {
                    return true;
                }
                if (absY !== absZ) {
                    return true;
                }
                return false;
            },
            enumerable: true,
            configurable: true
        });
        // Properties
        /**
         * Returns the length of the Vector3 (float).
         */
        Vector3.prototype.length = function () {
            return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        };
        /**
         * Returns the squared length of the Vector3 (float).
         */
        Vector3.prototype.lengthSquared = function () {
            return (this.x * this.x + this.y * this.y + this.z * this.z);
        };
        /**
         * Normalize the current Vector3.
         * Returns the updated Vector3.
         * /!\ In place operation.
         */
        Vector3.prototype.normalize = function () {
            var len = this.length();
            if (len === 0 || len === 1.0)
                return this;
            var num = 1.0 / len;
            this.x *= num;
            this.y *= num;
            this.z *= num;
            return this;
        };
        /**
         * Normalize the current Vector3 to a new vector.
         * @returns the new Vector3.
         */
        Vector3.prototype.normalizeToNew = function () {
            var normalized = new Vector3(0, 0, 0);
            this.normalizeToRef(normalized);
            return normalized;
        };
        /**
         * Normalize the current Vector3 to the reference.
         * @param the reference to update.
         * @returns the updated Vector3.
         */
        Vector3.prototype.normalizeToRef = function (reference) {
            var len = this.length();
            if (len === 0 || len === 1.0) {
                reference.set(this.x, this.y, this.z);
                return reference;
            }
            var scale = 1.0 / len;
            this.scaleToRef(scale, reference);
            return reference;
        };
        /**
         * Returns a new Vector3 copied from the current Vector3.
         */
        Vector3.prototype.clone = function () {
            return new Vector3(this.x, this.y, this.z);
        };
        /**
         * Copies the passed vector coordinates to the current Vector3 ones.
         * Returns the updated Vector3.
         */
        Vector3.prototype.copyFrom = function (source) {
            this.x = source.x;
            this.y = source.y;
            this.z = source.z;
            return this;
        };
        /**
         * Copies the passed floats to the current Vector3 coordinates.
         * Returns the updated Vector3.
         */
        Vector3.prototype.copyFromFloats = function (x, y, z) {
            this.x = x;
            this.y = y;
            this.z = z;
            return this;
        };
        /**
         * Copies the passed floats to the current Vector3 coordinates.
         * Returns the updated Vector3.
         */
        Vector3.prototype.set = function (x, y, z) {
            return this.copyFromFloats(x, y, z);
        };
        // Statics
        /**
         *
         */
        Vector3.GetClipFactor = function (vector0, vector1, axis, size) {
            var d0 = Vector3.Dot(vector0, axis) - size;
            var d1 = Vector3.Dot(vector1, axis) - size;
            var s = d0 / (d0 - d1);
            return s;
        };
        /**
         * Returns a new Vector3 set from the index "offset" of the passed array.
         */
        Vector3.FromArray = function (array, offset) {
            if (!offset) {
                offset = 0;
            }
            return new Vector3(array[offset], array[offset + 1], array[offset + 2]);
        };
        /**
         * Returns a new Vector3 set from the index "offset" of the passed Float32Array.
         * This function is deprecated.  Use FromArray instead.
         */
        Vector3.FromFloatArray = function (array, offset) {
            return Vector3.FromArray(array, offset);
        };
        /**
         * Sets the passed vector "result" with the element values from the index "offset" of the passed array.
         */
        Vector3.FromArrayToRef = function (array, offset, result) {
            result.x = array[offset];
            result.y = array[offset + 1];
            result.z = array[offset + 2];
        };
        /**
         * Sets the passed vector "result" with the element values from the index "offset" of the passed Float32Array.
         * This function is deprecated.  Use FromArrayToRef instead.
         */
        Vector3.FromFloatArrayToRef = function (array, offset, result) {
            return Vector3.FromArrayToRef(array, offset, result);
        };
        /**
         * Sets the passed vector "result" with the passed floats.
         */
        Vector3.FromFloatsToRef = function (x, y, z, result) {
            result.x = x;
            result.y = y;
            result.z = z;
        };
        /**
         * Returns a new Vector3 set to (0.0, 0.0, 0.0).
         */
        Vector3.Zero = function () {
            return new Vector3(0.0, 0.0, 0.0);
        };
        /**
         * Returns a new Vector3 set to (1.0, 1.0, 1.0).
         */
        Vector3.One = function () {
            return new Vector3(1.0, 1.0, 1.0);
        };
        /**
         * Returns a new Vector3 set to (0.0, 1.0, 0.0)
         */
        Vector3.Up = function () {
            return new Vector3(0.0, 1.0, 0.0);
        };
        /**
         * Returns a new Vector3 set to (0.0, 0.0, 1.0)
         */
        Vector3.Forward = function () {
            return new Vector3(0.0, 0.0, 1.0);
        };
        /**
         * Returns a new Vector3 set to (1.0, 0.0, 0.0)
         */
        Vector3.Right = function () {
            return new Vector3(1.0, 0.0, 0.0);
        };
        /**
         * Returns a new Vector3 set to (-1.0, 0.0, 0.0)
         */
        Vector3.Left = function () {
            return new Vector3(-1.0, 0.0, 0.0);
        };
        /**
         * Returns a new Vector3 set with the result of the transformation by the passed matrix of the passed vector.
         * This method computes tranformed coordinates only, not transformed direction vectors.
         */
        Vector3.TransformCoordinates = function (vector, transformation) {
            var result = Vector3.Zero();
            Vector3.TransformCoordinatesToRef(vector, transformation, result);
            return result;
        };
        /**
         * Sets the passed vector "result" coordinates with the result of the transformation by the passed matrix of the passed vector.
         * This method computes tranformed coordinates only, not transformed direction vectors.
         */
        Vector3.TransformCoordinatesToRef = function (vector, transformation, result) {
            var x = (vector.x * transformation.m[0]) + (vector.y * transformation.m[4]) + (vector.z * transformation.m[8]) + transformation.m[12];
            var y = (vector.x * transformation.m[1]) + (vector.y * transformation.m[5]) + (vector.z * transformation.m[9]) + transformation.m[13];
            var z = (vector.x * transformation.m[2]) + (vector.y * transformation.m[6]) + (vector.z * transformation.m[10]) + transformation.m[14];
            var w = (vector.x * transformation.m[3]) + (vector.y * transformation.m[7]) + (vector.z * transformation.m[11]) + transformation.m[15];
            result.x = x / w;
            result.y = y / w;
            result.z = z / w;
        };
        /**
         * Sets the passed vector "result" coordinates with the result of the transformation by the passed matrix of the passed floats (x, y, z).
         * This method computes tranformed coordinates only, not transformed direction vectors.
         */
        Vector3.TransformCoordinatesFromFloatsToRef = function (x, y, z, transformation, result) {
            var rx = (x * transformation.m[0]) + (y * transformation.m[4]) + (z * transformation.m[8]) + transformation.m[12];
            var ry = (x * transformation.m[1]) + (y * transformation.m[5]) + (z * transformation.m[9]) + transformation.m[13];
            var rz = (x * transformation.m[2]) + (y * transformation.m[6]) + (z * transformation.m[10]) + transformation.m[14];
            var rw = (x * transformation.m[3]) + (y * transformation.m[7]) + (z * transformation.m[11]) + transformation.m[15];
            result.x = rx / rw;
            result.y = ry / rw;
            result.z = rz / rw;
        };
        /**
         * Returns a new Vector3 set with the result of the normal transformation by the passed matrix of the passed vector.
         * This methods computes transformed normalized direction vectors only.
         */
        Vector3.TransformNormal = function (vector, transformation) {
            var result = Vector3.Zero();
            Vector3.TransformNormalToRef(vector, transformation, result);
            return result;
        };
        /**
         * Sets the passed vector "result" with the result of the normal transformation by the passed matrix of the passed vector.
         * This methods computes transformed normalized direction vectors only.
         */
        Vector3.TransformNormalToRef = function (vector, transformation, result) {
            var x = (vector.x * transformation.m[0]) + (vector.y * transformation.m[4]) + (vector.z * transformation.m[8]);
            var y = (vector.x * transformation.m[1]) + (vector.y * transformation.m[5]) + (vector.z * transformation.m[9]);
            var z = (vector.x * transformation.m[2]) + (vector.y * transformation.m[6]) + (vector.z * transformation.m[10]);
            result.x = x;
            result.y = y;
            result.z = z;
        };
        /**
         * Sets the passed vector "result" with the result of the normal transformation by the passed matrix of the passed floats (x, y, z).
         * This methods computes transformed normalized direction vectors only.
         */
        Vector3.TransformNormalFromFloatsToRef = function (x, y, z, transformation, result) {
            result.x = (x * transformation.m[0]) + (y * transformation.m[4]) + (z * transformation.m[8]);
            result.y = (x * transformation.m[1]) + (y * transformation.m[5]) + (z * transformation.m[9]);
            result.z = (x * transformation.m[2]) + (y * transformation.m[6]) + (z * transformation.m[10]);
        };
        /**
         * Returns a new Vector3 located for "amount" on the CatmullRom interpolation spline defined by the vectors "value1", "value2", "value3", "value4".
         */
        Vector3.CatmullRom = function (value1, value2, value3, value4, amount) {
            var squared = amount * amount;
            var cubed = amount * squared;
            var x = 0.5 * ((((2.0 * value2.x) + ((-value1.x + value3.x) * amount)) +
                (((((2.0 * value1.x) - (5.0 * value2.x)) + (4.0 * value3.x)) - value4.x) * squared)) +
                ((((-value1.x + (3.0 * value2.x)) - (3.0 * value3.x)) + value4.x) * cubed));
            var y = 0.5 * ((((2.0 * value2.y) + ((-value1.y + value3.y) * amount)) +
                (((((2.0 * value1.y) - (5.0 * value2.y)) + (4.0 * value3.y)) - value4.y) * squared)) +
                ((((-value1.y + (3.0 * value2.y)) - (3.0 * value3.y)) + value4.y) * cubed));
            var z = 0.5 * ((((2.0 * value2.z) + ((-value1.z + value3.z) * amount)) +
                (((((2.0 * value1.z) - (5.0 * value2.z)) + (4.0 * value3.z)) - value4.z) * squared)) +
                ((((-value1.z + (3.0 * value2.z)) - (3.0 * value3.z)) + value4.z) * cubed));
            return new Vector3(x, y, z);
        };
        /**
         * Returns a new Vector3 set with the coordinates of "value", if the vector "value" is in the cube defined by the vectors "min" and "max".
         * If a coordinate value of "value" is lower than one of the "min" coordinate, then this "value" coordinate is set with the "min" one.
         * If a coordinate value of "value" is greater than one of the "max" coordinate, then this "value" coordinate is set with the "max" one.
         */
        Vector3.Clamp = function (value, min, max) {
            var x = value.x;
            x = (x > max.x) ? max.x : x;
            x = (x < min.x) ? min.x : x;
            var y = value.y;
            y = (y > max.y) ? max.y : y;
            y = (y < min.y) ? min.y : y;
            var z = value.z;
            z = (z > max.z) ? max.z : z;
            z = (z < min.z) ? min.z : z;
            return new Vector3(x, y, z);
        };
        /**
         * Returns a new Vector3 located for "amount" (float) on the Hermite interpolation spline defined by the vectors "value1", "tangent1", "value2", "tangent2".
         */
        Vector3.Hermite = function (value1, tangent1, value2, tangent2, amount) {
            var squared = amount * amount;
            var cubed = amount * squared;
            var part1 = ((2.0 * cubed) - (3.0 * squared)) + 1.0;
            var part2 = (-2.0 * cubed) + (3.0 * squared);
            var part3 = (cubed - (2.0 * squared)) + amount;
            var part4 = cubed - squared;
            var x = (((value1.x * part1) + (value2.x * part2)) + (tangent1.x * part3)) + (tangent2.x * part4);
            var y = (((value1.y * part1) + (value2.y * part2)) + (tangent1.y * part3)) + (tangent2.y * part4);
            var z = (((value1.z * part1) + (value2.z * part2)) + (tangent1.z * part3)) + (tangent2.z * part4);
            return new Vector3(x, y, z);
        };
        /**
         * Returns a new Vector3 located for "amount" (float) on the linear interpolation between the vectors "start" and "end".
         */
        Vector3.Lerp = function (start, end, amount) {
            var result = new Vector3(0, 0, 0);
            Vector3.LerpToRef(start, end, amount, result);
            return result;
        };
        /**
         * Sets the passed vector "result" with the result of the linear interpolation from the vector "start" for "amount" to the vector "end".
         */
        Vector3.LerpToRef = function (start, end, amount, result) {
            result.x = start.x + ((end.x - start.x) * amount);
            result.y = start.y + ((end.y - start.y) * amount);
            result.z = start.z + ((end.z - start.z) * amount);
        };
        /**
         * Returns the dot product (float) between the vectors "left" and "right".
         */
        Vector3.Dot = function (left, right) {
            return (left.x * right.x + left.y * right.y + left.z * right.z);
        };
        /**
         * Returns a new Vector3 as the cross product of the vectors "left" and "right".
         * The cross product is then orthogonal to both "left" and "right".
         */
        Vector3.Cross = function (left, right) {
            var result = Vector3.Zero();
            Vector3.CrossToRef(left, right, result);
            return result;
        };
        /**
         * Sets the passed vector "result" with the cross product of "left" and "right".
         * The cross product is then orthogonal to both "left" and "right".
         */
        Vector3.CrossToRef = function (left, right, result) {
            MathTmp.Vector3[0].x = left.y * right.z - left.z * right.y;
            MathTmp.Vector3[0].y = left.z * right.x - left.x * right.z;
            MathTmp.Vector3[0].z = left.x * right.y - left.y * right.x;
            result.copyFrom(MathTmp.Vector3[0]);
        };
        /**
         * Returns a new Vector3 as the normalization of the passed vector.
         */
        Vector3.Normalize = function (vector) {
            var result = Vector3.Zero();
            Vector3.NormalizeToRef(vector, result);
            return result;
        };
        /**
         * Sets the passed vector "result" with the normalization of the passed first vector.
         */
        Vector3.NormalizeToRef = function (vector, result) {
            result.copyFrom(vector);
            result.normalize();
        };
        Vector3.Project = function (vector, world, transform, viewport) {
            var cw = viewport.width;
            var ch = viewport.height;
            var cx = viewport.x;
            var cy = viewport.y;
            var viewportMatrix = Vector3._viewportMatrixCache ? Vector3._viewportMatrixCache : (Vector3._viewportMatrixCache = new Matrix());
            Matrix.FromValuesToRef(cw / 2.0, 0, 0, 0, 0, -ch / 2.0, 0, 0, 0, 0, 0.5, 0, cx + cw / 2.0, ch / 2.0 + cy, 0.5, 1, viewportMatrix);
            var matrix = MathTmp.Matrix[0];
            world.multiplyToRef(transform, matrix);
            matrix.multiplyToRef(viewportMatrix, matrix);
            return Vector3.TransformCoordinates(vector, matrix);
        };
        Vector3.UnprojectFromTransform = function (source, viewportWidth, viewportHeight, world, transform) {
            var matrix = MathTmp.Matrix[0];
            world.multiplyToRef(transform, matrix);
            matrix.invert();
            source.x = source.x / viewportWidth * 2 - 1;
            source.y = -(source.y / viewportHeight * 2 - 1);
            var vector = Vector3.TransformCoordinates(source, matrix);
            var num = source.x * matrix.m[3] + source.y * matrix.m[7] + source.z * matrix.m[11] + matrix.m[15];
            if (BABYLON.Scalar.WithinEpsilon(num, 1.0)) {
                vector = vector.scale(1.0 / num);
            }
            return vector;
        };
        Vector3.Unproject = function (source, viewportWidth, viewportHeight, world, view, projection) {
            var result = Vector3.Zero();
            Vector3.UnprojectToRef(source, viewportWidth, viewportHeight, world, view, projection, result);
            return result;
        };
        Vector3.UnprojectToRef = function (source, viewportWidth, viewportHeight, world, view, projection, result) {
            Vector3.UnprojectFloatsToRef(source.x, source.y, source.z, viewportWidth, viewportHeight, world, view, projection, result);
        };
        Vector3.UnprojectFloatsToRef = function (sourceX, sourceY, sourceZ, viewportWidth, viewportHeight, world, view, projection, result) {
            var matrix = MathTmp.Matrix[0];
            world.multiplyToRef(view, matrix);
            matrix.multiplyToRef(projection, matrix);
            matrix.invert();
            var screenSource = MathTmp.Vector3[0];
            screenSource.x = sourceX / viewportWidth * 2 - 1;
            screenSource.y = -(sourceY / viewportHeight * 2 - 1);
            screenSource.z = 2 * sourceZ - 1.0;
            Vector3.TransformCoordinatesToRef(screenSource, matrix, result);
            var num = screenSource.x * matrix.m[3] + screenSource.y * matrix.m[7] + screenSource.z * matrix.m[11] + matrix.m[15];
            if (BABYLON.Scalar.WithinEpsilon(num, 1.0)) {
                result.scaleInPlace(1.0 / num);
            }
        };
        Vector3.Minimize = function (left, right) {
            var min = left.clone();
            min.MinimizeInPlace(right);
            return min;
        };
        Vector3.Maximize = function (left, right) {
            var max = left.clone();
            max.MaximizeInPlace(right);
            return max;
        };
        /**
         * Returns the distance (float) between the vectors "value1" and "value2".
         */
        Vector3.Distance = function (value1, value2) {
            return Math.sqrt(Vector3.DistanceSquared(value1, value2));
        };
        /**
         * Returns the squared distance (float) between the vectors "value1" and "value2".
         */
        Vector3.DistanceSquared = function (value1, value2) {
            var x = value1.x - value2.x;
            var y = value1.y - value2.y;
            var z = value1.z - value2.z;
            return (x * x) + (y * y) + (z * z);
        };
        /**
         * Returns a new Vector3 located at the center between "value1" and "value2".
         */
        Vector3.Center = function (value1, value2) {
            var center = value1.add(value2);
            center.scaleInPlace(0.5);
            return center;
        };
        /**
         * Given three orthogonal normalized left-handed oriented Vector3 axis in space (target system),
         * RotationFromAxis() returns the rotation Euler angles (ex : rotation.x, rotation.y, rotation.z) to apply
         * to something in order to rotate it from its local system to the given target system.
         * Note : axis1, axis2 and axis3 are normalized during this operation.
         * Returns a new Vector3.
         */
        Vector3.RotationFromAxis = function (axis1, axis2, axis3) {
            var rotation = Vector3.Zero();
            Vector3.RotationFromAxisToRef(axis1, axis2, axis3, rotation);
            return rotation;
        };
        /**
         * The same than RotationFromAxis but updates the passed ref Vector3 parameter instead of returning a new Vector3.
         */
        Vector3.RotationFromAxisToRef = function (axis1, axis2, axis3, ref) {
            var quat = MathTmp.Quaternion[0];
            Quaternion.RotationQuaternionFromAxisToRef(axis1, axis2, axis3, quat);
            quat.toEulerAnglesToRef(ref);
        };
        return Vector3;
    }());
    BABYLON.Vector3 = Vector3;
    //Vector4 class created for EulerAngle class conversion to Quaternion
    var Vector4 = /** @class */ (function () {
        /**
         * Creates a Vector4 object from the passed floats.
         */
        function Vector4(x, y, z, w) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.w = w;
        }
        /**
         * Returns the string with the Vector4 coordinates.
         */
        Vector4.prototype.toString = function () {
            return "{X: " + this.x + " Y:" + this.y + " Z:" + this.z + " W:" + this.w + "}";
        };
        /**
         * Returns the string "Vector4".
         */
        Vector4.prototype.getClassName = function () {
            return "Vector4";
        };
        /**
         * Returns the Vector4 hash code.
         */
        Vector4.prototype.getHashCode = function () {
            var hash = this.x || 0;
            hash = (hash * 397) ^ (this.y || 0);
            hash = (hash * 397) ^ (this.z || 0);
            hash = (hash * 397) ^ (this.w || 0);
            return hash;
        };
        // Operators
        /**
         * Returns a new array populated with 4 elements : the Vector4 coordinates.
         */
        Vector4.prototype.asArray = function () {
            var result = new Array();
            this.toArray(result, 0);
            return result;
        };
        /**
         * Populates the passed array from the passed index with the Vector4 coordinates.
         * Returns the Vector4.
         */
        Vector4.prototype.toArray = function (array, index) {
            if (index === undefined) {
                index = 0;
            }
            array[index] = this.x;
            array[index + 1] = this.y;
            array[index + 2] = this.z;
            array[index + 3] = this.w;
            return this;
        };
        /**
         * Adds the passed vector to the current Vector4.
         * Returns the updated Vector4.
         */
        Vector4.prototype.addInPlace = function (otherVector) {
            this.x += otherVector.x;
            this.y += otherVector.y;
            this.z += otherVector.z;
            this.w += otherVector.w;
            return this;
        };
        /**
         * Returns a new Vector4 as the result of the addition of the current Vector4 and the passed one.
         */
        Vector4.prototype.add = function (otherVector) {
            return new Vector4(this.x + otherVector.x, this.y + otherVector.y, this.z + otherVector.z, this.w + otherVector.w);
        };
        /**
         * Updates the passed vector "result" with the result of the addition of the current Vector4 and the passed one.
         * Returns the current Vector4.
         */
        Vector4.prototype.addToRef = function (otherVector, result) {
            result.x = this.x + otherVector.x;
            result.y = this.y + otherVector.y;
            result.z = this.z + otherVector.z;
            result.w = this.w + otherVector.w;
            return this;
        };
        /**
         * Subtract in place the passed vector from the current Vector4.
         * Returns the updated Vector4.
         */
        Vector4.prototype.subtractInPlace = function (otherVector) {
            this.x -= otherVector.x;
            this.y -= otherVector.y;
            this.z -= otherVector.z;
            this.w -= otherVector.w;
            return this;
        };
        /**
         * Returns a new Vector4 with the result of the subtraction of the passed vector from the current Vector4.
         */
        Vector4.prototype.subtract = function (otherVector) {
            return new Vector4(this.x - otherVector.x, this.y - otherVector.y, this.z - otherVector.z, this.w - otherVector.w);
        };
        /**
         * Sets the passed vector "result" with the result of the subtraction of the passed vector from the current Vector4.
         * Returns the current Vector4.
         */
        Vector4.prototype.subtractToRef = function (otherVector, result) {
            result.x = this.x - otherVector.x;
            result.y = this.y - otherVector.y;
            result.z = this.z - otherVector.z;
            result.w = this.w - otherVector.w;
            return this;
        };
        /**
         * Returns a new Vector4 set with the result of the subtraction of the passed floats from the current Vector4 coordinates.
         */
        Vector4.prototype.subtractFromFloats = function (x, y, z, w) {
            return new Vector4(this.x - x, this.y - y, this.z - z, this.w - w);
        };
        /**
         * Sets the passed vector "result" set with the result of the subtraction of the passed floats from the current Vector4 coordinates.
         * Returns the current Vector4.
         */
        Vector4.prototype.subtractFromFloatsToRef = function (x, y, z, w, result) {
            result.x = this.x - x;
            result.y = this.y - y;
            result.z = this.z - z;
            result.w = this.w - w;
            return this;
        };
        /**
         * Returns a new Vector4 set with the current Vector4 negated coordinates.
         */
        Vector4.prototype.negate = function () {
            return new Vector4(-this.x, -this.y, -this.z, -this.w);
        };
        /**
         * Multiplies the current Vector4 coordinates by scale (float).
         * Returns the updated Vector4.
         */
        Vector4.prototype.scaleInPlace = function (scale) {
            this.x *= scale;
            this.y *= scale;
            this.z *= scale;
            this.w *= scale;
            return this;
        };
        /**
         * Returns a new Vector4 set with the current Vector4 coordinates multiplied by scale (float).
         */
        Vector4.prototype.scale = function (scale) {
            return new Vector4(this.x * scale, this.y * scale, this.z * scale, this.w * scale);
        };
        /**
         * Sets the passed vector "result" with the current Vector4 coordinates multiplied by scale (float).
         * Returns the current Vector4.
         */
        Vector4.prototype.scaleToRef = function (scale, result) {
            result.x = this.x * scale;
            result.y = this.y * scale;
            result.z = this.z * scale;
            result.w = this.w * scale;
            return this;
        };
        /**
         * Boolean : True if the current Vector4 coordinates are stricly equal to the passed ones.
         */
        Vector4.prototype.equals = function (otherVector) {
            return otherVector && this.x === otherVector.x && this.y === otherVector.y && this.z === otherVector.z && this.w === otherVector.w;
        };
        /**
         * Boolean : True if the current Vector4 coordinates are each beneath the distance "epsilon" from the passed vector ones.
         */
        Vector4.prototype.equalsWithEpsilon = function (otherVector, epsilon) {
            if (epsilon === void 0) { epsilon = BABYLON.Epsilon; }
            return otherVector
                && BABYLON.Scalar.WithinEpsilon(this.x, otherVector.x, epsilon)
                && BABYLON.Scalar.WithinEpsilon(this.y, otherVector.y, epsilon)
                && BABYLON.Scalar.WithinEpsilon(this.z, otherVector.z, epsilon)
                && BABYLON.Scalar.WithinEpsilon(this.w, otherVector.w, epsilon);
        };
        /**
         * Boolean : True if the passed floats are strictly equal to the current Vector4 coordinates.
         */
        Vector4.prototype.equalsToFloats = function (x, y, z, w) {
            return this.x === x && this.y === y && this.z === z && this.w === w;
        };
        /**
         * Multiplies in place the current Vector4 by the passed one.
         * Returns the updated Vector4.
         */
        Vector4.prototype.multiplyInPlace = function (otherVector) {
            this.x *= otherVector.x;
            this.y *= otherVector.y;
            this.z *= otherVector.z;
            this.w *= otherVector.w;
            return this;
        };
        /**
         * Returns a new Vector4 set with the multiplication result of the current Vector4 and the passed one.
         */
        Vector4.prototype.multiply = function (otherVector) {
            return new Vector4(this.x * otherVector.x, this.y * otherVector.y, this.z * otherVector.z, this.w * otherVector.w);
        };
        /**
         * Updates the passed vector "result" with the multiplication result of the current Vector4 and the passed one.
         * Returns the current Vector4.
         */
        Vector4.prototype.multiplyToRef = function (otherVector, result) {
            result.x = this.x * otherVector.x;
            result.y = this.y * otherVector.y;
            result.z = this.z * otherVector.z;
            result.w = this.w * otherVector.w;
            return this;
        };
        /**
         * Returns a new Vector4 set with the multiplication result of the passed floats and the current Vector4 coordinates.
         */
        Vector4.prototype.multiplyByFloats = function (x, y, z, w) {
            return new Vector4(this.x * x, this.y * y, this.z * z, this.w * w);
        };
        /**
         * Returns a new Vector4 set with the division result of the current Vector4 by the passed one.
         */
        Vector4.prototype.divide = function (otherVector) {
            return new Vector4(this.x / otherVector.x, this.y / otherVector.y, this.z / otherVector.z, this.w / otherVector.w);
        };
        /**
         * Updates the passed vector "result" with the division result of the current Vector4 by the passed one.
         * Returns the current Vector4.
         */
        Vector4.prototype.divideToRef = function (otherVector, result) {
            result.x = this.x / otherVector.x;
            result.y = this.y / otherVector.y;
            result.z = this.z / otherVector.z;
            result.w = this.w / otherVector.w;
            return this;
        };
        /**
         * Updates the Vector4 coordinates with the minimum values between its own and the passed vector ones.
         */
        Vector4.prototype.MinimizeInPlace = function (other) {
            if (other.x < this.x)
                this.x = other.x;
            if (other.y < this.y)
                this.y = other.y;
            if (other.z < this.z)
                this.z = other.z;
            if (other.w < this.w)
                this.w = other.w;
            return this;
        };
        /**
         * Updates the Vector4 coordinates with the maximum values between its own and the passed vector ones.
         */
        Vector4.prototype.MaximizeInPlace = function (other) {
            if (other.x > this.x)
                this.x = other.x;
            if (other.y > this.y)
                this.y = other.y;
            if (other.z > this.z)
                this.z = other.z;
            if (other.w > this.w)
                this.w = other.w;
            return this;
        };
        // Properties
        /**
         * Returns the Vector4 length (float).
         */
        Vector4.prototype.length = function () {
            return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
        };
        /**
         * Returns the Vector4 squared length (float).
         */
        Vector4.prototype.lengthSquared = function () {
            return (this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
        };
        // Methods
        /**
         * Normalizes in place the Vector4.
         * Returns the updated Vector4.
         */
        Vector4.prototype.normalize = function () {
            var len = this.length();
            if (len === 0)
                return this;
            var num = 1.0 / len;
            this.x *= num;
            this.y *= num;
            this.z *= num;
            this.w *= num;
            return this;
        };
        /**
         * Returns a new Vector3 from the Vector4 (x, y, z) coordinates.
         */
        Vector4.prototype.toVector3 = function () {
            return new Vector3(this.x, this.y, this.z);
        };
        /**
         * Returns a new Vector4 copied from the current one.
         */
        Vector4.prototype.clone = function () {
            return new Vector4(this.x, this.y, this.z, this.w);
        };
        /**
         * Updates the current Vector4 with the passed one coordinates.
         * Returns the updated Vector4.
         */
        Vector4.prototype.copyFrom = function (source) {
            this.x = source.x;
            this.y = source.y;
            this.z = source.z;
            this.w = source.w;
            return this;
        };
        /**
         * Updates the current Vector4 coordinates with the passed floats.
         * Returns the updated Vector4.
         */
        Vector4.prototype.copyFromFloats = function (x, y, z, w) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.w = w;
            return this;
        };
        /**
         * Updates the current Vector4 coordinates with the passed floats.
         * Returns the updated Vector4.
         */
        Vector4.prototype.set = function (x, y, z, w) {
            return this.copyFromFloats(x, y, z, w);
        };
        // Statics
        /**
         * Returns a new Vector4 set from the starting index of the passed array.
         */
        Vector4.FromArray = function (array, offset) {
            if (!offset) {
                offset = 0;
            }
            return new Vector4(array[offset], array[offset + 1], array[offset + 2], array[offset + 3]);
        };
        /**
         * Updates the passed vector "result" from the starting index of the passed array.
         */
        Vector4.FromArrayToRef = function (array, offset, result) {
            result.x = array[offset];
            result.y = array[offset + 1];
            result.z = array[offset + 2];
            result.w = array[offset + 3];
        };
        /**
         * Updates the passed vector "result" from the starting index of the passed Float32Array.
         */
        Vector4.FromFloatArrayToRef = function (array, offset, result) {
            Vector4.FromArrayToRef(array, offset, result);
        };
        /**
         * Updates the passed vector "result" coordinates from the passed floats.
         */
        Vector4.FromFloatsToRef = function (x, y, z, w, result) {
            result.x = x;
            result.y = y;
            result.z = z;
            result.w = w;
        };
        /**
         * Returns a new Vector4 set to (0.0, 0.0, 0.0, 0.0)
         */
        Vector4.Zero = function () {
            return new Vector4(0.0, 0.0, 0.0, 0.0);
        };
        /**
         * Returns a new Vector4 set to (1.0, 1.0, 1.0, 1.0)
         */
        Vector4.One = function () {
            return new Vector4(1.0, 1.0, 1.0, 1.0);
        };
        /**
         * Returns a new normalized Vector4 from the passed one.
         */
        Vector4.Normalize = function (vector) {
            var result = Vector4.Zero();
            Vector4.NormalizeToRef(vector, result);
            return result;
        };
        /**
         * Updates the passed vector "result" from the normalization of the passed one.
         */
        Vector4.NormalizeToRef = function (vector, result) {
            result.copyFrom(vector);
            result.normalize();
        };
        Vector4.Minimize = function (left, right) {
            var min = left.clone();
            min.MinimizeInPlace(right);
            return min;
        };
        Vector4.Maximize = function (left, right) {
            var max = left.clone();
            max.MaximizeInPlace(right);
            return max;
        };
        /**
         * Returns the distance (float) between the vectors "value1" and "value2".
         */
        Vector4.Distance = function (value1, value2) {
            return Math.sqrt(Vector4.DistanceSquared(value1, value2));
        };
        /**
         * Returns the squared distance (float) between the vectors "value1" and "value2".
         */
        Vector4.DistanceSquared = function (value1, value2) {
            var x = value1.x - value2.x;
            var y = value1.y - value2.y;
            var z = value1.z - value2.z;
            var w = value1.w - value2.w;
            return (x * x) + (y * y) + (z * z) + (w * w);
        };
        /**
         * Returns a new Vector4 located at the center between the vectors "value1" and "value2".
         */
        Vector4.Center = function (value1, value2) {
            var center = value1.add(value2);
            center.scaleInPlace(0.5);
            return center;
        };
        /**
         * Returns a new Vector4 set with the result of the normal transformation by the passed matrix of the passed vector.
         * This methods computes transformed normalized direction vectors only.
         */
        Vector4.TransformNormal = function (vector, transformation) {
            var result = Vector4.Zero();
            Vector4.TransformNormalToRef(vector, transformation, result);
            return result;
        };
        /**
         * Sets the passed vector "result" with the result of the normal transformation by the passed matrix of the passed vector.
         * This methods computes transformed normalized direction vectors only.
         */
        Vector4.TransformNormalToRef = function (vector, transformation, result) {
            var x = (vector.x * transformation.m[0]) + (vector.y * transformation.m[4]) + (vector.z * transformation.m[8]);
            var y = (vector.x * transformation.m[1]) + (vector.y * transformation.m[5]) + (vector.z * transformation.m[9]);
            var z = (vector.x * transformation.m[2]) + (vector.y * transformation.m[6]) + (vector.z * transformation.m[10]);
            result.x = x;
            result.y = y;
            result.z = z;
            result.w = vector.w;
        };
        /**
         * Sets the passed vector "result" with the result of the normal transformation by the passed matrix of the passed floats (x, y, z, w).
         * This methods computes transformed normalized direction vectors only.
         */
        Vector4.TransformNormalFromFloatsToRef = function (x, y, z, w, transformation, result) {
            result.x = (x * transformation.m[0]) + (y * transformation.m[4]) + (z * transformation.m[8]);
            result.y = (x * transformation.m[1]) + (y * transformation.m[5]) + (z * transformation.m[9]);
            result.z = (x * transformation.m[2]) + (y * transformation.m[6]) + (z * transformation.m[10]);
            result.w = w;
        };
        return Vector4;
    }());
    BABYLON.Vector4 = Vector4;
    var Size = /** @class */ (function () {
        /**
         * Creates a Size object from the passed width and height (floats).
         */
        function Size(width, height) {
            this.width = width;
            this.height = height;
        }
        // Returns a string with the Size width and height.  
        Size.prototype.toString = function () {
            return "{W: " + this.width + ", H: " + this.height + "}";
        };
        /**
         * Returns the string "Size"
         */
        Size.prototype.getClassName = function () {
            return "Size";
        };
        /**
         * Returns the Size hash code.
         */
        Size.prototype.getHashCode = function () {
            var hash = this.width || 0;
            hash = (hash * 397) ^ (this.height || 0);
            return hash;
        };
        /**
         * Updates the current size from the passed one.
         * Returns the updated Size.
         */
        Size.prototype.copyFrom = function (src) {
            this.width = src.width;
            this.height = src.height;
        };
        /**
         * Updates in place the current Size from the passed floats.
         * Returns the updated Size.
         */
        Size.prototype.copyFromFloats = function (width, height) {
            this.width = width;
            this.height = height;
            return this;
        };
        /**
         * Updates in place the current Size from the passed floats.
         * Returns the updated Size.
         */
        Size.prototype.set = function (width, height) {
            return this.copyFromFloats(width, height);
        };
        /**
         * Returns a new Size set with the multiplication result of the current Size and the passed floats.
         */
        Size.prototype.multiplyByFloats = function (w, h) {
            return new Size(this.width * w, this.height * h);
        };
        /**
         * Returns a new Size copied from the passed one.
         */
        Size.prototype.clone = function () {
            return new Size(this.width, this.height);
        };
        /**
         * Boolean : True if the current Size and the passed one width and height are strictly equal.
         */
        Size.prototype.equals = function (other) {
            if (!other) {
                return false;
            }
            return (this.width === other.width) && (this.height === other.height);
        };
        Object.defineProperty(Size.prototype, "surface", {
            /**
             * Returns the surface of the Size : width * height (float).
             */
            get: function () {
                return this.width * this.height;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * Returns a new Size set to (0.0, 0.0)
         */
        Size.Zero = function () {
            return new Size(0.0, 0.0);
        };
        /**
         * Returns a new Size set as the addition result of the current Size and the passed one.
         */
        Size.prototype.add = function (otherSize) {
            var r = new Size(this.width + otherSize.width, this.height + otherSize.height);
            return r;
        };
        /**
         * Returns a new Size set as the subtraction result of  the passed one from the current Size.
         */
        Size.prototype.subtract = function (otherSize) {
            var r = new Size(this.width - otherSize.width, this.height - otherSize.height);
            return r;
        };
        /**
         * Returns a new Size set at the linear interpolation "amount" between "start" and "end".
         */
        Size.Lerp = function (start, end, amount) {
            var w = start.width + ((end.width - start.width) * amount);
            var h = start.height + ((end.height - start.height) * amount);
            return new Size(w, h);
        };
        return Size;
    }());
    BABYLON.Size = Size;
    var Quaternion = /** @class */ (function () {
        /**
         * Creates a new Quaternion from the passed floats.
         */
        function Quaternion(x, y, z, w) {
            if (x === void 0) { x = 0.0; }
            if (y === void 0) { y = 0.0; }
            if (z === void 0) { z = 0.0; }
            if (w === void 0) { w = 1.0; }
            this.x = x;
            this.y = y;
            this.z = z;
            this.w = w;
        }
        /**
         * Returns a string with the Quaternion coordinates.
         */
        Quaternion.prototype.toString = function () {
            return "{X: " + this.x + " Y:" + this.y + " Z:" + this.z + " W:" + this.w + "}";
        };
        /**
         * Returns the string "Quaternion".
         */
        Quaternion.prototype.getClassName = function () {
            return "Quaternion";
        };
        /**
         * Returns the Quaternion hash code.
         */
        Quaternion.prototype.getHashCode = function () {
            var hash = this.x || 0;
            hash = (hash * 397) ^ (this.y || 0);
            hash = (hash * 397) ^ (this.z || 0);
            hash = (hash * 397) ^ (this.w || 0);
            return hash;
        };
        /**
         * Returns a new array populated with 4 elements : the Quaternion coordinates.
         */
        Quaternion.prototype.asArray = function () {
            return [this.x, this.y, this.z, this.w];
        };
        /**
         * Boolean : True if the current Quaterion and the passed one coordinates are strictly equal.
         */
        Quaternion.prototype.equals = function (otherQuaternion) {
            return otherQuaternion && this.x === otherQuaternion.x && this.y === otherQuaternion.y && this.z === otherQuaternion.z && this.w === otherQuaternion.w;
        };
        /**
         * Returns a new Quaternion copied from the current one.
         */
        Quaternion.prototype.clone = function () {
            return new Quaternion(this.x, this.y, this.z, this.w);
        };
        /**
         * Updates the current Quaternion from the passed one coordinates.
         * Returns the updated Quaterion.
         */
        Quaternion.prototype.copyFrom = function (other) {
            this.x = other.x;
            this.y = other.y;
            this.z = other.z;
            this.w = other.w;
            return this;
        };
        /**
         * Updates the current Quaternion from the passed float coordinates.
         * Returns the updated Quaterion.
         */
        Quaternion.prototype.copyFromFloats = function (x, y, z, w) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.w = w;
            return this;
        };
        /**
         * Updates the current Quaternion from the passed float coordinates.
         * Returns the updated Quaterion.
         */
        Quaternion.prototype.set = function (x, y, z, w) {
            return this.copyFromFloats(x, y, z, w);
        };
        /**
         * Returns a new Quaternion as the addition result of the passed one and the current Quaternion.
         */
        Quaternion.prototype.add = function (other) {
            return new Quaternion(this.x + other.x, this.y + other.y, this.z + other.z, this.w + other.w);
        };
        /**
         * Returns a new Quaternion as the subtraction result of the passed one from the current Quaternion.
         */
        Quaternion.prototype.subtract = function (other) {
            return new Quaternion(this.x - other.x, this.y - other.y, this.z - other.z, this.w - other.w);
        };
        /**
         * Returns a new Quaternion set by multiplying the current Quaterion coordinates by the float "scale".
         */
        Quaternion.prototype.scale = function (value) {
            return new Quaternion(this.x * value, this.y * value, this.z * value, this.w * value);
        };
        /**
         * Returns a new Quaternion set as the quaternion mulplication result of the current one with the passed one "q1".
         */
        Quaternion.prototype.multiply = function (q1) {
            var result = new Quaternion(0, 0, 0, 1.0);
            this.multiplyToRef(q1, result);
            return result;
        };
        /**
         * Sets the passed "result" as the quaternion mulplication result of the current one with the passed one "q1".
         * Returns the current Quaternion.
         */
        Quaternion.prototype.multiplyToRef = function (q1, result) {
            var x = this.x * q1.w + this.y * q1.z - this.z * q1.y + this.w * q1.x;
            var y = -this.x * q1.z + this.y * q1.w + this.z * q1.x + this.w * q1.y;
            var z = this.x * q1.y - this.y * q1.x + this.z * q1.w + this.w * q1.z;
            var w = -this.x * q1.x - this.y * q1.y - this.z * q1.z + this.w * q1.w;
            result.copyFromFloats(x, y, z, w);
            return this;
        };
        /**
         * Updates the current Quaternion with the quaternion mulplication result of itself with the passed one "q1".
         * Returns the updated Quaternion.
         */
        Quaternion.prototype.multiplyInPlace = function (q1) {
            this.multiplyToRef(q1, this);
            return this;
        };
        /**
         * Sets the passed "ref" with the conjugation of the current Quaternion.
         * Returns the current Quaternion.
         */
        Quaternion.prototype.conjugateToRef = function (ref) {
            ref.copyFromFloats(-this.x, -this.y, -this.z, this.w);
            return this;
        };
        /**
         * Conjugates in place the current Quaternion.
         * Returns the updated Quaternion.
         */
        Quaternion.prototype.conjugateInPlace = function () {
            this.x *= -1;
            this.y *= -1;
            this.z *= -1;
            return this;
        };
        /**
         * Returns a new Quaternion as the conjugate of the current Quaternion.
         */
        Quaternion.prototype.conjugate = function () {
            var result = new Quaternion(-this.x, -this.y, -this.z, this.w);
            return result;
        };
        /**
         * Returns the Quaternion length (float).
         */
        Quaternion.prototype.length = function () {
            return Math.sqrt((this.x * this.x) + (this.y * this.y) + (this.z * this.z) + (this.w * this.w));
        };
        /**
         * Normalize in place the current Quaternion.
         * Returns the updated Quaternion.
         */
        Quaternion.prototype.normalize = function () {
            var length = 1.0 / this.length();
            this.x *= length;
            this.y *= length;
            this.z *= length;
            this.w *= length;
            return this;
        };
        /**
         * Returns a new Vector3 set with the Euler angles translated from the current Quaternion.
         */
        Quaternion.prototype.toEulerAngles = function (order) {
            if (order === void 0) { order = "YZX"; }
            var result = Vector3.Zero();
            this.toEulerAnglesToRef(result, order);
            return result;
        };
        /**
         * Sets the passed vector3 "result" with the Euler angles translated from the current Quaternion.
         * Returns the current Quaternion.
         */
        Quaternion.prototype.toEulerAnglesToRef = function (result, order) {
            if (order === void 0) { order = "YZX"; }
            var qz = this.z;
            var qx = this.x;
            var qy = this.y;
            var qw = this.w;
            var sqw = qw * qw;
            var sqz = qz * qz;
            var sqx = qx * qx;
            var sqy = qy * qy;
            var zAxisY = qy * qz - qx * qw;
            var limit = .4999999;
            if (zAxisY < -limit) {
                result.y = 2 * Math.atan2(qy, qw);
                result.x = Math.PI / 2;
                result.z = 0;
            }
            else if (zAxisY > limit) {
                result.y = 2 * Math.atan2(qy, qw);
                result.x = -Math.PI / 2;
                result.z = 0;
            }
            else {
                result.z = Math.atan2(2.0 * (qx * qy + qz * qw), (-sqz - sqx + sqy + sqw));
                result.x = Math.asin(-2.0 * (qz * qy - qx * qw));
                result.y = Math.atan2(2.0 * (qz * qx + qy * qw), (sqz - sqx - sqy + sqw));
            }
            return this;
        };
        /**
         * Updates the passed rotation matrix with the current Quaternion values.
         * Returns the current Quaternion.
         */
        Quaternion.prototype.toRotationMatrix = function (result) {
            var xx = this.x * this.x;
            var yy = this.y * this.y;
            var zz = this.z * this.z;
            var xy = this.x * this.y;
            var zw = this.z * this.w;
            var zx = this.z * this.x;
            var yw = this.y * this.w;
            var yz = this.y * this.z;
            var xw = this.x * this.w;
            result.m[0] = 1.0 - (2.0 * (yy + zz));
            result.m[1] = 2.0 * (xy + zw);
            result.m[2] = 2.0 * (zx - yw);
            result.m[3] = 0;
            result.m[4] = 2.0 * (xy - zw);
            result.m[5] = 1.0 - (2.0 * (zz + xx));
            result.m[6] = 2.0 * (yz + xw);
            result.m[7] = 0;
            result.m[8] = 2.0 * (zx + yw);
            result.m[9] = 2.0 * (yz - xw);
            result.m[10] = 1.0 - (2.0 * (yy + xx));
            result.m[11] = 0;
            result.m[12] = 0;
            result.m[13] = 0;
            result.m[14] = 0;
            result.m[15] = 1.0;
            result._markAsUpdated();
            return this;
        };
        /**
         * Updates the current Quaternion from the passed rotation matrix values.
         * Returns the updated Quaternion.
         */
        Quaternion.prototype.fromRotationMatrix = function (matrix) {
            Quaternion.FromRotationMatrixToRef(matrix, this);
            return this;
        };
        // Statics
        /**
         * Returns a new Quaternion set from the passed rotation matrix values.
         */
        Quaternion.FromRotationMatrix = function (matrix) {
            var result = new Quaternion();
            Quaternion.FromRotationMatrixToRef(matrix, result);
            return result;
        };
        /**
         * Updates the passed quaternion "result" with the passed rotation matrix values.
         */
        Quaternion.FromRotationMatrixToRef = function (matrix, result) {
            var data = matrix.m;
            var m11 = data[0], m12 = data[4], m13 = data[8];
            var m21 = data[1], m22 = data[5], m23 = data[9];
            var m31 = data[2], m32 = data[6], m33 = data[10];
            var trace = m11 + m22 + m33;
            var s;
            if (trace > 0) {
                s = 0.5 / Math.sqrt(trace + 1.0);
                result.w = 0.25 / s;
                result.x = (m32 - m23) * s;
                result.y = (m13 - m31) * s;
                result.z = (m21 - m12) * s;
            }
            else if (m11 > m22 && m11 > m33) {
                s = 2.0 * Math.sqrt(1.0 + m11 - m22 - m33);
                result.w = (m32 - m23) / s;
                result.x = 0.25 * s;
                result.y = (m12 + m21) / s;
                result.z = (m13 + m31) / s;
            }
            else if (m22 > m33) {
                s = 2.0 * Math.sqrt(1.0 + m22 - m11 - m33);
                result.w = (m13 - m31) / s;
                result.x = (m12 + m21) / s;
                result.y = 0.25 * s;
                result.z = (m23 + m32) / s;
            }
            else {
                s = 2.0 * Math.sqrt(1.0 + m33 - m11 - m22);
                result.w = (m21 - m12) / s;
                result.x = (m13 + m31) / s;
                result.y = (m23 + m32) / s;
                result.z = 0.25 * s;
            }
        };
        /**
         * Returns a new Quaternion set to (0.0, 0.0, 0.0).
         */
        Quaternion.Zero = function () {
            return new Quaternion(0.0, 0.0, 0.0, 0.0);
        };
        /**
         * Returns a new Quaternion as the inverted current Quaternion.
         */
        Quaternion.Inverse = function (q) {
            return new Quaternion(-q.x, -q.y, -q.z, q.w);
        };
        /**
         * Returns the identity Quaternion.
         */
        Quaternion.Identity = function () {
            return new Quaternion(0.0, 0.0, 0.0, 1.0);
        };
        Quaternion.IsIdentity = function (quaternion) {
            return quaternion && quaternion.x === 0 && quaternion.y === 0 && quaternion.z === 0 && quaternion.w === 1;
        };
        /**
         * Returns a new Quaternion set from the passed axis (Vector3) and angle in radians (float).
         */
        Quaternion.RotationAxis = function (axis, angle) {
            return Quaternion.RotationAxisToRef(axis, angle, new Quaternion());
        };
        /**
         * Sets the passed quaternion "result" from the passed axis (Vector3) and angle in radians (float).
         */
        Quaternion.RotationAxisToRef = function (axis, angle, result) {
            var sin = Math.sin(angle / 2);
            axis.normalize();
            result.w = Math.cos(angle / 2);
            result.x = axis.x * sin;
            result.y = axis.y * sin;
            result.z = axis.z * sin;
            return result;
        };
        /**
         * Retuns a new Quaternion set from the starting index of the passed array.
         */
        Quaternion.FromArray = function (array, offset) {
            if (!offset) {
                offset = 0;
            }
            return new Quaternion(array[offset], array[offset + 1], array[offset + 2], array[offset + 3]);
        };
        /**
         * Returns a new Quaternion set from the passed Euler float angles (y, x, z).
         */
        Quaternion.RotationYawPitchRoll = function (yaw, pitch, roll) {
            var q = new Quaternion();
            Quaternion.RotationYawPitchRollToRef(yaw, pitch, roll, q);
            return q;
        };
        /**
         * Sets the passed quaternion "result" from the passed float Euler angles (y, x, z).
         */
        Quaternion.RotationYawPitchRollToRef = function (yaw, pitch, roll, result) {
            // Produces a quaternion from Euler angles in the z-y-x orientation (Tait-Bryan angles)
            var halfRoll = roll * 0.5;
            var halfPitch = pitch * 0.5;
            var halfYaw = yaw * 0.5;
            var sinRoll = Math.sin(halfRoll);
            var cosRoll = Math.cos(halfRoll);
            var sinPitch = Math.sin(halfPitch);
            var cosPitch = Math.cos(halfPitch);
            var sinYaw = Math.sin(halfYaw);
            var cosYaw = Math.cos(halfYaw);
            result.x = (cosYaw * sinPitch * cosRoll) + (sinYaw * cosPitch * sinRoll);
            result.y = (sinYaw * cosPitch * cosRoll) - (cosYaw * sinPitch * sinRoll);
            result.z = (cosYaw * cosPitch * sinRoll) - (sinYaw * sinPitch * cosRoll);
            result.w = (cosYaw * cosPitch * cosRoll) + (sinYaw * sinPitch * sinRoll);
        };
        /**
         * Returns a new Quaternion from the passed float Euler angles expressed in z-x-z orientation
         */
        Quaternion.RotationAlphaBetaGamma = function (alpha, beta, gamma) {
            var result = new Quaternion();
            Quaternion.RotationAlphaBetaGammaToRef(alpha, beta, gamma, result);
            return result;
        };
        /**
         * Sets the passed quaternion "result" from the passed float Euler angles expressed in z-x-z orientation
         */
        Quaternion.RotationAlphaBetaGammaToRef = function (alpha, beta, gamma, result) {
            // Produces a quaternion from Euler angles in the z-x-z orientation
            var halfGammaPlusAlpha = (gamma + alpha) * 0.5;
            var halfGammaMinusAlpha = (gamma - alpha) * 0.5;
            var halfBeta = beta * 0.5;
            result.x = Math.cos(halfGammaMinusAlpha) * Math.sin(halfBeta);
            result.y = Math.sin(halfGammaMinusAlpha) * Math.sin(halfBeta);
            result.z = Math.sin(halfGammaPlusAlpha) * Math.cos(halfBeta);
            result.w = Math.cos(halfGammaPlusAlpha) * Math.cos(halfBeta);
        };
        /**
         * Returns a new Quaternion as the quaternion rotation value to reach the target (axis1, axis2, axis3) orientation as a rotated XYZ system.
         * cf to Vector3.RotationFromAxis() documentation.
         * Note : axis1, axis2 and axis3 are normalized during this operation.
         */
        Quaternion.RotationQuaternionFromAxis = function (axis1, axis2, axis3, ref) {
            var quat = new Quaternion(0.0, 0.0, 0.0, 0.0);
            Quaternion.RotationQuaternionFromAxisToRef(axis1, axis2, axis3, quat);
            return quat;
        };
        /**
         * Sets the passed quaternion "ref" with the quaternion rotation value to reach the target (axis1, axis2, axis3) orientation as a rotated XYZ system.
         * cf to Vector3.RotationFromAxis() documentation.
         * Note : axis1, axis2 and axis3 are normalized during this operation.
         */
        Quaternion.RotationQuaternionFromAxisToRef = function (axis1, axis2, axis3, ref) {
            var rotMat = MathTmp.Matrix[0];
            BABYLON.Matrix.FromXYZAxesToRef(axis1.normalize(), axis2.normalize(), axis3.normalize(), rotMat);
            BABYLON.Quaternion.FromRotationMatrixToRef(rotMat, ref);
        };
        Quaternion.Slerp = function (left, right, amount) {
            var result = Quaternion.Identity();
            Quaternion.SlerpToRef(left, right, amount, result);
            return result;
        };
        Quaternion.SlerpToRef = function (left, right, amount, result) {
            var num2;
            var num3;
            var num = amount;
            var num4 = (((left.x * right.x) + (left.y * right.y)) + (left.z * right.z)) + (left.w * right.w);
            var flag = false;
            if (num4 < 0) {
                flag = true;
                num4 = -num4;
            }
            if (num4 > 0.999999) {
                num3 = 1 - num;
                num2 = flag ? -num : num;
            }
            else {
                var num5 = Math.acos(num4);
                var num6 = (1.0 / Math.sin(num5));
                num3 = (Math.sin((1.0 - num) * num5)) * num6;
                num2 = flag ? ((-Math.sin(num * num5)) * num6) : ((Math.sin(num * num5)) * num6);
            }
            result.x = (num3 * left.x) + (num2 * right.x);
            result.y = (num3 * left.y) + (num2 * right.y);
            result.z = (num3 * left.z) + (num2 * right.z);
            result.w = (num3 * left.w) + (num2 * right.w);
        };
        /**
         * Returns a new Quaternion located for "amount" (float) on the Hermite interpolation spline defined by the vectors "value1", "tangent1", "value2", "tangent2".
         */
        Quaternion.Hermite = function (value1, tangent1, value2, tangent2, amount) {
            var squared = amount * amount;
            var cubed = amount * squared;
            var part1 = ((2.0 * cubed) - (3.0 * squared)) + 1.0;
            var part2 = (-2.0 * cubed) + (3.0 * squared);
            var part3 = (cubed - (2.0 * squared)) + amount;
            var part4 = cubed - squared;
            var x = (((value1.x * part1) + (value2.x * part2)) + (tangent1.x * part3)) + (tangent2.x * part4);
            var y = (((value1.y * part1) + (value2.y * part2)) + (tangent1.y * part3)) + (tangent2.y * part4);
            var z = (((value1.z * part1) + (value2.z * part2)) + (tangent1.z * part3)) + (tangent2.z * part4);
            var w = (((value1.w * part1) + (value2.w * part2)) + (tangent1.w * part3)) + (tangent2.w * part4);
            return new Quaternion(x, y, z, w);
        };
        return Quaternion;
    }());
    BABYLON.Quaternion = Quaternion;
    var Matrix = /** @class */ (function () {
        function Matrix() {
            this._isIdentity = false;
            this._isIdentityDirty = true;
            this.m = new Float32Array(16);
            this._markAsUpdated();
        }
        Matrix.prototype._markAsUpdated = function () {
            this.updateFlag = Matrix._updateFlagSeed++;
            this._isIdentityDirty = true;
        };
        // Properties
        /**
         * Boolean : True is the matrix is the identity matrix
         */
        Matrix.prototype.isIdentity = function (considerAsTextureMatrix) {
            if (considerAsTextureMatrix === void 0) { considerAsTextureMatrix = false; }
            if (this._isIdentityDirty) {
                this._isIdentityDirty = false;
                if (this.m[0] !== 1.0 || this.m[5] !== 1.0 || this.m[15] !== 1.0) {
                    this._isIdentity = false;
                }
                else if (this.m[1] !== 0.0 || this.m[2] !== 0.0 || this.m[3] !== 0.0 ||
                    this.m[4] !== 0.0 || this.m[6] !== 0.0 || this.m[7] !== 0.0 ||
                    this.m[8] !== 0.0 || this.m[9] !== 0.0 || this.m[11] !== 0.0 ||
                    this.m[12] !== 0.0 || this.m[13] !== 0.0 || this.m[14] !== 0.0) {
                    this._isIdentity = false;
                }
                else {
                    this._isIdentity = true;
                }
                if (!considerAsTextureMatrix && this.m[10] !== 1.0) {
                    this._isIdentity = false;
                }
            }
            return this._isIdentity;
        };
        /**
         * Returns the matrix determinant (float).
         */
        Matrix.prototype.determinant = function () {
            var temp1 = (this.m[10] * this.m[15]) - (this.m[11] * this.m[14]);
            var temp2 = (this.m[9] * this.m[15]) - (this.m[11] * this.m[13]);
            var temp3 = (this.m[9] * this.m[14]) - (this.m[10] * this.m[13]);
            var temp4 = (this.m[8] * this.m[15]) - (this.m[11] * this.m[12]);
            var temp5 = (this.m[8] * this.m[14]) - (this.m[10] * this.m[12]);
            var temp6 = (this.m[8] * this.m[13]) - (this.m[9] * this.m[12]);
            return ((((this.m[0] * (((this.m[5] * temp1) - (this.m[6] * temp2)) + (this.m[7] * temp3))) - (this.m[1] * (((this.m[4] * temp1) -
                (this.m[6] * temp4)) + (this.m[7] * temp5)))) + (this.m[2] * (((this.m[4] * temp2) - (this.m[5] * temp4)) + (this.m[7] * temp6)))) -
                (this.m[3] * (((this.m[4] * temp3) - (this.m[5] * temp5)) + (this.m[6] * temp6))));
        };
        // Methods
        /**
         * Returns the matrix underlying array.
         */
        Matrix.prototype.toArray = function () {
            return this.m;
        };
        /**
        * Returns the matrix underlying array.
        */
        Matrix.prototype.asArray = function () {
            return this.toArray();
        };
        /**
         * Inverts in place the Matrix.
         * Returns the Matrix inverted.
         */
        Matrix.prototype.invert = function () {
            this.invertToRef(this);
            return this;
        };
        /**
         * Sets all the matrix elements to zero.
         * Returns the Matrix.
         */
        Matrix.prototype.reset = function () {
            for (var index = 0; index < 16; index++) {
                this.m[index] = 0.0;
            }
            this._markAsUpdated();
            return this;
        };
        /**
         * Returns a new Matrix as the addition result of the current Matrix and the passed one.
         */
        Matrix.prototype.add = function (other) {
            var result = new Matrix();
            this.addToRef(other, result);
            return result;
        };
        /**
         * Sets the passed matrix "result" with the ddition result of the current Matrix and the passed one.
         * Returns the Matrix.
         */
        Matrix.prototype.addToRef = function (other, result) {
            for (var index = 0; index < 16; index++) {
                result.m[index] = this.m[index] + other.m[index];
            }
            result._markAsUpdated();
            return this;
        };
        /**
         * Adds in place the passed matrix to the current Matrix.
         * Returns the updated Matrix.
         */
        Matrix.prototype.addToSelf = function (other) {
            for (var index = 0; index < 16; index++) {
                this.m[index] += other.m[index];
            }
            this._markAsUpdated();
            return this;
        };
        /**
         * Sets the passed matrix with the current inverted Matrix.
         * Returns the unmodified current Matrix.
         */
        Matrix.prototype.invertToRef = function (other) {
            var l1 = this.m[0];
            var l2 = this.m[1];
            var l3 = this.m[2];
            var l4 = this.m[3];
            var l5 = this.m[4];
            var l6 = this.m[5];
            var l7 = this.m[6];
            var l8 = this.m[7];
            var l9 = this.m[8];
            var l10 = this.m[9];
            var l11 = this.m[10];
            var l12 = this.m[11];
            var l13 = this.m[12];
            var l14 = this.m[13];
            var l15 = this.m[14];
            var l16 = this.m[15];
            var l17 = (l11 * l16) - (l12 * l15);
            var l18 = (l10 * l16) - (l12 * l14);
            var l19 = (l10 * l15) - (l11 * l14);
            var l20 = (l9 * l16) - (l12 * l13);
            var l21 = (l9 * l15) - (l11 * l13);
            var l22 = (l9 * l14) - (l10 * l13);
            var l23 = ((l6 * l17) - (l7 * l18)) + (l8 * l19);
            var l24 = -(((l5 * l17) - (l7 * l20)) + (l8 * l21));
            var l25 = ((l5 * l18) - (l6 * l20)) + (l8 * l22);
            var l26 = -(((l5 * l19) - (l6 * l21)) + (l7 * l22));
            var l27 = 1.0 / ((((l1 * l23) + (l2 * l24)) + (l3 * l25)) + (l4 * l26));
            var l28 = (l7 * l16) - (l8 * l15);
            var l29 = (l6 * l16) - (l8 * l14);
            var l30 = (l6 * l15) - (l7 * l14);
            var l31 = (l5 * l16) - (l8 * l13);
            var l32 = (l5 * l15) - (l7 * l13);
            var l33 = (l5 * l14) - (l6 * l13);
            var l34 = (l7 * l12) - (l8 * l11);
            var l35 = (l6 * l12) - (l8 * l10);
            var l36 = (l6 * l11) - (l7 * l10);
            var l37 = (l5 * l12) - (l8 * l9);
            var l38 = (l5 * l11) - (l7 * l9);
            var l39 = (l5 * l10) - (l6 * l9);
            other.m[0] = l23 * l27;
            other.m[4] = l24 * l27;
            other.m[8] = l25 * l27;
            other.m[12] = l26 * l27;
            other.m[1] = -(((l2 * l17) - (l3 * l18)) + (l4 * l19)) * l27;
            other.m[5] = (((l1 * l17) - (l3 * l20)) + (l4 * l21)) * l27;
            other.m[9] = -(((l1 * l18) - (l2 * l20)) + (l4 * l22)) * l27;
            other.m[13] = (((l1 * l19) - (l2 * l21)) + (l3 * l22)) * l27;
            other.m[2] = (((l2 * l28) - (l3 * l29)) + (l4 * l30)) * l27;
            other.m[6] = -(((l1 * l28) - (l3 * l31)) + (l4 * l32)) * l27;
            other.m[10] = (((l1 * l29) - (l2 * l31)) + (l4 * l33)) * l27;
            other.m[14] = -(((l1 * l30) - (l2 * l32)) + (l3 * l33)) * l27;
            other.m[3] = -(((l2 * l34) - (l3 * l35)) + (l4 * l36)) * l27;
            other.m[7] = (((l1 * l34) - (l3 * l37)) + (l4 * l38)) * l27;
            other.m[11] = -(((l1 * l35) - (l2 * l37)) + (l4 * l39)) * l27;
            other.m[15] = (((l1 * l36) - (l2 * l38)) + (l3 * l39)) * l27;
            other._markAsUpdated();
            return this;
        };
        /**
         * Inserts the translation vector (using 3 x floats) in the current Matrix.
         * Returns the updated Matrix.
         */
        Matrix.prototype.setTranslationFromFloats = function (x, y, z) {
            this.m[12] = x;
            this.m[13] = y;
            this.m[14] = z;
            this._markAsUpdated();
            return this;
        };
        /**
 * Inserts the translation vector in the current Matrix.
 * Returns the updated Matrix.
 */
        Matrix.prototype.setTranslation = function (vector3) {
            this.m[12] = vector3.x;
            this.m[13] = vector3.y;
            this.m[14] = vector3.z;
            this._markAsUpdated();
            return this;
        };
        /**
         * Returns a new Vector3 as the extracted translation from the Matrix.
         */
        Matrix.prototype.getTranslation = function () {
            return new Vector3(this.m[12], this.m[13], this.m[14]);
        };
        /**
         * Fill a Vector3 with the extracted translation from the Matrix.
         */
        Matrix.prototype.getTranslationToRef = function (result) {
            result.x = this.m[12];
            result.y = this.m[13];
            result.z = this.m[14];
            return this;
        };
        /**
         * Remove rotation and scaling part from the Matrix.
         * Returns the updated Matrix.
         */
        Matrix.prototype.removeRotationAndScaling = function () {
            this.setRowFromFloats(0, 1, 0, 0, 0);
            this.setRowFromFloats(1, 0, 1, 0, 0);
            this.setRowFromFloats(2, 0, 0, 1, 0);
            return this;
        };
        /**
         * Returns a new Matrix set with the multiplication result of the current Matrix and the passed one.
         */
        Matrix.prototype.multiply = function (other) {
            var result = new Matrix();
            this.multiplyToRef(other, result);
            return result;
        };
        /**
         * Updates the current Matrix from the passed one values.
         * Returns the updated Matrix.
         */
        Matrix.prototype.copyFrom = function (other) {
            for (var index = 0; index < 16; index++) {
                this.m[index] = other.m[index];
            }
            this._markAsUpdated();
            return this;
        };
        /**
         * Populates the passed array from the starting index with the Matrix values.
         * Returns the Matrix.
         */
        Matrix.prototype.copyToArray = function (array, offset) {
            if (offset === void 0) { offset = 0; }
            for (var index = 0; index < 16; index++) {
                array[offset + index] = this.m[index];
            }
            return this;
        };
        /**
         * Sets the passed matrix "result" with the multiplication result of the current Matrix and the passed one.
         */
        Matrix.prototype.multiplyToRef = function (other, result) {
            this.multiplyToArray(other, result.m, 0);
            result._markAsUpdated();
            return this;
        };
        /**
         * Sets the Float32Array "result" from the passed index "offset" with the multiplication result of the current Matrix and the passed one.
         */
        Matrix.prototype.multiplyToArray = function (other, result, offset) {
            var tm0 = this.m[0];
            var tm1 = this.m[1];
            var tm2 = this.m[2];
            var tm3 = this.m[3];
            var tm4 = this.m[4];
            var tm5 = this.m[5];
            var tm6 = this.m[6];
            var tm7 = this.m[7];
            var tm8 = this.m[8];
            var tm9 = this.m[9];
            var tm10 = this.m[10];
            var tm11 = this.m[11];
            var tm12 = this.m[12];
            var tm13 = this.m[13];
            var tm14 = this.m[14];
            var tm15 = this.m[15];
            var om0 = other.m[0];
            var om1 = other.m[1];
            var om2 = other.m[2];
            var om3 = other.m[3];
            var om4 = other.m[4];
            var om5 = other.m[5];
            var om6 = other.m[6];
            var om7 = other.m[7];
            var om8 = other.m[8];
            var om9 = other.m[9];
            var om10 = other.m[10];
            var om11 = other.m[11];
            var om12 = other.m[12];
            var om13 = other.m[13];
            var om14 = other.m[14];
            var om15 = other.m[15];
            result[offset] = tm0 * om0 + tm1 * om4 + tm2 * om8 + tm3 * om12;
            result[offset + 1] = tm0 * om1 + tm1 * om5 + tm2 * om9 + tm3 * om13;
            result[offset + 2] = tm0 * om2 + tm1 * om6 + tm2 * om10 + tm3 * om14;
            result[offset + 3] = tm0 * om3 + tm1 * om7 + tm2 * om11 + tm3 * om15;
            result[offset + 4] = tm4 * om0 + tm5 * om4 + tm6 * om8 + tm7 * om12;
            result[offset + 5] = tm4 * om1 + tm5 * om5 + tm6 * om9 + tm7 * om13;
            result[offset + 6] = tm4 * om2 + tm5 * om6 + tm6 * om10 + tm7 * om14;
            result[offset + 7] = tm4 * om3 + tm5 * om7 + tm6 * om11 + tm7 * om15;
            result[offset + 8] = tm8 * om0 + tm9 * om4 + tm10 * om8 + tm11 * om12;
            result[offset + 9] = tm8 * om1 + tm9 * om5 + tm10 * om9 + tm11 * om13;
            result[offset + 10] = tm8 * om2 + tm9 * om6 + tm10 * om10 + tm11 * om14;
            result[offset + 11] = tm8 * om3 + tm9 * om7 + tm10 * om11 + tm11 * om15;
            result[offset + 12] = tm12 * om0 + tm13 * om4 + tm14 * om8 + tm15 * om12;
            result[offset + 13] = tm12 * om1 + tm13 * om5 + tm14 * om9 + tm15 * om13;
            result[offset + 14] = tm12 * om2 + tm13 * om6 + tm14 * om10 + tm15 * om14;
            result[offset + 15] = tm12 * om3 + tm13 * om7 + tm14 * om11 + tm15 * om15;
            return this;
        };
        /**
         * Boolean : True is the current Matrix and the passed one values are strictly equal.
         */
        Matrix.prototype.equals = function (value) {
            return value &&
                (this.m[0] === value.m[0] && this.m[1] === value.m[1] && this.m[2] === value.m[2] && this.m[3] === value.m[3] &&
                    this.m[4] === value.m[4] && this.m[5] === value.m[5] && this.m[6] === value.m[6] && this.m[7] === value.m[7] &&
                    this.m[8] === value.m[8] && this.m[9] === value.m[9] && this.m[10] === value.m[10] && this.m[11] === value.m[11] &&
                    this.m[12] === value.m[12] && this.m[13] === value.m[13] && this.m[14] === value.m[14] && this.m[15] === value.m[15]);
        };
        /**
         * Returns a new Matrix from the current Matrix.
         */
        Matrix.prototype.clone = function () {
            return Matrix.FromValues(this.m[0], this.m[1], this.m[2], this.m[3], this.m[4], this.m[5], this.m[6], this.m[7], this.m[8], this.m[9], this.m[10], this.m[11], this.m[12], this.m[13], this.m[14], this.m[15]);
        };
        /**
         * Returns the string "Matrix"
         */
        Matrix.prototype.getClassName = function () {
            return "Matrix";
        };
        /**
         * Returns the Matrix hash code.
         */
        Matrix.prototype.getHashCode = function () {
            var hash = this.m[0] || 0;
            for (var i = 1; i < 16; i++) {
                hash = (hash * 397) ^ (this.m[i] || 0);
            }
            return hash;
        };
        /**
         * Decomposes the current Matrix into :
         * - a scale vector3 passed as a reference to update,
         * - a rotation quaternion passed as a reference to update,
         * - a translation vector3 passed as a reference to update.
         * Returns the boolean `true`.
         */
        Matrix.prototype.decompose = function (scale, rotation, translation) {
            translation.x = this.m[12];
            translation.y = this.m[13];
            translation.z = this.m[14];
            scale.x = Math.sqrt(this.m[0] * this.m[0] + this.m[1] * this.m[1] + this.m[2] * this.m[2]);
            scale.y = Math.sqrt(this.m[4] * this.m[4] + this.m[5] * this.m[5] + this.m[6] * this.m[6]);
            scale.z = Math.sqrt(this.m[8] * this.m[8] + this.m[9] * this.m[9] + this.m[10] * this.m[10]);
            if (this.determinant() <= 0) {
                scale.y *= -1;
            }
            if (scale.x === 0 || scale.y === 0 || scale.z === 0) {
                rotation.x = 0;
                rotation.y = 0;
                rotation.z = 0;
                rotation.w = 1;
                return false;
            }
            Matrix.FromValuesToRef(this.m[0] / scale.x, this.m[1] / scale.x, this.m[2] / scale.x, 0, this.m[4] / scale.y, this.m[5] / scale.y, this.m[6] / scale.y, 0, this.m[8] / scale.z, this.m[9] / scale.z, this.m[10] / scale.z, 0, 0, 0, 0, 1, MathTmp.Matrix[0]);
            Quaternion.FromRotationMatrixToRef(MathTmp.Matrix[0], rotation);
            return true;
        };
        /**
         * Returns a new Matrix as the extracted rotation matrix from the current one.
         */
        Matrix.prototype.getRotationMatrix = function () {
            var result = Matrix.Identity();
            this.getRotationMatrixToRef(result);
            return result;
        };
        /**
         * Extracts the rotation matrix from the current one and sets it as the passed "result".
         * Returns the current Matrix.
         */
        Matrix.prototype.getRotationMatrixToRef = function (result) {
            var m = this.m;
            var xs = m[0] * m[1] * m[2] * m[3] < 0 ? -1 : 1;
            var ys = m[4] * m[5] * m[6] * m[7] < 0 ? -1 : 1;
            var zs = m[8] * m[9] * m[10] * m[11] < 0 ? -1 : 1;
            var sx = xs * Math.sqrt(m[0] * m[0] + m[1] * m[1] + m[2] * m[2]);
            var sy = ys * Math.sqrt(m[4] * m[4] + m[5] * m[5] + m[6] * m[6]);
            var sz = zs * Math.sqrt(m[8] * m[8] + m[9] * m[9] + m[10] * m[10]);
            Matrix.FromValuesToRef(m[0] / sx, m[1] / sx, m[2] / sx, 0, m[4] / sy, m[5] / sy, m[6] / sy, 0, m[8] / sz, m[9] / sz, m[10] / sz, 0, 0, 0, 0, 1, result);
            return this;
        };
        // Statics
        /**
         * Returns a new Matrix set from the starting index of the passed array.
         */
        Matrix.FromArray = function (array, offset) {
            var result = new Matrix();
            if (!offset) {
                offset = 0;
            }
            Matrix.FromArrayToRef(array, offset, result);
            return result;
        };
        /**
         * Sets the passed "result" matrix from the starting index of the passed array.
         */
        Matrix.FromArrayToRef = function (array, offset, result) {
            for (var index = 0; index < 16; index++) {
                result.m[index] = array[index + offset];
            }
            result._markAsUpdated();
        };
        /**
         * Sets the passed "result" matrix from the starting index of the passed Float32Array by multiplying each element by the float "scale".
         */
        Matrix.FromFloat32ArrayToRefScaled = function (array, offset, scale, result) {
            for (var index = 0; index < 16; index++) {
                result.m[index] = array[index + offset] * scale;
            }
            result._markAsUpdated();
        };
        /**
         * Sets the passed matrix "result" with the 16 passed floats.
         */
        Matrix.FromValuesToRef = function (initialM11, initialM12, initialM13, initialM14, initialM21, initialM22, initialM23, initialM24, initialM31, initialM32, initialM33, initialM34, initialM41, initialM42, initialM43, initialM44, result) {
            result.m[0] = initialM11;
            result.m[1] = initialM12;
            result.m[2] = initialM13;
            result.m[3] = initialM14;
            result.m[4] = initialM21;
            result.m[5] = initialM22;
            result.m[6] = initialM23;
            result.m[7] = initialM24;
            result.m[8] = initialM31;
            result.m[9] = initialM32;
            result.m[10] = initialM33;
            result.m[11] = initialM34;
            result.m[12] = initialM41;
            result.m[13] = initialM42;
            result.m[14] = initialM43;
            result.m[15] = initialM44;
            result._markAsUpdated();
        };
        /**
         * Returns the index-th row of the current matrix as a new Vector4.
         */
        Matrix.prototype.getRow = function (index) {
            if (index < 0 || index > 3) {
                return null;
            }
            var i = index * 4;
            return new Vector4(this.m[i + 0], this.m[i + 1], this.m[i + 2], this.m[i + 3]);
        };
        /**
         * Sets the index-th row of the current matrix with the passed Vector4 values.
         * Returns the updated Matrix.
         */
        Matrix.prototype.setRow = function (index, row) {
            if (index < 0 || index > 3) {
                return this;
            }
            var i = index * 4;
            this.m[i + 0] = row.x;
            this.m[i + 1] = row.y;
            this.m[i + 2] = row.z;
            this.m[i + 3] = row.w;
            this._markAsUpdated();
            return this;
        };
        /**
         * Compute the transpose of the matrix.
         * Returns a new Matrix.
         */
        Matrix.prototype.transpose = function () {
            return Matrix.Transpose(this);
        };
        /**
         * Compute the transpose of the matrix.
         * Returns the current matrix.
         */
        Matrix.prototype.transposeToRef = function (result) {
            Matrix.TransposeToRef(this, result);
            return this;
        };
        /**
         * Sets the index-th row of the current matrix with the passed 4 x float values.
         * Returns the updated Matrix.
         */
        Matrix.prototype.setRowFromFloats = function (index, x, y, z, w) {
            if (index < 0 || index > 3) {
                return this;
            }
            var i = index * 4;
            this.m[i + 0] = x;
            this.m[i + 1] = y;
            this.m[i + 2] = z;
            this.m[i + 3] = w;
            this._markAsUpdated();
            return this;
        };
        Object.defineProperty(Matrix, "IdentityReadOnly", {
            /**
             * Static identity matrix to be used as readonly matrix
             * Must not be updated.
             */
            get: function () {
                return Matrix._identityReadOnly;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * Returns a new Matrix set from the 16 passed floats.
         */
        Matrix.FromValues = function (initialM11, initialM12, initialM13, initialM14, initialM21, initialM22, initialM23, initialM24, initialM31, initialM32, initialM33, initialM34, initialM41, initialM42, initialM43, initialM44) {
            var result = new Matrix();
            result.m[0] = initialM11;
            result.m[1] = initialM12;
            result.m[2] = initialM13;
            result.m[3] = initialM14;
            result.m[4] = initialM21;
            result.m[5] = initialM22;
            result.m[6] = initialM23;
            result.m[7] = initialM24;
            result.m[8] = initialM31;
            result.m[9] = initialM32;
            result.m[10] = initialM33;
            result.m[11] = initialM34;
            result.m[12] = initialM41;
            result.m[13] = initialM42;
            result.m[14] = initialM43;
            result.m[15] = initialM44;
            return result;
        };
        /**
         * Returns a new Matrix composed by the passed scale (vector3), rotation (quaternion) and translation (vector3).
         */
        Matrix.Compose = function (scale, rotation, translation) {
            var result = Matrix.Identity();
            Matrix.ComposeToRef(scale, rotation, translation, result);
            return result;
        };
        /**
       * Update a Matrix with values composed by the passed scale (vector3), rotation (quaternion) and translation (vector3).
       */
        Matrix.ComposeToRef = function (scale, rotation, translation, result) {
            Matrix.FromValuesToRef(scale.x, 0, 0, 0, 0, scale.y, 0, 0, 0, 0, scale.z, 0, 0, 0, 0, 1, MathTmp.Matrix[1]);
            rotation.toRotationMatrix(MathTmp.Matrix[0]);
            MathTmp.Matrix[1].multiplyToRef(MathTmp.Matrix[0], result);
            result.setTranslation(translation);
        };
        /**
         * Returns a new indentity Matrix.
         */
        Matrix.Identity = function () {
            return Matrix.FromValues(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        };
        /**
         * Sets the passed "result" as an identity matrix.
         */
        Matrix.IdentityToRef = function (result) {
            Matrix.FromValuesToRef(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, result);
        };
        /**
         * Returns a new zero Matrix.
         */
        Matrix.Zero = function () {
            return Matrix.FromValues(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        };
        /**
         * Returns a new rotation matrix for "angle" radians around the X axis.
         */
        Matrix.RotationX = function (angle) {
            var result = new Matrix();
            Matrix.RotationXToRef(angle, result);
            return result;
        };
        /**
         * Returns a new Matrix as the passed inverted one.
         */
        Matrix.Invert = function (source) {
            var result = new Matrix();
            source.invertToRef(result);
            return result;
        };
        /**
         * Sets the passed matrix "result" as a rotation matrix for "angle" radians around the X axis.
         */
        Matrix.RotationXToRef = function (angle, result) {
            var s = Math.sin(angle);
            var c = Math.cos(angle);
            result.m[0] = 1.0;
            result.m[15] = 1.0;
            result.m[5] = c;
            result.m[10] = c;
            result.m[9] = -s;
            result.m[6] = s;
            result.m[1] = 0.0;
            result.m[2] = 0.0;
            result.m[3] = 0.0;
            result.m[4] = 0.0;
            result.m[7] = 0.0;
            result.m[8] = 0.0;
            result.m[11] = 0.0;
            result.m[12] = 0.0;
            result.m[13] = 0.0;
            result.m[14] = 0.0;
            result._markAsUpdated();
        };
        /**
         * Returns a new rotation matrix for "angle" radians around the Y axis.
         */
        Matrix.RotationY = function (angle) {
            var result = new Matrix();
            Matrix.RotationYToRef(angle, result);
            return result;
        };
        /**
         * Sets the passed matrix "result" as a rotation matrix for "angle" radians around the Y axis.
         */
        Matrix.RotationYToRef = function (angle, result) {
            var s = Math.sin(angle);
            var c = Math.cos(angle);
            result.m[5] = 1.0;
            result.m[15] = 1.0;
            result.m[0] = c;
            result.m[2] = -s;
            result.m[8] = s;
            result.m[10] = c;
            result.m[1] = 0.0;
            result.m[3] = 0.0;
            result.m[4] = 0.0;
            result.m[6] = 0.0;
            result.m[7] = 0.0;
            result.m[9] = 0.0;
            result.m[11] = 0.0;
            result.m[12] = 0.0;
            result.m[13] = 0.0;
            result.m[14] = 0.0;
            result._markAsUpdated();
        };
        /**
         * Returns a new rotation matrix for "angle" radians around the Z axis.
         */
        Matrix.RotationZ = function (angle) {
            var result = new Matrix();
            Matrix.RotationZToRef(angle, result);
            return result;
        };
        /**
         * Sets the passed matrix "result" as a rotation matrix for "angle" radians around the Z axis.
         */
        Matrix.RotationZToRef = function (angle, result) {
            var s = Math.sin(angle);
            var c = Math.cos(angle);
            result.m[10] = 1.0;
            result.m[15] = 1.0;
            result.m[0] = c;
            result.m[1] = s;
            result.m[4] = -s;
            result.m[5] = c;
            result.m[2] = 0.0;
            result.m[3] = 0.0;
            result.m[6] = 0.0;
            result.m[7] = 0.0;
            result.m[8] = 0.0;
            result.m[9] = 0.0;
            result.m[11] = 0.0;
            result.m[12] = 0.0;
            result.m[13] = 0.0;
            result.m[14] = 0.0;
            result._markAsUpdated();
        };
        /**
         * Returns a new rotation matrix for "angle" radians around the passed axis.
         */
        Matrix.RotationAxis = function (axis, angle) {
            var result = Matrix.Zero();
            Matrix.RotationAxisToRef(axis, angle, result);
            return result;
        };
        /**
         * Sets the passed matrix "result" as a rotation matrix for "angle" radians around the passed axis.
         */
        Matrix.RotationAxisToRef = function (axis, angle, result) {
            var s = Math.sin(-angle);
            var c = Math.cos(-angle);
            var c1 = 1 - c;
            axis.normalize();
            result.m[0] = (axis.x * axis.x) * c1 + c;
            result.m[1] = (axis.x * axis.y) * c1 - (axis.z * s);
            result.m[2] = (axis.x * axis.z) * c1 + (axis.y * s);
            result.m[3] = 0.0;
            result.m[4] = (axis.y * axis.x) * c1 + (axis.z * s);
            result.m[5] = (axis.y * axis.y) * c1 + c;
            result.m[6] = (axis.y * axis.z) * c1 - (axis.x * s);
            result.m[7] = 0.0;
            result.m[8] = (axis.z * axis.x) * c1 - (axis.y * s);
            result.m[9] = (axis.z * axis.y) * c1 + (axis.x * s);
            result.m[10] = (axis.z * axis.z) * c1 + c;
            result.m[11] = 0.0;
            result.m[15] = 1.0;
            result._markAsUpdated();
        };
        /**
         * Returns a new Matrix as a rotation matrix from the Euler angles (y, x, z).
         */
        Matrix.RotationYawPitchRoll = function (yaw, pitch, roll) {
            var result = new Matrix();
            Matrix.RotationYawPitchRollToRef(yaw, pitch, roll, result);
            return result;
        };
        /**
         * Sets the passed matrix "result" as a rotation matrix from the Euler angles (y, x, z).
         */
        Matrix.RotationYawPitchRollToRef = function (yaw, pitch, roll, result) {
            Quaternion.RotationYawPitchRollToRef(yaw, pitch, roll, this._tempQuaternion);
            this._tempQuaternion.toRotationMatrix(result);
        };
        /**
         * Returns a new Matrix as a scaling matrix from the passed floats (x, y, z).
         */
        Matrix.Scaling = function (x, y, z) {
            var result = Matrix.Zero();
            Matrix.ScalingToRef(x, y, z, result);
            return result;
        };
        /**
         * Sets the passed matrix "result" as a scaling matrix from the passed floats (x, y, z).
         */
        Matrix.ScalingToRef = function (x, y, z, result) {
            result.m[0] = x;
            result.m[1] = 0.0;
            result.m[2] = 0.0;
            result.m[3] = 0.0;
            result.m[4] = 0.0;
            result.m[5] = y;
            result.m[6] = 0.0;
            result.m[7] = 0.0;
            result.m[8] = 0.0;
            result.m[9] = 0.0;
            result.m[10] = z;
            result.m[11] = 0.0;
            result.m[12] = 0.0;
            result.m[13] = 0.0;
            result.m[14] = 0.0;
            result.m[15] = 1.0;
            result._markAsUpdated();
        };
        /**
         * Returns a new Matrix as a translation matrix from the passed floats (x, y, z).
         */
        Matrix.Translation = function (x, y, z) {
            var result = Matrix.Identity();
            Matrix.TranslationToRef(x, y, z, result);
            return result;
        };
        /**
         * Sets the passed matrix "result" as a translation matrix from the passed floats (x, y, z).
         */
        Matrix.TranslationToRef = function (x, y, z, result) {
            Matrix.FromValuesToRef(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, x, y, z, 1.0, result);
        };
        /**
         * Returns a new Matrix whose values are the interpolated values for "gradien" (float) between the ones of the matrices "startValue" and "endValue".
         */
        Matrix.Lerp = function (startValue, endValue, gradient) {
            var result = Matrix.Zero();
            for (var index = 0; index < 16; index++) {
                result.m[index] = startValue.m[index] * (1.0 - gradient) + endValue.m[index] * gradient;
            }
            result._markAsUpdated();
            return result;
        };
        /**
         * Returns a new Matrix whose values are computed by :
         * - decomposing the the "startValue" and "endValue" matrices into their respective scale, rotation and translation matrices,
         * - interpolating for "gradient" (float) the values between each of these decomposed matrices between the start and the end,
         * - recomposing a new matrix from these 3 interpolated scale, rotation and translation matrices.
         */
        Matrix.DecomposeLerp = function (startValue, endValue, gradient) {
            var startScale = new Vector3(0, 0, 0);
            var startRotation = new Quaternion();
            var startTranslation = new Vector3(0, 0, 0);
            startValue.decompose(startScale, startRotation, startTranslation);
            var endScale = new Vector3(0, 0, 0);
            var endRotation = new Quaternion();
            var endTranslation = new Vector3(0, 0, 0);
            endValue.decompose(endScale, endRotation, endTranslation);
            var resultScale = Vector3.Lerp(startScale, endScale, gradient);
            var resultRotation = Quaternion.Slerp(startRotation, endRotation, gradient);
            var resultTranslation = Vector3.Lerp(startTranslation, endTranslation, gradient);
            return Matrix.Compose(resultScale, resultRotation, resultTranslation);
        };
        /**
         * Returns a new rotation Matrix used to rotate a mesh so as it looks at the target Vector3, from the eye Vector3, the UP vector3 being orientated like "up".
         * This methods works for a Left-Handed system.
         */
        Matrix.LookAtLH = function (eye, target, up) {
            var result = Matrix.Zero();
            Matrix.LookAtLHToRef(eye, target, up, result);
            return result;
        };
        /**
         * Sets the passed "result" Matrix as a rotation matrix used to rotate a mesh so as it looks at the target Vector3, from the eye Vector3, the UP vector3 being orientated like "up".
         * This methods works for a Left-Handed system.
         */
        Matrix.LookAtLHToRef = function (eye, target, up, result) {
            // Z axis
            target.subtractToRef(eye, this._zAxis);
            this._zAxis.normalize();
            // X axis
            Vector3.CrossToRef(up, this._zAxis, this._xAxis);
            if (this._xAxis.lengthSquared() === 0) {
                this._xAxis.x = 1.0;
            }
            else {
                this._xAxis.normalize();
            }
            // Y axis
            Vector3.CrossToRef(this._zAxis, this._xAxis, this._yAxis);
            this._yAxis.normalize();
            // Eye angles
            var ex = -Vector3.Dot(this._xAxis, eye);
            var ey = -Vector3.Dot(this._yAxis, eye);
            var ez = -Vector3.Dot(this._zAxis, eye);
            return Matrix.FromValuesToRef(this._xAxis.x, this._yAxis.x, this._zAxis.x, 0, this._xAxis.y, this._yAxis.y, this._zAxis.y, 0, this._xAxis.z, this._yAxis.z, this._zAxis.z, 0, ex, ey, ez, 1, result);
        };
        /**
         * Returns a new rotation Matrix used to rotate a mesh so as it looks at the target Vector3, from the eye Vector3, the UP vector3 being orientated like "up".
         * This methods works for a Right-Handed system.
         */
        Matrix.LookAtRH = function (eye, target, up) {
            var result = Matrix.Zero();
            Matrix.LookAtRHToRef(eye, target, up, result);
            return result;
        };
        /**
         * Sets the passed "result" Matrix as a rotation matrix used to rotate a mesh so as it looks at the target Vector3, from the eye Vector3, the UP vector3 being orientated like "up".
         * This methods works for a Left-Handed system.
         */
        Matrix.LookAtRHToRef = function (eye, target, up, result) {
            // Z axis
            eye.subtractToRef(target, this._zAxis);
            this._zAxis.normalize();
            // X axis
            Vector3.CrossToRef(up, this._zAxis, this._xAxis);
            if (this._xAxis.lengthSquared() === 0) {
                this._xAxis.x = 1.0;
            }
            else {
                this._xAxis.normalize();
            }
            // Y axis
            Vector3.CrossToRef(this._zAxis, this._xAxis, this._yAxis);
            this._yAxis.normalize();
            // Eye angles
            var ex = -Vector3.Dot(this._xAxis, eye);
            var ey = -Vector3.Dot(this._yAxis, eye);
            var ez = -Vector3.Dot(this._zAxis, eye);
            return Matrix.FromValuesToRef(this._xAxis.x, this._yAxis.x, this._zAxis.x, 0, this._xAxis.y, this._yAxis.y, this._zAxis.y, 0, this._xAxis.z, this._yAxis.z, this._zAxis.z, 0, ex, ey, ez, 1, result);
        };
        /**
         * Returns a new Matrix as a left-handed orthographic projection matrix computed from the passed floats : width and height of the projection plane, z near and far limits.
         */
        Matrix.OrthoLH = function (width, height, znear, zfar) {
            var matrix = Matrix.Zero();
            Matrix.OrthoLHToRef(width, height, znear, zfar, matrix);
            return matrix;
        };
        /**
         * Sets the passed matrix "result" as a left-handed orthographic projection matrix computed from the passed floats : width and height of the projection plane, z near and far limits.
         */
        Matrix.OrthoLHToRef = function (width, height, znear, zfar, result) {
            var n = znear;
            var f = zfar;
            var a = 2.0 / width;
            var b = 2.0 / height;
            var c = 2.0 / (f - n);
            var d = -(f + n) / (f - n);
            BABYLON.Matrix.FromValuesToRef(a, 0.0, 0.0, 0.0, 0.0, b, 0.0, 0.0, 0.0, 0.0, c, 0.0, 0.0, 0.0, d, 1.0, result);
        };
        /**
         * Returns a new Matrix as a left-handed orthographic projection matrix computed from the passed floats : left, right, top and bottom being the coordinates of the projection plane, z near and far limits.
         */
        Matrix.OrthoOffCenterLH = function (left, right, bottom, top, znear, zfar) {
            var matrix = Matrix.Zero();
            Matrix.OrthoOffCenterLHToRef(left, right, bottom, top, znear, zfar, matrix);
            return matrix;
        };
        /**
         * Sets the passed matrix "result" as a left-handed orthographic projection matrix computed from the passed floats : left, right, top and bottom being the coordinates of the projection plane, z near and far limits.
         */
        Matrix.OrthoOffCenterLHToRef = function (left, right, bottom, top, znear, zfar, result) {
            var n = znear;
            var f = zfar;
            var a = 2.0 / (right - left);
            var b = 2.0 / (top - bottom);
            var c = 2.0 / (f - n);
            var d = -(f + n) / (f - n);
            var i0 = (left + right) / (left - right);
            var i1 = (top + bottom) / (bottom - top);
            BABYLON.Matrix.FromValuesToRef(a, 0.0, 0.0, 0.0, 0.0, b, 0.0, 0.0, 0.0, 0.0, c, 0.0, i0, i1, d, 1.0, result);
        };
        /**
         * Returns a new Matrix as a right-handed orthographic projection matrix computed from the passed floats : left, right, top and bottom being the coordinates of the projection plane, z near and far limits.
         */
        Matrix.OrthoOffCenterRH = function (left, right, bottom, top, znear, zfar) {
            var matrix = Matrix.Zero();
            Matrix.OrthoOffCenterRHToRef(left, right, bottom, top, znear, zfar, matrix);
            return matrix;
        };
        /**
         * Sets the passed matrix "result" as a right-handed orthographic projection matrix computed from the passed floats : left, right, top and bottom being the coordinates of the projection plane, z near and far limits.
         */
        Matrix.OrthoOffCenterRHToRef = function (left, right, bottom, top, znear, zfar, result) {
            Matrix.OrthoOffCenterLHToRef(left, right, bottom, top, znear, zfar, result);
            result.m[10] *= -1.0;
        };
        /**
         * Returns a new Matrix as a left-handed perspective projection matrix computed from the passed floats : width and height of the projection plane, z near and far limits.
         */
        Matrix.PerspectiveLH = function (width, height, znear, zfar) {
            var matrix = Matrix.Zero();
            var n = znear;
            var f = zfar;
            var a = 2.0 * n / width;
            var b = 2.0 * n / height;
            var c = (f + n) / (f - n);
            var d = -2.0 * f * n / (f - n);
            BABYLON.Matrix.FromValuesToRef(a, 0.0, 0.0, 0.0, 0.0, b, 0.0, 0.0, 0.0, 0.0, c, 1.0, 0.0, 0.0, d, 0.0, matrix);
            return matrix;
        };
        /**
         * Returns a new Matrix as a left-handed perspective projection matrix computed from the passed floats : vertical angle of view (fov), width/height ratio (aspect), z near and far limits.
         */
        Matrix.PerspectiveFovLH = function (fov, aspect, znear, zfar) {
            var matrix = Matrix.Zero();
            Matrix.PerspectiveFovLHToRef(fov, aspect, znear, zfar, matrix);
            return matrix;
        };
        /**
         * Sets the passed matrix "result" as a left-handed perspective projection matrix computed from the passed floats : vertical angle of view (fov), width/height ratio (aspect), z near and far limits.
         */
        Matrix.PerspectiveFovLHToRef = function (fov, aspect, znear, zfar, result, isVerticalFovFixed) {
            if (isVerticalFovFixed === void 0) { isVerticalFovFixed = true; }
            var n = znear;
            var f = zfar;
            var t = 1.0 / (Math.tan(fov * 0.5));
            var a = isVerticalFovFixed ? (t / aspect) : t;
            var b = isVerticalFovFixed ? t : (t * aspect);
            var c = (f + n) / (f - n);
            var d = -2.0 * f * n / (f - n);
            BABYLON.Matrix.FromValuesToRef(a, 0.0, 0.0, 0.0, 0.0, b, 0.0, 0.0, 0.0, 0.0, c, 1.0, 0.0, 0.0, d, 0.0, result);
        };
        /**
         * Returns a new Matrix as a right-handed perspective projection matrix computed from the passed floats : vertical angle of view (fov), width/height ratio (aspect), z near and far limits.
         */
        Matrix.PerspectiveFovRH = function (fov, aspect, znear, zfar) {
            var matrix = Matrix.Zero();
            Matrix.PerspectiveFovRHToRef(fov, aspect, znear, zfar, matrix);
            return matrix;
        };
        /**
         * Sets the passed matrix "result" as a right-handed perspective projection matrix computed from the passed floats : vertical angle of view (fov), width/height ratio (aspect), z near and far limits.
         */
        Matrix.PerspectiveFovRHToRef = function (fov, aspect, znear, zfar, result, isVerticalFovFixed) {
            //alternatively this could be expressed as:
            //    m = PerspectiveFovLHToRef
            //    m[10] *= -1.0;
            //    m[11] *= -1.0;
            if (isVerticalFovFixed === void 0) { isVerticalFovFixed = true; }
            var n = znear;
            var f = zfar;
            var t = 1.0 / (Math.tan(fov * 0.5));
            var a = isVerticalFovFixed ? (t / aspect) : t;
            var b = isVerticalFovFixed ? t : (t * aspect);
            var c = -(f + n) / (f - n);
            var d = -2 * f * n / (f - n);
            BABYLON.Matrix.FromValuesToRef(a, 0.0, 0.0, 0.0, 0.0, b, 0.0, 0.0, 0.0, 0.0, c, -1.0, 0.0, 0.0, d, 0.0, result);
        };
        /**
         * Sets the passed matrix "result" as a left-handed perspective projection matrix  for WebVR computed from the passed floats : vertical angle of view (fov), width/height ratio (aspect), z near and far limits.
         */
        Matrix.PerspectiveFovWebVRToRef = function (fov, znear, zfar, result, rightHanded) {
            if (rightHanded === void 0) { rightHanded = false; }
            var rightHandedFactor = rightHanded ? -1 : 1;
            var upTan = Math.tan(fov.upDegrees * Math.PI / 180.0);
            var downTan = Math.tan(fov.downDegrees * Math.PI / 180.0);
            var leftTan = Math.tan(fov.leftDegrees * Math.PI / 180.0);
            var rightTan = Math.tan(fov.rightDegrees * Math.PI / 180.0);
            var xScale = 2.0 / (leftTan + rightTan);
            var yScale = 2.0 / (upTan + downTan);
            result.m[0] = xScale;
            result.m[1] = result.m[2] = result.m[3] = result.m[4] = 0.0;
            result.m[5] = yScale;
            result.m[6] = result.m[7] = 0.0;
            result.m[8] = ((leftTan - rightTan) * xScale * 0.5); // * rightHandedFactor;
            result.m[9] = -((upTan - downTan) * yScale * 0.5); // * rightHandedFactor;
            //result.m[10] = -(znear + zfar) / (zfar - znear) * rightHandedFactor;
            result.m[10] = -zfar / (znear - zfar);
            result.m[11] = 1.0 * rightHandedFactor;
            result.m[12] = result.m[13] = result.m[15] = 0.0;
            result.m[14] = -(2.0 * zfar * znear) / (zfar - znear);
            // result.m[14] = (znear * zfar) / (znear - zfar);
            result._markAsUpdated();
        };
        /**
         * Returns the final transformation matrix : world * view * projection * viewport
         */
        Matrix.GetFinalMatrix = function (viewport, world, view, projection, zmin, zmax) {
            var cw = viewport.width;
            var ch = viewport.height;
            var cx = viewport.x;
            var cy = viewport.y;
            var viewportMatrix = Matrix.FromValues(cw / 2.0, 0.0, 0.0, 0.0, 0.0, -ch / 2.0, 0.0, 0.0, 0.0, 0.0, zmax - zmin, 0.0, cx + cw / 2.0, ch / 2.0 + cy, zmin, 1);
            return world.multiply(view).multiply(projection).multiply(viewportMatrix);
        };
        /**
         * Returns a new Float32Array array with 4 elements : the 2x2 matrix extracted from the passed Matrix.
         */
        Matrix.GetAsMatrix2x2 = function (matrix) {
            return new Float32Array([
                matrix.m[0], matrix.m[1],
                matrix.m[4], matrix.m[5]
            ]);
        };
        /**
         * Returns a new Float32Array array with 9 elements : the 3x3 matrix extracted from the passed Matrix.
         */
        Matrix.GetAsMatrix3x3 = function (matrix) {
            return new Float32Array([
                matrix.m[0], matrix.m[1], matrix.m[2],
                matrix.m[4], matrix.m[5], matrix.m[6],
                matrix.m[8], matrix.m[9], matrix.m[10]
            ]);
        };
        /**
         * Compute the transpose of the passed Matrix.
         * Returns a new Matrix.
         */
        Matrix.Transpose = function (matrix) {
            var result = new Matrix();
            Matrix.TransposeToRef(matrix, result);
            return result;
        };
        /**
         * Compute the transpose of the passed Matrix and store it in the result matrix.
         */
        Matrix.TransposeToRef = function (matrix, result) {
            result.m[0] = matrix.m[0];
            result.m[1] = matrix.m[4];
            result.m[2] = matrix.m[8];
            result.m[3] = matrix.m[12];
            result.m[4] = matrix.m[1];
            result.m[5] = matrix.m[5];
            result.m[6] = matrix.m[9];
            result.m[7] = matrix.m[13];
            result.m[8] = matrix.m[2];
            result.m[9] = matrix.m[6];
            result.m[10] = matrix.m[10];
            result.m[11] = matrix.m[14];
            result.m[12] = matrix.m[3];
            result.m[13] = matrix.m[7];
            result.m[14] = matrix.m[11];
            result.m[15] = matrix.m[15];
        };
        /**
         * Returns a new Matrix as the reflection  matrix across the passed plane.
         */
        Matrix.Reflection = function (plane) {
            var matrix = new Matrix();
            Matrix.ReflectionToRef(plane, matrix);
            return matrix;
        };
        /**
         * Sets the passed matrix "result" as the reflection matrix across the passed plane.
         */
        Matrix.ReflectionToRef = function (plane, result) {
            plane.normalize();
            var x = plane.normal.x;
            var y = plane.normal.y;
            var z = plane.normal.z;
            var temp = -2 * x;
            var temp2 = -2 * y;
            var temp3 = -2 * z;
            result.m[0] = (temp * x) + 1;
            result.m[1] = temp2 * x;
            result.m[2] = temp3 * x;
            result.m[3] = 0.0;
            result.m[4] = temp * y;
            result.m[5] = (temp2 * y) + 1;
            result.m[6] = temp3 * y;
            result.m[7] = 0.0;
            result.m[8] = temp * z;
            result.m[9] = temp2 * z;
            result.m[10] = (temp3 * z) + 1;
            result.m[11] = 0.0;
            result.m[12] = temp * plane.d;
            result.m[13] = temp2 * plane.d;
            result.m[14] = temp3 * plane.d;
            result.m[15] = 1.0;
            result._markAsUpdated();
        };
        /**
         * Sets the passed matrix "mat" as a rotation matrix composed from the 3 passed  left handed axis.
         */
        Matrix.FromXYZAxesToRef = function (xaxis, yaxis, zaxis, result) {
            result.m[0] = xaxis.x;
            result.m[1] = xaxis.y;
            result.m[2] = xaxis.z;
            result.m[3] = 0.0;
            result.m[4] = yaxis.x;
            result.m[5] = yaxis.y;
            result.m[6] = yaxis.z;
            result.m[7] = 0.0;
            result.m[8] = zaxis.x;
            result.m[9] = zaxis.y;
            result.m[10] = zaxis.z;
            result.m[11] = 0.0;
            result.m[12] = 0.0;
            result.m[13] = 0.0;
            result.m[14] = 0.0;
            result.m[15] = 1.0;
            result._markAsUpdated();
        };
        /**
         * Sets the passed matrix "result" as a rotation matrix according to the passed quaternion.
         */
        Matrix.FromQuaternionToRef = function (quat, result) {
            var xx = quat.x * quat.x;
            var yy = quat.y * quat.y;
            var zz = quat.z * quat.z;
            var xy = quat.x * quat.y;
            var zw = quat.z * quat.w;
            var zx = quat.z * quat.x;
            var yw = quat.y * quat.w;
            var yz = quat.y * quat.z;
            var xw = quat.x * quat.w;
            result.m[0] = 1.0 - (2.0 * (yy + zz));
            result.m[1] = 2.0 * (xy + zw);
            result.m[2] = 2.0 * (zx - yw);
            result.m[3] = 0.0;
            result.m[4] = 2.0 * (xy - zw);
            result.m[5] = 1.0 - (2.0 * (zz + xx));
            result.m[6] = 2.0 * (yz + xw);
            result.m[7] = 0.0;
            result.m[8] = 2.0 * (zx + yw);
            result.m[9] = 2.0 * (yz - xw);
            result.m[10] = 1.0 - (2.0 * (yy + xx));
            result.m[11] = 0.0;
            result.m[12] = 0.0;
            result.m[13] = 0.0;
            result.m[14] = 0.0;
            result.m[15] = 1.0;
            result._markAsUpdated();
        };
        Matrix._tempQuaternion = new Quaternion();
        Matrix._xAxis = Vector3.Zero();
        Matrix._yAxis = Vector3.Zero();
        Matrix._zAxis = Vector3.Zero();
        Matrix._updateFlagSeed = 0;
        Matrix._identityReadOnly = Matrix.Identity();
        return Matrix;
    }());
    BABYLON.Matrix = Matrix;
    var Plane = /** @class */ (function () {
        /**
         * Creates a Plane object according to the passed floats a, b, c, d and the plane equation : ax + by + cz + d = 0
         */
        function Plane(a, b, c, d) {
            this.normal = new Vector3(a, b, c);
            this.d = d;
        }
        /**
         * Returns the plane coordinates as a new array of 4 elements [a, b, c, d].
         */
        Plane.prototype.asArray = function () {
            return [this.normal.x, this.normal.y, this.normal.z, this.d];
        };
        // Methods
        /**
         * Returns a new plane copied from the current Plane.
         */
        Plane.prototype.clone = function () {
            return new Plane(this.normal.x, this.normal.y, this.normal.z, this.d);
        };
        /**
         * Returns the string "Plane".
         */
        Plane.prototype.getClassName = function () {
            return "Plane";
        };
        /**
         * Returns the Plane hash code.
         */
        Plane.prototype.getHashCode = function () {
            var hash = this.normal.getHashCode();
            hash = (hash * 397) ^ (this.d || 0);
            return hash;
        };
        /**
         * Normalize the current Plane in place.
         * Returns the updated Plane.
         */
        Plane.prototype.normalize = function () {
            var norm = (Math.sqrt((this.normal.x * this.normal.x) + (this.normal.y * this.normal.y) + (this.normal.z * this.normal.z)));
            var magnitude = 0.0;
            if (norm !== 0) {
                magnitude = 1.0 / norm;
            }
            this.normal.x *= magnitude;
            this.normal.y *= magnitude;
            this.normal.z *= magnitude;
            this.d *= magnitude;
            return this;
        };
        /**
         * Returns a new Plane as the result of the transformation of the current Plane by the passed matrix.
         */
        Plane.prototype.transform = function (transformation) {
            var transposedMatrix = Matrix.Transpose(transformation);
            var x = this.normal.x;
            var y = this.normal.y;
            var z = this.normal.z;
            var d = this.d;
            var normalX = (((x * transposedMatrix.m[0]) + (y * transposedMatrix.m[1])) + (z * transposedMatrix.m[2])) + (d * transposedMatrix.m[3]);
            var normalY = (((x * transposedMatrix.m[4]) + (y * transposedMatrix.m[5])) + (z * transposedMatrix.m[6])) + (d * transposedMatrix.m[7]);
            var normalZ = (((x * transposedMatrix.m[8]) + (y * transposedMatrix.m[9])) + (z * transposedMatrix.m[10])) + (d * transposedMatrix.m[11]);
            var finalD = (((x * transposedMatrix.m[12]) + (y * transposedMatrix.m[13])) + (z * transposedMatrix.m[14])) + (d * transposedMatrix.m[15]);
            return new Plane(normalX, normalY, normalZ, finalD);
        };
        /**
         * Returns the dot product (float) of the point coordinates and the plane normal.
         */
        Plane.prototype.dotCoordinate = function (point) {
            return ((((this.normal.x * point.x) + (this.normal.y * point.y)) + (this.normal.z * point.z)) + this.d);
        };
        /**
         * Updates the current Plane from the plane defined by the three passed points.
         * Returns the updated Plane.
         */
        Plane.prototype.copyFromPoints = function (point1, point2, point3) {
            var x1 = point2.x - point1.x;
            var y1 = point2.y - point1.y;
            var z1 = point2.z - point1.z;
            var x2 = point3.x - point1.x;
            var y2 = point3.y - point1.y;
            var z2 = point3.z - point1.z;
            var yz = (y1 * z2) - (z1 * y2);
            var xz = (z1 * x2) - (x1 * z2);
            var xy = (x1 * y2) - (y1 * x2);
            var pyth = (Math.sqrt((yz * yz) + (xz * xz) + (xy * xy)));
            var invPyth;
            if (pyth !== 0) {
                invPyth = 1.0 / pyth;
            }
            else {
                invPyth = 0.0;
            }
            this.normal.x = yz * invPyth;
            this.normal.y = xz * invPyth;
            this.normal.z = xy * invPyth;
            this.d = -((this.normal.x * point1.x) + (this.normal.y * point1.y) + (this.normal.z * point1.z));
            return this;
        };
        /**
         * Boolean : True is the vector "direction"  is the same side than the plane normal.
         */
        Plane.prototype.isFrontFacingTo = function (direction, epsilon) {
            var dot = Vector3.Dot(this.normal, direction);
            return (dot <= epsilon);
        };
        /**
         * Returns the signed distance (float) from the passed point to the Plane.
         */
        Plane.prototype.signedDistanceTo = function (point) {
            return Vector3.Dot(point, this.normal) + this.d;
        };
        // Statics
        /**
         * Returns a new Plane from the passed array.
         */
        Plane.FromArray = function (array) {
            return new Plane(array[0], array[1], array[2], array[3]);
        };
        /**
         * Returns a new Plane defined by the three passed points.
         */
        Plane.FromPoints = function (point1, point2, point3) {
            var result = new Plane(0.0, 0.0, 0.0, 0.0);
            result.copyFromPoints(point1, point2, point3);
            return result;
        };
        /**
         * Returns a new Plane the normal vector to this plane at the passed origin point.
         * Note : the vector "normal" is updated because normalized.
         */
        Plane.FromPositionAndNormal = function (origin, normal) {
            var result = new Plane(0.0, 0.0, 0.0, 0.0);
            normal.normalize();
            result.normal = normal;
            result.d = -(normal.x * origin.x + normal.y * origin.y + normal.z * origin.z);
            return result;
        };
        /**
         * Returns the signed distance between the plane defined by the normal vector at the "origin"" point and the passed other point.
         */
        Plane.SignedDistanceToPlaneFromPositionAndNormal = function (origin, normal, point) {
            var d = -(normal.x * origin.x + normal.y * origin.y + normal.z * origin.z);
            return Vector3.Dot(point, normal) + d;
        };
        return Plane;
    }());
    BABYLON.Plane = Plane;
    var Viewport = /** @class */ (function () {
        /**
         * Creates a Viewport object located at (x, y) and sized (width, height).
         */
        function Viewport(x, y, width, height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }
        Viewport.prototype.toGlobal = function (renderWidthOrEngine, renderHeight) {
            if (renderWidthOrEngine.getRenderWidth) {
                var engine = renderWidthOrEngine;
                return this.toGlobal(engine.getRenderWidth(), engine.getRenderHeight());
            }
            var renderWidth = renderWidthOrEngine;
            return new Viewport(this.x * renderWidth, this.y * renderHeight, this.width * renderWidth, this.height * renderHeight);
        };
        /**
         * Returns a new Viewport copied from the current one.
         */
        Viewport.prototype.clone = function () {
            return new Viewport(this.x, this.y, this.width, this.height);
        };
        return Viewport;
    }());
    BABYLON.Viewport = Viewport;
    var Frustum = /** @class */ (function () {
        function Frustum() {
        }
        /**
         * Returns a new array of 6 Frustum planes computed by the passed transformation matrix.
         */
        Frustum.GetPlanes = function (transform) {
            var frustumPlanes = [];
            for (var index = 0; index < 6; index++) {
                frustumPlanes.push(new Plane(0.0, 0.0, 0.0, 0.0));
            }
            Frustum.GetPlanesToRef(transform, frustumPlanes);
            return frustumPlanes;
        };
        Frustum.GetNearPlaneToRef = function (transform, frustumPlane) {
            frustumPlane.normal.x = transform.m[3] + transform.m[2];
            frustumPlane.normal.y = transform.m[7] + transform.m[6];
            frustumPlane.normal.z = transform.m[11] + transform.m[10];
            frustumPlane.d = transform.m[15] + transform.m[14];
            frustumPlane.normalize();
        };
        Frustum.GetFarPlaneToRef = function (transform, frustumPlane) {
            frustumPlane.normal.x = transform.m[3] - transform.m[2];
            frustumPlane.normal.y = transform.m[7] - transform.m[6];
            frustumPlane.normal.z = transform.m[11] - transform.m[10];
            frustumPlane.d = transform.m[15] - transform.m[14];
            frustumPlane.normalize();
        };
        Frustum.GetLeftPlaneToRef = function (transform, frustumPlane) {
            frustumPlane.normal.x = transform.m[3] + transform.m[0];
            frustumPlane.normal.y = transform.m[7] + transform.m[4];
            frustumPlane.normal.z = transform.m[11] + transform.m[8];
            frustumPlane.d = transform.m[15] + transform.m[12];
            frustumPlane.normalize();
        };
        Frustum.GetRightPlaneToRef = function (transform, frustumPlane) {
            frustumPlane.normal.x = transform.m[3] - transform.m[0];
            frustumPlane.normal.y = transform.m[7] - transform.m[4];
            frustumPlane.normal.z = transform.m[11] - transform.m[8];
            frustumPlane.d = transform.m[15] - transform.m[12];
            frustumPlane.normalize();
        };
        Frustum.GetTopPlaneToRef = function (transform, frustumPlane) {
            frustumPlane.normal.x = transform.m[3] - transform.m[1];
            frustumPlane.normal.y = transform.m[7] - transform.m[5];
            frustumPlane.normal.z = transform.m[11] - transform.m[9];
            frustumPlane.d = transform.m[15] - transform.m[13];
            frustumPlane.normalize();
        };
        Frustum.GetBottomPlaneToRef = function (transform, frustumPlane) {
            frustumPlane.normal.x = transform.m[3] + transform.m[1];
            frustumPlane.normal.y = transform.m[7] + transform.m[5];
            frustumPlane.normal.z = transform.m[11] + transform.m[9];
            frustumPlane.d = transform.m[15] + transform.m[13];
            frustumPlane.normalize();
        };
        /**
         * Sets the passed array "frustumPlanes" with the 6 Frustum planes computed by the passed transformation matrix.
         */
        Frustum.GetPlanesToRef = function (transform, frustumPlanes) {
            // Near
            Frustum.GetNearPlaneToRef(transform, frustumPlanes[0]);
            // Far
            Frustum.GetFarPlaneToRef(transform, frustumPlanes[1]);
            // Left
            Frustum.GetLeftPlaneToRef(transform, frustumPlanes[2]);
            // Right
            Frustum.GetRightPlaneToRef(transform, frustumPlanes[3]);
            // Top
            Frustum.GetTopPlaneToRef(transform, frustumPlanes[4]);
            // Bottom
            Frustum.GetBottomPlaneToRef(transform, frustumPlanes[5]);
        };
        return Frustum;
    }());
    BABYLON.Frustum = Frustum;
    var Space;
    (function (Space) {
        Space[Space["LOCAL"] = 0] = "LOCAL";
        Space[Space["WORLD"] = 1] = "WORLD";
        Space[Space["BONE"] = 2] = "BONE";
    })(Space = BABYLON.Space || (BABYLON.Space = {}));
    var Axis = /** @class */ (function () {
        function Axis() {
        }
        Axis.X = new Vector3(1.0, 0.0, 0.0);
        Axis.Y = new Vector3(0.0, 1.0, 0.0);
        Axis.Z = new Vector3(0.0, 0.0, 1.0);
        return Axis;
    }());
    BABYLON.Axis = Axis;
    ;
    var BezierCurve = /** @class */ (function () {
        function BezierCurve() {
        }
        /**
         * Returns the cubic Bezier interpolated value (float) at "t" (float) from the passed x1, y1, x2, y2 floats.
         */
        BezierCurve.interpolate = function (t, x1, y1, x2, y2) {
            // Extract X (which is equal to time here)
            var f0 = 1 - 3 * x2 + 3 * x1;
            var f1 = 3 * x2 - 6 * x1;
            var f2 = 3 * x1;
            var refinedT = t;
            for (var i = 0; i < 5; i++) {
                var refinedT2 = refinedT * refinedT;
                var refinedT3 = refinedT2 * refinedT;
                var x = f0 * refinedT3 + f1 * refinedT2 + f2 * refinedT;
                var slope = 1.0 / (3.0 * f0 * refinedT2 + 2.0 * f1 * refinedT + f2);
                refinedT -= (x - t) * slope;
                refinedT = Math.min(1, Math.max(0, refinedT));
            }
            // Resolve cubic bezier for the given x
            return 3 * Math.pow(1 - refinedT, 2) * refinedT * y1 +
                3 * (1 - refinedT) * Math.pow(refinedT, 2) * y2 +
                Math.pow(refinedT, 3);
        };
        return BezierCurve;
    }());
    BABYLON.BezierCurve = BezierCurve;
    var Orientation;
    (function (Orientation) {
        Orientation[Orientation["CW"] = 0] = "CW";
        Orientation[Orientation["CCW"] = 1] = "CCW";
    })(Orientation = BABYLON.Orientation || (BABYLON.Orientation = {}));
    var Angle = /** @class */ (function () {
        /**
         * Creates an Angle object of "radians" radians (float).
         */
        function Angle(radians) {
            var _this = this;
            /**
             * Returns the Angle value in degrees (float).
             */
            this.degrees = function () { return _this._radians * 180.0 / Math.PI; };
            /**
             * Returns the Angle value in radians (float).
             */
            this.radians = function () { return _this._radians; };
            this._radians = radians;
            if (this._radians < 0.0)
                this._radians += (2.0 * Math.PI);
        }
        /**
         * Returns a new Angle object valued with the angle value in radians between the two passed vectors.
         */
        Angle.BetweenTwoPoints = function (a, b) {
            var delta = b.subtract(a);
            var theta = Math.atan2(delta.y, delta.x);
            return new Angle(theta);
        };
        /**
         * Returns a new Angle object from the passed float in radians.
         */
        Angle.FromRadians = function (radians) {
            return new Angle(radians);
        };
        /**
         * Returns a new Angle object from the passed float in degrees.
         */
        Angle.FromDegrees = function (degrees) {
            return new Angle(degrees * Math.PI / 180.0);
        };
        return Angle;
    }());
    BABYLON.Angle = Angle;
    var Arc2 = /** @class */ (function () {
        /**
         * Creates an Arc object from the three passed points : start, middle and end.
         */
        function Arc2(startPoint, midPoint, endPoint) {
            this.startPoint = startPoint;
            this.midPoint = midPoint;
            this.endPoint = endPoint;
            var temp = Math.pow(midPoint.x, 2) + Math.pow(midPoint.y, 2);
            var startToMid = (Math.pow(startPoint.x, 2) + Math.pow(startPoint.y, 2) - temp) / 2.;
            var midToEnd = (temp - Math.pow(endPoint.x, 2) - Math.pow(endPoint.y, 2)) / 2.;
            var det = (startPoint.x - midPoint.x) * (midPoint.y - endPoint.y) - (midPoint.x - endPoint.x) * (startPoint.y - midPoint.y);
            this.centerPoint = new Vector2((startToMid * (midPoint.y - endPoint.y) - midToEnd * (startPoint.y - midPoint.y)) / det, ((startPoint.x - midPoint.x) * midToEnd - (midPoint.x - endPoint.x) * startToMid) / det);
            this.radius = this.centerPoint.subtract(this.startPoint).length();
            this.startAngle = Angle.BetweenTwoPoints(this.centerPoint, this.startPoint);
            var a1 = this.startAngle.degrees();
            var a2 = Angle.BetweenTwoPoints(this.centerPoint, this.midPoint).degrees();
            var a3 = Angle.BetweenTwoPoints(this.centerPoint, this.endPoint).degrees();
            // angles correction
            if (a2 - a1 > +180.0)
                a2 -= 360.0;
            if (a2 - a1 < -180.0)
                a2 += 360.0;
            if (a3 - a2 > +180.0)
                a3 -= 360.0;
            if (a3 - a2 < -180.0)
                a3 += 360.0;
            this.orientation = (a2 - a1) < 0 ? Orientation.CW : Orientation.CCW;
            this.angle = Angle.FromDegrees(this.orientation === Orientation.CW ? a1 - a3 : a3 - a1);
        }
        return Arc2;
    }());
    BABYLON.Arc2 = Arc2;
    var Path2 = /** @class */ (function () {
        /**
         * Creates a Path2 object from the starting 2D coordinates x and y.
         */
        function Path2(x, y) {
            this._points = new Array();
            this._length = 0.0;
            this.closed = false;
            this._points.push(new Vector2(x, y));
        }
        /**
         * Adds a new segment until the passed coordinates (x, y) to the current Path2.
         * Returns the updated Path2.
         */
        Path2.prototype.addLineTo = function (x, y) {
            if (this.closed) {
                //Tools.Error("cannot add lines to closed paths");
                return this;
            }
            var newPoint = new Vector2(x, y);
            var previousPoint = this._points[this._points.length - 1];
            this._points.push(newPoint);
            this._length += newPoint.subtract(previousPoint).length();
            return this;
        };
        /**
         * Adds _numberOfSegments_ segments according to the arc definition (middle point coordinates, end point coordinates, the arc start point being the current Path2 last point) to the current Path2.
         * Returns the updated Path2.
         */
        Path2.prototype.addArcTo = function (midX, midY, endX, endY, numberOfSegments) {
            if (numberOfSegments === void 0) { numberOfSegments = 36; }
            if (this.closed) {
                //Tools.Error("cannot add arcs to closed paths");
                return this;
            }
            var startPoint = this._points[this._points.length - 1];
            var midPoint = new Vector2(midX, midY);
            var endPoint = new Vector2(endX, endY);
            var arc = new Arc2(startPoint, midPoint, endPoint);
            var increment = arc.angle.radians() / numberOfSegments;
            if (arc.orientation === Orientation.CW)
                increment *= -1;
            var currentAngle = arc.startAngle.radians() + increment;
            for (var i = 0; i < numberOfSegments; i++) {
                var x = Math.cos(currentAngle) * arc.radius + arc.centerPoint.x;
                var y = Math.sin(currentAngle) * arc.radius + arc.centerPoint.y;
                this.addLineTo(x, y);
                currentAngle += increment;
            }
            return this;
        };
        /**
         * Closes the Path2.
         * Returns the Path2.
         */
        Path2.prototype.close = function () {
            this.closed = true;
            return this;
        };
        /**
         * Returns the Path2 total length (float).
         */
        Path2.prototype.length = function () {
            var result = this._length;
            if (!this.closed) {
                var lastPoint = this._points[this._points.length - 1];
                var firstPoint = this._points[0];
                result += (firstPoint.subtract(lastPoint).length());
            }
            return result;
        };
        /**
         * Returns the Path2 internal array of points.
         */
        Path2.prototype.getPoints = function () {
            return this._points;
        };
        /**
         * Returns a new Vector2 located at a percentage of the Path2 total length on this path.
         */
        Path2.prototype.getPointAtLengthPosition = function (normalizedLengthPosition) {
            if (normalizedLengthPosition < 0 || normalizedLengthPosition > 1) {
                //Tools.Error("normalized length position should be between 0 and 1.");
                return Vector2.Zero();
            }
            var lengthPosition = normalizedLengthPosition * this.length();
            var previousOffset = 0;
            for (var i = 0; i < this._points.length; i++) {
                var j = (i + 1) % this._points.length;
                var a = this._points[i];
                var b = this._points[j];
                var bToA = b.subtract(a);
                var nextOffset = (bToA.length() + previousOffset);
                if (lengthPosition >= previousOffset && lengthPosition <= nextOffset) {
                    var dir = bToA.normalize();
                    var localOffset = lengthPosition - previousOffset;
                    return new Vector2(a.x + (dir.x * localOffset), a.y + (dir.y * localOffset));
                }
                previousOffset = nextOffset;
            }
            //Tools.Error("internal error");
            return Vector2.Zero();
        };
        /**
         * Returns a new Path2 starting at the coordinates (x, y).
         */
        Path2.StartingAt = function (x, y) {
            return new Path2(x, y);
        };
        return Path2;
    }());
    BABYLON.Path2 = Path2;
    var Path3D = /** @class */ (function () {
        /**
        * new Path3D(path, normal, raw)
        * Creates a Path3D. A Path3D is a logical math object, so not a mesh.
        * please read the description in the tutorial :  http://doc.babylonjs.com/tutorials/How_to_use_Path3D
        * path : an array of Vector3, the curve axis of the Path3D
        * normal (optional) : Vector3, the first wanted normal to the curve. Ex (0, 1, 0) for a vertical normal.
        * raw (optional, default false) : boolean, if true the returned Path3D isn't normalized. Useful to depict path acceleration or speed.
        */
        function Path3D(path, firstNormal, raw) {
            if (firstNormal === void 0) { firstNormal = null; }
            this.path = path;
            this._curve = new Array();
            this._distances = new Array();
            this._tangents = new Array();
            this._normals = new Array();
            this._binormals = new Array();
            for (var p = 0; p < path.length; p++) {
                this._curve[p] = path[p].clone(); // hard copy
            }
            this._raw = raw || false;
            this._compute(firstNormal);
        }
        /**
         * Returns the Path3D array of successive Vector3 designing its curve.
         */
        Path3D.prototype.getCurve = function () {
            return this._curve;
        };
        /**
         * Returns an array populated with tangent vectors on each Path3D curve point.
         */
        Path3D.prototype.getTangents = function () {
            return this._tangents;
        };
        /**
         * Returns an array populated with normal vectors on each Path3D curve point.
         */
        Path3D.prototype.getNormals = function () {
            return this._normals;
        };
        /**
         * Returns an array populated with binormal vectors on each Path3D curve point.
         */
        Path3D.prototype.getBinormals = function () {
            return this._binormals;
        };
        /**
         * Returns an array populated with distances (float) of the i-th point from the first curve point.
         */
        Path3D.prototype.getDistances = function () {
            return this._distances;
        };
        /**
         * Forces the Path3D tangent, normal, binormal and distance recomputation.
         * Returns the same object updated.
         */
        Path3D.prototype.update = function (path, firstNormal) {
            if (firstNormal === void 0) { firstNormal = null; }
            for (var p = 0; p < path.length; p++) {
                this._curve[p].x = path[p].x;
                this._curve[p].y = path[p].y;
                this._curve[p].z = path[p].z;
            }
            this._compute(firstNormal);
            return this;
        };
        // private function compute() : computes tangents, normals and binormals
        Path3D.prototype._compute = function (firstNormal) {
            var l = this._curve.length;
            // first and last tangents
            this._tangents[0] = this._getFirstNonNullVector(0);
            if (!this._raw) {
                this._tangents[0].normalize();
            }
            this._tangents[l - 1] = this._curve[l - 1].subtract(this._curve[l - 2]);
            if (!this._raw) {
                this._tangents[l - 1].normalize();
            }
            // normals and binormals at first point : arbitrary vector with _normalVector()
            var tg0 = this._tangents[0];
            var pp0 = this._normalVector(this._curve[0], tg0, firstNormal);
            this._normals[0] = pp0;
            if (!this._raw) {
                this._normals[0].normalize();
            }
            this._binormals[0] = Vector3.Cross(tg0, this._normals[0]);
            if (!this._raw) {
                this._binormals[0].normalize();
            }
            this._distances[0] = 0.0;
            // normals and binormals : next points
            var prev; // previous vector (segment)
            var cur; // current vector (segment)
            var curTang; // current tangent
            // previous normal
            var prevBinor; // previous binormal
            for (var i = 1; i < l; i++) {
                // tangents
                prev = this._getLastNonNullVector(i);
                if (i < l - 1) {
                    cur = this._getFirstNonNullVector(i);
                    this._tangents[i] = prev.add(cur);
                    this._tangents[i].normalize();
                }
                this._distances[i] = this._distances[i - 1] + prev.length();
                // normals and binormals
                // http://www.cs.cmu.edu/afs/andrew/scs/cs/15-462/web/old/asst2camera.html
                curTang = this._tangents[i];
                prevBinor = this._binormals[i - 1];
                this._normals[i] = Vector3.Cross(prevBinor, curTang);
                if (!this._raw) {
                    this._normals[i].normalize();
                }
                this._binormals[i] = Vector3.Cross(curTang, this._normals[i]);
                if (!this._raw) {
                    this._binormals[i].normalize();
                }
            }
        };
        // private function getFirstNonNullVector(index)
        // returns the first non null vector from index : curve[index + N].subtract(curve[index])
        Path3D.prototype._getFirstNonNullVector = function (index) {
            var i = 1;
            var nNVector = this._curve[index + i].subtract(this._curve[index]);
            while (nNVector.length() === 0 && index + i + 1 < this._curve.length) {
                i++;
                nNVector = this._curve[index + i].subtract(this._curve[index]);
            }
            return nNVector;
        };
        // private function getLastNonNullVector(index)
        // returns the last non null vector from index : curve[index].subtract(curve[index - N])
        Path3D.prototype._getLastNonNullVector = function (index) {
            var i = 1;
            var nLVector = this._curve[index].subtract(this._curve[index - i]);
            while (nLVector.length() === 0 && index > i + 1) {
                i++;
                nLVector = this._curve[index].subtract(this._curve[index - i]);
            }
            return nLVector;
        };
        // private function normalVector(v0, vt, va) :
        // returns an arbitrary point in the plane defined by the point v0 and the vector vt orthogonal to this plane
        // if va is passed, it returns the va projection on the plane orthogonal to vt at the point v0
        Path3D.prototype._normalVector = function (v0, vt, va) {
            var normal0;
            var tgl = vt.length();
            if (tgl === 0.0) {
                tgl = 1.0;
            }
            if (va === undefined || va === null) {
                var point;
                if (!BABYLON.Scalar.WithinEpsilon(Math.abs(vt.y) / tgl, 1.0, BABYLON.Epsilon)) {
                    point = new Vector3(0.0, -1.0, 0.0);
                }
                else if (!BABYLON.Scalar.WithinEpsilon(Math.abs(vt.x) / tgl, 1.0, BABYLON.Epsilon)) {
                    point = new Vector3(1.0, 0.0, 0.0);
                }
                else if (!BABYLON.Scalar.WithinEpsilon(Math.abs(vt.z) / tgl, 1.0, BABYLON.Epsilon)) {
                    point = new Vector3(0.0, 0.0, 1.0);
                }
                else {
                    point = Vector3.Zero();
                }
                normal0 = Vector3.Cross(vt, point);
            }
            else {
                normal0 = Vector3.Cross(vt, va);
                Vector3.CrossToRef(normal0, vt, normal0);
            }
            normal0.normalize();
            return normal0;
        };
        return Path3D;
    }());
    BABYLON.Path3D = Path3D;
    var Curve3 = /** @class */ (function () {
        /**
         * A Curve3 object is a logical object, so not a mesh, to handle curves in the 3D geometric space.
         * A Curve3 is designed from a series of successive Vector3.
         * Tuto : http://doc.babylonjs.com/tutorials/How_to_use_Curve3#curve3-object
         */
        function Curve3(points) {
            this._length = 0.0;
            this._points = points;
            this._length = this._computeLength(points);
        }
        /**
         * Returns a Curve3 object along a Quadratic Bezier curve : http://doc.babylonjs.com/tutorials/How_to_use_Curve3#quadratic-bezier-curve
         * @param v0 (Vector3) the origin point of the Quadratic Bezier
         * @param v1 (Vector3) the control point
         * @param v2 (Vector3) the end point of the Quadratic Bezier
         * @param nbPoints (integer) the wanted number of points in the curve
         */
        Curve3.CreateQuadraticBezier = function (v0, v1, v2, nbPoints) {
            nbPoints = nbPoints > 2 ? nbPoints : 3;
            var bez = new Array();
            var equation = function (t, val0, val1, val2) {
                var res = (1.0 - t) * (1.0 - t) * val0 + 2.0 * t * (1.0 - t) * val1 + t * t * val2;
                return res;
            };
            for (var i = 0; i <= nbPoints; i++) {
                bez.push(new Vector3(equation(i / nbPoints, v0.x, v1.x, v2.x), equation(i / nbPoints, v0.y, v1.y, v2.y), equation(i / nbPoints, v0.z, v1.z, v2.z)));
            }
            return new Curve3(bez);
        };
        /**
         * Returns a Curve3 object along a Cubic Bezier curve : http://doc.babylonjs.com/tutorials/How_to_use_Curve3#cubic-bezier-curve
         * @param v0 (Vector3) the origin point of the Cubic Bezier
         * @param v1 (Vector3) the first control point
         * @param v2 (Vector3) the second control point
         * @param v3 (Vector3) the end point of the Cubic Bezier
         * @param nbPoints (integer) the wanted number of points in the curve
         */
        Curve3.CreateCubicBezier = function (v0, v1, v2, v3, nbPoints) {
            nbPoints = nbPoints > 3 ? nbPoints : 4;
            var bez = new Array();
            var equation = function (t, val0, val1, val2, val3) {
                var res = (1.0 - t) * (1.0 - t) * (1.0 - t) * val0 + 3.0 * t * (1.0 - t) * (1.0 - t) * val1 + 3.0 * t * t * (1.0 - t) * val2 + t * t * t * val3;
                return res;
            };
            for (var i = 0; i <= nbPoints; i++) {
                bez.push(new Vector3(equation(i / nbPoints, v0.x, v1.x, v2.x, v3.x), equation(i / nbPoints, v0.y, v1.y, v2.y, v3.y), equation(i / nbPoints, v0.z, v1.z, v2.z, v3.z)));
            }
            return new Curve3(bez);
        };
        /**
         * Returns a Curve3 object along a Hermite Spline curve : http://doc.babylonjs.com/tutorials/How_to_use_Curve3#hermite-spline
         * @param p1 (Vector3) the origin point of the Hermite Spline
         * @param t1 (Vector3) the tangent vector at the origin point
         * @param p2 (Vector3) the end point of the Hermite Spline
         * @param t2 (Vector3) the tangent vector at the end point
         * @param nbPoints (integer) the wanted number of points in the curve
         */
        Curve3.CreateHermiteSpline = function (p1, t1, p2, t2, nbPoints) {
            var hermite = new Array();
            var step = 1.0 / nbPoints;
            for (var i = 0; i <= nbPoints; i++) {
                hermite.push(Vector3.Hermite(p1, t1, p2, t2, i * step));
            }
            return new Curve3(hermite);
        };
        /**
         * Returns a Curve3 object along a CatmullRom Spline curve :
         * @param points (array of Vector3) the points the spline must pass through. At least, four points required.
         * @param nbPoints (integer) the wanted number of points between each curve control points.
         */
        Curve3.CreateCatmullRomSpline = function (points, nbPoints) {
            var totalPoints = new Array();
            totalPoints.push(points[0].clone());
            Array.prototype.push.apply(totalPoints, points);
            totalPoints.push(points[points.length - 1].clone());
            var catmullRom = new Array();
            var step = 1.0 / nbPoints;
            var amount = 0.0;
            for (var i = 0; i < totalPoints.length - 3; i++) {
                amount = 0;
                for (var c = 0; c < nbPoints; c++) {
                    catmullRom.push(Vector3.CatmullRom(totalPoints[i], totalPoints[i + 1], totalPoints[i + 2], totalPoints[i + 3], amount));
                    amount += step;
                }
            }
            i--;
            catmullRom.push(Vector3.CatmullRom(totalPoints[i], totalPoints[i + 1], totalPoints[i + 2], totalPoints[i + 3], amount));
            return new Curve3(catmullRom);
        };
        /**
         * Returns the Curve3 stored array of successive Vector3
         */
        Curve3.prototype.getPoints = function () {
            return this._points;
        };
        /**
         * Returns the computed length (float) of the curve.
         */
        Curve3.prototype.length = function () {
            return this._length;
        };
        /**
         * Returns a new instance of Curve3 object : var curve = curveA.continue(curveB);
         * This new Curve3 is built by translating and sticking the curveB at the end of the curveA.
         * curveA and curveB keep unchanged.
         */
        Curve3.prototype.continue = function (curve) {
            var lastPoint = this._points[this._points.length - 1];
            var continuedPoints = this._points.slice();
            var curvePoints = curve.getPoints();
            for (var i = 1; i < curvePoints.length; i++) {
                continuedPoints.push(curvePoints[i].subtract(curvePoints[0]).add(lastPoint));
            }
            var continuedCurve = new Curve3(continuedPoints);
            return continuedCurve;
        };
        Curve3.prototype._computeLength = function (path) {
            var l = 0;
            for (var i = 1; i < path.length; i++) {
                l += (path[i].subtract(path[i - 1])).length();
            }
            return l;
        };
        return Curve3;
    }());
    BABYLON.Curve3 = Curve3;
    // Vertex formats
    var PositionNormalVertex = /** @class */ (function () {
        function PositionNormalVertex(position, normal) {
            if (position === void 0) { position = Vector3.Zero(); }
            if (normal === void 0) { normal = Vector3.Up(); }
            this.position = position;
            this.normal = normal;
        }
        PositionNormalVertex.prototype.clone = function () {
            return new PositionNormalVertex(this.position.clone(), this.normal.clone());
        };
        return PositionNormalVertex;
    }());
    BABYLON.PositionNormalVertex = PositionNormalVertex;
    var PositionNormalTextureVertex = /** @class */ (function () {
        function PositionNormalTextureVertex(position, normal, uv) {
            if (position === void 0) { position = Vector3.Zero(); }
            if (normal === void 0) { normal = Vector3.Up(); }
            if (uv === void 0) { uv = Vector2.Zero(); }
            this.position = position;
            this.normal = normal;
            this.uv = uv;
        }
        PositionNormalTextureVertex.prototype.clone = function () {
            return new PositionNormalTextureVertex(this.position.clone(), this.normal.clone(), this.uv.clone());
        };
        return PositionNormalTextureVertex;
    }());
    BABYLON.PositionNormalTextureVertex = PositionNormalTextureVertex;
    // Temporary pre-allocated objects for engine internal use
    // usage in any internal function :
    // var tmp = Tmp.Vector3[0];   <= gets access to the first pre-created Vector3
    // There's a Tmp array per object type : int, float, Vector2, Vector3, Vector4, Quaternion, Matrix
    var Tmp = /** @class */ (function () {
        function Tmp() {
        }
        Tmp.Color3 = [Color3.Black(), Color3.Black(), Color3.Black()];
        Tmp.Vector2 = [Vector2.Zero(), Vector2.Zero(), Vector2.Zero()]; // 3 temp Vector2 at once should be enough
        Tmp.Vector3 = [Vector3.Zero(), Vector3.Zero(), Vector3.Zero(),
            Vector3.Zero(), Vector3.Zero(), Vector3.Zero(), Vector3.Zero(), Vector3.Zero(), Vector3.Zero()]; // 9 temp Vector3 at once should be enough
        Tmp.Vector4 = [Vector4.Zero(), Vector4.Zero(), Vector4.Zero()]; // 3 temp Vector4 at once should be enough
        Tmp.Quaternion = [Quaternion.Zero(), Quaternion.Zero()]; // 2 temp Quaternion at once should be enough
        Tmp.Matrix = [Matrix.Zero(), Matrix.Zero(),
            Matrix.Zero(), Matrix.Zero(),
            Matrix.Zero(), Matrix.Zero(),
            Matrix.Zero(), Matrix.Zero()]; // 6 temp Matrices at once should be enough
        return Tmp;
    }());
    BABYLON.Tmp = Tmp;
    // Same as Tmp but not exported to keep it onyl for math functions to avoid conflicts
    var MathTmp = /** @class */ (function () {
        function MathTmp() {
        }
        MathTmp.Vector3 = [Vector3.Zero()];
        MathTmp.Matrix = [Matrix.Zero(), Matrix.Zero()];
        MathTmp.Quaternion = [Quaternion.Zero()];
        return MathTmp;
    }());
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.math.js.map

var BABYLON;
(function (BABYLON) {
    var Scalar = /** @class */ (function () {
        function Scalar() {
        }
        /**
         * Boolean : true if the absolute difference between a and b is lower than epsilon (default = 1.401298E-45)
         */
        Scalar.WithinEpsilon = function (a, b, epsilon) {
            if (epsilon === void 0) { epsilon = 1.401298E-45; }
            var num = a - b;
            return -epsilon <= num && num <= epsilon;
        };
        /**
         * Returns a string : the upper case translation of the number i to hexadecimal.
         */
        Scalar.ToHex = function (i) {
            var str = i.toString(16);
            if (i <= 15) {
                return ("0" + str).toUpperCase();
            }
            return str.toUpperCase();
        };
        /**
         * Returns -1 if value is negative and +1 is value is positive.
         * Returns the value itself if it's equal to zero.
         */
        Scalar.Sign = function (value) {
            value = +value; // convert to a number
            if (value === 0 || isNaN(value))
                return value;
            return value > 0 ? 1 : -1;
        };
        /**
         * Returns the value itself if it's between min and max.
         * Returns min if the value is lower than min.
         * Returns max if the value is greater than max.
         */
        Scalar.Clamp = function (value, min, max) {
            if (min === void 0) { min = 0; }
            if (max === void 0) { max = 1; }
            return Math.min(max, Math.max(min, value));
        };
        /**
         * Returns the log2 of value.
         */
        Scalar.Log2 = function (value) {
            return Math.log(value) * Math.LOG2E;
        };
        /**
        * Loops the value, so that it is never larger than length and never smaller than 0.
        *
        * This is similar to the modulo operator but it works with floating point numbers.
        * For example, using 3.0 for t and 2.5 for length, the result would be 0.5.
        * With t = 5 and length = 2.5, the result would be 0.0.
        * Note, however, that the behaviour is not defined for negative numbers as it is for the modulo operator
        */
        Scalar.Repeat = function (value, length) {
            return value - Math.floor(value / length) * length;
        };
        /**
        * Normalize the value between 0.0 and 1.0 using min and max values
        */
        Scalar.Normalize = function (value, min, max) {
            return (value - min) / (max - min);
        };
        /**
        * Denormalize the value from 0.0 and 1.0 using min and max values
        */
        Scalar.Denormalize = function (normalized, min, max) {
            return (normalized * (max - min) + min);
        };
        /**
        * Calculates the shortest difference between two given angles given in degrees.
        */
        Scalar.DeltaAngle = function (current, target) {
            var num = Scalar.Repeat(target - current, 360.0);
            if (num > 180.0) {
                num -= 360.0;
            }
            return num;
        };
        /**
        * PingPongs the value t, so that it is never larger than length and never smaller than 0.
        *
        * The returned value will move back and forth between 0 and length
        */
        Scalar.PingPong = function (tx, length) {
            var t = Scalar.Repeat(tx, length * 2.0);
            return length - Math.abs(t - length);
        };
        /**
        * Interpolates between min and max with smoothing at the limits.
        *
        * This function interpolates between min and max in a similar way to Lerp. However, the interpolation will gradually speed up
        * from the start and slow down toward the end. This is useful for creating natural-looking animation, fading and other transitions.
        */
        Scalar.SmoothStep = function (from, to, tx) {
            var t = Scalar.Clamp(tx);
            t = -2.0 * t * t * t + 3.0 * t * t;
            return to * t + from * (1.0 - t);
        };
        /**
        * Moves a value current towards target.
        *
        * This is essentially the same as Mathf.Lerp but instead the function will ensure that the speed never exceeds maxDelta.
        * Negative values of maxDelta pushes the value away from target.
        */
        Scalar.MoveTowards = function (current, target, maxDelta) {
            var result = 0;
            if (Math.abs(target - current) <= maxDelta) {
                result = target;
            }
            else {
                result = current + Scalar.Sign(target - current) * maxDelta;
            }
            return result;
        };
        /**
        * Same as MoveTowards but makes sure the values interpolate correctly when they wrap around 360 degrees.
        *
        * Variables current and target are assumed to be in degrees. For optimization reasons, negative values of maxDelta
        *  are not supported and may cause oscillation. To push current away from a target angle, add 180 to that angle instead.
        */
        Scalar.MoveTowardsAngle = function (current, target, maxDelta) {
            var num = Scalar.DeltaAngle(current, target);
            var result = 0;
            if (-maxDelta < num && num < maxDelta) {
                result = target;
            }
            else {
                target = current + num;
                result = Scalar.MoveTowards(current, target, maxDelta);
            }
            return result;
        };
        /**
            * Creates a new scalar with values linearly interpolated of "amount" between the start scalar and the end scalar.
            */
        Scalar.Lerp = function (start, end, amount) {
            return start + ((end - start) * amount);
        };
        /**
        * Same as Lerp but makes sure the values interpolate correctly when they wrap around 360 degrees.
        * The parameter t is clamped to the range [0, 1]. Variables a and b are assumed to be in degrees.
        */
        Scalar.LerpAngle = function (start, end, amount) {
            var num = Scalar.Repeat(end - start, 360.0);
            if (num > 180.0) {
                num -= 360.0;
            }
            return start + num * Scalar.Clamp(amount);
        };
        /**
        * Calculates the linear parameter t that produces the interpolant value within the range [a, b].
        */
        Scalar.InverseLerp = function (a, b, value) {
            var result = 0;
            if (a != b) {
                result = Scalar.Clamp((value - a) / (b - a));
            }
            else {
                result = 0.0;
            }
            return result;
        };
        /**
         * Returns a new scalar located for "amount" (float) on the Hermite spline defined by the scalars "value1", "value3", "tangent1", "tangent2".
         */
        Scalar.Hermite = function (value1, tangent1, value2, tangent2, amount) {
            var squared = amount * amount;
            var cubed = amount * squared;
            var part1 = ((2.0 * cubed) - (3.0 * squared)) + 1.0;
            var part2 = (-2.0 * cubed) + (3.0 * squared);
            var part3 = (cubed - (2.0 * squared)) + amount;
            var part4 = cubed - squared;
            return (((value1 * part1) + (value2 * part2)) + (tangent1 * part3)) + (tangent2 * part4);
        };
        /**
        * Returns a random float number between and min and max values
        */
        Scalar.RandomRange = function (min, max) {
            if (min === max)
                return min;
            return ((Math.random() * (max - min)) + min);
        };
        /**
        * This function returns percentage of a number in a given range.
        *
        * RangeToPercent(40,20,60) will return 0.5 (50%)
        * RangeToPercent(34,0,100) will return 0.34 (34%)
        */
        Scalar.RangeToPercent = function (number, min, max) {
            return ((number - min) / (max - min));
        };
        /**
        * This function returns number that corresponds to the percentage in a given range.
        *
        * PercentToRange(0.34,0,100) will return 34.
        */
        Scalar.PercentToRange = function (percent, min, max) {
            return ((max - min) * percent + min);
        };
        /**
         * Returns the angle converted to equivalent value between -Math.PI and Math.PI radians.
         * @param angle The angle to normalize in radian.
         * @return The converted angle.
         */
        Scalar.NormalizeRadians = function (angle) {
            // More precise but slower version kept for reference.
            // angle = angle % Tools.TwoPi;
            // angle = (angle + Tools.TwoPi) % Tools.TwoPi;
            //if (angle > Math.PI) {
            //    angle -= Tools.TwoPi;
            //}
            angle -= (Scalar.TwoPi * Math.floor((angle + Math.PI) / Scalar.TwoPi));
            return angle;
        };
        /**
         * Two pi constants convenient for computation.
         */
        Scalar.TwoPi = Math.PI * 2;
        return Scalar;
    }());
    BABYLON.Scalar = Scalar;
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.math.scalar.js.map



//# sourceMappingURL=babylon.mixins.js.map

var BABYLON;
(function (BABYLON) {
    var __decoratorInitialStore = {};
    var __mergedStore = {};
    var _copySource = function (creationFunction, source, instanciate) {
        var destination = creationFunction();
        // Tags
        if (BABYLON.Tags) {
            BABYLON.Tags.AddTagsTo(destination, source.tags);
        }
        var classStore = getMergedStore(destination);
        // Properties
        for (var property in classStore) {
            var propertyDescriptor = classStore[property];
            var sourceProperty = source[property];
            var propertyType = propertyDescriptor.type;
            if (sourceProperty !== undefined && sourceProperty !== null) {
                switch (propertyType) {
                    case 0: // Value
                    case 6:// Mesh reference
                        destination[property] = sourceProperty;
                        break;
                    case 1:// Texture
                        destination[property] = (instanciate || sourceProperty.isRenderTarget) ? sourceProperty : sourceProperty.clone();
                        break;
                    case 2: // Color3
                    case 3: // FresnelParameters
                    case 4: // Vector2
                    case 5: // Vector3
                    case 7: // Color Curves
                    case 10:// Quaternion
                        destination[property] = instanciate ? sourceProperty : sourceProperty.clone();
                        break;
                }
            }
        }
        return destination;
    };
    function getDirectStore(target) {
        var classKey = target.getClassName();
        if (!__decoratorInitialStore[classKey]) {
            __decoratorInitialStore[classKey] = {};
        }
        return __decoratorInitialStore[classKey];
    }
    /**
     * Return the list of properties flagged as serializable
     * @param target: host object
     */
    function getMergedStore(target) {
        var classKey = target.getClassName();
        if (__mergedStore[classKey]) {
            return __mergedStore[classKey];
        }
        __mergedStore[classKey] = {};
        var store = __mergedStore[classKey];
        var currentTarget = target;
        var currentKey = classKey;
        while (currentKey) {
            var initialStore = __decoratorInitialStore[currentKey];
            for (var property in initialStore) {
                store[property] = initialStore[property];
            }
            var parent_1 = void 0;
            var done = false;
            do {
                parent_1 = Object.getPrototypeOf(currentTarget);
                if (!parent_1.getClassName) {
                    done = true;
                    break;
                }
                if (parent_1.getClassName() !== currentKey) {
                    break;
                }
                currentTarget = parent_1;
            } while (parent_1);
            if (done) {
                break;
            }
            currentKey = parent_1.getClassName();
            currentTarget = parent_1;
        }
        return store;
    }
    function generateSerializableMember(type, sourceName) {
        return function (target, propertyKey) {
            var classStore = getDirectStore(target);
            if (!classStore[propertyKey]) {
                classStore[propertyKey] = { type: type, sourceName: sourceName };
            }
        };
    }
    function generateExpandMember(setCallback, targetKey) {
        if (targetKey === void 0) { targetKey = null; }
        return function (target, propertyKey) {
            var key = targetKey || ("_" + propertyKey);
            Object.defineProperty(target, propertyKey, {
                get: function () {
                    return this[key];
                },
                set: function (value) {
                    if (this[key] === value) {
                        return;
                    }
                    this[key] = value;
                    target[setCallback].apply(this);
                },
                enumerable: true,
                configurable: true
            });
        };
    }
    function expandToProperty(callback, targetKey) {
        if (targetKey === void 0) { targetKey = null; }
        return generateExpandMember(callback, targetKey);
    }
    BABYLON.expandToProperty = expandToProperty;
    function serialize(sourceName) {
        return generateSerializableMember(0, sourceName); // value member
    }
    BABYLON.serialize = serialize;
    function serializeAsTexture(sourceName) {
        return generateSerializableMember(1, sourceName); // texture member
    }
    BABYLON.serializeAsTexture = serializeAsTexture;
    function serializeAsColor3(sourceName) {
        return generateSerializableMember(2, sourceName); // color3 member
    }
    BABYLON.serializeAsColor3 = serializeAsColor3;
    function serializeAsFresnelParameters(sourceName) {
        return generateSerializableMember(3, sourceName); // fresnel parameters member
    }
    BABYLON.serializeAsFresnelParameters = serializeAsFresnelParameters;
    function serializeAsVector2(sourceName) {
        return generateSerializableMember(4, sourceName); // vector2 member
    }
    BABYLON.serializeAsVector2 = serializeAsVector2;
    function serializeAsVector3(sourceName) {
        return generateSerializableMember(5, sourceName); // vector3 member
    }
    BABYLON.serializeAsVector3 = serializeAsVector3;
    function serializeAsMeshReference(sourceName) {
        return generateSerializableMember(6, sourceName); // mesh reference member
    }
    BABYLON.serializeAsMeshReference = serializeAsMeshReference;
    function serializeAsColorCurves(sourceName) {
        return generateSerializableMember(7, sourceName); // color curves
    }
    BABYLON.serializeAsColorCurves = serializeAsColorCurves;
    function serializeAsColor4(sourceName) {
        return generateSerializableMember(8, sourceName); // color 4
    }
    BABYLON.serializeAsColor4 = serializeAsColor4;
    function serializeAsImageProcessingConfiguration(sourceName) {
        return generateSerializableMember(9, sourceName); // image processing
    }
    BABYLON.serializeAsImageProcessingConfiguration = serializeAsImageProcessingConfiguration;
    function serializeAsQuaternion(sourceName) {
        return generateSerializableMember(10, sourceName); // quaternion member
    }
    BABYLON.serializeAsQuaternion = serializeAsQuaternion;
    var SerializationHelper = /** @class */ (function () {
        function SerializationHelper() {
        }
        SerializationHelper.Serialize = function (entity, serializationObject) {
            if (!serializationObject) {
                serializationObject = {};
            }
            // Tags
            if (BABYLON.Tags) {
                serializationObject.tags = BABYLON.Tags.GetTags(entity);
            }
            var serializedProperties = getMergedStore(entity);
            // Properties
            for (var property in serializedProperties) {
                var propertyDescriptor = serializedProperties[property];
                var targetPropertyName = propertyDescriptor.sourceName || property;
                var propertyType = propertyDescriptor.type;
                var sourceProperty = entity[property];
                if (sourceProperty !== undefined && sourceProperty !== null) {
                    switch (propertyType) {
                        case 0:// Value
                            serializationObject[targetPropertyName] = sourceProperty;
                            break;
                        case 1:// Texture
                            serializationObject[targetPropertyName] = sourceProperty.serialize();
                            break;
                        case 2:// Color3
                            serializationObject[targetPropertyName] = sourceProperty.asArray();
                            break;
                        case 3:// FresnelParameters
                            serializationObject[targetPropertyName] = sourceProperty.serialize();
                            break;
                        case 4:// Vector2
                            serializationObject[targetPropertyName] = sourceProperty.asArray();
                            break;
                        case 5:// Vector3
                            serializationObject[targetPropertyName] = sourceProperty.asArray();
                            break;
                        case 6:// Mesh reference
                            serializationObject[targetPropertyName] = sourceProperty.id;
                            break;
                        case 7:// Color Curves
                            serializationObject[targetPropertyName] = sourceProperty.serialize();
                            break;
                        case 8:// Color 4
                            serializationObject[targetPropertyName] = sourceProperty.asArray();
                            break;
                        case 9:// Image Processing
                            serializationObject[targetPropertyName] = sourceProperty.serialize();
                            break;
                    }
                }
            }
            return serializationObject;
        };
        SerializationHelper.Parse = function (creationFunction, source, scene, rootUrl) {
            if (rootUrl === void 0) { rootUrl = null; }
            var destination = creationFunction();
            if (!rootUrl) {
                rootUrl = "";
            }
            // Tags
            if (BABYLON.Tags) {
                BABYLON.Tags.AddTagsTo(destination, source.tags);
            }
            var classStore = getMergedStore(destination);
            // Properties
            for (var property in classStore) {
                var propertyDescriptor = classStore[property];
                var sourceProperty = source[propertyDescriptor.sourceName || property];
                var propertyType = propertyDescriptor.type;
                if (sourceProperty !== undefined && sourceProperty !== null) {
                    var dest = destination;
                    switch (propertyType) {
                        case 0:// Value
                            dest[property] = sourceProperty;
                            break;
                        case 1:// Texture
                            if (scene) {
                                dest[property] = BABYLON.Texture.Parse(sourceProperty, scene, rootUrl);
                            }
                            break;
                        case 2:// Color3
                            dest[property] = BABYLON.Color3.FromArray(sourceProperty);
                            break;
                        case 3:// FresnelParameters
                            dest[property] = BABYLON.FresnelParameters.Parse(sourceProperty);
                            break;
                        case 4:// Vector2
                            dest[property] = BABYLON.Vector2.FromArray(sourceProperty);
                            break;
                        case 5:// Vector3
                            dest[property] = BABYLON.Vector3.FromArray(sourceProperty);
                            break;
                        case 6:// Mesh reference
                            if (scene) {
                                dest[property] = scene.getLastMeshByID(sourceProperty);
                            }
                            break;
                        case 7:// Color Curves
                            dest[property] = BABYLON.ColorCurves.Parse(sourceProperty);
                            break;
                        case 8:// Color 4
                            dest[property] = BABYLON.Color4.FromArray(sourceProperty);
                            break;
                        case 9:// Image Processing
                            dest[property] = BABYLON.ImageProcessingConfiguration.Parse(sourceProperty);
                            break;
                    }
                }
            }
            return destination;
        };
        SerializationHelper.Clone = function (creationFunction, source) {
            return _copySource(creationFunction, source, false);
        };
        SerializationHelper.Instanciate = function (creationFunction, source) {
            return _copySource(creationFunction, source, true);
        };
        return SerializationHelper;
    }());
    BABYLON.SerializationHelper = SerializationHelper;
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.decorators.js.map

var BABYLON;
(function (BABYLON) {
    /**
     * A class serves as a medium between the observable and its observers
     */
    var EventState = /** @class */ (function () {
        /**
        * If the callback of a given Observer set skipNextObservers to true the following observers will be ignored
        */
        function EventState(mask, skipNextObservers, target, currentTarget) {
            if (skipNextObservers === void 0) { skipNextObservers = false; }
            this.initalize(mask, skipNextObservers, target, currentTarget);
        }
        EventState.prototype.initalize = function (mask, skipNextObservers, target, currentTarget) {
            if (skipNextObservers === void 0) { skipNextObservers = false; }
            this.mask = mask;
            this.skipNextObservers = skipNextObservers;
            this.target = target;
            this.currentTarget = currentTarget;
            return this;
        };
        return EventState;
    }());
    BABYLON.EventState = EventState;
    /**
     * Represent an Observer registered to a given Observable object.
     */
    var Observer = /** @class */ (function () {
        function Observer(callback, mask, scope) {
            if (scope === void 0) { scope = null; }
            this.callback = callback;
            this.mask = mask;
            this.scope = scope;
        }
        return Observer;
    }());
    BABYLON.Observer = Observer;
    /**
     * Represent a list of observers registered to multiple Observables object.
     */
    var MultiObserver = /** @class */ (function () {
        function MultiObserver() {
        }
        MultiObserver.prototype.dispose = function () {
            if (this._observers && this._observables) {
                for (var index = 0; index < this._observers.length; index++) {
                    this._observables[index].remove(this._observers[index]);
                }
            }
            this._observers = null;
            this._observables = null;
        };
        MultiObserver.Watch = function (observables, callback, mask, scope) {
            if (mask === void 0) { mask = -1; }
            if (scope === void 0) { scope = null; }
            var result = new MultiObserver();
            result._observers = new Array();
            result._observables = observables;
            for (var _i = 0, observables_1 = observables; _i < observables_1.length; _i++) {
                var observable = observables_1[_i];
                var observer = observable.add(callback, mask, false, scope);
                if (observer) {
                    result._observers.push(observer);
                }
            }
            return result;
        };
        return MultiObserver;
    }());
    BABYLON.MultiObserver = MultiObserver;
    /**
     * The Observable class is a simple implementation of the Observable pattern.
     * There's one slight particularity though: a given Observable can notify its observer using a particular mask value, only the Observers registered with this mask value will be notified.
     * This enable a more fine grained execution without having to rely on multiple different Observable objects.
     * For instance you may have a given Observable that have four different types of notifications: Move (mask = 0x01), Stop (mask = 0x02), Turn Right (mask = 0X04), Turn Left (mask = 0X08).
     * A given observer can register itself with only Move and Stop (mask = 0x03), then it will only be notified when one of these two occurs and will never be for Turn Left/Right.
     */
    var Observable = /** @class */ (function () {
        function Observable(onObserverAdded) {
            this._observers = new Array();
            this._eventState = new EventState(0);
            if (onObserverAdded) {
                this._onObserverAdded = onObserverAdded;
            }
        }
        /**
         * Create a new Observer with the specified callback
         * @param callback the callback that will be executed for that Observer
         * @param mask the mask used to filter observers
         * @param insertFirst if true the callback will be inserted at the first position, hence executed before the others ones. If false (default behavior) the callback will be inserted at the last position, executed after all the others already present.
         * @param scope optional scope for the callback to be called from
         */
        Observable.prototype.add = function (callback, mask, insertFirst, scope) {
            if (mask === void 0) { mask = -1; }
            if (insertFirst === void 0) { insertFirst = false; }
            if (scope === void 0) { scope = null; }
            if (!callback) {
                return null;
            }
            var observer = new Observer(callback, mask, scope);
            if (insertFirst) {
                this._observers.unshift(observer);
            }
            else {
                this._observers.push(observer);
            }
            if (this._onObserverAdded) {
                this._onObserverAdded(observer);
            }
            return observer;
        };
        /**
         * Remove an Observer from the Observable object
         * @param observer the instance of the Observer to remove. If it doesn't belong to this Observable, false will be returned.
         */
        Observable.prototype.remove = function (observer) {
            if (!observer) {
                return false;
            }
            var index = this._observers.indexOf(observer);
            if (index !== -1) {
                this._observers.splice(index, 1);
                return true;
            }
            return false;
        };
        /**
         * Remove a callback from the Observable object
         * @param callback the callback to remove. If it doesn't belong to this Observable, false will be returned.
        */
        Observable.prototype.removeCallback = function (callback) {
            for (var index = 0; index < this._observers.length; index++) {
                if (this._observers[index].callback === callback) {
                    this._observers.splice(index, 1);
                    return true;
                }
            }
            return false;
        };
        /**
         * Notify all Observers by calling their respective callback with the given data
         * Will return true if all observers were executed, false if an observer set skipNextObservers to true, then prevent the subsequent ones to execute
         * @param eventData
         * @param mask
         */
        Observable.prototype.notifyObservers = function (eventData, mask, target, currentTarget) {
            if (mask === void 0) { mask = -1; }
            if (!this._observers.length) {
                return true;
            }
            var state = this._eventState;
            state.mask = mask;
            state.target = target;
            state.currentTarget = currentTarget;
            state.skipNextObservers = false;
            for (var _i = 0, _a = this._observers; _i < _a.length; _i++) {
                var obs = _a[_i];
                if (obs.mask & mask) {
                    if (obs.scope) {
                        obs.callback.apply(obs.scope, [eventData, state]);
                    }
                    else {
                        obs.callback(eventData, state);
                    }
                }
                if (state.skipNextObservers) {
                    return false;
                }
            }
            return true;
        };
        /**
         * Notify a specific observer
         * @param eventData
         * @param mask
         */
        Observable.prototype.notifyObserver = function (observer, eventData, mask) {
            if (mask === void 0) { mask = -1; }
            var state = this._eventState;
            state.mask = mask;
            state.skipNextObservers = false;
            observer.callback(eventData, state);
        };
        /**
         * return true is the Observable has at least one Observer registered
         */
        Observable.prototype.hasObservers = function () {
            return this._observers.length > 0;
        };
        /**
        * Clear the list of observers
        */
        Observable.prototype.clear = function () {
            this._observers = new Array();
            this._onObserverAdded = null;
        };
        /**
        * Clone the current observable
        */
        Observable.prototype.clone = function () {
            var result = new Observable();
            result._observers = this._observers.slice(0);
            return result;
        };
        /**
         * Does this observable handles observer registered with a given mask
         * @param {number} trigger - the mask to be tested
         * @return {boolean} whether or not one observer registered with the given mask is handeled
        **/
        Observable.prototype.hasSpecificMask = function (mask) {
            if (mask === void 0) { mask = -1; }
            for (var _i = 0, _a = this._observers; _i < _a.length; _i++) {
                var obs = _a[_i];
                if (obs.mask & mask || obs.mask === mask) {
                    return true;
                }
            }
            return false;
        };
        return Observable;
    }());
    BABYLON.Observable = Observable;
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.observable.js.map


var BABYLON;
(function (BABYLON) {
    var SmartArray = /** @class */ (function () {
        function SmartArray(capacity) {
            this.length = 0;
            this.data = new Array(capacity);
            this._id = SmartArray._GlobalId++;
        }
        SmartArray.prototype.push = function (value) {
            this.data[this.length++] = value;
            if (this.length > this.data.length) {
                this.data.length *= 2;
            }
        };
        SmartArray.prototype.forEach = function (func) {
            for (var index = 0; index < this.length; index++) {
                func(this.data[index]);
            }
        };
        SmartArray.prototype.sort = function (compareFn) {
            this.data.sort(compareFn);
        };
        SmartArray.prototype.reset = function () {
            this.length = 0;
        };
        SmartArray.prototype.dispose = function () {
            this.reset();
            if (this.data) {
                this.data.length = 0;
                this.data = [];
            }
        };
        SmartArray.prototype.concat = function (array) {
            if (array.length === 0) {
                return;
            }
            if (this.length + array.length > this.data.length) {
                this.data.length = (this.length + array.length) * 2;
            }
            for (var index = 0; index < array.length; index++) {
                this.data[this.length++] = (array.data || array)[index];
            }
        };
        SmartArray.prototype.indexOf = function (value) {
            var position = this.data.indexOf(value);
            if (position >= this.length) {
                return -1;
            }
            return position;
        };
        SmartArray.prototype.contains = function (value) {
            return this.data.indexOf(value) !== -1;
        };
        // Statics
        SmartArray._GlobalId = 0;
        return SmartArray;
    }());
    BABYLON.SmartArray = SmartArray;
    var SmartArrayNoDuplicate = /** @class */ (function (_super) {
        __extends(SmartArrayNoDuplicate, _super);
        function SmartArrayNoDuplicate() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this._duplicateId = 0;
            return _this;
        }
        SmartArrayNoDuplicate.prototype.push = function (value) {
            _super.prototype.push.call(this, value);
            if (!value.__smartArrayFlags) {
                value.__smartArrayFlags = {};
            }
            value.__smartArrayFlags[this._id] = this._duplicateId;
        };
        SmartArrayNoDuplicate.prototype.pushNoDuplicate = function (value) {
            if (value.__smartArrayFlags && value.__smartArrayFlags[this._id] === this._duplicateId) {
                return false;
            }
            this.push(value);
            return true;
        };
        SmartArrayNoDuplicate.prototype.reset = function () {
            _super.prototype.reset.call(this);
            this._duplicateId++;
        };
        SmartArrayNoDuplicate.prototype.concatWithNoDuplicate = function (array) {
            if (array.length === 0) {
                return;
            }
            if (this.length + array.length > this.data.length) {
                this.data.length = (this.length + array.length) * 2;
            }
            for (var index = 0; index < array.length; index++) {
                var item = (array.data || array)[index];
                this.pushNoDuplicate(item);
            }
        };
        return SmartArrayNoDuplicate;
    }(SmartArray));
    BABYLON.SmartArrayNoDuplicate = SmartArrayNoDuplicate;
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.smartArray.js.map

var BABYLON;
(function (BABYLON) {
    // Screenshots
    var screenshotCanvas;
    var cloneValue = function (source, destinationObject) {
        if (!source)
            return null;
        if (source instanceof BABYLON.Mesh) {
            return null;
        }
        if (source instanceof BABYLON.SubMesh) {
            return source.clone(destinationObject);
        }
        else if (source.clone) {
            return source.clone();
        }
        return null;
    };
    var Tools = /** @class */ (function () {
        function Tools() {
        }
        /**
         * Interpolates between a and b via alpha
         * @param a The lower value (returned when alpha = 0)
         * @param b The upper value (returned when alpha = 1)
         * @param alpha The interpolation-factor
         * @return The mixed value
         */
        Tools.Mix = function (a, b, alpha) {
            return a * (1 - alpha) + b * alpha;
        };
        Tools.Instantiate = function (className) {
            if (Tools.RegisteredExternalClasses && Tools.RegisteredExternalClasses[className]) {
                return Tools.RegisteredExternalClasses[className];
            }
            var arr = className.split(".");
            var fn = (window || this);
            for (var i = 0, len = arr.length; i < len; i++) {
                fn = fn[arr[i]];
            }
            if (typeof fn !== "function") {
                return null;
            }
            return fn;
        };
        Tools.SetImmediate = function (action) {
            if (window.setImmediate) {
                window.setImmediate(action);
            }
            else {
                setTimeout(action, 1);
            }
        };
        Tools.IsExponentOfTwo = function (value) {
            var count = 1;
            do {
                count *= 2;
            } while (count < value);
            return count === value;
        };
        /**
         * Find the next highest power of two.
         * @param x Number to start search from.
         * @return Next highest power of two.
         */
        Tools.CeilingPOT = function (x) {
            x--;
            x |= x >> 1;
            x |= x >> 2;
            x |= x >> 4;
            x |= x >> 8;
            x |= x >> 16;
            x++;
            return x;
        };
        /**
         * Find the next lowest power of two.
         * @param x Number to start search from.
         * @return Next lowest power of two.
         */
        Tools.FloorPOT = function (x) {
            x = x | (x >> 1);
            x = x | (x >> 2);
            x = x | (x >> 4);
            x = x | (x >> 8);
            x = x | (x >> 16);
            return x - (x >> 1);
        };
        /**
         * Find the nearest power of two.
         * @param x Number to start search from.
         * @return Next nearest power of two.
         */
        Tools.NearestPOT = function (x) {
            var c = Tools.CeilingPOT(x);
            var f = Tools.FloorPOT(x);
            return (c - x) > (x - f) ? f : c;
        };
        Tools.GetExponentOfTwo = function (value, max, mode) {
            if (mode === void 0) { mode = BABYLON.Engine.SCALEMODE_NEAREST; }
            var pot;
            switch (mode) {
                case BABYLON.Engine.SCALEMODE_FLOOR:
                    pot = Tools.FloorPOT(value);
                    break;
                case BABYLON.Engine.SCALEMODE_NEAREST:
                    pot = Tools.NearestPOT(value);
                    break;
                case BABYLON.Engine.SCALEMODE_CEILING:
                default:
                    pot = Tools.CeilingPOT(value);
                    break;
            }
            return Math.min(pot, max);
        };
        Tools.GetFilename = function (path) {
            var index = path.lastIndexOf("/");
            if (index < 0)
                return path;
            return path.substring(index + 1);
        };
        Tools.GetFolderPath = function (uri) {
            var index = uri.lastIndexOf("/");
            if (index < 0)
                return "";
            return uri.substring(0, index + 1);
        };
        Tools.GetDOMTextContent = function (element) {
            var result = "";
            var child = element.firstChild;
            while (child) {
                if (child.nodeType === 3) {
                    result += child.textContent;
                }
                child = child.nextSibling;
            }
            return result;
        };
        Tools.ToDegrees = function (angle) {
            return angle * 180 / Math.PI;
        };
        Tools.ToRadians = function (angle) {
            return angle * Math.PI / 180;
        };
        Tools.EncodeArrayBufferTobase64 = function (buffer) {
            var keyStr = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
            var output = "";
            var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
            var i = 0;
            var bytes = new Uint8Array(buffer);
            while (i < bytes.length) {
                chr1 = bytes[i++];
                chr2 = i < bytes.length ? bytes[i++] : Number.NaN; // Not sure if the index 
                chr3 = i < bytes.length ? bytes[i++] : Number.NaN; // checks are needed here
                enc1 = chr1 >> 2;
                enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
                enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
                enc4 = chr3 & 63;
                if (isNaN(chr2)) {
                    enc3 = enc4 = 64;
                }
                else if (isNaN(chr3)) {
                    enc4 = 64;
                }
                output += keyStr.charAt(enc1) + keyStr.charAt(enc2) +
                    keyStr.charAt(enc3) + keyStr.charAt(enc4);
            }
            return "data:image/png;base64," + output;
        };
        Tools.ExtractMinAndMaxIndexed = function (positions, indices, indexStart, indexCount, bias) {
            if (bias === void 0) { bias = null; }
            var minimum = new BABYLON.Vector3(Number.MAX_VALUE, Number.MAX_VALUE, Number.MAX_VALUE);
            var maximum = new BABYLON.Vector3(-Number.MAX_VALUE, -Number.MAX_VALUE, -Number.MAX_VALUE);
            for (var index = indexStart; index < indexStart + indexCount; index++) {
                var current = new BABYLON.Vector3(positions[indices[index] * 3], positions[indices[index] * 3 + 1], positions[indices[index] * 3 + 2]);
                minimum = BABYLON.Vector3.Minimize(current, minimum);
                maximum = BABYLON.Vector3.Maximize(current, maximum);
            }
            if (bias) {
                minimum.x -= minimum.x * bias.x + bias.y;
                minimum.y -= minimum.y * bias.x + bias.y;
                minimum.z -= minimum.z * bias.x + bias.y;
                maximum.x += maximum.x * bias.x + bias.y;
                maximum.y += maximum.y * bias.x + bias.y;
                maximum.z += maximum.z * bias.x + bias.y;
            }
            return {
                minimum: minimum,
                maximum: maximum
            };
        };
        Tools.ExtractMinAndMax = function (positions, start, count, bias, stride) {
            if (bias === void 0) { bias = null; }
            var minimum = new BABYLON.Vector3(Number.MAX_VALUE, Number.MAX_VALUE, Number.MAX_VALUE);
            var maximum = new BABYLON.Vector3(-Number.MAX_VALUE, -Number.MAX_VALUE, -Number.MAX_VALUE);
            if (!stride) {
                stride = 3;
            }
            for (var index = start; index < start + count; index++) {
                var current = new BABYLON.Vector3(positions[index * stride], positions[index * stride + 1], positions[index * stride + 2]);
                minimum = BABYLON.Vector3.Minimize(current, minimum);
                maximum = BABYLON.Vector3.Maximize(current, maximum);
            }
            if (bias) {
                minimum.x -= minimum.x * bias.x + bias.y;
                minimum.y -= minimum.y * bias.x + bias.y;
                minimum.z -= minimum.z * bias.x + bias.y;
                maximum.x += maximum.x * bias.x + bias.y;
                maximum.y += maximum.y * bias.x + bias.y;
                maximum.z += maximum.z * bias.x + bias.y;
            }
            return {
                minimum: minimum,
                maximum: maximum
            };
        };
        Tools.Vector2ArrayFeeder = function (array) {
            return function (index) {
                var isFloatArray = (array.BYTES_PER_ELEMENT !== undefined);
                var length = isFloatArray ? array.length / 2 : array.length;
                if (index >= length) {
                    return null;
                }
                if (isFloatArray) {
                    var fa = array;
                    return new BABYLON.Vector2(fa[index * 2 + 0], fa[index * 2 + 1]);
                }
                var a = array;
                return a[index];
            };
        };
        Tools.ExtractMinAndMaxVector2 = function (feeder, bias) {
            if (bias === void 0) { bias = null; }
            var minimum = new BABYLON.Vector2(Number.MAX_VALUE, Number.MAX_VALUE);
            var maximum = new BABYLON.Vector2(-Number.MAX_VALUE, -Number.MAX_VALUE);
            var i = 0;
            var cur = feeder(i++);
            while (cur) {
                minimum = BABYLON.Vector2.Minimize(cur, minimum);
                maximum = BABYLON.Vector2.Maximize(cur, maximum);
                cur = feeder(i++);
            }
            if (bias) {
                minimum.x -= minimum.x * bias.x + bias.y;
                minimum.y -= minimum.y * bias.x + bias.y;
                maximum.x += maximum.x * bias.x + bias.y;
                maximum.y += maximum.y * bias.x + bias.y;
            }
            return {
                minimum: minimum,
                maximum: maximum
            };
        };
        Tools.MakeArray = function (obj, allowsNullUndefined) {
            if (allowsNullUndefined !== true && (obj === undefined || obj == null))
                return null;
            return Array.isArray(obj) ? obj : [obj];
        };
        // Misc.
        Tools.GetPointerPrefix = function () {
            var eventPrefix = "pointer";
            // Check if pointer events are supported
            if (Tools.IsWindowObjectExist() && !window.PointerEvent && !navigator.pointerEnabled) {
                eventPrefix = "mouse";
            }
            return eventPrefix;
        };
        /**
         * @param func - the function to be called
         * @param requester - the object that will request the next frame. Falls back to window.
         */
        Tools.QueueNewFrame = function (func, requester) {
            if (!Tools.IsWindowObjectExist()) {
                return setTimeout(func, 16);
            }
            if (!requester) {
                requester = window;
            }
            if (requester.requestAnimationFrame) {
                return requester.requestAnimationFrame(func);
            }
            else if (requester.msRequestAnimationFrame) {
                return requester.msRequestAnimationFrame(func);
            }
            else if (requester.webkitRequestAnimationFrame) {
                return requester.webkitRequestAnimationFrame(func);
            }
            else if (requester.mozRequestAnimationFrame) {
                return requester.mozRequestAnimationFrame(func);
            }
            else if (requester.oRequestAnimationFrame) {
                return requester.oRequestAnimationFrame(func);
            }
            else {
                return window.setTimeout(func, 16);
            }
        };
        Tools.RequestFullscreen = function (element) {
            var requestFunction = element.requestFullscreen || element.msRequestFullscreen || element.webkitRequestFullscreen || element.mozRequestFullScreen;
            if (!requestFunction)
                return;
            requestFunction.call(element);
        };
        Tools.ExitFullscreen = function () {
            if (document.exitFullscreen) {
                document.exitFullscreen();
            }
            else if (document.mozCancelFullScreen) {
                document.mozCancelFullScreen();
            }
            else if (document.webkitCancelFullScreen) {
                document.webkitCancelFullScreen();
            }
            else if (document.msCancelFullScreen) {
                document.msCancelFullScreen();
            }
        };
        Tools.SetCorsBehavior = function (url, element) {
            if (url && url.indexOf("data:") === 0) {
                return;
            }
            if (Tools.CorsBehavior) {
                if (typeof (Tools.CorsBehavior) === 'string' || Tools.CorsBehavior instanceof String) {
                    element.crossOrigin = Tools.CorsBehavior;
                }
                else {
                    var result = Tools.CorsBehavior(url);
                    if (result) {
                        element.crossOrigin = result;
                    }
                }
            }
        };
        // External files
        Tools.CleanUrl = function (url) {
            url = url.replace(/#/mg, "%23");
            return url;
        };
        Tools.LoadImage = function (url, onLoad, onError, database) {
            if (url instanceof ArrayBuffer) {
                url = Tools.EncodeArrayBufferTobase64(url);
            }
            url = Tools.CleanUrl(url);
            url = Tools.PreprocessUrl(url);
            var img = new Image();
            Tools.SetCorsBehavior(url, img);
            img.onload = function () {
                onLoad(img);
            };
            img.onerror = function (err) {
                Tools.Error("Error while trying to load image: " + url);
                if (onError) {
                    onError("Error while trying to load image: " + url, err);
                }
            };
            var noIndexedDB = function () {
                img.src = url;
            };
            var loadFromIndexedDB = function () {
                if (database) {
                    database.loadImageFromDB(url, img);
                }
            };
            //ANY database to do!
            if (url.substr(0, 5) !== "data:" && database && database.enableTexturesOffline && BABYLON.Database.IsUASupportingBlobStorage) {
                database.openAsync(loadFromIndexedDB, noIndexedDB);
            }
            else {
                if (url.indexOf("file:") !== -1) {
                    var textureName = decodeURIComponent(url.substring(5).toLowerCase());
                    if (BABYLON.FilesInput.FilesToLoad[textureName]) {
                        try {
                            var blobURL;
                            try {
                                blobURL = URL.createObjectURL(BABYLON.FilesInput.FilesToLoad[textureName], { oneTimeOnly: true });
                            }
                            catch (ex) {
                                // Chrome doesn't support oneTimeOnly parameter
                                blobURL = URL.createObjectURL(BABYLON.FilesInput.FilesToLoad[textureName]);
                            }
                            img.src = blobURL;
                        }
                        catch (e) {
                            img.src = "";
                        }
                        return img;
                    }
                }
                noIndexedDB();
            }
            return img;
        };
        Tools.LoadFile = function (url, callback, progressCallBack, database, useArrayBuffer, onError) {
            url = Tools.CleanUrl(url);
            url = Tools.PreprocessUrl(url);
            var request = null;
            var noIndexedDB = function () {
                request = new XMLHttpRequest();
                var loadUrl = Tools.BaseUrl + url;
                request.open('GET', loadUrl, true);
                if (useArrayBuffer) {
                    request.responseType = "arraybuffer";
                }
                if (progressCallBack) {
                    request.onprogress = progressCallBack;
                }
                request.onreadystatechange = function () {
                    var req = request;
                    // In case of undefined state in some browsers.
                    if (req.readyState === (XMLHttpRequest.DONE || 4)) {
                        req.onreadystatechange = function () { }; //some browsers have issues where onreadystatechange can be called multiple times with the same value
                        if (req.status >= 200 && req.status < 300 || (!Tools.IsWindowObjectExist() && (req.status === 0))) {
                            callback(!useArrayBuffer ? req.responseText : req.response, req.responseURL);
                        }
                        else {
                            var e = new Error("Error status: " + req.status + " - Unable to load " + loadUrl);
                            if (onError) {
                                onError(req, e);
                            }
                            else {
                                throw e;
                            }
                        }
                    }
                };
                request.send(null);
            };
            var loadFromIndexedDB = function () {
                if (database) {
                    database.loadFileFromDB(url, callback, progressCallBack, noIndexedDB, useArrayBuffer);
                }
            };
            // If file and file input are set
            if (url.indexOf("file:") !== -1) {
                var fileName = decodeURIComponent(url.substring(5).toLowerCase());
                if (BABYLON.FilesInput.FilesToLoad[fileName]) {
                    Tools.ReadFile(BABYLON.FilesInput.FilesToLoad[fileName], callback, progressCallBack, useArrayBuffer);
                    return request;
                }
            }
            // Caching all files
            if (database && database.enableSceneOffline) {
                database.openAsync(loadFromIndexedDB, noIndexedDB);
            }
            else {
                noIndexedDB();
            }
            return request;
        };
        /**
         * Load a script (identified by an url). When the url returns, the
         * content of this file is added into a new script element, attached to the DOM (body element)
         */
        Tools.LoadScript = function (scriptUrl, onSuccess, onError) {
            var head = document.getElementsByTagName('head')[0];
            var script = document.createElement('script');
            script.type = 'text/javascript';
            script.src = scriptUrl;
            script.onload = function () {
                if (onSuccess) {
                    onSuccess();
                }
            };
            script.onerror = function (e) {
                if (onError) {
                    onError("Unable to load script", e);
                }
            };
            head.appendChild(script);
        };
        Tools.ReadFileAsDataURL = function (fileToLoad, callback, progressCallback) {
            var reader = new FileReader();
            reader.onload = function (e) {
                //target doesn't have result from ts 1.3
                callback(e.target['result']);
            };
            reader.onprogress = progressCallback;
            reader.readAsDataURL(fileToLoad);
        };
        Tools.ReadFile = function (fileToLoad, callback, progressCallBack, useArrayBuffer) {
            var reader = new FileReader();
            reader.onerror = function (e) {
                Tools.Log("Error while reading file: " + fileToLoad.name);
                callback(JSON.stringify({ autoClear: true, clearColor: [1, 0, 0], ambientColor: [0, 0, 0], gravity: [0, -9.807, 0], meshes: [], cameras: [], lights: [] }));
            };
            reader.onload = function (e) {
                //target doesn't have result from ts 1.3
                callback(e.target['result']);
            };
            if (progressCallBack) {
                reader.onprogress = progressCallBack;
            }
            if (!useArrayBuffer) {
                // Asynchronous read
                reader.readAsText(fileToLoad);
            }
            else {
                reader.readAsArrayBuffer(fileToLoad);
            }
        };
        //returns a downloadable url to a file content.
        Tools.FileAsURL = function (content) {
            var fileBlob = new Blob([content]);
            var url = window.URL || window.webkitURL;
            var link = url.createObjectURL(fileBlob);
            return link;
        };
        // Misc.
        Tools.Format = function (value, decimals) {
            if (decimals === void 0) { decimals = 2; }
            return value.toFixed(decimals);
        };
        Tools.CheckExtends = function (v, min, max) {
            if (v.x < min.x)
                min.x = v.x;
            if (v.y < min.y)
                min.y = v.y;
            if (v.z < min.z)
                min.z = v.z;
            if (v.x > max.x)
                max.x = v.x;
            if (v.y > max.y)
                max.y = v.y;
            if (v.z > max.z)
                max.z = v.z;
        };
        Tools.DeepCopy = function (source, destination, doNotCopyList, mustCopyList) {
            for (var prop in source) {
                if (prop[0] === "_" && (!mustCopyList || mustCopyList.indexOf(prop) === -1)) {
                    continue;
                }
                if (doNotCopyList && doNotCopyList.indexOf(prop) !== -1) {
                    continue;
                }
                var sourceValue = source[prop];
                var typeOfSourceValue = typeof sourceValue;
                if (typeOfSourceValue === "function") {
                    continue;
                }
                if (typeOfSourceValue === "object") {
                    if (sourceValue instanceof Array) {
                        destination[prop] = [];
                        if (sourceValue.length > 0) {
                            if (typeof sourceValue[0] == "object") {
                                for (var index = 0; index < sourceValue.length; index++) {
                                    var clonedValue = cloneValue(sourceValue[index], destination);
                                    if (destination[prop].indexOf(clonedValue) === -1) {
                                        destination[prop].push(clonedValue);
                                    }
                                }
                            }
                            else {
                                destination[prop] = sourceValue.slice(0);
                            }
                        }
                    }
                    else {
                        destination[prop] = cloneValue(sourceValue, destination);
                    }
                }
                else {
                    destination[prop] = sourceValue;
                }
            }
        };
        Tools.IsEmpty = function (obj) {
            for (var i in obj) {
                if (obj.hasOwnProperty(i)) {
                    return false;
                }
            }
            return true;
        };
        Tools.RegisterTopRootEvents = function (events) {
            for (var index = 0; index < events.length; index++) {
                var event = events[index];
                window.addEventListener(event.name, event.handler, false);
                try {
                    if (window.parent) {
                        window.parent.addEventListener(event.name, event.handler, false);
                    }
                }
                catch (e) {
                    // Silently fails...
                }
            }
        };
        Tools.UnregisterTopRootEvents = function (events) {
            for (var index = 0; index < events.length; index++) {
                var event = events[index];
                window.removeEventListener(event.name, event.handler);
                try {
                    if (window.parent) {
                        window.parent.removeEventListener(event.name, event.handler);
                    }
                }
                catch (e) {
                    // Silently fails...
                }
            }
        };
        Tools.DumpFramebuffer = function (width, height, engine, successCallback, mimeType, fileName) {
            if (mimeType === void 0) { mimeType = "image/png"; }
            // Read the contents of the framebuffer
            var numberOfChannelsByLine = width * 4;
            var halfHeight = height / 2;
            //Reading datas from WebGL
            var data = engine.readPixels(0, 0, width, height);
            //To flip image on Y axis.
            for (var i = 0; i < halfHeight; i++) {
                for (var j = 0; j < numberOfChannelsByLine; j++) {
                    var currentCell = j + i * numberOfChannelsByLine;
                    var targetLine = height - i - 1;
                    var targetCell = j + targetLine * numberOfChannelsByLine;
                    var temp = data[currentCell];
                    data[currentCell] = data[targetCell];
                    data[targetCell] = temp;
                }
            }
            // Create a 2D canvas to store the result
            if (!screenshotCanvas) {
                screenshotCanvas = document.createElement('canvas');
            }
            screenshotCanvas.width = width;
            screenshotCanvas.height = height;
            var context = screenshotCanvas.getContext('2d');
            if (context) {
                // Copy the pixels to a 2D canvas
                var imageData = context.createImageData(width, height);
                var castData = (imageData.data);
                castData.set(data);
                context.putImageData(imageData, 0, 0);
                Tools.EncodeScreenshotCanvasData(successCallback, mimeType, fileName);
            }
        };
        Tools.EncodeScreenshotCanvasData = function (successCallback, mimeType, fileName) {
            if (mimeType === void 0) { mimeType = "image/png"; }
            var base64Image = screenshotCanvas.toDataURL(mimeType);
            if (successCallback) {
                successCallback(base64Image);
            }
            else {
                // We need HTMLCanvasElement.toBlob for HD screenshots
                if (!screenshotCanvas.toBlob) {
                    //  low performance polyfill based on toDataURL (https://developer.mozilla.org/en-US/docs/Web/API/HTMLCanvasElement/toBlob)
                    screenshotCanvas.toBlob = function (callback, type, quality) {
                        var _this = this;
                        setTimeout(function () {
                            var binStr = atob(_this.toDataURL(type, quality).split(',')[1]), len = binStr.length, arr = new Uint8Array(len);
                            for (var i = 0; i < len; i++) {
                                arr[i] = binStr.charCodeAt(i);
                            }
                            callback(new Blob([arr], { type: type || 'image/png' }));
                        });
                    };
                }
                screenshotCanvas.toBlob(function (blob) {
                    var url = URL.createObjectURL(blob);
                    //Creating a link if the browser have the download attribute on the a tag, to automatically start download generated image.
                    if (("download" in document.createElement("a"))) {
                        var a = window.document.createElement("a");
                        a.href = url;
                        if (fileName) {
                            a.setAttribute("download", fileName);
                        }
                        else {
                            var date = new Date();
                            var stringDate = (date.getFullYear() + "-" + (date.getMonth() + 1)).slice(-2) + "-" + date.getDate() + "_" + date.getHours() + "-" + ('0' + date.getMinutes()).slice(-2);
                            a.setAttribute("download", "screenshot_" + stringDate + ".png");
                        }
                        window.document.body.appendChild(a);
                        a.addEventListener("click", function () {
                            if (a.parentElement) {
                                a.parentElement.removeChild(a);
                            }
                        });
                        a.click();
                    }
                    else {
                        var newWindow = window.open("");
                        if (!newWindow)
                            return;
                        var img = newWindow.document.createElement("img");
                        img.onload = function () {
                            // no longer need to read the blob so it's revoked
                            URL.revokeObjectURL(url);
                        };
                        img.src = url;
                        newWindow.document.body.appendChild(img);
                    }
                });
            }
        };
        Tools.CreateScreenshot = function (engine, camera, size, successCallback, mimeType) {
            if (mimeType === void 0) { mimeType = "image/png"; }
            var width;
            var height;
            // If a precision value is specified
            if (size.precision) {
                width = Math.round(engine.getRenderWidth() * size.precision);
                height = Math.round(width / engine.getAspectRatio(camera));
            }
            else if (size.width && size.height) {
                width = size.width;
                height = size.height;
            }
            else if (size.width && !size.height) {
                width = size.width;
                height = Math.round(width / engine.getAspectRatio(camera));
            }
            else if (size.height && !size.width) {
                height = size.height;
                width = Math.round(height * engine.getAspectRatio(camera));
            }
            else if (!isNaN(size)) {
                height = size;
                width = size;
            }
            else {
                Tools.Error("Invalid 'size' parameter !");
                return;
            }
            if (!screenshotCanvas) {
                screenshotCanvas = document.createElement('canvas');
            }
            screenshotCanvas.width = width;
            screenshotCanvas.height = height;
            var renderContext = screenshotCanvas.getContext("2d");
            var ratio = engine.getRenderWidth() / engine.getRenderHeight();
            var newWidth = width;
            var newHeight = newWidth / ratio;
            if (newHeight > height) {
                newHeight = height;
                newWidth = newHeight * ratio;
            }
            var offsetX = Math.max(0, width - newWidth) / 2;
            var offsetY = Math.max(0, height - newHeight) / 2;
            var renderingCanvas = engine.getRenderingCanvas();
            if (renderContext && renderingCanvas) {
                renderContext.drawImage(renderingCanvas, offsetX, offsetY, newWidth, newHeight);
            }
            Tools.EncodeScreenshotCanvasData(successCallback, mimeType);
        };
        Tools.CreateScreenshotUsingRenderTarget = function (engine, camera, size, successCallback, mimeType, samples, antialiasing, fileName) {
            if (mimeType === void 0) { mimeType = "image/png"; }
            if (samples === void 0) { samples = 1; }
            if (antialiasing === void 0) { antialiasing = false; }
            var width;
            var height;
            //If a precision value is specified
            if (size.precision) {
                width = Math.round(engine.getRenderWidth() * size.precision);
                height = Math.round(width / engine.getAspectRatio(camera));
                size = { width: width, height: height };
            }
            else if (size.width && size.height) {
                width = size.width;
                height = size.height;
            }
            else if (size.width && !size.height) {
                width = size.width;
                height = Math.round(width / engine.getAspectRatio(camera));
                size = { width: width, height: height };
            }
            else if (size.height && !size.width) {
                height = size.height;
                width = Math.round(height * engine.getAspectRatio(camera));
                size = { width: width, height: height };
            }
            else if (!isNaN(size)) {
                height = size;
                width = size;
            }
            else {
                Tools.Error("Invalid 'size' parameter !");
                return;
            }
            var scene = camera.getScene();
            var previousCamera = null;
            if (scene.activeCamera !== camera) {
                previousCamera = scene.activeCamera;
                scene.activeCamera = camera;
            }
            //At this point size can be a number, or an object (according to engine.prototype.createRenderTargetTexture method)
            var texture = new BABYLON.RenderTargetTexture("screenShot", size, scene, false, false, BABYLON.Engine.TEXTURETYPE_UNSIGNED_INT, false, BABYLON.Texture.NEAREST_SAMPLINGMODE);
            texture.renderList = null;
            texture.samples = samples;
            if (antialiasing) {
                texture.addPostProcess(new BABYLON.FxaaPostProcess('antialiasing', 1.0, scene.activeCamera));
            }
            texture.onAfterRenderObservable.add(function () {
                Tools.DumpFramebuffer(width, height, engine, successCallback, mimeType, fileName);
            });
            scene.incrementRenderId();
            scene.resetCachedMaterial();
            texture.render(true);
            texture.dispose();
            if (previousCamera) {
                scene.activeCamera = previousCamera;
            }
            camera.getProjectionMatrix(true); // Force cache refresh;
        };
        // XHR response validator for local file scenario
        Tools.ValidateXHRData = function (xhr, dataType) {
            // 1 for text (.babylon, manifest and shaders), 2 for TGA, 4 for DDS, 7 for all
            if (dataType === void 0) { dataType = 7; }
            try {
                if (dataType & 1) {
                    if (xhr.responseText && xhr.responseText.length > 0) {
                        return true;
                    }
                    else if (dataType === 1) {
                        return false;
                    }
                }
                if (dataType & 2) {
                    // Check header width and height since there is no "TGA" magic number
                    var tgaHeader = BABYLON.Internals.TGATools.GetTGAHeader(xhr.response);
                    if (tgaHeader.width && tgaHeader.height && tgaHeader.width > 0 && tgaHeader.height > 0) {
                        return true;
                    }
                    else if (dataType === 2) {
                        return false;
                    }
                }
                if (dataType & 4) {
                    // Check for the "DDS" magic number
                    var ddsHeader = new Uint8Array(xhr.response, 0, 3);
                    if (ddsHeader[0] === 68 && ddsHeader[1] === 68 && ddsHeader[2] === 83) {
                        return true;
                    }
                    else {
                        return false;
                    }
                }
            }
            catch (e) {
                // Global protection
            }
            return false;
        };
        /**
         * Implementation from http://stackoverflow.com/questions/105034/how-to-create-a-guid-uuid-in-javascript/2117523#answer-2117523
         * Be aware Math.random() could cause collisions, but:
         * "All but 6 of the 128 bits of the ID are randomly generated, which means that for any two ids, there's a 1 in 2^^122 (or 5.3x10^^36) chance they'll collide"
         */
        Tools.RandomId = function () {
            return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
                var r = Math.random() * 16 | 0, v = c === 'x' ? r : (r & 0x3 | 0x8);
                return v.toString(16);
            });
        };
        Object.defineProperty(Tools, "NoneLogLevel", {
            get: function () {
                return Tools._NoneLogLevel;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Tools, "MessageLogLevel", {
            get: function () {
                return Tools._MessageLogLevel;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Tools, "WarningLogLevel", {
            get: function () {
                return Tools._WarningLogLevel;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Tools, "ErrorLogLevel", {
            get: function () {
                return Tools._ErrorLogLevel;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Tools, "AllLogLevel", {
            get: function () {
                return Tools._MessageLogLevel | Tools._WarningLogLevel | Tools._ErrorLogLevel;
            },
            enumerable: true,
            configurable: true
        });
        Tools._AddLogEntry = function (entry) {
            Tools._LogCache = entry + Tools._LogCache;
            if (Tools.OnNewCacheEntry) {
                Tools.OnNewCacheEntry(entry);
            }
        };
        Tools._FormatMessage = function (message) {
            var padStr = function (i) { return (i < 10) ? "0" + i : "" + i; };
            var date = new Date();
            return "[" + padStr(date.getHours()) + ":" + padStr(date.getMinutes()) + ":" + padStr(date.getSeconds()) + "]: " + message;
        };
        Tools._LogDisabled = function (message) {
            // nothing to do
        };
        Tools._LogEnabled = function (message) {
            var formattedMessage = Tools._FormatMessage(message);
            console.log("BJS - " + formattedMessage);
            var entry = "<div style='color:white'>" + formattedMessage + "</div><br>";
            Tools._AddLogEntry(entry);
        };
        Tools._WarnDisabled = function (message) {
            // nothing to do
        };
        Tools._WarnEnabled = function (message) {
            var formattedMessage = Tools._FormatMessage(message);
            console.warn("BJS - " + formattedMessage);
            var entry = "<div style='color:orange'>" + formattedMessage + "</div><br>";
            Tools._AddLogEntry(entry);
        };
        Tools._ErrorDisabled = function (message) {
            // nothing to do
        };
        Tools._ErrorEnabled = function (message) {
            Tools.errorsCount++;
            var formattedMessage = Tools._FormatMessage(message);
            console.error("BJS - " + formattedMessage);
            var entry = "<div style='color:red'>" + formattedMessage + "</div><br>";
            Tools._AddLogEntry(entry);
        };
        Object.defineProperty(Tools, "LogCache", {
            get: function () {
                return Tools._LogCache;
            },
            enumerable: true,
            configurable: true
        });
        Tools.ClearLogCache = function () {
            Tools._LogCache = "";
            Tools.errorsCount = 0;
        };
        Object.defineProperty(Tools, "LogLevels", {
            set: function (level) {
                if ((level & Tools.MessageLogLevel) === Tools.MessageLogLevel) {
                    Tools.Log = Tools._LogEnabled;
                }
                else {
                    Tools.Log = Tools._LogDisabled;
                }
                if ((level & Tools.WarningLogLevel) === Tools.WarningLogLevel) {
                    Tools.Warn = Tools._WarnEnabled;
                }
                else {
                    Tools.Warn = Tools._WarnDisabled;
                }
                if ((level & Tools.ErrorLogLevel) === Tools.ErrorLogLevel) {
                    Tools.Error = Tools._ErrorEnabled;
                }
                else {
                    Tools.Error = Tools._ErrorDisabled;
                }
            },
            enumerable: true,
            configurable: true
        });
        Tools.IsWindowObjectExist = function () {
            return (typeof window) !== "undefined";
        };
        Object.defineProperty(Tools, "PerformanceNoneLogLevel", {
            get: function () {
                return Tools._PerformanceNoneLogLevel;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Tools, "PerformanceUserMarkLogLevel", {
            get: function () {
                return Tools._PerformanceUserMarkLogLevel;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Tools, "PerformanceConsoleLogLevel", {
            get: function () {
                return Tools._PerformanceConsoleLogLevel;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Tools, "PerformanceLogLevel", {
            set: function (level) {
                if ((level & Tools.PerformanceUserMarkLogLevel) === Tools.PerformanceUserMarkLogLevel) {
                    Tools.StartPerformanceCounter = Tools._StartUserMark;
                    Tools.EndPerformanceCounter = Tools._EndUserMark;
                    return;
                }
                if ((level & Tools.PerformanceConsoleLogLevel) === Tools.PerformanceConsoleLogLevel) {
                    Tools.StartPerformanceCounter = Tools._StartPerformanceConsole;
                    Tools.EndPerformanceCounter = Tools._EndPerformanceConsole;
                    return;
                }
                Tools.StartPerformanceCounter = Tools._StartPerformanceCounterDisabled;
                Tools.EndPerformanceCounter = Tools._EndPerformanceCounterDisabled;
            },
            enumerable: true,
            configurable: true
        });
        Tools._StartPerformanceCounterDisabled = function (counterName, condition) {
        };
        Tools._EndPerformanceCounterDisabled = function (counterName, condition) {
        };
        Tools._StartUserMark = function (counterName, condition) {
            if (condition === void 0) { condition = true; }
            if (!Tools._performance) {
                if (!Tools.IsWindowObjectExist()) {
                    return;
                }
                Tools._performance = window.performance;
            }
            if (!condition || !Tools._performance.mark) {
                return;
            }
            Tools._performance.mark(counterName + "-Begin");
        };
        Tools._EndUserMark = function (counterName, condition) {
            if (condition === void 0) { condition = true; }
            if (!condition || !Tools._performance.mark) {
                return;
            }
            Tools._performance.mark(counterName + "-End");
            Tools._performance.measure(counterName, counterName + "-Begin", counterName + "-End");
        };
        Tools._StartPerformanceConsole = function (counterName, condition) {
            if (condition === void 0) { condition = true; }
            if (!condition) {
                return;
            }
            Tools._StartUserMark(counterName, condition);
            if (console.time) {
                console.time(counterName);
            }
        };
        Tools._EndPerformanceConsole = function (counterName, condition) {
            if (condition === void 0) { condition = true; }
            if (!condition) {
                return;
            }
            Tools._EndUserMark(counterName, condition);
            if (console.time) {
                console.timeEnd(counterName);
            }
        };
        Object.defineProperty(Tools, "Now", {
            get: function () {
                if (Tools.IsWindowObjectExist() && window.performance && window.performance.now) {
                    return window.performance.now();
                }
                return new Date().getTime();
            },
            enumerable: true,
            configurable: true
        });
        /**
         * This method will return the name of the class used to create the instance of the given object.
         * It will works only on Javascript basic data types (number, string, ...) and instance of class declared with the @className decorator.
         * @param object the object to get the class name from
         * @return the name of the class, will be "object" for a custom data type not using the @className decorator
         */
        Tools.GetClassName = function (object, isType) {
            if (isType === void 0) { isType = false; }
            var name = null;
            if (!isType && object.getClassName) {
                name = object.getClassName();
            }
            else {
                if (object instanceof Object) {
                    var classObj = isType ? object : Object.getPrototypeOf(object);
                    name = classObj.constructor["__bjsclassName__"];
                }
                if (!name) {
                    name = typeof object;
                }
            }
            return name;
        };
        Tools.First = function (array, predicate) {
            for (var _i = 0, array_1 = array; _i < array_1.length; _i++) {
                var el = array_1[_i];
                if (predicate(el)) {
                    return el;
                }
            }
            return null;
        };
        /**
         * This method will return the name of the full name of the class, including its owning module (if any).
         * It will works only on Javascript basic data types (number, string, ...) and instance of class declared with the @className decorator or implementing a method getClassName():string (in which case the module won't be specified).
         * @param object the object to get the class name from
         * @return a string that can have two forms: "moduleName.className" if module was specified when the class' Name was registered or "className" if there was not module specified.
         */
        Tools.getFullClassName = function (object, isType) {
            if (isType === void 0) { isType = false; }
            var className = null;
            var moduleName = null;
            if (!isType && object.getClassName) {
                className = object.getClassName();
            }
            else {
                if (object instanceof Object) {
                    var classObj = isType ? object : Object.getPrototypeOf(object);
                    className = classObj.constructor["__bjsclassName__"];
                    moduleName = classObj.constructor["__bjsmoduleName__"];
                }
                if (!className) {
                    className = typeof object;
                }
            }
            if (!className) {
                return null;
            }
            return ((moduleName != null) ? (moduleName + ".") : "") + className;
        };
        /**
         * This method can be used with hashCodeFromStream when your input is an array of values that are either: number, string, boolean or custom type implementing the getHashCode():number method.
         * @param array
         */
        Tools.arrayOrStringFeeder = function (array) {
            return function (index) {
                if (index >= array.length) {
                    return null;
                }
                var val = array.charCodeAt ? array.charCodeAt(index) : array[index];
                if (val && val.getHashCode) {
                    val = val.getHashCode();
                }
                if (typeof val === "string") {
                    return Tools.hashCodeFromStream(Tools.arrayOrStringFeeder(val));
                }
                return val;
            };
        };
        /**
         * Compute the hashCode of a stream of number
         * To compute the HashCode on a string or an Array of data types implementing the getHashCode() method, use the arrayOrStringFeeder method.
         * @param feeder a callback that will be called until it returns null, each valid returned values will be used to compute the hash code.
         * @return the hash code computed
         */
        Tools.hashCodeFromStream = function (feeder) {
            // Based from here: http://stackoverflow.com/a/7616484/802124
            var hash = 0;
            var index = 0;
            var chr = feeder(index++);
            while (chr != null) {
                hash = ((hash << 5) - hash) + chr;
                hash |= 0; // Convert to 32bit integer
                chr = feeder(index++);
            }
            return hash;
        };
        Tools.BaseUrl = "";
        /**
         * Default behaviour for cors in the application.
         * It can be a string if the expected behavior is identical in the entire app.
         * Or a callback to be able to set it per url or on a group of them (in case of Video source for instance)
         */
        Tools.CorsBehavior = "anonymous";
        Tools.UseFallbackTexture = true;
        /**
         * Use this object to register external classes like custom textures or material
         * to allow the laoders to instantiate them
         */
        Tools.RegisteredExternalClasses = {};
        // Used in case of a texture loading problem 
        Tools.fallbackTexture = "data:image/jpg;base64,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";
        Tools.PreprocessUrl = function (url) {
            return url;
        };
        // Logs
        Tools._NoneLogLevel = 0;
        Tools._MessageLogLevel = 1;
        Tools._WarningLogLevel = 2;
        Tools._ErrorLogLevel = 4;
        Tools._LogCache = "";
        Tools.errorsCount = 0;
        Tools.Log = Tools._LogEnabled;
        Tools.Warn = Tools._WarnEnabled;
        Tools.Error = Tools._ErrorEnabled;
        // Performances
        Tools._PerformanceNoneLogLevel = 0;
        Tools._PerformanceUserMarkLogLevel = 1;
        Tools._PerformanceConsoleLogLevel = 2;
        Tools.StartPerformanceCounter = Tools._StartPerformanceCounterDisabled;
        Tools.EndPerformanceCounter = Tools._EndPerformanceCounterDisabled;
        return Tools;
    }());
    BABYLON.Tools = Tools;
    /**
     * This class is used to track a performance counter which is number based.
     * The user has access to many properties which give statistics of different nature
     *
     * The implementer can track two kinds of Performance Counter: time and count
     * For time you can optionally call fetchNewFrame() to notify the start of a new frame to monitor, then call beginMonitoring() to start and endMonitoring() to record the lapsed time. endMonitoring takes a newFrame parameter for you to specify if the monitored time should be set for a new frame or accumulated to the current frame being monitored.
     * For count you first have to call fetchNewFrame() to notify the start of a new frame to monitor, then call addCount() how many time required to increment the count value you monitor.
     */
    var PerfCounter = /** @class */ (function () {
        function PerfCounter() {
            this._startMonitoringTime = 0;
            this._min = 0;
            this._max = 0;
            this._average = 0;
            this._lastSecAverage = 0;
            this._current = 0;
            this._totalValueCount = 0;
            this._totalAccumulated = 0;
            this._lastSecAccumulated = 0;
            this._lastSecTime = 0;
            this._lastSecValueCount = 0;
        }
        Object.defineProperty(PerfCounter.prototype, "min", {
            /**
             * Returns the smallest value ever
             */
            get: function () {
                return this._min;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PerfCounter.prototype, "max", {
            /**
             * Returns the biggest value ever
             */
            get: function () {
                return this._max;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PerfCounter.prototype, "average", {
            /**
             * Returns the average value since the performance counter is running
             */
            get: function () {
                return this._average;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PerfCounter.prototype, "lastSecAverage", {
            /**
             * Returns the average value of the last second the counter was monitored
             */
            get: function () {
                return this._lastSecAverage;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PerfCounter.prototype, "current", {
            /**
             * Returns the current value
             */
            get: function () {
                return this._current;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PerfCounter.prototype, "total", {
            get: function () {
                return this._totalAccumulated;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PerfCounter.prototype, "count", {
            get: function () {
                return this._totalValueCount;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * Call this method to start monitoring a new frame.
         * This scenario is typically used when you accumulate monitoring time many times for a single frame, you call this method at the start of the frame, then beginMonitoring to start recording and endMonitoring(false) to accumulated the recorded time to the PerfCounter or addCount() to accumulate a monitored count.
         */
        PerfCounter.prototype.fetchNewFrame = function () {
            this._totalValueCount++;
            this._current = 0;
            this._lastSecValueCount++;
        };
        /**
         * Call this method to monitor a count of something (e.g. mesh drawn in viewport count)
         * @param newCount the count value to add to the monitored count
         * @param fetchResult true when it's the last time in the frame you add to the counter and you wish to update the statistics properties (min/max/average), false if you only want to update statistics.
         */
        PerfCounter.prototype.addCount = function (newCount, fetchResult) {
            if (!PerfCounter.Enabled) {
                return;
            }
            this._current += newCount;
            if (fetchResult) {
                this._fetchResult();
            }
        };
        /**
         * Start monitoring this performance counter
         */
        PerfCounter.prototype.beginMonitoring = function () {
            if (!PerfCounter.Enabled) {
                return;
            }
            this._startMonitoringTime = Tools.Now;
        };
        /**
         * Compute the time lapsed since the previous beginMonitoring() call.
         * @param newFrame true by default to fetch the result and monitor a new frame, if false the time monitored will be added to the current frame counter
         */
        PerfCounter.prototype.endMonitoring = function (newFrame) {
            if (newFrame === void 0) { newFrame = true; }
            if (!PerfCounter.Enabled) {
                return;
            }
            if (newFrame) {
                this.fetchNewFrame();
            }
            var currentTime = Tools.Now;
            this._current = currentTime - this._startMonitoringTime;
            if (newFrame) {
                this._fetchResult();
            }
        };
        PerfCounter.prototype._fetchResult = function () {
            this._totalAccumulated += this._current;
            this._lastSecAccumulated += this._current;
            // Min/Max update
            this._min = Math.min(this._min, this._current);
            this._max = Math.max(this._max, this._current);
            this._average = this._totalAccumulated / this._totalValueCount;
            // Reset last sec?
            var now = Tools.Now;
            if ((now - this._lastSecTime) > 1000) {
                this._lastSecAverage = this._lastSecAccumulated / this._lastSecValueCount;
                this._lastSecTime = now;
                this._lastSecAccumulated = 0;
                this._lastSecValueCount = 0;
            }
        };
        PerfCounter.Enabled = true;
        return PerfCounter;
    }());
    BABYLON.PerfCounter = PerfCounter;
    /**
     * Use this className as a decorator on a given class definition to add it a name and optionally its module.
     * You can then use the Tools.getClassName(obj) on an instance to retrieve its class name.
     * This method is the only way to get it done in all cases, even if the .js file declaring the class is minified
     * @param name The name of the class, case should be preserved
     * @param module The name of the Module hosting the class, optional, but strongly recommended to specify if possible. Case should be preserved.
     */
    function className(name, module) {
        return function (target) {
            target["__bjsclassName__"] = name;
            target["__bjsmoduleName__"] = (module != null) ? module : null;
        };
    }
    BABYLON.className = className;
    /**
    * An implementation of a loop for asynchronous functions.
    */
    var AsyncLoop = /** @class */ (function () {
        /**
         * Constroctor.
         * @param iterations the number of iterations.
         * @param _fn the function to run each iteration
         * @param _successCallback the callback that will be called upon succesful execution
         * @param offset starting offset.
         */
        function AsyncLoop(iterations, _fn, _successCallback, offset) {
            if (offset === void 0) { offset = 0; }
            this.iterations = iterations;
            this._fn = _fn;
            this._successCallback = _successCallback;
            this.index = offset - 1;
            this._done = false;
        }
        /**
         * Execute the next iteration. Must be called after the last iteration was finished.
         */
        AsyncLoop.prototype.executeNext = function () {
            if (!this._done) {
                if (this.index + 1 < this.iterations) {
                    ++this.index;
                    this._fn(this);
                }
                else {
                    this.breakLoop();
                }
            }
        };
        /**
         * Break the loop and run the success callback.
         */
        AsyncLoop.prototype.breakLoop = function () {
            this._done = true;
            this._successCallback();
        };
        /**
         * Helper function
         */
        AsyncLoop.Run = function (iterations, _fn, _successCallback, offset) {
            if (offset === void 0) { offset = 0; }
            var loop = new AsyncLoop(iterations, _fn, _successCallback, offset);
            loop.executeNext();
            return loop;
        };
        /**
         * A for-loop that will run a given number of iterations synchronous and the rest async.
         * @param iterations total number of iterations
         * @param syncedIterations number of synchronous iterations in each async iteration.
         * @param fn the function to call each iteration.
         * @param callback a success call back that will be called when iterating stops.
         * @param breakFunction a break condition (optional)
         * @param timeout timeout settings for the setTimeout function. default - 0.
         * @constructor
         */
        AsyncLoop.SyncAsyncForLoop = function (iterations, syncedIterations, fn, callback, breakFunction, timeout) {
            if (timeout === void 0) { timeout = 0; }
            AsyncLoop.Run(Math.ceil(iterations / syncedIterations), function (loop) {
                if (breakFunction && breakFunction())
                    loop.breakLoop();
                else {
                    setTimeout(function () {
                        for (var i = 0; i < syncedIterations; ++i) {
                            var iteration = (loop.index * syncedIterations) + i;
                            if (iteration >= iterations)
                                break;
                            fn(iteration);
                            if (breakFunction && breakFunction()) {
                                loop.breakLoop();
                                break;
                            }
                        }
                        loop.executeNext();
                    }, timeout);
                }
            }, callback);
        };
        return AsyncLoop;
    }());
    BABYLON.AsyncLoop = AsyncLoop;
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.tools.js.map

var BABYLON;
(function (BABYLON) {
    var Internals;
    (function (Internals) {
        var _AlphaState = /** @class */ (function () {
            /**
             * Initializes the state.
             */
            function _AlphaState() {
                this._isAlphaBlendDirty = false;
                this._isBlendFunctionParametersDirty = false;
                this._isBlendEquationParametersDirty = false;
                this._isBlendConstantsDirty = false;
                this._alphaBlend = false;
                this._blendFunctionParameters = new Array(4);
                this._blendEquationParameters = new Array(2);
                this._blendConstants = new Array(4);
                this.reset();
            }
            Object.defineProperty(_AlphaState.prototype, "isDirty", {
                get: function () {
                    return this._isAlphaBlendDirty || this._isBlendFunctionParametersDirty;
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(_AlphaState.prototype, "alphaBlend", {
                get: function () {
                    return this._alphaBlend;
                },
                set: function (value) {
                    if (this._alphaBlend === value) {
                        return;
                    }
                    this._alphaBlend = value;
                    this._isAlphaBlendDirty = true;
                },
                enumerable: true,
                configurable: true
            });
            _AlphaState.prototype.setAlphaBlendConstants = function (r, g, b, a) {
                if (this._blendConstants[0] === r &&
                    this._blendConstants[1] === g &&
                    this._blendConstants[2] === b &&
                    this._blendConstants[3] === a) {
                    return;
                }
                this._blendConstants[0] = r;
                this._blendConstants[1] = g;
                this._blendConstants[2] = b;
                this._blendConstants[3] = a;
                this._isBlendConstantsDirty = true;
            };
            _AlphaState.prototype.setAlphaBlendFunctionParameters = function (value0, value1, value2, value3) {
                if (this._blendFunctionParameters[0] === value0 &&
                    this._blendFunctionParameters[1] === value1 &&
                    this._blendFunctionParameters[2] === value2 &&
                    this._blendFunctionParameters[3] === value3) {
                    return;
                }
                this._blendFunctionParameters[0] = value0;
                this._blendFunctionParameters[1] = value1;
                this._blendFunctionParameters[2] = value2;
                this._blendFunctionParameters[3] = value3;
                this._isBlendFunctionParametersDirty = true;
            };
            _AlphaState.prototype.setAlphaEquationParameters = function (rgb, alpha) {
                if (this._blendEquationParameters[0] === rgb &&
                    this._blendEquationParameters[1] === alpha) {
                    return;
                }
                this._blendEquationParameters[0] = rgb;
                this._blendEquationParameters[1] = alpha;
                this._isBlendEquationParametersDirty = true;
            };
            _AlphaState.prototype.reset = function () {
                this._alphaBlend = false;
                this._blendFunctionParameters[0] = null;
                this._blendFunctionParameters[1] = null;
                this._blendFunctionParameters[2] = null;
                this._blendFunctionParameters[3] = null;
                this._blendEquationParameters[0] = null;
                this._blendEquationParameters[1] = null;
                this._blendConstants[0] = null;
                this._blendConstants[1] = null;
                this._blendConstants[2] = null;
                this._blendConstants[3] = null;
                this._isAlphaBlendDirty = true;
                this._isBlendFunctionParametersDirty = false;
                this._isBlendEquationParametersDirty = false;
                this._isBlendConstantsDirty = false;
            };
            _AlphaState.prototype.apply = function (gl) {
                if (!this.isDirty) {
                    return;
                }
                // Alpha blend
                if (this._isAlphaBlendDirty) {
                    if (this._alphaBlend) {
                        gl.enable(gl.BLEND);
                    }
                    else {
                        gl.disable(gl.BLEND);
                    }
                    this._isAlphaBlendDirty = false;
                }
                // Alpha function
                if (this._isBlendFunctionParametersDirty) {
                    gl.blendFuncSeparate(this._blendFunctionParameters[0], this._blendFunctionParameters[1], this._blendFunctionParameters[2], this._blendFunctionParameters[3]);
                    this._isBlendFunctionParametersDirty = false;
                }
                // Alpha equation
                if (this._isBlendEquationParametersDirty) {
                    gl.blendEquationSeparate(this._isBlendEquationParametersDirty[0], this._isBlendEquationParametersDirty[1]);
                    this._isBlendEquationParametersDirty = false;
                }
                // Constants
                if (this._isBlendConstantsDirty) {
                    gl.blendColor(this._blendConstants[0], this._blendConstants[1], this._blendConstants[2], this._blendConstants[3]);
                    this._isBlendConstantsDirty = false;
                }
            };
            return _AlphaState;
        }());
        Internals._AlphaState = _AlphaState;
    })(Internals = BABYLON.Internals || (BABYLON.Internals = {}));
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.alphaCullingState.js.map

var BABYLON;
(function (BABYLON) {
    var Internals;
    (function (Internals) {
        var _DepthCullingState = /** @class */ (function () {
            /**
             * Initializes the state.
             */
            function _DepthCullingState() {
                this._isDepthTestDirty = false;
                this._isDepthMaskDirty = false;
                this._isDepthFuncDirty = false;
                this._isCullFaceDirty = false;
                this._isCullDirty = false;
                this._isZOffsetDirty = false;
                this.reset();
            }
            Object.defineProperty(_DepthCullingState.prototype, "isDirty", {
                get: function () {
                    return this._isDepthFuncDirty || this._isDepthTestDirty || this._isDepthMaskDirty || this._isCullFaceDirty || this._isCullDirty || this._isZOffsetDirty;
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(_DepthCullingState.prototype, "zOffset", {
                get: function () {
                    return this._zOffset;
                },
                set: function (value) {
                    if (this._zOffset === value) {
                        return;
                    }
                    this._zOffset = value;
                    this._isZOffsetDirty = true;
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(_DepthCullingState.prototype, "cullFace", {
                get: function () {
                    return this._cullFace;
                },
                set: function (value) {
                    if (this._cullFace === value) {
                        return;
                    }
                    this._cullFace = value;
                    this._isCullFaceDirty = true;
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(_DepthCullingState.prototype, "cull", {
                get: function () {
                    return this._cull;
                },
                set: function (value) {
                    if (this._cull === value) {
                        return;
                    }
                    this._cull = value;
                    this._isCullDirty = true;
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(_DepthCullingState.prototype, "depthFunc", {
                get: function () {
                    return this._depthFunc;
                },
                set: function (value) {
                    if (this._depthFunc === value) {
                        return;
                    }
                    this._depthFunc = value;
                    this._isDepthFuncDirty = true;
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(_DepthCullingState.prototype, "depthMask", {
                get: function () {
                    return this._depthMask;
                },
                set: function (value) {
                    if (this._depthMask === value) {
                        return;
                    }
                    this._depthMask = value;
                    this._isDepthMaskDirty = true;
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(_DepthCullingState.prototype, "depthTest", {
                get: function () {
                    return this._depthTest;
                },
                set: function (value) {
                    if (this._depthTest === value) {
                        return;
                    }
                    this._depthTest = value;
                    this._isDepthTestDirty = true;
                },
                enumerable: true,
                configurable: true
            });
            _DepthCullingState.prototype.reset = function () {
                this._depthMask = true;
                this._depthTest = true;
                this._depthFunc = null;
                this._cullFace = null;
                this._cull = null;
                this._zOffset = 0;
                this._isDepthTestDirty = true;
                this._isDepthMaskDirty = true;
                this._isDepthFuncDirty = false;
                this._isCullFaceDirty = false;
                this._isCullDirty = false;
                this._isZOffsetDirty = false;
            };
            _DepthCullingState.prototype.apply = function (gl) {
                if (!this.isDirty) {
                    return;
                }
                // Cull
                if (this._isCullDirty) {
                    if (this.cull) {
                        gl.enable(gl.CULL_FACE);
                    }
                    else {
                        gl.disable(gl.CULL_FACE);
                    }
                    this._isCullDirty = false;
                }
                // Cull face
                if (this._isCullFaceDirty) {
                    gl.cullFace(this.cullFace);
                    this._isCullFaceDirty = false;
                }
                // Depth mask
                if (this._isDepthMaskDirty) {
                    gl.depthMask(this.depthMask);
                    this._isDepthMaskDirty = false;
                }
                // Depth test
                if (this._isDepthTestDirty) {
                    if (this.depthTest) {
                        gl.enable(gl.DEPTH_TEST);
                    }
                    else {
                        gl.disable(gl.DEPTH_TEST);
                    }
                    this._isDepthTestDirty = false;
                }
                // Depth func
                if (this._isDepthFuncDirty) {
                    gl.depthFunc(this.depthFunc);
                    this._isDepthFuncDirty = false;
                }
                // zOffset
                if (this._isZOffsetDirty) {
                    if (this.zOffset) {
                        gl.enable(gl.POLYGON_OFFSET_FILL);
                        gl.polygonOffset(this.zOffset, 0);
                    }
                    else {
                        gl.disable(gl.POLYGON_OFFSET_FILL);
                    }
                    this._isZOffsetDirty = false;
                }
            };
            return _DepthCullingState;
        }());
        Internals._DepthCullingState = _DepthCullingState;
    })(Internals = BABYLON.Internals || (BABYLON.Internals = {}));
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.depthCullingState.js.map

var BABYLON;
(function (BABYLON) {
    var Internals;
    (function (Internals) {
        var _StencilState = /** @class */ (function () {
            function _StencilState() {
                this._isStencilTestDirty = false;
                this._isStencilMaskDirty = false;
                this._isStencilFuncDirty = false;
                this._isStencilOpDirty = false;
                this.reset();
            }
            Object.defineProperty(_StencilState.prototype, "isDirty", {
                get: function () {
                    return this._isStencilTestDirty || this._isStencilMaskDirty || this._isStencilFuncDirty || this._isStencilOpDirty;
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(_StencilState.prototype, "stencilFunc", {
                get: function () {
                    return this._stencilFunc;
                },
                set: function (value) {
                    if (this._stencilFunc === value) {
                        return;
                    }
                    this._stencilFunc = value;
                    this._isStencilFuncDirty = true;
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(_StencilState.prototype, "stencilFuncRef", {
                get: function () {
                    return this._stencilFuncRef;
                },
                set: function (value) {
                    if (this._stencilFuncRef === value) {
                        return;
                    }
                    this._stencilFuncRef = value;
                    this._isStencilFuncDirty = true;
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(_StencilState.prototype, "stencilFuncMask", {
                get: function () {
                    return this._stencilFuncMask;
                },
                set: function (value) {
                    if (this._stencilFuncMask === value) {
                        return;
                    }
                    this._stencilFuncMask = value;
                    this._isStencilFuncDirty = true;
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(_StencilState.prototype, "stencilOpStencilFail", {
                get: function () {
                    return this._stencilOpStencilFail;
                },
                set: function (value) {
                    if (this._stencilOpStencilFail === value) {
                        return;
                    }
                    this._stencilOpStencilFail = value;
                    this._isStencilOpDirty = true;
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(_StencilState.prototype, "stencilOpDepthFail", {
                get: function () {
                    return this._stencilOpDepthFail;
                },
                set: function (value) {
                    if (this._stencilOpDepthFail === value) {
                        return;
                    }
                    this._stencilOpDepthFail = value;
                    this._isStencilOpDirty = true;
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(_StencilState.prototype, "stencilOpStencilDepthPass", {
                get: function () {
                    return this._stencilOpStencilDepthPass;
                },
                set: function (value) {
                    if (this._stencilOpStencilDepthPass === value) {
                        return;
                    }
                    this._stencilOpStencilDepthPass = value;
                    this._isStencilOpDirty = true;
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(_StencilState.prototype, "stencilMask", {
                get: function () {
                    return this._stencilMask;
                },
                set: function (value) {
                    if (this._stencilMask === value) {
                        return;
                    }
                    this._stencilMask = value;
                    this._isStencilMaskDirty = true;
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(_StencilState.prototype, "stencilTest", {
                get: function () {
                    return this._stencilTest;
                },
                set: function (value) {
                    if (this._stencilTest === value) {
                        return;
                    }
                    this._stencilTest = value;
                    this._isStencilTestDirty = true;
                },
                enumerable: true,
                configurable: true
            });
            _StencilState.prototype.reset = function () {
                this._stencilTest = false;
                this._stencilMask = 0xFF;
                this._stencilFunc = BABYLON.Engine.ALWAYS;
                this._stencilFuncRef = 1;
                this._stencilFuncMask = 0xFF;
                this._stencilOpStencilFail = BABYLON.Engine.KEEP;
                this._stencilOpDepthFail = BABYLON.Engine.KEEP;
                this._stencilOpStencilDepthPass = BABYLON.Engine.REPLACE;
                this._isStencilTestDirty = true;
                this._isStencilMaskDirty = true;
                this._isStencilFuncDirty = true;
                this._isStencilOpDirty = true;
            };
            _StencilState.prototype.apply = function (gl) {
                if (!this.isDirty) {
                    return;
                }
                // Stencil test
                if (this._isStencilTestDirty) {
                    if (this.stencilTest) {
                        gl.enable(gl.STENCIL_TEST);
                    }
                    else {
                        gl.disable(gl.STENCIL_TEST);
                    }
                    this._isStencilTestDirty = false;
                }
                // Stencil mask
                if (this._isStencilMaskDirty) {
                    gl.stencilMask(this.stencilMask);
                    this._isStencilMaskDirty = false;
                }
                // Stencil func
                if (this._isStencilFuncDirty) {
                    gl.stencilFunc(this.stencilFunc, this.stencilFuncRef, this.stencilFuncMask);
                    this._isStencilFuncDirty = false;
                }
                // Stencil op
                if (this._isStencilOpDirty) {
                    gl.stencilOp(this.stencilOpStencilFail, this.stencilOpDepthFail, this.stencilOpStencilDepthPass);
                    this._isStencilOpDirty = false;
                }
            };
            return _StencilState;
        }());
        Internals._StencilState = _StencilState;
    })(Internals = BABYLON.Internals || (BABYLON.Internals = {}));
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.stencilState.js.map

var BABYLON;
(function (BABYLON) {
    var compileShader = function (gl, source, type, defines, shaderVersion) {
        return compileRawShader(gl, shaderVersion + (defines ? defines + "\n" : "") + source, type);
    };
    var compileRawShader = function (gl, source, type) {
        var shader = gl.createShader(type === "vertex" ? gl.VERTEX_SHADER : gl.FRAGMENT_SHADER);
        gl.shaderSource(shader, source);
        gl.compileShader(shader);
        if (!gl.getShaderParameter(shader, gl.COMPILE_STATUS)) {
            var log = gl.getShaderInfoLog(shader);
            if (log) {
                throw new Error(log);
            }
        }
        if (!shader) {
            throw new Error("Something went wrong while compile the shader.");
        }
        return shader;
    };
    var getSamplingParameters = function (samplingMode, generateMipMaps, gl) {
        var magFilter = gl.NEAREST;
        var minFilter = gl.NEAREST;
        switch (samplingMode) {
            case BABYLON.Texture.BILINEAR_SAMPLINGMODE:
                magFilter = gl.LINEAR;
                if (generateMipMaps) {
                    minFilter = gl.LINEAR_MIPMAP_NEAREST;
                }
                else {
                    minFilter = gl.LINEAR;
                }
                break;
            case BABYLON.Texture.TRILINEAR_SAMPLINGMODE:
                magFilter = gl.LINEAR;
                if (generateMipMaps) {
                    minFilter = gl.LINEAR_MIPMAP_LINEAR;
                }
                else {
                    minFilter = gl.LINEAR;
                }
                break;
            case BABYLON.Texture.NEAREST_SAMPLINGMODE:
                magFilter = gl.NEAREST;
                if (generateMipMaps) {
                    minFilter = gl.NEAREST_MIPMAP_LINEAR;
                }
                else {
                    minFilter = gl.NEAREST;
                }
                break;
            case BABYLON.Texture.NEAREST_NEAREST_MIPNEAREST:
                magFilter = gl.NEAREST;
                if (generateMipMaps) {
                    minFilter = gl.NEAREST_MIPMAP_NEAREST;
                }
                else {
                    minFilter = gl.NEAREST;
                }
                break;
            case BABYLON.Texture.NEAREST_LINEAR_MIPNEAREST:
                magFilter = gl.NEAREST;
                if (generateMipMaps) {
                    minFilter = gl.LINEAR_MIPMAP_NEAREST;
                }
                else {
                    minFilter = gl.LINEAR;
                }
                break;
            case BABYLON.Texture.NEAREST_LINEAR_MIPLINEAR:
                magFilter = gl.NEAREST;
                if (generateMipMaps) {
                    minFilter = gl.LINEAR_MIPMAP_LINEAR;
                }
                else {
                    minFilter = gl.LINEAR;
                }
                break;
            case BABYLON.Texture.NEAREST_LINEAR:
                magFilter = gl.NEAREST;
                minFilter = gl.LINEAR;
                break;
            case BABYLON.Texture.NEAREST_NEAREST:
                magFilter = gl.NEAREST;
                minFilter = gl.NEAREST;
                break;
            case BABYLON.Texture.LINEAR_NEAREST_MIPNEAREST:
                magFilter = gl.LINEAR;
                if (generateMipMaps) {
                    minFilter = gl.NEAREST_MIPMAP_NEAREST;
                }
                else {
                    minFilter = gl.NEAREST;
                }
                break;
            case BABYLON.Texture.LINEAR_NEAREST_MIPLINEAR:
                magFilter = gl.LINEAR;
                if (generateMipMaps) {
                    minFilter = gl.NEAREST_MIPMAP_LINEAR;
                }
                else {
                    minFilter = gl.NEAREST;
                }
                break;
            case BABYLON.Texture.LINEAR_LINEAR:
                magFilter = gl.LINEAR;
                minFilter = gl.LINEAR;
                break;
            case BABYLON.Texture.LINEAR_NEAREST:
                magFilter = gl.LINEAR;
                minFilter = gl.NEAREST;
                break;
        }
        return {
            min: minFilter,
            mag: magFilter
        };
    };
    var partialLoadImg = function (url, index, loadedImages, scene, onfinish, onErrorCallBack) {
        if (onErrorCallBack === void 0) { onErrorCallBack = null; }
        var img;
        var onload = function () {
            loadedImages[index] = img;
            loadedImages._internalCount++;
            if (scene) {
                scene._removePendingData(img);
            }
            if (loadedImages._internalCount === 6) {
                onfinish(loadedImages);
            }
        };
        var onerror = function (message, exception) {
            if (scene) {
                scene._removePendingData(img);
            }
            if (onErrorCallBack) {
                onErrorCallBack(message, exception);
            }
        };
        img = BABYLON.Tools.LoadImage(url, onload, onerror, scene ? scene.database : null);
        if (scene) {
            scene._addPendingData(img);
        }
    };
    var cascadeLoadImgs = function (rootUrl, scene, onfinish, files, onError) {
        if (onError === void 0) { onError = null; }
        var loadedImages = [];
        loadedImages._internalCount = 0;
        for (var index = 0; index < 6; index++) {
            partialLoadImg(files[index], index, loadedImages, scene, onfinish, onError);
        }
    };
    var partialLoadFile = function (url, index, loadedFiles, scene, onfinish, onErrorCallBack) {
        if (onErrorCallBack === void 0) { onErrorCallBack = null; }
        var onload = function (data) {
            loadedFiles[index] = data;
            loadedFiles._internalCount++;
            if (loadedFiles._internalCount === 6) {
                onfinish(loadedFiles);
            }
        };
        var onerror = function (request, exception) {
            if (onErrorCallBack && request) {
                onErrorCallBack(request.status + " " + request.statusText, exception);
            }
        };
        BABYLON.Tools.LoadFile(url, onload, undefined, undefined, true, onerror);
    };
    var cascadeLoadFiles = function (rootUrl, scene, onfinish, files, onError) {
        if (onError === void 0) { onError = null; }
        var loadedFiles = [];
        loadedFiles._internalCount = 0;
        for (var index = 0; index < 6; index++) {
            partialLoadFile(files[index], index, loadedFiles, scene, onfinish, onError);
        }
    };
    var BufferPointer = /** @class */ (function () {
        function BufferPointer() {
        }
        return BufferPointer;
    }());
    var InstancingAttributeInfo = /** @class */ (function () {
        function InstancingAttributeInfo() {
        }
        return InstancingAttributeInfo;
    }());
    BABYLON.InstancingAttributeInfo = InstancingAttributeInfo;
    /**
     * Define options used to create a render target texture
     */
    var RenderTargetCreationOptions = /** @class */ (function () {
        function RenderTargetCreationOptions() {
        }
        return RenderTargetCreationOptions;
    }());
    BABYLON.RenderTargetCreationOptions = RenderTargetCreationOptions;
    /**
     * Regroup several parameters relative to the browser in use
     */
    var EngineCapabilities = /** @class */ (function () {
        function EngineCapabilities() {
        }
        return EngineCapabilities;
    }());
    BABYLON.EngineCapabilities = EngineCapabilities;
    /**
     * The engine class is responsible for interfacing with all lower-level APIs such as WebGL and Audio.
     */
    var Engine = /** @class */ (function () {
        /**
         * @constructor
         * @param {HTMLCanvasElement | WebGLRenderingContext} canvasOrContext - the canvas or the webgl context to be used for rendering
         * @param {boolean} [antialias] - enable antialias
         * @param options - further options to be sent to the getContext function
         */
        function Engine(canvasOrContext, antialias, options, adaptToDeviceRatio) {
            if (adaptToDeviceRatio === void 0) { adaptToDeviceRatio = false; }
            var _this = this;
            // Public members
            this.forcePOTTextures = false;
            this.isFullscreen = false;
            this.isPointerLock = false;
            this.cullBackFaces = true;
            this.renderEvenInBackground = true;
            this.preventCacheWipeBetweenFrames = false;
            // To enable/disable IDB support and avoid XHR on .manifest
            this.enableOfflineSupport = false;
            this.scenes = new Array();
            this.postProcesses = new Array();
            // Observables
            /**
             * Observable event triggered each time the rendering canvas is resized
             */
            this.onResizeObservable = new BABYLON.Observable();
            /**
             * Observable event triggered each time the canvas loses focus
             */
            this.onCanvasBlurObservable = new BABYLON.Observable();
            /**
             * Observable event triggered each time the canvas gains focus
             */
            this.onCanvasFocusObservable = new BABYLON.Observable();
            /**
             * Observable event triggered each time the canvas receives pointerout event
             */
            this.onCanvasPointerOutObservable = new BABYLON.Observable();
            /**
             * Observable event triggered before each texture is initialized
             */
            this.onBeforeTextureInitObservable = new BABYLON.Observable();
            //WebVR
            this._vrDisplay = undefined;
            this._vrSupported = false;
            this._vrExclusivePointerMode = false;
            // Uniform buffers list
            this.disableUniformBuffers = false;
            this._uniformBuffers = new Array();
            // Observables
            /**
             * Observable raised when the engine begins a new frame
             */
            this.onBeginFrameObservable = new BABYLON.Observable();
            /**
             * Observable raised when the engine ends the current frame
             */
            this.onEndFrameObservable = new BABYLON.Observable();
            /**
             * Observable raised when the engine is about to compile a shader
             */
            this.onBeforeShaderCompilationObservable = new BABYLON.Observable();
            /**
             * Observable raised when the engine has jsut compiled a shader
             */
            this.onAfterShaderCompilationObservable = new BABYLON.Observable();
            this._windowIsBackground = false;
            this._webGLVersion = 1.0;
            this._badOS = false;
            this._badDesktopOS = false;
            this.onVRDisplayChangedObservable = new BABYLON.Observable();
            this.onVRRequestPresentComplete = new BABYLON.Observable();
            this.onVRRequestPresentStart = new BABYLON.Observable();
            this._colorWrite = true;
            this._drawCalls = new BABYLON.PerfCounter();
            this._renderingQueueLaunched = false;
            this._activeRenderLoops = new Array();
            // Deterministic lockstepMaxSteps
            this._deterministicLockstep = false;
            this._lockstepMaxSteps = 4;
            // Lost context
            this.onContextLostObservable = new BABYLON.Observable();
            this.onContextRestoredObservable = new BABYLON.Observable();
            this._contextWasLost = false;
            this._doNotHandleContextLost = false;
            // FPS
            this._performanceMonitor = new BABYLON.PerformanceMonitor();
            this._fps = 60;
            this._deltaTime = 0;
            /**
             * Turn this value on if you want to pause FPS computation when in background
             */
            this.disablePerformanceMonitorInBackground = false;
            // States
            this._depthCullingState = new BABYLON.Internals._DepthCullingState();
            this._stencilState = new BABYLON.Internals._StencilState();
            this._alphaState = new BABYLON.Internals._AlphaState();
            this._alphaMode = Engine.ALPHA_DISABLE;
            // Cache
            this._internalTexturesCache = new Array();
            this._boundTexturesCache = {};
            this._compiledEffects = {};
            this._vertexAttribArraysEnabled = [];
            this._uintIndicesCurrentlySet = false;
            this._currentBoundBuffer = new Array();
            this._currentBufferPointers = new Array();
            this._currentInstanceLocations = new Array();
            this._currentInstanceBuffers = new Array();
            this._vaoRecordInProgress = false;
            this._mustWipeVertexAttributes = false;
            // Hardware supported Compressed Textures
            this._texturesSupported = new Array();
            this._onVRFullScreenTriggered = function () {
                if (_this._vrDisplay && _this._vrDisplay.isPresenting) {
                    //get the old size before we change
                    _this._oldSize = new BABYLON.Size(_this.getRenderWidth(), _this.getRenderHeight());
                    _this._oldHardwareScaleFactor = _this.getHardwareScalingLevel();
                    //get the width and height, change the render size
                    var leftEye = _this._vrDisplay.getEyeParameters('left');
                    _this.setHardwareScalingLevel(1);
                    _this.setSize(leftEye.renderWidth * 2, leftEye.renderHeight);
                }
                else {
                    _this.setHardwareScalingLevel(_this._oldHardwareScaleFactor);
                    _this.setSize(_this._oldSize.width, _this._oldSize.height);
                }
            };
            var canvas = null;
            Engine.Instances.push(this);
            if (!canvasOrContext) {
                return;
            }
            options = options || {};
            if (canvasOrContext.getContext) {
                canvas = canvasOrContext;
                this._renderingCanvas = canvas;
                if (antialias != null) {
                    options.antialias = antialias;
                }
                if (options.deterministicLockstep === undefined) {
                    options.deterministicLockstep = false;
                }
                if (options.lockstepMaxSteps === undefined) {
                    options.lockstepMaxSteps = 4;
                }
                if (options.preserveDrawingBuffer === undefined) {
                    options.preserveDrawingBuffer = false;
                }
                if (options.audioEngine === undefined) {
                    options.audioEngine = true;
                }
                if (options.stencil === undefined) {
                    options.stencil = true;
                }
                this._deterministicLockstep = options.deterministicLockstep;
                this._lockstepMaxSteps = options.lockstepMaxSteps;
                this._doNotHandleContextLost = options.doNotHandleContextLost ? true : false;
                // Exceptions
                if (!options.disableWebGL2Support) {
                    if (navigator && navigator.userAgent) {
                        var ua = navigator.userAgent;
                        for (var _i = 0, _a = Engine.WebGL2UniformBuffersExceptionList; _i < _a.length; _i++) {
                            var exception = _a[_i];
                            if (ua.indexOf(exception) > -1) {
                                this.disableUniformBuffers = true;
                                break;
                            }
                        }
                    }
                }
                // GL
                if (!options.disableWebGL2Support) {
                    try {
                        this._gl = (canvas.getContext("webgl2", options) || canvas.getContext("experimental-webgl2", options));
                        if (this._gl) {
                            this._webGLVersion = 2.0;
                        }
                    }
                    catch (e) {
                        // Do nothing
                    }
                }
                if (!this._gl) {
                    if (!canvas) {
                        throw new Error("The provided canvas is null or undefined.");
                    }
                    try {
                        this._gl = (canvas.getContext("webgl", options) || canvas.getContext("experimental-webgl", options));
                    }
                    catch (e) {
                        throw new Error("WebGL not supported");
                    }
                }
                if (!this._gl) {
                    throw new Error("WebGL not supported");
                }
                this._onCanvasFocus = function () {
                    _this.onCanvasFocusObservable.notifyObservers(_this);
                };
                this._onCanvasBlur = function () {
                    _this.onCanvasBlurObservable.notifyObservers(_this);
                };
                canvas.addEventListener("focus", this._onCanvasFocus);
                canvas.addEventListener("blur", this._onCanvasBlur);
                this._onBlur = function () {
                    if (_this.disablePerformanceMonitorInBackground) {
                        _this._performanceMonitor.disable();
                    }
                    _this._windowIsBackground = true;
                };
                this._onFocus = function () {
                    if (_this.disablePerformanceMonitorInBackground) {
                        _this._performanceMonitor.enable();
                    }
                    _this._windowIsBackground = false;
                };
                this._onCanvasPointerOut = function () {
                    _this.onCanvasPointerOutObservable.notifyObservers(_this);
                };
                window.addEventListener("blur", this._onBlur);
                window.addEventListener("focus", this._onFocus);
                canvas.addEventListener("pointerout", this._onCanvasPointerOut);
                // Context lost
                if (!this._doNotHandleContextLost) {
                    this._onContextLost = function (evt) {
                        evt.preventDefault();
                        _this._contextWasLost = true;
                        BABYLON.Tools.Warn("WebGL context lost.");
                        _this.onContextLostObservable.notifyObservers(_this);
                    };
                    this._onContextRestored = function (evt) {
                        // Adding a timeout to avoid race condition at browser level
                        setTimeout(function () {
                            // Rebuild gl context
                            _this._initGLContext();
                            // Rebuild effects
                            _this._rebuildEffects();
                            // Rebuild textures
                            _this._rebuildInternalTextures();
                            // Rebuild buffers
                            _this._rebuildBuffers();
                            // Cache
                            _this.wipeCaches(true);
                            BABYLON.Tools.Warn("WebGL context successfully restored.");
                            _this.onContextRestoredObservable.notifyObservers(_this);
                            _this._contextWasLost = false;
                        }, 0);
                    };
                    canvas.addEventListener("webglcontextlost", this._onContextLost, false);
                    canvas.addEventListener("webglcontextrestored", this._onContextRestored, false);
                }
            }
            else {
                this._gl = canvasOrContext;
                this._renderingCanvas = this._gl.canvas;
                if (this._gl.renderbufferStorageMultisample) {
                    this._webGLVersion = 2.0;
                }
                options.stencil = this._gl.getContextAttributes().stencil;
            }
            // Viewport
            var limitDeviceRatio = options.limitDeviceRatio || window.devicePixelRatio || 1.0;
            this._hardwareScalingLevel = adaptToDeviceRatio ? 1.0 / Math.min(limitDeviceRatio, window.devicePixelRatio || 1.0) : 1.0;
            this.resize();
            this._isStencilEnable = options.stencil ? true : false;
            this._initGLContext();
            if (canvas) {
                // Fullscreen
                this._onFullscreenChange = function () {
                    if (document.fullscreen !== undefined) {
                        _this.isFullscreen = document.fullscreen;
                    }
                    else if (document.mozFullScreen !== undefined) {
                        _this.isFullscreen = document.mozFullScreen;
                    }
                    else if (document.webkitIsFullScreen !== undefined) {
                        _this.isFullscreen = document.webkitIsFullScreen;
                    }
                    else if (document.msIsFullScreen !== undefined) {
                        _this.isFullscreen = document.msIsFullScreen;
                    }
                    // Pointer lock
                    if (_this.isFullscreen && _this._pointerLockRequested && canvas) {
                        canvas.requestPointerLock = canvas.requestPointerLock ||
                            canvas.msRequestPointerLock ||
                            canvas.mozRequestPointerLock ||
                            canvas.webkitRequestPointerLock;
                        if (canvas.requestPointerLock) {
                            canvas.requestPointerLock();
                        }
                    }
                };
                document.addEventListener("fullscreenchange", this._onFullscreenChange, false);
                document.addEventListener("mozfullscreenchange", this._onFullscreenChange, false);
                document.addEventListener("webkitfullscreenchange", this._onFullscreenChange, false);
                document.addEventListener("msfullscreenchange", this._onFullscreenChange, false);
                // Pointer lock
                this._onPointerLockChange = function () {
                    _this.isPointerLock = (document.mozPointerLockElement === canvas ||
                        document.webkitPointerLockElement === canvas ||
                        document.msPointerLockElement === canvas ||
                        document.pointerLockElement === canvas);
                };
                document.addEventListener("pointerlockchange", this._onPointerLockChange, false);
                document.addEventListener("mspointerlockchange", this._onPointerLockChange, false);
                document.addEventListener("mozpointerlockchange", this._onPointerLockChange, false);
                document.addEventListener("webkitpointerlockchange", this._onPointerLockChange, false);
                this._onVRDisplayPointerRestricted = function () {
                    if (canvas) {
                        canvas.requestPointerLock();
                    }
                };
                this._onVRDisplayPointerUnrestricted = function () {
                    document.exitPointerLock();
                };
                window.addEventListener('vrdisplaypointerrestricted', this._onVRDisplayPointerRestricted, false);
                window.addEventListener('vrdisplaypointerunrestricted', this._onVRDisplayPointerUnrestricted, false);
            }
            if (options.audioEngine && BABYLON.AudioEngine && !Engine.audioEngine) {
                Engine.audioEngine = new BABYLON.AudioEngine();
            }
            // Prepare buffer pointers
            for (var i = 0; i < this._caps.maxVertexAttribs; i++) {
                this._currentBufferPointers[i] = new BufferPointer();
            }
            // Load WebVR Devices
            if (options.autoEnableWebVR) {
                this.initWebVR();
            }
            // Detect if we are running on a faulty buggy OS.
            this._badOS = /iPad/i.test(navigator.userAgent) || /iPhone/i.test(navigator.userAgent);
            // Detect if we are running on a faulty buggy desktop OS.
            this._badDesktopOS = /^((?!chrome|android).)*safari/i.test(navigator.userAgent);
            BABYLON.Tools.Log("Babylon.js engine (v" + Engine.Version + ") launched");
            this.enableOfflineSupport = (BABYLON.Database !== undefined);
        }
        Object.defineProperty(Engine, "LastCreatedEngine", {
            get: function () {
                if (Engine.Instances.length === 0) {
                    return null;
                }
                return Engine.Instances[Engine.Instances.length - 1];
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "LastCreatedScene", {
            get: function () {
                var lastCreatedEngine = Engine.LastCreatedEngine;
                if (!lastCreatedEngine) {
                    return null;
                }
                if (lastCreatedEngine.scenes.length === 0) {
                    return null;
                }
                return lastCreatedEngine.scenes[lastCreatedEngine.scenes.length - 1];
            },
            enumerable: true,
            configurable: true
        });
        /**
         * Will flag all materials in all scenes in all engines as dirty to trigger new shader compilation
         */
        Engine.MarkAllMaterialsAsDirty = function (flag, predicate) {
            for (var engineIndex = 0; engineIndex < Engine.Instances.length; engineIndex++) {
                var engine = Engine.Instances[engineIndex];
                for (var sceneIndex = 0; sceneIndex < engine.scenes.length; sceneIndex++) {
                    engine.scenes[sceneIndex].markAllMaterialsAsDirty(flag, predicate);
                }
            }
        };
        Object.defineProperty(Engine, "NEVER", {
            get: function () {
                return Engine._NEVER;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "ALWAYS", {
            get: function () {
                return Engine._ALWAYS;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "LESS", {
            get: function () {
                return Engine._LESS;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "EQUAL", {
            get: function () {
                return Engine._EQUAL;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "LEQUAL", {
            get: function () {
                return Engine._LEQUAL;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "GREATER", {
            get: function () {
                return Engine._GREATER;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "GEQUAL", {
            get: function () {
                return Engine._GEQUAL;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "NOTEQUAL", {
            get: function () {
                return Engine._NOTEQUAL;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "KEEP", {
            get: function () {
                return Engine._KEEP;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "REPLACE", {
            get: function () {
                return Engine._REPLACE;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "INCR", {
            get: function () {
                return Engine._INCR;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "DECR", {
            get: function () {
                return Engine._DECR;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "INVERT", {
            get: function () {
                return Engine._INVERT;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "INCR_WRAP", {
            get: function () {
                return Engine._INCR_WRAP;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "DECR_WRAP", {
            get: function () {
                return Engine._DECR_WRAP;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "ALPHA_DISABLE", {
            get: function () {
                return Engine._ALPHA_DISABLE;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "ALPHA_ONEONE", {
            get: function () {
                return Engine._ALPHA_ONEONE;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "ALPHA_ADD", {
            get: function () {
                return Engine._ALPHA_ADD;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "ALPHA_COMBINE", {
            get: function () {
                return Engine._ALPHA_COMBINE;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "ALPHA_SUBTRACT", {
            get: function () {
                return Engine._ALPHA_SUBTRACT;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "ALPHA_MULTIPLY", {
            get: function () {
                return Engine._ALPHA_MULTIPLY;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "ALPHA_MAXIMIZED", {
            get: function () {
                return Engine._ALPHA_MAXIMIZED;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "ALPHA_PREMULTIPLIED", {
            get: function () {
                return Engine._ALPHA_PREMULTIPLIED;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "ALPHA_PREMULTIPLIED_PORTERDUFF", {
            get: function () {
                return Engine._ALPHA_PREMULTIPLIED_PORTERDUFF;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "ALPHA_INTERPOLATE", {
            get: function () {
                return Engine._ALPHA_INTERPOLATE;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "ALPHA_SCREENMODE", {
            get: function () {
                return Engine._ALPHA_SCREENMODE;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "DELAYLOADSTATE_NONE", {
            get: function () {
                return Engine._DELAYLOADSTATE_NONE;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "DELAYLOADSTATE_LOADED", {
            get: function () {
                return Engine._DELAYLOADSTATE_LOADED;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "DELAYLOADSTATE_LOADING", {
            get: function () {
                return Engine._DELAYLOADSTATE_LOADING;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "DELAYLOADSTATE_NOTLOADED", {
            get: function () {
                return Engine._DELAYLOADSTATE_NOTLOADED;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "TEXTUREFORMAT_ALPHA", {
            get: function () {
                return Engine._TEXTUREFORMAT_ALPHA;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "TEXTUREFORMAT_LUMINANCE", {
            get: function () {
                return Engine._TEXTUREFORMAT_LUMINANCE;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "TEXTUREFORMAT_LUMINANCE_ALPHA", {
            get: function () {
                return Engine._TEXTUREFORMAT_LUMINANCE_ALPHA;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "TEXTUREFORMAT_RGB", {
            get: function () {
                return Engine._TEXTUREFORMAT_RGB;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "TEXTUREFORMAT_RGBA", {
            get: function () {
                return Engine._TEXTUREFORMAT_RGBA;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "TEXTURETYPE_UNSIGNED_INT", {
            get: function () {
                return Engine._TEXTURETYPE_UNSIGNED_INT;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "TEXTURETYPE_FLOAT", {
            get: function () {
                return Engine._TEXTURETYPE_FLOAT;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "TEXTURETYPE_HALF_FLOAT", {
            get: function () {
                return Engine._TEXTURETYPE_HALF_FLOAT;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "SCALEMODE_FLOOR", {
            get: function () {
                return Engine._SCALEMODE_FLOOR;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "SCALEMODE_NEAREST", {
            get: function () {
                return Engine._SCALEMODE_NEAREST;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "SCALEMODE_CEILING", {
            get: function () {
                return Engine._SCALEMODE_CEILING;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine, "Version", {
            get: function () {
                return "3.1.1";
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine.prototype, "isInVRExclusivePointerMode", {
            get: function () {
                return this._vrExclusivePointerMode;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine.prototype, "supportsUniformBuffers", {
            get: function () {
                return this.webGLVersion > 1 && !this.disableUniformBuffers;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine.prototype, "needPOTTextures", {
            get: function () {
                return this._webGLVersion < 2 || this.forcePOTTextures;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine.prototype, "badOS", {
            get: function () {
                return this._badOS;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine.prototype, "badDesktopOS", {
            get: function () {
                return this._badDesktopOS;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine.prototype, "performanceMonitor", {
            get: function () {
                return this._performanceMonitor;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine.prototype, "texturesSupported", {
            get: function () {
                return this._texturesSupported;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine.prototype, "textureFormatInUse", {
            get: function () {
                return this._textureFormatInUse;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine.prototype, "currentViewport", {
            get: function () {
                return this._cachedViewport;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine.prototype, "emptyTexture", {
            // Empty texture
            get: function () {
                if (!this._emptyTexture) {
                    this._emptyTexture = this.createRawTexture(new Uint8Array(4), 1, 1, BABYLON.Engine.TEXTUREFORMAT_RGBA, false, false, BABYLON.Texture.NEAREST_SAMPLINGMODE);
                }
                return this._emptyTexture;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine.prototype, "emptyTexture3D", {
            get: function () {
                if (!this._emptyTexture3D) {
                    this._emptyTexture3D = this.createRawTexture3D(new Uint8Array(4), 1, 1, 1, BABYLON.Engine.TEXTUREFORMAT_RGBA, false, false, BABYLON.Texture.NEAREST_SAMPLINGMODE);
                }
                return this._emptyTexture3D;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine.prototype, "emptyCubeTexture", {
            get: function () {
                if (!this._emptyCubeTexture) {
                    var faceData = new Uint8Array(4);
                    var cubeData = [faceData, faceData, faceData, faceData, faceData, faceData];
                    this._emptyCubeTexture = this.createRawCubeTexture(cubeData, 1, BABYLON.Engine.TEXTUREFORMAT_RGBA, BABYLON.Engine.TEXTURETYPE_UNSIGNED_INT, false, false, BABYLON.Texture.NEAREST_SAMPLINGMODE);
                }
                return this._emptyCubeTexture;
            },
            enumerable: true,
            configurable: true
        });
        Engine.prototype._rebuildInternalTextures = function () {
            var currentState = this._internalTexturesCache.slice(); // Do a copy because the rebuild will add proxies
            for (var _i = 0, currentState_1 = currentState; _i < currentState_1.length; _i++) {
                var internalTexture = currentState_1[_i];
                internalTexture._rebuild();
            }
        };
        Engine.prototype._rebuildEffects = function () {
            for (var key in this._compiledEffects) {
                var effect = this._compiledEffects[key];
                effect._prepareEffect();
            }
            BABYLON.Effect.ResetCache();
        };
        Engine.prototype._rebuildBuffers = function () {
            // Index / Vertex
            for (var _i = 0, _a = this.scenes; _i < _a.length; _i++) {
                var scene = _a[_i];
                scene.resetCachedMaterial();
                scene._rebuildGeometries();
                scene._rebuildTextures();
            }
            // Uniforms
            for (var _b = 0, _c = this._uniformBuffers; _b < _c.length; _b++) {
                var uniformBuffer = _c[_b];
                uniformBuffer._rebuild();
            }
        };
        Engine.prototype._initGLContext = function () {
            // Caps
            this._caps = new EngineCapabilities();
            this._caps.maxTexturesImageUnits = this._gl.getParameter(this._gl.MAX_TEXTURE_IMAGE_UNITS);
            this._caps.maxVertexTextureImageUnits = this._gl.getParameter(this._gl.MAX_VERTEX_TEXTURE_IMAGE_UNITS);
            this._caps.maxTextureSize = this._gl.getParameter(this._gl.MAX_TEXTURE_SIZE);
            this._caps.maxCubemapTextureSize = this._gl.getParameter(this._gl.MAX_CUBE_MAP_TEXTURE_SIZE);
            this._caps.maxRenderTextureSize = this._gl.getParameter(this._gl.MAX_RENDERBUFFER_SIZE);
            this._caps.maxVertexAttribs = this._gl.getParameter(this._gl.MAX_VERTEX_ATTRIBS);
            this._caps.maxVaryingVectors = this._gl.getParameter(this._gl.MAX_VARYING_VECTORS);
            this._caps.maxFragmentUniformVectors = this._gl.getParameter(this._gl.MAX_FRAGMENT_UNIFORM_VECTORS);
            this._caps.maxVertexUniformVectors = this._gl.getParameter(this._gl.MAX_VERTEX_UNIFORM_VECTORS);
            // Infos
            this._glVersion = this._gl.getParameter(this._gl.VERSION);
            var rendererInfo = this._gl.getExtension("WEBGL_debug_renderer_info");
            if (rendererInfo != null) {
                this._glRenderer = this._gl.getParameter(rendererInfo.UNMASKED_RENDERER_WEBGL);
                this._glVendor = this._gl.getParameter(rendererInfo.UNMASKED_VENDOR_WEBGL);
            }
            if (!this._glVendor) {
                this._glVendor = "Unknown vendor";
            }
            if (!this._glRenderer) {
                this._glRenderer = "Unknown renderer";
            }
            // Constants
            this._gl.HALF_FLOAT_OES = 0x8D61; // Half floating-point type (16-bit).
            if (this._gl.RGBA16F !== 0x881A) {
                this._gl.RGBA16F = 0x881A; // RGBA 16-bit floating-point color-renderable internal sized format.
            }
            if (this._gl.RGBA32F !== 0x8814) {
                this._gl.RGBA32F = 0x8814; // RGBA 32-bit floating-point color-renderable internal sized format.
            }
            if (this._gl.DEPTH24_STENCIL8 !== 35056) {
                this._gl.DEPTH24_STENCIL8 = 35056;
            }
            // Extensions
            this._caps.standardDerivatives = this._webGLVersion > 1 || (this._gl.getExtension('OES_standard_derivatives') !== null);
            this._caps.astc = this._gl.getExtension('WEBGL_compressed_texture_astc') || this._gl.getExtension('WEBKIT_WEBGL_compressed_texture_astc');
            this._caps.s3tc = this._gl.getExtension('WEBGL_compressed_texture_s3tc') || this._gl.getExtension('WEBKIT_WEBGL_compressed_texture_s3tc');
            this._caps.pvrtc = this._gl.getExtension('WEBGL_compressed_texture_pvrtc') || this._gl.getExtension('WEBKIT_WEBGL_compressed_texture_pvrtc');
            this._caps.etc1 = this._gl.getExtension('WEBGL_compressed_texture_etc1') || this._gl.getExtension('WEBKIT_WEBGL_compressed_texture_etc1');
            this._caps.etc2 = this._gl.getExtension('WEBGL_compressed_texture_etc') || this._gl.getExtension('WEBKIT_WEBGL_compressed_texture_etc') ||
                this._gl.getExtension('WEBGL_compressed_texture_es3_0'); // also a requirement of OpenGL ES 3
            this._caps.textureAnisotropicFilterExtension = this._gl.getExtension('EXT_texture_filter_anisotropic') || this._gl.getExtension('WEBKIT_EXT_texture_filter_anisotropic') || this._gl.getExtension('MOZ_EXT_texture_filter_anisotropic');
            this._caps.maxAnisotropy = this._caps.textureAnisotropicFilterExtension ? this._gl.getParameter(this._caps.textureAnisotropicFilterExtension.MAX_TEXTURE_MAX_ANISOTROPY_EXT) : 0;
            this._caps.uintIndices = this._webGLVersion > 1 || this._gl.getExtension('OES_element_index_uint') !== null;
            this._caps.fragmentDepthSupported = this._webGLVersion > 1 || this._gl.getExtension('EXT_frag_depth') !== null;
            this._caps.highPrecisionShaderSupported = true;
            this._caps.timerQuery = this._gl.getExtension('EXT_disjoint_timer_query_webgl2') || this._gl.getExtension("EXT_disjoint_timer_query");
            if (this._caps.timerQuery) {
                if (this._webGLVersion === 1) {
                    this._gl.getQuery = this._caps.timerQuery.getQueryEXT.bind(this._caps.timerQuery);
                }
                this._caps.canUseTimestampForTimerQuery = this._gl.getQuery(this._caps.timerQuery.TIMESTAMP_EXT, this._caps.timerQuery.QUERY_COUNTER_BITS_EXT) > 0;
            }
            // Checks if some of the format renders first to allow the use of webgl inspector.
            this._caps.colorBufferFloat = this._webGLVersion > 1 && this._gl.getExtension('EXT_color_buffer_float');
            this._caps.textureFloat = this._webGLVersion > 1 || this._gl.getExtension('OES_texture_float');
            this._caps.textureFloatLinearFiltering = this._caps.textureFloat && this._gl.getExtension('OES_texture_float_linear');
            this._caps.textureFloatRender = this._caps.textureFloat && this._canRenderToFloatFramebuffer();
            this._caps.textureHalfFloat = this._webGLVersion > 1 || this._gl.getExtension('OES_texture_half_float');
            this._caps.textureHalfFloatLinearFiltering = this._webGLVersion > 1 || (this._caps.textureHalfFloat && this._gl.getExtension('OES_texture_half_float_linear'));
            if (this._webGLVersion > 1) {
                this._gl.HALF_FLOAT_OES = 0x140B;
            }
            this._caps.textureHalfFloatRender = this._caps.textureHalfFloat && this._canRenderToHalfFloatFramebuffer();
            this._caps.textureLOD = this._webGLVersion > 1 || this._gl.getExtension('EXT_shader_texture_lod');
            // Draw buffers
            if (this._webGLVersion > 1) {
                this._caps.drawBuffersExtension = true;
            }
            else {
                var drawBuffersExtension = this._gl.getExtension('WEBGL_draw_buffers');
                if (drawBuffersExtension !== null) {
                    this._caps.drawBuffersExtension = true;
                    this._gl.drawBuffers = drawBuffersExtension.drawBuffersWEBGL.bind(drawBuffersExtension);
                    this._gl.DRAW_FRAMEBUFFER = this._gl.FRAMEBUFFER;
                    for (var i = 0; i < 16; i++) {
                        this._gl["COLOR_ATTACHMENT" + i + "_WEBGL"] = drawBuffersExtension["COLOR_ATTACHMENT" + i + "_WEBGL"];
                    }
                }
                else {
                    this._caps.drawBuffersExtension = false;
                }
            }
            // Depth Texture
            if (this._webGLVersion > 1) {
                this._caps.depthTextureExtension = true;
            }
            else {
                var depthTextureExtension = this._gl.getExtension('WEBGL_depth_texture');
                if (depthTextureExtension != null) {
                    this._caps.depthTextureExtension = true;
                }
            }
            // Vertex array object
            if (this._webGLVersion > 1) {
                this._caps.vertexArrayObject = true;
            }
            else {
                var vertexArrayObjectExtension = this._gl.getExtension('OES_vertex_array_object');
                if (vertexArrayObjectExtension != null) {
                    this._caps.vertexArrayObject = true;
                    this._gl.createVertexArray = vertexArrayObjectExtension.createVertexArrayOES.bind(vertexArrayObjectExtension);
                    this._gl.bindVertexArray = vertexArrayObjectExtension.bindVertexArrayOES.bind(vertexArrayObjectExtension);
                    this._gl.deleteVertexArray = vertexArrayObjectExtension.deleteVertexArrayOES.bind(vertexArrayObjectExtension);
                }
                else {
                    this._caps.vertexArrayObject = false;
                }
            }
            // Instances count
            if (this._webGLVersion > 1) {
                this._caps.instancedArrays = true;
            }
            else {
                var instanceExtension = this._gl.getExtension('ANGLE_instanced_arrays');
                if (instanceExtension != null) {
                    this._caps.instancedArrays = true;
                    this._gl.drawArraysInstanced = instanceExtension.drawArraysInstancedANGLE.bind(instanceExtension);
                    this._gl.drawElementsInstanced = instanceExtension.drawElementsInstancedANGLE.bind(instanceExtension);
                    this._gl.vertexAttribDivisor = instanceExtension.vertexAttribDivisorANGLE.bind(instanceExtension);
                }
                else {
                    this._caps.instancedArrays = false;
                }
            }
            // Intelligently add supported compressed formats in order to check for.
            // Check for ASTC support first as it is most powerful and to be very cross platform.
            // Next PVRTC & DXT, which are probably superior to ETC1/2.
            // Likely no hardware which supports both PVR & DXT, so order matters little.
            // ETC2 is newer and handles ETC1 (no alpha capability), so check for first.
            if (this._caps.astc)
                this.texturesSupported.push('-astc.ktx');
            if (this._caps.s3tc)
                this.texturesSupported.push('-dxt.ktx');
            if (this._caps.pvrtc)
                this.texturesSupported.push('-pvrtc.ktx');
            if (this._caps.etc2)
                this.texturesSupported.push('-etc2.ktx');
            if (this._caps.etc1)
                this.texturesSupported.push('-etc1.ktx');
            if (this._gl.getShaderPrecisionFormat) {
                var highp = this._gl.getShaderPrecisionFormat(this._gl.FRAGMENT_SHADER, this._gl.HIGH_FLOAT);
                if (highp) {
                    this._caps.highPrecisionShaderSupported = highp.precision !== 0;
                }
            }
            // Depth buffer
            this.setDepthBuffer(true);
            this.setDepthFunctionToLessOrEqual();
            this.setDepthWrite(true);
        };
        Object.defineProperty(Engine.prototype, "webGLVersion", {
            get: function () {
                return this._webGLVersion;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine.prototype, "isStencilEnable", {
            /**
             * Returns true if the stencil buffer has been enabled through the creation option of the context.
             */
            get: function () {
                return this._isStencilEnable;
            },
            enumerable: true,
            configurable: true
        });
        Engine.prototype._prepareWorkingCanvas = function () {
            if (this._workingCanvas) {
                return;
            }
            this._workingCanvas = document.createElement("canvas");
            var context = this._workingCanvas.getContext("2d");
            if (context) {
                this._workingContext = context;
            }
        };
        Engine.prototype.resetTextureCache = function () {
            for (var key in this._boundTexturesCache) {
                this._boundTexturesCache[key] = null;
            }
        };
        Engine.prototype.isDeterministicLockStep = function () {
            return this._deterministicLockstep;
        };
        Engine.prototype.getLockstepMaxSteps = function () {
            return this._lockstepMaxSteps;
        };
        Engine.prototype.getGlInfo = function () {
            return {
                vendor: this._glVendor,
                renderer: this._glRenderer,
                version: this._glVersion
            };
        };
        Engine.prototype.getAspectRatio = function (camera, useScreen) {
            if (useScreen === void 0) { useScreen = false; }
            var viewport = camera.viewport;
            return (this.getRenderWidth(useScreen) * viewport.width) / (this.getRenderHeight(useScreen) * viewport.height);
        };
        Engine.prototype.getRenderWidth = function (useScreen) {
            if (useScreen === void 0) { useScreen = false; }
            if (!useScreen && this._currentRenderTarget) {
                return this._currentRenderTarget.width;
            }
            return this._gl.drawingBufferWidth;
        };
        Engine.prototype.getRenderHeight = function (useScreen) {
            if (useScreen === void 0) { useScreen = false; }
            if (!useScreen && this._currentRenderTarget) {
                return this._currentRenderTarget.height;
            }
            return this._gl.drawingBufferHeight;
        };
        Engine.prototype.getRenderingCanvas = function () {
            return this._renderingCanvas;
        };
        Engine.prototype.getRenderingCanvasClientRect = function () {
            if (!this._renderingCanvas) {
                return null;
            }
            return this._renderingCanvas.getBoundingClientRect();
        };
        Engine.prototype.setHardwareScalingLevel = function (level) {
            this._hardwareScalingLevel = level;
            this.resize();
        };
        Engine.prototype.getHardwareScalingLevel = function () {
            return this._hardwareScalingLevel;
        };
        Engine.prototype.getLoadedTexturesCache = function () {
            return this._internalTexturesCache;
        };
        Engine.prototype.getCaps = function () {
            return this._caps;
        };
        Object.defineProperty(Engine.prototype, "drawCalls", {
            /** The number of draw calls submitted last frame */
            get: function () {
                BABYLON.Tools.Warn("drawCalls is deprecated. Please use SceneInstrumentation class");
                return 0;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine.prototype, "drawCallsPerfCounter", {
            get: function () {
                BABYLON.Tools.Warn("drawCallsPerfCounter is deprecated. Please use SceneInstrumentation class");
                return null;
            },
            enumerable: true,
            configurable: true
        });
        Engine.prototype.getDepthFunction = function () {
            return this._depthCullingState.depthFunc;
        };
        Engine.prototype.setDepthFunction = function (depthFunc) {
            this._depthCullingState.depthFunc = depthFunc;
        };
        Engine.prototype.setDepthFunctionToGreater = function () {
            this._depthCullingState.depthFunc = this._gl.GREATER;
        };
        Engine.prototype.setDepthFunctionToGreaterOrEqual = function () {
            this._depthCullingState.depthFunc = this._gl.GEQUAL;
        };
        Engine.prototype.setDepthFunctionToLess = function () {
            this._depthCullingState.depthFunc = this._gl.LESS;
        };
        Engine.prototype.setDepthFunctionToLessOrEqual = function () {
            this._depthCullingState.depthFunc = this._gl.LEQUAL;
        };
        Engine.prototype.getStencilBuffer = function () {
            return this._stencilState.stencilTest;
        };
        Engine.prototype.setStencilBuffer = function (enable) {
            this._stencilState.stencilTest = enable;
        };
        Engine.prototype.getStencilMask = function () {
            return this._stencilState.stencilMask;
        };
        Engine.prototype.setStencilMask = function (mask) {
            this._stencilState.stencilMask = mask;
        };
        Engine.prototype.getStencilFunction = function () {
            return this._stencilState.stencilFunc;
        };
        Engine.prototype.getStencilFunctionReference = function () {
            return this._stencilState.stencilFuncRef;
        };
        Engine.prototype.getStencilFunctionMask = function () {
            return this._stencilState.stencilFuncMask;
        };
        Engine.prototype.setStencilFunction = function (stencilFunc) {
            this._stencilState.stencilFunc = stencilFunc;
        };
        Engine.prototype.setStencilFunctionReference = function (reference) {
            this._stencilState.stencilFuncRef = reference;
        };
        Engine.prototype.setStencilFunctionMask = function (mask) {
            this._stencilState.stencilFuncMask = mask;
        };
        Engine.prototype.getStencilOperationFail = function () {
            return this._stencilState.stencilOpStencilFail;
        };
        Engine.prototype.getStencilOperationDepthFail = function () {
            return this._stencilState.stencilOpDepthFail;
        };
        Engine.prototype.getStencilOperationPass = function () {
            return this._stencilState.stencilOpStencilDepthPass;
        };
        Engine.prototype.setStencilOperationFail = function (operation) {
            this._stencilState.stencilOpStencilFail = operation;
        };
        Engine.prototype.setStencilOperationDepthFail = function (operation) {
            this._stencilState.stencilOpDepthFail = operation;
        };
        Engine.prototype.setStencilOperationPass = function (operation) {
            this._stencilState.stencilOpStencilDepthPass = operation;
        };
        Engine.prototype.setDitheringState = function (value) {
            if (value) {
                this._gl.enable(this._gl.DITHER);
            }
            else {
                this._gl.disable(this._gl.DITHER);
            }
        };
        Engine.prototype.setRasterizerState = function (value) {
            if (value) {
                this._gl.disable(this._gl.RASTERIZER_DISCARD);
            }
            else {
                this._gl.enable(this._gl.RASTERIZER_DISCARD);
            }
        };
        /**
         * stop executing a render loop function and remove it from the execution array
         * @param {Function} [renderFunction] the function to be removed. If not provided all functions will be removed.
         */
        Engine.prototype.stopRenderLoop = function (renderFunction) {
            if (!renderFunction) {
                this._activeRenderLoops = [];
                return;
            }
            var index = this._activeRenderLoops.indexOf(renderFunction);
            if (index >= 0) {
                this._activeRenderLoops.splice(index, 1);
            }
        };
        Engine.prototype._renderLoop = function () {
            if (!this._contextWasLost) {
                var shouldRender = true;
                if (!this.renderEvenInBackground && this._windowIsBackground) {
                    shouldRender = false;
                }
                if (shouldRender) {
                    // Start new frame
                    this.beginFrame();
                    for (var index = 0; index < this._activeRenderLoops.length; index++) {
                        var renderFunction = this._activeRenderLoops[index];
                        renderFunction();
                    }
                    // Present
                    this.endFrame();
                }
            }
            if (this._activeRenderLoops.length > 0) {
                // Register new frame
                var requester = null;
                if (this._vrDisplay && this._vrDisplay.isPresenting)
                    requester = this._vrDisplay;
                this._frameHandler = BABYLON.Tools.QueueNewFrame(this._bindedRenderFunction, requester);
            }
            else {
                this._renderingQueueLaunched = false;
            }
        };
        /**
         * Register and execute a render loop. The engine can have more than one render function.
         * @param {Function} renderFunction - the function to continuously execute starting the next render loop.
         * @example
         * engine.runRenderLoop(function () {
         *      scene.render()
         * })
         */
        Engine.prototype.runRenderLoop = function (renderFunction) {
            if (this._activeRenderLoops.indexOf(renderFunction) !== -1) {
                return;
            }
            this._activeRenderLoops.push(renderFunction);
            if (!this._renderingQueueLaunched) {
                this._renderingQueueLaunched = true;
                this._bindedRenderFunction = this._renderLoop.bind(this);
                this._frameHandler = BABYLON.Tools.QueueNewFrame(this._bindedRenderFunction);
            }
        };
        /**
         * Toggle full screen mode.
         * @param {boolean} requestPointerLock - should a pointer lock be requested from the user
         * @param {any} options - an options object to be sent to the requestFullscreen function
         */
        Engine.prototype.switchFullscreen = function (requestPointerLock) {
            if (this.isFullscreen) {
                BABYLON.Tools.ExitFullscreen();
            }
            else {
                this._pointerLockRequested = requestPointerLock;
                if (this._renderingCanvas) {
                    BABYLON.Tools.RequestFullscreen(this._renderingCanvas);
                }
            }
        };
        Engine.prototype.clear = function (color, backBuffer, depth, stencil) {
            if (stencil === void 0) { stencil = false; }
            this.applyStates();
            var mode = 0;
            if (backBuffer && color) {
                this._gl.clearColor(color.r, color.g, color.b, color.a !== undefined ? color.a : 1.0);
                mode |= this._gl.COLOR_BUFFER_BIT;
            }
            if (depth) {
                this._gl.clearDepth(1.0);
                mode |= this._gl.DEPTH_BUFFER_BIT;
            }
            if (stencil) {
                this._gl.clearStencil(0);
                mode |= this._gl.STENCIL_BUFFER_BIT;
            }
            this._gl.clear(mode);
        };
        Engine.prototype.scissorClear = function (x, y, width, height, clearColor) {
            var gl = this._gl;
            // Save state
            var curScissor = gl.getParameter(gl.SCISSOR_TEST);
            var curScissorBox = gl.getParameter(gl.SCISSOR_BOX);
            // Change state
            gl.enable(gl.SCISSOR_TEST);
            gl.scissor(x, y, width, height);
            // Clear
            this.clear(clearColor, true, true, true);
            // Restore state
            gl.scissor(curScissorBox[0], curScissorBox[1], curScissorBox[2], curScissorBox[3]);
            if (curScissor === true) {
                gl.enable(gl.SCISSOR_TEST);
            }
            else {
                gl.disable(gl.SCISSOR_TEST);
            }
        };
        /**
         * Set the WebGL's viewport
         * @param {BABYLON.Viewport} viewport - the viewport element to be used.
         * @param {number} [requiredWidth] - the width required for rendering. If not provided the rendering canvas' width is used.
         * @param {number} [requiredHeight] - the height required for rendering. If not provided the rendering canvas' height is used.
         */
        Engine.prototype.setViewport = function (viewport, requiredWidth, requiredHeight) {
            var width = requiredWidth || this.getRenderWidth();
            var height = requiredHeight || this.getRenderHeight();
            var x = viewport.x || 0;
            var y = viewport.y || 0;
            this._cachedViewport = viewport;
            this._gl.viewport(x * width, y * height, width * viewport.width, height * viewport.height);
        };
        /**
         * Directly set the WebGL Viewport
         * The x, y, width & height are directly passed to the WebGL call
         * @return the current viewport Object (if any) that is being replaced by this call. You can restore this viewport later on to go back to the original state.
         */
        Engine.prototype.setDirectViewport = function (x, y, width, height) {
            var currentViewport = this._cachedViewport;
            this._cachedViewport = null;
            this._gl.viewport(x, y, width, height);
            return currentViewport;
        };
        Engine.prototype.beginFrame = function () {
            this.onBeginFrameObservable.notifyObservers(this);
            this._measureFps();
        };
        Engine.prototype.endFrame = function () {
            //force a flush in case we are using a bad OS.
            if (this._badOS) {
                this.flushFramebuffer();
            }
            //submit frame to the vr device, if enabled
            if (this._vrDisplay && this._vrDisplay.isPresenting) {
                // TODO: We should only submit the frame if we read frameData successfully.
                this._vrDisplay.submitFrame();
            }
            this.onEndFrameObservable.notifyObservers(this);
        };
        /**
         * resize the view according to the canvas' size.
         * @example
         *   window.addEventListener("resize", function () {
         *      engine.resize();
         *   });
         */
        Engine.prototype.resize = function () {
            // We're not resizing the size of the canvas while in VR mode & presenting
            if (!(this._vrDisplay && this._vrDisplay.isPresenting)) {
                var width = this._renderingCanvas ? this._renderingCanvas.clientWidth : window.innerWidth;
                var height = this._renderingCanvas ? this._renderingCanvas.clientHeight : window.innerHeight;
                this.setSize(width / this._hardwareScalingLevel, height / this._hardwareScalingLevel);
            }
        };
        /**
         * force a specific size of the canvas
         * @param {number} width - the new canvas' width
         * @param {number} height - the new canvas' height
         */
        Engine.prototype.setSize = function (width, height) {
            if (!this._renderingCanvas) {
                return;
            }
            if (this._renderingCanvas.width === width && this._renderingCanvas.height === height) {
                return;
            }
            this._renderingCanvas.width = width;
            this._renderingCanvas.height = height;
            for (var index = 0; index < this.scenes.length; index++) {
                var scene = this.scenes[index];
                for (var camIndex = 0; camIndex < scene.cameras.length; camIndex++) {
                    var cam = scene.cameras[camIndex];
                    cam._currentRenderId = 0;
                }
            }
            if (this.onResizeObservable.hasObservers) {
                this.onResizeObservable.notifyObservers(this);
            }
        };
        // WebVR functions
        Engine.prototype.isVRDevicePresent = function () {
            return !!this._vrDisplay;
        };
        Engine.prototype.getVRDevice = function () {
            return this._vrDisplay;
        };
        Engine.prototype.initWebVR = function () {
            var _this = this;
            var notifyObservers = function () {
                var eventArgs = {
                    vrDisplay: _this._vrDisplay,
                    vrSupported: _this._vrSupported
                };
                _this.onVRDisplayChangedObservable.notifyObservers(eventArgs);
            };
            if (!this._onVrDisplayConnect) {
                this._onVrDisplayConnect = function (event) {
                    _this._vrDisplay = event.display;
                    notifyObservers();
                };
                this._onVrDisplayDisconnect = function () {
                    _this._vrDisplay.cancelAnimationFrame(_this._frameHandler);
                    _this._vrDisplay = undefined;
                    _this._frameHandler = BABYLON.Tools.QueueNewFrame(_this._bindedRenderFunction);
                    notifyObservers();
                };
                this._onVrDisplayPresentChange = function () {
                    _this._vrExclusivePointerMode = _this._vrDisplay && _this._vrDisplay.isPresenting;
                };
                window.addEventListener('vrdisplayconnect', this._onVrDisplayConnect);
                window.addEventListener('vrdisplaydisconnect', this._onVrDisplayDisconnect);
                window.addEventListener('vrdisplaypresentchange', this._onVrDisplayPresentChange);
            }
            this._getVRDisplays(notifyObservers);
            return this.onVRDisplayChangedObservable;
        };
        Engine.prototype.enableVR = function () {
            var _this = this;
            if (this._vrDisplay && !this._vrDisplay.isPresenting) {
                var onResolved = function () {
                    _this.onVRRequestPresentComplete.notifyObservers(true);
                    _this._onVRFullScreenTriggered();
                };
                var onRejected = function () {
                    _this.onVRRequestPresentComplete.notifyObservers(false);
                };
                this.onVRRequestPresentStart.notifyObservers(this);
                this._vrDisplay.requestPresent([{ source: this.getRenderingCanvas() }]).then(onResolved).catch(onRejected);
            }
        };
        Engine.prototype.disableVR = function () {
            if (this._vrDisplay && this._vrDisplay.isPresenting) {
                this._vrDisplay.exitPresent().then(this._onVRFullScreenTriggered).catch(this._onVRFullScreenTriggered);
            }
        };
        Engine.prototype._getVRDisplays = function (callback) {
            var _this = this;
            var getWebVRDevices = function (devices) {
                _this._vrSupported = true;
                // note that devices may actually be an empty array. This is fine;
                // we expect this._vrDisplay to be undefined in this case.
                return _this._vrDisplay = devices[0];
            };
            if (navigator.getVRDisplays) {
                navigator.getVRDisplays().then(getWebVRDevices).then(callback).catch(function (error) {
                    // TODO: System CANNOT support WebVR, despite API presence.
                    _this._vrSupported = false;
                    callback();
                });
            }
            else {
                // TODO: Browser does not support WebVR
                this._vrDisplay = undefined;
                this._vrSupported = false;
                callback();
            }
        };
        Engine.prototype.bindFramebuffer = function (texture, faceIndex, requiredWidth, requiredHeight, forceFullscreenViewport) {
            if (this._currentRenderTarget) {
                this.unBindFramebuffer(this._currentRenderTarget);
            }
            this._currentRenderTarget = texture;
            this.bindUnboundFramebuffer(texture._MSAAFramebuffer ? texture._MSAAFramebuffer : texture._framebuffer);
            var gl = this._gl;
            if (texture.isCube) {
                if (faceIndex === undefined) {
                    faceIndex = 0;
                }
                gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.COLOR_ATTACHMENT0, gl.TEXTURE_CUBE_MAP_POSITIVE_X + faceIndex, texture._webGLTexture, 0);
            }
            if (this._cachedViewport && !forceFullscreenViewport) {
                this.setViewport(this._cachedViewport, requiredWidth, requiredHeight);
            }
            else {
                gl.viewport(0, 0, requiredWidth || texture.width, requiredHeight || texture.height);
            }
            this.wipeCaches();
        };
        Engine.prototype.bindUnboundFramebuffer = function (framebuffer) {
            if (this._currentFramebuffer !== framebuffer) {
                this._gl.bindFramebuffer(this._gl.FRAMEBUFFER, framebuffer);
                this._currentFramebuffer = framebuffer;
            }
        };
        Engine.prototype.unBindFramebuffer = function (texture, disableGenerateMipMaps, onBeforeUnbind) {
            if (disableGenerateMipMaps === void 0) { disableGenerateMipMaps = false; }
            this._currentRenderTarget = null;
            // If MSAA, we need to bitblt back to main texture
            var gl = this._gl;
            if (texture._MSAAFramebuffer) {
                gl.bindFramebuffer(gl.READ_FRAMEBUFFER, texture._MSAAFramebuffer);
                gl.bindFramebuffer(gl.DRAW_FRAMEBUFFER, texture._framebuffer);
                gl.blitFramebuffer(0, 0, texture.width, texture.height, 0, 0, texture.width, texture.height, gl.COLOR_BUFFER_BIT, gl.NEAREST);
            }
            if (texture.generateMipMaps && !disableGenerateMipMaps && !texture.isCube) {
                this._bindTextureDirectly(gl.TEXTURE_2D, texture);
                gl.generateMipmap(gl.TEXTURE_2D);
                this._bindTextureDirectly(gl.TEXTURE_2D, null);
            }
            if (onBeforeUnbind) {
                if (texture._MSAAFramebuffer) {
                    // Bind the correct framebuffer
                    this.bindUnboundFramebuffer(texture._framebuffer);
                }
                onBeforeUnbind();
            }
            this.bindUnboundFramebuffer(null);
        };
        Engine.prototype.generateMipMapsForCubemap = function (texture) {
            if (texture.generateMipMaps) {
                var gl = this._gl;
                this._bindTextureDirectly(gl.TEXTURE_CUBE_MAP, texture);
                gl.generateMipmap(gl.TEXTURE_CUBE_MAP);
                this._bindTextureDirectly(gl.TEXTURE_CUBE_MAP, null);
            }
        };
        Engine.prototype.flushFramebuffer = function () {
            this._gl.flush();
        };
        Engine.prototype.restoreDefaultFramebuffer = function () {
            if (this._currentRenderTarget) {
                this.unBindFramebuffer(this._currentRenderTarget);
            }
            else {
                this.bindUnboundFramebuffer(null);
            }
            if (this._cachedViewport) {
                this.setViewport(this._cachedViewport);
            }
            this.wipeCaches();
        };
        // UBOs
        Engine.prototype.createUniformBuffer = function (elements) {
            var ubo = this._gl.createBuffer();
            if (!ubo) {
                throw new Error("Unable to create uniform buffer");
            }
            this.bindUniformBuffer(ubo);
            if (elements instanceof Float32Array) {
                this._gl.bufferData(this._gl.UNIFORM_BUFFER, elements, this._gl.STATIC_DRAW);
            }
            else {
                this._gl.bufferData(this._gl.UNIFORM_BUFFER, new Float32Array(elements), this._gl.STATIC_DRAW);
            }
            this.bindUniformBuffer(null);
            ubo.references = 1;
            return ubo;
        };
        Engine.prototype.createDynamicUniformBuffer = function (elements) {
            var ubo = this._gl.createBuffer();
            if (!ubo) {
                throw new Error("Unable to create dynamic uniform buffer");
            }
            this.bindUniformBuffer(ubo);
            if (elements instanceof Float32Array) {
                this._gl.bufferData(this._gl.UNIFORM_BUFFER, elements, this._gl.DYNAMIC_DRAW);
            }
            else {
                this._gl.bufferData(this._gl.UNIFORM_BUFFER, new Float32Array(elements), this._gl.DYNAMIC_DRAW);
            }
            this.bindUniformBuffer(null);
            ubo.references = 1;
            return ubo;
        };
        Engine.prototype.updateUniformBuffer = function (uniformBuffer, elements, offset, count) {
            this.bindUniformBuffer(uniformBuffer);
            if (offset === undefined) {
                offset = 0;
            }
            if (count === undefined) {
                if (elements instanceof Float32Array) {
                    this._gl.bufferSubData(this._gl.UNIFORM_BUFFER, offset, elements);
                }
                else {
                    this._gl.bufferSubData(this._gl.UNIFORM_BUFFER, offset, new Float32Array(elements));
                }
            }
            else {
                if (elements instanceof Float32Array) {
                    this._gl.bufferSubData(this._gl.UNIFORM_BUFFER, 0, elements.subarray(offset, offset + count));
                }
                else {
                    this._gl.bufferSubData(this._gl.UNIFORM_BUFFER, 0, new Float32Array(elements).subarray(offset, offset + count));
                }
            }
            this.bindUniformBuffer(null);
        };
        // VBOs
        Engine.prototype._resetVertexBufferBinding = function () {
            this.bindArrayBuffer(null);
            this._cachedVertexBuffers = null;
        };
        Engine.prototype.createVertexBuffer = function (vertices) {
            var vbo = this._gl.createBuffer();
            if (!vbo) {
                throw new Error("Unable to create vertex buffer");
            }
            this.bindArrayBuffer(vbo);
            if (vertices instanceof Float32Array) {
                this._gl.bufferData(this._gl.ARRAY_BUFFER, vertices, this._gl.STATIC_DRAW);
            }
            else {
                this._gl.bufferData(this._gl.ARRAY_BUFFER, new Float32Array(vertices), this._gl.STATIC_DRAW);
            }
            this._resetVertexBufferBinding();
            vbo.references = 1;
            return vbo;
        };
        Engine.prototype.createDynamicVertexBuffer = function (vertices) {
            var vbo = this._gl.createBuffer();
            if (!vbo) {
                throw new Error("Unable to create dynamic vertex buffer");
            }
            this.bindArrayBuffer(vbo);
            if (vertices instanceof Float32Array) {
                this._gl.bufferData(this._gl.ARRAY_BUFFER, vertices, this._gl.DYNAMIC_DRAW);
            }
            else {
                this._gl.bufferData(this._gl.ARRAY_BUFFER, new Float32Array(vertices), this._gl.DYNAMIC_DRAW);
            }
            this._resetVertexBufferBinding();
            vbo.references = 1;
            return vbo;
        };
        Engine.prototype.updateDynamicIndexBuffer = function (indexBuffer, indices, offset) {
            if (offset === void 0) { offset = 0; }
            // Force cache update
            this._currentBoundBuffer[this._gl.ELEMENT_ARRAY_BUFFER] = null;
            this.bindIndexBuffer(indexBuffer);
            var arrayBuffer;
            if (indices instanceof Uint16Array || indices instanceof Uint32Array) {
                arrayBuffer = indices;
            }
            else {
                arrayBuffer = indexBuffer.is32Bits ? new Uint32Array(indices) : new Uint16Array(indices);
            }
            this._gl.bufferData(this._gl.ELEMENT_ARRAY_BUFFER, arrayBuffer, this._gl.DYNAMIC_DRAW);
            this._resetIndexBufferBinding();
        };
        Engine.prototype.updateDynamicVertexBuffer = function (vertexBuffer, vertices, offset, count) {
            this.bindArrayBuffer(vertexBuffer);
            if (offset === undefined) {
                offset = 0;
            }
            if (count === undefined) {
                if (vertices instanceof Float32Array) {
                    this._gl.bufferSubData(this._gl.ARRAY_BUFFER, offset, vertices);
                }
                else {
                    this._gl.bufferSubData(this._gl.ARRAY_BUFFER, offset, new Float32Array(vertices));
                }
            }
            else {
                if (vertices instanceof Float32Array) {
                    this._gl.bufferSubData(this._gl.ARRAY_BUFFER, 0, vertices.subarray(offset, offset + count));
                }
                else {
                    this._gl.bufferSubData(this._gl.ARRAY_BUFFER, 0, new Float32Array(vertices).subarray(offset, offset + count));
                }
            }
            this._resetVertexBufferBinding();
        };
        Engine.prototype._resetIndexBufferBinding = function () {
            this.bindIndexBuffer(null);
            this._cachedIndexBuffer = null;
        };
        Engine.prototype.createIndexBuffer = function (indices, updatable) {
            var vbo = this._gl.createBuffer();
            if (!vbo) {
                throw new Error("Unable to create index buffer");
            }
            this.bindIndexBuffer(vbo);
            // Check for 32 bits indices
            var arrayBuffer;
            var need32Bits = false;
            if (indices instanceof Uint16Array) {
                arrayBuffer = indices;
            }
            else {
                //check 32 bit support
                if (this._caps.uintIndices) {
                    if (indices instanceof Uint32Array) {
                        arrayBuffer = indices;
                        need32Bits = true;
                    }
                    else {
                        //number[] or Int32Array, check if 32 bit is necessary
                        for (var index = 0; index < indices.length; index++) {
                            if (indices[index] > 65535) {
                                need32Bits = true;
                                break;
                            }
                        }
                        arrayBuffer = need32Bits ? new Uint32Array(indices) : new Uint16Array(indices);
                    }
                }
                else {
                    //no 32 bit support, force conversion to 16 bit (values greater 16 bit are lost)
                    arrayBuffer = new Uint16Array(indices);
                }
            }
            this._gl.bufferData(this._gl.ELEMENT_ARRAY_BUFFER, arrayBuffer, updatable ? this._gl.DYNAMIC_DRAW : this._gl.STATIC_DRAW);
            this._resetIndexBufferBinding();
            vbo.references = 1;
            vbo.is32Bits = need32Bits;
            return vbo;
        };
        Engine.prototype.bindArrayBuffer = function (buffer) {
            if (!this._vaoRecordInProgress) {
                this._unbindVertexArrayObject();
            }
            this.bindBuffer(buffer, this._gl.ARRAY_BUFFER);
        };
        Engine.prototype.bindUniformBuffer = function (buffer) {
            this._gl.bindBuffer(this._gl.UNIFORM_BUFFER, buffer);
        };
        Engine.prototype.bindUniformBufferBase = function (buffer, location) {
            this._gl.bindBufferBase(this._gl.UNIFORM_BUFFER, location, buffer);
        };
        Engine.prototype.bindUniformBlock = function (shaderProgram, blockName, index) {
            var uniformLocation = this._gl.getUniformBlockIndex(shaderProgram, blockName);
            this._gl.uniformBlockBinding(shaderProgram, uniformLocation, index);
        };
        ;
        Engine.prototype.bindIndexBuffer = function (buffer) {
            if (!this._vaoRecordInProgress) {
                this._unbindVertexArrayObject();
            }
            this.bindBuffer(buffer, this._gl.ELEMENT_ARRAY_BUFFER);
        };
        Engine.prototype.bindBuffer = function (buffer, target) {
            if (this._vaoRecordInProgress || this._currentBoundBuffer[target] !== buffer) {
                this._gl.bindBuffer(target, buffer);
                this._currentBoundBuffer[target] = buffer;
            }
        };
        Engine.prototype.updateArrayBuffer = function (data) {
            this._gl.bufferSubData(this._gl.ARRAY_BUFFER, 0, data);
        };
        Engine.prototype.vertexAttribPointer = function (buffer, indx, size, type, normalized, stride, offset) {
            var pointer = this._currentBufferPointers[indx];
            var changed = false;
            if (!pointer.active) {
                changed = true;
                pointer.active = true;
                pointer.index = indx;
                pointer.size = size;
                pointer.type = type;
                pointer.normalized = normalized;
                pointer.stride = stride;
                pointer.offset = offset;
                pointer.buffer = buffer;
            }
            else {
                if (pointer.buffer !== buffer) {
                    pointer.buffer = buffer;
                    changed = true;
                }
                if (pointer.size !== size) {
                    pointer.size = size;
                    changed = true;
                }
                if (pointer.type !== type) {
                    pointer.type = type;
                    changed = true;
                }
                if (pointer.normalized !== normalized) {
                    pointer.normalized = normalized;
                    changed = true;
                }
                if (pointer.stride !== stride) {
                    pointer.stride = stride;
                    changed = true;
                }
                if (pointer.offset !== offset) {
                    pointer.offset = offset;
                    changed = true;
                }
            }
            if (changed || this._vaoRecordInProgress) {
                this.bindArrayBuffer(buffer);
                this._gl.vertexAttribPointer(indx, size, type, normalized, stride, offset);
            }
        };
        Engine.prototype._bindIndexBufferWithCache = function (indexBuffer) {
            if (indexBuffer == null) {
                return;
            }
            if (this._cachedIndexBuffer !== indexBuffer) {
                this._cachedIndexBuffer = indexBuffer;
                this.bindIndexBuffer(indexBuffer);
                this._uintIndicesCurrentlySet = indexBuffer.is32Bits;
            }
        };
        Engine.prototype._bindVertexBuffersAttributes = function (vertexBuffers, effect) {
            var attributes = effect.getAttributesNames();
            if (!this._vaoRecordInProgress) {
                this._unbindVertexArrayObject();
            }
            this.unbindAllAttributes();
            for (var index = 0; index < attributes.length; index++) {
                var order = effect.getAttributeLocation(index);
                if (order >= 0) {
                    var vertexBuffer = vertexBuffers[attributes[index]];
                    if (!vertexBuffer) {
                        continue;
                    }
                    this._gl.enableVertexAttribArray(order);
                    if (!this._vaoRecordInProgress) {
                        this._vertexAttribArraysEnabled[order] = true;
                    }
                    var buffer = vertexBuffer.getBuffer();
                    if (buffer) {
                        this.vertexAttribPointer(buffer, order, vertexBuffer.getSize(), this._gl.FLOAT, false, vertexBuffer.getStrideSize() * 4, vertexBuffer.getOffset() * 4);
                        if (vertexBuffer.getIsInstanced()) {
                            this._gl.vertexAttribDivisor(order, vertexBuffer.getInstanceDivisor());
                            if (!this._vaoRecordInProgress) {
                                this._currentInstanceLocations.push(order);
                                this._currentInstanceBuffers.push(buffer);
                            }
                        }
                    }
                }
            }
        };
        Engine.prototype.recordVertexArrayObject = function (vertexBuffers, indexBuffer, effect) {
            var vao = this._gl.createVertexArray();
            this._vaoRecordInProgress = true;
            this._gl.bindVertexArray(vao);
            this._mustWipeVertexAttributes = true;
            this._bindVertexBuffersAttributes(vertexBuffers, effect);
            this.bindIndexBuffer(indexBuffer);
            this._vaoRecordInProgress = false;
            this._gl.bindVertexArray(null);
            return vao;
        };
        Engine.prototype.bindVertexArrayObject = function (vertexArrayObject, indexBuffer) {
            if (this._cachedVertexArrayObject !== vertexArrayObject) {
                this._cachedVertexArrayObject = vertexArrayObject;
                this._gl.bindVertexArray(vertexArrayObject);
                this._cachedVertexBuffers = null;
                this._cachedIndexBuffer = null;
                this._uintIndicesCurrentlySet = indexBuffer != null && indexBuffer.is32Bits;
                this._mustWipeVertexAttributes = true;
            }
        };
        Engine.prototype.bindBuffersDirectly = function (vertexBuffer, indexBuffer, vertexDeclaration, vertexStrideSize, effect) {
            if (this._cachedVertexBuffers !== vertexBuffer || this._cachedEffectForVertexBuffers !== effect) {
                this._cachedVertexBuffers = vertexBuffer;
                this._cachedEffectForVertexBuffers = effect;
                var attributesCount = effect.getAttributesCount();
                this._unbindVertexArrayObject();
                this.unbindAllAttributes();
                var offset = 0;
                for (var index = 0; index < attributesCount; index++) {
                    if (index < vertexDeclaration.length) {
                        var order = effect.getAttributeLocation(index);
                        if (order >= 0) {
                            this._gl.enableVertexAttribArray(order);
                            this._vertexAttribArraysEnabled[order] = true;
                            this.vertexAttribPointer(vertexBuffer, order, vertexDeclaration[index], this._gl.FLOAT, false, vertexStrideSize, offset);
                        }
                        offset += vertexDeclaration[index] * 4;
                    }
                }
            }
            this._bindIndexBufferWithCache(indexBuffer);
        };
        Engine.prototype._unbindVertexArrayObject = function () {
            if (!this._cachedVertexArrayObject) {
                return;
            }
            this._cachedVertexArrayObject = null;
            this._gl.bindVertexArray(null);
        };
        Engine.prototype.bindBuffers = function (vertexBuffers, indexBuffer, effect) {
            if (this._cachedVertexBuffers !== vertexBuffers || this._cachedEffectForVertexBuffers !== effect) {
                this._cachedVertexBuffers = vertexBuffers;
                this._cachedEffectForVertexBuffers = effect;
                this._bindVertexBuffersAttributes(vertexBuffers, effect);
            }
            this._bindIndexBufferWithCache(indexBuffer);
        };
        Engine.prototype.unbindInstanceAttributes = function () {
            var boundBuffer;
            for (var i = 0, ul = this._currentInstanceLocations.length; i < ul; i++) {
                var instancesBuffer = this._currentInstanceBuffers[i];
                if (boundBuffer != instancesBuffer && instancesBuffer.references) {
                    boundBuffer = instancesBuffer;
                    this.bindArrayBuffer(instancesBuffer);
                }
                var offsetLocation = this._currentInstanceLocations[i];
                this._gl.vertexAttribDivisor(offsetLocation, 0);
            }
            this._currentInstanceBuffers.length = 0;
            this._currentInstanceLocations.length = 0;
        };
        Engine.prototype.releaseVertexArrayObject = function (vao) {
            this._gl.deleteVertexArray(vao);
        };
        Engine.prototype._releaseBuffer = function (buffer) {
            buffer.references--;
            if (buffer.references === 0) {
                this._gl.deleteBuffer(buffer);
                return true;
            }
            return false;
        };
        Engine.prototype.createInstancesBuffer = function (capacity) {
            var buffer = this._gl.createBuffer();
            if (!buffer) {
                throw new Error("Unable to create instance buffer");
            }
            buffer.capacity = capacity;
            this.bindArrayBuffer(buffer);
            this._gl.bufferData(this._gl.ARRAY_BUFFER, capacity, this._gl.DYNAMIC_DRAW);
            return buffer;
        };
        Engine.prototype.deleteInstancesBuffer = function (buffer) {
            this._gl.deleteBuffer(buffer);
        };
        Engine.prototype.updateAndBindInstancesBuffer = function (instancesBuffer, data, offsetLocations) {
            this.bindArrayBuffer(instancesBuffer);
            if (data) {
                this._gl.bufferSubData(this._gl.ARRAY_BUFFER, 0, data);
            }
            if (offsetLocations[0].index !== undefined) {
                var stride = 0;
                for (var i = 0; i < offsetLocations.length; i++) {
                    var ai = offsetLocations[i];
                    stride += ai.attributeSize * 4;
                }
                for (var i = 0; i < offsetLocations.length; i++) {
                    var ai = offsetLocations[i];
                    if (!this._vertexAttribArraysEnabled[ai.index]) {
                        this._gl.enableVertexAttribArray(ai.index);
                        this._vertexAttribArraysEnabled[ai.index] = true;
                    }
                    this.vertexAttribPointer(instancesBuffer, ai.index, ai.attributeSize, ai.attribyteType || this._gl.FLOAT, ai.normalized || false, stride, ai.offset);
                    this._gl.vertexAttribDivisor(ai.index, 1);
                    this._currentInstanceLocations.push(ai.index);
                    this._currentInstanceBuffers.push(instancesBuffer);
                }
            }
            else {
                for (var index = 0; index < 4; index++) {
                    var offsetLocation = offsetLocations[index];
                    if (!this._vertexAttribArraysEnabled[offsetLocation]) {
                        this._gl.enableVertexAttribArray(offsetLocation);
                        this._vertexAttribArraysEnabled[offsetLocation] = true;
                    }
                    this.vertexAttribPointer(instancesBuffer, offsetLocation, 4, this._gl.FLOAT, false, 64, index * 16);
                    this._gl.vertexAttribDivisor(offsetLocation, 1);
                    this._currentInstanceLocations.push(offsetLocation);
                    this._currentInstanceBuffers.push(instancesBuffer);
                }
            }
        };
        Engine.prototype.applyStates = function () {
            this._depthCullingState.apply(this._gl);
            this._stencilState.apply(this._gl);
            this._alphaState.apply(this._gl);
        };
        Engine.prototype.draw = function (useTriangles, indexStart, indexCount, instancesCount) {
            // Apply states
            this.applyStates();
            this._drawCalls.addCount(1, false);
            // Render
            var indexFormat = this._uintIndicesCurrentlySet ? this._gl.UNSIGNED_INT : this._gl.UNSIGNED_SHORT;
            var mult = this._uintIndicesCurrentlySet ? 4 : 2;
            if (instancesCount) {
                this._gl.drawElementsInstanced(useTriangles ? this._gl.TRIANGLES : this._gl.LINES, indexCount, indexFormat, indexStart * mult, instancesCount);
                return;
            }
            this._gl.drawElements(useTriangles ? this._gl.TRIANGLES : this._gl.LINES, indexCount, indexFormat, indexStart * mult);
        };
        Engine.prototype.drawPointClouds = function (verticesStart, verticesCount, instancesCount) {
            // Apply states
            this.applyStates();
            this._drawCalls.addCount(1, false);
            if (instancesCount) {
                this._gl.drawArraysInstanced(this._gl.POINTS, verticesStart, verticesCount, instancesCount);
                return;
            }
            this._gl.drawArrays(this._gl.POINTS, verticesStart, verticesCount);
        };
        Engine.prototype.drawUnIndexed = function (useTriangles, verticesStart, verticesCount, instancesCount) {
            // Apply states
            this.applyStates();
            this._drawCalls.addCount(1, false);
            if (instancesCount) {
                this._gl.drawArraysInstanced(useTriangles ? this._gl.TRIANGLES : this._gl.LINES, verticesStart, verticesCount, instancesCount);
                return;
            }
            this._gl.drawArrays(useTriangles ? this._gl.TRIANGLES : this._gl.LINES, verticesStart, verticesCount);
        };
        // Shaders
        Engine.prototype._releaseEffect = function (effect) {
            if (this._compiledEffects[effect._key]) {
                delete this._compiledEffects[effect._key];
                this._deleteProgram(effect.getProgram());
            }
        };
        Engine.prototype._deleteProgram = function (program) {
            if (program) {
                program.__SPECTOR_rebuildProgram = null;
                if (program.transformFeedback) {
                    this.deleteTransformFeedback(program.transformFeedback);
                    program.transformFeedback = null;
                }
                this._gl.deleteProgram(program);
            }
        };
        /**
         * @param baseName The base name of the effect (The name of file without .fragment.fx or .vertex.fx)
         * @param samplers An array of string used to represent textures
         */
        Engine.prototype.createEffect = function (baseName, attributesNamesOrOptions, uniformsNamesOrEngine, samplers, defines, fallbacks, onCompiled, onError, indexParameters) {
            var vertex = baseName.vertexElement || baseName.vertex || baseName;
            var fragment = baseName.fragmentElement || baseName.fragment || baseName;
            var name = vertex + "+" + fragment + "@" + (defines ? defines : attributesNamesOrOptions.defines);
            if (this._compiledEffects[name]) {
                var compiledEffect = this._compiledEffects[name];
                if (onCompiled && compiledEffect.isReady()) {
                    onCompiled(compiledEffect);
                }
                return compiledEffect;
            }
            var effect = new BABYLON.Effect(baseName, attributesNamesOrOptions, uniformsNamesOrEngine, samplers, this, defines, fallbacks, onCompiled, onError, indexParameters);
            effect._key = name;
            this._compiledEffects[name] = effect;
            return effect;
        };
        Engine.prototype.createEffectForParticles = function (fragmentName, uniformsNames, samplers, defines, fallbacks, onCompiled, onError) {
            if (uniformsNames === void 0) { uniformsNames = []; }
            if (samplers === void 0) { samplers = []; }
            if (defines === void 0) { defines = ""; }
            return this.createEffect({
                vertex: "particles",
                fragmentElement: fragmentName
            }, ["position", "color", "options"], ["view", "projection"].concat(uniformsNames), ["diffuseSampler"].concat(samplers), defines, fallbacks, onCompiled, onError);
        };
        Engine.prototype.createRawShaderProgram = function (vertexCode, fragmentCode, context, transformFeedbackVaryings) {
            if (transformFeedbackVaryings === void 0) { transformFeedbackVaryings = null; }
            context = context || this._gl;
            var vertexShader = compileRawShader(context, vertexCode, "vertex");
            var fragmentShader = compileRawShader(context, fragmentCode, "fragment");
            return this._createShaderProgram(vertexShader, fragmentShader, context, transformFeedbackVaryings);
        };
        Engine.prototype.createShaderProgram = function (vertexCode, fragmentCode, defines, context, transformFeedbackVaryings) {
            if (transformFeedbackVaryings === void 0) { transformFeedbackVaryings = null; }
            context = context || this._gl;
            this.onBeforeShaderCompilationObservable.notifyObservers(this);
            var shaderVersion = (this._webGLVersion > 1) ? "#version 300 es\n" : "";
            var vertexShader = compileShader(context, vertexCode, "vertex", defines, shaderVersion);
            var fragmentShader = compileShader(context, fragmentCode, "fragment", defines, shaderVersion);
            var program = this._createShaderProgram(vertexShader, fragmentShader, context, transformFeedbackVaryings);
            this.onAfterShaderCompilationObservable.notifyObservers(this);
            return program;
        };
        Engine.prototype._createShaderProgram = function (vertexShader, fragmentShader, context, transformFeedbackVaryings) {
            if (transformFeedbackVaryings === void 0) { transformFeedbackVaryings = null; }
            var shaderProgram = context.createProgram();
            if (!shaderProgram) {
                throw new Error("Unable to create program");
            }
            context.attachShader(shaderProgram, vertexShader);
            context.attachShader(shaderProgram, fragmentShader);
            if (this.webGLVersion > 1 && transformFeedbackVaryings) {
                var transformFeedback = this.createTransformFeedback();
                this.bindTransformFeedback(transformFeedback);
                this.setTranformFeedbackVaryings(shaderProgram, transformFeedbackVaryings);
                shaderProgram.transformFeedback = transformFeedback;
            }
            context.linkProgram(shaderProgram);
            if (this.webGLVersion > 1 && transformFeedbackVaryings) {
                this.bindTransformFeedback(null);
            }
            var linked = context.getProgramParameter(shaderProgram, context.LINK_STATUS);
            if (!linked) {
                context.validateProgram(shaderProgram);
                var error = context.getProgramInfoLog(shaderProgram);
                if (error) {
                    throw new Error(error);
                }
            }
            context.deleteShader(vertexShader);
            context.deleteShader(fragmentShader);
            return shaderProgram;
        };
        Engine.prototype.getUniforms = function (shaderProgram, uniformsNames) {
            var results = new Array();
            for (var index = 0; index < uniformsNames.length; index++) {
                results.push(this._gl.getUniformLocation(shaderProgram, uniformsNames[index]));
            }
            return results;
        };
        Engine.prototype.getAttributes = function (shaderProgram, attributesNames) {
            var results = [];
            for (var index = 0; index < attributesNames.length; index++) {
                try {
                    results.push(this._gl.getAttribLocation(shaderProgram, attributesNames[index]));
                }
                catch (e) {
                    results.push(-1);
                }
            }
            return results;
        };
        Engine.prototype.enableEffect = function (effect) {
            if (!effect) {
                return;
            }
            // Use program
            this.setProgram(effect.getProgram());
            this._currentEffect = effect;
            if (effect.onBind) {
                effect.onBind(effect);
            }
            effect.onBindObservable.notifyObservers(effect);
        };
        Engine.prototype.setIntArray = function (uniform, array) {
            if (!uniform)
                return;
            this._gl.uniform1iv(uniform, array);
        };
        Engine.prototype.setIntArray2 = function (uniform, array) {
            if (!uniform || array.length % 2 !== 0)
                return;
            this._gl.uniform2iv(uniform, array);
        };
        Engine.prototype.setIntArray3 = function (uniform, array) {
            if (!uniform || array.length % 3 !== 0)
                return;
            this._gl.uniform3iv(uniform, array);
        };
        Engine.prototype.setIntArray4 = function (uniform, array) {
            if (!uniform || array.length % 4 !== 0)
                return;
            this._gl.uniform4iv(uniform, array);
        };
        Engine.prototype.setFloatArray = function (uniform, array) {
            if (!uniform)
                return;
            this._gl.uniform1fv(uniform, array);
        };
        Engine.prototype.setFloatArray2 = function (uniform, array) {
            if (!uniform || array.length % 2 !== 0)
                return;
            this._gl.uniform2fv(uniform, array);
        };
        Engine.prototype.setFloatArray3 = function (uniform, array) {
            if (!uniform || array.length % 3 !== 0)
                return;
            this._gl.uniform3fv(uniform, array);
        };
        Engine.prototype.setFloatArray4 = function (uniform, array) {
            if (!uniform || array.length % 4 !== 0)
                return;
            this._gl.uniform4fv(uniform, array);
        };
        Engine.prototype.setArray = function (uniform, array) {
            if (!uniform)
                return;
            this._gl.uniform1fv(uniform, array);
        };
        Engine.prototype.setArray2 = function (uniform, array) {
            if (!uniform || array.length % 2 !== 0)
                return;
            this._gl.uniform2fv(uniform, array);
        };
        Engine.prototype.setArray3 = function (uniform, array) {
            if (!uniform || array.length % 3 !== 0)
                return;
            this._gl.uniform3fv(uniform, array);
        };
        Engine.prototype.setArray4 = function (uniform, array) {
            if (!uniform || array.length % 4 !== 0)
                return;
            this._gl.uniform4fv(uniform, array);
        };
        Engine.prototype.setMatrices = function (uniform, matrices) {
            if (!uniform)
                return;
            this._gl.uniformMatrix4fv(uniform, false, matrices);
        };
        Engine.prototype.setMatrix = function (uniform, matrix) {
            if (!uniform)
                return;
            this._gl.uniformMatrix4fv(uniform, false, matrix.toArray());
        };
        Engine.prototype.setMatrix3x3 = function (uniform, matrix) {
            if (!uniform)
                return;
            this._gl.uniformMatrix3fv(uniform, false, matrix);
        };
        Engine.prototype.setMatrix2x2 = function (uniform, matrix) {
            if (!uniform)
                return;
            this._gl.uniformMatrix2fv(uniform, false, matrix);
        };
        Engine.prototype.setFloat = function (uniform, value) {
            if (!uniform)
                return;
            this._gl.uniform1f(uniform, value);
        };
        Engine.prototype.setFloat2 = function (uniform, x, y) {
            if (!uniform)
                return;
            this._gl.uniform2f(uniform, x, y);
        };
        Engine.prototype.setFloat3 = function (uniform, x, y, z) {
            if (!uniform)
                return;
            this._gl.uniform3f(uniform, x, y, z);
        };
        Engine.prototype.setBool = function (uniform, bool) {
            if (!uniform)
                return;
            this._gl.uniform1i(uniform, bool);
        };
        Engine.prototype.setFloat4 = function (uniform, x, y, z, w) {
            if (!uniform)
                return;
            this._gl.uniform4f(uniform, x, y, z, w);
        };
        Engine.prototype.setColor3 = function (uniform, color3) {
            if (!uniform)
                return;
            this._gl.uniform3f(uniform, color3.r, color3.g, color3.b);
        };
        Engine.prototype.setColor4 = function (uniform, color3, alpha) {
            if (!uniform)
                return;
            this._gl.uniform4f(uniform, color3.r, color3.g, color3.b, alpha);
        };
        // States
        Engine.prototype.setState = function (culling, zOffset, force, reverseSide) {
            if (zOffset === void 0) { zOffset = 0; }
            if (reverseSide === void 0) { reverseSide = false; }
            // Culling
            var showSide = reverseSide ? this._gl.FRONT : this._gl.BACK;
            var hideSide = reverseSide ? this._gl.BACK : this._gl.FRONT;
            var cullFace = this.cullBackFaces ? showSide : hideSide;
            if (this._depthCullingState.cull !== culling || force || this._depthCullingState.cullFace !== cullFace) {
                if (culling) {
                    this._depthCullingState.cullFace = cullFace;
                    this._depthCullingState.cull = true;
                }
                else {
                    this._depthCullingState.cull = false;
                }
            }
            // Z offset
            this.setZOffset(zOffset);
        };
        Engine.prototype.setZOffset = function (value) {
            this._depthCullingState.zOffset = value;
        };
        Engine.prototype.getZOffset = function () {
            return this._depthCullingState.zOffset;
        };
        Engine.prototype.setDepthBuffer = function (enable) {
            this._depthCullingState.depthTest = enable;
        };
        Engine.prototype.getDepthWrite = function () {
            return this._depthCullingState.depthMask;
        };
        Engine.prototype.setDepthWrite = function (enable) {
            this._depthCullingState.depthMask = enable;
        };
        Engine.prototype.setColorWrite = function (enable) {
            this._gl.colorMask(enable, enable, enable, enable);
            this._colorWrite = enable;
        };
        Engine.prototype.getColorWrite = function () {
            return this._colorWrite;
        };
        Engine.prototype.setAlphaConstants = function (r, g, b, a) {
            this._alphaState.setAlphaBlendConstants(r, g, b, a);
        };
        Engine.prototype.setAlphaMode = function (mode, noDepthWriteChange) {
            if (noDepthWriteChange === void 0) { noDepthWriteChange = false; }
            if (this._alphaMode === mode) {
                return;
            }
            switch (mode) {
                case Engine.ALPHA_DISABLE:
                    this._alphaState.alphaBlend = false;
                    break;
                case Engine.ALPHA_PREMULTIPLIED:
                    this._alphaState.setAlphaBlendFunctionParameters(this._gl.ONE, this._gl.ONE_MINUS_SRC_ALPHA, this._gl.ONE, this._gl.ONE);
                    this._alphaState.alphaBlend = true;
                    break;
                case Engine.ALPHA_PREMULTIPLIED_PORTERDUFF:
                    this._alphaState.setAlphaBlendFunctionParameters(this._gl.ONE, this._gl.ONE_MINUS_SRC_ALPHA, this._gl.ONE, this._gl.ONE_MINUS_SRC_ALPHA);
                    this._alphaState.alphaBlend = true;
                    break;
                case Engine.ALPHA_COMBINE:
                    this._alphaState.setAlphaBlendFunctionParameters(this._gl.SRC_ALPHA, this._gl.ONE_MINUS_SRC_ALPHA, this._gl.ONE, this._gl.ONE);
                    this._alphaState.alphaBlend = true;
                    break;
                case Engine.ALPHA_ONEONE:
                    this._alphaState.setAlphaBlendFunctionParameters(this._gl.ONE, this._gl.ONE, this._gl.ZERO, this._gl.ONE);
                    this._alphaState.alphaBlend = true;
                    break;
                case Engine.ALPHA_ADD:
                    this._alphaState.setAlphaBlendFunctionParameters(this._gl.SRC_ALPHA, this._gl.ONE, this._gl.ZERO, this._gl.ONE);
                    this._alphaState.alphaBlend = true;
                    break;
                case Engine.ALPHA_SUBTRACT:
                    this._alphaState.setAlphaBlendFunctionParameters(this._gl.ZERO, this._gl.ONE_MINUS_SRC_COLOR, this._gl.ONE, this._gl.ONE);
                    this._alphaState.alphaBlend = true;
                    break;
                case Engine.ALPHA_MULTIPLY:
                    this._alphaState.setAlphaBlendFunctionParameters(this._gl.DST_COLOR, this._gl.ZERO, this._gl.ONE, this._gl.ONE);
                    this._alphaState.alphaBlend = true;
                    break;
                case Engine.ALPHA_MAXIMIZED:
                    this._alphaState.setAlphaBlendFunctionParameters(this._gl.SRC_ALPHA, this._gl.ONE_MINUS_SRC_COLOR, this._gl.ONE, this._gl.ONE);
                    this._alphaState.alphaBlend = true;
                    break;
                case Engine.ALPHA_INTERPOLATE:
                    this._alphaState.setAlphaBlendFunctionParameters(this._gl.CONSTANT_COLOR, this._gl.ONE_MINUS_CONSTANT_COLOR, this._gl.CONSTANT_ALPHA, this._gl.ONE_MINUS_CONSTANT_ALPHA);
                    this._alphaState.alphaBlend = true;
                    break;
                case Engine.ALPHA_SCREENMODE:
                    this._alphaState.setAlphaBlendFunctionParameters(this._gl.ONE, this._gl.ONE_MINUS_SRC_COLOR, this._gl.ONE, this._gl.ONE_MINUS_SRC_ALPHA);
                    this._alphaState.alphaBlend = true;
                    break;
            }
            if (!noDepthWriteChange) {
                this.setDepthWrite(mode === Engine.ALPHA_DISABLE);
            }
            this._alphaMode = mode;
        };
        Engine.prototype.getAlphaMode = function () {
            return this._alphaMode;
        };
        Engine.prototype.setAlphaTesting = function (enable) {
            this._alphaTest = enable;
        };
        Engine.prototype.getAlphaTesting = function () {
            return !!this._alphaTest;
        };
        // Textures
        Engine.prototype.wipeCaches = function (bruteForce) {
            if (this.preventCacheWipeBetweenFrames) {
                return;
            }
            this.resetTextureCache();
            this._currentEffect = null;
            // 6/8/2017: deltakosh: Should not be required anymore.
            // This message is then mostly for the future myself which will scream out loud when seeing that actually it was required :)
            if (bruteForce) {
                this._currentProgram = null;
                this._stencilState.reset();
                this._depthCullingState.reset();
                this.setDepthFunctionToLessOrEqual();
                this._alphaState.reset();
            }
            this._cachedVertexBuffers = null;
            this._cachedIndexBuffer = null;
            this._cachedEffectForVertexBuffers = null;
            this._unbindVertexArrayObject();
            this.bindIndexBuffer(null);
            this.bindArrayBuffer(null);
        };
        /**
         * Set the compressed texture format to use, based on the formats you have, and the formats
         * supported by the hardware / browser.
         *
         * Khronos Texture Container (.ktx) files are used to support this.  This format has the
         * advantage of being specifically designed for OpenGL.  Header elements directly correspond
         * to API arguments needed to compressed textures.  This puts the burden on the container
         * generator to house the arcane code for determining these for current & future formats.
         *
         * for description see https://www.khronos.org/opengles/sdk/tools/KTX/
         * for file layout see https://www.khronos.org/opengles/sdk/tools/KTX/file_format_spec/
         *
         * Note: The result of this call is not taken into account when a texture is base64.
         *
         * @param {Array<string>} formatsAvailable- The list of those format families you have created
         * on your server.  Syntax: '-' + format family + '.ktx'.  (Case and order do not matter.)
         *
         * Current families are astc, dxt, pvrtc, etc2, & etc1.
         * @returns The extension selected.
         */
        Engine.prototype.setTextureFormatToUse = function (formatsAvailable) {
            for (var i = 0, len1 = this.texturesSupported.length; i < len1; i++) {
                for (var j = 0, len2 = formatsAvailable.length; j < len2; j++) {
                    if (this._texturesSupported[i] === formatsAvailable[j].toLowerCase()) {
                        return this._textureFormatInUse = this._texturesSupported[i];
                    }
                }
            }
            // actively set format to nothing, to allow this to be called more than once
            // and possibly fail the 2nd time
            this._textureFormatInUse = null;
            return null;
        };
        Engine.prototype._createTexture = function () {
            var texture = this._gl.createTexture();
            if (!texture) {
                throw new Error("Unable to create texture");
            }
            return texture;
        };
        /**
         * Usually called from BABYLON.Texture.ts.  Passed information to create a WebGLTexture.
         * @param {string} urlArg- This contains one of the following:
         *                         1. A conventional http URL, e.g. 'http://...' or 'file://...'
         *                         2. A base64 string of in-line texture data, e.g. 'data:image/jpg;base64,/...'
         *                         3. An indicator that data being passed using the buffer parameter, e.g. 'data:mytexture.jpg'
         *
         * @param {boolean} noMipmap- When true, no mipmaps shall be generated.  Ignored for compressed textures.  They must be in the file.
         * @param {boolean} invertY- When true, image is flipped when loaded.  You probably want true. Ignored for compressed textures.  Must be flipped in the file.
         * @param {Scene} scene- Needed for loading to the correct scene.
         * @param {number} samplingMode- Mode with should be used sample / access the texture.  Default: TRILINEAR
         * @param {callback} onLoad- Optional callback to be called upon successful completion.
         * @param {callback} onError- Optional callback to be called upon failure.
         * @param {ArrayBuffer | HTMLImageElement} buffer- A source of a file previously fetched as either an ArrayBuffer (compressed or image format) or HTMLImageElement (image format)
         * @param {WebGLTexture} fallback- An internal argument in case the function must be called again, due to etc1 not having alpha capabilities.
         * @param {number} format-  Internal format.  Default: RGB when extension is '.jpg' else RGBA.  Ignored for compressed textures.
         *
         * @returns {WebGLTexture} for assignment back into BABYLON.Texture
         */
        Engine.prototype.createTexture = function (urlArg, noMipmap, invertY, scene, samplingMode, onLoad, onError, buffer, fallBack, format) {
            var _this = this;
            if (samplingMode === void 0) { samplingMode = BABYLON.Texture.TRILINEAR_SAMPLINGMODE; }
            if (onLoad === void 0) { onLoad = null; }
            if (onError === void 0) { onError = null; }
            if (buffer === void 0) { buffer = null; }
            if (fallBack === void 0) { fallBack = null; }
            if (format === void 0) { format = null; }
            var url = String(urlArg); // assign a new string, so that the original is still available in case of fallback
            var fromData = url.substr(0, 5) === "data:";
            var fromBlob = url.substr(0, 5) === "blob:";
            var isBase64 = fromData && url.indexOf("base64") !== -1;
            var texture = fallBack ? fallBack : new BABYLON.InternalTexture(this, BABYLON.InternalTexture.DATASOURCE_URL);
            // establish the file extension, if possible
            var lastDot = url.lastIndexOf('.');
            var extension = (lastDot > 0) ? url.substring(lastDot).toLowerCase() : "";
            var isDDS = this.getCaps().s3tc && (extension === ".dds");
            var isTGA = (extension === ".tga");
            // determine if a ktx file should be substituted
            var isKTX = false;
            if (this._textureFormatInUse && !isBase64 && !fallBack) {
                url = url.substring(0, lastDot) + this._textureFormatInUse;
                isKTX = true;
            }
            if (scene) {
                scene._addPendingData(texture);
            }
            texture.url = url;
            texture.generateMipMaps = !noMipmap;
            texture.samplingMode = samplingMode;
            texture.invertY = invertY;
            if (!this._doNotHandleContextLost) {
                // Keep a link to the buffer only if we plan to handle context lost
                texture._buffer = buffer;
            }
            var onLoadObserver = null;
            if (onLoad && !fallBack) {
                onLoadObserver = texture.onLoadedObservable.add(onLoad);
            }
            if (!fallBack)
                this._internalTexturesCache.push(texture);
            var onerror = function (message, exception) {
                if (scene) {
                    scene._removePendingData(texture);
                }
                if (onLoadObserver) {
                    texture.onLoadedObservable.remove(onLoadObserver);
                }
                // fallback for when compressed file not found to try again.  For instance, etc1 does not have an alpha capable type
                if (isKTX) {
                    _this.createTexture(urlArg, noMipmap, invertY, scene, samplingMode, null, onError, buffer, texture);
                }
                else if (BABYLON.Tools.UseFallbackTexture) {
                    _this.createTexture(BABYLON.Tools.fallbackTexture, noMipmap, invertY, scene, samplingMode, null, onError, buffer, texture);
                }
                if (onError) {
                    onError(message || "Unknown error", exception);
                }
            };
            var callback = null;
            // processing for non-image formats
            if (isKTX || isTGA || isDDS) {
                if (isKTX) {
                    callback = function (data) {
                        var ktx = new BABYLON.Internals.KhronosTextureContainer(data, 1);
                        _this._prepareWebGLTexture(texture, scene, ktx.pixelWidth, ktx.pixelHeight, invertY, false, true, function () {
                            ktx.uploadLevels(_this._gl, !noMipmap);
                            return false;
                        }, samplingMode);
                    };
                }
                else if (isTGA) {
                    callback = function (arrayBuffer) {
                        var data = new Uint8Array(arrayBuffer);
                        var header = BABYLON.Internals.TGATools.GetTGAHeader(data);
                        _this._prepareWebGLTexture(texture, scene, header.width, header.height, invertY, noMipmap, false, function () {
                            BABYLON.Internals.TGATools.UploadContent(_this._gl, data);
                            return false;
                        }, samplingMode);
                    };
                }
                else if (isDDS) {
                    callback = function (data) {
                        var info = BABYLON.Internals.DDSTools.GetDDSInfo(data);
                        var loadMipmap = (info.isRGB || info.isLuminance || info.mipmapCount > 1) && !noMipmap && ((info.width >> (info.mipmapCount - 1)) === 1);
                        _this._prepareWebGLTexture(texture, scene, info.width, info.height, invertY, !loadMipmap, info.isFourCC, function () {
                            BABYLON.Internals.DDSTools.UploadDDSLevels(_this, _this._gl, data, info, loadMipmap, 1);
                            return false;
                        }, samplingMode);
                    };
                }
                if (!buffer) {
                    BABYLON.Tools.LoadFile(url, function (data) {
                        if (callback) {
                            callback(data);
                        }
                    }, undefined, scene ? scene.database : undefined, true, function (request, exception) {
                        onerror("Unable to load " + (request ? request.responseURL : url, exception));
                    });
                }
                else {
                    if (callback) {
                        callback(buffer);
                    }
                }
                // image format processing
            }
            else {
                var onload = function (img) {
                    if (fromBlob && !_this._doNotHandleContextLost) {
                        // We need to store the image if we need to rebuild the texture
                        // in case of a webgl context lost
                        texture._buffer = img;
                    }
                    _this._prepareWebGLTexture(texture, scene, img.width, img.height, invertY, noMipmap, false, function (potWidth, potHeight, continuationCallback) {
                        var gl = _this._gl;
                        var isPot = (img.width === potWidth && img.height === potHeight);
                        var internalFormat = format ? _this._getInternalFormat(format) : ((extension === ".jpg") ? gl.RGB : gl.RGBA);
                        if (isPot) {
                            gl.texImage2D(gl.TEXTURE_2D, 0, internalFormat, internalFormat, gl.UNSIGNED_BYTE, img);
                            return false;
                        }
                        // Using shaders to rescale because canvas.drawImage is lossy
                        var source = new BABYLON.InternalTexture(_this, BABYLON.InternalTexture.DATASOURCE_TEMP);
                        _this._bindTextureDirectly(gl.TEXTURE_2D, source);
                        gl.texImage2D(gl.TEXTURE_2D, 0, internalFormat, internalFormat, gl.UNSIGNED_BYTE, img);
                        gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, gl.LINEAR);
                        gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.LINEAR);
                        gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);
                        gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);
                        _this._rescaleTexture(source, texture, scene, internalFormat, function () {
                            _this._releaseTexture(source);
                            _this._bindTextureDirectly(gl.TEXTURE_2D, texture);
                            continuationCallback();
                        });
                        return true;
                    }, samplingMode);
                };
                if (!fromData || isBase64)
                    if (buffer instanceof HTMLImageElement) {
                        onload(buffer);
                    }
                    else {
                        BABYLON.Tools.LoadImage(url, onload, onerror, scene ? scene.database : null);
                    }
                else if (buffer instanceof Array || typeof buffer === "string" || buffer instanceof ArrayBuffer)
                    BABYLON.Tools.LoadImage(buffer, onload, onerror, scene ? scene.database : null);
                else
                    onload(buffer);
            }
            return texture;
        };
        Engine.prototype._rescaleTexture = function (source, destination, scene, internalFormat, onComplete) {
            var _this = this;
            var rtt = this.createRenderTargetTexture({
                width: destination.width,
                height: destination.height,
            }, {
                generateMipMaps: false,
                type: Engine.TEXTURETYPE_UNSIGNED_INT,
                samplingMode: BABYLON.Texture.BILINEAR_SAMPLINGMODE,
                generateDepthBuffer: false,
                generateStencilBuffer: false
            });
            if (!this._rescalePostProcess) {
                this._rescalePostProcess = new BABYLON.PassPostProcess("rescale", 1, null, BABYLON.Texture.BILINEAR_SAMPLINGMODE, this, false, Engine.TEXTURETYPE_UNSIGNED_INT);
            }
            this._rescalePostProcess.getEffect().executeWhenCompiled(function () {
                _this._rescalePostProcess.onApply = function (effect) {
                    effect._bindTexture("textureSampler", source);
                };
                var hostingScene = scene;
                if (!hostingScene) {
                    hostingScene = _this.scenes[_this.scenes.length - 1];
                }
                hostingScene.postProcessManager.directRender([_this._rescalePostProcess], rtt, true);
                _this._bindTextureDirectly(_this._gl.TEXTURE_2D, destination);
                _this._gl.copyTexImage2D(_this._gl.TEXTURE_2D, 0, internalFormat, 0, 0, destination.width, destination.height, 0);
                _this.unBindFramebuffer(rtt);
                _this._releaseTexture(rtt);
                if (onComplete) {
                    onComplete();
                }
            });
        };
        Engine.prototype._getInternalFormat = function (format) {
            var internalFormat = this._gl.RGBA;
            switch (format) {
                case Engine.TEXTUREFORMAT_ALPHA:
                    internalFormat = this._gl.ALPHA;
                    break;
                case Engine.TEXTUREFORMAT_LUMINANCE:
                    internalFormat = this._gl.LUMINANCE;
                    break;
                case Engine.TEXTUREFORMAT_LUMINANCE_ALPHA:
                    internalFormat = this._gl.LUMINANCE_ALPHA;
                    break;
                case Engine.TEXTUREFORMAT_RGB:
                    internalFormat = this._gl.RGB;
                    break;
                case Engine.TEXTUREFORMAT_RGBA:
                    internalFormat = this._gl.RGBA;
                    break;
            }
            return internalFormat;
        };
        Engine.prototype.updateRawTexture = function (texture, data, format, invertY, compression, type) {
            if (compression === void 0) { compression = null; }
            if (type === void 0) { type = Engine.TEXTURETYPE_UNSIGNED_INT; }
            if (!texture) {
                return;
            }
            var internalFormat = this._getInternalFormat(format);
            var internalSizedFomat = this._getRGBABufferInternalSizedFormat(type);
            var textureType = this._getWebGLTextureType(type);
            this._bindTextureDirectly(this._gl.TEXTURE_2D, texture);
            this._gl.pixelStorei(this._gl.UNPACK_FLIP_Y_WEBGL, invertY === undefined ? 1 : (invertY ? 1 : 0));
            if (!this._doNotHandleContextLost) {
                texture._bufferView = data;
                texture.format = format;
                texture.type = type;
                texture.invertY = invertY;
                texture._compression = compression;
            }
            if (texture.width % 4 !== 0) {
                this._gl.pixelStorei(this._gl.UNPACK_ALIGNMENT, 1);
            }
            if (compression && data) {
                this._gl.compressedTexImage2D(this._gl.TEXTURE_2D, 0, this.getCaps().s3tc[compression], texture.width, texture.height, 0, data);
            }
            else {
                this._gl.texImage2D(this._gl.TEXTURE_2D, 0, internalSizedFomat, texture.width, texture.height, 0, internalFormat, textureType, data);
            }
            if (texture.generateMipMaps) {
                this._gl.generateMipmap(this._gl.TEXTURE_2D);
            }
            this._bindTextureDirectly(this._gl.TEXTURE_2D, null);
            this.resetTextureCache();
            texture.isReady = true;
        };
        Engine.prototype.createRawTexture = function (data, width, height, format, generateMipMaps, invertY, samplingMode, compression, type) {
            if (compression === void 0) { compression = null; }
            if (type === void 0) { type = BABYLON.Engine.TEXTURETYPE_UNSIGNED_INT; }
            var texture = new BABYLON.InternalTexture(this, BABYLON.InternalTexture.DATASOURCE_RAW);
            texture.baseWidth = width;
            texture.baseHeight = height;
            texture.width = width;
            texture.height = height;
            texture.format = format;
            texture.generateMipMaps = generateMipMaps;
            texture.samplingMode = samplingMode;
            texture.invertY = invertY;
            texture._compression = compression;
            texture.type = type;
            if (!this._doNotHandleContextLost) {
                texture._bufferView = data;
            }
            this.updateRawTexture(texture, data, format, invertY, compression, type);
            this._bindTextureDirectly(this._gl.TEXTURE_2D, texture);
            // Filters
            var filters = getSamplingParameters(samplingMode, generateMipMaps, this._gl);
            this._gl.texParameteri(this._gl.TEXTURE_2D, this._gl.TEXTURE_MAG_FILTER, filters.mag);
            this._gl.texParameteri(this._gl.TEXTURE_2D, this._gl.TEXTURE_MIN_FILTER, filters.min);
            if (generateMipMaps) {
                this._gl.generateMipmap(this._gl.TEXTURE_2D);
            }
            this._bindTextureDirectly(this._gl.TEXTURE_2D, null);
            this._internalTexturesCache.push(texture);
            return texture;
        };
        Engine.prototype.createDynamicTexture = function (width, height, generateMipMaps, samplingMode) {
            var texture = new BABYLON.InternalTexture(this, BABYLON.InternalTexture.DATASOURCE_DYNAMIC);
            texture.baseWidth = width;
            texture.baseHeight = height;
            if (generateMipMaps) {
                width = this.needPOTTextures ? BABYLON.Tools.GetExponentOfTwo(width, this._caps.maxTextureSize) : width;
                height = this.needPOTTextures ? BABYLON.Tools.GetExponentOfTwo(height, this._caps.maxTextureSize) : height;
            }
            this.resetTextureCache();
            texture.width = width;
            texture.height = height;
            texture.isReady = false;
            texture.generateMipMaps = generateMipMaps;
            texture.samplingMode = samplingMode;
            this.updateTextureSamplingMode(samplingMode, texture);
            this._internalTexturesCache.push(texture);
            return texture;
        };
        Engine.prototype.updateTextureSamplingMode = function (samplingMode, texture) {
            var filters = getSamplingParameters(samplingMode, texture.generateMipMaps, this._gl);
            if (texture.isCube) {
                this._bindTextureDirectly(this._gl.TEXTURE_CUBE_MAP, texture);
                this._gl.texParameteri(this._gl.TEXTURE_CUBE_MAP, this._gl.TEXTURE_MAG_FILTER, filters.mag);
                this._gl.texParameteri(this._gl.TEXTURE_CUBE_MAP, this._gl.TEXTURE_MIN_FILTER, filters.min);
                this._bindTextureDirectly(this._gl.TEXTURE_CUBE_MAP, null);
            }
            else if (texture.is3D) {
                this._bindTextureDirectly(this._gl.TEXTURE_3D, texture);
                this._gl.texParameteri(this._gl.TEXTURE_3D, this._gl.TEXTURE_MAG_FILTER, filters.mag);
                this._gl.texParameteri(this._gl.TEXTURE_3D, this._gl.TEXTURE_MIN_FILTER, filters.min);
                this._bindTextureDirectly(this._gl.TEXTURE_3D, null);
            }
            else {
                this._bindTextureDirectly(this._gl.TEXTURE_2D, texture);
                this._gl.texParameteri(this._gl.TEXTURE_2D, this._gl.TEXTURE_MAG_FILTER, filters.mag);
                this._gl.texParameteri(this._gl.TEXTURE_2D, this._gl.TEXTURE_MIN_FILTER, filters.min);
                this._bindTextureDirectly(this._gl.TEXTURE_2D, null);
            }
            texture.samplingMode = samplingMode;
        };
        Engine.prototype.updateDynamicTexture = function (texture, canvas, invertY, premulAlpha, format) {
            if (premulAlpha === void 0) { premulAlpha = false; }
            if (!texture) {
                return;
            }
            this._bindTextureDirectly(this._gl.TEXTURE_2D, texture);
            this._gl.pixelStorei(this._gl.UNPACK_FLIP_Y_WEBGL, invertY ? 1 : 0);
            if (premulAlpha) {
                this._gl.pixelStorei(this._gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL, 1);
            }
            var internalFormat = format ? this._getInternalFormat(format) : this._gl.RGBA;
            this._gl.texImage2D(this._gl.TEXTURE_2D, 0, internalFormat, internalFormat, this._gl.UNSIGNED_BYTE, canvas);
            if (texture.generateMipMaps) {
                this._gl.generateMipmap(this._gl.TEXTURE_2D);
            }
            this._bindTextureDirectly(this._gl.TEXTURE_2D, null);
            if (premulAlpha) {
                this._gl.pixelStorei(this._gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL, 0);
            }
            this.resetTextureCache();
            texture.isReady = true;
        };
        Engine.prototype.updateVideoTexture = function (texture, video, invertY) {
            if (!texture || texture._isDisabled) {
                return;
            }
            this._bindTextureDirectly(this._gl.TEXTURE_2D, texture);
            this._gl.pixelStorei(this._gl.UNPACK_FLIP_Y_WEBGL, invertY ? 0 : 1); // Video are upside down by default
            try {
                // Testing video texture support
                if (this._videoTextureSupported === undefined) {
                    this._gl.texImage2D(this._gl.TEXTURE_2D, 0, this._gl.RGBA, this._gl.RGBA, this._gl.UNSIGNED_BYTE, video);
                    if (this._gl.getError() !== 0) {
                        this._videoTextureSupported = false;
                    }
                    else {
                        this._videoTextureSupported = true;
                    }
                }
                // Copy video through the current working canvas if video texture is not supported
                if (!this._videoTextureSupported) {
                    if (!texture._workingCanvas) {
                        texture._workingCanvas = document.createElement("canvas");
                        var context = texture._workingCanvas.getContext("2d");
                        if (!context) {
                            throw new Error("Unable to get 2d context");
                        }
                        texture._workingContext = context;
                        texture._workingCanvas.width = texture.width;
                        texture._workingCanvas.height = texture.height;
                    }
                    texture._workingContext.drawImage(video, 0, 0, video.videoWidth, video.videoHeight, 0, 0, texture.width, texture.height);
                    this._gl.texImage2D(this._gl.TEXTURE_2D, 0, this._gl.RGBA, this._gl.RGBA, this._gl.UNSIGNED_BYTE, texture._workingCanvas);
                }
                else {
                    this._gl.texImage2D(this._gl.TEXTURE_2D, 0, this._gl.RGBA, this._gl.RGBA, this._gl.UNSIGNED_BYTE, video);
                }
                if (texture.generateMipMaps) {
                    this._gl.generateMipmap(this._gl.TEXTURE_2D);
                }
                this._bindTextureDirectly(this._gl.TEXTURE_2D, null);
                this.resetTextureCache();
                texture.isReady = true;
            }
            catch (ex) {
                // Something unexpected
                // Let's disable the texture
                texture._isDisabled = true;
            }
        };
        Engine.prototype.createRenderTargetTexture = function (size, options) {
            var fullOptions = new RenderTargetCreationOptions();
            if (options !== undefined && typeof options === "object") {
                fullOptions.generateMipMaps = options.generateMipMaps;
                fullOptions.generateDepthBuffer = options.generateDepthBuffer === undefined ? true : options.generateDepthBuffer;
                fullOptions.generateStencilBuffer = fullOptions.generateDepthBuffer && options.generateStencilBuffer;
                fullOptions.type = options.type === undefined ? Engine.TEXTURETYPE_UNSIGNED_INT : options.type;
                fullOptions.samplingMode = options.samplingMode === undefined ? BABYLON.Texture.TRILINEAR_SAMPLINGMODE : options.samplingMode;
            }
            else {
                fullOptions.generateMipMaps = options;
                fullOptions.generateDepthBuffer = true;
                fullOptions.generateStencilBuffer = false;
                fullOptions.type = Engine.TEXTURETYPE_UNSIGNED_INT;
                fullOptions.samplingMode = BABYLON.Texture.TRILINEAR_SAMPLINGMODE;
            }
            if (fullOptions.type === Engine.TEXTURETYPE_FLOAT && !this._caps.textureFloatLinearFiltering) {
                // if floating point linear (gl.FLOAT) then force to NEAREST_SAMPLINGMODE
                fullOptions.samplingMode = BABYLON.Texture.NEAREST_SAMPLINGMODE;
            }
            else if (fullOptions.type === Engine.TEXTURETYPE_HALF_FLOAT && !this._caps.textureHalfFloatLinearFiltering) {
                // if floating point linear (HALF_FLOAT) then force to NEAREST_SAMPLINGMODE
                fullOptions.samplingMode = BABYLON.Texture.NEAREST_SAMPLINGMODE;
            }
            var gl = this._gl;
            var texture = new BABYLON.InternalTexture(this, BABYLON.InternalTexture.DATASOURCE_RENDERTARGET);
            this._bindTextureDirectly(gl.TEXTURE_2D, texture);
            var width = size.width || size;
            var height = size.height || size;
            var filters = getSamplingParameters(fullOptions.samplingMode, fullOptions.generateMipMaps ? true : false, gl);
            if (fullOptions.type === Engine.TEXTURETYPE_FLOAT && !this._caps.textureFloat) {
                fullOptions.type = Engine.TEXTURETYPE_UNSIGNED_INT;
                BABYLON.Tools.Warn("Float textures are not supported. Render target forced to TEXTURETYPE_UNSIGNED_BYTE type");
            }
            gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, filters.mag);
            gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, filters.min);
            gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);
            gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);
            gl.texImage2D(gl.TEXTURE_2D, 0, this._getRGBABufferInternalSizedFormat(fullOptions.type), width, height, 0, gl.RGBA, this._getWebGLTextureType(fullOptions.type), null);
            // Create the framebuffer
            var framebuffer = gl.createFramebuffer();
            this.bindUnboundFramebuffer(framebuffer);
            gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.COLOR_ATTACHMENT0, gl.TEXTURE_2D, texture._webGLTexture, 0);
            texture._depthStencilBuffer = this._setupFramebufferDepthAttachments(fullOptions.generateStencilBuffer ? true : false, fullOptions.generateDepthBuffer, width, height);
            if (fullOptions.generateMipMaps) {
                this._gl.generateMipmap(this._gl.TEXTURE_2D);
            }
            // Unbind
            this._bindTextureDirectly(gl.TEXTURE_2D, null);
            gl.bindRenderbuffer(gl.RENDERBUFFER, null);
            this.bindUnboundFramebuffer(null);
            texture._framebuffer = framebuffer;
            texture.baseWidth = width;
            texture.baseHeight = height;
            texture.width = width;
            texture.height = height;
            texture.isReady = true;
            texture.samples = 1;
            texture.generateMipMaps = fullOptions.generateMipMaps ? true : false;
            texture.samplingMode = fullOptions.samplingMode;
            texture.type = fullOptions.type;
            texture._generateDepthBuffer = fullOptions.generateDepthBuffer;
            texture._generateStencilBuffer = fullOptions.generateStencilBuffer ? true : false;
            this.resetTextureCache();
            this._internalTexturesCache.push(texture);
            return texture;
        };
        Engine.prototype.createMultipleRenderTarget = function (size, options) {
            var generateMipMaps = false;
            var generateDepthBuffer = true;
            var generateStencilBuffer = false;
            var generateDepthTexture = false;
            var textureCount = 1;
            var defaultType = Engine.TEXTURETYPE_UNSIGNED_INT;
            var defaultSamplingMode = BABYLON.Texture.TRILINEAR_SAMPLINGMODE;
            var types = [], samplingModes = [];
            if (options !== undefined) {
                generateMipMaps = options.generateMipMaps;
                generateDepthBuffer = options.generateDepthBuffer === undefined ? true : options.generateDepthBuffer;
                generateStencilBuffer = options.generateStencilBuffer;
                generateDepthTexture = options.generateDepthTexture;
                textureCount = options.textureCount || 1;
                if (options.types) {
                    types = options.types;
                }
                if (options.samplingModes) {
                    samplingModes = options.samplingModes;
                }
            }
            var gl = this._gl;
            // Create the framebuffer
            var framebuffer = gl.createFramebuffer();
            this.bindUnboundFramebuffer(framebuffer);
            var width = size.width || size;
            var height = size.height || size;
            var textures = [];
            var attachments = [];
            var depthStencilBuffer = this._setupFramebufferDepthAttachments(generateStencilBuffer, generateDepthBuffer, width, height);
            for (var i = 0; i < textureCount; i++) {
                var samplingMode = samplingModes[i] || defaultSamplingMode;
                var type = types[i] || defaultType;
                if (type === Engine.TEXTURETYPE_FLOAT && !this._caps.textureFloatLinearFiltering) {
                    // if floating point linear (gl.FLOAT) then force to NEAREST_SAMPLINGMODE
                    samplingMode = BABYLON.Texture.NEAREST_SAMPLINGMODE;
                }
                else if (type === Engine.TEXTURETYPE_HALF_FLOAT && !this._caps.textureHalfFloatLinearFiltering) {
                    // if floating point linear (HALF_FLOAT) then force to NEAREST_SAMPLINGMODE
                    samplingMode = BABYLON.Texture.NEAREST_SAMPLINGMODE;
                }
                var filters = getSamplingParameters(samplingMode, generateMipMaps, gl);
                if (type === Engine.TEXTURETYPE_FLOAT && !this._caps.textureFloat) {
                    type = Engine.TEXTURETYPE_UNSIGNED_INT;
                    BABYLON.Tools.Warn("Float textures are not supported. Render target forced to TEXTURETYPE_UNSIGNED_BYTE type");
                }
                var texture = new BABYLON.InternalTexture(this, BABYLON.InternalTexture.DATASOURCE_MULTIRENDERTARGET);
                var attachment = gl[this.webGLVersion > 1 ? "COLOR_ATTACHMENT" + i : "COLOR_ATTACHMENT" + i + "_WEBGL"];
                textures.push(texture);
                attachments.push(attachment);
                gl.activeTexture(gl["TEXTURE" + i]);
                gl.bindTexture(gl.TEXTURE_2D, texture._webGLTexture);
                gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, filters.mag);
                gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, filters.min);
                gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);
                gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);
                gl.texImage2D(gl.TEXTURE_2D, 0, this._getRGBABufferInternalSizedFormat(type), width, height, 0, gl.RGBA, this._getWebGLTextureType(type), null);
                gl.framebufferTexture2D(gl.DRAW_FRAMEBUFFER, attachment, gl.TEXTURE_2D, texture._webGLTexture, 0);
                if (generateMipMaps) {
                    this._gl.generateMipmap(this._gl.TEXTURE_2D);
                }
                // Unbind
                this._bindTextureDirectly(gl.TEXTURE_2D, null);
                texture._framebuffer = framebuffer;
                texture._depthStencilBuffer = depthStencilBuffer;
                texture.baseWidth = width;
                texture.baseHeight = height;
                texture.width = width;
                texture.height = height;
                texture.isReady = true;
                texture.samples = 1;
                texture.generateMipMaps = generateMipMaps;
                texture.samplingMode = samplingMode;
                texture.type = type;
                texture._generateDepthBuffer = generateDepthBuffer;
                texture._generateStencilBuffer = generateStencilBuffer;
                this._internalTexturesCache.push(texture);
            }
            if (generateDepthTexture && this._caps.depthTextureExtension) {
                // Depth texture
                var depthTexture = new BABYLON.InternalTexture(this, BABYLON.InternalTexture.DATASOURCE_MULTIRENDERTARGET);
                gl.activeTexture(gl.TEXTURE0);
                gl.bindTexture(gl.TEXTURE_2D, depthTexture._webGLTexture);
                gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, gl.NEAREST);
                gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.NEAREST);
                gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);
                gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);
                gl.texImage2D(gl.TEXTURE_2D, 0, this.webGLVersion < 2 ? gl.DEPTH_COMPONENT : gl.DEPTH_COMPONENT16, width, height, 0, gl.DEPTH_COMPONENT, gl.UNSIGNED_SHORT, null);
                gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.DEPTH_ATTACHMENT, gl.TEXTURE_2D, depthTexture._webGLTexture, 0);
                depthTexture._framebuffer = framebuffer;
                depthTexture.baseWidth = width;
                depthTexture.baseHeight = height;
                depthTexture.width = width;
                depthTexture.height = height;
                depthTexture.isReady = true;
                depthTexture.samples = 1;
                depthTexture.generateMipMaps = generateMipMaps;
                depthTexture.samplingMode = gl.NEAREST;
                depthTexture._generateDepthBuffer = generateDepthBuffer;
                depthTexture._generateStencilBuffer = generateStencilBuffer;
                textures.push(depthTexture);
                this._internalTexturesCache.push(depthTexture);
            }
            gl.drawBuffers(attachments);
            gl.bindRenderbuffer(gl.RENDERBUFFER, null);
            this.bindUnboundFramebuffer(null);
            this.resetTextureCache();
            return textures;
        };
        Engine.prototype._setupFramebufferDepthAttachments = function (generateStencilBuffer, generateDepthBuffer, width, height, samples) {
            if (samples === void 0) { samples = 1; }
            var depthStencilBuffer = null;
            var gl = this._gl;
            // Create the depth/stencil buffer
            if (generateStencilBuffer) {
                depthStencilBuffer = gl.createRenderbuffer();
                gl.bindRenderbuffer(gl.RENDERBUFFER, depthStencilBuffer);
                if (samples > 1) {
                    gl.renderbufferStorageMultisample(gl.RENDERBUFFER, samples, gl.DEPTH24_STENCIL8, width, height);
                }
                else {
                    gl.renderbufferStorage(gl.RENDERBUFFER, gl.DEPTH_STENCIL, width, height);
                }
                gl.framebufferRenderbuffer(gl.FRAMEBUFFER, gl.DEPTH_STENCIL_ATTACHMENT, gl.RENDERBUFFER, depthStencilBuffer);
            }
            else if (generateDepthBuffer) {
                depthStencilBuffer = gl.createRenderbuffer();
                gl.bindRenderbuffer(gl.RENDERBUFFER, depthStencilBuffer);
                if (samples > 1) {
                    gl.renderbufferStorageMultisample(gl.RENDERBUFFER, samples, gl.DEPTH_COMPONENT16, width, height);
                }
                else {
                    gl.renderbufferStorage(gl.RENDERBUFFER, gl.DEPTH_COMPONENT16, width, height);
                }
                gl.framebufferRenderbuffer(gl.FRAMEBUFFER, gl.DEPTH_ATTACHMENT, gl.RENDERBUFFER, depthStencilBuffer);
            }
            return depthStencilBuffer;
        };
        Engine.prototype.updateRenderTargetTextureSampleCount = function (texture, samples) {
            if (this.webGLVersion < 2 || !texture) {
                return 1;
            }
            if (texture.samples === samples) {
                return samples;
            }
            var gl = this._gl;
            samples = Math.min(samples, gl.getParameter(gl.MAX_SAMPLES));
            // Dispose previous render buffers
            if (texture._depthStencilBuffer) {
                gl.deleteRenderbuffer(texture._depthStencilBuffer);
            }
            if (texture._MSAAFramebuffer) {
                gl.deleteFramebuffer(texture._MSAAFramebuffer);
            }
            if (texture._MSAARenderBuffer) {
                gl.deleteRenderbuffer(texture._MSAARenderBuffer);
            }
            if (samples > 1) {
                var framebuffer = gl.createFramebuffer();
                if (!framebuffer) {
                    throw new Error("Unable to create multi sampled framebuffer");
                }
                texture._MSAAFramebuffer = framebuffer;
                this.bindUnboundFramebuffer(texture._MSAAFramebuffer);
                var colorRenderbuffer = gl.createRenderbuffer();
                if (!colorRenderbuffer) {
                    throw new Error("Unable to create multi sampled framebuffer");
                }
                gl.bindRenderbuffer(gl.RENDERBUFFER, colorRenderbuffer);
                gl.renderbufferStorageMultisample(gl.RENDERBUFFER, samples, gl.RGBA8, texture.width, texture.height);
                gl.framebufferRenderbuffer(gl.FRAMEBUFFER, gl.COLOR_ATTACHMENT0, gl.RENDERBUFFER, colorRenderbuffer);
                texture._MSAARenderBuffer = colorRenderbuffer;
            }
            else {
                this.bindUnboundFramebuffer(texture._framebuffer);
            }
            texture.samples = samples;
            texture._depthStencilBuffer = this._setupFramebufferDepthAttachments(texture._generateStencilBuffer, texture._generateDepthBuffer, texture.width, texture.height, samples);
            gl.bindRenderbuffer(gl.RENDERBUFFER, null);
            this.bindUnboundFramebuffer(null);
            return samples;
        };
        Engine.prototype._uploadDataToTexture = function (target, lod, internalFormat, width, height, format, type, data) {
            this._gl.texImage2D(target, lod, internalFormat, width, height, 0, format, type, data);
        };
        Engine.prototype._uploadCompressedDataToTexture = function (target, lod, internalFormat, width, height, data) {
            this._gl.compressedTexImage2D(target, lod, internalFormat, width, height, 0, data);
        };
        Engine.prototype.createRenderTargetCubeTexture = function (size, options) {
            var gl = this._gl;
            var texture = new BABYLON.InternalTexture(this, BABYLON.InternalTexture.DATASOURCE_RENDERTARGET);
            var generateMipMaps = true;
            var generateDepthBuffer = true;
            var generateStencilBuffer = false;
            var samplingMode = BABYLON.Texture.TRILINEAR_SAMPLINGMODE;
            if (options !== undefined) {
                generateMipMaps = options.generateMipMaps === undefined ? true : options.generateMipMaps;
                generateDepthBuffer = options.generateDepthBuffer === undefined ? true : options.generateDepthBuffer;
                generateStencilBuffer = (generateDepthBuffer && options.generateStencilBuffer) ? true : false;
                if (options.samplingMode !== undefined) {
                    samplingMode = options.samplingMode;
                }
            }
            texture.isCube = true;
            texture.generateMipMaps = generateMipMaps;
            texture.samples = 1;
            texture.samplingMode = samplingMode;
            var filters = getSamplingParameters(samplingMode, generateMipMaps, gl);
            this._bindTextureDirectly(gl.TEXTURE_CUBE_MAP, texture);
            for (var face = 0; face < 6; face++) {
                gl.texImage2D((gl.TEXTURE_CUBE_MAP_POSITIVE_X + face), 0, gl.RGBA, size, size, 0, gl.RGBA, gl.UNSIGNED_BYTE, null);
            }
            gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_MAG_FILTER, filters.mag);
            gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_MIN_FILTER, filters.min);
            gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);
            gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);
            // Create the framebuffer
            var framebuffer = gl.createFramebuffer();
            this.bindUnboundFramebuffer(framebuffer);
            texture._depthStencilBuffer = this._setupFramebufferDepthAttachments(generateStencilBuffer, generateDepthBuffer, size, size);
            // Mipmaps
            if (texture.generateMipMaps) {
                this._bindTextureDirectly(gl.TEXTURE_CUBE_MAP, texture);
                gl.generateMipmap(gl.TEXTURE_CUBE_MAP);
            }
            // Unbind
            this._bindTextureDirectly(gl.TEXTURE_CUBE_MAP, null);
            gl.bindRenderbuffer(gl.RENDERBUFFER, null);
            this.bindUnboundFramebuffer(null);
            texture._framebuffer = framebuffer;
            texture.width = size;
            texture.height = size;
            texture.isReady = true;
            this.resetTextureCache();
            this._internalTexturesCache.push(texture);
            return texture;
        };
        Engine.prototype.createPrefilteredCubeTexture = function (rootUrl, scene, scale, offset, onLoad, onError, format, forcedExtension) {
            var _this = this;
            if (onLoad === void 0) { onLoad = null; }
            if (onError === void 0) { onError = null; }
            if (forcedExtension === void 0) { forcedExtension = null; }
            var callback = function (loadData) {
                if (!loadData) {
                    if (onLoad) {
                        onLoad(null);
                    }
                    return;
                }
                var texture = loadData.texture;
                texture._dataSource = BABYLON.InternalTexture.DATASOURCE_CUBEPREFILTERED;
                texture._lodGenerationScale = scale;
                texture._lodGenerationOffset = offset;
                if (_this._caps.textureLOD) {
                    // Do not add extra process if texture lod is supported.
                    if (onLoad) {
                        onLoad(texture);
                    }
                    return;
                }
                var mipSlices = 3;
                var gl = _this._gl;
                var width = loadData.width;
                if (!width) {
                    return;
                }
                var textures = [];
                for (var i = 0; i < mipSlices; i++) {
                    //compute LOD from even spacing in smoothness (matching shader calculation)
                    var smoothness = i / (mipSlices - 1);
                    var roughness = 1 - smoothness;
                    var minLODIndex = offset; // roughness = 0
                    var maxLODIndex = BABYLON.Scalar.Log2(width) * scale + offset; // roughness = 1
                    var lodIndex = minLODIndex + (maxLODIndex - minLODIndex) * roughness;
                    var mipmapIndex = Math.round(Math.min(Math.max(lodIndex, 0), maxLODIndex));
                    var glTextureFromLod = new BABYLON.InternalTexture(_this, BABYLON.InternalTexture.DATASOURCE_TEMP);
                    glTextureFromLod.isCube = true;
                    _this._bindTextureDirectly(gl.TEXTURE_CUBE_MAP, glTextureFromLod);
                    gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_MAG_FILTER, gl.LINEAR);
                    gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_MIN_FILTER, gl.LINEAR);
                    gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);
                    gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);
                    if (loadData.isDDS) {
                        var info = loadData.info;
                        var data = loadData.data;
                        gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, info.isCompressed ? 1 : 0);
                        BABYLON.Internals.DDSTools.UploadDDSLevels(_this, _this._gl, data, info, true, 6, mipmapIndex);
                    }
                    else {
                        BABYLON.Tools.Warn("DDS is the only prefiltered cube map supported so far.");
                    }
                    _this._bindTextureDirectly(gl.TEXTURE_CUBE_MAP, null);
                    // Wrap in a base texture for easy binding.
                    var lodTexture = new BABYLON.BaseTexture(scene);
                    lodTexture.isCube = true;
                    lodTexture._texture = glTextureFromLod;
                    glTextureFromLod.isReady = true;
                    textures.push(lodTexture);
                }
                texture._lodTextureHigh = textures[2];
                texture._lodTextureMid = textures[1];
                texture._lodTextureLow = textures[0];
                if (onLoad) {
                    onLoad(texture);
                }
            };
            return this.createCubeTexture(rootUrl, scene, null, false, callback, onError, format, forcedExtension);
        };
        Engine.prototype.createCubeTexture = function (rootUrl, scene, files, noMipmap, onLoad, onError, format, forcedExtension) {
            var _this = this;
            if (onLoad === void 0) { onLoad = null; }
            if (onError === void 0) { onError = null; }
            if (forcedExtension === void 0) { forcedExtension = null; }
            var gl = this._gl;
            var texture = new BABYLON.InternalTexture(this, BABYLON.InternalTexture.DATASOURCE_CUBE);
            texture.isCube = true;
            texture.url = rootUrl;
            texture.generateMipMaps = !noMipmap;
            if (!this._doNotHandleContextLost) {
                texture._extension = forcedExtension;
                texture._files = files;
            }
            var isKTX = false;
            var isDDS = false;
            var lastDot = rootUrl.lastIndexOf('.');
            var extension = forcedExtension ? forcedExtension : (lastDot > -1 ? rootUrl.substring(lastDot).toLowerCase() : "");
            if (this._textureFormatInUse) {
                extension = this._textureFormatInUse;
                rootUrl = (lastDot > -1 ? rootUrl.substring(0, lastDot) : rootUrl) + this._textureFormatInUse;
                isKTX = true;
            }
            else {
                isDDS = (extension === ".dds");
            }
            var onerror = function (request, exception) {
                if (onError && request) {
                    onError(request.status + " " + request.statusText, exception);
                }
            };
            if (isKTX) {
                BABYLON.Tools.LoadFile(rootUrl, function (data) {
                    var ktx = new BABYLON.Internals.KhronosTextureContainer(data, 6);
                    var loadMipmap = ktx.numberOfMipmapLevels > 1 && !noMipmap;
                    _this._bindTextureDirectly(gl.TEXTURE_CUBE_MAP, texture);
                    gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, 1);
                    ktx.uploadLevels(_this._gl, !noMipmap);
                    _this.setCubeMapTextureParams(gl, loadMipmap);
                    texture.width = ktx.pixelWidth;
                    texture.height = ktx.pixelHeight;
                    texture.isReady = true;
                }, undefined, undefined, true, onerror);
            }
            else if (isDDS) {
                if (files && files.length === 6) {
                    cascadeLoadFiles(rootUrl, scene, function (imgs) {
                        var info;
                        var loadMipmap = false;
                        var width = 0;
                        for (var index = 0; index < imgs.length; index++) {
                            var data = imgs[index];
                            info = BABYLON.Internals.DDSTools.GetDDSInfo(data);
                            loadMipmap = (info.isRGB || info.isLuminance || info.mipmapCount > 1) && !noMipmap;
                            _this._bindTextureDirectly(gl.TEXTURE_CUBE_MAP, texture);
                            gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, info.isCompressed ? 1 : 0);
                            BABYLON.Internals.DDSTools.UploadDDSLevels(_this, _this._gl, data, info, loadMipmap, 6, -1, index);
                            if (!noMipmap && !info.isFourCC && info.mipmapCount === 1) {
                                gl.generateMipmap(gl.TEXTURE_CUBE_MAP);
                            }
                            texture.width = info.width;
                            texture.height = info.height;
                            texture.type = info.textureType;
                            width = info.width;
                        }
                        _this.setCubeMapTextureParams(gl, loadMipmap);
                        texture.isReady = true;
                        if (onLoad) {
                            onLoad({ isDDS: true, width: width, info: info, imgs: imgs, texture: texture });
                        }
                    }, files, onError);
                }
                else {
                    BABYLON.Tools.LoadFile(rootUrl, function (data) {
                        var info = BABYLON.Internals.DDSTools.GetDDSInfo(data);
                        var loadMipmap = (info.isRGB || info.isLuminance || info.mipmapCount > 1) && !noMipmap;
                        _this._bindTextureDirectly(gl.TEXTURE_CUBE_MAP, texture);
                        gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, info.isCompressed ? 1 : 0);
                        BABYLON.Internals.DDSTools.UploadDDSLevels(_this, _this._gl, data, info, loadMipmap, 6);
                        if (!noMipmap && !info.isFourCC && info.mipmapCount === 1) {
                            gl.generateMipmap(gl.TEXTURE_CUBE_MAP);
                        }
                        _this.setCubeMapTextureParams(gl, loadMipmap);
                        texture.width = info.width;
                        texture.height = info.height;
                        texture.isReady = true;
                        texture.type = info.textureType;
                        if (onLoad) {
                            onLoad({ isDDS: true, width: info.width, info: info, data: data, texture: texture });
                        }
                    }, undefined, undefined, true, onerror);
                }
            }
            else {
                if (!files) {
                    throw new Error("Cannot load cubemap because files were not defined");
                }
                cascadeLoadImgs(rootUrl, scene, function (imgs) {
                    var width = _this.needPOTTextures ? BABYLON.Tools.GetExponentOfTwo(imgs[0].width, _this._caps.maxCubemapTextureSize) : imgs[0].width;
                    var height = width;
                    _this._prepareWorkingCanvas();
                    if (!_this._workingCanvas || !_this._workingContext) {
                        return;
                    }
                    _this._workingCanvas.width = width;
                    _this._workingCanvas.height = height;
                    var faces = [
                        gl.TEXTURE_CUBE_MAP_POSITIVE_X, gl.TEXTURE_CUBE_MAP_POSITIVE_Y, gl.TEXTURE_CUBE_MAP_POSITIVE_Z,
                        gl.TEXTURE_CUBE_MAP_NEGATIVE_X, gl.TEXTURE_CUBE_MAP_NEGATIVE_Y, gl.TEXTURE_CUBE_MAP_NEGATIVE_Z
                    ];
                    _this._bindTextureDirectly(gl.TEXTURE_CUBE_MAP, texture);
                    gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, 0);
                    var internalFormat = format ? _this._getInternalFormat(format) : _this._gl.RGBA;
                    for (var index = 0; index < faces.length; index++) {
                        _this._workingContext.drawImage(imgs[index], 0, 0, imgs[index].width, imgs[index].height, 0, 0, width, height);
                        gl.texImage2D(faces[index], 0, internalFormat, internalFormat, gl.UNSIGNED_BYTE, _this._workingCanvas);
                    }
                    if (!noMipmap) {
                        gl.generateMipmap(gl.TEXTURE_CUBE_MAP);
                    }
                    _this.setCubeMapTextureParams(gl, !noMipmap);
                    texture.width = width;
                    texture.height = height;
                    texture.isReady = true;
                    if (format) {
                        texture.format = format;
                    }
                    texture.onLoadedObservable.notifyObservers(texture);
                    texture.onLoadedObservable.clear();
                    if (onLoad) {
                        onLoad();
                    }
                }, files, onError);
            }
            this._internalTexturesCache.push(texture);
            return texture;
        };
        Engine.prototype.setCubeMapTextureParams = function (gl, loadMipmap) {
            gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_MAG_FILTER, gl.LINEAR);
            gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_MIN_FILTER, loadMipmap ? gl.LINEAR_MIPMAP_LINEAR : gl.LINEAR);
            gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);
            gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);
            this._bindTextureDirectly(gl.TEXTURE_CUBE_MAP, null);
            this.resetTextureCache();
        };
        Engine.prototype.updateRawCubeTexture = function (texture, data, format, type, invertY, compression, level) {
            if (compression === void 0) { compression = null; }
            if (level === void 0) { level = 0; }
            texture._bufferViewArray = data;
            texture.format = format;
            texture.type = type;
            texture.invertY = invertY;
            texture._compression = compression;
            var gl = this._gl;
            var textureType = this._getWebGLTextureType(type);
            var internalFormat = this._getInternalFormat(format);
            var internalSizedFomat = this._getRGBABufferInternalSizedFormat(type);
            var needConversion = false;
            if (internalFormat === gl.RGB) {
                internalFormat = gl.RGBA;
                needConversion = true;
            }
            this._bindTextureDirectly(gl.TEXTURE_CUBE_MAP, texture);
            gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, invertY === undefined ? 1 : (invertY ? 1 : 0));
            if (texture.width % 4 !== 0) {
                gl.pixelStorei(gl.UNPACK_ALIGNMENT, 1);
            }
            // Data are known to be in +X +Y +Z -X -Y -Z
            for (var faceIndex = 0; faceIndex < 6; faceIndex++) {
                var faceData = data[faceIndex];
                if (compression) {
                    gl.compressedTexImage2D(gl.TEXTURE_CUBE_MAP_POSITIVE_X + faceIndex, level, (this.getCaps().s3tc)[compression], texture.width, texture.height, 0, faceData);
                }
                else {
                    if (needConversion) {
                        faceData = this._convertRGBtoRGBATextureData(faceData, texture.width, texture.height, type);
                    }
                    gl.texImage2D(gl.TEXTURE_CUBE_MAP_POSITIVE_X + faceIndex, level, internalSizedFomat, texture.width, texture.height, 0, internalFormat, textureType, faceData);
                }
            }
            var isPot = !this.needPOTTextures || (BABYLON.Tools.IsExponentOfTwo(texture.width) && BABYLON.Tools.IsExponentOfTwo(texture.height));
            if (isPot && texture.generateMipMaps && level === 0) {
                this._gl.generateMipmap(this._gl.TEXTURE_CUBE_MAP);
            }
            this._bindTextureDirectly(this._gl.TEXTURE_CUBE_MAP, null);
            this.resetTextureCache();
            texture.isReady = true;
        };
        Engine.prototype.createRawCubeTexture = function (data, size, format, type, generateMipMaps, invertY, samplingMode, compression) {
            if (compression === void 0) { compression = null; }
            var gl = this._gl;
            var texture = new BABYLON.InternalTexture(this, BABYLON.InternalTexture.DATASOURCE_CUBERAW);
            texture.isCube = true;
            texture.generateMipMaps = generateMipMaps;
            texture.format = format;
            texture.type = type;
            if (!this._doNotHandleContextLost) {
                texture._bufferViewArray = data;
            }
            var textureType = this._getWebGLTextureType(type);
            var internalFormat = this._getInternalFormat(format);
            if (internalFormat === gl.RGB) {
                internalFormat = gl.RGBA;
            }
            var width = size;
            var height = width;
            texture.width = width;
            texture.height = height;
            // Double check on POT to generate Mips.
            var isPot = !this.needPOTTextures || (BABYLON.Tools.IsExponentOfTwo(texture.width) && BABYLON.Tools.IsExponentOfTwo(texture.height));
            if (!isPot) {
                generateMipMaps = false;
            }
            // Upload data if needed. The texture won't be ready until then.
            if (data) {
                this.updateRawCubeTexture(texture, data, format, type, invertY, compression);
            }
            this._bindTextureDirectly(this._gl.TEXTURE_CUBE_MAP, texture);
            // Filters
            if (data && generateMipMaps) {
                this._gl.generateMipmap(this._gl.TEXTURE_CUBE_MAP);
            }
            if (textureType === gl.FLOAT && !this._caps.textureFloatLinearFiltering) {
                gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_MAG_FILTER, gl.NEAREST);
                gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_MIN_FILTER, gl.NEAREST);
            }
            else if (textureType === this._gl.HALF_FLOAT_OES && !this._caps.textureHalfFloatLinearFiltering) {
                gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_MAG_FILTER, gl.NEAREST);
                gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_MIN_FILTER, gl.NEAREST);
            }
            else {
                var filters = getSamplingParameters(samplingMode, generateMipMaps, gl);
                gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_MAG_FILTER, filters.mag);
                gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_MIN_FILTER, filters.min);
            }
            gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);
            gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);
            this._bindTextureDirectly(gl.TEXTURE_CUBE_MAP, null);
            return texture;
        };
        Engine.prototype.createRawCubeTextureFromUrl = function (url, scene, size, format, type, noMipmap, callback, mipmmapGenerator, onLoad, onError, samplingMode, invertY) {
            var _this = this;
            if (onLoad === void 0) { onLoad = null; }
            if (onError === void 0) { onError = null; }
            if (samplingMode === void 0) { samplingMode = BABYLON.Texture.TRILINEAR_SAMPLINGMODE; }
            if (invertY === void 0) { invertY = false; }
            var gl = this._gl;
            var texture = this.createRawCubeTexture(null, size, format, type, !noMipmap, invertY, samplingMode);
            scene._addPendingData(texture);
            texture.url = url;
            this._internalTexturesCache.push(texture);
            var onerror = function (request, exception) {
                scene._removePendingData(texture);
                if (onError && request) {
                    onError(request.status + " " + request.statusText, exception);
                }
            };
            var internalCallback = function (data) {
                var width = texture.width;
                var faceDataArrays = callback(data);
                if (!faceDataArrays) {
                    return;
                }
                if (mipmmapGenerator) {
                    var textureType = _this._getWebGLTextureType(type);
                    var internalFormat = _this._getInternalFormat(format);
                    var internalSizedFomat = _this._getRGBABufferInternalSizedFormat(type);
                    var needConversion = false;
                    if (internalFormat === gl.RGB) {
                        internalFormat = gl.RGBA;
                        needConversion = true;
                    }
                    _this._bindTextureDirectly(gl.TEXTURE_CUBE_MAP, texture);
                    gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, 0);
                    var mipData = mipmmapGenerator(faceDataArrays);
                    for (var level = 0; level < mipData.length; level++) {
                        var mipSize = width >> level;
                        for (var faceIndex = 0; faceIndex < 6; faceIndex++) {
                            var mipFaceData = mipData[level][faceIndex];
                            if (needConversion) {
                                mipFaceData = _this._convertRGBtoRGBATextureData(mipFaceData, mipSize, mipSize, type);
                            }
                            gl.texImage2D(faceIndex, level, internalSizedFomat, mipSize, mipSize, 0, internalFormat, textureType, mipFaceData);
                        }
                    }
                    _this._bindTextureDirectly(gl.TEXTURE_CUBE_MAP, null);
                }
                else {
                    texture.generateMipMaps = !noMipmap;
                    _this.updateRawCubeTexture(texture, faceDataArrays, format, type, invertY);
                }
                texture.isReady = true;
                _this.resetTextureCache();
                scene._removePendingData(texture);
                if (onLoad) {
                    onLoad();
                }
            };
            BABYLON.Tools.LoadFile(url, function (data) {
                internalCallback(data);
            }, undefined, scene.database, true, onerror);
            return texture;
        };
        ;
        Engine.prototype.updateRawTexture3D = function (texture, data, format, invertY, compression) {
            if (compression === void 0) { compression = null; }
            var internalFormat = this._getInternalFormat(format);
            this._bindTextureDirectly(this._gl.TEXTURE_3D, texture);
            this._gl.pixelStorei(this._gl.UNPACK_FLIP_Y_WEBGL, invertY === undefined ? 1 : (invertY ? 1 : 0));
            if (!this._doNotHandleContextLost) {
                texture._bufferView = data;
                texture.format = format;
                texture.invertY = invertY;
                texture._compression = compression;
            }
            if (texture.width % 4 !== 0) {
                this._gl.pixelStorei(this._gl.UNPACK_ALIGNMENT, 1);
            }
            if (compression && data) {
                this._gl.compressedTexImage3D(this._gl.TEXTURE_3D, 0, this.getCaps().s3tc[compression], texture.width, texture.height, texture.depth, 0, data);
            }
            else {
                this._gl.texImage3D(this._gl.TEXTURE_3D, 0, internalFormat, texture.width, texture.height, texture.depth, 0, internalFormat, this._gl.UNSIGNED_BYTE, data);
            }
            if (texture.generateMipMaps) {
                this._gl.generateMipmap(this._gl.TEXTURE_3D);
            }
            this._bindTextureDirectly(this._gl.TEXTURE_3D, null);
            this.resetTextureCache();
            texture.isReady = true;
        };
        Engine.prototype.createRawTexture3D = function (data, width, height, depth, format, generateMipMaps, invertY, samplingMode, compression) {
            if (compression === void 0) { compression = null; }
            var texture = new BABYLON.InternalTexture(this, BABYLON.InternalTexture.DATASOURCE_RAW3D);
            texture.baseWidth = width;
            texture.baseHeight = height;
            texture.baseDepth = depth;
            texture.width = width;
            texture.height = height;
            texture.depth = depth;
            texture.format = format;
            texture.generateMipMaps = generateMipMaps;
            texture.samplingMode = samplingMode;
            texture.is3D = true;
            if (!this._doNotHandleContextLost) {
                texture._bufferView = data;
            }
            this.updateRawTexture3D(texture, data, format, invertY, compression);
            this._bindTextureDirectly(this._gl.TEXTURE_3D, texture);
            // Filters
            var filters = getSamplingParameters(samplingMode, generateMipMaps, this._gl);
            this._gl.texParameteri(this._gl.TEXTURE_3D, this._gl.TEXTURE_MAG_FILTER, filters.mag);
            this._gl.texParameteri(this._gl.TEXTURE_3D, this._gl.TEXTURE_MIN_FILTER, filters.min);
            if (generateMipMaps) {
                this._gl.generateMipmap(this._gl.TEXTURE_3D);
            }
            this._bindTextureDirectly(this._gl.TEXTURE_3D, null);
            this._internalTexturesCache.push(texture);
            return texture;
        };
        Engine.prototype._prepareWebGLTextureContinuation = function (texture, scene, noMipmap, isCompressed, samplingMode) {
            var gl = this._gl;
            if (!gl) {
                return;
            }
            var filters = getSamplingParameters(samplingMode, !noMipmap, gl);
            gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, filters.mag);
            gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, filters.min);
            if (!noMipmap && !isCompressed) {
                gl.generateMipmap(gl.TEXTURE_2D);
            }
            this._bindTextureDirectly(gl.TEXTURE_2D, null);
            this.resetTextureCache();
            if (scene) {
                scene._removePendingData(texture);
            }
            texture.onLoadedObservable.notifyObservers(texture);
            texture.onLoadedObservable.clear();
        };
        Engine.prototype._prepareWebGLTexture = function (texture, scene, width, height, invertY, noMipmap, isCompressed, processFunction, samplingMode) {
            var _this = this;
            if (samplingMode === void 0) { samplingMode = BABYLON.Texture.TRILINEAR_SAMPLINGMODE; }
            var potWidth = this.needPOTTextures ? BABYLON.Tools.GetExponentOfTwo(width, this.getCaps().maxTextureSize) : width;
            var potHeight = this.needPOTTextures ? BABYLON.Tools.GetExponentOfTwo(height, this.getCaps().maxTextureSize) : height;
            var gl = this._gl;
            if (!gl) {
                return;
            }
            if (!texture._webGLTexture) {
                this.resetTextureCache();
                if (scene) {
                    scene._removePendingData(texture);
                }
                return;
            }
            this._bindTextureDirectly(gl.TEXTURE_2D, texture);
            gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, invertY === undefined ? 1 : (invertY ? 1 : 0));
            texture.baseWidth = width;
            texture.baseHeight = height;
            texture.width = potWidth;
            texture.height = potHeight;
            texture.isReady = true;
            if (processFunction(potWidth, potHeight, function () {
                _this._prepareWebGLTextureContinuation(texture, scene, noMipmap, isCompressed, samplingMode);
            })) {
                // Returning as texture needs extra async steps
                return;
            }
            this._prepareWebGLTextureContinuation(texture, scene, noMipmap, isCompressed, samplingMode);
        };
        Engine.prototype._convertRGBtoRGBATextureData = function (rgbData, width, height, textureType) {
            // Create new RGBA data container.
            var rgbaData;
            if (textureType === Engine.TEXTURETYPE_FLOAT) {
                rgbaData = new Float32Array(width * height * 4);
            }
            else {
                rgbaData = new Uint32Array(width * height * 4);
            }
            // Convert each pixel.
            for (var x = 0; x < width; x++) {
                for (var y = 0; y < height; y++) {
                    var index = (y * width + x) * 3;
                    var newIndex = (y * width + x) * 4;
                    // Map Old Value to new value.
                    rgbaData[newIndex + 0] = rgbData[index + 0];
                    rgbaData[newIndex + 1] = rgbData[index + 1];
                    rgbaData[newIndex + 2] = rgbData[index + 2];
                    // Add fully opaque alpha channel.
                    rgbaData[newIndex + 3] = 1;
                }
            }
            return rgbaData;
        };
        Engine.prototype._releaseFramebufferObjects = function (texture) {
            var gl = this._gl;
            if (texture._framebuffer) {
                gl.deleteFramebuffer(texture._framebuffer);
                texture._framebuffer = null;
            }
            if (texture._depthStencilBuffer) {
                gl.deleteRenderbuffer(texture._depthStencilBuffer);
                texture._depthStencilBuffer = null;
            }
            if (texture._MSAAFramebuffer) {
                gl.deleteFramebuffer(texture._MSAAFramebuffer);
                texture._MSAAFramebuffer = null;
            }
            if (texture._MSAARenderBuffer) {
                gl.deleteRenderbuffer(texture._MSAARenderBuffer);
                texture._MSAARenderBuffer = null;
            }
        };
        Engine.prototype._releaseTexture = function (texture) {
            var gl = this._gl;
            this._releaseFramebufferObjects(texture);
            gl.deleteTexture(texture._webGLTexture);
            // Unbind channels
            this.unbindAllTextures();
            var index = this._internalTexturesCache.indexOf(texture);
            if (index !== -1) {
                this._internalTexturesCache.splice(index, 1);
            }
            // Integrated fixed lod samplers.
            if (texture._lodTextureHigh) {
                texture._lodTextureHigh.dispose();
            }
            if (texture._lodTextureMid) {
                texture._lodTextureMid.dispose();
            }
            if (texture._lodTextureLow) {
                texture._lodTextureLow.dispose();
            }
        };
        Engine.prototype.setProgram = function (program) {
            if (this._currentProgram !== program) {
                this._gl.useProgram(program);
                this._currentProgram = program;
            }
        };
        Engine.prototype.bindSamplers = function (effect) {
            this.setProgram(effect.getProgram());
            var samplers = effect.getSamplers();
            for (var index = 0; index < samplers.length; index++) {
                var uniform = effect.getUniform(samplers[index]);
                this._gl.uniform1i(uniform, index);
            }
            this._currentEffect = null;
        };
        Engine.prototype.activateTextureChannel = function (textureChannel) {
            if (this._activeTextureChannel !== textureChannel) {
                this._gl.activeTexture(textureChannel);
                this._activeTextureChannel = textureChannel;
            }
        };
        Engine.prototype._bindTextureDirectly = function (target, texture) {
            if (this._boundTexturesCache[this._activeTextureChannel] !== texture) {
                this._gl.bindTexture(target, texture ? texture._webGLTexture : null);
                this._boundTexturesCache[this._activeTextureChannel] = texture;
            }
        };
        Engine.prototype._bindTexture = function (channel, texture) {
            if (channel < 0) {
                return;
            }
            this.activateTextureChannel(this._gl.TEXTURE0 + channel);
            this._bindTextureDirectly(this._gl.TEXTURE_2D, texture);
        };
        Engine.prototype.setTextureFromPostProcess = function (channel, postProcess) {
            this._bindTexture(channel, postProcess ? postProcess._textures.data[postProcess._currentRenderTextureInd] : null);
        };
        Engine.prototype.unbindAllTextures = function () {
            for (var channel = 0; channel < this._caps.maxTexturesImageUnits; channel++) {
                this.activateTextureChannel(this._gl.TEXTURE0 + channel);
                this._bindTextureDirectly(this._gl.TEXTURE_2D, null);
                this._bindTextureDirectly(this._gl.TEXTURE_CUBE_MAP, null);
                if (this.webGLVersion > 1) {
                    this._bindTextureDirectly(this._gl.TEXTURE_3D, null);
                }
            }
        };
        Engine.prototype.setTexture = function (channel, uniform, texture) {
            if (channel < 0) {
                return;
            }
            if (this._setTexture(channel, texture)) {
                this._gl.uniform1i(uniform, channel);
            }
        };
        Engine.prototype._setTexture = function (channel, texture) {
            // Not ready?
            if (!texture) {
                if (this._boundTexturesCache[channel] != null) {
                    this.activateTextureChannel(this._gl.TEXTURE0 + channel);
                    this._bindTextureDirectly(this._gl.TEXTURE_2D, null);
                    this._bindTextureDirectly(this._gl.TEXTURE_CUBE_MAP, null);
                    if (this.webGLVersion > 1) {
                        this._bindTextureDirectly(this._gl.TEXTURE_3D, null);
                    }
                }
                return false;
            }
            // Video
            var alreadyActivated = false;
            if (texture.video) {
                this.activateTextureChannel(this._gl.TEXTURE0 + channel);
                alreadyActivated = true;
                texture.update();
            }
            else if (texture.delayLoadState === Engine.DELAYLOADSTATE_NOTLOADED) {
                texture.delayLoad();
                return false;
            }
            var internalTexture;
            if (texture.isReady()) {
                internalTexture = texture.getInternalTexture();
            }
            else if (texture.isCube) {
                internalTexture = this.emptyCubeTexture;
            }
            else if (texture.is3D) {
                internalTexture = this.emptyTexture3D;
            }
            else {
                internalTexture = this.emptyTexture;
            }
            if (!alreadyActivated) {
                this.activateTextureChannel(this._gl.TEXTURE0 + channel);
            }
            if (this._boundTexturesCache[this._activeTextureChannel] === internalTexture) {
                return false;
            }
            if (internalTexture && internalTexture.is3D) {
                this._bindTextureDirectly(this._gl.TEXTURE_3D, internalTexture);
                if (internalTexture && internalTexture._cachedWrapU !== texture.wrapU) {
                    internalTexture._cachedWrapU = texture.wrapU;
                    switch (texture.wrapU) {
                        case BABYLON.Texture.WRAP_ADDRESSMODE:
                            this._gl.texParameteri(this._gl.TEXTURE_3D, this._gl.TEXTURE_WRAP_S, this._gl.REPEAT);
                            break;
                        case BABYLON.Texture.CLAMP_ADDRESSMODE:
                            this._gl.texParameteri(this._gl.TEXTURE_3D, this._gl.TEXTURE_WRAP_S, this._gl.CLAMP_TO_EDGE);
                            break;
                        case BABYLON.Texture.MIRROR_ADDRESSMODE:
                            this._gl.texParameteri(this._gl.TEXTURE_3D, this._gl.TEXTURE_WRAP_S, this._gl.MIRRORED_REPEAT);
                            break;
                    }
                }
                if (internalTexture && internalTexture._cachedWrapV !== texture.wrapV) {
                    internalTexture._cachedWrapV = texture.wrapV;
                    switch (texture.wrapV) {
                        case BABYLON.Texture.WRAP_ADDRESSMODE:
                            this._gl.texParameteri(this._gl.TEXTURE_3D, this._gl.TEXTURE_WRAP_T, this._gl.REPEAT);
                            break;
                        case BABYLON.Texture.CLAMP_ADDRESSMODE:
                            this._gl.texParameteri(this._gl.TEXTURE_3D, this._gl.TEXTURE_WRAP_T, this._gl.CLAMP_TO_EDGE);
                            break;
                        case BABYLON.Texture.MIRROR_ADDRESSMODE:
                            this._gl.texParameteri(this._gl.TEXTURE_3D, this._gl.TEXTURE_WRAP_T, this._gl.MIRRORED_REPEAT);
                            break;
                    }
                }
                if (internalTexture && internalTexture._cachedWrapR !== texture.wrapR) {
                    internalTexture._cachedWrapR = texture.wrapR;
                    switch (texture.wrapV) {
                        case BABYLON.Texture.WRAP_ADDRESSMODE:
                            this._gl.texParameteri(this._gl.TEXTURE_3D, this._gl.TEXTURE_WRAP_R, this._gl.REPEAT);
                            break;
                        case BABYLON.Texture.CLAMP_ADDRESSMODE:
                            this._gl.texParameteri(this._gl.TEXTURE_3D, this._gl.TEXTURE_WRAP_R, this._gl.CLAMP_TO_EDGE);
                            break;
                        case BABYLON.Texture.MIRROR_ADDRESSMODE:
                            this._gl.texParameteri(this._gl.TEXTURE_3D, this._gl.TEXTURE_WRAP_R, this._gl.MIRRORED_REPEAT);
                            break;
                    }
                }
                this._setAnisotropicLevel(this._gl.TEXTURE_3D, texture);
            }
            else if (internalTexture && internalTexture.isCube) {
                this._bindTextureDirectly(this._gl.TEXTURE_CUBE_MAP, internalTexture);
                if (internalTexture._cachedCoordinatesMode !== texture.coordinatesMode) {
                    internalTexture._cachedCoordinatesMode = texture.coordinatesMode;
                    // CUBIC_MODE and SKYBOX_MODE both require CLAMP_TO_EDGE.  All other modes use REPEAT.
                    var textureWrapMode = (texture.coordinatesMode !== BABYLON.Texture.CUBIC_MODE && texture.coordinatesMode !== BABYLON.Texture.SKYBOX_MODE) ? this._gl.REPEAT : this._gl.CLAMP_TO_EDGE;
                    this._gl.texParameteri(this._gl.TEXTURE_CUBE_MAP, this._gl.TEXTURE_WRAP_S, textureWrapMode);
                    this._gl.texParameteri(this._gl.TEXTURE_CUBE_MAP, this._gl.TEXTURE_WRAP_T, textureWrapMode);
                }
                this._setAnisotropicLevel(this._gl.TEXTURE_CUBE_MAP, texture);
            }
            else {
                this._bindTextureDirectly(this._gl.TEXTURE_2D, internalTexture);
                if (internalTexture && internalTexture._cachedWrapU !== texture.wrapU) {
                    internalTexture._cachedWrapU = texture.wrapU;
                    switch (texture.wrapU) {
                        case BABYLON.Texture.WRAP_ADDRESSMODE:
                            this._gl.texParameteri(this._gl.TEXTURE_2D, this._gl.TEXTURE_WRAP_S, this._gl.REPEAT);
                            break;
                        case BABYLON.Texture.CLAMP_ADDRESSMODE:
                            this._gl.texParameteri(this._gl.TEXTURE_2D, this._gl.TEXTURE_WRAP_S, this._gl.CLAMP_TO_EDGE);
                            break;
                        case BABYLON.Texture.MIRROR_ADDRESSMODE:
                            this._gl.texParameteri(this._gl.TEXTURE_2D, this._gl.TEXTURE_WRAP_S, this._gl.MIRRORED_REPEAT);
                            break;
                    }
                }
                if (internalTexture && internalTexture._cachedWrapV !== texture.wrapV) {
                    internalTexture._cachedWrapV = texture.wrapV;
                    switch (texture.wrapV) {
                        case BABYLON.Texture.WRAP_ADDRESSMODE:
                            this._gl.texParameteri(this._gl.TEXTURE_2D, this._gl.TEXTURE_WRAP_T, this._gl.REPEAT);
                            break;
                        case BABYLON.Texture.CLAMP_ADDRESSMODE:
                            this._gl.texParameteri(this._gl.TEXTURE_2D, this._gl.TEXTURE_WRAP_T, this._gl.CLAMP_TO_EDGE);
                            break;
                        case BABYLON.Texture.MIRROR_ADDRESSMODE:
                            this._gl.texParameteri(this._gl.TEXTURE_2D, this._gl.TEXTURE_WRAP_T, this._gl.MIRRORED_REPEAT);
                            break;
                    }
                }
                this._setAnisotropicLevel(this._gl.TEXTURE_2D, texture);
            }
            return true;
        };
        Engine.prototype.setTextureArray = function (channel, uniform, textures) {
            if (channel < 0 || !uniform) {
                return;
            }
            if (!this._textureUnits || this._textureUnits.length !== textures.length) {
                this._textureUnits = new Int32Array(textures.length);
            }
            for (var i = 0; i < textures.length; i++) {
                this._textureUnits[i] = channel + i;
            }
            this._gl.uniform1iv(uniform, this._textureUnits);
            for (var index = 0; index < textures.length; index++) {
                this._setTexture(channel + index, textures[index]);
            }
        };
        Engine.prototype._setAnisotropicLevel = function (key, texture) {
            var internalTexture = texture.getInternalTexture();
            if (!internalTexture) {
                return;
            }
            var anisotropicFilterExtension = this._caps.textureAnisotropicFilterExtension;
            var value = texture.anisotropicFilteringLevel;
            if (internalTexture.samplingMode !== BABYLON.Texture.LINEAR_LINEAR_MIPNEAREST
                && internalTexture.samplingMode !== BABYLON.Texture.LINEAR_LINEAR_MIPLINEAR
                && internalTexture.samplingMode !== BABYLON.Texture.LINEAR_LINEAR) {
                value = 1; // Forcing the anisotropic to 1 because else webgl will force filters to linear
            }
            if (anisotropicFilterExtension && internalTexture._cachedAnisotropicFilteringLevel !== value) {
                this._gl.texParameterf(key, anisotropicFilterExtension.TEXTURE_MAX_ANISOTROPY_EXT, Math.min(value, this._caps.maxAnisotropy));
                internalTexture._cachedAnisotropicFilteringLevel = value;
            }
        };
        Engine.prototype.readPixels = function (x, y, width, height) {
            var data = new Uint8Array(height * width * 4);
            this._gl.readPixels(x, y, width, height, this._gl.RGBA, this._gl.UNSIGNED_BYTE, data);
            return data;
        };
        /**
         * Add an externaly attached data from its key.
         * This method call will fail and return false, if such key already exists.
         * If you don't care and just want to get the data no matter what, use the more convenient getOrAddExternalDataWithFactory() method.
         * @param key the unique key that identifies the data
         * @param data the data object to associate to the key for this Engine instance
         * @return true if no such key were already present and the data was added successfully, false otherwise
         */
        Engine.prototype.addExternalData = function (key, data) {
            if (!this._externalData) {
                this._externalData = new BABYLON.StringDictionary();
            }
            return this._externalData.add(key, data);
        };
        /**
         * Get an externaly attached data from its key
         * @param key the unique key that identifies the data
         * @return the associated data, if present (can be null), or undefined if not present
         */
        Engine.prototype.getExternalData = function (key) {
            if (!this._externalData) {
                this._externalData = new BABYLON.StringDictionary();
            }
            return this._externalData.get(key);
        };
        /**
         * Get an externaly attached data from its key, create it using a factory if it's not already present
         * @param key the unique key that identifies the data
         * @param factory the factory that will be called to create the instance if and only if it doesn't exists
         * @return the associated data, can be null if the factory returned null.
         */
        Engine.prototype.getOrAddExternalDataWithFactory = function (key, factory) {
            if (!this._externalData) {
                this._externalData = new BABYLON.StringDictionary();
            }
            return this._externalData.getOrAddWithFactory(key, factory);
        };
        /**
         * Remove an externaly attached data from the Engine instance
         * @param key the unique key that identifies the data
         * @return true if the data was successfully removed, false if it doesn't exist
         */
        Engine.prototype.removeExternalData = function (key) {
            if (!this._externalData) {
                this._externalData = new BABYLON.StringDictionary();
            }
            return this._externalData.remove(key);
        };
        Engine.prototype.unbindAllAttributes = function () {
            if (this._mustWipeVertexAttributes) {
                this._mustWipeVertexAttributes = false;
                for (var i = 0; i < this._caps.maxVertexAttribs; i++) {
                    this._gl.disableVertexAttribArray(i);
                    this._vertexAttribArraysEnabled[i] = false;
                    this._currentBufferPointers[i].active = false;
                }
                return;
            }
            for (var i = 0, ul = this._vertexAttribArraysEnabled.length; i < ul; i++) {
                if (i >= this._caps.maxVertexAttribs || !this._vertexAttribArraysEnabled[i]) {
                    continue;
                }
                this._gl.disableVertexAttribArray(i);
                this._vertexAttribArraysEnabled[i] = false;
                this._currentBufferPointers[i].active = false;
            }
        };
        Engine.prototype.releaseEffects = function () {
            for (var name in this._compiledEffects) {
                this._deleteProgram(this._compiledEffects[name]._program);
            }
            this._compiledEffects = {};
        };
        // Dispose
        Engine.prototype.dispose = function () {
            this.hideLoadingUI();
            this.stopRenderLoop();
            // Release postProcesses
            while (this.postProcesses.length) {
                this.postProcesses[0].dispose();
            }
            // Empty texture
            if (this._emptyTexture) {
                this._releaseTexture(this._emptyTexture);
                this._emptyTexture = null;
            }
            if (this._emptyCubeTexture) {
                this._releaseTexture(this._emptyCubeTexture);
                this._emptyCubeTexture = null;
            }
            // Rescale PP
            if (this._rescalePostProcess) {
                this._rescalePostProcess.dispose();
            }
            // Release scenes
            while (this.scenes.length) {
                this.scenes[0].dispose();
            }
            // Release audio engine
            if (Engine.audioEngine) {
                Engine.audioEngine.dispose();
            }
            // Release effects
            this.releaseEffects();
            // Unbind
            this.unbindAllAttributes();
            if (this._dummyFramebuffer) {
                this._gl.deleteFramebuffer(this._dummyFramebuffer);
            }
            //WebVR
            this.disableVR();
            // Events
            if (BABYLON.Tools.IsWindowObjectExist()) {
                window.removeEventListener("blur", this._onBlur);
                window.removeEventListener("focus", this._onFocus);
                window.removeEventListener('vrdisplaypointerrestricted', this._onVRDisplayPointerRestricted);
                window.removeEventListener('vrdisplaypointerunrestricted', this._onVRDisplayPointerUnrestricted);
                if (this._renderingCanvas) {
                    this._renderingCanvas.removeEventListener("focus", this._onCanvasFocus);
                    this._renderingCanvas.removeEventListener("blur", this._onCanvasBlur);
                    this._renderingCanvas.removeEventListener("pointerout", this._onCanvasBlur);
                    if (!this._doNotHandleContextLost) {
                        this._renderingCanvas.removeEventListener("webglcontextlost", this._onContextLost);
                        this._renderingCanvas.removeEventListener("webglcontextrestored", this._onContextRestored);
                    }
                }
                document.removeEventListener("fullscreenchange", this._onFullscreenChange);
                document.removeEventListener("mozfullscreenchange", this._onFullscreenChange);
                document.removeEventListener("webkitfullscreenchange", this._onFullscreenChange);
                document.removeEventListener("msfullscreenchange", this._onFullscreenChange);
                document.removeEventListener("pointerlockchange", this._onPointerLockChange);
                document.removeEventListener("mspointerlockchange", this._onPointerLockChange);
                document.removeEventListener("mozpointerlockchange", this._onPointerLockChange);
                document.removeEventListener("webkitpointerlockchange", this._onPointerLockChange);
                if (this._onVrDisplayConnect) {
                    window.removeEventListener('vrdisplayconnect', this._onVrDisplayConnect);
                    if (this._onVrDisplayDisconnect) {
                        window.removeEventListener('vrdisplaydisconnect', this._onVrDisplayDisconnect);
                    }
                    if (this._onVrDisplayPresentChange) {
                        window.removeEventListener('vrdisplaypresentchange', this._onVrDisplayPresentChange);
                    }
                    this._onVrDisplayConnect = null;
                    this._onVrDisplayDisconnect = null;
                }
            }
            // Remove from Instances
            var index = Engine.Instances.indexOf(this);
            if (index >= 0) {
                Engine.Instances.splice(index, 1);
            }
            this._workingCanvas = null;
            this._workingContext = null;
            this._currentBufferPointers = [];
            this._renderingCanvas = null;
            this._currentProgram = null;
            this.onResizeObservable.clear();
            this.onCanvasBlurObservable.clear();
            this.onCanvasFocusObservable.clear();
            this.onCanvasPointerOutObservable.clear();
            this.onBeginFrameObservable.clear();
            this.onEndFrameObservable.clear();
            BABYLON.Effect.ResetCache();
        };
        // Loading screen
        Engine.prototype.displayLoadingUI = function () {
            if (!BABYLON.Tools.IsWindowObjectExist()) {
                return;
            }
            var loadingScreen = this.loadingScreen;
            if (loadingScreen) {
                loadingScreen.displayLoadingUI();
            }
        };
        Engine.prototype.hideLoadingUI = function () {
            if (!BABYLON.Tools.IsWindowObjectExist()) {
                return;
            }
            var loadingScreen = this.loadingScreen;
            if (loadingScreen) {
                loadingScreen.hideLoadingUI();
            }
        };
        Object.defineProperty(Engine.prototype, "loadingScreen", {
            get: function () {
                if (!this._loadingScreen && BABYLON.DefaultLoadingScreen && this._renderingCanvas)
                    this._loadingScreen = new BABYLON.DefaultLoadingScreen(this._renderingCanvas);
                return this._loadingScreen;
            },
            set: function (loadingScreen) {
                this._loadingScreen = loadingScreen;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine.prototype, "loadingUIText", {
            set: function (text) {
                this.loadingScreen.loadingUIText = text;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Engine.prototype, "loadingUIBackgroundColor", {
            set: function (color) {
                this.loadingScreen.loadingUIBackgroundColor = color;
            },
            enumerable: true,
            configurable: true
        });
        Engine.prototype.attachContextLostEvent = function (callback) {
            if (this._renderingCanvas) {
                this._renderingCanvas.addEventListener("webglcontextlost", callback, false);
            }
        };
        Engine.prototype.attachContextRestoredEvent = function (callback) {
            if (this._renderingCanvas) {
                this._renderingCanvas.addEventListener("webglcontextrestored", callback, false);
            }
        };
        Engine.prototype.getVertexShaderSource = function (program) {
            var shaders = this._gl.getAttachedShaders(program);
            if (!shaders) {
                return null;
            }
            return this._gl.getShaderSource(shaders[0]);
        };
        Engine.prototype.getFragmentShaderSource = function (program) {
            var shaders = this._gl.getAttachedShaders(program);
            if (!shaders) {
                return null;
            }
            return this._gl.getShaderSource(shaders[1]);
        };
        Engine.prototype.getError = function () {
            return this._gl.getError();
        };
        // FPS
        Engine.prototype.getFps = function () {
            return this._fps;
        };
        Engine.prototype.getDeltaTime = function () {
            return this._deltaTime;
        };
        Engine.prototype._measureFps = function () {
            this._performanceMonitor.sampleFrame();
            this._fps = this._performanceMonitor.averageFPS;
            this._deltaTime = this._performanceMonitor.instantaneousFrameTime || 0;
        };
        Engine.prototype._readTexturePixels = function (texture, width, height, faceIndex) {
            if (faceIndex === void 0) { faceIndex = -1; }
            var gl = this._gl;
            if (!this._dummyFramebuffer) {
                var dummy = gl.createFramebuffer();
                if (!dummy) {
                    throw new Error("Unable to create dummy framebuffer");
                }
                this._dummyFramebuffer = dummy;
            }
            gl.bindFramebuffer(gl.FRAMEBUFFER, this._dummyFramebuffer);
            if (faceIndex > -1) {
                gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.COLOR_ATTACHMENT0, gl.TEXTURE_CUBE_MAP_POSITIVE_X + faceIndex, texture._webGLTexture, 0);
            }
            else {
                gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.COLOR_ATTACHMENT0, gl.TEXTURE_2D, texture._webGLTexture, 0);
            }
            var readType = (texture.type !== undefined) ? this._getWebGLTextureType(texture.type) : gl.UNSIGNED_BYTE;
            var buffer;
            switch (readType) {
                case gl.UNSIGNED_BYTE:
                    buffer = new Uint8Array(4 * width * height);
                    readType = gl.UNSIGNED_BYTE;
                    break;
                default:
                    buffer = new Float32Array(4 * width * height);
                    readType = gl.FLOAT;
                    break;
            }
            gl.readPixels(0, 0, width, height, gl.RGBA, readType, buffer);
            gl.bindFramebuffer(gl.FRAMEBUFFER, this._currentFramebuffer);
            return buffer;
        };
        Engine.prototype._canRenderToFloatFramebuffer = function () {
            if (this._webGLVersion > 1) {
                return this._caps.colorBufferFloat;
            }
            return this._canRenderToFramebuffer(BABYLON.Engine.TEXTURETYPE_FLOAT);
        };
        Engine.prototype._canRenderToHalfFloatFramebuffer = function () {
            if (this._webGLVersion > 1) {
                return this._caps.colorBufferFloat;
            }
            return this._canRenderToFramebuffer(BABYLON.Engine.TEXTURETYPE_HALF_FLOAT);
        };
        // Thank you : http://stackoverflow.com/questions/28827511/webgl-ios-render-to-floating-point-texture
        Engine.prototype._canRenderToFramebuffer = function (type) {
            var gl = this._gl;
            //clear existing errors
            while (gl.getError() !== gl.NO_ERROR) { }
            var successful = true;
            var texture = gl.createTexture();
            gl.bindTexture(gl.TEXTURE_2D, texture);
            gl.texImage2D(gl.TEXTURE_2D, 0, this._getRGBABufferInternalSizedFormat(type), 1, 1, 0, gl.RGBA, this._getWebGLTextureType(type), null);
            gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.NEAREST);
            gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, gl.NEAREST);
            var fb = gl.createFramebuffer();
            gl.bindFramebuffer(gl.FRAMEBUFFER, fb);
            gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.COLOR_ATTACHMENT0, gl.TEXTURE_2D, texture, 0);
            var status = gl.checkFramebufferStatus(gl.FRAMEBUFFER);
            successful = successful && (status === gl.FRAMEBUFFER_COMPLETE);
            successful = successful && (gl.getError() === gl.NO_ERROR);
            //try render by clearing frame buffer's color buffer
            if (successful) {
                gl.clear(gl.COLOR_BUFFER_BIT);
                successful = successful && (gl.getError() === gl.NO_ERROR);
            }
            //try reading from frame to ensure render occurs (just creating the FBO is not sufficient to determine if rendering is supported)
            if (successful) {
                //in practice it's sufficient to just read from the backbuffer rather than handle potentially issues reading from the texture
                gl.bindFramebuffer(gl.FRAMEBUFFER, null);
                var readFormat = gl.RGBA;
                var readType = gl.UNSIGNED_BYTE;
                var buffer = new Uint8Array(4);
                gl.readPixels(0, 0, 1, 1, readFormat, readType, buffer);
                successful = successful && (gl.getError() === gl.NO_ERROR);
            }
            //clean up
            gl.deleteTexture(texture);
            gl.deleteFramebuffer(fb);
            gl.bindFramebuffer(gl.FRAMEBUFFER, null);
            //clear accumulated errors
            while (!successful && (gl.getError() !== gl.NO_ERROR)) { }
            return successful;
        };
        Engine.prototype._getWebGLTextureType = function (type) {
            if (type === Engine.TEXTURETYPE_FLOAT) {
                return this._gl.FLOAT;
            }
            else if (type === Engine.TEXTURETYPE_HALF_FLOAT) {
                // Add Half Float Constant.
                return this._gl.HALF_FLOAT_OES;
            }
            return this._gl.UNSIGNED_BYTE;
        };
        ;
        Engine.prototype._getRGBABufferInternalSizedFormat = function (type) {
            if (this._webGLVersion === 1) {
                return this._gl.RGBA;
            }
            if (type === Engine.TEXTURETYPE_FLOAT) {
                return this._gl.RGBA32F;
            }
            else if (type === Engine.TEXTURETYPE_HALF_FLOAT) {
                return this._gl.RGBA16F;
            }
            return this._gl.RGBA;
        };
        ;
        Engine.prototype.createQuery = function () {
            return this._gl.createQuery();
        };
        Engine.prototype.deleteQuery = function (query) {
            this._gl.deleteQuery(query);
            return this;
        };
        Engine.prototype.isQueryResultAvailable = function (query) {
            return this._gl.getQueryParameter(query, this._gl.QUERY_RESULT_AVAILABLE);
        };
        Engine.prototype.getQueryResult = function (query) {
            return this._gl.getQueryParameter(query, this._gl.QUERY_RESULT);
        };
        Engine.prototype.beginOcclusionQuery = function (algorithmType, query) {
            var glAlgorithm = this.getGlAlgorithmType(algorithmType);
            this._gl.beginQuery(glAlgorithm, query);
            return this;
        };
        Engine.prototype.endOcclusionQuery = function (algorithmType) {
            var glAlgorithm = this.getGlAlgorithmType(algorithmType);
            this._gl.endQuery(glAlgorithm);
            return this;
        };
        /* Time queries */
        Engine.prototype._createTimeQuery = function () {
            var timerQuery = this._caps.timerQuery;
            if (timerQuery.createQueryEXT) {
                return timerQuery.createQueryEXT();
            }
            return this.createQuery();
        };
        Engine.prototype._deleteTimeQuery = function (query) {
            var timerQuery = this._caps.timerQuery;
            if (timerQuery.deleteQueryEXT) {
                timerQuery.deleteQueryEXT(query);
                return;
            }
            this.deleteQuery(query);
        };
        Engine.prototype._getTimeQueryResult = function (query) {
            var timerQuery = this._caps.timerQuery;
            if (timerQuery.getQueryObjectEXT) {
                return timerQuery.getQueryObjectEXT(query, timerQuery.QUERY_RESULT_EXT);
            }
            return this.getQueryResult(query);
        };
        Engine.prototype._getTimeQueryAvailability = function (query) {
            var timerQuery = this._caps.timerQuery;
            if (timerQuery.getQueryObjectEXT) {
                return timerQuery.getQueryObjectEXT(query, timerQuery.QUERY_RESULT_AVAILABLE_EXT);
            }
            return this.isQueryResultAvailable(query);
        };
        Engine.prototype.startTimeQuery = function () {
            var timerQuery = this._caps.timerQuery;
            if (!timerQuery) {
                return null;
            }
            var token = new BABYLON._TimeToken();
            this._gl.getParameter(timerQuery.GPU_DISJOINT_EXT);
            if (this._caps.canUseTimestampForTimerQuery) {
                token._startTimeQuery = this._createTimeQuery();
                timerQuery.queryCounterEXT(token._startTimeQuery, timerQuery.TIMESTAMP_EXT);
            }
            else {
                if (this._currentNonTimestampToken) {
                    return this._currentNonTimestampToken;
                }
                token._timeElapsedQuery = this._createTimeQuery();
                if (timerQuery.beginQueryEXT) {
                    timerQuery.beginQueryEXT(timerQuery.TIME_ELAPSED_EXT, token._timeElapsedQuery);
                }
                else {
                    this._gl.beginQuery(timerQuery.TIME_ELAPSED_EXT, token._timeElapsedQuery);
                }
                this._currentNonTimestampToken = token;
            }
            return token;
        };
        Engine.prototype.endTimeQuery = function (token) {
            var timerQuery = this._caps.timerQuery;
            if (!timerQuery || !token) {
                return -1;
            }
            if (this._caps.canUseTimestampForTimerQuery) {
                if (!token._startTimeQuery) {
                    return -1;
                }
                if (!token._endTimeQuery) {
                    token._endTimeQuery = this._createTimeQuery();
                    timerQuery.queryCounterEXT(token._endTimeQuery, timerQuery.TIMESTAMP_EXT);
                }
            }
            else if (!token._timeElapsedQueryEnded) {
                if (!token._timeElapsedQuery) {
                    return -1;
                }
                if (timerQuery.endQueryEXT) {
                    timerQuery.endQueryEXT(timerQuery.TIME_ELAPSED_EXT);
                }
                else {
                    this._gl.endQuery(timerQuery.TIME_ELAPSED_EXT);
                }
                token._timeElapsedQueryEnded = true;
            }
            var disjoint = this._gl.getParameter(timerQuery.GPU_DISJOINT_EXT);
            var available = false;
            if (token._endTimeQuery) {
                available = this._getTimeQueryAvailability(token._endTimeQuery);
            }
            else if (token._timeElapsedQuery) {
                available = this._getTimeQueryAvailability(token._timeElapsedQuery);
            }
            if (available && !disjoint) {
                var result = 0;
                if (this._caps.canUseTimestampForTimerQuery) {
                    if (!token._startTimeQuery || !token._endTimeQuery) {
                        return -1;
                    }
                    var timeStart = this._getTimeQueryResult(token._startTimeQuery);
                    var timeEnd = this._getTimeQueryResult(token._endTimeQuery);
                    result = timeEnd - timeStart;
                    this._deleteTimeQuery(token._startTimeQuery);
                    this._deleteTimeQuery(token._endTimeQuery);
                    token._startTimeQuery = null;
                    token._endTimeQuery = null;
                }
                else {
                    if (!token._timeElapsedQuery) {
                        return -1;
                    }
                    result = this._getTimeQueryResult(token._timeElapsedQuery);
                    this._deleteTimeQuery(token._timeElapsedQuery);
                    token._timeElapsedQuery = null;
                    token._timeElapsedQueryEnded = false;
                    this._currentNonTimestampToken = null;
                }
                return result;
            }
            return -1;
        };
        Engine.prototype.getGlAlgorithmType = function (algorithmType) {
            return algorithmType === BABYLON.AbstractMesh.OCCLUSION_ALGORITHM_TYPE_CONSERVATIVE ? this._gl.ANY_SAMPLES_PASSED_CONSERVATIVE : this._gl.ANY_SAMPLES_PASSED;
        };
        // Transform feedback
        Engine.prototype.createTransformFeedback = function () {
            return this._gl.createTransformFeedback();
        };
        Engine.prototype.deleteTransformFeedback = function (value) {
            this._gl.deleteTransformFeedback(value);
        };
        Engine.prototype.bindTransformFeedback = function (value) {
            this._gl.bindTransformFeedback(this._gl.TRANSFORM_FEEDBACK, value);
        };
        Engine.prototype.beginTransformFeedback = function (usePoints) {
            if (usePoints === void 0) { usePoints = true; }
            this._gl.beginTransformFeedback(usePoints ? this._gl.POINTS : this._gl.TRIANGLES);
        };
        Engine.prototype.endTransformFeedback = function () {
            this._gl.endTransformFeedback();
        };
        Engine.prototype.setTranformFeedbackVaryings = function (program, value) {
            this._gl.transformFeedbackVaryings(program, value, this._gl.INTERLEAVED_ATTRIBS);
        };
        Engine.prototype.bindTransformFeedbackBuffer = function (value) {
            this._gl.bindBufferBase(this._gl.TRANSFORM_FEEDBACK_BUFFER, 0, value);
        };
        // Statics
        Engine.isSupported = function () {
            try {
                var tempcanvas = document.createElement("canvas");
                var gl = tempcanvas.getContext("webgl") || tempcanvas.getContext("experimental-webgl");
                return gl != null && !!window.WebGLRenderingContext;
            }
            catch (e) {
                return false;
            }
        };
        /** Use this array to turn off some WebGL2 features on known buggy browsers version */
        Engine.WebGL2UniformBuffersExceptionList = ["Chrome/63"];
        Engine.Instances = new Array();
        // Const statics
        Engine._ALPHA_DISABLE = 0;
        Engine._ALPHA_ADD = 1;
        Engine._ALPHA_COMBINE = 2;
        Engine._ALPHA_SUBTRACT = 3;
        Engine._ALPHA_MULTIPLY = 4;
        Engine._ALPHA_MAXIMIZED = 5;
        Engine._ALPHA_ONEONE = 6;
        Engine._ALPHA_PREMULTIPLIED = 7;
        Engine._ALPHA_PREMULTIPLIED_PORTERDUFF = 8;
        Engine._ALPHA_INTERPOLATE = 9;
        Engine._ALPHA_SCREENMODE = 10;
        Engine._DELAYLOADSTATE_NONE = 0;
        Engine._DELAYLOADSTATE_LOADED = 1;
        Engine._DELAYLOADSTATE_LOADING = 2;
        Engine._DELAYLOADSTATE_NOTLOADED = 4;
        Engine._TEXTUREFORMAT_ALPHA = 0;
        Engine._TEXTUREFORMAT_LUMINANCE = 1;
        Engine._TEXTUREFORMAT_LUMINANCE_ALPHA = 2;
        Engine._TEXTUREFORMAT_RGB = 4;
        Engine._TEXTUREFORMAT_RGBA = 5;
        Engine._TEXTURETYPE_UNSIGNED_INT = 0;
        Engine._TEXTURETYPE_FLOAT = 1;
        Engine._TEXTURETYPE_HALF_FLOAT = 2;
        // Depht or Stencil test Constants.
        Engine._NEVER = 0x0200; //    Passed to depthFunction or stencilFunction to specify depth or stencil tests will never pass. i.e. Nothing will be drawn.
        Engine._ALWAYS = 0x0207; //    Passed to depthFunction or stencilFunction to specify depth or stencil tests will always pass. i.e. Pixels will be drawn in the order they are drawn.
        Engine._LESS = 0x0201; //    Passed to depthFunction or stencilFunction to specify depth or stencil tests will pass if the new depth value is less than the stored value.
        Engine._EQUAL = 0x0202; //    Passed to depthFunction or stencilFunction to specify depth or stencil tests will pass if the new depth value is equals to the stored value.
        Engine._LEQUAL = 0x0203; //    Passed to depthFunction or stencilFunction to specify depth or stencil tests will pass if the new depth value is less than or equal to the stored value.
        Engine._GREATER = 0x0204; //    Passed to depthFunction or stencilFunction to specify depth or stencil tests will pass if the new depth value is greater than the stored value.
        Engine._GEQUAL = 0x0206; //    Passed to depthFunction or stencilFunction to specify depth or stencil tests will pass if the new depth value is greater than or equal to the stored value.
        Engine._NOTEQUAL = 0x0205; //  Passed to depthFunction or stencilFunction to specify depth or stencil tests will pass if the new depth value is not equal to the stored value.
        // Stencil Actions Constants.
        Engine._KEEP = 0x1E00;
        Engine._REPLACE = 0x1E01;
        Engine._INCR = 0x1E02;
        Engine._DECR = 0x1E03;
        Engine._INVERT = 0x150A;
        Engine._INCR_WRAP = 0x8507;
        Engine._DECR_WRAP = 0x8508;
        // Texture rescaling mode
        Engine._SCALEMODE_FLOOR = 1;
        Engine._SCALEMODE_NEAREST = 2;
        Engine._SCALEMODE_CEILING = 3;
        // Updatable statics so stick with vars here
        Engine.CollisionsEpsilon = 0.001;
        Engine.CodeRepository = "src/";
        Engine.ShadersRepository = "src/Shaders/";
        return Engine;
    }());
    BABYLON.Engine = Engine;
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.engine.js.map


var BABYLON;
(function (BABYLON) {
    /**
     * Node is the basic class for all scene objects (Mesh, Light Camera).
     */
    var Node = /** @class */ (function () {
        /**
         * @constructor
         * @param {string} name - the name and id to be given to this node
         * @param {BABYLON.Scene} the scene this node will be added to
         */
        function Node(name, scene) {
            if (scene === void 0) { scene = null; }
            this.state = "";
            this.metadata = null;
            this.doNotSerialize = false;
            this.animations = new Array();
            this._ranges = {};
            this._isEnabled = true;
            this._isReady = true;
            this._currentRenderId = -1;
            this._parentRenderId = -1;
            /**
            * An event triggered when the mesh is disposed.
            * @type {BABYLON.Observable}
            */
            this.onDisposeObservable = new BABYLON.Observable();
            // Behaviors
            this._behaviors = new Array();
            this.name = name;
            this.id = name;
            this._scene = (scene || BABYLON.Engine.LastCreatedScene);
            this.uniqueId = this._scene.getUniqueId();
            this._initCache();
        }
        Object.defineProperty(Node.prototype, "parent", {
            get: function () {
                return this._parentNode;
            },
            set: function (parent) {
                if (this._parentNode === parent) {
                    return;
                }
                if (this._parentNode) {
                    var index = this._parentNode._children.indexOf(this);
                    if (index !== -1) {
                        this._parentNode._children.splice(index, 1);
                    }
                }
                this._parentNode = parent;
                if (this._parentNode) {
                    if (!this._parentNode._children) {
                        this._parentNode._children = new Array();
                    }
                    this._parentNode._children.push(this);
                }
            },
            enumerable: true,
            configurable: true
        });
        Node.prototype.getClassName = function () {
            return "Node";
        };
        Object.defineProperty(Node.prototype, "onDispose", {
            set: function (callback) {
                if (this._onDisposeObserver) {
                    this.onDisposeObservable.remove(this._onDisposeObserver);
                }
                this._onDisposeObserver = this.onDisposeObservable.add(callback);
            },
            enumerable: true,
            configurable: true
        });
        Node.prototype.getScene = function () {
            return this._scene;
        };
        Node.prototype.getEngine = function () {
            return this._scene.getEngine();
        };
        Node.prototype.addBehavior = function (behavior) {
            var _this = this;
            var index = this._behaviors.indexOf(behavior);
            if (index !== -1) {
                return this;
            }
            behavior.init();
            if (this._scene.isLoading) {
                // We defer the attach when the scene will be loaded
                var observer = this._scene.onDataLoadedObservable.add(function () {
                    behavior.attach(_this);
                    setTimeout(function () {
                        // Need to use a timeout to avoid removing an observer while iterating the list of observers
                        _this._scene.onDataLoadedObservable.remove(observer);
                    }, 0);
                });
            }
            else {
                behavior.attach(this);
            }
            this._behaviors.push(behavior);
            return this;
        };
        Node.prototype.removeBehavior = function (behavior) {
            var index = this._behaviors.indexOf(behavior);
            if (index === -1) {
                return this;
            }
            this._behaviors[index].detach();
            this._behaviors.splice(index, 1);
            return this;
        };
        Object.defineProperty(Node.prototype, "behaviors", {
            get: function () {
                return this._behaviors;
            },
            enumerable: true,
            configurable: true
        });
        Node.prototype.getBehaviorByName = function (name) {
            for (var _i = 0, _a = this._behaviors; _i < _a.length; _i++) {
                var behavior = _a[_i];
                if (behavior.name === name) {
                    return behavior;
                }
            }
            return null;
        };
        // override it in derived class
        Node.prototype.getWorldMatrix = function () {
            return BABYLON.Matrix.Identity();
        };
        // override it in derived class if you add new variables to the cache
        // and call the parent class method
        Node.prototype._initCache = function () {
            this._cache = {};
            this._cache.parent = undefined;
        };
        Node.prototype.updateCache = function (force) {
            if (!force && this.isSynchronized())
                return;
            this._cache.parent = this.parent;
            this._updateCache();
        };
        // override it in derived class if you add new variables to the cache
        // and call the parent class method if !ignoreParentClass
        Node.prototype._updateCache = function (ignoreParentClass) {
        };
        // override it in derived class if you add new variables to the cache
        Node.prototype._isSynchronized = function () {
            return true;
        };
        Node.prototype._markSyncedWithParent = function () {
            if (this.parent) {
                this._parentRenderId = this.parent._currentRenderId;
            }
        };
        Node.prototype.isSynchronizedWithParent = function () {
            if (!this.parent) {
                return true;
            }
            if (this._parentRenderId !== this.parent._currentRenderId) {
                return false;
            }
            return this.parent.isSynchronized();
        };
        Node.prototype.isSynchronized = function (updateCache) {
            var check = this.hasNewParent();
            check = check || !this.isSynchronizedWithParent();
            check = check || !this._isSynchronized();
            if (updateCache)
                this.updateCache(true);
            return !check;
        };
        Node.prototype.hasNewParent = function (update) {
            if (this._cache.parent === this.parent)
                return false;
            if (update)
                this._cache.parent = this.parent;
            return true;
        };
        /**
         * Is this node ready to be used/rendered
         * @return {boolean} is it ready
         */
        Node.prototype.isReady = function () {
            return this._isReady;
        };
        /**
         * Is this node enabled.
         * If the node has a parent and is enabled, the parent will be inspected as well.
         * @return {boolean} whether this node (and its parent) is enabled.
         * @see setEnabled
         */
        Node.prototype.isEnabled = function () {
            if (!this._isEnabled) {
                return false;
            }
            if (this.parent) {
                return this.parent.isEnabled();
            }
            return true;
        };
        /**
         * Set the enabled state of this node.
         * @param {boolean} value - the new enabled state
         * @see isEnabled
         */
        Node.prototype.setEnabled = function (value) {
            this._isEnabled = value;
        };
        /**
         * Is this node a descendant of the given node.
         * The function will iterate up the hierarchy until the ancestor was found or no more parents defined.
         * @param {BABYLON.Node} ancestor - The parent node to inspect
         * @see parent
         */
        Node.prototype.isDescendantOf = function (ancestor) {
            if (this.parent) {
                if (this.parent === ancestor) {
                    return true;
                }
                return this.parent.isDescendantOf(ancestor);
            }
            return false;
        };
        /**
         * Evaluate the list of children and determine if they should be considered as descendants considering the given criterias
         * @param {BABYLON.Node[]} results the result array containing the nodes matching the given criterias
         * @param {boolean} directDescendantsOnly if true only direct descendants of 'this' will be considered, if false direct and also indirect (children of children, an so on in a recursive manner) descendants of 'this' will be considered.
         * @param predicate: an optional predicate that will be called on every evaluated children, the predicate must return true for a given child to be part of the result, otherwise it will be ignored.
         */
        Node.prototype._getDescendants = function (results, directDescendantsOnly, predicate) {
            if (directDescendantsOnly === void 0) { directDescendantsOnly = false; }
            if (!this._children) {
                return;
            }
            for (var index = 0; index < this._children.length; index++) {
                var item = this._children[index];
                if (!predicate || predicate(item)) {
                    results.push(item);
                }
                if (!directDescendantsOnly) {
                    item._getDescendants(results, false, predicate);
                }
            }
        };
        /**
         * Will return all nodes that have this node as ascendant.
         * @param {boolean} directDescendantsOnly if true only direct descendants of 'this' will be considered, if false direct and also indirect (children of children, an so on in a recursive manner) descendants of 'this' will be considered.
         * @param predicate: an optional predicate that will be called on every evaluated children, the predicate must return true for a given child to be part of the result, otherwise it will be ignored.
         * @return {BABYLON.Node[]} all children nodes of all types.
         */
        Node.prototype.getDescendants = function (directDescendantsOnly, predicate) {
            var results = new Array();
            this._getDescendants(results, directDescendantsOnly, predicate);
            return results;
        };
        /**
         * Get all child-meshes of this node.
         */
        Node.prototype.getChildMeshes = function (directDescendantsOnly, predicate) {
            var results = [];
            this._getDescendants(results, directDescendantsOnly, function (node) {
                return ((!predicate || predicate(node)) && (node instanceof BABYLON.AbstractMesh));
            });
            return results;
        };
        /**
         * Get all child-transformNodes of this node.
         */
        Node.prototype.getChildTransformNodes = function (directDescendantsOnly, predicate) {
            var results = [];
            this._getDescendants(results, directDescendantsOnly, function (node) {
                return ((!predicate || predicate(node)) && (node instanceof BABYLON.TransformNode));
            });
            return results;
        };
        /**
         * Get all direct children of this node.
        */
        Node.prototype.getChildren = function (predicate) {
            return this.getDescendants(true, predicate);
        };
        Node.prototype._setReady = function (state) {
            if (state === this._isReady) {
                return;
            }
            if (!state) {
                this._isReady = false;
                return;
            }
            this._isReady = true;
            if (this.onReady) {
                this.onReady(this);
            }
        };
        Node.prototype.getAnimationByName = function (name) {
            for (var i = 0; i < this.animations.length; i++) {
                var animation = this.animations[i];
                if (animation.name === name) {
                    return animation;
                }
            }
            return null;
        };
        Node.prototype.createAnimationRange = function (name, from, to) {
            // check name not already in use
            if (!this._ranges[name]) {
                this._ranges[name] = new BABYLON.AnimationRange(name, from, to);
                for (var i = 0, nAnimations = this.animations.length; i < nAnimations; i++) {
                    if (this.animations[i]) {
                        this.animations[i].createRange(name, from, to);
                    }
                }
            }
        };
        Node.prototype.deleteAnimationRange = function (name, deleteFrames) {
            if (deleteFrames === void 0) { deleteFrames = true; }
            for (var i = 0, nAnimations = this.animations.length; i < nAnimations; i++) {
                if (this.animations[i]) {
                    this.animations[i].deleteRange(name, deleteFrames);
                }
            }
            this._ranges[name] = null; // said much faster than 'delete this._range[name]' 
        };
        Node.prototype.getAnimationRange = function (name) {
            return this._ranges[name];
        };
        Node.prototype.beginAnimation = function (name, loop, speedRatio, onAnimationEnd) {
            var range = this.getAnimationRange(name);
            if (!range) {
                return;
            }
            this._scene.beginAnimation(this, range.from, range.to, loop, speedRatio, onAnimationEnd);
        };
        Node.prototype.serializeAnimationRanges = function () {
            var serializationRanges = [];
            for (var name in this._ranges) {
                var localRange = this._ranges[name];
                if (!localRange) {
                    continue;
                }
                var range = {};
                range.name = name;
                range.from = localRange.from;
                range.to = localRange.to;
                serializationRanges.push(range);
            }
            return serializationRanges;
        };
        // override it in derived class
        Node.prototype.computeWorldMatrix = function (force) {
            return BABYLON.Matrix.Identity();
        };
        Node.prototype.dispose = function () {
            this.parent = null;
            // Callback
            this.onDisposeObservable.notifyObservers(this);
            this.onDisposeObservable.clear();
            // Behaviors
            for (var _i = 0, _a = this._behaviors; _i < _a.length; _i++) {
                var behavior = _a[_i];
                behavior.detach();
            }
            this._behaviors = [];
        };
        Node.ParseAnimationRanges = function (node, parsedNode, scene) {
            if (parsedNode.ranges) {
                for (var index = 0; index < parsedNode.ranges.length; index++) {
                    var data = parsedNode.ranges[index];
                    node.createAnimationRange(data.name, data.from, data.to);
                }
            }
        };
        __decorate([
            BABYLON.serialize()
        ], Node.prototype, "name", void 0);
        __decorate([
            BABYLON.serialize()
        ], Node.prototype, "id", void 0);
        __decorate([
            BABYLON.serialize()
        ], Node.prototype, "uniqueId", void 0);
        __decorate([
            BABYLON.serialize()
        ], Node.prototype, "state", void 0);
        __decorate([
            BABYLON.serialize()
        ], Node.prototype, "metadata", void 0);
        return Node;
    }());
    BABYLON.Node = Node;
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.node.js.map

var BABYLON;
(function (BABYLON) {
    var BoundingSphere = /** @class */ (function () {
        function BoundingSphere(minimum, maximum) {
            this.minimum = minimum;
            this.maximum = maximum;
            this._tempRadiusVector = BABYLON.Vector3.Zero();
            var distance = BABYLON.Vector3.Distance(minimum, maximum);
            this.center = BABYLON.Vector3.Lerp(minimum, maximum, 0.5);
            this.radius = distance * 0.5;
            this.centerWorld = BABYLON.Vector3.Zero();
            this._update(BABYLON.Matrix.Identity());
        }
        // Methods
        BoundingSphere.prototype._update = function (world) {
            BABYLON.Vector3.TransformCoordinatesToRef(this.center, world, this.centerWorld);
            BABYLON.Vector3.TransformNormalFromFloatsToRef(1.0, 1.0, 1.0, world, this._tempRadiusVector);
            this.radiusWorld = Math.max(Math.abs(this._tempRadiusVector.x), Math.abs(this._tempRadiusVector.y), Math.abs(this._tempRadiusVector.z)) * this.radius;
        };
        BoundingSphere.prototype.isInFrustum = function (frustumPlanes) {
            for (var i = 0; i < 6; i++) {
                if (frustumPlanes[i].dotCoordinate(this.centerWorld) <= -this.radiusWorld)
                    return false;
            }
            return true;
        };
        BoundingSphere.prototype.intersectsPoint = function (point) {
            var x = this.centerWorld.x - point.x;
            var y = this.centerWorld.y - point.y;
            var z = this.centerWorld.z - point.z;
            var distance = Math.sqrt((x * x) + (y * y) + (z * z));
            if (Math.abs(this.radiusWorld - distance) < BABYLON.Epsilon)
                return false;
            return true;
        };
        // Statics
        BoundingSphere.Intersects = function (sphere0, sphere1) {
            var x = sphere0.centerWorld.x - sphere1.centerWorld.x;
            var y = sphere0.centerWorld.y - sphere1.centerWorld.y;
            var z = sphere0.centerWorld.z - sphere1.centerWorld.z;
            var distance = Math.sqrt((x * x) + (y * y) + (z * z));
            if (sphere0.radiusWorld + sphere1.radiusWorld < distance)
                return false;
            return true;
        };
        return BoundingSphere;
    }());
    BABYLON.BoundingSphere = BoundingSphere;
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.boundingSphere.js.map

var BABYLON;
(function (BABYLON) {
    var BoundingBox = /** @class */ (function () {
        function BoundingBox(minimum, maximum) {
            this.minimum = minimum;
            this.maximum = maximum;
            this.vectors = new Array();
            this.vectorsWorld = new Array();
            // Bounding vectors
            this.vectors.push(this.minimum.clone());
            this.vectors.push(this.maximum.clone());
            this.vectors.push(this.minimum.clone());
            this.vectors[2].x = this.maximum.x;
            this.vectors.push(this.minimum.clone());
            this.vectors[3].y = this.maximum.y;
            this.vectors.push(this.minimum.clone());
            this.vectors[4].z = this.maximum.z;
            this.vectors.push(this.maximum.clone());
            this.vectors[5].z = this.minimum.z;
            this.vectors.push(this.maximum.clone());
            this.vectors[6].x = this.minimum.x;
            this.vectors.push(this.maximum.clone());
            this.vectors[7].y = this.minimum.y;
            // OBB
            this.center = this.maximum.add(this.minimum).scale(0.5);
            this.extendSize = this.maximum.subtract(this.minimum).scale(0.5);
            this.directions = [BABYLON.Vector3.Zero(), BABYLON.Vector3.Zero(), BABYLON.Vector3.Zero()];
            // World
            for (var index = 0; index < this.vectors.length; index++) {
                this.vectorsWorld[index] = BABYLON.Vector3.Zero();
            }
            this.minimumWorld = BABYLON.Vector3.Zero();
            this.maximumWorld = BABYLON.Vector3.Zero();
            this.centerWorld = BABYLON.Vector3.Zero();
            this.extendSizeWorld = BABYLON.Vector3.Zero();
            this._update(BABYLON.Matrix.Identity());
        }
        // Methods
        BoundingBox.prototype.getWorldMatrix = function () {
            return this._worldMatrix;
        };
        BoundingBox.prototype.setWorldMatrix = function (matrix) {
            this._worldMatrix.copyFrom(matrix);
            return this;
        };
        BoundingBox.prototype._update = function (world) {
            BABYLON.Vector3.FromFloatsToRef(Number.MAX_VALUE, Number.MAX_VALUE, Number.MAX_VALUE, this.minimumWorld);
            BABYLON.Vector3.FromFloatsToRef(-Number.MAX_VALUE, -Number.MAX_VALUE, -Number.MAX_VALUE, this.maximumWorld);
            for (var index = 0; index < this.vectors.length; index++) {
                var v = this.vectorsWorld[index];
                BABYLON.Vector3.TransformCoordinatesToRef(this.vectors[index], world, v);
                if (v.x < this.minimumWorld.x)
                    this.minimumWorld.x = v.x;
                if (v.y < this.minimumWorld.y)
                    this.minimumWorld.y = v.y;
                if (v.z < this.minimumWorld.z)
                    this.minimumWorld.z = v.z;
                if (v.x > this.maximumWorld.x)
                    this.maximumWorld.x = v.x;
                if (v.y > this.maximumWorld.y)
                    this.maximumWorld.y = v.y;
                if (v.z > this.maximumWorld.z)
                    this.maximumWorld.z = v.z;
            }
            // Extend
            this.maximumWorld.subtractToRef(this.minimumWorld, this.extendSizeWorld);
            this.extendSizeWorld.scaleInPlace(0.5);
            // OBB
            this.maximumWorld.addToRef(this.minimumWorld, this.centerWorld);
            this.centerWorld.scaleInPlace(0.5);
            BABYLON.Vector3.FromFloatArrayToRef(world.m, 0, this.directions[0]);
            BABYLON.Vector3.FromFloatArrayToRef(world.m, 4, this.directions[1]);
            BABYLON.Vector3.FromFloatArrayToRef(world.m, 8, this.directions[2]);
            this._worldMatrix = world;
        };
        BoundingBox.prototype.isInFrustum = function (frustumPlanes) {
            return BoundingBox.IsInFrustum(this.vectorsWorld, frustumPlanes);
        };
        BoundingBox.prototype.isCompletelyInFrustum = function (frustumPlanes) {
            return BoundingBox.IsCompletelyInFrustum(this.vectorsWorld, frustumPlanes);
        };
        BoundingBox.prototype.intersectsPoint = function (point) {
            var delta = -BABYLON.Epsilon;
            if (this.maximumWorld.x - point.x < delta || delta > point.x - this.minimumWorld.x)
                return false;
            if (this.maximumWorld.y - point.y < delta || delta > point.y - this.minimumWorld.y)
                return false;
            if (this.maximumWorld.z - point.z < delta || delta > point.z - this.minimumWorld.z)
                return false;
            return true;
        };
        BoundingBox.prototype.intersectsSphere = function (sphere) {
            return BoundingBox.IntersectsSphere(this.minimumWorld, this.maximumWorld, sphere.centerWorld, sphere.radiusWorld);
        };
        BoundingBox.prototype.intersectsMinMax = function (min, max) {
            if (this.maximumWorld.x < min.x || this.minimumWorld.x > max.x)
                return false;
            if (this.maximumWorld.y < min.y || this.minimumWorld.y > max.y)
                return false;
            if (this.maximumWorld.z < min.z || this.minimumWorld.z > max.z)
                return false;
            return true;
        };
        // Statics
        BoundingBox.Intersects = function (box0, box1) {
            if (box0.maximumWorld.x < box1.minimumWorld.x || box0.minimumWorld.x > box1.maximumWorld.x)
                return false;
            if (box0.maximumWorld.y < box1.minimumWorld.y || box0.minimumWorld.y > box1.maximumWorld.y)
                return false;
            if (box0.maximumWorld.z < box1.minimumWorld.z || box0.minimumWorld.z > box1.maximumWorld.z)
                return false;
            return true;
        };
        BoundingBox.IntersectsSphere = function (minPoint, maxPoint, sphereCenter, sphereRadius) {
            var vector = BABYLON.Vector3.Clamp(sphereCenter, minPoint, maxPoint);
            var num = BABYLON.Vector3.DistanceSquared(sphereCenter, vector);
            return (num <= (sphereRadius * sphereRadius));
        };
        BoundingBox.IsCompletelyInFrustum = function (boundingVectors, frustumPlanes) {
            for (var p = 0; p < 6; p++) {
                for (var i = 0; i < 8; i++) {
                    if (frustumPlanes[p].dotCoordinate(boundingVectors[i]) < 0) {
                        return false;
                    }
                }
            }
            return true;
        };
        BoundingBox.IsInFrustum = function (boundingVectors, frustumPlanes) {
            for (var p = 0; p < 6; p++) {
                var inCount = 8;
                for (var i = 0; i < 8; i++) {
                    if (frustumPlanes[p].dotCoordinate(boundingVectors[i]) < 0) {
                        --inCount;
                    }
                    else {
                        break;
                    }
                }
                if (inCount === 0)
                    return false;
            }
            return true;
        };
        return BoundingBox;
    }());
    BABYLON.BoundingBox = BoundingBox;
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.boundingBox.js.map

var BABYLON;
(function (BABYLON) {
    var computeBoxExtents = function (axis, box) {
        var p = BABYLON.Vector3.Dot(box.centerWorld, axis);
        var r0 = Math.abs(BABYLON.Vector3.Dot(box.directions[0], axis)) * box.extendSize.x;
        var r1 = Math.abs(BABYLON.Vector3.Dot(box.directions[1], axis)) * box.extendSize.y;
        var r2 = Math.abs(BABYLON.Vector3.Dot(box.directions[2], axis)) * box.extendSize.z;
        var r = r0 + r1 + r2;
        return {
            min: p - r,
            max: p + r
        };
    };
    var extentsOverlap = function (min0, max0, min1, max1) { return !(min0 > max1 || min1 > max0); };
    var axisOverlap = function (axis, box0, box1) {
        var result0 = computeBoxExtents(axis, box0);
        var result1 = computeBoxExtents(axis, box1);
        return extentsOverlap(result0.min, result0.max, result1.min, result1.max);
    };
    var BoundingInfo = /** @class */ (function () {
        function BoundingInfo(minimum, maximum) {
            this.minimum = minimum;
            this.maximum = maximum;
            this._isLocked = false;
            this.boundingBox = new BABYLON.BoundingBox(minimum, maximum);
            this.boundingSphere = new BABYLON.BoundingSphere(minimum, maximum);
        }
        Object.defineProperty(BoundingInfo.prototype, "isLocked", {
            get: function () {
                return this._isLocked;
            },
            set: function (value) {
                this._isLocked = value;
            },
            enumerable: true,
            configurable: true
        });
        // Methods
        BoundingInfo.prototype.update = function (world) {
            if (this._isLocked) {
                return;
            }
            this.boundingBox._update(world);
            this.boundingSphere._update(world);
        };
        /**
         * Recreate the bounding info to be centered around a specific point given a specific extend.
         * @param center New center of the bounding info
         * @param extend New extend of the bounding info
         */
        BoundingInfo.prototype.centerOn = function (center, extend) {
            this.minimum = center.subtract(extend);
            this.maximum = center.add(extend);
            this.boundingBox = new BABYLON.BoundingBox(this.minimum, this.maximum);
            this.boundingSphere = new BABYLON.BoundingSphere(this.minimum, this.maximum);
            return this;
        };
        BoundingInfo.prototype.isInFrustum = function (frustumPlanes) {
            if (!this.boundingSphere.isInFrustum(frustumPlanes))
                return false;
            return this.boundingBox.isInFrustum(frustumPlanes);
        };
        Object.defineProperty(BoundingInfo.prototype, "diagonalLength", {
            /**
             * Gets the world distance between the min and max points of the bounding box
             */
            get: function () {
                var boundingBox = this.boundingBox;
                var size = boundingBox.maximumWorld.subtract(boundingBox.minimumWorld);
                return size.length();
            },
            enumerable: true,
            configurable: true
        });
        BoundingInfo.prototype.isCompletelyInFrustum = function (frustumPlanes) {
            return this.boundingBox.isCompletelyInFrustum(frustumPlanes);
        };
        BoundingInfo.prototype._checkCollision = function (collider) {
            return collider._canDoCollision(this.boundingSphere.centerWorld, this.boundingSphere.radiusWorld, this.boundingBox.minimumWorld, this.boundingBox.maximumWorld);
        };
        BoundingInfo.prototype.intersectsPoint = function (point) {
            if (!this.boundingSphere.centerWorld) {
                return false;
            }
            if (!this.boundingSphere.intersectsPoint(point)) {
                return false;
            }
            if (!this.boundingBox.intersectsPoint(point)) {
                return false;
            }
            return true;
        };
        BoundingInfo.prototype.intersects = function (boundingInfo, precise) {
            if (!this.boundingSphere.centerWorld || !boundingInfo.boundingSphere.centerWorld) {
                return false;
            }
            if (!BABYLON.BoundingSphere.Intersects(this.boundingSphere, boundingInfo.boundingSphere)) {
                return false;
            }
            if (!BABYLON.BoundingBox.Intersects(this.boundingBox, boundingInfo.boundingBox)) {
                return false;
            }
            if (!precise) {
                return true;
            }
            var box0 = this.boundingBox;
            var box1 = boundingInfo.boundingBox;
            if (!axisOverlap(box0.directions[0], box0, box1))
                return false;
            if (!axisOverlap(box0.directions[1], box0, box1))
                return false;
            if (!axisOverlap(box0.directions[2], box0, box1))
                return false;
            if (!axisOverlap(box1.directions[0], box0, box1))
                return false;
            if (!axisOverlap(box1.directions[1], box0, box1))
                return false;
            if (!axisOverlap(box1.directions[2], box0, box1))
                return false;
            if (!axisOverlap(BABYLON.Vector3.Cross(box0.directions[0], box1.directions[0]), box0, box1))
                return false;
            if (!axisOverlap(BABYLON.Vector3.Cross(box0.directions[0], box1.directions[1]), box0, box1))
                return false;
            if (!axisOverlap(BABYLON.Vector3.Cross(box0.directions[0], box1.directions[2]), box0, box1))
                return false;
            if (!axisOverlap(BABYLON.Vector3.Cross(box0.directions[1], box1.directions[0]), box0, box1))
                return false;
            if (!axisOverlap(BABYLON.Vector3.Cross(box0.directions[1], box1.directions[1]), box0, box1))
                return false;
            if (!axisOverlap(BABYLON.Vector3.Cross(box0.directions[1], box1.directions[2]), box0, box1))
                return false;
            if (!axisOverlap(BABYLON.Vector3.Cross(box0.directions[2], box1.directions[0]), box0, box1))
                return false;
            if (!axisOverlap(BABYLON.Vector3.Cross(box0.directions[2], box1.directions[1]), box0, box1))
                return false;
            if (!axisOverlap(BABYLON.Vector3.Cross(box0.directions[2], box1.directions[2]), box0, box1))
                return false;
            return true;
        };
        return BoundingInfo;
    }());
    BABYLON.BoundingInfo = BoundingInfo;
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.boundingInfo.js.map



var BABYLON;
(function (BABYLON) {
    var TransformNode = /** @class */ (function (_super) {
        __extends(TransformNode, _super);
        function TransformNode(name, scene, isPure) {
            if (scene === void 0) { scene = null; }
            if (isPure === void 0) { isPure = true; }
            var _this = _super.call(this, name, scene) || this;
            // Properties
            _this._rotation = BABYLON.Vector3.Zero();
            _this._scaling = BABYLON.Vector3.One();
            _this._isDirty = false;
            _this.billboardMode = BABYLON.AbstractMesh.BILLBOARDMODE_NONE;
            _this.scalingDeterminant = 1;
            _this.infiniteDistance = false;
            _this.position = BABYLON.Vector3.Zero();
            _this._localWorld = BABYLON.Matrix.Zero();
            _this._worldMatrix = BABYLON.Matrix.Zero();
            _this._absolutePosition = BABYLON.Vector3.Zero();
            _this._pivotMatrix = BABYLON.Matrix.Identity();
            _this._postMultiplyPivotMatrix = false;
            _this._isWorldMatrixFrozen = false;
            /**
            * An event triggered after the world matrix is updated
            * @type {BABYLON.Observable}
            */
            _this.onAfterWorldMatrixUpdateObservable = new BABYLON.Observable();
            _this._nonUniformScaling = false;
            if (isPure) {
                _this.getScene().addTransformNode(_this);
            }
            return _this;
        }
        Object.defineProperty(TransformNode.prototype, "rotation", {
            /**
              * Rotation property : a Vector3 depicting the rotation value in radians around each local axis X, Y, Z.
              * If rotation quaternion is set, this Vector3 will (almost always) be the Zero vector!
              * Default : (0.0, 0.0, 0.0)
              */
            get: function () {
                return this._rotation;
            },
            set: function (newRotation) {
                this._rotation = newRotation;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TransformNode.prototype, "scaling", {
            /**
             * Scaling property : a Vector3 depicting the mesh scaling along each local axis X, Y, Z.
             * Default : (1.0, 1.0, 1.0)
             */
            get: function () {
                return this._scaling;
            },
            /**
             * Scaling property : a Vector3 depicting the mesh scaling along each local axis X, Y, Z.
             * Default : (1.0, 1.0, 1.0)
            */
            set: function (newScaling) {
                this._scaling = newScaling;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TransformNode.prototype, "rotationQuaternion", {
            /**
             * Rotation Quaternion property : this a Quaternion object depicting the mesh rotation by using a unit quaternion.
             * It's null by default.
             * If set, only the rotationQuaternion is then used to compute the mesh rotation and its property `.rotation\ is then ignored and set to (0.0, 0.0, 0.0)
             */
            get: function () {
                return this._rotationQuaternion;
            },
            set: function (quaternion) {
                this._rotationQuaternion = quaternion;
                //reset the rotation vector. 
                if (quaternion && this.rotation.length()) {
                    this.rotation.copyFromFloats(0.0, 0.0, 0.0);
                }
            },
            enumerable: true,
            configurable: true
        });
        /**
         * Returns the latest update of the World matrix
         * Returns a Matrix.
         */
        TransformNode.prototype.getWorldMatrix = function () {
            if (this._currentRenderId !== this.getScene().getRenderId()) {
                this.computeWorldMatrix();
            }
            return this._worldMatrix;
        };
        Object.defineProperty(TransformNode.prototype, "worldMatrixFromCache", {
            /**
             * Returns directly the latest state of the mesh World matrix.
             * A Matrix is returned.
             */
            get: function () {
                return this._worldMatrix;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * Copies the paramater passed Matrix into the mesh Pose matrix.
         * Returns the AbstractMesh.
         */
        TransformNode.prototype.updatePoseMatrix = function (matrix) {
            this._poseMatrix.copyFrom(matrix);
            return this;
        };
        /**
         * Returns the mesh Pose matrix.
         * Returned object : Matrix
         */
        TransformNode.prototype.getPoseMatrix = function () {
            return this._poseMatrix;
        };
        TransformNode.prototype._isSynchronized = function () {
            if (this._isDirty) {
                return false;
            }
            if (this.billboardMode !== this._cache.billboardMode || this.billboardMode !== BABYLON.AbstractMesh.BILLBOARDMODE_NONE)
                return false;
            if (this._cache.pivotMatrixUpdated) {
                return false;
            }
            if (this.infiniteDistance) {
                return false;
            }
            if (!this._cache.position.equals(this.position))
                return false;
            if (this.rotationQuaternion) {
                if (!this._cache.rotationQuaternion.equals(this.rotationQuaternion))
                    return false;
            }
            if (!this._cache.rotation.equals(this.rotation))
                return false;
            if (!this._cache.scaling.equals(this.scaling))
                return false;
            return true;
        };
        TransformNode.prototype._initCache = function () {
            _super.prototype._initCache.call(this);
            this._cache.localMatrixUpdated = false;
            this._cache.position = BABYLON.Vector3.Zero();
            this._cache.scaling = BABYLON.Vector3.Zero();
            this._cache.rotation = BABYLON.Vector3.Zero();
            this._cache.rotationQuaternion = new BABYLON.Quaternion(0, 0, 0, 0);
            this._cache.billboardMode = -1;
        };
        TransformNode.prototype.markAsDirty = function (property) {
            if (property === "rotation") {
                this.rotationQuaternion = null;
            }
            this._currentRenderId = Number.MAX_VALUE;
            this._isDirty = true;
            return this;
        };
        Object.defineProperty(TransformNode.prototype, "absolutePosition", {
            /**
             * Returns the current mesh absolute position.
             * Retuns a Vector3.
             */
            get: function () {
                return this._absolutePosition;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * Sets a new pivot matrix to the mesh.
         * Returns the AbstractMesh.
        */
        TransformNode.prototype.setPivotMatrix = function (matrix, postMultiplyPivotMatrix) {
            if (postMultiplyPivotMatrix === void 0) { postMultiplyPivotMatrix = false; }
            this._pivotMatrix = matrix.clone();
            this._cache.pivotMatrixUpdated = true;
            this._postMultiplyPivotMatrix = postMultiplyPivotMatrix;
            if (this._postMultiplyPivotMatrix) {
                this._pivotMatrixInverse = BABYLON.Matrix.Invert(matrix);
            }
            return this;
        };
        /**
         * Returns the mesh pivot matrix.
         * Default : Identity.
         * A Matrix is returned.
         */
        TransformNode.prototype.getPivotMatrix = function () {
            return this._pivotMatrix;
        };
        /**
         * Prevents the World matrix to be computed any longer.
         * Returns the AbstractMesh.
         */
        TransformNode.prototype.freezeWorldMatrix = function () {
            this._isWorldMatrixFrozen = false; // no guarantee world is not already frozen, switch off temporarily
            this.computeWorldMatrix(true);
            this._isWorldMatrixFrozen = true;
            return this;
        };
        /**
         * Allows back the World matrix computation.
         * Returns the AbstractMesh.
         */
        TransformNode.prototype.unfreezeWorldMatrix = function () {
            this._isWorldMatrixFrozen = false;
            this.computeWorldMatrix(true);
            return this;
        };
        Object.defineProperty(TransformNode.prototype, "isWorldMatrixFrozen", {
            /**
             * True if the World matrix has been frozen.
             * Returns a boolean.
             */
            get: function () {
                return this._isWorldMatrixFrozen;
            },
            enumerable: true,
            configurable: true
        });
        /**
            * Retuns the mesh absolute position in the World.
            * Returns a Vector3.
            */
        TransformNode.prototype.getAbsolutePosition = function () {
            this.computeWorldMatrix();
            return this._absolutePosition;
        };
        /**
         * Sets the mesh absolute position in the World from a Vector3 or an Array(3).
         * Returns the AbstractMesh.
         */
        TransformNode.prototype.setAbsolutePosition = function (absolutePosition) {
            if (!absolutePosition) {
                return this;
            }
            var absolutePositionX;
            var absolutePositionY;
            var absolutePositionZ;
            if (absolutePosition.x === undefined) {
                if (arguments.length < 3) {
                    return this;
                }
                absolutePositionX = arguments[0];
                absolutePositionY = arguments[1];
                absolutePositionZ = arguments[2];
            }
            else {
                absolutePositionX = absolutePosition.x;
                absolutePositionY = absolutePosition.y;
                absolutePositionZ = absolutePosition.z;
            }
            if (this.parent) {
                var invertParentWorldMatrix = this.parent.getWorldMatrix().clone();
                invertParentWorldMatrix.invert();
                var worldPosition = new BABYLON.Vector3(absolutePositionX, absolutePositionY, absolutePositionZ);
                this.position = BABYLON.Vector3.TransformCoordinates(worldPosition, invertParentWorldMatrix);
            }
            else {
                this.position.x = absolutePositionX;
                this.position.y = absolutePositionY;
                this.position.z = absolutePositionZ;
            }
            return this;
        };
        /**
           * Sets the mesh position in its local space.
           * Returns the AbstractMesh.
           */
        TransformNode.prototype.setPositionWithLocalVector = function (vector3) {
            this.computeWorldMatrix();
            this.position = BABYLON.Vector3.TransformNormal(vector3, this._localWorld);
            return this;
        };
        /**
         * Returns the mesh position in the local space from the current World matrix values.
         * Returns a new Vector3.
         */
        TransformNode.prototype.getPositionExpressedInLocalSpace = function () {
            this.computeWorldMatrix();
            var invLocalWorldMatrix = this._localWorld.clone();
            invLocalWorldMatrix.invert();
            return BABYLON.Vector3.TransformNormal(this.position, invLocalWorldMatrix);
        };
        /**
         * Translates the mesh along the passed Vector3 in its local space.
         * Returns the AbstractMesh.
         */
        TransformNode.prototype.locallyTranslate = function (vector3) {
            this.computeWorldMatrix(true);
            this.position = BABYLON.Vector3.TransformCoordinates(vector3, this._localWorld);
            return this;
        };
        /**
         * Orients a mesh towards a target point. Mesh must be drawn facing user.
         * @param targetPoint the position (must be in same space as current mesh) to look at
         * @param yawCor optional yaw (y-axis) correction in radians
         * @param pitchCor optional pitch (x-axis) correction in radians
         * @param rollCor optional roll (z-axis) correction in radians
         * @param space the choosen space of the target
         * @returns the TransformNode.
         */
        TransformNode.prototype.lookAt = function (targetPoint, yawCor, pitchCor, rollCor, space) {
            if (yawCor === void 0) { yawCor = 0; }
            if (pitchCor === void 0) { pitchCor = 0; }
            if (rollCor === void 0) { rollCor = 0; }
            if (space === void 0) { space = BABYLON.Space.LOCAL; }
            var dv = BABYLON.AbstractMesh._lookAtVectorCache;
            var pos = space === BABYLON.Space.LOCAL ? this.position : this.getAbsolutePosition();
            targetPoint.subtractToRef(pos, dv);
            var yaw = -Math.atan2(dv.z, dv.x) - Math.PI / 2;
            var len = Math.sqrt(dv.x * dv.x + dv.z * dv.z);
            var pitch = Math.atan2(dv.y, len);
            if (this.rotationQuaternion) {
                BABYLON.Quaternion.RotationYawPitchRollToRef(yaw + yawCor, pitch + pitchCor, rollCor, this.rotationQuaternion);
            }
            else {
                this.rotation.x = pitch + pitchCor;
                this.rotation.y = yaw + yawCor;
                this.rotation.z = rollCor;
            }
            return this;
        };
        /**
          * Returns a new Vector3 what is the localAxis, expressed in the mesh local space, rotated like the mesh.
          * This Vector3 is expressed in the World space.
          */
        TransformNode.prototype.getDirection = function (localAxis) {
            var result = BABYLON.Vector3.Zero();
            this.getDirectionToRef(localAxis, result);
            return result;
        };
        /**
         * Sets the Vector3 "result" as the rotated Vector3 "localAxis" in the same rotation than the mesh.
         * localAxis is expressed in the mesh local space.
         * result is computed in the Wordl space from the mesh World matrix.
         * Returns the AbstractMesh.
         */
        TransformNode.prototype.getDirectionToRef = function (localAxis, result) {
            BABYLON.Vector3.TransformNormalToRef(localAxis, this.getWorldMatrix(), result);
            return this;
        };
        TransformNode.prototype.setPivotPoint = function (point, space) {
            if (space === void 0) { space = BABYLON.Space.LOCAL; }
            if (this.getScene().getRenderId() == 0) {
                this.computeWorldMatrix(true);
            }
            var wm = this.getWorldMatrix();
            if (space == BABYLON.Space.WORLD) {
                var tmat = BABYLON.Tmp.Matrix[0];
                wm.invertToRef(tmat);
                point = BABYLON.Vector3.TransformCoordinates(point, tmat);
            }
            BABYLON.Vector3.TransformCoordinatesToRef(point, wm, this.position);
            this._pivotMatrix.m[12] = -point.x;
            this._pivotMatrix.m[13] = -point.y;
            this._pivotMatrix.m[14] = -point.z;
            this._cache.pivotMatrixUpdated = true;
            return this;
        };
        /**
         * Returns a new Vector3 set with the mesh pivot point coordinates in the local space.
         */
        TransformNode.prototype.getPivotPoint = function () {
            var point = BABYLON.Vector3.Zero();
            this.getPivotPointToRef(point);
            return point;
        };
        /**
         * Sets the passed Vector3 "result" with the coordinates of the mesh pivot point in the local space.
         * Returns the AbstractMesh.
         */
        TransformNode.prototype.getPivotPointToRef = function (result) {
            result.x = -this._pivotMatrix.m[12];
            result.y = -this._pivotMatrix.m[13];
            result.z = -this._pivotMatrix.m[14];
            return this;
        };
        /**
         * Returns a new Vector3 set with the mesh pivot point World coordinates.
         */
        TransformNode.prototype.getAbsolutePivotPoint = function () {
            var point = BABYLON.Vector3.Zero();
            this.getAbsolutePivotPointToRef(point);
            return point;
        };
        /**
         * Sets the Vector3 "result" coordinates with the mesh pivot point World coordinates.
         * Returns the AbstractMesh.
         */
        TransformNode.prototype.getAbsolutePivotPointToRef = function (result) {
            result.x = this._pivotMatrix.m[12];
            result.y = this._pivotMatrix.m[13];
            result.z = this._pivotMatrix.m[14];
            this.getPivotPointToRef(result);
            BABYLON.Vector3.TransformCoordinatesToRef(result, this.getWorldMatrix(), result);
            return this;
        };
        /**
         * Defines the passed node as the parent of the current node.
         * The node will remain exactly where it is and its position / rotation will be updated accordingly
         * Returns the TransformNode.
         */
        TransformNode.prototype.setParent = function (node) {
            if (node == null) {
                var rotation = BABYLON.Tmp.Quaternion[0];
                var position = BABYLON.Tmp.Vector3[0];
                var scale = BABYLON.Tmp.Vector3[1];
                if (this.parent && this.parent.computeWorldMatrix) {
                    this.parent.computeWorldMatrix(true);
                }
                this.computeWorldMatrix(true);
                this.getWorldMatrix().decompose(scale, rotation, position);
                if (this.rotationQuaternion) {
                    this.rotationQuaternion.copyFrom(rotation);
                }
                else {
                    rotation.toEulerAnglesToRef(this.rotation);
                }
                this.scaling.x = scale.x;
                this.scaling.y = scale.y;
                this.scaling.z = scale.z;
                this.position.x = position.x;
                this.position.y = position.y;
                this.position.z = position.z;
            }
            else {
                var rotation = BABYLON.Tmp.Quaternion[0];
                var position = BABYLON.Tmp.Vector3[0];
                var scale = BABYLON.Tmp.Vector3[1];
                var diffMatrix = BABYLON.Tmp.Matrix[0];
                var invParentMatrix = BABYLON.Tmp.Matrix[1];
                this.computeWorldMatrix(true);
                node.computeWorldMatrix(true);
                node.getWorldMatrix().invertToRef(invParentMatrix);
                this.getWorldMatrix().multiplyToRef(invParentMatrix, diffMatrix);
                diffMatrix.decompose(scale, rotation, position);
                if (this.rotationQuaternion) {
                    this.rotationQuaternion.copyFrom(rotation);
                }
                else {
                    rotation.toEulerAnglesToRef(this.rotation);
                }
                this.position.x = position.x;
                this.position.y = position.y;
                this.position.z = position.z;
                this.scaling.x = scale.x;
                this.scaling.y = scale.y;
                this.scaling.z = scale.z;
            }
            this.parent = node;
            return this;
        };
        Object.defineProperty(TransformNode.prototype, "nonUniformScaling", {
            get: function () {
                return this._nonUniformScaling;
            },
            enumerable: true,
            configurable: true
        });
        TransformNode.prototype._updateNonUniformScalingState = function (value) {
            if (this._nonUniformScaling === value) {
                return false;
            }
            this._nonUniformScaling = true;
            return true;
        };
        /**
         * Attach the current TransformNode to another TransformNode associated with a bone
         * @param bone Bone affecting the TransformNode
         * @param affectedTransformNode TransformNode associated with the bone
         */
        TransformNode.prototype.attachToBone = function (bone, affectedTransformNode) {
            this._transformToBoneReferal = affectedTransformNode;
            this.parent = bone;
            if (bone.getWorldMatrix().determinant() < 0) {
                this.scalingDeterminant *= -1;
            }
            return this;
        };
        TransformNode.prototype.detachFromBone = function () {
            if (!this.parent) {
                return this;
            }
            if (this.parent.getWorldMatrix().determinant() < 0) {
                this.scalingDeterminant *= -1;
            }
            this._transformToBoneReferal = null;
            this.parent = null;
            return this;
        };
        /**
         * Rotates the mesh around the axis vector for the passed angle (amount) expressed in radians, in the given space.
         * space (default LOCAL) can be either BABYLON.Space.LOCAL, either BABYLON.Space.WORLD.
         * Note that the property `rotationQuaternion` is then automatically updated and the property `rotation` is set to (0,0,0) and no longer used.
         * The passed axis is also normalized.
         * Returns the AbstractMesh.
         */
        TransformNode.prototype.rotate = function (axis, amount, space) {
            axis.normalize();
            if (!this.rotationQuaternion) {
                this.rotationQuaternion = BABYLON.Quaternion.RotationYawPitchRoll(this.rotation.y, this.rotation.x, this.rotation.z);
                this.rotation = BABYLON.Vector3.Zero();
            }
            var rotationQuaternion;
            if (!space || space === BABYLON.Space.LOCAL) {
                rotationQuaternion = BABYLON.Quaternion.RotationAxisToRef(axis, amount, BABYLON.AbstractMesh._rotationAxisCache);
                this.rotationQuaternion.multiplyToRef(rotationQuaternion, this.rotationQuaternion);
            }
            else {
                if (this.parent) {
                    var invertParentWorldMatrix = this.parent.getWorldMatrix().clone();
                    invertParentWorldMatrix.invert();
                    axis = BABYLON.Vector3.TransformNormal(axis, invertParentWorldMatrix);
                }
                rotationQuaternion = BABYLON.Quaternion.RotationAxisToRef(axis, amount, BABYLON.AbstractMesh._rotationAxisCache);
                rotationQuaternion.multiplyToRef(this.rotationQuaternion, this.rotationQuaternion);
            }
            return this;
        };
        /**
         * Rotates the mesh around the axis vector for the passed angle (amount) expressed in radians, in world space.
         * Note that the property `rotationQuaternion` is then automatically updated and the property `rotation` is set to (0,0,0) and no longer used.
         * The passed axis is also normalized.
         * Returns the AbstractMesh.
         * Method is based on http://www.euclideanspace.com/maths/geometry/affine/aroundPoint/index.htm
         */
        TransformNode.prototype.rotateAround = function (point, axis, amount) {
            axis.normalize();
            if (!this.rotationQuaternion) {
                this.rotationQuaternion = BABYLON.Quaternion.RotationYawPitchRoll(this.rotation.y, this.rotation.x, this.rotation.z);
                this.rotation.copyFromFloats(0, 0, 0);
            }
            point.subtractToRef(this.position, BABYLON.Tmp.Vector3[0]);
            BABYLON.Matrix.TranslationToRef(BABYLON.Tmp.Vector3[0].x, BABYLON.Tmp.Vector3[0].y, BABYLON.Tmp.Vector3[0].z, BABYLON.Tmp.Matrix[0]);
            BABYLON.Tmp.Matrix[0].invertToRef(BABYLON.Tmp.Matrix[2]);
            BABYLON.Matrix.RotationAxisToRef(axis, amount, BABYLON.Tmp.Matrix[1]);
            BABYLON.Tmp.Matrix[2].multiplyToRef(BABYLON.Tmp.Matrix[1], BABYLON.Tmp.Matrix[2]);
            BABYLON.Tmp.Matrix[2].multiplyToRef(BABYLON.Tmp.Matrix[0], BABYLON.Tmp.Matrix[2]);
            BABYLON.Tmp.Matrix[2].decompose(BABYLON.Tmp.Vector3[0], BABYLON.Tmp.Quaternion[0], BABYLON.Tmp.Vector3[1]);
            this.position.addInPlace(BABYLON.Tmp.Vector3[1]);
            BABYLON.Tmp.Quaternion[0].multiplyToRef(this.rotationQuaternion, this.rotationQuaternion);
            return this;
        };
        /**
         * Translates the mesh along the axis vector for the passed distance in the given space.
         * space (default LOCAL) can be either BABYLON.Space.LOCAL, either BABYLON.Space.WORLD.
         * Returns the AbstractMesh.
         */
        TransformNode.prototype.translate = function (axis, distance, space) {
            var displacementVector = axis.scale(distance);
            if (!space || space === BABYLON.Space.LOCAL) {
                var tempV3 = this.getPositionExpressedInLocalSpace().add(displacementVector);
                this.setPositionWithLocalVector(tempV3);
            }
            else {
                this.setAbsolutePosition(this.getAbsolutePosition().add(displacementVector));
            }
            return this;
        };
        /**
         * Adds a rotation step to the mesh current rotation.
         * x, y, z are Euler angles expressed in radians.
         * This methods updates the current mesh rotation, either mesh.rotation, either mesh.rotationQuaternion if it's set.
         * This means this rotation is made in the mesh local space only.
         * It's useful to set a custom rotation order different from the BJS standard one YXZ.
         * Example : this rotates the mesh first around its local X axis, then around its local Z axis, finally around its local Y axis.
         * ```javascript
         * mesh.addRotation(x1, 0, 0).addRotation(0, 0, z2).addRotation(0, 0, y3);
         * ```
         * Note that `addRotation()` accumulates the passed rotation values to the current ones and computes the .rotation or .rotationQuaternion updated values.
         * Under the hood, only quaternions are used. So it's a little faster is you use .rotationQuaternion because it doesn't need to translate them back to Euler angles.
         * Returns the AbstractMesh.
         */
        TransformNode.prototype.addRotation = function (x, y, z) {
            var rotationQuaternion;
            if (this.rotationQuaternion) {
                rotationQuaternion = this.rotationQuaternion;
            }
            else {
                rotationQuaternion = BABYLON.Tmp.Quaternion[1];
                BABYLON.Quaternion.RotationYawPitchRollToRef(this.rotation.y, this.rotation.x, this.rotation.z, rotationQuaternion);
            }
            var accumulation = BABYLON.Tmp.Quaternion[0];
            BABYLON.Quaternion.RotationYawPitchRollToRef(y, x, z, accumulation);
            rotationQuaternion.multiplyInPlace(accumulation);
            if (!this.rotationQuaternion) {
                rotationQuaternion.toEulerAnglesToRef(this.rotation);
            }
            return this;
        };
        /**
         * Computes the mesh World matrix and returns it.
         * If the mesh world matrix is frozen, this computation does nothing more than returning the last frozen values.
         * If the parameter `force` is let to `false` (default), the current cached World matrix is returned.
         * If the parameter `force`is set to `true`, the actual computation is done.
         * Returns the mesh World Matrix.
         */
        TransformNode.prototype.computeWorldMatrix = function (force) {
            if (this._isWorldMatrixFrozen) {
                return this._worldMatrix;
            }
            if (!force && this.isSynchronized(true)) {
                return this._worldMatrix;
            }
            this._cache.position.copyFrom(this.position);
            this._cache.scaling.copyFrom(this.scaling);
            this._cache.pivotMatrixUpdated = false;
            this._cache.billboardMode = this.billboardMode;
            this._currentRenderId = this.getScene().getRenderId();
            this._isDirty = false;
            // Scaling
            BABYLON.Matrix.ScalingToRef(this.scaling.x * this.scalingDeterminant, this.scaling.y * this.scalingDeterminant, this.scaling.z * this.scalingDeterminant, BABYLON.Tmp.Matrix[1]);
            // Rotation
            //rotate, if quaternion is set and rotation was used
            if (this.rotationQuaternion) {
                var len = this.rotation.length();
                if (len) {
                    this.rotationQuaternion.multiplyInPlace(BABYLON.Quaternion.RotationYawPitchRoll(this.rotation.y, this.rotation.x, this.rotation.z));
                    this.rotation.copyFromFloats(0, 0, 0);
                }
            }
            if (this.rotationQuaternion) {
                this.rotationQuaternion.toRotationMatrix(BABYLON.Tmp.Matrix[0]);
                this._cache.rotationQuaternion.copyFrom(this.rotationQuaternion);
            }
            else {
                BABYLON.Matrix.RotationYawPitchRollToRef(this.rotation.y, this.rotation.x, this.rotation.z, BABYLON.Tmp.Matrix[0]);
                this._cache.rotation.copyFrom(this.rotation);
            }
            // Translation
            var camera = this.getScene().activeCamera;
            if (this.infiniteDistance && !this.parent && camera) {
                var cameraWorldMatrix = camera.getWorldMatrix();
                var cameraGlobalPosition = new BABYLON.Vector3(cameraWorldMatrix.m[12], cameraWorldMatrix.m[13], cameraWorldMatrix.m[14]);
                BABYLON.Matrix.TranslationToRef(this.position.x + cameraGlobalPosition.x, this.position.y + cameraGlobalPosition.y, this.position.z + cameraGlobalPosition.z, BABYLON.Tmp.Matrix[2]);
            }
            else {
                BABYLON.Matrix.TranslationToRef(this.position.x, this.position.y, this.position.z, BABYLON.Tmp.Matrix[2]);
            }
            // Composing transformations
            this._pivotMatrix.multiplyToRef(BABYLON.Tmp.Matrix[1], BABYLON.Tmp.Matrix[4]);
            BABYLON.Tmp.Matrix[4].multiplyToRef(BABYLON.Tmp.Matrix[0], BABYLON.Tmp.Matrix[5]);
            // Billboarding (testing PG:http://www.babylonjs-playground.com/#UJEIL#13)
            if (this.billboardMode !== BABYLON.AbstractMesh.BILLBOARDMODE_NONE && camera) {
                if ((this.billboardMode & BABYLON.AbstractMesh.BILLBOARDMODE_ALL) !== BABYLON.AbstractMesh.BILLBOARDMODE_ALL) {
                    // Need to decompose each rotation here
                    var currentPosition = BABYLON.Tmp.Vector3[3];
                    if (this.parent && this.parent.getWorldMatrix) {
                        if (this._transformToBoneReferal) {
                            this.parent.getWorldMatrix().multiplyToRef(this._transformToBoneReferal.getWorldMatrix(), BABYLON.Tmp.Matrix[6]);
                            BABYLON.Vector3.TransformCoordinatesToRef(this.position, BABYLON.Tmp.Matrix[6], currentPosition);
                        }
                        else {
                            BABYLON.Vector3.TransformCoordinatesToRef(this.position, this.parent.getWorldMatrix(), currentPosition);
                        }
                    }
                    else {
                        currentPosition.copyFrom(this.position);
                    }
                    currentPosition.subtractInPlace(camera.globalPosition);
                    var finalEuler = BABYLON.Tmp.Vector3[4].copyFromFloats(0, 0, 0);
                    if ((this.billboardMode & BABYLON.AbstractMesh.BILLBOARDMODE_X) === BABYLON.AbstractMesh.BILLBOARDMODE_X) {
                        finalEuler.x = Math.atan2(-currentPosition.y, currentPosition.z);
                    }
                    if ((this.billboardMode & BABYLON.AbstractMesh.BILLBOARDMODE_Y) === BABYLON.AbstractMesh.BILLBOARDMODE_Y) {
                        finalEuler.y = Math.atan2(currentPosition.x, currentPosition.z);
                    }
                    if ((this.billboardMode & BABYLON.AbstractMesh.BILLBOARDMODE_Z) === BABYLON.AbstractMesh.BILLBOARDMODE_Z) {
                        finalEuler.z = Math.atan2(currentPosition.y, currentPosition.x);
                    }
                    BABYLON.Matrix.RotationYawPitchRollToRef(finalEuler.y, finalEuler.x, finalEuler.z, BABYLON.Tmp.Matrix[0]);
                }
                else {
                    BABYLON.Tmp.Matrix[1].copyFrom(camera.getViewMatrix());
                    BABYLON.Tmp.Matrix[1].setTranslationFromFloats(0, 0, 0);
                    BABYLON.Tmp.Matrix[1].invertToRef(BABYLON.Tmp.Matrix[0]);
                }
                BABYLON.Tmp.Matrix[1].copyFrom(BABYLON.Tmp.Matrix[5]);
                BABYLON.Tmp.Matrix[1].multiplyToRef(BABYLON.Tmp.Matrix[0], BABYLON.Tmp.Matrix[5]);
            }
            // Local world
            BABYLON.Tmp.Matrix[5].multiplyToRef(BABYLON.Tmp.Matrix[2], this._localWorld);
            // Parent
            if (this.parent && this.parent.getWorldMatrix) {
                if (this.billboardMode !== BABYLON.AbstractMesh.BILLBOARDMODE_NONE) {
                    if (this._transformToBoneReferal) {
                        this.parent.getWorldMatrix().multiplyToRef(this._transformToBoneReferal.getWorldMatrix(), BABYLON.Tmp.Matrix[6]);
                        BABYLON.Tmp.Matrix[5].copyFrom(BABYLON.Tmp.Matrix[6]);
                    }
                    else {
                        BABYLON.Tmp.Matrix[5].copyFrom(this.parent.getWorldMatrix());
                    }
                    this._localWorld.getTranslationToRef(BABYLON.Tmp.Vector3[5]);
                    BABYLON.Vector3.TransformCoordinatesToRef(BABYLON.Tmp.Vector3[5], BABYLON.Tmp.Matrix[5], BABYLON.Tmp.Vector3[5]);
                    this._worldMatrix.copyFrom(this._localWorld);
                    this._worldMatrix.setTranslation(BABYLON.Tmp.Vector3[5]);
                }
                else {
                    if (this._transformToBoneReferal) {
                        this._localWorld.multiplyToRef(this.parent.getWorldMatrix(), BABYLON.Tmp.Matrix[6]);
                        BABYLON.Tmp.Matrix[6].multiplyToRef(this._transformToBoneReferal.getWorldMatrix(), this._worldMatrix);
                    }
                    else {
                        this._localWorld.multiplyToRef(this.parent.getWorldMatrix(), this._worldMatrix);
                    }
                }
                this._markSyncedWithParent();
            }
            else {
                this._worldMatrix.copyFrom(this._localWorld);
            }
            // Post multiply inverse of pivotMatrix
            if (this._postMultiplyPivotMatrix) {
                this._worldMatrix.multiplyToRef(this._pivotMatrixInverse, this._worldMatrix);
            }
            // Normal matrix
            if (this.scaling.isNonUniform) {
                this._updateNonUniformScalingState(true);
            }
            else if (this.parent && this.parent._nonUniformScaling) {
                this._updateNonUniformScalingState(this.parent._nonUniformScaling);
            }
            else {
                this._updateNonUniformScalingState(false);
            }
            this._afterComputeWorldMatrix();
            // Absolute position
            this._absolutePosition.copyFromFloats(this._worldMatrix.m[12], this._worldMatrix.m[13], this._worldMatrix.m[14]);
            // Callbacks
            this.onAfterWorldMatrixUpdateObservable.notifyObservers(this);
            if (!this._poseMatrix) {
                this._poseMatrix = BABYLON.Matrix.Invert(this._worldMatrix);
            }
            return this._worldMatrix;
        };
        TransformNode.prototype._afterComputeWorldMatrix = function () {
        };
        /**
        * If you'd like to be called back after the mesh position, rotation or scaling has been updated.
        * @param func: callback function to add
        *
        * Returns the TransformNode.
        */
        TransformNode.prototype.registerAfterWorldMatrixUpdate = function (func) {
            this.onAfterWorldMatrixUpdateObservable.add(func);
            return this;
        };
        /**
         * Removes a registered callback function.
         * Returns the TransformNode.
         */
        TransformNode.prototype.unregisterAfterWorldMatrixUpdate = function (func) {
            this.onAfterWorldMatrixUpdateObservable.removeCallback(func);
            return this;
        };
        /**
         * Clone the current transform node
         * Returns the new transform node
         * @param name Name of the new clone
         * @param newParent New parent for the clone
         * @param doNotCloneChildren Do not clone children hierarchy
         */
        TransformNode.prototype.clone = function (name, newParent, doNotCloneChildren) {
            var _this = this;
            var result = BABYLON.SerializationHelper.Clone(function () { return new TransformNode(name, _this.getScene()); }, this);
            result.name = name;
            result.id = name;
            if (newParent) {
                result.parent = newParent;
            }
            if (!doNotCloneChildren) {
                // Children
                var directDescendants = this.getDescendants(true);
                for (var index = 0; index < directDescendants.length; index++) {
                    var child = directDescendants[index];
                    if (child.clone) {
                        child.clone(name + "." + child.name, result);
                    }
                }
            }
            return result;
        };
        TransformNode.prototype.serialize = function (currentSerializationObject) {
            var serializationObject = BABYLON.SerializationHelper.Serialize(this, currentSerializationObject);
            serializationObject.type = this.getClassName();
            // Parent
            if (this.parent) {
                serializationObject.parentId = this.parent.id;
            }
            if (BABYLON.Tags && BABYLON.Tags.HasTags(this)) {
                serializationObject.tags = BABYLON.Tags.GetTags(this);
            }
            serializationObject.localMatrix = this.getPivotMatrix().asArray();
            serializationObject.isEnabled = this.isEnabled();
            // Parent
            if (this.parent) {
                serializationObject.parentId = this.parent.id;
            }
            return serializationObject;
        };
        // Statics
        /**
         * Returns a new TransformNode object parsed from the source provided.
         * The parameter `parsedMesh` is the source.
         * The parameter `rootUrl` is a string, it's the root URL to prefix the `delayLoadingFile` property with
         */
        TransformNode.Parse = function (parsedTransformNode, scene, rootUrl) {
            var transformNode = BABYLON.SerializationHelper.Parse(function () { return new TransformNode(parsedTransformNode.name, scene); }, parsedTransformNode, scene, rootUrl);
            if (BABYLON.Tags) {
                BABYLON.Tags.AddTagsTo(transformNode, parsedTransformNode.tags);
            }
            if (parsedTransformNode.localMatrix) {
                transformNode.setPivotMatrix(BABYLON.Matrix.FromArray(parsedTransformNode.localMatrix));
            }
            else if (parsedTransformNode.pivotMatrix) {
                transformNode.setPivotMatrix(BABYLON.Matrix.FromArray(parsedTransformNode.pivotMatrix));
            }
            transformNode.setEnabled(parsedTransformNode.isEnabled);
            // Parent
            if (parsedTransformNode.parentId) {
                transformNode._waitingParentId = parsedTransformNode.parentId;
            }
            return transformNode;
        };
        /**
         * Disposes the TransformNode.
         * By default, all the children are also disposed unless the parameter `doNotRecurse` is set to `true`.
         * Returns nothing.
         */
        TransformNode.prototype.dispose = function (doNotRecurse) {
            // Animations
            this.getScene().stopAnimation(this);
            // Remove from scene
            this.getScene().removeTransformNode(this);
            this._cache = {};
            if (!doNotRecurse) {
                // Children
                var objects = this.getDescendants(true);
                for (var index = 0; index < objects.length; index++) {
                    objects[index].dispose();
                }
            }
            else {
                var childMeshes = this.getChildMeshes(true);
                for (index = 0; index < childMeshes.length; index++) {
                    var child = childMeshes[index];
                    child.parent = null;
                    child.computeWorldMatrix(true);
                }
            }
            this.onAfterWorldMatrixUpdateObservable.clear();
            _super.prototype.dispose.call(this);
        };
        // Statics
        TransformNode.BILLBOARDMODE_NONE = 0;
        TransformNode.BILLBOARDMODE_X = 1;
        TransformNode.BILLBOARDMODE_Y = 2;
        TransformNode.BILLBOARDMODE_Z = 4;
        TransformNode.BILLBOARDMODE_ALL = 7;
        TransformNode._lookAtVectorCache = new BABYLON.Vector3(0, 0, 0);
        TransformNode._rotationAxisCache = new BABYLON.Quaternion();
        __decorate([
            BABYLON.serializeAsVector3()
        ], TransformNode.prototype, "_rotation", void 0);
        __decorate([
            BABYLON.serializeAsQuaternion()
        ], TransformNode.prototype, "_rotationQuaternion", void 0);
        __decorate([
            BABYLON.serializeAsVector3()
        ], TransformNode.prototype, "_scaling", void 0);
        __decorate([
            BABYLON.serialize()
        ], TransformNode.prototype, "billboardMode", void 0);
        __decorate([
            BABYLON.serialize()
        ], TransformNode.prototype, "scalingDeterminant", void 0);
        __decorate([
            BABYLON.serialize()
        ], TransformNode.prototype, "infiniteDistance", void 0);
        __decorate([
            BABYLON.serializeAsVector3()
        ], TransformNode.prototype, "position", void 0);
        return TransformNode;
    }(BABYLON.Node));
    BABYLON.TransformNode = TransformNode;
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.transformNode.js.map


var BABYLON;
(function (BABYLON) {
    var AbstractMesh = /** @class */ (function (_super) {
        __extends(AbstractMesh, _super);
        // Constructor
        function AbstractMesh(name, scene) {
            if (scene === void 0) { scene = null; }
            var _this = _super.call(this, name, scene, false) || this;
            _this._facetNb = 0; // facet number
            _this._partitioningSubdivisions = 10; // number of subdivisions per axis in the partioning space  
            _this._partitioningBBoxRatio = 1.01; // the partioning array space is by default 1% bigger than the bounding box
            _this._facetDataEnabled = false; // is the facet data feature enabled on this mesh ?
            _this._facetParameters = {}; // keep a reference to the object parameters to avoid memory re-allocation
            _this._bbSize = BABYLON.Vector3.Zero(); // bbox size approximated for facet data
            _this._subDiv = {
                max: 1,
                X: 1,
                Y: 1,
                Z: 1
            };
            _this._facetDepthSort = false; // is the facet depth sort to be computed
            _this._facetDepthSortEnabled = false; // is the facet depth sort initialized
            // Events
            /**
            * An event triggered when this mesh collides with another one
            * @type {BABYLON.Observable}
            */
            _this.onCollideObservable = new BABYLON.Observable();
            /**
            * An event triggered when the collision's position changes
            * @type {BABYLON.Observable}
            */
            _this.onCollisionPositionChangeObservable = new BABYLON.Observable();
            /**
            * An event triggered when material is changed
            * @type {BABYLON.Observable}
            */
            _this.onMaterialChangedObservable = new BABYLON.Observable();
            // Properties
            _this.definedFacingForward = true; // orientation for POV movement & rotation
            /**
            * This property determines the type of occlusion query algorithm to run in WebGl, you can use:
    
            * AbstractMesh.OCCLUSION_ALGORITHM_TYPE_ACCURATE which is mapped to GL_ANY_SAMPLES_PASSED.
    
            * or
    
            * AbstractMesh.OCCLUSION_ALGORITHM_TYPE_CONSERVATIVE (Default Value) which is mapped to GL_ANY_SAMPLES_PASSED_CONSERVATIVE which is a false positive algorithm that is faster than GL_ANY_SAMPLES_PASSED but less accurate.
    
            * for more info check WebGl documentations
            */
            _this.occlusionQueryAlgorithmType = AbstractMesh.OCCLUSION_ALGORITHM_TYPE_CONSERVATIVE;
            /**
             * This property is responsible for starting the occlusion query within the Mesh or not, this property is also used     to determine what should happen when the occlusionRetryCount is reached. It has supports 3 values:
    
            * OCCLUSION_TYPE_NONE (Default Value): this option means no occlusion query whith the Mesh.
    
            * OCCLUSION_TYPE_OPTIMISTIC: this option is means use occlusion query and if occlusionRetryCount is reached and the query is broken show the mesh.
    
                * OCCLUSION_TYPE_STRICT: this option is means use occlusion query and if occlusionRetryCount is reached and the query is broken restore the last state of the mesh occlusion if the mesh was visible then show the mesh if was hidden then hide don't show.
             */
            _this.occlusionType = AbstractMesh.OCCLUSION_TYPE_NONE;
            /**
            * This number indicates the number of allowed retries before stop the occlusion query, this is useful if the        occlusion query is taking long time before to the query result is retireved, the query result indicates if the object is visible within the scene or not and based on that Babylon.Js engine decideds to show or hide the object.
    
            * The default value is -1 which means don't break the query and wait till the result.
            */
            _this.occlusionRetryCount = -1;
            _this._occlusionInternalRetryCounter = 0;
            _this._isOccluded = false;
            _this._isOcclusionQueryInProgress = false;
            _this.visibility = 1.0;
            _this.alphaIndex = Number.MAX_VALUE;
            _this.isVisible = true;
            _this.isPickable = true;
            _this.showBoundingBox = false;
            _this.showSubMeshesBoundingBox = false;
            _this.isBlocker = false;
            _this.enablePointerMoveEvents = false;
            _this.renderingGroupId = 0;
            _this._receiveShadows = false;
            _this.renderOutline = false;
            _this.outlineColor = BABYLON.Color3.Red();
            _this.outlineWidth = 0.02;
            _this.renderOverlay = false;
            _this.overlayColor = BABYLON.Color3.Red();
            _this.overlayAlpha = 0.5;
            _this._hasVertexAlpha = false;
            _this._useVertexColors = true;
            _this._computeBonesUsingShaders = true;
            _this._numBoneInfluencers = 4;
            _this._applyFog = true;
            _this.useOctreeForRenderingSelection = true;
            _this.useOctreeForPicking = true;
            _this.useOctreeForCollisions = true;
            _this._layerMask = 0x0FFFFFFF;
            /**
             * True if the mesh must be rendered in any case.
             */
            _this.alwaysSelectAsActiveMesh = false;
            /**
             * This scene's action manager
             * @type {BABYLON.ActionManager}
            */
            _this.actionManager = null;
            // Physics
            _this.physicsImpostor = null;
            // Collisions
            _this._checkCollisions = false;
            _this._collisionMask = -1;
            _this._collisionGroup = -1;
            _this.ellipsoid = new BABYLON.Vector3(0.5, 1, 0.5);
            _this.ellipsoidOffset = new BABYLON.Vector3(0, 0, 0);
            _this._oldPositionForCollisions = new BABYLON.Vector3(0, 0, 0);
            _this._diffPositionForCollisions = new BABYLON.Vector3(0, 0, 0);
            // Edges
            _this.edgesWidth = 1;
            _this.edgesColor = new BABYLON.Color4(1, 0, 0, 1);
            // Cache
            _this._collisionsTransformMatrix = BABYLON.Matrix.Zero();
            _this._collisionsScalingMatrix = BABYLON.Matrix.Zero();
            _this._isDisposed = false;
            _this._renderId = 0;
            _this._intersectionsInProgress = new Array();
            _this._unIndexed = false;
            _this._lightSources = new Array();
            _this._onCollisionPositionChange = function (collisionId, newPosition, collidedMesh) {
                if (collidedMesh === void 0) { collidedMesh = null; }
                //TODO move this to the collision coordinator!
                if (_this.getScene().workerCollisions)
                    newPosition.multiplyInPlace(_this._collider._radius);
                newPosition.subtractToRef(_this._oldPositionForCollisions, _this._diffPositionForCollisions);
                if (_this._diffPositionForCollisions.length() > BABYLON.Engine.CollisionsEpsilon) {
                    _this.position.addInPlace(_this._diffPositionForCollisions);
                }
                if (collidedMesh) {
                    _this.onCollideObservable.notifyObservers(collidedMesh);
                }
                _this.onCollisionPositionChangeObservable.notifyObservers(_this.position);
            };
            _this.getScene().addMesh(_this);
            _this._resyncLightSources();
            return _this;
        }
        Object.defineProperty(AbstractMesh, "BILLBOARDMODE_NONE", {
            get: function () {
                return BABYLON.TransformNode.BILLBOARDMODE_NONE;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh, "BILLBOARDMODE_X", {
            get: function () {
                return BABYLON.TransformNode.BILLBOARDMODE_X;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh, "BILLBOARDMODE_Y", {
            get: function () {
                return BABYLON.TransformNode.BILLBOARDMODE_Y;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh, "BILLBOARDMODE_Z", {
            get: function () {
                return BABYLON.TransformNode.BILLBOARDMODE_Z;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh, "BILLBOARDMODE_ALL", {
            get: function () {
                return BABYLON.TransformNode.BILLBOARDMODE_ALL;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "facetNb", {
            /**
             * Read-only : the number of facets in the mesh
             */
            get: function () {
                return this._facetNb;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "partitioningSubdivisions", {
            /**
             * The number (integer) of subdivisions per axis in the partioning space
             */
            get: function () {
                return this._partitioningSubdivisions;
            },
            set: function (nb) {
                this._partitioningSubdivisions = nb;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "partitioningBBoxRatio", {
            /**
             * The ratio (float) to apply to the bouding box size to set to the partioning space.
             * Ex : 1.01 (default) the partioning space is 1% bigger than the bounding box.
             */
            get: function () {
                return this._partitioningBBoxRatio;
            },
            set: function (ratio) {
                this._partitioningBBoxRatio = ratio;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "mustDepthSortFacets", {
            /**
             * Boolean : must the facet be depth sorted on next call to `updateFacetData()` ?
             * Works only for updatable meshes.
             * Doesn't work with multi-materials.
             */
            get: function () {
                return this._facetDepthSort;
            },
            set: function (sort) {
                this._facetDepthSort = sort;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "facetDepthSortFrom", {
            /**
             * The location (Vector3) where the facet depth sort must be computed from.
             * By default, the active camera position.
             * Used only when facet depth sort is enabled.
             */
            get: function () {
                return this._facetDepthSortFrom;
            },
            set: function (location) {
                this._facetDepthSortFrom = location;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "isFacetDataEnabled", {
            /**
             * Read-only boolean : is the feature facetData enabled ?
             */
            get: function () {
                return this._facetDataEnabled;
            },
            enumerable: true,
            configurable: true
        });
        AbstractMesh.prototype._updateNonUniformScalingState = function (value) {
            if (!_super.prototype._updateNonUniformScalingState.call(this, value)) {
                return false;
            }
            this._markSubMeshesAsMiscDirty();
            return true;
        };
        Object.defineProperty(AbstractMesh.prototype, "onCollide", {
            set: function (callback) {
                if (this._onCollideObserver) {
                    this.onCollideObservable.remove(this._onCollideObserver);
                }
                this._onCollideObserver = this.onCollideObservable.add(callback);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "onCollisionPositionChange", {
            set: function (callback) {
                if (this._onCollisionPositionChangeObserver) {
                    this.onCollisionPositionChangeObservable.remove(this._onCollisionPositionChangeObserver);
                }
                this._onCollisionPositionChangeObserver = this.onCollisionPositionChangeObservable.add(callback);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "isOccluded", {
            /**
            * Property isOccluded : Gets or sets whether the mesh is occluded or not, it is used also to set the intial state of the mesh to be occluded or not.
            */
            get: function () {
                return this._isOccluded;
            },
            set: function (value) {
                this._isOccluded = value;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "isOcclusionQueryInProgress", {
            /**
            * Flag to check the progress status of the query
            */
            get: function () {
                return this._isOcclusionQueryInProgress;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "material", {
            get: function () {
                return this._material;
            },
            set: function (value) {
                if (this._material === value) {
                    return;
                }
                this._material = value;
                if (this.onMaterialChangedObservable.hasObservers) {
                    this.onMaterialChangedObservable.notifyObservers(this);
                }
                if (!this.subMeshes) {
                    return;
                }
                for (var _i = 0, _a = this.subMeshes; _i < _a.length; _i++) {
                    var subMesh = _a[_i];
                    subMesh.setEffect(null);
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "receiveShadows", {
            get: function () {
                return this._receiveShadows;
            },
            set: function (value) {
                if (this._receiveShadows === value) {
                    return;
                }
                this._receiveShadows = value;
                this._markSubMeshesAsLightDirty();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "hasVertexAlpha", {
            get: function () {
                return this._hasVertexAlpha;
            },
            set: function (value) {
                if (this._hasVertexAlpha === value) {
                    return;
                }
                this._hasVertexAlpha = value;
                this._markSubMeshesAsAttributesDirty();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "useVertexColors", {
            get: function () {
                return this._useVertexColors;
            },
            set: function (value) {
                if (this._useVertexColors === value) {
                    return;
                }
                this._useVertexColors = value;
                this._markSubMeshesAsAttributesDirty();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "computeBonesUsingShaders", {
            get: function () {
                return this._computeBonesUsingShaders;
            },
            set: function (value) {
                if (this._computeBonesUsingShaders === value) {
                    return;
                }
                this._computeBonesUsingShaders = value;
                this._markSubMeshesAsAttributesDirty();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "numBoneInfluencers", {
            get: function () {
                return this._numBoneInfluencers;
            },
            set: function (value) {
                if (this._numBoneInfluencers === value) {
                    return;
                }
                this._numBoneInfluencers = value;
                this._markSubMeshesAsAttributesDirty();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "applyFog", {
            get: function () {
                return this._applyFog;
            },
            set: function (value) {
                if (this._applyFog === value) {
                    return;
                }
                this._applyFog = value;
                this._markSubMeshesAsMiscDirty();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "layerMask", {
            get: function () {
                return this._layerMask;
            },
            set: function (value) {
                if (value === this._layerMask) {
                    return;
                }
                this._layerMask = value;
                this._resyncLightSources();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "collisionMask", {
            get: function () {
                return this._collisionMask;
            },
            set: function (mask) {
                this._collisionMask = !isNaN(mask) ? mask : -1;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "collisionGroup", {
            get: function () {
                return this._collisionGroup;
            },
            set: function (mask) {
                this._collisionGroup = !isNaN(mask) ? mask : -1;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "_positions", {
            get: function () {
                return null;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "skeleton", {
            get: function () {
                return this._skeleton;
            },
            set: function (value) {
                if (this._skeleton && this._skeleton.needInitialSkinMatrix) {
                    this._skeleton._unregisterMeshWithPoseMatrix(this);
                }
                if (value && value.needInitialSkinMatrix) {
                    value._registerMeshWithPoseMatrix(this);
                }
                this._skeleton = value;
                if (!this._skeleton) {
                    this._bonesTransformMatrices = null;
                }
                this._markSubMeshesAsAttributesDirty();
            },
            enumerable: true,
            configurable: true
        });
        /**
         * Boolean : true if the mesh has been disposed.
         */
        AbstractMesh.prototype.isDisposed = function () {
            return this._isDisposed;
        };
        /**
         * Returns the string "AbstractMesh"
         */
        AbstractMesh.prototype.getClassName = function () {
            return "AbstractMesh";
        };
        /**
         * @param {boolean} fullDetails - support for multiple levels of logging within scene loading
         */
        AbstractMesh.prototype.toString = function (fullDetails) {
            var ret = "Name: " + this.name + ", isInstance: " + (this instanceof BABYLON.InstancedMesh ? "YES" : "NO");
            ret += ", # of submeshes: " + (this.subMeshes ? this.subMeshes.length : 0);
            if (this._skeleton) {
                ret += ", skeleton: " + this._skeleton.name;
            }
            if (fullDetails) {
                ret += ", billboard mode: " + (["NONE", "X", "Y", null, "Z", null, null, "ALL"])[this.billboardMode];
                ret += ", freeze wrld mat: " + (this._isWorldMatrixFrozen || this._waitingFreezeWorldMatrix ? "YES" : "NO");
            }
            return ret;
        };
        AbstractMesh.prototype._rebuild = function () {
            if (this._occlusionQuery) {
                this._occlusionQuery = null;
            }
            if (this._edgesRenderer) {
                this._edgesRenderer._rebuild();
            }
            if (!this.subMeshes) {
                return;
            }
            for (var _i = 0, _a = this.subMeshes; _i < _a.length; _i++) {
                var subMesh = _a[_i];
                subMesh._rebuild();
            }
        };
        AbstractMesh.prototype._resyncLightSources = function () {
            this._lightSources.length = 0;
            for (var _i = 0, _a = this.getScene().lights; _i < _a.length; _i++) {
                var light = _a[_i];
                if (!light.isEnabled()) {
                    continue;
                }
                if (light.canAffectMesh(this)) {
                    this._lightSources.push(light);
                }
            }
            this._markSubMeshesAsLightDirty();
        };
        AbstractMesh.prototype._resyncLighSource = function (light) {
            var isIn = light.isEnabled() && light.canAffectMesh(this);
            var index = this._lightSources.indexOf(light);
            if (index === -1) {
                if (!isIn) {
                    return;
                }
                this._lightSources.push(light);
            }
            else {
                if (isIn) {
                    return;
                }
                this._lightSources.splice(index, 1);
            }
            this._markSubMeshesAsLightDirty();
        };
        AbstractMesh.prototype._removeLightSource = function (light) {
            var index = this._lightSources.indexOf(light);
            if (index === -1) {
                return;
            }
            this._lightSources.splice(index, 1);
        };
        AbstractMesh.prototype._markSubMeshesAsDirty = function (func) {
            if (!this.subMeshes) {
                return;
            }
            for (var _i = 0, _a = this.subMeshes; _i < _a.length; _i++) {
                var subMesh = _a[_i];
                if (subMesh._materialDefines) {
                    func(subMesh._materialDefines);
                }
            }
        };
        AbstractMesh.prototype._markSubMeshesAsLightDirty = function () {
            this._markSubMeshesAsDirty(function (defines) { return defines.markAsLightDirty(); });
        };
        AbstractMesh.prototype._markSubMeshesAsAttributesDirty = function () {
            this._markSubMeshesAsDirty(function (defines) { return defines.markAsAttributesDirty(); });
        };
        AbstractMesh.prototype._markSubMeshesAsMiscDirty = function () {
            if (!this.subMeshes) {
                return;
            }
            for (var _i = 0, _a = this.subMeshes; _i < _a.length; _i++) {
                var subMesh = _a[_i];
                var material = subMesh.getMaterial();
                if (material) {
                    material.markAsDirty(BABYLON.Material.MiscDirtyFlag);
                }
            }
        };
        Object.defineProperty(AbstractMesh.prototype, "scaling", {
            /**
            * Scaling property : a Vector3 depicting the mesh scaling along each local axis X, Y, Z.
            * Default : (1.0, 1.0, 1.0)
            */
            get: function () {
                return this._scaling;
            },
            /**
             * Scaling property : a Vector3 depicting the mesh scaling along each local axis X, Y, Z.
             * Default : (1.0, 1.0, 1.0)
             */
            set: function (newScaling) {
                this._scaling = newScaling;
                if (this.physicsImpostor) {
                    this.physicsImpostor.forceUpdate();
                }
            },
            enumerable: true,
            configurable: true
        });
        // Methods
        /**
         * Disables the mesh edger rendering mode.
         * Returns the AbstractMesh.
         */
        AbstractMesh.prototype.disableEdgesRendering = function () {
            if (this._edgesRenderer) {
                this._edgesRenderer.dispose();
                this._edgesRenderer = null;
            }
            return this;
        };
        /**
         * Enables the edge rendering mode on the mesh.
         * This mode makes the mesh edges visible.
         * Returns the AbstractMesh.
         */
        AbstractMesh.prototype.enableEdgesRendering = function (epsilon, checkVerticesInsteadOfIndices) {
            if (epsilon === void 0) { epsilon = 0.95; }
            if (checkVerticesInsteadOfIndices === void 0) { checkVerticesInsteadOfIndices = false; }
            this.disableEdgesRendering();
            this._edgesRenderer = new BABYLON.EdgesRenderer(this, epsilon, checkVerticesInsteadOfIndices);
            return this;
        };
        Object.defineProperty(AbstractMesh.prototype, "isBlocked", {
            /**
             * Returns true if the mesh is blocked. Used by the class Mesh.
             * Returns the boolean `false` by default.
             */
            get: function () {
                return false;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * Returns the mesh itself by default, used by the class Mesh.
         * Returned type : AbstractMesh
         */
        AbstractMesh.prototype.getLOD = function (camera) {
            return this;
        };
        /**
         * Returns 0 by default, used by the class Mesh.
         * Returns an integer.
         */
        AbstractMesh.prototype.getTotalVertices = function () {
            return 0;
        };
        /**
         * Returns null by default, used by the class Mesh.
         * Returned type : integer array
         */
        AbstractMesh.prototype.getIndices = function () {
            return null;
        };
        /**
         * Returns the array of the requested vertex data kind. Used by the class Mesh. Returns null here.
         * Returned type : float array or Float32Array
         */
        AbstractMesh.prototype.getVerticesData = function (kind) {
            return null;
        };
        /**
         * Sets the vertex data of the mesh geometry for the requested `kind`.
         * If the mesh has no geometry, a new Geometry object is set to the mesh and then passed this vertex data.
         * The `data` are either a numeric array either a Float32Array.
         * The parameter `updatable` is passed as is to the underlying Geometry object constructor (if initianilly none) or updater.
         * The parameter `stride` is an optional positive integer, it is usually automatically deducted from the `kind` (3 for positions or normals, 2 for UV, etc).
         * Note that a new underlying VertexBuffer object is created each call.
         * If the `kind` is the `PositionKind`, the mesh BoundingInfo is renewed, so the bounding box and sphere, and the mesh World Matrix is recomputed.
         *
         * Possible `kind` values :
         * - BABYLON.VertexBuffer.PositionKind
         * - BABYLON.VertexBuffer.UVKind
         * - BABYLON.VertexBuffer.UV2Kind
         * - BABYLON.VertexBuffer.UV3Kind
         * - BABYLON.VertexBuffer.UV4Kind
         * - BABYLON.VertexBuffer.UV5Kind
         * - BABYLON.VertexBuffer.UV6Kind
         * - BABYLON.VertexBuffer.ColorKind
         * - BABYLON.VertexBuffer.MatricesIndicesKind
         * - BABYLON.VertexBuffer.MatricesIndicesExtraKind
         * - BABYLON.VertexBuffer.MatricesWeightsKind
         * - BABYLON.VertexBuffer.MatricesWeightsExtraKind
         *
         * Returns the Mesh.
         */
        AbstractMesh.prototype.setVerticesData = function (kind, data, updatable, stride) {
            return this;
        };
        /**
         * Updates the existing vertex data of the mesh geometry for the requested `kind`.
         * If the mesh has no geometry, it is simply returned as it is.
         * The `data` are either a numeric array either a Float32Array.
         * No new underlying VertexBuffer object is created.
         * If the `kind` is the `PositionKind` and if `updateExtends` is true, the mesh BoundingInfo is renewed, so the bounding box and sphere, and the mesh World Matrix is recomputed.
         * If the parameter `makeItUnique` is true, a new global geometry is created from this positions and is set to the mesh.
         *
         * Possible `kind` values :
         * - BABYLON.VertexBuffer.PositionKind
         * - BABYLON.VertexBuffer.UVKind
         * - BABYLON.VertexBuffer.UV2Kind
         * - BABYLON.VertexBuffer.UV3Kind
         * - BABYLON.VertexBuffer.UV4Kind
         * - BABYLON.VertexBuffer.UV5Kind
         * - BABYLON.VertexBuffer.UV6Kind
         * - BABYLON.VertexBuffer.ColorKind
         * - BABYLON.VertexBuffer.MatricesIndicesKind
         * - BABYLON.VertexBuffer.MatricesIndicesExtraKind
         * - BABYLON.VertexBuffer.MatricesWeightsKind
         * - BABYLON.VertexBuffer.MatricesWeightsExtraKind
         *
         * Returns the Mesh.
         */
        AbstractMesh.prototype.updateVerticesData = function (kind, data, updateExtends, makeItUnique) {
            return this;
        };
        /**
         * Sets the mesh indices.
         * Expects an array populated with integers or a typed array (Int32Array, Uint32Array, Uint16Array).
         * If the mesh has no geometry, a new Geometry object is created and set to the mesh.
         * This method creates a new index buffer each call.
         * Returns the Mesh.
         */
        AbstractMesh.prototype.setIndices = function (indices, totalVertices) {
            return this;
        };
        /** Returns false by default, used by the class Mesh.
         *  Returns a boolean
        */
        AbstractMesh.prototype.isVerticesDataPresent = function (kind) {
            return false;
        };
        /**
         * Returns the mesh BoundingInfo object or creates a new one and returns it if undefined.
         * Returns a BoundingInfo
         */
        AbstractMesh.prototype.getBoundingInfo = function () {
            if (this._masterMesh) {
                return this._masterMesh.getBoundingInfo();
            }
            if (!this._boundingInfo) {
                // this._boundingInfo is being created here
                this._updateBoundingInfo();
            }
            // cannot be null.
            return this._boundingInfo;
        };
        /**
         * Uniformly scales the mesh to fit inside of a unit cube (1 X 1 X 1 units).
         * @param includeDescendants Take the hierarchy's bounding box instead of the mesh's bounding box.
         */
        AbstractMesh.prototype.normalizeToUnitCube = function (includeDescendants) {
            if (includeDescendants === void 0) { includeDescendants = true; }
            var boundingVectors = this.getHierarchyBoundingVectors(includeDescendants);
            var sizeVec = boundingVectors.max.subtract(boundingVectors.min);
            var maxDimension = Math.max(sizeVec.x, sizeVec.y, sizeVec.z);
            if (maxDimension === 0) {
                return this;
            }
            var scale = 1 / maxDimension;
            this.scaling.scaleInPlace(scale);
            return this;
        };
        /**
         * Sets a mesh new object BoundingInfo.
         * Returns the AbstractMesh.
         */
        AbstractMesh.prototype.setBoundingInfo = function (boundingInfo) {
            this._boundingInfo = boundingInfo;
            return this;
        };
        Object.defineProperty(AbstractMesh.prototype, "useBones", {
            get: function () {
                return (this.skeleton && this.getScene().skeletonsEnabled && this.isVerticesDataPresent(BABYLON.VertexBuffer.MatricesIndicesKind) && this.isVerticesDataPresent(BABYLON.VertexBuffer.MatricesWeightsKind));
            },
            enumerable: true,
            configurable: true
        });
        AbstractMesh.prototype._preActivate = function () {
        };
        AbstractMesh.prototype._preActivateForIntermediateRendering = function (renderId) {
        };
        AbstractMesh.prototype._activate = function (renderId) {
            this._renderId = renderId;
        };
        /**
         * Returns the latest update of the World matrix
         * Returns a Matrix.
         */
        AbstractMesh.prototype.getWorldMatrix = function () {
            if (this._masterMesh) {
                return this._masterMesh.getWorldMatrix();
            }
            return _super.prototype.getWorldMatrix.call(this);
        };
        // ================================== Point of View Movement =================================
        /**
         * Perform relative position change from the point of view of behind the front of the mesh.
         * This is performed taking into account the meshes current rotation, so you do not have to care.
         * Supports definition of mesh facing forward or backward.
         * @param {number} amountRight
         * @param {number} amountUp
         * @param {number} amountForward
         *
         * Returns the AbstractMesh.
         */
        AbstractMesh.prototype.movePOV = function (amountRight, amountUp, amountForward) {
            this.position.addInPlace(this.calcMovePOV(amountRight, amountUp, amountForward));
            return this;
        };
        /**
         * Calculate relative position change from the point of view of behind the front of the mesh.
         * This is performed taking into account the meshes current rotation, so you do not have to care.
         * Supports definition of mesh facing forward or backward.
         * @param {number} amountRight
         * @param {number} amountUp
         * @param {number} amountForward
         *
         * Returns a new Vector3.
         */
        AbstractMesh.prototype.calcMovePOV = function (amountRight, amountUp, amountForward) {
            var rotMatrix = new BABYLON.Matrix();
            var rotQuaternion = (this.rotationQuaternion) ? this.rotationQuaternion : BABYLON.Quaternion.RotationYawPitchRoll(this.rotation.y, this.rotation.x, this.rotation.z);
            rotQuaternion.toRotationMatrix(rotMatrix);
            var translationDelta = BABYLON.Vector3.Zero();
            var defForwardMult = this.definedFacingForward ? -1 : 1;
            BABYLON.Vector3.TransformCoordinatesFromFloatsToRef(amountRight * defForwardMult, amountUp, amountForward * defForwardMult, rotMatrix, translationDelta);
            return translationDelta;
        };
        // ================================== Point of View Rotation =================================
        /**
         * Perform relative rotation change from the point of view of behind the front of the mesh.
         * Supports definition of mesh facing forward or backward.
         * @param {number} flipBack
         * @param {number} twirlClockwise
         * @param {number} tiltRight
         *
         * Returns the AbstractMesh.
         */
        AbstractMesh.prototype.rotatePOV = function (flipBack, twirlClockwise, tiltRight) {
            this.rotation.addInPlace(this.calcRotatePOV(flipBack, twirlClockwise, tiltRight));
            return this;
        };
        /**
         * Calculate relative rotation change from the point of view of behind the front of the mesh.
         * Supports definition of mesh facing forward or backward.
         * @param {number} flipBack
         * @param {number} twirlClockwise
         * @param {number} tiltRight
         *
         * Returns a new Vector3.
         */
        AbstractMesh.prototype.calcRotatePOV = function (flipBack, twirlClockwise, tiltRight) {
            var defForwardMult = this.definedFacingForward ? 1 : -1;
            return new BABYLON.Vector3(flipBack * defForwardMult, twirlClockwise, tiltRight * defForwardMult);
        };
        /**
         * Return the minimum and maximum world vectors of the entire hierarchy under current mesh
         * @param includeDescendants Include bounding info from descendants as well (true by default).
         */
        AbstractMesh.prototype.getHierarchyBoundingVectors = function (includeDescendants) {
            if (includeDescendants === void 0) { includeDescendants = true; }
            this.computeWorldMatrix(true);
            var min;
            var max;
            var boundingInfo = this.getBoundingInfo();
            if (!this.subMeshes) {
                min = new BABYLON.Vector3(Number.MAX_VALUE, Number.MAX_VALUE, Number.MAX_VALUE);
                max = new BABYLON.Vector3(-Number.MAX_VALUE, -Number.MAX_VALUE, -Number.MAX_VALUE);
            }
            else {
                min = boundingInfo.boundingBox.minimumWorld;
                max = boundingInfo.boundingBox.maximumWorld;
            }
            if (includeDescendants) {
                var descendants = this.getDescendants(false);
                for (var _i = 0, descendants_1 = descendants; _i < descendants_1.length; _i++) {
                    var descendant = descendants_1[_i];
                    var childMesh = descendant;
                    childMesh.computeWorldMatrix(true);
                    var childBoundingInfo = childMesh.getBoundingInfo();
                    if (childMesh.getTotalVertices() === 0) {
                        continue;
                    }
                    var boundingBox = childBoundingInfo.boundingBox;
                    var minBox = boundingBox.minimumWorld;
                    var maxBox = boundingBox.maximumWorld;
                    BABYLON.Tools.CheckExtends(minBox, min, max);
                    BABYLON.Tools.CheckExtends(maxBox, min, max);
                }
            }
            return {
                min: min,
                max: max
            };
        };
        /**
         * Updates the mesh BoundingInfo object and all its children BoundingInfo objects also.
         * Returns the AbstractMesh.
         */
        AbstractMesh.prototype._updateBoundingInfo = function () {
            this._boundingInfo = this._boundingInfo || new BABYLON.BoundingInfo(this.absolutePosition, this.absolutePosition);
            this._boundingInfo.update(this.worldMatrixFromCache);
            this._updateSubMeshesBoundingInfo(this.worldMatrixFromCache);
            return this;
        };
        /**
         * Update a mesh's children BoundingInfo objects only.
         * Returns the AbstractMesh.
         */
        AbstractMesh.prototype._updateSubMeshesBoundingInfo = function (matrix) {
            if (!this.subMeshes) {
                return this;
            }
            for (var subIndex = 0; subIndex < this.subMeshes.length; subIndex++) {
                var subMesh = this.subMeshes[subIndex];
                if (!subMesh.IsGlobal) {
                    subMesh.updateBoundingInfo(matrix);
                }
            }
            return this;
        };
        AbstractMesh.prototype._afterComputeWorldMatrix = function () {
            // Bounding info
            this._updateBoundingInfo();
        };
        /**
         * Returns `true` if the mesh is within the frustum defined by the passed array of planes.
         * A mesh is in the frustum if its bounding box intersects the frustum.
         * Boolean returned.
         */
        AbstractMesh.prototype.isInFrustum = function (frustumPlanes) {
            return this._boundingInfo !== null && this._boundingInfo.isInFrustum(frustumPlanes);
        };
        /**
         * Returns `true` if the mesh is completely in the frustum defined be the passed array of planes.
         * A mesh is completely in the frustum if its bounding box it completely inside the frustum.
         * Boolean returned.
         */
        AbstractMesh.prototype.isCompletelyInFrustum = function (frustumPlanes) {
            return this._boundingInfo !== null && this._boundingInfo.isCompletelyInFrustum(frustumPlanes);
            ;
        };
        /**
         * True if the mesh intersects another mesh or a SolidParticle object.
         * Unless the parameter `precise` is set to `true` the intersection is computed according to Axis Aligned Bounding Boxes (AABB), else according to OBB (Oriented BBoxes)
         * includeDescendants can be set to true to test if the mesh defined in parameters intersects with the current mesh or any child meshes
         * Returns a boolean.
         */
        AbstractMesh.prototype.intersectsMesh = function (mesh, precise, includeDescendants) {
            if (precise === void 0) { precise = false; }
            if (!this._boundingInfo || !mesh._boundingInfo) {
                return false;
            }
            if (this._boundingInfo.intersects(mesh._boundingInfo, precise)) {
                return true;
            }
            if (includeDescendants) {
                for (var _i = 0, _a = this.getChildMeshes(); _i < _a.length; _i++) {
                    var child = _a[_i];
                    if (child.intersectsMesh(mesh, precise, true)) {
                        return true;
                    }
                }
            }
            return false;
        };
        /**
         * Returns true if the passed point (Vector3) is inside the mesh bounding box.
         * Returns a boolean.
         */
        AbstractMesh.prototype.intersectsPoint = function (point) {
            if (!this._boundingInfo) {
                return false;
            }
            return this._boundingInfo.intersectsPoint(point);
        };
        AbstractMesh.prototype.getPhysicsImpostor = function () {
            return this.physicsImpostor;
        };
        AbstractMesh.prototype.getPositionInCameraSpace = function (camera) {
            if (camera === void 0) { camera = null; }
            if (!camera) {
                camera = this.getScene().activeCamera;
            }
            return BABYLON.Vector3.TransformCoordinates(this.absolutePosition, camera.getViewMatrix());
        };
        /**
         * Returns the distance from the mesh to the active camera.
         * Returns a float.
         */
        AbstractMesh.prototype.getDistanceToCamera = function (camera) {
            if (camera === void 0) { camera = null; }
            if (!camera) {
                camera = this.getScene().activeCamera;
            }
            return this.absolutePosition.subtract(camera.position).length();
        };
        AbstractMesh.prototype.applyImpulse = function (force, contactPoint) {
            if (!this.physicsImpostor) {
                return this;
            }
            this.physicsImpostor.applyImpulse(force, contactPoint);
            return this;
        };
        AbstractMesh.prototype.setPhysicsLinkWith = function (otherMesh, pivot1, pivot2, options) {
            if (!this.physicsImpostor || !otherMesh.physicsImpostor) {
                return this;
            }
            this.physicsImpostor.createJoint(otherMesh.physicsImpostor, BABYLON.PhysicsJoint.HingeJoint, {
                mainPivot: pivot1,
                connectedPivot: pivot2,
                nativeParams: options
            });
            return this;
        };
        Object.defineProperty(AbstractMesh.prototype, "checkCollisions", {
            // Collisions
            /**
             * Property checkCollisions : Boolean, whether the camera should check the collisions against the mesh.
             * Default `false`.
             */
            get: function () {
                return this._checkCollisions;
            },
            set: function (collisionEnabled) {
                this._checkCollisions = collisionEnabled;
                if (this.getScene().workerCollisions) {
                    this.getScene().collisionCoordinator.onMeshUpdated(this);
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(AbstractMesh.prototype, "collider", {
            /**
             * Gets Collider object used to compute collisions (not physics)
             */
            get: function () {
                return this._collider;
            },
            enumerable: true,
            configurable: true
        });
        AbstractMesh.prototype.moveWithCollisions = function (displacement) {
            var globalPosition = this.getAbsolutePosition();
            globalPosition.addToRef(this.ellipsoidOffset, this._oldPositionForCollisions);
            if (!this._collider) {
                this._collider = new BABYLON.Collider();
            }
            this._collider._radius = this.ellipsoid;
            this.getScene().collisionCoordinator.getNewPosition(this._oldPositionForCollisions, displacement, this._collider, 3, this, this._onCollisionPositionChange, this.uniqueId);
            return this;
        };
        // Submeshes octree
        /**
        * This function will create an octree to help to select the right submeshes for rendering, picking and collision computations.
        * Please note that you must have a decent number of submeshes to get performance improvements when using an octree.
        * Returns an Octree of submeshes.
        */
        AbstractMesh.prototype.createOrUpdateSubmeshesOctree = function (maxCapacity, maxDepth) {
            if (maxCapacity === void 0) { maxCapacity = 64; }
            if (maxDepth === void 0) { maxDepth = 2; }
            if (!this._submeshesOctree) {
                this._submeshesOctree = new BABYLON.Octree(BABYLON.Octree.CreationFuncForSubMeshes, maxCapacity, maxDepth);
            }
            this.computeWorldMatrix(true);
            var boundingInfo = this.getBoundingInfo();
            // Update octree
            var bbox = boundingInfo.boundingBox;
            this._submeshesOctree.update(bbox.minimumWorld, bbox.maximumWorld, this.subMeshes);
            return this._submeshesOctree;
        };
        // Collisions
        AbstractMesh.prototype._collideForSubMesh = function (subMesh, transformMatrix, collider) {
            this._generatePointsArray();
            if (!this._positions) {
                return this;
            }
            // Transformation
            if (!subMesh._lastColliderWorldVertices || !subMesh._lastColliderTransformMatrix.equals(transformMatrix)) {
                subMesh._lastColliderTransformMatrix = transformMatrix.clone();
                subMesh._lastColliderWorldVertices = [];
                subMesh._trianglePlanes = [];
                var start = subMesh.verticesStart;
                var end = (subMesh.verticesStart + subMesh.verticesCount);
                for (var i = start; i < end; i++) {
                    subMesh._lastColliderWorldVertices.push(BABYLON.Vector3.TransformCoordinates(this._positions[i], transformMatrix));
                }
            }
            // Collide
            collider._collide(subMesh._trianglePlanes, subMesh._lastColliderWorldVertices, this.getIndices(), subMesh.indexStart, subMesh.indexStart + subMesh.indexCount, subMesh.verticesStart, !!subMesh.getMaterial());
            if (collider.collisionFound) {
                collider.collidedMesh = this;
            }
            return this;
        };
        AbstractMesh.prototype._processCollisionsForSubMeshes = function (collider, transformMatrix) {
            var subMeshes;
            var len;
            // Octrees
            if (this._submeshesOctree && this.useOctreeForCollisions) {
                var radius = collider._velocityWorldLength + Math.max(collider._radius.x, collider._radius.y, collider._radius.z);
                var intersections = this._submeshesOctree.intersects(collider._basePointWorld, radius);
                len = intersections.length;
                subMeshes = intersections.data;
            }
            else {
                subMeshes = this.subMeshes;
                len = subMeshes.length;
            }
            for (var index = 0; index < len; index++) {
                var subMesh = subMeshes[index];
                // Bounding test
                if (len > 1 && !subMesh._checkCollision(collider))
                    continue;
                this._collideForSubMesh(subMesh, transformMatrix, collider);
            }
            return this;
        };
        AbstractMesh.prototype._checkCollision = function (collider) {
            // Bounding box test
            if (!this._boundingInfo || !this._boundingInfo._checkCollision(collider))
                return this;
            // Transformation matrix
            BABYLON.Matrix.ScalingToRef(1.0 / collider._radius.x, 1.0 / collider._radius.y, 1.0 / collider._radius.z, this._collisionsScalingMatrix);
            this.worldMatrixFromCache.multiplyToRef(this._collisionsScalingMatrix, this._collisionsTransformMatrix);
            this._processCollisionsForSubMeshes(collider, this._collisionsTransformMatrix);
            return this;
        };
        // Picking
        AbstractMesh.prototype._generatePointsArray = function () {
            return false;
        };
        /**
         * Checks if the passed Ray intersects with the mesh.
         * Returns an object PickingInfo.
         */
        AbstractMesh.prototype.intersects = function (ray, fastCheck) {
            var pickingInfo = new BABYLON.PickingInfo();
            if (!this.subMeshes || !this._boundingInfo || !ray.intersectsSphere(this._boundingInfo.boundingSphere) || !ray.intersectsBox(this._boundingInfo.boundingBox)) {
                return pickingInfo;
            }
            if (!this._generatePointsArray()) {
                return pickingInfo;
            }
            var intersectInfo = null;
            // Octrees
            var subMeshes;
            var len;
            if (this._submeshesOctree && this.useOctreeForPicking) {
                var worldRay = BABYLON.Ray.Transform(ray, this.getWorldMatrix());
                var intersections = this._submeshesOctree.intersectsRay(worldRay);
                len = intersections.length;
                subMeshes = intersections.data;
            }
            else {
                subMeshes = this.subMeshes;
                len = subMeshes.length;
            }
            for (var index = 0; index < len; index++) {
                var subMesh = subMeshes[index];
                // Bounding test
                if (len > 1 && !subMesh.canIntersects(ray))
                    continue;
                var currentIntersectInfo = subMesh.intersects(ray, this._positions, this.getIndices(), fastCheck);
                if (currentIntersectInfo) {
                    if (fastCheck || !intersectInfo || currentIntersectInfo.distance < intersectInfo.distance) {
                        intersectInfo = currentIntersectInfo;
                        intersectInfo.subMeshId = index;
                        if (fastCheck) {
                            break;
                        }
                    }
                }
            }
            if (intersectInfo) {
                // Get picked point
                var world = this.getWorldMatrix();
                var worldOrigin = BABYLON.Vector3.TransformCoordinates(ray.origin, world);
                var direction = ray.direction.clone();
                direction = direction.scale(intersectInfo.distance);
                var worldDirection = BABYLON.Vector3.TransformNormal(direction, world);
                var pickedPoint = worldOrigin.add(worldDirection);
                // Return result
                pickingInfo.hit = true;
                pickingInfo.distance = BABYLON.Vector3.Distance(worldOrigin, pickedPoint);
                pickingInfo.pickedPoint = pickedPoint;
                pickingInfo.pickedMesh = this;
                pickingInfo.bu = intersectInfo.bu || 0;
                pickingInfo.bv = intersectInfo.bv || 0;
                pickingInfo.faceId = intersectInfo.faceId;
                pickingInfo.subMeshId = intersectInfo.subMeshId;
                return pickingInfo;
            }
            return pickingInfo;
        };
        /**
         * Clones the mesh, used by the class Mesh.
         * Just returns `null` for an AbstractMesh.
         */
        AbstractMesh.prototype.clone = function (name, newParent, doNotCloneChildren) {
            return null;
        };
        /**
         * Disposes all the mesh submeshes.
         * Returns the AbstractMesh.
         */
        AbstractMesh.prototype.releaseSubMeshes = function () {
            if (this.subMeshes) {
                while (this.subMeshes.length) {
                    this.subMeshes[0].dispose();
                }
            }
            else {
                this.subMeshes = new Array();
            }
            return this;
        };
        /**
         * Disposes the AbstractMesh.
         * By default, all the mesh children are also disposed unless the parameter `doNotRecurse` is set to `true`.
         * Returns nothing.
         */
        AbstractMesh.prototype.dispose = function (doNotRecurse, disposeMaterialAndTextures) {
            var _this = this;
            if (disposeMaterialAndTextures === void 0) { disposeMaterialAndTextures = false; }
            var index;
            // Action manager
            if (this.actionManager) {
                this.actionManager.dispose();
                this.actionManager = null;
            }
            // Skeleton
            this.skeleton = null;
            // Physics
            if (this.physicsImpostor) {
                this.physicsImpostor.dispose();
            }
            // Intersections in progress
            for (index = 0; index < this._intersectionsInProgress.length; index++) {
                var other = this._intersectionsInProgress[index];
                var pos = other._intersectionsInProgress.indexOf(this);
                other._intersectionsInProgress.splice(pos, 1);
            }
            this._intersectionsInProgress = [];
            // Lights
            var lights = this.getScene().lights;
            lights.forEach(function (light) {
                var meshIndex = light.includedOnlyMeshes.indexOf(_this);
                if (meshIndex !== -1) {
                    light.includedOnlyMeshes.splice(meshIndex, 1);
                }
                meshIndex = light.excludedMeshes.indexOf(_this);
                if (meshIndex !== -1) {
                    light.excludedMeshes.splice(meshIndex, 1);
                }
                // Shadow generators
                var generator = light.getShadowGenerator();
                if (generator) {
                    var shadowMap = generator.getShadowMap();
                    if (shadowMap && shadowMap.renderList) {
                        meshIndex = shadowMap.renderList.indexOf(_this);
                        if (meshIndex !== -1) {
                            shadowMap.renderList.splice(meshIndex, 1);
                        }
                    }
                }
            });
            // Edges
            if (this._edgesRenderer) {
                this._edgesRenderer.dispose();
                this._edgesRenderer = null;
            }
            // SubMeshes
            if (this.getClassName() !== "InstancedMesh") {
                this.releaseSubMeshes();
            }
            // Octree
            var sceneOctree = this.getScene().selectionOctree;
            if (sceneOctree) {
                var index = sceneOctree.dynamicContent.indexOf(this);
                if (index !== -1) {
                    sceneOctree.dynamicContent.splice(index, 1);
                }
            }
            // Query
            var engine = this.getScene().getEngine();
            if (this._occlusionQuery) {
                this._isOcclusionQueryInProgress = false;
                engine.deleteQuery(this._occlusionQuery);
                this._occlusionQuery = null;
            }
            // Engine
            engine.wipeCaches();
            // Remove from scene
            this.getScene().removeMesh(this);
            if (disposeMaterialAndTextures) {
                if (this.material) {
                    this.material.dispose(false, true);
                }
            }
            if (!doNotRecurse) {
                // Particles
                for (index = 0; index < this.getScene().particleSystems.length; index++) {
                    if (this.getScene().particleSystems[index].emitter === this) {
                        this.getScene().particleSystems[index].dispose();
                        index--;
                    }
                }
            }
            // facet data
            if (this._facetDataEnabled) {
                this.disableFacetData();
            }
            this.onAfterWorldMatrixUpdateObservable.clear();
            this.onCollideObservable.clear();
            this.onCollisionPositionChangeObservable.clear();
            this._isDisposed = true;
            _super.prototype.dispose.call(this, doNotRecurse);
        };
        /**
         * Adds the passed mesh as a child to the current mesh.
         * Returns the AbstractMesh.
         */
        AbstractMesh.prototype.addChild = function (mesh) {
            mesh.setParent(this);
            return this;
        };
        /**
         * Removes the passed mesh from the current mesh children list.
         * Returns the AbstractMesh.
         */
        AbstractMesh.prototype.removeChild = function (mesh) {
            mesh.setParent(null);
            return this;
        };
        // Facet data
        /**
         *  Initialize the facet data arrays : facetNormals, facetPositions and facetPartitioning.
         * Returns the AbstractMesh.
         */
        AbstractMesh.prototype._initFacetData = function () {
            if (!this._facetNormals) {
                this._facetNormals = new Array();
            }
            if (!this._facetPositions) {
                this._facetPositions = new Array();
            }
            if (!this._facetPartitioning) {
                this._facetPartitioning = new Array();
            }
            this._facetNb = (this.getIndices().length / 3) | 0;
            this._partitioningSubdivisions = (this._partitioningSubdivisions) ? this._partitioningSubdivisions : 10; // default nb of partitioning subdivisions = 10
            this._partitioningBBoxRatio = (this._partitioningBBoxRatio) ? this._partitioningBBoxRatio : 1.01; // default ratio 1.01 = the partitioning is 1% bigger than the bounding box
            for (var f = 0; f < this._facetNb; f++) {
                this._facetNormals[f] = BABYLON.Vector3.Zero();
                this._facetPositions[f] = BABYLON.Vector3.Zero();
            }
            this._facetDataEnabled = true;
            return this;
        };
        /**
         * Updates the mesh facetData arrays and the internal partitioning when the mesh is morphed or updated.
         * This method can be called within the render loop.
         * You don't need to call this method by yourself in the render loop when you update/morph a mesh with the methods CreateXXX() as they automatically manage this computation.
         * Returns the AbstractMesh.
         */
        AbstractMesh.prototype.updateFacetData = function () {
            if (!this._facetDataEnabled) {
                this._initFacetData();
            }
            var positions = this.getVerticesData(BABYLON.VertexBuffer.PositionKind);
            var indices = this.getIndices();
            var normals = this.getVerticesData(BABYLON.VertexBuffer.NormalKind);
            var bInfo = this.getBoundingInfo();
            if (this._facetDepthSort && !this._facetDepthSortEnabled) {
                // init arrays, matrix and sort function on first call
                this._facetDepthSortEnabled = true;
                if (indices instanceof Uint16Array) {
                    this._depthSortedIndices = new Uint16Array(indices);
                }
                else if (indices instanceof Uint32Array) {
                    this._depthSortedIndices = new Uint32Array(indices);
                }
                else {
                    var needs32bits = false;
                    for (var i = 0; i < indices.length; i++) {
                        if (indices[i] > 65535) {
                            needs32bits = true;
                            break;
                        }
                    }
                    if (needs32bits) {
                        this._depthSortedIndices = new Uint32Array(indices);
                    }
                    else {
                        this._depthSortedIndices = new Uint16Array(indices);
                    }
                }
                this._facetDepthSortFunction = function (f1, f2) {
                    return (f2.sqDistance - f1.sqDistance);
                };
                if (!this._facetDepthSortFrom) {
                    var camera = this.getScene().activeCamera;
                    this._facetDepthSortFrom = (camera) ? camera.position : BABYLON.Vector3.Zero();
                }
                this._depthSortedFacets = [];
                for (var f = 0; f < this._facetNb; f++) {
                    var depthSortedFacet = { ind: f * 3, sqDistance: 0.0 };
                    this._depthSortedFacets.push(depthSortedFacet);
                }
                this._invertedMatrix = BABYLON.Matrix.Identity();
                this._facetDepthSortOrigin = BABYLON.Vector3.Zero();
            }
            this._bbSize.x = (bInfo.maximum.x - bInfo.minimum.x > BABYLON.Epsilon) ? bInfo.maximum.x - bInfo.minimum.x : BABYLON.Epsilon;
            this._bbSize.y = (bInfo.maximum.y - bInfo.minimum.y > BABYLON.Epsilon) ? bInfo.maximum.y - bInfo.minimum.y : BABYLON.Epsilon;
            this._bbSize.z = (bInfo.maximum.z - bInfo.minimum.z > BABYLON.Epsilon) ? bInfo.maximum.z - bInfo.minimum.z : BABYLON.Epsilon;
            var bbSizeMax = (this._bbSize.x > this._bbSize.y) ? this._bbSize.x : this._bbSize.y;
            bbSizeMax = (bbSizeMax > this._bbSize.z) ? bbSizeMax : this._bbSize.z;
            this._subDiv.max = this._partitioningSubdivisions;
            this._subDiv.X = Math.floor(this._subDiv.max * this._bbSize.x / bbSizeMax); // adjust the number of subdivisions per axis
            this._subDiv.Y = Math.floor(this._subDiv.max * this._bbSize.y / bbSizeMax); // according to each bbox size per axis
            this._subDiv.Z = Math.floor(this._subDiv.max * this._bbSize.z / bbSizeMax);
            this._subDiv.X = this._subDiv.X < 1 ? 1 : this._subDiv.X; // at least one subdivision
            this._subDiv.Y = this._subDiv.Y < 1 ? 1 : this._subDiv.Y;
            this._subDiv.Z = this._subDiv.Z < 1 ? 1 : this._subDiv.Z;
            // set the parameters for ComputeNormals()
            this._facetParameters.facetNormals = this.getFacetLocalNormals();
            this._facetParameters.facetPositions = this.getFacetLocalPositions();
            this._facetParameters.facetPartitioning = this.getFacetLocalPartitioning();
            this._facetParameters.bInfo = bInfo;
            this._facetParameters.bbSize = this._bbSize;
            this._facetParameters.subDiv = this._subDiv;
            this._facetParameters.ratio = this.partitioningBBoxRatio;
            this._facetParameters.depthSort = this._facetDepthSort;
            if (this._facetDepthSort && this._facetDepthSortEnabled) {
                this.computeWorldMatrix(true);
                this._worldMatrix.invertToRef(this._invertedMatrix);
                BABYLON.Vector3.TransformCoordinatesToRef(this._facetDepthSortFrom, this._invertedMatrix, this._facetDepthSortOrigin);
                this._facetParameters.distanceTo = this._facetDepthSortOrigin;
            }
            this._facetParameters.depthSortedFacets = this._depthSortedFacets;
            BABYLON.VertexData.ComputeNormals(positions, indices, normals, this._facetParameters);
            if (this._facetDepthSort && this._facetDepthSortEnabled) {
                this._depthSortedFacets.sort(this._facetDepthSortFunction);
                var l = (this._depthSortedIndices.length / 3) | 0;
                for (var f = 0; f < l; f++) {
                    var sind = this._depthSortedFacets[f].ind;
                    this._depthSortedIndices[f * 3] = indices[sind];
                    this._depthSortedIndices[f * 3 + 1] = indices[sind + 1];
                    this._depthSortedIndices[f * 3 + 2] = indices[sind + 2];
                }
                this.updateIndices(this._depthSortedIndices);
            }
            return this;
        };
        /**
         * Returns the facetLocalNormals array.
         * The normals are expressed in the mesh local space.
         */
        AbstractMesh.prototype.getFacetLocalNormals = function () {
            if (!this._facetNormals) {
                this.updateFacetData();
            }
            return this._facetNormals;
        };
        /**
         * Returns the facetLocalPositions array.
         * The facet positions are expressed in the mesh local space.
         */
        AbstractMesh.prototype.getFacetLocalPositions = function () {
            if (!this._facetPositions) {
                this.updateFacetData();
            }
            return this._facetPositions;
        };
        /**
         * Returns the facetLocalPartioning array.
         */
        AbstractMesh.prototype.getFacetLocalPartitioning = function () {
            if (!this._facetPartitioning) {
                this.updateFacetData();
            }
            return this._facetPartitioning;
        };
        /**
         * Returns the i-th facet position in the world system.
         * This method allocates a new Vector3 per call.
         */
        AbstractMesh.prototype.getFacetPosition = function (i) {
            var pos = BABYLON.Vector3.Zero();
            this.getFacetPositionToRef(i, pos);
            return pos;
        };
        /**
         * Sets the reference Vector3 with the i-th facet position in the world system.
         * Returns the AbstractMesh.
         */
        AbstractMesh.prototype.getFacetPositionToRef = function (i, ref) {
            var localPos = (this.getFacetLocalPositions())[i];
            var world = this.getWorldMatrix();
            BABYLON.Vector3.TransformCoordinatesToRef(localPos, world, ref);
            return this;
        };
        /**
         * Returns the i-th facet normal in the world system.
         * This method allocates a new Vector3 per call.
         */
        AbstractMesh.prototype.getFacetNormal = function (i) {
            var norm = BABYLON.Vector3.Zero();
            this.getFacetNormalToRef(i, norm);
            return norm;
        };
        /**
         * Sets the reference Vector3 with the i-th facet normal in the world system.
         * Returns the AbstractMesh.
         */
        AbstractMesh.prototype.getFacetNormalToRef = function (i, ref) {
            var localNorm = (this.getFacetLocalNormals())[i];
            BABYLON.Vector3.TransformNormalToRef(localNorm, this.getWorldMatrix(), ref);
            return this;
        };
        /**
         * Returns the facets (in an array) in the same partitioning block than the one the passed coordinates are located (expressed in the mesh local system).
         */
        AbstractMesh.prototype.getFacetsAtLocalCoordinates = function (x, y, z) {
            var bInfo = this.getBoundingInfo();
            var ox = Math.floor((x - bInfo.minimum.x * this._partitioningBBoxRatio) * this._subDiv.X * this._partitioningBBoxRatio / this._bbSize.x);
            var oy = Math.floor((y - bInfo.minimum.y * this._partitioningBBoxRatio) * this._subDiv.Y * this._partitioningBBoxRatio / this._bbSize.y);
            var oz = Math.floor((z - bInfo.minimum.z * this._partitioningBBoxRatio) * this._subDiv.Z * this._partitioningBBoxRatio / this._bbSize.z);
            if (ox < 0 || ox > this._subDiv.max || oy < 0 || oy > this._subDiv.max || oz < 0 || oz > this._subDiv.max) {
                return null;
            }
            return this._facetPartitioning[ox + this._subDiv.max * oy + this._subDiv.max * this._subDiv.max * oz];
        };
        /**
         * Returns the closest mesh facet index at (x,y,z) World coordinates, null if not found.
         * If the parameter projected (vector3) is passed, it is set as the (x,y,z) World projection on the facet.
         * If checkFace is true (default false), only the facet "facing" to (x,y,z) or only the ones "turning their backs", according to the parameter "facing" are returned.
         * If facing and checkFace are true, only the facet "facing" to (x, y, z) are returned : positive dot (x, y, z) * facet position.
         * If facing si false and checkFace is true, only the facet "turning their backs" to (x, y, z) are returned : negative dot (x, y, z) * facet position.
         */
        AbstractMesh.prototype.getClosestFacetAtCoordinates = function (x, y, z, projected, checkFace, facing) {
            if (checkFace === void 0) { checkFace = false; }
            if (facing === void 0) { facing = true; }
            var world = this.getWorldMatrix();
            var invMat = BABYLON.Tmp.Matrix[5];
            world.invertToRef(invMat);
            var invVect = BABYLON.Tmp.Vector3[8];
            BABYLON.Vector3.TransformCoordinatesFromFloatsToRef(x, y, z, invMat, invVect); // transform (x,y,z) to coordinates in the mesh local space
            var closest = this.getClosestFacetAtLocalCoordinates(invVect.x, invVect.y, invVect.z, projected, checkFace, facing);
            if (projected) {
                // tranform the local computed projected vector to world coordinates
                BABYLON.Vector3.TransformCoordinatesFromFloatsToRef(projected.x, projected.y, projected.z, world, projected);
            }
            return closest;
        };
        /**
         * Returns the closest mesh facet index at (x,y,z) local coordinates, null if not found.
         * If the parameter projected (vector3) is passed, it is set as the (x,y,z) local projection on the facet.
         * If checkFace is true (default false), only the facet "facing" to (x,y,z) or only the ones "turning their backs", according to the parameter "facing" are returned.
         * If facing and checkFace are true, only the facet "facing" to (x, y, z) are returned : positive dot (x, y, z) * facet position.
         * If facing si false and checkFace is true, only the facet "turning their backs"  to (x, y, z) are returned : negative dot (x, y, z) * facet position.
         */
        AbstractMesh.prototype.getClosestFacetAtLocalCoordinates = function (x, y, z, projected, checkFace, facing) {
            if (checkFace === void 0) { checkFace = false; }
            if (facing === void 0) { facing = true; }
            var closest = null;
            var tmpx = 0.0;
            var tmpy = 0.0;
            var tmpz = 0.0;
            var d = 0.0; // tmp dot facet normal * facet position
            var t0 = 0.0;
            var projx = 0.0;
            var projy = 0.0;
            var projz = 0.0;
            // Get all the facets in the same partitioning block than (x, y, z)
            var facetPositions = this.getFacetLocalPositions();
            var facetNormals = this.getFacetLocalNormals();
            var facetsInBlock = this.getFacetsAtLocalCoordinates(x, y, z);
            if (!facetsInBlock) {
                return null;
            }
            // Get the closest facet to (x, y, z)
            var shortest = Number.MAX_VALUE; // init distance vars
            var tmpDistance = shortest;
            var fib; // current facet in the block
            var norm; // current facet normal
            var p0; // current facet barycenter position
            // loop on all the facets in the current partitioning block
            for (var idx = 0; idx < facetsInBlock.length; idx++) {
                fib = facetsInBlock[idx];
                norm = facetNormals[fib];
                p0 = facetPositions[fib];
                d = (x - p0.x) * norm.x + (y - p0.y) * norm.y + (z - p0.z) * norm.z;
                if (!checkFace || (checkFace && facing && d >= 0.0) || (checkFace && !facing && d <= 0.0)) {
                    // compute (x,y,z) projection on the facet = (projx, projy, projz)
                    d = norm.x * p0.x + norm.y * p0.y + norm.z * p0.z;
                    t0 = -(norm.x * x + norm.y * y + norm.z * z - d) / (norm.x * norm.x + norm.y * norm.y + norm.z * norm.z);
                    projx = x + norm.x * t0;
                    projy = y + norm.y * t0;
                    projz = z + norm.z * t0;
                    tmpx = projx - x;
                    tmpy = projy - y;
                    tmpz = projz - z;
                    tmpDistance = tmpx * tmpx + tmpy * tmpy + tmpz * tmpz; // compute length between (x, y, z) and its projection on the facet
                    if (tmpDistance < shortest) {
                        shortest = tmpDistance;
                        closest = fib;
                        if (projected) {
                            projected.x = projx;
                            projected.y = projy;
                            projected.z = projz;
                        }
                    }
                }
            }
            return closest;
        };
        /**
         * Returns the object "parameter" set with all the expected parameters for facetData computation by ComputeNormals()
         */
        AbstractMesh.prototype.getFacetDataParameters = function () {
            return this._facetParameters;
        };
        /**
         * Disables the feature FacetData and frees the related memory.
         * Returns the AbstractMesh.
         */
        AbstractMesh.prototype.disableFacetData = function () {
            if (this._facetDataEnabled) {
                this._facetDataEnabled = false;
                this._facetPositions = new Array();
                this._facetNormals = new Array();
                this._facetPartitioning = new Array();
                this._facetParameters = null;
                this._depthSortedIndices = new Uint32Array(0);
            }
            return this;
        };
        /**
         * Updates the AbstractMesh indices array. Actually, used by the Mesh object.
         * Returns the mesh.
         */
        AbstractMesh.prototype.updateIndices = function (indices) {
            return this;
        };
        /**
         * The mesh Geometry. Actually used by the Mesh object.
         * Returns a blank geometry object.
         */
        /**
         * Creates new normals data for the mesh.
         * @param updatable.
         */
        AbstractMesh.prototype.createNormals = function (updatable) {
            var positions = this.getVerticesData(BABYLON.VertexBuffer.PositionKind);
            var indices = this.getIndices();
            var normals;
            if (this.isVerticesDataPresent(BABYLON.VertexBuffer.NormalKind)) {
                normals = this.getVerticesData(BABYLON.VertexBuffer.NormalKind);
            }
            else {
                normals = [];
            }
            BABYLON.VertexData.ComputeNormals(positions, indices, normals, { useRightHandedSystem: this.getScene().useRightHandedSystem });
            this.setVerticesData(BABYLON.VertexBuffer.NormalKind, normals, updatable);
        };
        /**
         * Align the mesh with a normal.
         * Returns the mesh.
         */
        AbstractMesh.prototype.alignWithNormal = function (normal, upDirection) {
            if (!upDirection) {
                upDirection = BABYLON.Axis.Y;
            }
            var axisX = BABYLON.Tmp.Vector3[0];
            var axisZ = BABYLON.Tmp.Vector3[1];
            BABYLON.Vector3.CrossToRef(upDirection, normal, axisZ);
            BABYLON.Vector3.CrossToRef(normal, axisZ, axisX);
            if (this.rotationQuaternion) {
                BABYLON.Quaternion.RotationQuaternionFromAxisToRef(axisX, normal, axisZ, this.rotationQuaternion);
            }
            else {
                BABYLON.Vector3.RotationFromAxisToRef(axisX, normal, axisZ, this.rotation);
            }
            return this;
        };
        AbstractMesh.prototype.checkOcclusionQuery = function () {
            var engine = this.getEngine();
            if (engine.webGLVersion < 2 || this.occlusionType === AbstractMesh.OCCLUSION_TYPE_NONE) {
                this._isOccluded = false;
                return;
            }
            if (this.isOcclusionQueryInProgress && this._occlusionQuery) {
                var isOcclusionQueryAvailable = engine.isQueryResultAvailable(this._occlusionQuery);
                if (isOcclusionQueryAvailable) {
                    var occlusionQueryResult = engine.getQueryResult(this._occlusionQuery);
                    this._isOcclusionQueryInProgress = false;
                    this._occlusionInternalRetryCounter = 0;
                    this._isOccluded = occlusionQueryResult === 1 ? false : true;
                }
                else {
                    this._occlusionInternalRetryCounter++;
                    if (this.occlusionRetryCount !== -1 && this._occlusionInternalRetryCounter > this.occlusionRetryCount) {
                        this._isOcclusionQueryInProgress = false;
                        this._occlusionInternalRetryCounter = 0;
                        // if optimistic set isOccluded to false regardless of the status of isOccluded. (Render in the current render loop)
                        // if strict continue the last state of the object.
                        this._isOccluded = this.occlusionType === AbstractMesh.OCCLUSION_TYPE_OPTIMISTIC ? false : this._isOccluded;
                    }
                    else {
                        return;
                    }
                }
            }
            var scene = this.getScene();
            var occlusionBoundingBoxRenderer = scene.getBoundingBoxRenderer();
            if (!this._occlusionQuery) {
                this._occlusionQuery = engine.createQuery();
            }
            engine.beginOcclusionQuery(this.occlusionQueryAlgorithmType, this._occlusionQuery);
            occlusionBoundingBoxRenderer.renderOcclusionBoundingBox(this);
            engine.endOcclusionQuery(this.occlusionQueryAlgorithmType);
            this._isOcclusionQueryInProgress = true;
        };
        AbstractMesh.OCCLUSION_TYPE_NONE = 0;
        AbstractMesh.OCCLUSION_TYPE_OPTIMISTIC = 1;
        AbstractMesh.OCCLUSION_TYPE_STRICT = 2;
        AbstractMesh.OCCLUSION_ALGORITHM_TYPE_ACCURATE = 0;
        AbstractMesh.OCCLUSION_ALGORITHM_TYPE_CONSERVATIVE = 1;
        return AbstractMesh;
    }(BABYLON.TransformNode));
    BABYLON.AbstractMesh = AbstractMesh;
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.abstractMesh.js.map







var BABYLON;
(function (BABYLON) {
    var Light = /** @class */ (function (_super) {
        __extends(Light, _super);
        /**
         * Creates a Light object in the scene.
         * Documentation : http://doc.babylonjs.com/tutorials/lights
         */
        function Light(name, scene) {
            var _this = _super.call(this, name, scene) || this;
            _this.diffuse = new BABYLON.Color3(1.0, 1.0, 1.0);
            _this.specular = new BABYLON.Color3(1.0, 1.0, 1.0);
            _this.intensity = 1.0;
            _this.range = Number.MAX_VALUE;
            /**
             * Cached photometric scale default to 1.0 as the automatic intensity mode defaults to 1.0 for every type
             * of light.
             */
            _this._photometricScale = 1.0;
            _this._intensityMode = Light.INTENSITYMODE_AUTOMATIC;
            _this._radius = 0.00001;
            _this.renderPriority = 0;
            /**
             * Defines wether or not the shadows are enabled for this light. This can help turning off/on shadow without detaching
             * the current shadow generator.
             */
            _this.shadowEnabled = true;
            _this._excludeWithLayerMask = 0;
            _this._includeOnlyWithLayerMask = 0;
            _this._lightmapMode = 0;
            _this._excludedMeshesIds = new Array();
            _this._includedOnlyMeshesIds = new Array();
            _this.getScene().addLight(_this);
            _this._uniformBuffer = new BABYLON.UniformBuffer(_this.getScene().getEngine());
            _this._buildUniformLayout();
            _this.includedOnlyMeshes = new Array();
            _this.excludedMeshes = new Array();
            _this._resyncMeshes();
            return _this;
        }
        Object.defineProperty(Light, "LIGHTMAP_DEFAULT", {
            /**
             * If every light affecting the material is in this lightmapMode,
             * material.lightmapTexture adds or multiplies
             * (depends on material.useLightmapAsShadowmap)
             * after every other light calculations.
             */
            get: function () {
                return Light._LIGHTMAP_DEFAULT;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Light, "LIGHTMAP_SPECULAR", {
            /**
             * material.lightmapTexture as only diffuse lighting from this light
             * adds pnly specular lighting from this light
             * adds dynamic shadows
             */
            get: function () {
                return Light._LIGHTMAP_SPECULAR;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Light, "LIGHTMAP_SHADOWSONLY", {
            /**
             * material.lightmapTexture as only lighting
             * no light calculation from this light
             * only adds dynamic shadows from this light
             */
            get: function () {
                return Light._LIGHTMAP_SHADOWSONLY;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Light, "INTENSITYMODE_AUTOMATIC", {
            /**
             * Each light type uses the default quantity according to its type:
             *      point/spot lights use luminous intensity
             *      directional lights use illuminance
             */
            get: function () {
                return Light._INTENSITYMODE_AUTOMATIC;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Light, "INTENSITYMODE_LUMINOUSPOWER", {
            /**
             * lumen (lm)
             */
            get: function () {
                return Light._INTENSITYMODE_LUMINOUSPOWER;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Light, "INTENSITYMODE_LUMINOUSINTENSITY", {
            /**
             * candela (lm/sr)
             */
            get: function () {
                return Light._INTENSITYMODE_LUMINOUSINTENSITY;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Light, "INTENSITYMODE_ILLUMINANCE", {
            /**
             * lux (lm/m^2)
             */
            get: function () {
                return Light._INTENSITYMODE_ILLUMINANCE;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Light, "INTENSITYMODE_LUMINANCE", {
            /**
             * nit (cd/m^2)
             */
            get: function () {
                return Light._INTENSITYMODE_LUMINANCE;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Light, "LIGHTTYPEID_POINTLIGHT", {
            /**
             * Light type const id of the point light.
             */
            get: function () {
                return Light._LIGHTTYPEID_POINTLIGHT;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Light, "LIGHTTYPEID_DIRECTIONALLIGHT", {
            /**
             * Light type const id of the directional light.
             */
            get: function () {
                return Light._LIGHTTYPEID_DIRECTIONALLIGHT;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Light, "LIGHTTYPEID_SPOTLIGHT", {
            /**
             * Light type const id of the spot light.
             */
            get: function () {
                return Light._LIGHTTYPEID_SPOTLIGHT;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Light, "LIGHTTYPEID_HEMISPHERICLIGHT", {
            /**
             * Light type const id of the hemispheric light.
             */
            get: function () {
                return Light._LIGHTTYPEID_HEMISPHERICLIGHT;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Light.prototype, "intensityMode", {
            /**
             * Gets the photometric scale used to interpret the intensity.
             * This is only relevant with PBR Materials where the light intensity can be defined in a physical way.
             */
            get: function () {
                return this._intensityMode;
            },
            /**
             * Sets the photometric scale used to interpret the intensity.
             * This is only relevant with PBR Materials where the light intensity can be defined in a physical way.
             */
            set: function (value) {
                this._intensityMode = value;
                this._computePhotometricScale();
            },
            enumerable: true,
            configurable: true
        });
        ;
        ;
        Object.defineProperty(Light.prototype, "radius", {
            /**
             * Gets the light radius used by PBR Materials to simulate soft area lights.
             */
            get: function () {
                return this._radius;
            },
            /**
             * sets the light radius used by PBR Materials to simulate soft area lights.
             */
            set: function (value) {
                this._radius = value;
                this._computePhotometricScale();
            },
            enumerable: true,
            configurable: true
        });
        ;
        ;
        Object.defineProperty(Light.prototype, "includedOnlyMeshes", {
            get: function () {
                return this._includedOnlyMeshes;
            },
            set: function (value) {
                this._includedOnlyMeshes = value;
                this._hookArrayForIncludedOnly(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Light.prototype, "excludedMeshes", {
            get: function () {
                return this._excludedMeshes;
            },
            set: function (value) {
                this._excludedMeshes = value;
                this._hookArrayForExcluded(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Light.prototype, "excludeWithLayerMask", {
            get: function () {
                return this._excludeWithLayerMask;
            },
            set: function (value) {
                this._excludeWithLayerMask = value;
                this._resyncMeshes();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Light.prototype, "includeOnlyWithLayerMask", {
            get: function () {
                return this._includeOnlyWithLayerMask;
            },
            set: function (value) {
                this._includeOnlyWithLayerMask = value;
                this._resyncMeshes();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Light.prototype, "lightmapMode", {
            get: function () {
                return this._lightmapMode;
            },
            set: function (value) {
                if (this._lightmapMode === value) {
                    return;
                }
                this._lightmapMode = value;
                this._markMeshesAsLightDirty();
            },
            enumerable: true,
            configurable: true
        });
        Light.prototype._buildUniformLayout = function () {
            // Overridden
        };
        /**
         * Returns the string "Light".
         */
        Light.prototype.getClassName = function () {
            return "Light";
        };
        /**
         * @param {boolean} fullDetails - support for multiple levels of logging within scene loading
         */
        Light.prototype.toString = function (fullDetails) {
            var ret = "Name: " + this.name;
            ret += ", type: " + (["Point", "Directional", "Spot", "Hemispheric"])[this.getTypeID()];
            if (this.animations) {
                for (var i = 0; i < this.animations.length; i++) {
                    ret += ", animation[0]: " + this.animations[i].toString(fullDetails);
                }
            }
            if (fullDetails) {
            }
            return ret;
        };
        /**
         * Set the enabled state of this node.
         * @param {boolean} value - the new enabled state
         * @see isEnabled
         */
        Light.prototype.setEnabled = function (value) {
            _super.prototype.setEnabled.call(this, value);
            this._resyncMeshes();
        };
        /**
         * Returns the Light associated shadow generator.
         */
        Light.prototype.getShadowGenerator = function () {
            return this._shadowGenerator;
        };
        /**
         * Returns a Vector3, the absolute light position in the World.
         */
        Light.prototype.getAbsolutePosition = function () {
            return BABYLON.Vector3.Zero();
        };
        Light.prototype.transferToEffect = function (effect, lightIndex) {
        };
        Light.prototype._getWorldMatrix = function () {
            return BABYLON.Matrix.Identity();
        };
        /**
         * Boolean : True if the light will affect the passed mesh.
         */
        Light.prototype.canAffectMesh = function (mesh) {
            if (!mesh) {
                return true;
            }
            if (this.includedOnlyMeshes && this.includedOnlyMeshes.length > 0 && this.includedOnlyMeshes.indexOf(mesh) === -1) {
                return false;
            }
            if (this.excludedMeshes && this.excludedMeshes.length > 0 && this.excludedMeshes.indexOf(mesh) !== -1) {
                return false;
            }
            if (this.includeOnlyWithLayerMask !== 0 && (this.includeOnlyWithLayerMask & mesh.layerMask) === 0) {
                return false;
            }
            if (this.excludeWithLayerMask !== 0 && this.excludeWithLayerMask & mesh.layerMask) {
                return false;
            }
            return true;
        };
        /**
         * Returns the light World matrix.
         */
        Light.prototype.getWorldMatrix = function () {
            this._currentRenderId = this.getScene().getRenderId();
            var worldMatrix = this._getWorldMatrix();
            if (this.parent && this.parent.getWorldMatrix) {
                if (!this._parentedWorldMatrix) {
                    this._parentedWorldMatrix = BABYLON.Matrix.Identity();
                }
                worldMatrix.multiplyToRef(this.parent.getWorldMatrix(), this._parentedWorldMatrix);
                this._markSyncedWithParent();
                return this._parentedWorldMatrix;
            }
            return worldMatrix;
        };
        /**
         * Sort function to order lights for rendering.
         * @param a First Light object to compare to second.
         * @param b Second Light object to compare first.
         * @return -1 to reduce's a's index relative to be, 0 for no change, 1 to increase a's index relative to b.
         */
        Light.compareLightsPriority = function (a, b) {
            //shadow-casting lights have priority over non-shadow-casting lights
            //the renderPrioirty is a secondary sort criterion
            if (a.shadowEnabled !== b.shadowEnabled) {
                return (b.shadowEnabled ? 1 : 0) - (a.shadowEnabled ? 1 : 0);
            }
            return b.renderPriority - a.renderPriority;
        };
        /**
         * Disposes the light.
         */
        Light.prototype.dispose = function () {
            if (this._shadowGenerator) {
                this._shadowGenerator.dispose();
                this._shadowGenerator = null;
            }
            // Animations
            this.getScene().stopAnimation(this);
            // Remove from meshes
            for (var _i = 0, _a = this.getScene().meshes; _i < _a.length; _i++) {
                var mesh = _a[_i];
                mesh._removeLightSource(this);
            }
            this._uniformBuffer.dispose();
            // Remove from scene
            this.getScene().removeLight(this);
            _super.prototype.dispose.call(this);
        };
        /**
         * Returns the light type ID (integer).
         */
        Light.prototype.getTypeID = function () {
            return 0;
        };
        /**
         * Returns the intensity scaled by the Photometric Scale according to the light type and intensity mode.
         */
        Light.prototype.getScaledIntensity = function () {
            return this._photometricScale * this.intensity;
        };
        /**
         * Returns a new Light object, named "name", from the current one.
         */
        Light.prototype.clone = function (name) {
            var constructor = Light.GetConstructorFromName(this.getTypeID(), name, this.getScene());
            if (!constructor) {
                return null;
            }
            return BABYLON.SerializationHelper.Clone(constructor, this);
        };
        /**
         * Serializes the current light into a Serialization object.
         * Returns the serialized object.
         */
        Light.prototype.serialize = function () {
            var serializationObject = BABYLON.SerializationHelper.Serialize(this);
            // Type
            serializationObject.type = this.getTypeID();
            // Parent
            if (this.parent) {
                serializationObject.parentId = this.parent.id;
            }
            // Inclusion / exclusions
            if (this.excludedMeshes.length > 0) {
                serializationObject.excludedMeshesIds = [];
                this.excludedMeshes.forEach(function (mesh) {
                    serializationObject.excludedMeshesIds.push(mesh.id);
                });
            }
            if (this.includedOnlyMeshes.length > 0) {
                serializationObject.includedOnlyMeshesIds = [];
                this.includedOnlyMeshes.forEach(function (mesh) {
                    serializationObject.includedOnlyMeshesIds.push(mesh.id);
                });
            }
            // Animations  
            BABYLON.Animation.AppendSerializedAnimations(this, serializationObject);
            serializationObject.ranges = this.serializeAnimationRanges();
            return serializationObject;
        };
        /**
         * Creates a new typed light from the passed type (integer) : point light = 0, directional light = 1, spot light = 2, hemispheric light = 3.
         * This new light is named "name" and added to the passed scene.
         */
        Light.GetConstructorFromName = function (type, name, scene) {
            switch (type) {
                case 0:
                    return function () { return new BABYLON.PointLight(name, BABYLON.Vector3.Zero(), scene); };
                case 1:
                    return function () { return new BABYLON.DirectionalLight(name, BABYLON.Vector3.Zero(), scene); };
                case 2:
                    return function () { return new BABYLON.SpotLight(name, BABYLON.Vector3.Zero(), BABYLON.Vector3.Zero(), 0, 0, scene); };
                case 3:
                    return function () { return new BABYLON.HemisphericLight(name, BABYLON.Vector3.Zero(), scene); };
            }
            return null;
        };
        /**
         * Parses the passed "parsedLight" and returns a new instanced Light from this parsing.
         */
        Light.Parse = function (parsedLight, scene) {
            var constructor = Light.GetConstructorFromName(parsedLight.type, parsedLight.name, scene);
            if (!constructor) {
                return null;
            }
            var light = BABYLON.SerializationHelper.Parse(constructor, parsedLight, scene);
            // Inclusion / exclusions
            if (parsedLight.excludedMeshesIds) {
                light._excludedMeshesIds = parsedLight.excludedMeshesIds;
            }
            if (parsedLight.includedOnlyMeshesIds) {
                light._includedOnlyMeshesIds = parsedLight.includedOnlyMeshesIds;
            }
            // Parent
            if (parsedLight.parentId) {
                light._waitingParentId = parsedLight.parentId;
            }
            // Animations
            if (parsedLight.animations) {
                for (var animationIndex = 0; animationIndex < parsedLight.animations.length; animationIndex++) {
                    var parsedAnimation = parsedLight.animations[animationIndex];
                    light.animations.push(BABYLON.Animation.Parse(parsedAnimation));
                }
                BABYLON.Node.ParseAnimationRanges(light, parsedLight, scene);
            }
            if (parsedLight.autoAnimate) {
                scene.beginAnimation(light, parsedLight.autoAnimateFrom, parsedLight.autoAnimateTo, parsedLight.autoAnimateLoop, parsedLight.autoAnimateSpeed || 1.0);
            }
            return light;
        };
        Light.prototype._hookArrayForExcluded = function (array) {
            var _this = this;
            var oldPush = array.push;
            array.push = function () {
                var items = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    items[_i] = arguments[_i];
                }
                var result = oldPush.apply(array, items);
                for (var _a = 0, items_1 = items; _a < items_1.length; _a++) {
                    var item = items_1[_a];
                    item._resyncLighSource(_this);
                }
                return result;
            };
            var oldSplice = array.splice;
            array.splice = function (index, deleteCount) {
                var deleted = oldSplice.apply(array, [index, deleteCount]);
                for (var _i = 0, deleted_1 = deleted; _i < deleted_1.length; _i++) {
                    var item = deleted_1[_i];
                    item._resyncLighSource(_this);
                }
                return deleted;
            };
            for (var _i = 0, array_1 = array; _i < array_1.length; _i++) {
                var item = array_1[_i];
                item._resyncLighSource(this);
            }
        };
        Light.prototype._hookArrayForIncludedOnly = function (array) {
            var _this = this;
            var oldPush = array.push;
            array.push = function () {
                var items = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    items[_i] = arguments[_i];
                }
                var result = oldPush.apply(array, items);
                _this._resyncMeshes();
                return result;
            };
            var oldSplice = array.splice;
            array.splice = function (index, deleteCount) {
                var deleted = oldSplice.apply(array, [index, deleteCount]);
                _this._resyncMeshes();
                return deleted;
            };
            this._resyncMeshes();
        };
        Light.prototype._resyncMeshes = function () {
            for (var _i = 0, _a = this.getScene().meshes; _i < _a.length; _i++) {
                var mesh = _a[_i];
                mesh._resyncLighSource(this);
            }
        };
        Light.prototype._markMeshesAsLightDirty = function () {
            for (var _i = 0, _a = this.getScene().meshes; _i < _a.length; _i++) {
                var mesh = _a[_i];
                if (mesh._lightSources.indexOf(this) !== -1) {
                    mesh._markSubMeshesAsLightDirty();
                }
            }
        };
        /**
         * Recomputes the cached photometric scale if needed.
         */
        Light.prototype._computePhotometricScale = function () {
            this._photometricScale = this._getPhotometricScale();
            this.getScene().resetCachedMaterial();
        };
        /**
         * Returns the Photometric Scale according to the light type and intensity mode.
         */
        Light.prototype._getPhotometricScale = function () {
            var photometricScale = 0.0;
            var lightTypeID = this.getTypeID();
            //get photometric mode
            var photometricMode = this.intensityMode;
            if (photometricMode === Light.INTENSITYMODE_AUTOMATIC) {
                if (lightTypeID === Light.LIGHTTYPEID_DIRECTIONALLIGHT) {
                    photometricMode = Light.INTENSITYMODE_ILLUMINANCE;
                }
                else {
                    photometricMode = Light.INTENSITYMODE_LUMINOUSINTENSITY;
                }
            }
            //compute photometric scale
            switch (lightTypeID) {
                case Light.LIGHTTYPEID_POINTLIGHT:
                case Light.LIGHTTYPEID_SPOTLIGHT:
                    switch (photometricMode) {
                        case Light.INTENSITYMODE_LUMINOUSPOWER:
                            photometricScale = 1.0 / (4.0 * Math.PI);
                            break;
                        case Light.INTENSITYMODE_LUMINOUSINTENSITY:
                            photometricScale = 1.0;
                            break;
                        case Light.INTENSITYMODE_LUMINANCE:
                            photometricScale = this.radius * this.radius;
                            break;
                    }
                    break;
                case Light.LIGHTTYPEID_DIRECTIONALLIGHT:
                    switch (photometricMode) {
                        case Light.INTENSITYMODE_ILLUMINANCE:
                            photometricScale = 1.0;
                            break;
                        case Light.INTENSITYMODE_LUMINANCE:
                            // When radius (and therefore solid angle) is non-zero a directional lights brightness can be specified via central (peak) luminance.
                            // For a directional light the 'radius' defines the angular radius (in radians) rather than world-space radius (e.g. in metres).
                            var apexAngleRadians = this.radius;
                            // Impose a minimum light angular size to avoid the light becoming an infinitely small angular light source (i.e. a dirac delta function).
                            apexAngleRadians = Math.max(apexAngleRadians, 0.001);
                            var solidAngle = 2.0 * Math.PI * (1.0 - Math.cos(apexAngleRadians));
                            photometricScale = solidAngle;
                            break;
                    }
                    break;
                case Light.LIGHTTYPEID_HEMISPHERICLIGHT:
                    // No fall off in hemisperic light.
                    photometricScale = 1.0;
                    break;
            }
            return photometricScale;
        };
        Light.prototype._reorderLightsInScene = function () {
            var scene = this.getScene();
            if (this._renderPriority != 0) {
                scene.requireLightSorting = true;
            }
            this.getScene().sortLightsByPriority();
        };
        //lightmapMode Consts
        Light._LIGHTMAP_DEFAULT = 0;
        Light._LIGHTMAP_SPECULAR = 1;
        Light._LIGHTMAP_SHADOWSONLY = 2;
        // Intensity Mode Consts
        Light._INTENSITYMODE_AUTOMATIC = 0;
        Light._INTENSITYMODE_LUMINOUSPOWER = 1;
        Light._INTENSITYMODE_LUMINOUSINTENSITY = 2;
        Light._INTENSITYMODE_ILLUMINANCE = 3;
        Light._INTENSITYMODE_LUMINANCE = 4;
        // Light types ids const.
        Light._LIGHTTYPEID_POINTLIGHT = 0;
        Light._LIGHTTYPEID_DIRECTIONALLIGHT = 1;
        Light._LIGHTTYPEID_SPOTLIGHT = 2;
        Light._LIGHTTYPEID_HEMISPHERICLIGHT = 3;
        __decorate([
            BABYLON.serializeAsColor3()
        ], Light.prototype, "diffuse", void 0);
        __decorate([
            BABYLON.serializeAsColor3()
        ], Light.prototype, "specular", void 0);
        __decorate([
            BABYLON.serialize()
        ], Light.prototype, "intensity", void 0);
        __decorate([
            BABYLON.serialize()
        ], Light.prototype, "range", void 0);
        __decorate([
            BABYLON.serialize()
        ], Light.prototype, "intensityMode", null);
        __decorate([
            BABYLON.serialize()
        ], Light.prototype, "radius", null);
        __decorate([
            BABYLON.serialize()
        ], Light.prototype, "_renderPriority", void 0);
        __decorate([
            BABYLON.expandToProperty("_reorderLightsInScene")
        ], Light.prototype, "renderPriority", void 0);
        __decorate([
            BABYLON.serialize()
        ], Light.prototype, "shadowEnabled", void 0);
        __decorate([
            BABYLON.serialize("excludeWithLayerMask")
        ], Light.prototype, "_excludeWithLayerMask", void 0);
        __decorate([
            BABYLON.serialize("includeOnlyWithLayerMask")
        ], Light.prototype, "_includeOnlyWithLayerMask", void 0);
        __decorate([
            BABYLON.serialize("lightmapMode")
        ], Light.prototype, "_lightmapMode", void 0);
        return Light;
    }(BABYLON.Node));
    BABYLON.Light = Light;
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.light.js.map







var BABYLON;
(function (BABYLON) {
    var Camera = /** @class */ (function (_super) {
        __extends(Camera, _super);
        function Camera(name, position, scene) {
            var _this = _super.call(this, name, scene) || this;
            _this.upVector = BABYLON.Vector3.Up();
            _this.orthoLeft = null;
            _this.orthoRight = null;
            _this.orthoBottom = null;
            _this.orthoTop = null;
            _this.fov = 0.8;
            _this.minZ = 1;
            _this.maxZ = 10000.0;
            _this.inertia = 0.9;
            _this.mode = Camera.PERSPECTIVE_CAMERA;
            _this.isIntermediate = false;
            _this.viewport = new BABYLON.Viewport(0, 0, 1.0, 1.0);
            _this.layerMask = 0x0FFFFFFF;
            _this.fovMode = Camera.FOVMODE_VERTICAL_FIXED;
            // Camera rig members
            _this.cameraRigMode = Camera.RIG_MODE_NONE;
            _this._rigCameras = new Array();
            _this._webvrViewMatrix = BABYLON.Matrix.Identity();
            _this._skipRendering = false;
            _this.customRenderTargets = new Array();
            // Observables
            _this.onViewMatrixChangedObservable = new BABYLON.Observable();
            _this.onProjectionMatrixChangedObservable = new BABYLON.Observable();
            _this.onAfterCheckInputsObservable = new BABYLON.Observable();
            _this.onRestoreStateObservable = new BABYLON.Observable();
            // Cache
            _this._computedViewMatrix = BABYLON.Matrix.Identity();
            _this._projectionMatrix = new BABYLON.Matrix();
            _this._doNotComputeProjectionMatrix = false;
            _this._postProcesses = new Array();
            _this._transformMatrix = BABYLON.Matrix.Zero();
            _this._activeMeshes = new BABYLON.SmartArray(256);
            _this._globalPosition = BABYLON.Vector3.Zero();
            _this._refreshFrustumPlanes = true;
            _this.getScene().addCamera(_this);
            if (!_this.getScene().activeCamera) {
                _this.getScene().activeCamera = _this;
            }
            _this.position = position;
            return _this;
        }
        Object.defineProperty(Camera, "PERSPECTIVE_CAMERA", {
            get: function () {
                return Camera._PERSPECTIVE_CAMERA;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Camera, "ORTHOGRAPHIC_CAMERA", {
            get: function () {
                return Camera._ORTHOGRAPHIC_CAMERA;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Camera, "FOVMODE_VERTICAL_FIXED", {
            get: function () {
                return Camera._FOVMODE_VERTICAL_FIXED;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Camera, "FOVMODE_HORIZONTAL_FIXED", {
            get: function () {
                return Camera._FOVMODE_HORIZONTAL_FIXED;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Camera, "RIG_MODE_NONE", {
            get: function () {
                return Camera._RIG_MODE_NONE;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Camera, "RIG_MODE_STEREOSCOPIC_ANAGLYPH", {
            get: function () {
                return Camera._RIG_MODE_STEREOSCOPIC_ANAGLYPH;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Camera, "RIG_MODE_STEREOSCOPIC_SIDEBYSIDE_PARALLEL", {
            get: function () {
                return Camera._RIG_MODE_STEREOSCOPIC_SIDEBYSIDE_PARALLEL;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Camera, "RIG_MODE_STEREOSCOPIC_SIDEBYSIDE_CROSSEYED", {
            get: function () {
                return Camera._RIG_MODE_STEREOSCOPIC_SIDEBYSIDE_CROSSEYED;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Camera, "RIG_MODE_STEREOSCOPIC_OVERUNDER", {
            get: function () {
                return Camera._RIG_MODE_STEREOSCOPIC_OVERUNDER;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Camera, "RIG_MODE_VR", {
            get: function () {
                return Camera._RIG_MODE_VR;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Camera, "RIG_MODE_WEBVR", {
            get: function () {
                return Camera._RIG_MODE_WEBVR;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * Store current camera state (fov, position, etc..)
         */
        Camera.prototype.storeState = function () {
            this._stateStored = true;
            this._storedFov = this.fov;
            return this;
        };
        /**
         * Restores the camera state values if it has been stored. You must call storeState() first
         */
        Camera.prototype._restoreStateValues = function () {
            if (!this._stateStored) {
                return false;
            }
            this.fov = this._storedFov;
            return true;
        };
        /**
         * Restored camera state. You must call storeState() first
         */
        Camera.prototype.restoreState = function () {
            if (this._restoreStateValues()) {
                this.onRestoreStateObservable.notifyObservers(this);
                return true;
            }
            return false;
        };
        Camera.prototype.getClassName = function () {
            return "Camera";
        };
        /**
         * @param {boolean} fullDetails - support for multiple levels of logging within scene loading
         */
        Camera.prototype.toString = function (fullDetails) {
            var ret = "Name: " + this.name;
            ret += ", type: " + this.getClassName();
            if (this.animations) {
                for (var i = 0; i < this.animations.length; i++) {
                    ret += ", animation[0]: " + this.animations[i].toString(fullDetails);
                }
            }
            if (fullDetails) {
            }
            return ret;
        };
        Object.defineProperty(Camera.prototype, "globalPosition", {
            get: function () {
                return this._globalPosition;
            },
            enumerable: true,
            configurable: true
        });
        Camera.prototype.getActiveMeshes = function () {
            return this._activeMeshes;
        };
        Camera.prototype.isActiveMesh = function (mesh) {
            return (this._activeMeshes.indexOf(mesh) !== -1);
        };
        //Cache
        Camera.prototype._initCache = function () {
            _super.prototype._initCache.call(this);
            this._cache.position = new BABYLON.Vector3(Number.MAX_VALUE, Number.MAX_VALUE, Number.MAX_VALUE);
            this._cache.upVector = new BABYLON.Vector3(Number.MAX_VALUE, Number.MAX_VALUE, Number.MAX_VALUE);
            this._cache.mode = undefined;
            this._cache.minZ = undefined;
            this._cache.maxZ = undefined;
            this._cache.fov = undefined;
            this._cache.fovMode = undefined;
            this._cache.aspectRatio = undefined;
            this._cache.orthoLeft = undefined;
            this._cache.orthoRight = undefined;
            this._cache.orthoBottom = undefined;
            this._cache.orthoTop = undefined;
            this._cache.renderWidth = undefined;
            this._cache.renderHeight = undefined;
        };
        Camera.prototype._updateCache = function (ignoreParentClass) {
            if (!ignoreParentClass) {
                _super.prototype._updateCache.call(this);
            }
            this._cache.position.copyFrom(this.position);
            this._cache.upVector.copyFrom(this.upVector);
        };
        // Synchronized
        Camera.prototype._isSynchronized = function () {
            return this._isSynchronizedViewMatrix() && this._isSynchronizedProjectionMatrix();
        };
        Camera.prototype._isSynchronizedViewMatrix = function () {
            if (!_super.prototype._isSynchronized.call(this))
                return false;
            return this._cache.position.equals(this.position)
                && this._cache.upVector.equals(this.upVector)
                && this.isSynchronizedWithParent();
        };
        Camera.prototype._isSynchronizedProjectionMatrix = function () {
            var check = this._cache.mode === this.mode
                && this._cache.minZ === this.minZ
                && this._cache.maxZ === this.maxZ;
            if (!check) {
                return false;
            }
            var engine = this.getEngine();
            if (this.mode === Camera.PERSPECTIVE_CAMERA) {
                check = this._cache.fov === this.fov
                    && this._cache.fovMode === this.fovMode
                    && this._cache.aspectRatio === engine.getAspectRatio(this);
            }
            else {
                check = this._cache.orthoLeft === this.orthoLeft
                    && this._cache.orthoRight === this.orthoRight
                    && this._cache.orthoBottom === this.orthoBottom
                    && this._cache.orthoTop === this.orthoTop
                    && this._cache.renderWidth === engine.getRenderWidth()
                    && this._cache.renderHeight === engine.getRenderHeight();
            }
            return check;
        };
        // Controls
        Camera.prototype.attachControl = function (element, noPreventDefault) {
        };
        Camera.prototype.detachControl = function (element) {
        };
        Camera.prototype.update = function () {
            this._checkInputs();
            if (this.cameraRigMode !== Camera.RIG_MODE_NONE) {
                this._updateRigCameras();
            }
        };
        Camera.prototype._checkInputs = function () {
            this.onAfterCheckInputsObservable.notifyObservers(this);
        };
        Object.defineProperty(Camera.prototype, "rigCameras", {
            get: function () {
                return this._rigCameras;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Camera.prototype, "rigPostProcess", {
            get: function () {
                return this._rigPostProcess;
            },
            enumerable: true,
            configurable: true
        });
        Camera.prototype._cascadePostProcessesToRigCams = function () {
            // invalidate framebuffer
            if (this._postProcesses.length > 0) {
                this._postProcesses[0].markTextureDirty();
            }
            // glue the rigPostProcess to the end of the user postprocesses & assign to each sub-camera
            for (var i = 0, len = this._rigCameras.length; i < len; i++) {
                var cam = this._rigCameras[i];
                var rigPostProcess = cam._rigPostProcess;
                // for VR rig, there does not have to be a post process 
                if (rigPostProcess) {
                    var isPass = rigPostProcess instanceof BABYLON.PassPostProcess;
                    if (isPass) {
                        // any rig which has a PassPostProcess for rig[0], cannot be isIntermediate when there are also user postProcesses
                        cam.isIntermediate = this._postProcesses.length === 0;
                    }
                    cam._postProcesses = this._postProcesses.slice(0).concat(rigPostProcess);
                    rigPostProcess.markTextureDirty();
                }
                else {
                    cam._postProcesses = this._postProcesses.slice(0);
                }
            }
        };
        Camera.prototype.attachPostProcess = function (postProcess, insertAt) {
            if (insertAt === void 0) { insertAt = null; }
            if (!postProcess.isReusable() && this._postProcesses.indexOf(postProcess) > -1) {
                BABYLON.Tools.Error("You're trying to reuse a post process not defined as reusable.");
                return 0;
            }
            if (insertAt == null || insertAt < 0) {
                this._postProcesses.push(postProcess);
            }
            else {
                this._postProcesses.splice(insertAt, 0, postProcess);
            }
            this._cascadePostProcessesToRigCams(); // also ensures framebuffer invalidated            
            return this._postProcesses.indexOf(postProcess);
        };
        Camera.prototype.detachPostProcess = function (postProcess) {
            var idx = this._postProcesses.indexOf(postProcess);
            if (idx !== -1) {
                this._postProcesses.splice(idx, 1);
            }
            this._cascadePostProcessesToRigCams(); // also ensures framebuffer invalidated
        };
        Camera.prototype.getWorldMatrix = function () {
            if (!this._worldMatrix) {
                this._worldMatrix = BABYLON.Matrix.Identity();
            }
            var viewMatrix = this.getViewMatrix();
            viewMatrix.invertToRef(this._worldMatrix);
            return this._worldMatrix;
        };
        Camera.prototype._getViewMatrix = function () {
            return BABYLON.Matrix.Identity();
        };
        Camera.prototype.getViewMatrix = function (force) {
            if (!force && this._isSynchronizedViewMatrix()) {
                return this._computedViewMatrix;
            }
            this.updateCache();
            this._computedViewMatrix = this._getViewMatrix();
            this._currentRenderId = this.getScene().getRenderId();
            this._refreshFrustumPlanes = true;
            if (!this.parent || !this.parent.getWorldMatrix) {
                this._globalPosition.copyFrom(this.position);
            }
            else {
                if (!this._worldMatrix) {
                    this._worldMatrix = BABYLON.Matrix.Identity();
                }
                this._computedViewMatrix.invertToRef(this._worldMatrix);
                this._worldMatrix.multiplyToRef(this.parent.getWorldMatrix(), this._computedViewMatrix);
                this._globalPosition.copyFromFloats(this._computedViewMatrix.m[12], this._computedViewMatrix.m[13], this._computedViewMatrix.m[14]);
                this._computedViewMatrix.invert();
                this._markSyncedWithParent();
            }
            if (this._cameraRigParams && this._cameraRigParams.vrPreViewMatrix) {
                this._computedViewMatrix.multiplyToRef(this._cameraRigParams.vrPreViewMatrix, this._computedViewMatrix);
            }
            this.onViewMatrixChangedObservable.notifyObservers(this);
            return this._computedViewMatrix;
        };
        Camera.prototype.freezeProjectionMatrix = function (projection) {
            this._doNotComputeProjectionMatrix = true;
            if (projection !== undefined) {
                this._projectionMatrix = projection;
            }
        };
        ;
        Camera.prototype.unfreezeProjectionMatrix = function () {
            this._doNotComputeProjectionMatrix = false;
        };
        ;
        Camera.prototype.getProjectionMatrix = function (force) {
            if (this._doNotComputeProjectionMatrix || (!force && this._isSynchronizedProjectionMatrix())) {
                return this._projectionMatrix;
            }
            // Cache
            this._cache.mode = this.mode;
            this._cache.minZ = this.minZ;
            this._cache.maxZ = this.maxZ;
            // Matrix
            this._refreshFrustumPlanes = true;
            var engine = this.getEngine();
            var scene = this.getScene();
            if (this.mode === Camera.PERSPECTIVE_CAMERA) {
                this._cache.fov = this.fov;
                this._cache.fovMode = this.fovMode;
                this._cache.aspectRatio = engine.getAspectRatio(this);
                if (this.minZ <= 0) {
                    this.minZ = 0.1;
                }
                if (scene.useRightHandedSystem) {
                    BABYLON.Matrix.PerspectiveFovRHToRef(this.fov, engine.getAspectRatio(this), this.minZ, this.maxZ, this._projectionMatrix, this.fovMode === Camera.FOVMODE_VERTICAL_FIXED);
                }
                else {
                    BABYLON.Matrix.PerspectiveFovLHToRef(this.fov, engine.getAspectRatio(this), this.minZ, this.maxZ, this._projectionMatrix, this.fovMode === Camera.FOVMODE_VERTICAL_FIXED);
                }
            }
            else {
                var halfWidth = engine.getRenderWidth() / 2.0;
                var halfHeight = engine.getRenderHeight() / 2.0;
                if (scene.useRightHandedSystem) {
                    BABYLON.Matrix.OrthoOffCenterRHToRef(this.orthoLeft || -halfWidth, this.orthoRight || halfWidth, this.orthoBottom || -halfHeight, this.orthoTop || halfHeight, this.minZ, this.maxZ, this._projectionMatrix);
                }
                else {
                    BABYLON.Matrix.OrthoOffCenterLHToRef(this.orthoLeft || -halfWidth, this.orthoRight || halfWidth, this.orthoBottom || -halfHeight, this.orthoTop || halfHeight, this.minZ, this.maxZ, this._projectionMatrix);
                }
                this._cache.orthoLeft = this.orthoLeft;
                this._cache.orthoRight = this.orthoRight;
                this._cache.orthoBottom = this.orthoBottom;
                this._cache.orthoTop = this.orthoTop;
                this._cache.renderWidth = engine.getRenderWidth();
                this._cache.renderHeight = engine.getRenderHeight();
            }
            this.onProjectionMatrixChangedObservable.notifyObservers(this);
            return this._projectionMatrix;
        };
        Camera.prototype.getTranformationMatrix = function () {
            this._computedViewMatrix.multiplyToRef(this._projectionMatrix, this._transformMatrix);
            return this._transformMatrix;
        };
        Camera.prototype.updateFrustumPlanes = function () {
            if (!this._refreshFrustumPlanes) {
                return;
            }
            this.getTranformationMatrix();
            if (!this._frustumPlanes) {
                this._frustumPlanes = BABYLON.Frustum.GetPlanes(this._transformMatrix);
            }
            else {
                BABYLON.Frustum.GetPlanesToRef(this._transformMatrix, this._frustumPlanes);
            }
            this._refreshFrustumPlanes = false;
        };
        Camera.prototype.isInFrustum = function (target) {
            this.updateFrustumPlanes();
            return target.isInFrustum(this._frustumPlanes);
        };
        Camera.prototype.isCompletelyInFrustum = function (target) {
            this.updateFrustumPlanes();
            return target.isCompletelyInFrustum(this._frustumPlanes);
        };
        Camera.prototype.getForwardRay = function (length, transform, origin) {
            if (length === void 0) { length = 100; }
            if (!transform) {
                transform = this.getWorldMatrix();
            }
            if (!origin) {
                origin = this.position;
            }
            var forward = new BABYLON.Vector3(0, 0, 1);
            var forwardWorld = BABYLON.Vector3.TransformNormal(forward, transform);
            var direction = BABYLON.Vector3.Normalize(forwardWorld);
            return new BABYLON.Ray(origin, direction, length);
        };
        Camera.prototype.dispose = function () {
            // Observables
            this.onViewMatrixChangedObservable.clear();
            this.onProjectionMatrixChangedObservable.clear();
            this.onAfterCheckInputsObservable.clear();
            this.onRestoreStateObservable.clear();
            // Inputs
            if (this.inputs) {
                this.inputs.clear();
            }
            // Animations
            this.getScene().stopAnimation(this);
            // Remove from scene
            this.getScene().removeCamera(this);
            while (this._rigCameras.length > 0) {
                var camera = this._rigCameras.pop();
                if (camera) {
                    camera.dispose();
                }
            }
            // Postprocesses
            if (this._rigPostProcess) {
                this._rigPostProcess.dispose(this);
                this._rigPostProcess = null;
                this._postProcesses = [];
            }
            else if (this.cameraRigMode !== Camera.RIG_MODE_NONE) {
                this._rigPostProcess = null;
                this._postProcesses = [];
            }
            else {
                var i = this._postProcesses.length;
                while (--i >= 0) {
                    this._postProcesses[i].dispose(this);
                }
            }
            // Render targets
            var i = this.customRenderTargets.length;
            while (--i >= 0) {
                this.customRenderTargets[i].dispose();
            }
            this.customRenderTargets = [];
            // Active Meshes
            this._activeMeshes.dispose();
            _super.prototype.dispose.call(this);
        };
        Object.defineProperty(Camera.prototype, "leftCamera", {
            // ---- Camera rigs section ----
            get: function () {
                if (this._rigCameras.length < 1) {
                    return null;
                }
                return this._rigCameras[0];
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Camera.prototype, "rightCamera", {
            get: function () {
                if (this._rigCameras.length < 2) {
                    return null;
                }
                return this._rigCameras[1];
            },
            enumerable: true,
            configurable: true
        });
        Camera.prototype.getLeftTarget = function () {
            if (this._rigCameras.length < 1) {
                return null;
            }
            return this._rigCameras[0].getTarget();
        };
        Camera.prototype.getRightTarget = function () {
            if (this._rigCameras.length < 2) {
                return null;
            }
            return this._rigCameras[1].getTarget();
        };
        Camera.prototype.setCameraRigMode = function (mode, rigParams) {
            if (this.cameraRigMode === mode) {
                return;
            }
            while (this._rigCameras.length > 0) {
                var camera = this._rigCameras.pop();
                if (camera) {
                    camera.dispose();
                }
            }
            this.cameraRigMode = mode;
            this._cameraRigParams = {};
            //we have to implement stereo camera calcultating left and right viewpoints from interaxialDistance and target, 
            //not from a given angle as it is now, but until that complete code rewriting provisional stereoHalfAngle value is introduced
            this._cameraRigParams.interaxialDistance = rigParams.interaxialDistance || 0.0637;
            this._cameraRigParams.stereoHalfAngle = BABYLON.Tools.ToRadians(this._cameraRigParams.interaxialDistance / 0.0637);
            // create the rig cameras, unless none
            if (this.cameraRigMode !== Camera.RIG_MODE_NONE) {
                var leftCamera = this.createRigCamera(this.name + "_L", 0);
                var rightCamera = this.createRigCamera(this.name + "_R", 1);
                if (leftCamera && rightCamera) {
                    this._rigCameras.push(leftCamera);
                    this._rigCameras.push(rightCamera);
                }
            }
            switch (this.cameraRigMode) {
                case Camera.RIG_MODE_STEREOSCOPIC_ANAGLYPH:
                    this._rigCameras[0]._rigPostProcess = new BABYLON.PassPostProcess(this.name + "_passthru", 1.0, this._rigCameras[0]);
                    this._rigCameras[1]._rigPostProcess = new BABYLON.AnaglyphPostProcess(this.name + "_anaglyph", 1.0, this._rigCameras);
                    break;
                case Camera.RIG_MODE_STEREOSCOPIC_SIDEBYSIDE_PARALLEL:
                case Camera.RIG_MODE_STEREOSCOPIC_SIDEBYSIDE_CROSSEYED:
                case Camera.RIG_MODE_STEREOSCOPIC_OVERUNDER:
                    var isStereoscopicHoriz = this.cameraRigMode === Camera.RIG_MODE_STEREOSCOPIC_SIDEBYSIDE_PARALLEL || this.cameraRigMode === Camera.RIG_MODE_STEREOSCOPIC_SIDEBYSIDE_CROSSEYED;
                    this._rigCameras[0]._rigPostProcess = new BABYLON.PassPostProcess(this.name + "_passthru", 1.0, this._rigCameras[0]);
                    this._rigCameras[1]._rigPostProcess = new BABYLON.StereoscopicInterlacePostProcess(this.name + "_stereoInterlace", this._rigCameras, isStereoscopicHoriz);
                    break;
                case Camera.RIG_MODE_VR:
                    var metrics = rigParams.vrCameraMetrics || BABYLON.VRCameraMetrics.GetDefault();
                    this._rigCameras[0]._cameraRigParams.vrMetrics = metrics;
                    this._rigCameras[0].viewport = new BABYLON.Viewport(0, 0, 0.5, 1.0);
                    this._rigCameras[0]._cameraRigParams.vrWorkMatrix = new BABYLON.Matrix();
                    this._rigCameras[0]._cameraRigParams.vrHMatrix = metrics.leftHMatrix;
                    this._rigCameras[0]._cameraRigParams.vrPreViewMatrix = metrics.leftPreViewMatrix;
                    this._rigCameras[0].getProjectionMatrix = this._rigCameras[0]._getVRProjectionMatrix;
                    this._rigCameras[1]._cameraRigParams.vrMetrics = metrics;
                    this._rigCameras[1].viewport = new BABYLON.Viewport(0.5, 0, 0.5, 1.0);
                    this._rigCameras[1]._cameraRigParams.vrWorkMatrix = new BABYLON.Matrix();
                    this._rigCameras[1]._cameraRigParams.vrHMatrix = metrics.rightHMatrix;
                    this._rigCameras[1]._cameraRigParams.vrPreViewMatrix = metrics.rightPreViewMatrix;
                    this._rigCameras[1].getProjectionMatrix = this._rigCameras[1]._getVRProjectionMatrix;
                    if (metrics.compensateDistortion) {
                        this._rigCameras[0]._rigPostProcess = new BABYLON.VRDistortionCorrectionPostProcess("VR_Distort_Compensation_Left", this._rigCameras[0], false, metrics);
                        this._rigCameras[1]._rigPostProcess = new BABYLON.VRDistortionCorrectionPostProcess("VR_Distort_Compensation_Right", this._rigCameras[1], true, metrics);
                    }
                    break;
                case Camera.RIG_MODE_WEBVR:
                    if (rigParams.vrDisplay) {
                        var leftEye = rigParams.vrDisplay.getEyeParameters('left');
                        var rightEye = rigParams.vrDisplay.getEyeParameters('right');
                        //Left eye
                        this._rigCameras[0].viewport = new BABYLON.Viewport(0, 0, 0.5, 1.0);
                        this._rigCameras[0].setCameraRigParameter("left", true);
                        //leaving this for future reference
                        this._rigCameras[0].setCameraRigParameter("specs", rigParams.specs);
                        this._rigCameras[0].setCameraRigParameter("eyeParameters", leftEye);
                        this._rigCameras[0].setCameraRigParameter("frameData", rigParams.frameData);
                        this._rigCameras[0].setCameraRigParameter("parentCamera", rigParams.parentCamera);
                        this._rigCameras[0]._cameraRigParams.vrWorkMatrix = new BABYLON.Matrix();
                        this._rigCameras[0].getProjectionMatrix = this._getWebVRProjectionMatrix;
                        this._rigCameras[0].parent = this;
                        this._rigCameras[0]._getViewMatrix = this._getWebVRViewMatrix;
                        //Right eye
                        this._rigCameras[1].viewport = new BABYLON.Viewport(0.5, 0, 0.5, 1.0);
                        this._rigCameras[1].setCameraRigParameter('eyeParameters', rightEye);
                        this._rigCameras[1].setCameraRigParameter("specs", rigParams.specs);
                        this._rigCameras[1].setCameraRigParameter("frameData", rigParams.frameData);
                        this._rigCameras[1].setCameraRigParameter("parentCamera", rigParams.parentCamera);
                        this._rigCameras[1]._cameraRigParams.vrWorkMatrix = new BABYLON.Matrix();
                        this._rigCameras[1].getProjectionMatrix = this._getWebVRProjectionMatrix;
                        this._rigCameras[1].parent = this;
                        this._rigCameras[1]._getViewMatrix = this._getWebVRViewMatrix;
                        if (Camera.UseAlternateWebVRRendering) {
                            this._rigCameras[1]._skipRendering = true;
                            this._rigCameras[0]._alternateCamera = this._rigCameras[1];
                        }
                    }
                    break;
            }
            this._cascadePostProcessesToRigCams();
            this.update();
        };
        Camera.prototype._getVRProjectionMatrix = function () {
            BABYLON.Matrix.PerspectiveFovLHToRef(this._cameraRigParams.vrMetrics.aspectRatioFov, this._cameraRigParams.vrMetrics.aspectRatio, this.minZ, this.maxZ, this._cameraRigParams.vrWorkMatrix);
            this._cameraRigParams.vrWorkMatrix.multiplyToRef(this._cameraRigParams.vrHMatrix, this._projectionMatrix);
            return this._projectionMatrix;
        };
        Camera.prototype._updateCameraRotationMatrix = function () {
            //Here for WebVR
        };
        Camera.prototype._updateWebVRCameraRotationMatrix = function () {
            //Here for WebVR
        };
        /**
         * This function MUST be overwritten by the different WebVR cameras available.
         * The context in which it is running is the RIG camera. So 'this' is the TargetCamera, left or right.
         */
        Camera.prototype._getWebVRProjectionMatrix = function () {
            return BABYLON.Matrix.Identity();
        };
        /**
         * This function MUST be overwritten by the different WebVR cameras available.
         * The context in which it is running is the RIG camera. So 'this' is the TargetCamera, left or right.
         */
        Camera.prototype._getWebVRViewMatrix = function () {
            return BABYLON.Matrix.Identity();
        };
        Camera.prototype.setCameraRigParameter = function (name, value) {
            if (!this._cameraRigParams) {
                this._cameraRigParams = {};
            }
            this._cameraRigParams[name] = value;
            //provisionnally:
            if (name === "interaxialDistance") {
                this._cameraRigParams.stereoHalfAngle = BABYLON.Tools.ToRadians(value / 0.0637);
            }
        };
        /**
         * needs to be overridden by children so sub has required properties to be copied
         */
        Camera.prototype.createRigCamera = function (name, cameraIndex) {
            return null;
        };
        /**
         * May need to be overridden by children
         */
        Camera.prototype._updateRigCameras = function () {
            for (var i = 0; i < this._rigCameras.length; i++) {
                this._rigCameras[i].minZ = this.minZ;
                this._rigCameras[i].maxZ = this.maxZ;
                this._rigCameras[i].fov = this.fov;
            }
            // only update viewport when ANAGLYPH
            if (this.cameraRigMode === Camera.RIG_MODE_STEREOSCOPIC_ANAGLYPH) {
                this._rigCameras[0].viewport = this._rigCameras[1].viewport = this.viewport;
            }
        };
        Camera.prototype._setupInputs = function () {
        };
        Camera.prototype.serialize = function () {
            var serializationObject = BABYLON.SerializationHelper.Serialize(this);
            // Type
            serializationObject.type = this.getClassName();
            // Parent
            if (this.parent) {
                serializationObject.parentId = this.parent.id;
            }
            if (this.inputs) {
                this.inputs.serialize(serializationObject);
            }
            // Animations
            BABYLON.Animation.AppendSerializedAnimations(this, serializationObject);
            serializationObject.ranges = this.serializeAnimationRanges();
            return serializationObject;
        };
        Camera.prototype.clone = function (name) {
            return BABYLON.SerializationHelper.Clone(Camera.GetConstructorFromName(this.getClassName(), name, this.getScene(), this.interaxialDistance, this.isStereoscopicSideBySide), this);
        };
        Camera.prototype.getDirection = function (localAxis) {
            var result = BABYLON.Vector3.Zero();
            this.getDirectionToRef(localAxis, result);
            return result;
        };
        Camera.prototype.getDirectionToRef = function (localAxis, result) {
            BABYLON.Vector3.TransformNormalToRef(localAxis, this.getWorldMatrix(), result);
        };
        Camera.GetConstructorFromName = function (type, name, scene, interaxial_distance, isStereoscopicSideBySide) {
            if (interaxial_distance === void 0) { interaxial_distance = 0; }
            if (isStereoscopicSideBySide === void 0) { isStereoscopicSideBySide = true; }
            switch (type) {
                case "ArcRotateCamera":
                    return function () { return new BABYLON.ArcRotateCamera(name, 0, 0, 1.0, BABYLON.Vector3.Zero(), scene); };
                case "DeviceOrientationCamera":
                    return function () { return new BABYLON.DeviceOrientationCamera(name, BABYLON.Vector3.Zero(), scene); };
                case "FollowCamera":
                    return function () { return new BABYLON.FollowCamera(name, BABYLON.Vector3.Zero(), scene); };
                case "ArcFollowCamera":
                    return function () { return new BABYLON.ArcFollowCamera(name, 0, 0, 1.0, null, scene); };
                case "GamepadCamera":
                    return function () { return new BABYLON.GamepadCamera(name, BABYLON.Vector3.Zero(), scene); };
                case "TouchCamera":
                    return function () { return new BABYLON.TouchCamera(name, BABYLON.Vector3.Zero(), scene); };
                case "VirtualJoysticksCamera":
                    return function () { return new BABYLON.VirtualJoysticksCamera(name, BABYLON.Vector3.Zero(), scene); };
                case "WebVRFreeCamera":
                    return function () { return new BABYLON.WebVRFreeCamera(name, BABYLON.Vector3.Zero(), scene); };
                case "WebVRGamepadCamera":
                    return function () { return new BABYLON.WebVRFreeCamera(name, BABYLON.Vector3.Zero(), scene); };
                case "VRDeviceOrientationFreeCamera":
                    return function () { return new BABYLON.VRDeviceOrientationFreeCamera(name, BABYLON.Vector3.Zero(), scene); };
                case "VRDeviceOrientationGamepadCamera":
                    return function () { return new BABYLON.VRDeviceOrientationGamepadCamera(name, BABYLON.Vector3.Zero(), scene); };
                case "AnaglyphArcRotateCamera":
                    return function () { return new BABYLON.AnaglyphArcRotateCamera(name, 0, 0, 1.0, BABYLON.Vector3.Zero(), interaxial_distance, scene); };
                case "AnaglyphFreeCamera":
                    return function () { return new BABYLON.AnaglyphFreeCamera(name, BABYLON.Vector3.Zero(), interaxial_distance, scene); };
                case "AnaglyphGamepadCamera":
                    return function () { return new BABYLON.AnaglyphGamepadCamera(name, BABYLON.Vector3.Zero(), interaxial_distance, scene); };
                case "AnaglyphUniversalCamera":
                    return function () { return new BABYLON.AnaglyphUniversalCamera(name, BABYLON.Vector3.Zero(), interaxial_distance, scene); };
                case "StereoscopicArcRotateCamera":
                    return function () { return new BABYLON.StereoscopicArcRotateCamera(name, 0, 0, 1.0, BABYLON.Vector3.Zero(), interaxial_distance, isStereoscopicSideBySide, scene); };
                case "StereoscopicFreeCamera":
                    return function () { return new BABYLON.StereoscopicFreeCamera(name, BABYLON.Vector3.Zero(), interaxial_distance, isStereoscopicSideBySide, scene); };
                case "StereoscopicGamepadCamera":
                    return function () { return new BABYLON.StereoscopicGamepadCamera(name, BABYLON.Vector3.Zero(), interaxial_distance, isStereoscopicSideBySide, scene); };
                case "StereoscopicUniversalCamera":
                    return function () { return new BABYLON.StereoscopicUniversalCamera(name, BABYLON.Vector3.Zero(), interaxial_distance, isStereoscopicSideBySide, scene); };
                case "FreeCamera":// Forcing Universal here
                    return function () { return new BABYLON.UniversalCamera(name, BABYLON.Vector3.Zero(), scene); };
                default:// Universal Camera is the default value
                    return function () { return new BABYLON.UniversalCamera(name, BABYLON.Vector3.Zero(), scene); };
            }
        };
        Camera.prototype.computeWorldMatrix = function () {
            return this.getWorldMatrix();
        };
        Camera.Parse = function (parsedCamera, scene) {
            var type = parsedCamera.type;
            var construct = Camera.GetConstructorFromName(type, parsedCamera.name, scene, parsedCamera.interaxial_distance, parsedCamera.isStereoscopicSideBySide);
            var camera = BABYLON.SerializationHelper.Parse(construct, parsedCamera, scene);
            // Parent
            if (parsedCamera.parentId) {
                camera._waitingParentId = parsedCamera.parentId;
            }
            //If camera has an input manager, let it parse inputs settings
            if (camera.inputs) {
                camera.inputs.parse(parsedCamera);
                camera._setupInputs();
            }
            if (camera.setPosition) {
                camera.position.copyFromFloats(0, 0, 0);
                camera.setPosition(BABYLON.Vector3.FromArray(parsedCamera.position));
            }
            // Target
            if (parsedCamera.target) {
                if (camera.setTarget) {
                    camera.setTarget(BABYLON.Vector3.FromArray(parsedCamera.target));
                }
            }
            // Apply 3d rig, when found
            if (parsedCamera.cameraRigMode) {
                var rigParams = (parsedCamera.interaxial_distance) ? { interaxialDistance: parsedCamera.interaxial_distance } : {};
                camera.setCameraRigMode(parsedCamera.cameraRigMode, rigParams);
            }
            // Animations
            if (parsedCamera.animations) {
                for (var animationIndex = 0; animationIndex < parsedCamera.animations.length; animationIndex++) {
                    var parsedAnimation = parsedCamera.animations[animationIndex];
                    camera.animations.push(BABYLON.Animation.Parse(parsedAnimation));
                }
                BABYLON.Node.ParseAnimationRanges(camera, parsedCamera, scene);
            }
            if (parsedCamera.autoAnimate) {
                scene.beginAnimation(camera, parsedCamera.autoAnimateFrom, parsedCamera.autoAnimateTo, parsedCamera.autoAnimateLoop, parsedCamera.autoAnimateSpeed || 1.0);
            }
            return camera;
        };
        // Statics
        Camera._PERSPECTIVE_CAMERA = 0;
        Camera._ORTHOGRAPHIC_CAMERA = 1;
        Camera._FOVMODE_VERTICAL_FIXED = 0;
        Camera._FOVMODE_HORIZONTAL_FIXED = 1;
        Camera._RIG_MODE_NONE = 0;
        Camera._RIG_MODE_STEREOSCOPIC_ANAGLYPH = 10;
        Camera._RIG_MODE_STEREOSCOPIC_SIDEBYSIDE_PARALLEL = 11;
        Camera._RIG_MODE_STEREOSCOPIC_SIDEBYSIDE_CROSSEYED = 12;
        Camera._RIG_MODE_STEREOSCOPIC_OVERUNDER = 13;
        Camera._RIG_MODE_VR = 20;
        Camera._RIG_MODE_WEBVR = 21;
        Camera.ForceAttachControlToAlwaysPreventDefault = false;
        Camera.UseAlternateWebVRRendering = false;
        __decorate([
            BABYLON.serializeAsVector3()
        ], Camera.prototype, "position", void 0);
        __decorate([
            BABYLON.serializeAsVector3()
        ], Camera.prototype, "upVector", void 0);
        __decorate([
            BABYLON.serialize()
        ], Camera.prototype, "orthoLeft", void 0);
        __decorate([
            BABYLON.serialize()
        ], Camera.prototype, "orthoRight", void 0);
        __decorate([
            BABYLON.serialize()
        ], Camera.prototype, "orthoBottom", void 0);
        __decorate([
            BABYLON.serialize()
        ], Camera.prototype, "orthoTop", void 0);
        __decorate([
            BABYLON.serialize()
        ], Camera.prototype, "fov", void 0);
        __decorate([
            BABYLON.serialize()
        ], Camera.prototype, "minZ", void 0);
        __decorate([
            BABYLON.serialize()
        ], Camera.prototype, "maxZ", void 0);
        __decorate([
            BABYLON.serialize()
        ], Camera.prototype, "inertia", void 0);
        __decorate([
            BABYLON.serialize()
        ], Camera.prototype, "mode", void 0);
        __decorate([
            BABYLON.serialize()
        ], Camera.prototype, "layerMask", void 0);
        __decorate([
            BABYLON.serialize()
        ], Camera.prototype, "fovMode", void 0);
        __decorate([
            BABYLON.serialize()
        ], Camera.prototype, "cameraRigMode", void 0);
        __decorate([
            BABYLON.serialize()
        ], Camera.prototype, "interaxialDistance", void 0);
        __decorate([
            BABYLON.serialize()
        ], Camera.prototype, "isStereoscopicSideBySide", void 0);
        return Camera;
    }(BABYLON.Node));
    BABYLON.Camera = Camera;
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.camera.js.map

var BABYLON;
(function (BABYLON) {
    var RenderingManager = /** @class */ (function () {
        function RenderingManager(scene) {
            this._renderingGroups = new Array();
            this._autoClearDepthStencil = {};
            this._customOpaqueSortCompareFn = {};
            this._customAlphaTestSortCompareFn = {};
            this._customTransparentSortCompareFn = {};
            this._renderinGroupInfo = null;
            this._scene = scene;
            for (var i = RenderingManager.MIN_RENDERINGGROUPS; i < RenderingManager.MAX_RENDERINGGROUPS; i++) {
                this._autoClearDepthStencil[i] = { autoClear: true, depth: true, stencil: true };
            }
        }
        RenderingManager.prototype._clearDepthStencilBuffer = function (depth, stencil) {
            if (depth === void 0) { depth = true; }
            if (stencil === void 0) { stencil = true; }
            if (this._depthStencilBufferAlreadyCleaned) {
                return;
            }
            this._scene.getEngine().clear(null, false, depth, stencil);
            this._depthStencilBufferAlreadyCleaned = true;
        };
        RenderingManager.prototype.render = function (customRenderFunction, activeMeshes, renderParticles, renderSprites) {
            // Check if there's at least on observer on the onRenderingGroupObservable and initialize things to fire it
            var observable = this._scene.onRenderingGroupObservable.hasObservers() ? this._scene.onRenderingGroupObservable : null;
            var info = null;
            if (observable) {
                if (!this._renderinGroupInfo) {
                    this._renderinGroupInfo = new BABYLON.RenderingGroupInfo();
                }
                info = this._renderinGroupInfo;
                info.scene = this._scene;
                info.camera = this._scene.activeCamera;
            }
            // Dispatch sprites
            if (renderSprites) {
                for (var index = 0; index < this._scene.spriteManagers.length; index++) {
                    var manager = this._scene.spriteManagers[index];
                    this.dispatchSprites(manager);
                }
            }
            // Render
            for (var index = RenderingManager.MIN_RENDERINGGROUPS; index < RenderingManager.MAX_RENDERINGGROUPS; index++) {
                this._depthStencilBufferAlreadyCleaned = index === RenderingManager.MIN_RENDERINGGROUPS;
                var renderingGroup = this._renderingGroups[index];
                if (!renderingGroup && !observable)
                    continue;
                var renderingGroupMask = 0;
                // Fire PRECLEAR stage
                if (observable && info) {
                    renderingGroupMask = Math.pow(2, index);
                    info.renderStage = BABYLON.RenderingGroupInfo.STAGE_PRECLEAR;
                    info.renderingGroupId = index;
                    observable.notifyObservers(info, renderingGroupMask);
                }
                // Clear depth/stencil if needed
                if (RenderingManager.AUTOCLEAR) {
                    var autoClear = this._autoClearDepthStencil[index];
                    if (autoClear && autoClear.autoClear) {
                        this._clearDepthStencilBuffer(autoClear.depth, autoClear.stencil);
                    }
                }
                if (observable && info) {
                    // Fire PREOPAQUE stage
                    info.renderStage = BABYLON.RenderingGroupInfo.STAGE_PREOPAQUE;
                    observable.notifyObservers(info, renderingGroupMask);
                    // Fire PRETRANSPARENT stage
                    info.renderStage = BABYLON.RenderingGroupInfo.STAGE_PRETRANSPARENT;
                    observable.notifyObservers(info, renderingGroupMask);
                }
                if (renderingGroup)
                    renderingGroup.render(customRenderFunction, renderSprites, renderParticles, activeMeshes);
                // Fire POSTTRANSPARENT stage
                if (observable && info) {
                    info.renderStage = BABYLON.RenderingGroupInfo.STAGE_POSTTRANSPARENT;
                    observable.notifyObservers(info, renderingGroupMask);
                }
            }
        };
        RenderingManager.prototype.reset = function () {
            for (var index = RenderingManager.MIN_RENDERINGGROUPS; index < RenderingManager.MAX_RENDERINGGROUPS; index++) {
                var renderingGroup = this._renderingGroups[index];
                if (renderingGroup) {
                    renderingGroup.prepare();
                }
            }
        };
        RenderingManager.prototype.dispose = function () {
            for (var index = RenderingManager.MIN_RENDERINGGROUPS; index < RenderingManager.MAX_RENDERINGGROUPS; index++) {
                var renderingGroup = this._renderingGroups[index];
                if (renderingGroup) {
                    renderingGroup.dispose();
                }
            }
            this._renderingGroups.length = 0;
        };
        RenderingManager.prototype._prepareRenderingGroup = function (renderingGroupId) {
            if (!this._renderingGroups[renderingGroupId]) {
                this._renderingGroups[renderingGroupId] = new BABYLON.RenderingGroup(renderingGroupId, this._scene, this._customOpaqueSortCompareFn[renderingGroupId], this._customAlphaTestSortCompareFn[renderingGroupId], this._customTransparentSortCompareFn[renderingGroupId]);
            }
        };
        RenderingManager.prototype.dispatchSprites = function (spriteManager) {
            var renderingGroupId = spriteManager.renderingGroupId || 0;
            this._prepareRenderingGroup(renderingGroupId);
            this._renderingGroups[renderingGroupId].dispatchSprites(spriteManager);
        };
        RenderingManager.prototype.dispatchParticles = function (particleSystem) {
            var renderingGroupId = particleSystem.renderingGroupId || 0;
            this._prepareRenderingGroup(renderingGroupId);
            this._renderingGroups[renderingGroupId].dispatchParticles(particleSystem);
        };
        RenderingManager.prototype.dispatch = function (subMesh) {
            var mesh = subMesh.getMesh();
            var renderingGroupId = mesh.renderingGroupId || 0;
            this._prepareRenderingGroup(renderingGroupId);
            this._renderingGroups[renderingGroupId].dispatch(subMesh);
        };
        /**
         * Overrides the default sort function applied in the renderging group to prepare the meshes.
         * This allowed control for front to back rendering or reversly depending of the special needs.
         *
         * @param renderingGroupId The rendering group id corresponding to its index
         * @param opaqueSortCompareFn The opaque queue comparison function use to sort.
         * @param alphaTestSortCompareFn The alpha test queue comparison function use to sort.
         * @param transparentSortCompareFn The transparent queue comparison function use to sort.
         */
        RenderingManager.prototype.setRenderingOrder = function (renderingGroupId, opaqueSortCompareFn, alphaTestSortCompareFn, transparentSortCompareFn) {
            if (opaqueSortCompareFn === void 0) { opaqueSortCompareFn = null; }
            if (alphaTestSortCompareFn === void 0) { alphaTestSortCompareFn = null; }
            if (transparentSortCompareFn === void 0) { transparentSortCompareFn = null; }
            this._customOpaqueSortCompareFn[renderingGroupId] = opaqueSortCompareFn;
            this._customAlphaTestSortCompareFn[renderingGroupId] = alphaTestSortCompareFn;
            this._customTransparentSortCompareFn[renderingGroupId] = transparentSortCompareFn;
            if (this._renderingGroups[renderingGroupId]) {
                var group = this._renderingGroups[renderingGroupId];
                group.opaqueSortCompareFn = this._customOpaqueSortCompareFn[renderingGroupId];
                group.alphaTestSortCompareFn = this._customAlphaTestSortCompareFn[renderingGroupId];
                group.transparentSortCompareFn = this._customTransparentSortCompareFn[renderingGroupId];
            }
        };
        /**
         * Specifies whether or not the stencil and depth buffer are cleared between two rendering groups.
         *
         * @param renderingGroupId The rendering group id corresponding to its index
         * @param autoClearDepthStencil Automatically clears depth and stencil between groups if true.
         * @param depth Automatically clears depth between groups if true and autoClear is true.
         * @param stencil Automatically clears stencil between groups if true and autoClear is true.
         */
        RenderingManager.prototype.setRenderingAutoClearDepthStencil = function (renderingGroupId, autoClearDepthStencil, depth, stencil) {
            if (depth === void 0) { depth = true; }
            if (stencil === void 0) { stencil = true; }
            this._autoClearDepthStencil[renderingGroupId] = {
                autoClear: autoClearDepthStencil,
                depth: depth,
                stencil: stencil
            };
        };
        /**
         * The max id used for rendering groups (not included)
         */
        RenderingManager.MAX_RENDERINGGROUPS = 4;
        /**
         * The min id used for rendering groups (included)
         */
        RenderingManager.MIN_RENDERINGGROUPS = 0;
        /**
         * Used to globally prevent autoclearing scenes.
         */
        RenderingManager.AUTOCLEAR = true;
        return RenderingManager;
    }());
    BABYLON.RenderingManager = RenderingManager;
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.renderingManager.js.map

var BABYLON;
(function (BABYLON) {
    var RenderingGroup = /** @class */ (function () {
        /**
         * Creates a new rendering group.
         * @param index The rendering group index
         * @param opaqueSortCompareFn The opaque sort comparison function. If null no order is applied
         * @param alphaTestSortCompareFn The alpha test sort comparison function. If null no order is applied
         * @param transparentSortCompareFn The transparent sort comparison function. If null back to front + alpha index sort is applied
         */
        function RenderingGroup(index, scene, opaqueSortCompareFn, alphaTestSortCompareFn, transparentSortCompareFn) {
            if (opaqueSortCompareFn === void 0) { opaqueSortCompareFn = null; }
            if (alphaTestSortCompareFn === void 0) { alphaTestSortCompareFn = null; }
            if (transparentSortCompareFn === void 0) { transparentSortCompareFn = null; }
            this.index = index;
            this._opaqueSubMeshes = new BABYLON.SmartArray(256);
            this._transparentSubMeshes = new BABYLON.SmartArray(256);
            this._alphaTestSubMeshes = new BABYLON.SmartArray(256);
            this._depthOnlySubMeshes = new BABYLON.SmartArray(256);
            this._particleSystems = new BABYLON.SmartArray(256);
            this._spriteManagers = new BABYLON.SmartArray(256);
            this._edgesRenderers = new BABYLON.SmartArray(16);
            this._scene = scene;
            this.opaqueSortCompareFn = opaqueSortCompareFn;
            this.alphaTestSortCompareFn = alphaTestSortCompareFn;
            this.transparentSortCompareFn = transparentSortCompareFn;
        }
        Object.defineProperty(RenderingGroup.prototype, "opaqueSortCompareFn", {
            /**
             * Set the opaque sort comparison function.
             * If null the sub meshes will be render in the order they were created
             */
            set: function (value) {
                this._opaqueSortCompareFn = value;
                if (value) {
                    this._renderOpaque = this.renderOpaqueSorted;
                }
                else {
                    this._renderOpaque = RenderingGroup.renderUnsorted;
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(RenderingGroup.prototype, "alphaTestSortCompareFn", {
            /**
             * Set the alpha test sort comparison function.
             * If null the sub meshes will be render in the order they were created
             */
            set: function (value) {
                this._alphaTestSortCompareFn = value;
                if (value) {
                    this._renderAlphaTest = this.renderAlphaTestSorted;
                }
                else {
                    this._renderAlphaTest = RenderingGroup.renderUnsorted;
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(RenderingGroup.prototype, "transparentSortCompareFn", {
            /**
             * Set the transparent sort comparison function.
             * If null the sub meshes will be render in the order they were created
             */
            set: function (value) {
                if (value) {
                    this._transparentSortCompareFn = value;
                }
                else {
                    this._transparentSortCompareFn = RenderingGroup.defaultTransparentSortCompare;
                }
                this._renderTransparent = this.renderTransparentSorted;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * Render all the sub meshes contained in the group.
         * @param customRenderFunction Used to override the default render behaviour of the group.
         * @returns true if rendered some submeshes.
         */
        RenderingGroup.prototype.render = function (customRenderFunction, renderSprites, renderParticles, activeMeshes) {
            if (customRenderFunction) {
                customRenderFunction(this._opaqueSubMeshes, this._alphaTestSubMeshes, this._transparentSubMeshes, this._depthOnlySubMeshes);
                return;
            }
            var engine = this._scene.getEngine();
            // Depth only
            if (this._depthOnlySubMeshes.length !== 0) {
                engine.setAlphaTesting(true);
                engine.setColorWrite(false);
                this._renderAlphaTest(this._depthOnlySubMeshes);
                engine.setAlphaTesting(false);
                engine.setColorWrite(true);
            }
            // Opaque
            if (this._opaqueSubMeshes.length !== 0) {
                this._renderOpaque(this._opaqueSubMeshes);
            }
            // Alpha test
            if (this._alphaTestSubMeshes.length !== 0) {
                engine.setAlphaTesting(true);
                this._renderAlphaTest(this._alphaTestSubMeshes);
                engine.setAlphaTesting(false);
            }
            var stencilState = engine.getStencilBuffer();
            engine.setStencilBuffer(false);
            // Sprites
            if (renderSprites) {
                this._renderSprites();
            }
            // Particles
            if (renderParticles) {
                this._renderParticles(activeMeshes);
            }
            if (this.onBeforeTransparentRendering) {
                this.onBeforeTransparentRendering();
            }
            // Transparent
            if (this._transparentSubMeshes.length !== 0) {
                this._renderTransparent(this._transparentSubMeshes);
                engine.setAlphaMode(BABYLON.Engine.ALPHA_DISABLE);
            }
            // Set back stencil to false in case it changes before the edge renderer.
            engine.setStencilBuffer(false);
            // Edges
            for (var edgesRendererIndex = 0; edgesRendererIndex < this._edgesRenderers.length; edgesRendererIndex++) {
                this._edgesRenderers.data[edgesRendererIndex].render();
            }
            // Restore Stencil state.
            engine.setStencilBuffer(stencilState);
        };
        /**
         * Renders the opaque submeshes in the order from the opaqueSortCompareFn.
         * @param subMeshes The submeshes to render
         */
        RenderingGroup.prototype.renderOpaqueSorted = function (subMeshes) {
            return RenderingGroup.renderSorted(subMeshes, this._opaqueSortCompareFn, this._scene.activeCamera, false);
        };
        /**
         * Renders the opaque submeshes in the order from the alphatestSortCompareFn.
         * @param subMeshes The submeshes to render
         */
        RenderingGroup.prototype.renderAlphaTestSorted = function (subMeshes) {
            return RenderingGroup.renderSorted(subMeshes, this._alphaTestSortCompareFn, this._scene.activeCamera, false);
        };
        /**
         * Renders the opaque submeshes in the order from the transparentSortCompareFn.
         * @param subMeshes The submeshes to render
         */
        RenderingGroup.prototype.renderTransparentSorted = function (subMeshes) {
            return RenderingGroup.renderSorted(subMeshes, this._transparentSortCompareFn, this._scene.activeCamera, true);
        };
        /**
         * Renders the submeshes in a specified order.
         * @param subMeshes The submeshes to sort before render
         * @param sortCompareFn The comparison function use to sort
         * @param cameraPosition The camera position use to preprocess the submeshes to help sorting
         * @param transparent Specifies to activate blending if true
         */
        RenderingGroup.renderSorted = function (subMeshes, sortCompareFn, camera, transparent) {
            var subIndex = 0;
            var subMesh;
            var cameraPosition = camera ? camera.globalPosition : BABYLON.Vector3.Zero();
            for (; subIndex < subMeshes.length; subIndex++) {
                subMesh = subMeshes.data[subIndex];
                subMesh._alphaIndex = subMesh.getMesh().alphaIndex;
                subMesh._distanceToCamera = subMesh.getBoundingInfo().boundingSphere.centerWorld.subtract(cameraPosition).length();
            }
            var sortedArray = subMeshes.data.slice(0, subMeshes.length);
            if (sortCompareFn) {
                sortedArray.sort(sortCompareFn);
            }
            for (subIndex = 0; subIndex < sortedArray.length; subIndex++) {
                subMesh = sortedArray[subIndex];
                if (transparent) {
                    var material = subMesh.getMaterial();
                    if (material && material.needDepthPrePass) {
                        var engine = material.getScene().getEngine();
                        engine.setColorWrite(false);
                        engine.setAlphaTesting(true);
                        engine.setAlphaMode(BABYLON.Engine.ALPHA_DISABLE);
                        subMesh.render(false);
                        engine.setAlphaTesting(false);
                        engine.setColorWrite(true);
                    }
                }
                subMesh.render(transparent);
            }
        };
        /**
         * Renders the submeshes in the order they were dispatched (no sort applied).
         * @param subMeshes The submeshes to render
         */
        RenderingGroup.renderUnsorted = function (subMeshes) {
            for (var subIndex = 0; subIndex < subMeshes.length; subIndex++) {
                var submesh = subMeshes.data[subIndex];
                submesh.render(false);
            }
        };
        /**
         * Build in function which can be applied to ensure meshes of a special queue (opaque, alpha test, transparent)
         * are rendered back to front if in the same alpha index.
         *
         * @param a The first submesh
         * @param b The second submesh
         * @returns The result of the comparison
         */
        RenderingGroup.defaultTransparentSortCompare = function (a, b) {
            // Alpha index first
            if (a._alphaIndex > b._alphaIndex) {
                return 1;
            }
            if (a._alphaIndex < b._alphaIndex) {
                return -1;
            }
            // Then distance to camera
            return RenderingGroup.backToFrontSortCompare(a, b);
        };
        /**
         * Build in function which can be applied to ensure meshes of a special queue (opaque, alpha test, transparent)
         * are rendered back to front.
         *
         * @param a The first submesh
         * @param b The second submesh
         * @returns The result of the comparison
         */
        RenderingGroup.backToFrontSortCompare = function (a, b) {
            // Then distance to camera
            if (a._distanceToCamera < b._distanceToCamera) {
                return 1;
            }
            if (a._distanceToCamera > b._distanceToCamera) {
                return -1;
            }
            return 0;
        };
        /**
         * Build in function which can be applied to ensure meshes of a special queue (opaque, alpha test, transparent)
         * are rendered front to back (prevent overdraw).
         *
         * @param a The first submesh
         * @param b The second submesh
         * @returns The result of the comparison
         */
        RenderingGroup.frontToBackSortCompare = function (a, b) {
            // Then distance to camera
            if (a._distanceToCamera < b._distanceToCamera) {
                return -1;
            }
            if (a._distanceToCamera > b._distanceToCamera) {
                return 1;
            }
            return 0;
        };
        /**
         * Resets the different lists of submeshes to prepare a new frame.
         */
        RenderingGroup.prototype.prepare = function () {
            this._opaqueSubMeshes.reset();
            this._transparentSubMeshes.reset();
            this._alphaTestSubMeshes.reset();
            this._depthOnlySubMeshes.reset();
            this._particleSystems.reset();
            this._spriteManagers.reset();
            this._edgesRenderers.reset();
        };
        RenderingGroup.prototype.dispose = function () {
            this._opaqueSubMeshes.dispose();
            this._transparentSubMeshes.dispose();
            this._alphaTestSubMeshes.dispose();
            this._depthOnlySubMeshes.dispose();
            this._particleSystems.dispose();
            this._spriteManagers.dispose();
            this._edgesRenderers.dispose();
        };
        /**
         * Inserts the submesh in its correct queue depending on its material.
         * @param subMesh The submesh to dispatch
         */
        RenderingGroup.prototype.dispatch = function (subMesh) {
            var material = subMesh.getMaterial();
            var mesh = subMesh.getMesh();
            if (!material) {
                return;
            }
            if (material.needAlphaBlendingForMesh(mesh)) {
                this._transparentSubMeshes.push(subMesh);
            }
            else if (material.needAlphaTesting()) {
                if (material.needDepthPrePass) {
                    this._depthOnlySubMeshes.push(subMesh);
                }
                this._alphaTestSubMeshes.push(subMesh);
            }
            else {
                if (material.needDepthPrePass) {
                    this._depthOnlySubMeshes.push(subMesh);
                }
                this._opaqueSubMeshes.push(subMesh); // Opaque
            }
            if (mesh._edgesRenderer) {
                this._edgesRenderers.push(mesh._edgesRenderer);
            }
        };
        RenderingGroup.prototype.dispatchSprites = function (spriteManager) {
            this._spriteManagers.push(spriteManager);
        };
        RenderingGroup.prototype.dispatchParticles = function (particleSystem) {
            this._particleSystems.push(particleSystem);
        };
        RenderingGroup.prototype._renderParticles = function (activeMeshes) {
            if (this._particleSystems.length === 0) {
                return;
            }
            // Particles
            var activeCamera = this._scene.activeCamera;
            this._scene.onBeforeParticlesRenderingObservable.notifyObservers(this._scene);
            for (var particleIndex = 0; particleIndex < this._scene._activeParticleSystems.length; particleIndex++) {
                var particleSystem = this._scene._activeParticleSystems.data[particleIndex];
                if ((activeCamera && activeCamera.layerMask & particleSystem.layerMask) === 0) {
                    continue;
                }
                var emitter = particleSystem.emitter;
                if (!emitter.position || !activeMeshes || activeMeshes.indexOf(emitter) !== -1) {
                    this._scene._activeParticles.addCount(particleSystem.render(), false);
                }
            }
            this._scene.onAfterParticlesRenderingObservable.notifyObservers(this._scene);
        };
        RenderingGroup.prototype._renderSprites = function () {
            if (!this._scene.spritesEnabled || this._spriteManagers.length === 0) {
                return;
            }
            // Sprites       
            var activeCamera = this._scene.activeCamera;
            this._scene.onBeforeSpritesRenderingObservable.notifyObservers(this._scene);
            for (var id = 0; id < this._spriteManagers.length; id++) {
                var spriteManager = this._spriteManagers.data[id];
                if (((activeCamera && activeCamera.layerMask & spriteManager.layerMask) !== 0)) {
                    spriteManager.render();
                }
            }
            this._scene.onAfterSpritesRenderingObservable.notifyObservers(this._scene);
        };
        return RenderingGroup;
    }());
    BABYLON.RenderingGroup = RenderingGroup;
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.renderingGroup.js.map

var BABYLON;
(function (BABYLON) {
    var ClickInfo = /** @class */ (function () {
        function ClickInfo() {
            this._singleClick = false;
            this._doubleClick = false;
            this._hasSwiped = false;
            this._ignore = false;
        }
        Object.defineProperty(ClickInfo.prototype, "singleClick", {
            get: function () {
                return this._singleClick;
            },
            set: function (b) {
                this._singleClick = b;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(ClickInfo.prototype, "doubleClick", {
            get: function () {
                return this._doubleClick;
            },
            set: function (b) {
                this._doubleClick = b;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(ClickInfo.prototype, "hasSwiped", {
            get: function () {
                return this._hasSwiped;
            },
            set: function (b) {
                this._hasSwiped = b;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(ClickInfo.prototype, "ignore", {
            get: function () {
                return this._ignore;
            },
            set: function (b) {
                this._ignore = b;
            },
            enumerable: true,
            configurable: true
        });
        return ClickInfo;
    }());
    /**
     * This class is used by the onRenderingGroupObservable
     */
    var RenderingGroupInfo = /** @class */ (function () {
        function RenderingGroupInfo() {
        }
        /**
         * Stage corresponding to the very first hook in the renderingGroup phase: before the render buffer may be cleared
         * This stage will be fired no matter what
         */
        RenderingGroupInfo.STAGE_PRECLEAR = 1;
        /**
         * Called before opaque object are rendered.
         * This stage will be fired only if there's 3D Opaque content to render
         */
        RenderingGroupInfo.STAGE_PREOPAQUE = 2;
        /**
         * Called after the opaque objects are rendered and before the transparent ones
         * This stage will be fired only if there's 3D transparent content to render
         */
        RenderingGroupInfo.STAGE_PRETRANSPARENT = 3;
        /**
         * Called after the transparent object are rendered, last hook of the renderingGroup phase
         * This stage will be fired no matter what
         */
        RenderingGroupInfo.STAGE_POSTTRANSPARENT = 4;
        return RenderingGroupInfo;
    }());
    BABYLON.RenderingGroupInfo = RenderingGroupInfo;
    /**
     * Represents a scene to be rendered by the engine.
     * @see http://doc.babylonjs.com/page.php?p=21911
     */
    var Scene = /** @class */ (function () {
        /**
         * @constructor
         * @param {BABYLON.Engine} engine - the engine to be used to render this scene.
         */
        function Scene(engine) {
            // Members
            this.autoClear = true;
            this.autoClearDepthAndStencil = true;
            this.clearColor = new BABYLON.Color4(0.2, 0.2, 0.3, 1.0);
            this.ambientColor = new BABYLON.Color3(0, 0, 0);
            this.forceWireframe = false;
            this._forcePointsCloud = false;
            this.forceShowBoundingBoxes = false;
            this.animationsEnabled = true;
            this.useConstantAnimationDeltaTime = false;
            this.constantlyUpdateMeshUnderPointer = false;
            this.hoverCursor = "pointer";
            this.defaultCursor = "";
            /**
             * This is used to call preventDefault() on pointer down
             * in order to block unwanted artifacts like system double clicks
             */
            this.preventDefaultOnPointerDown = true;
            // Metadata
            this.metadata = null;
            /**
            * An event triggered when the scene is disposed.
            * @type {BABYLON.Observable}
            */
            this.onDisposeObservable = new BABYLON.Observable();
            /**
            * An event triggered before rendering the scene (right after animations and physics)
            * @type {BABYLON.Observable}
            */
            this.onBeforeRenderObservable = new BABYLON.Observable();
            /**
            * An event triggered after rendering the scene
            * @type {BABYLON.Observable}
            */
            this.onAfterRenderObservable = new BABYLON.Observable();
            /**
            * An event triggered before animating the scene
            * @type {BABYLON.Observable}
            */
            this.onBeforeAnimationsObservable = new BABYLON.Observable();
            /**
            * An event triggered after animations processing
            * @type {BABYLON.Observable}
            */
            this.onAfterAnimationsObservable = new BABYLON.Observable();
            /**
            * An event triggered before draw calls are ready to be sent
            * @type {BABYLON.Observable}
            */
            this.onBeforeDrawPhaseObservable = new BABYLON.Observable();
            /**
            * An event triggered after draw calls have been sent
            * @type {BABYLON.Observable}
            */
            this.onAfterDrawPhaseObservable = new BABYLON.Observable();
            /**
            * An event triggered when physic simulation is about to be run
            * @type {BABYLON.Observable}
            */
            this.onBeforePhysicsObservable = new BABYLON.Observable();
            /**
            * An event triggered when physic simulation has been done
            * @type {BABYLON.Observable}
            */
            this.onAfterPhysicsObservable = new BABYLON.Observable();
            /**
            * An event triggered when the scene is ready
            * @type {BABYLON.Observable}
            */
            this.onReadyObservable = new BABYLON.Observable();
            /**
            * An event triggered before rendering a camera
            * @type {BABYLON.Observable}
            */
            this.onBeforeCameraRenderObservable = new BABYLON.Observable();
            /**
            * An event triggered after rendering a camera
            * @type {BABYLON.Observable}
            */
            this.onAfterCameraRenderObservable = new BABYLON.Observable();
            /**
            * An event triggered when active meshes evaluation is about to start
            * @type {BABYLON.Observable}
            */
            this.onBeforeActiveMeshesEvaluationObservable = new BABYLON.Observable();
            /**
            * An event triggered when active meshes evaluation is done
            * @type {BABYLON.Observable}
            */
            this.onAfterActiveMeshesEvaluationObservable = new BABYLON.Observable();
            /**
            * An event triggered when particles rendering is about to start
            * Note: This event can be trigger more than once per frame (because particles can be rendered by render target textures as well)
            * @type {BABYLON.Observable}
            */
            this.onBeforeParticlesRenderingObservable = new BABYLON.Observable();
            /**
            * An event triggered when particles rendering is done
            * Note: This event can be trigger more than once per frame (because particles can be rendered by render target textures as well)
            * @type {BABYLON.Observable}
            */
            this.onAfterParticlesRenderingObservable = new BABYLON.Observable();
            /**
            * An event triggered when sprites rendering is about to start
            * Note: This event can be trigger more than once per frame (because sprites can be rendered by render target textures as well)
            * @type {BABYLON.Observable}
            */
            this.onBeforeSpritesRenderingObservable = new BABYLON.Observable();
            /**
            * An event triggered when sprites rendering is done
            * Note: This event can be trigger more than once per frame (because sprites can be rendered by render target textures as well)
            * @type {BABYLON.Observable}
            */
            this.onAfterSpritesRenderingObservable = new BABYLON.Observable();
            /**
            * An event triggered when SceneLoader.Append or SceneLoader.Load or SceneLoader.ImportMesh were successfully executed
            * @type {BABYLON.Observable}
            */
            this.onDataLoadedObservable = new BABYLON.Observable();
            /**
            * An event triggered when a camera is created
            * @type {BABYLON.Observable}
            */
            this.onNewCameraAddedObservable = new BABYLON.Observable();
            /**
            * An event triggered when a camera is removed
            * @type {BABYLON.Observable}
            */
            this.onCameraRemovedObservable = new BABYLON.Observable();
            /**
            * An event triggered when a light is created
            * @type {BABYLON.Observable}
            */
            this.onNewLightAddedObservable = new BABYLON.Observable();
            /**
            * An event triggered when a light is removed
            * @type {BABYLON.Observable}
            */
            this.onLightRemovedObservable = new BABYLON.Observable();
            /**
            * An event triggered when a geometry is created
            * @type {BABYLON.Observable}
            */
            this.onNewGeometryAddedObservable = new BABYLON.Observable();
            /**
            * An event triggered when a geometry is removed
            * @type {BABYLON.Observable}
            */
            this.onGeometryRemovedObservable = new BABYLON.Observable();
            /**
            * An event triggered when a transform node is created
            * @type {BABYLON.Observable}
            */
            this.onNewTransformNodeAddedObservable = new BABYLON.Observable();
            /**
            * An event triggered when a transform node is removed
            * @type {BABYLON.Observable}
            */
            this.onTransformNodeRemovedObservable = new BABYLON.Observable();
            /**
            * An event triggered when a mesh is created
            * @type {BABYLON.Observable}
            */
            this.onNewMeshAddedObservable = new BABYLON.Observable();
            /**
            * An event triggered when a mesh is removed
            * @type {BABYLON.Observable}
            */
            this.onMeshRemovedObservable = new BABYLON.Observable();
            /**
            * An event triggered when render targets are about to be rendered
            * Can happen multiple times per frame.
            * @type {BABYLON.Observable}
            */
            this.OnBeforeRenderTargetsRenderObservable = new BABYLON.Observable();
            /**
            * An event triggered when render targets were rendered.
            * Can happen multiple times per frame.
            * @type {BABYLON.Observable}
            */
            this.OnAfterRenderTargetsRenderObservable = new BABYLON.Observable();
            /**
            * An event triggered before calculating deterministic simulation step
            * @type {BABYLON.Observable}
            */
            this.onBeforeStepObservable = new BABYLON.Observable();
            /**
            * An event triggered after calculating deterministic simulation step
            * @type {BABYLON.Observable}
            */
            this.onAfterStepObservable = new BABYLON.Observable();
            /**
             * This Observable will be triggered for each stage of each renderingGroup of each rendered camera.
             * The RenderinGroupInfo class contains all the information about the context in which the observable is called
             * If you wish to register an Observer only for a given set of renderingGroup, use the mask with a combination of the renderingGroup index elevated to the power of two (1 for renderingGroup 0, 2 for renderingrOup1, 4 for 2 and 8 for 3)
             */
            this.onRenderingGroupObservable = new BABYLON.Observable();
            // Animations
            this.animations = [];
            /**
             * This observable event is triggered when any ponter event is triggered. It is registered during Scene.attachControl() and it is called BEFORE the 3D engine process anything (mesh/sprite picking for instance).
             * You have the possibility to skip the process and the call to onPointerObservable by setting PointerInfoPre.skipOnPointerObservable to true
             */
            this.onPrePointerObservable = new BABYLON.Observable();
            /**
             * Observable event triggered each time an input event is received from the rendering canvas
             */
            this.onPointerObservable = new BABYLON.Observable();
            this._meshPickProceed = false;
            this._currentPickResult = null;
            this._previousPickResult = null;
            this._totalPointersPressed = 0;
            this._doubleClickOccured = false;
            /** Define this parameter if you are using multiple cameras and you want to specify which one should be used for pointer position */
            this.cameraToUseForPointers = null;
            this._startingPointerPosition = new BABYLON.Vector2(0, 0);
            this._previousStartingPointerPosition = new BABYLON.Vector2(0, 0);
            this._startingPointerTime = 0;
            this._previousStartingPointerTime = 0;
            // Deterministic lockstep
            this._timeAccumulator = 0;
            this._currentStepId = 0;
            this._currentInternalStep = 0;
            // Keyboard
            /**
             * This observable event is triggered when any keyboard event si raised and registered during Scene.attachControl()
             * You have the possibility to skip the process and the call to onKeyboardObservable by setting KeyboardInfoPre.skipOnPointerObservable to true
             */
            this.onPreKeyboardObservable = new BABYLON.Observable();
            /**
             * Observable event triggered each time an keyboard event is received from the hosting window
             */
            this.onKeyboardObservable = new BABYLON.Observable();
            // Coordinate system
            /**
            * use right-handed coordinate system on this scene.
            * @type {boolean}
            */
            this._useRightHandedSystem = false;
            // Fog
            this._fogEnabled = true;
            this._fogMode = Scene.FOGMODE_NONE;
            this.fogColor = new BABYLON.Color3(0.2, 0.2, 0.3);
            this.fogDensity = 0.1;
            this.fogStart = 0;
            this.fogEnd = 1000.0;
            // Lights
            /**
            * is shadow enabled on this scene.
            * @type {boolean}
            */
            this._shadowsEnabled = true;
            /**
            * is light enabled on this scene.
            * @type {boolean}
            */
            this._lightsEnabled = true;
            /**
            * All of the lights added to this scene.
            * @see BABYLON.Light
            * @type {BABYLON.Light[]}
            */
            this.lights = new Array();
            // Cameras
            /** All of the cameras added to this scene. */
            this.cameras = new Array();
            /** All of the active cameras added to this scene. */
            this.activeCameras = new Array();
            // Meshes
            /**
            * All of the tranform nodes added to this scene.
            * @see BABYLON.TransformNode
            * @type {BABYLON.TransformNode[]}
            */
            this.transformNodes = new Array();
            /**
            * All of the (abstract) meshes added to this scene.
            * @see BABYLON.AbstractMesh
            * @type {BABYLON.AbstractMesh[]}
            */
            this.meshes = new Array();
            // Geometries
            this._geometries = new Array();
            this.materials = new Array();
            this.multiMaterials = new Array();
            // Textures
            this._texturesEnabled = true;
            this.textures = new Array();
            // Particles
            this.particlesEnabled = true;
            this.particleSystems = new Array();
            // Sprites
            this.spritesEnabled = true;
            this.spriteManagers = new Array();
            // Layers
            this.layers = new Array();
            this.highlightLayers = new Array();
            // Skeletons
            this._skeletonsEnabled = true;
            this.skeletons = new Array();
            // Morph targets
            this.morphTargetManagers = new Array();
            // Lens flares
            this.lensFlaresEnabled = true;
            this.lensFlareSystems = new Array();
            // Collisions
            this.collisionsEnabled = true;
            /** Defines the gravity applied to this scene */
            this.gravity = new BABYLON.Vector3(0, -9.807, 0);
            // Postprocesses
            this.postProcesses = new Array();
            this.postProcessesEnabled = true;
            // Customs render targets
            this.renderTargetsEnabled = true;
            this.dumpNextRenderTargets = false;
            this.customRenderTargets = new Array();
            // Imported meshes
            this.importedMeshesFiles = new Array();
            // Probes
            this.probesEnabled = true;
            this.reflectionProbes = new Array();
            this._actionManagers = new Array();
            this._meshesForIntersections = new BABYLON.SmartArrayNoDuplicate(256);
            // Procedural textures
            this.proceduralTexturesEnabled = true;
            this._proceduralTextures = new Array();
            this.soundTracks = new Array();
            this._audioEnabled = true;
            this._headphone = false;
            // Performance counters
            this._totalVertices = new BABYLON.PerfCounter();
            this._activeIndices = new BABYLON.PerfCounter();
            this._activeParticles = new BABYLON.PerfCounter();
            this._activeBones = new BABYLON.PerfCounter();
            this._animationTime = 0;
            this.animationTimeScale = 1;
            this._renderId = 0;
            this._executeWhenReadyTimeoutId = -1;
            this._intermediateRendering = false;
            this._viewUpdateFlag = -1;
            this._projectionUpdateFlag = -1;
            this._alternateViewUpdateFlag = -1;
            this._alternateProjectionUpdateFlag = -1;
            this._toBeDisposed = new BABYLON.SmartArray(256);
            this._pendingData = new Array();
            this._isDisposed = false;
            this._activeMeshes = new BABYLON.SmartArray(256);
            this._processedMaterials = new BABYLON.SmartArray(256);
            this._renderTargets = new BABYLON.SmartArrayNoDuplicate(256);
            this._activeParticleSystems = new BABYLON.SmartArray(256);
            this._activeSkeletons = new BABYLON.SmartArrayNoDuplicate(32);
            this._softwareSkinnedMeshes = new BABYLON.SmartArrayNoDuplicate(32);
            this._activeAnimatables = new Array();
            this._transformMatrix = BABYLON.Matrix.Zero();
            this._useAlternateCameraConfiguration = false;
            this._alternateRendering = false;
            this.requireLightSorting = false;
            this._activeMeshesFrozen = false;
            this._tempPickingRay = BABYLON.Ray ? BABYLON.Ray.Zero() : null;
            this._engine = engine || BABYLON.Engine.LastCreatedEngine;
            this._engine.scenes.push(this);
            this._uid = null;
            this._renderingManager = new BABYLON.RenderingManager(this);
            this.postProcessManager = new BABYLON.PostProcessManager(this);
            if (BABYLON.OutlineRenderer) {
                this._outlineRenderer = new BABYLON.OutlineRenderer(this);
            }
            if (BABYLON.Tools.IsWindowObjectExist()) {
                this.attachControl();
            }
            //simplification queue
            if (BABYLON.SimplificationQueue) {
                this.simplificationQueue = new BABYLON.SimplificationQueue();
            }
            //collision coordinator initialization. For now legacy per default.
            this.workerCollisions = false; //(!!Worker && (!!BABYLON.CollisionWorker || BABYLON.WorkerIncluded));
            // Uniform Buffer
            this._createUbo();
            // Default Image processing definition.
            this._imageProcessingConfiguration = new BABYLON.ImageProcessingConfiguration();
        }
        Object.defineProperty(Scene, "FOGMODE_NONE", {
            /** The fog is deactivated */
            get: function () {
                return Scene._FOGMODE_NONE;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Scene, "FOGMODE_EXP", {
            /** The fog density is following an exponential function */
            get: function () {
                return Scene._FOGMODE_EXP;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Scene, "FOGMODE_EXP2", {
            /** The fog density is following an exponential function faster than FOGMODE_EXP */
            get: function () {
                return Scene._FOGMODE_EXP2;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Scene, "FOGMODE_LINEAR", {
            /** The fog density is following a linear function. */
            get: function () {
                return Scene._FOGMODE_LINEAR;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Scene.prototype, "environmentTexture", {
            /**
             * Texture used in all pbr material as the reflection texture.
             * As in the majority of the scene they are the same (exception for multi room and so on),
             * this is easier to reference from here than from all the materials.
             */
            get: function () {
                return this._environmentTexture;
            },
            /**
             * Texture used in all pbr material as the reflection texture.
             * As in the majority of the scene they are the same (exception for multi room and so on),
             * this is easier to set here than in all the materials.
             */
            set: function (value) {
                if (this._environmentTexture === value) {
                    return;
                }
                this._environmentTexture = value;
                this.markAllMaterialsAsDirty(BABYLON.Material.TextureDirtyFlag);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Scene.prototype, "imageProcessingConfiguration", {
            /**
             * Default image processing configuration used either in the rendering
             * Forward main pass or through the imageProcessingPostProcess if present.
             * As in the majority of the scene they are the same (exception for multi camera),
             * this is easier to reference from here than from all the materials and post process.
             *
             * No setter as we it is a shared configuration, you can set the values instead.
             */
            get: function () {
                return this._imageProcessingConfiguration;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Scene.prototype, "forcePointsCloud", {
            get: function () {
                return this._forcePointsCloud;
            },
            set: function (value) {
                if (this._forcePointsCloud === value) {
                    return;
                }
                this._forcePointsCloud = value;
                this.markAllMaterialsAsDirty(BABYLON.Material.MiscDirtyFlag);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Scene.prototype, "onDispose", {
            /** A function to be executed when this scene is disposed. */
            set: function (callback) {
                if (this._onDisposeObserver) {
                    this.onDisposeObservable.remove(this._onDisposeObserver);
                }
                this._onDisposeObserver = this.onDisposeObservable.add(callback);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Scene.prototype, "beforeRender", {
            /** A function to be executed before rendering this scene */
            set: function (callback) {
                if (this._onBeforeRenderObserver) {
                    this.onBeforeRenderObservable.remove(this._onBeforeRenderObserver);
                }
                if (callback) {
                    this._onBeforeRenderObserver = this.onBeforeRenderObservable.add(callback);
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Scene.prototype, "afterRender", {
            /** A function to be executed after rendering this scene */
            set: function (callback) {
                if (this._onAfterRenderObserver) {
                    this.onAfterRenderObservable.remove(this._onAfterRenderObserver);
                }
                if (callback) {
                    this._onAfterRenderObserver = this.onAfterRenderObservable.add(callback);
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Scene.prototype, "beforeCameraRender", {
            set: function (callback) {
                if (this._onBeforeCameraRenderObserver) {
                    this.onBeforeCameraRenderObservable.remove(this._onBeforeCameraRenderObserver);
                }
                this._onBeforeCameraRenderObserver = this.onBeforeCameraRenderObservable.add(callback);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Scene.prototype, "afterCameraRender", {
            set: function (callback) {
                if (this._onAfterCameraRenderObserver) {
                    this.onAfterCameraRenderObservable.remove(this._onAfterCameraRenderObserver);
                }
                this._onAfterCameraRenderObserver = this.onAfterCameraRenderObservable.add(callback);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Scene.prototype, "gamepadManager", {
            get: function () {
                if (!this._gamepadManager) {
                    this._gamepadManager = new BABYLON.GamepadManager(this);
                }
                return this._gamepadManager;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Scene.prototype, "unTranslatedPointer", {
            get: function () {
                return new BABYLON.Vector2(this._unTranslatedPointerX, this._unTranslatedPointerY);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Scene.prototype, "useRightHandedSystem", {
            get: function () {
                return this._useRightHandedSystem;
            },
            set: function (value) {
                if (this._useRightHandedSystem === value) {
                    return;
                }
                this._useRightHandedSystem = value;
                this.markAllMaterialsAsDirty(BABYLON.Material.MiscDirtyFlag);
            },
            enumerable: true,
            configurable: true
        });
        Scene.prototype.setStepId = function (newStepId) {
            this._currentStepId = newStepId;
        };
        ;
        Scene.prototype.getStepId = function () {
            return this._currentStepId;
        };
        ;
        Scene.prototype.getInternalStep = function () {
            return this._currentInternalStep;
        };
        ;
        Object.defineProperty(Scene.prototype, "fogEnabled", {
            get: function () {
                return this._fogEnabled;
            },
            /**
            * is fog enabled on this scene.
            */
            set: function (value) {
                if (this._fogEnabled === value) {
                    return;
                }
                this._fogEnabled = value;
                this.markAllMaterialsAsDirty(BABYLON.Material.MiscDirtyFlag);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Scene.prototype, "fogMode", {
            get: function () {
                return this._fogMode;
            },
            set: function (value) {
                if (this._fogMode === value) {
                    return;
                }
                this._fogMode = value;
                this.markAllMaterialsAsDirty(BABYLON.Material.MiscDirtyFlag);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Scene.prototype, "shadowsEnabled", {
            get: function () {
                return this._shadowsEnabled;
            },
            set: function (value) {
                if (this._shadowsEnabled === value) {
                    return;
                }
                this._shadowsEnabled = value;
                this.markAllMaterialsAsDirty(BABYLON.Material.LightDirtyFlag);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Scene.prototype, "lightsEnabled", {
            get: function () {
                return this._lightsEnabled;
            },
            set: function (value) {
                if (this._lightsEnabled === value) {
                    return;
                }
                this._lightsEnabled = value;
                this.markAllMaterialsAsDirty(BABYLON.Material.LightDirtyFlag);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Scene.prototype, "defaultMaterial", {
            /** The default material used on meshes when no material is affected */
            get: function () {
                if (!this._defaultMaterial) {
                    this._defaultMaterial = new BABYLON.StandardMaterial("default material", this);
                }
                return this._defaultMaterial;
            },
            /** The default material used on meshes when no material is affected */
            set: function (value) {
                this._defaultMaterial = value;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Scene.prototype, "texturesEnabled", {
            get: function () {
                return this._texturesEnabled;
            },
            set: function (value) {
                if (this._texturesEnabled === value) {
                    return;
                }
                this._texturesEnabled = value;
                this.markAllMaterialsAsDirty(BABYLON.Material.TextureDirtyFlag);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Scene.prototype, "skeletonsEnabled", {
            get: function () {
                return this._skeletonsEnabled;
            },
            set: function (value) {
                if (this._skeletonsEnabled === value) {
                    return;
                }
                this._skeletonsEnabled = value;
                this.markAllMaterialsAsDirty(BABYLON.Material.AttributesDirtyFlag);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Scene.prototype, "postProcessRenderPipelineManager", {
            get: function () {
                if (!this._postProcessRenderPipelineManager) {
                    this._postProcessRenderPipelineManager = new BABYLON.PostProcessRenderPipelineManager();
                }
                return this._postProcessRenderPipelineManager;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Scene.prototype, "mainSoundTrack", {
            get: function () {
                if (!this._mainSoundTrack) {
                    this._mainSoundTrack = new BABYLON.SoundTrack(this, { mainTrack: true });
                }
                return this._mainSoundTrack;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Scene.prototype, "_isAlternateRenderingEnabled", {
            get: function () {
                return this._alternateRendering;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Scene.prototype, "frustumPlanes", {
            get: function () {
                return this._frustumPlanes;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Scene.prototype, "debugLayer", {
            // Properties
            get: function () {
                if (!this._debugLayer) {
                    this._debugLayer = new BABYLON.DebugLayer(this);
                }
                return this._debugLayer;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Scene.prototype, "workerCollisions", {
            get: function () {
                return this._workerCollisions;
            },
            set: function (enabled) {
                if (!BABYLON.CollisionCoordinatorLegacy) {
                    return;
                }
                enabled = (enabled && !!Worker);
                this._workerCollisions = enabled;
                if (this.collisionCoordinator) {
                    this.collisionCoordinator.destroy();
                }
                this.collisionCoordinator = enabled ? new BABYLON.CollisionCoordinatorWorker() : new BABYLON.CollisionCoordinatorLegacy();
                this.collisionCoordinator.init(this);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Scene.prototype, "selectionOctree", {
            get: function () {
                return this._selectionOctree;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Scene.prototype, "meshUnderPointer", {
            /**
             * The mesh that is currently under the pointer.
             * @return {BABYLON.AbstractMesh} mesh under the pointer/mouse cursor or null if none.
             */
            get: function () {
                return this._pointerOverMesh;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Scene.prototype, "pointerX", {
            /**
             * Current on-screen X position of the pointer
             * @return {number} X position of the pointer
             */
            get: function () {
                return this._pointerX;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Scene.prototype, "pointerY", {
            /**
             * Current on-screen Y position of the pointer
             * @return {number} Y position of the pointer
             */
            get: function () {
                return this._pointerY;
            },
            enumerable: true,
            configurable: true
        });
        Scene.prototype.getCachedMaterial = function () {
            return this._cachedMaterial;
        };
        Scene.prototype.getCachedEffect = function () {
            return this._cachedEffect;
        };
        Scene.prototype.getCachedVisibility = function () {
            return this._cachedVisibility;
        };
        Scene.prototype.isCachedMaterialInvalid = function (material, effect, visibility) {
            if (visibility === void 0) { visibility = 1; }
            return this._cachedEffect !== effect || this._cachedMaterial !== material || this._cachedVisibility !== visibility;
        };
        Scene.prototype.getBoundingBoxRenderer = function () {
            if (!this._boundingBoxRenderer) {
                this._boundingBoxRenderer = new BABYLON.BoundingBoxRenderer(this);
            }
            return this._boundingBoxRenderer;
        };
        Scene.prototype.getOutlineRenderer = function () {
            return this._outlineRenderer;
        };
        Scene.prototype.getEngine = function () {
            return this._engine;
        };
        Scene.prototype.getTotalVertices = function () {
            return this._totalVertices.current;
        };
        Object.defineProperty(Scene.prototype, "totalVerticesPerfCounter", {
            get: function () {
                return this._totalVertices;
            },
            enumerable: true,
            configurable: true
        });
        Scene.prototype.getActiveIndices = function () {
            return this._activeIndices.current;
        };
        Object.defineProperty(Scene.prototype, "totalActiveIndicesPerfCounter", {
            get: function () {
                return this._activeIndices;
            },
            enumerable: true,
            configurable: true
        });
        Scene.prototype.getActiveParticles = function () {
            return this._activeParticles.current;
        };
        Object.defineProperty(Scene.prototype, "activeParticlesPerfCounter", {
            get: function () {
                return this._activeParticles;
            },
            enumerable: true,
            configurable: true
        });
        Scene.prototype.getActiveBones = function () {
            return this._activeBones.current;
        };
        Object.defineProperty(Scene.prototype, "activeBonesPerfCounter", {
            get: function () {
                return this._activeBones;
            },
            enumerable: true,
            configurable: true
        });
        // Stats
        Scene.prototype.getInterFramePerfCounter = function () {
            BABYLON.Tools.Warn("getInterFramePerfCounter is deprecated. Please use SceneInstrumentation class");
            return 0;
        };
        Object.defineProperty(Scene.prototype, "interFramePerfCounter", {
            get: function () {
                BABYLON.Tools.Warn("interFramePerfCounter is deprecated. Please use SceneInstrumentation class");
                return null;
            },
            enumerable: true,
            configurable: true
        });
        Scene.prototype.getLastFrameDuration = function () {
            BABYLON.Tools.Warn("getLastFrameDuration is deprecated. Please use SceneInstrumentation class");
            return 0;
        };
        Object.defineProperty(Scene.prototype, "lastFramePerfCounter", {
            get: function () {
                BABYLON.Tools.Warn("lastFramePerfCounter is deprecated. Please use SceneInstrumentation class");
                return null;
            },
            enumerable: true,
            configurable: true
        });
        Scene.prototype.getEvaluateActiveMeshesDuration = function () {
            BABYLON.Tools.Warn("getEvaluateActiveMeshesDuration is deprecated. Please use SceneInstrumentation class");
            return 0;
        };
        Object.defineProperty(Scene.prototype, "evaluateActiveMeshesDurationPerfCounter", {
            get: function () {
                BABYLON.Tools.Warn("evaluateActiveMeshesDurationPerfCounter is deprecated. Please use SceneInstrumentation class");
                return null;
            },
            enumerable: true,
            configurable: true
        });
        Scene.prototype.getActiveMeshes = function () {
            return this._activeMeshes;
        };
        Scene.prototype.getRenderTargetsDuration = function () {
            BABYLON.Tools.Warn("getRenderTargetsDuration is deprecated. Please use SceneInstrumentation class");
            return 0;
        };
        Scene.prototype.getRenderDuration = function () {
            BABYLON.Tools.Warn("getRenderDuration is deprecated. Please use SceneInstrumentation class");
            return 0;
        };
        Object.defineProperty(Scene.prototype, "renderDurationPerfCounter", {
            get: function () {
                BABYLON.Tools.Warn("renderDurationPerfCounter is deprecated. Please use SceneInstrumentation class");
                return null;
            },
            enumerable: true,
            configurable: true
        });
        Scene.prototype.getParticlesDuration = function () {
            BABYLON.Tools.Warn("getParticlesDuration is deprecated. Please use SceneInstrumentation class");
            return 0;
        };
        Object.defineProperty(Scene.prototype, "particlesDurationPerfCounter", {
            get: function () {
                BABYLON.Tools.Warn("particlesDurationPerfCounter is deprecated. Please use SceneInstrumentation class");
                return null;
            },
            enumerable: true,
            configurable: true
        });
        Scene.prototype.getSpritesDuration = function () {
            BABYLON.Tools.Warn("getSpritesDuration is deprecated. Please use SceneInstrumentation class");
            return 0;
        };
        Object.defineProperty(Scene.prototype, "spriteDuractionPerfCounter", {
            get: function () {
                BABYLON.Tools.Warn("spriteDuractionPerfCounter is deprecated. Please use SceneInstrumentation class");
                return null;
            },
            enumerable: true,
            configurable: true
        });
        Scene.prototype.getAnimationRatio = function () {
            return this._animationRatio;
        };
        Scene.prototype.getRenderId = function () {
            return this._renderId;
        };
        Scene.prototype.incrementRenderId = function () {
            this._renderId++;
        };
        Scene.prototype._updatePointerPosition = function (evt) {
            var canvasRect = this._engine.getRenderingCanvasClientRect();
            if (!canvasRect) {
                return;
            }
            this._pointerX = evt.clientX - canvasRect.left;
            this._pointerY = evt.clientY - canvasRect.top;
            this._unTranslatedPointerX = this._pointerX;
            this._unTranslatedPointerY = this._pointerY;
        };
        Scene.prototype._createUbo = function () {
            this._sceneUbo = new BABYLON.UniformBuffer(this._engine, undefined, true);
            this._sceneUbo.addUniform("viewProjection", 16);
            this._sceneUbo.addUniform("view", 16);
        };
        Scene.prototype._createAlternateUbo = function () {
            this._alternateSceneUbo = new BABYLON.UniformBuffer(this._engine, undefined, true);
            this._alternateSceneUbo.addUniform("viewProjection", 16);
            this._alternateSceneUbo.addUniform("view", 16);
        };
        // Pointers handling
        /**
         * Use this method to simulate a pointer move on a mesh
         * The pickResult parameter can be obtained from a scene.pick or scene.pickWithRay
         */
        Scene.prototype.simulatePointerMove = function (pickResult) {
            var evt = new PointerEvent("pointermove");
            return this._processPointerMove(pickResult, evt);
        };
        Scene.prototype._processPointerMove = function (pickResult, evt) {
            var canvas = this._engine.getRenderingCanvas();
            if (!canvas) {
                return this;
            }
            if (pickResult && pickResult.hit && pickResult.pickedMesh) {
                this.setPointerOverSprite(null);
                this.setPointerOverMesh(pickResult.pickedMesh);
                if (this._pointerOverMesh && this._pointerOverMesh.actionManager && this._pointerOverMesh.actionManager.hasPointerTriggers) {
                    if (this._pointerOverMesh.actionManager.hoverCursor) {
                        canvas.style.cursor = this._pointerOverMesh.actionManager.hoverCursor;
                    }
                    else {
                        canvas.style.cursor = this.hoverCursor;
                    }
                }
                else {
                    canvas.style.cursor = this.defaultCursor;
                }
            }
            else {
                this.setPointerOverMesh(null);
                // Sprites
                pickResult = this.pickSprite(this._unTranslatedPointerX, this._unTranslatedPointerY, this._spritePredicate, false, this.cameraToUseForPointers || undefined);
                if (pickResult && pickResult.hit && pickResult.pickedSprite) {
                    this.setPointerOverSprite(pickResult.pickedSprite);
                    if (this._pointerOverSprite && this._pointerOverSprite.actionManager && this._pointerOverSprite.actionManager.hoverCursor) {
                        canvas.style.cursor = this._pointerOverSprite.actionManager.hoverCursor;
                    }
                    else {
                        canvas.style.cursor = this.hoverCursor;
                    }
                }
                else {
                    this.setPointerOverSprite(null);
                    // Restore pointer
                    canvas.style.cursor = this.defaultCursor;
                }
            }
            if (pickResult) {
                if (this.onPointerMove) {
                    this.onPointerMove(evt, pickResult);
                }
                if (this.onPointerObservable.hasObservers()) {
                    var type = evt.type === "mousewheel" || evt.type === "DOMMouseScroll" ? BABYLON.PointerEventTypes.POINTERWHEEL : BABYLON.PointerEventTypes.POINTERMOVE;
                    var pi = new BABYLON.PointerInfo(type, evt, pickResult);
                    this.onPointerObservable.notifyObservers(pi, type);
                }
            }
            return this;
        };
        /**
         * Use this method to simulate a pointer down on a mesh
         * The pickResult parameter can be obtained from a scene.pick or scene.pickWithRay
         */
        Scene.prototype.simulatePointerDown = function (pickResult) {
            var evt = new PointerEvent("pointerdown");
            return this._processPointerDown(pickResult, evt);
        };
        Scene.prototype._processPointerDown = function (pickResult, evt) {
            var _this = this;
            if (pickResult && pickResult.hit && pickResult.pickedMesh) {
                this._pickedDownMesh = pickResult.pickedMesh;
                var actionManager = pickResult.pickedMesh.actionManager;
                if (actionManager) {
                    if (actionManager.hasPickTriggers) {
                        actionManager.processTrigger(BABYLON.ActionManager.OnPickDownTrigger, BABYLON.ActionEvent.CreateNew(pickResult.pickedMesh, evt));
                        switch (evt.button) {
                            case 0:
                                actionManager.processTrigger(BABYLON.ActionManager.OnLeftPickTrigger, BABYLON.ActionEvent.CreateNew(pickResult.pickedMesh, evt));
                                break;
                            case 1:
                                actionManager.processTrigger(BABYLON.ActionManager.OnCenterPickTrigger, BABYLON.ActionEvent.CreateNew(pickResult.pickedMesh, evt));
                                break;
                            case 2:
                                actionManager.processTrigger(BABYLON.ActionManager.OnRightPickTrigger, BABYLON.ActionEvent.CreateNew(pickResult.pickedMesh, evt));
                                break;
                        }
                    }
                    if (actionManager.hasSpecificTrigger(BABYLON.ActionManager.OnLongPressTrigger)) {
                        window.setTimeout(function () {
                            var pickResult = _this.pick(_this._unTranslatedPointerX, _this._unTranslatedPointerY, function (mesh) { return (mesh.isPickable && mesh.isVisible && mesh.isReady() && mesh.actionManager && mesh.actionManager.hasSpecificTrigger(BABYLON.ActionManager.OnLongPressTrigger) && mesh == _this._pickedDownMesh); }, false, _this.cameraToUseForPointers);
                            if (pickResult && pickResult.hit && pickResult.pickedMesh && actionManager) {
                                if (_this._totalPointersPressed !== 0 &&
                                    ((new Date().getTime() - _this._startingPointerTime) > Scene.LongPressDelay) &&
                                    (Math.abs(_this._startingPointerPosition.x - _this._pointerX) < Scene.DragMovementThreshold &&
                                        Math.abs(_this._startingPointerPosition.y - _this._pointerY) < Scene.DragMovementThreshold)) {
                                    _this._startingPointerTime = 0;
                                    actionManager.processTrigger(BABYLON.ActionManager.OnLongPressTrigger, BABYLON.ActionEvent.CreateNew(pickResult.pickedMesh, evt));
                                }
                            }
                        }, Scene.LongPressDelay);
                    }
                }
            }
            if (pickResult) {
                if (this.onPointerDown) {
                    this.onPointerDown(evt, pickResult);
                }
                if (this.onPointerObservable.hasObservers()) {
                    var type = BABYLON.PointerEventTypes.POINTERDOWN;
                    var pi = new BABYLON.PointerInfo(type, evt, pickResult);
                    this.onPointerObservable.notifyObservers(pi, type);
                }
            }
            return this;
        };
        /**
         * Use this method to simulate a pointer up on a mesh
         * The pickResult parameter can be obtained from a scene.pick or scene.pickWithRay
         */
        Scene.prototype.simulatePointerUp = function (pickResult) {
            var evt = new PointerEvent("pointerup");
            var clickInfo = new ClickInfo();
            clickInfo.singleClick = true;
            clickInfo.ignore = true;
            return this._processPointerUp(pickResult, evt, clickInfo);
        };
        Scene.prototype._processPointerUp = function (pickResult, evt, clickInfo) {
            if (pickResult && pickResult && pickResult.pickedMesh) {
                this._pickedUpMesh = pickResult.pickedMesh;
                if (this._pickedDownMesh === this._pickedUpMesh) {
                    if (this.onPointerPick) {
                        this.onPointerPick(evt, pickResult);
                    }
                    if (clickInfo.singleClick && !clickInfo.ignore && this.onPointerObservable.hasObservers()) {
                        var type = BABYLON.PointerEventTypes.POINTERPICK;
                        var pi = new BABYLON.PointerInfo(type, evt, pickResult);
                        this.onPointerObservable.notifyObservers(pi, type);
                    }
                }
                if (pickResult.pickedMesh.actionManager) {
                    if (clickInfo.ignore) {
                        pickResult.pickedMesh.actionManager.processTrigger(BABYLON.ActionManager.OnPickUpTrigger, BABYLON.ActionEvent.CreateNew(pickResult.pickedMesh, evt));
                    }
                    if (!clickInfo.hasSwiped && !clickInfo.ignore && clickInfo.singleClick) {
                        pickResult.pickedMesh.actionManager.processTrigger(BABYLON.ActionManager.OnPickTrigger, BABYLON.ActionEvent.CreateNew(pickResult.pickedMesh, evt));
                    }
                    if (clickInfo.doubleClick && !clickInfo.ignore && pickResult.pickedMesh.actionManager.hasSpecificTrigger(BABYLON.ActionManager.OnDoublePickTrigger)) {
                        pickResult.pickedMesh.actionManager.processTrigger(BABYLON.ActionManager.OnDoublePickTrigger, BABYLON.ActionEvent.CreateNew(pickResult.pickedMesh, evt));
                    }
                }
            }
            if (this._pickedDownMesh &&
                this._pickedDownMesh.actionManager &&
                this._pickedDownMesh.actionManager.hasSpecificTrigger(BABYLON.ActionManager.OnPickOutTrigger) &&
                this._pickedDownMesh !== this._pickedUpMesh) {
                this._pickedDownMesh.actionManager.processTrigger(BABYLON.ActionManager.OnPickOutTrigger, BABYLON.ActionEvent.CreateNew(this._pickedDownMesh, evt));
            }
            if (this.onPointerUp) {
                this.onPointerUp(evt, pickResult);
            }
            if (this.onPointerObservable.hasObservers()) {
                if (!clickInfo.ignore) {
                    if (!clickInfo.hasSwiped) {
                        if (clickInfo.singleClick && this.onPointerObservable.hasSpecificMask(BABYLON.PointerEventTypes.POINTERTAP)) {
                            var type = BABYLON.PointerEventTypes.POINTERTAP;
                            var pi = new BABYLON.PointerInfo(type, evt, pickResult);
                            this.onPointerObservable.notifyObservers(pi, type);
                        }
                        if (clickInfo.doubleClick && this.onPointerObservable.hasSpecificMask(BABYLON.PointerEventTypes.POINTERDOUBLETAP)) {
                            var type = BABYLON.PointerEventTypes.POINTERDOUBLETAP;
                            var pi = new BABYLON.PointerInfo(type, evt, pickResult);
                            this.onPointerObservable.notifyObservers(pi, type);
                        }
                    }
                }
                else {
                    var type = BABYLON.PointerEventTypes.POINTERUP;
                    var pi = new BABYLON.PointerInfo(type, evt, pickResult);
                    this.onPointerObservable.notifyObservers(pi, type);
                }
            }
            return this;
        };
        /**
        * Attach events to the canvas (To handle actionManagers triggers and raise onPointerMove, onPointerDown and onPointerUp
        * @param attachUp defines if you want to attach events to pointerup
        * @param attachDown defines if you want to attach events to pointerdown
        * @param attachMove defines if you want to attach events to pointermove
        */
        Scene.prototype.attachControl = function (attachUp, attachDown, attachMove) {
            var _this = this;
            if (attachUp === void 0) { attachUp = true; }
            if (attachDown === void 0) { attachDown = true; }
            if (attachMove === void 0) { attachMove = true; }
            this._initActionManager = function (act, clickInfo) {
                if (!_this._meshPickProceed) {
                    var pickResult = _this.pick(_this._unTranslatedPointerX, _this._unTranslatedPointerY, _this.pointerDownPredicate, false, _this.cameraToUseForPointers);
                    _this._currentPickResult = pickResult;
                    if (pickResult) {
                        act = (pickResult.hit && pickResult.pickedMesh) ? pickResult.pickedMesh.actionManager : null;
                    }
                    _this._meshPickProceed = true;
                }
                return act;
            };
            this._delayedSimpleClick = function (btn, clickInfo, cb) {
                // double click delay is over and that no double click has been raised since, or the 2 consecutive keys pressed are different
                if ((new Date().getTime() - _this._previousStartingPointerTime > Scene.DoubleClickDelay && !_this._doubleClickOccured) ||
                    btn !== _this._previousButtonPressed) {
                    _this._doubleClickOccured = false;
                    clickInfo.singleClick = true;
                    clickInfo.ignore = false;
                    cb(clickInfo, _this._currentPickResult);
                }
            };
            this._initClickEvent = function (obs1, obs2, evt, cb) {
                var clickInfo = new ClickInfo();
                _this._currentPickResult = null;
                var act = null;
                var checkPicking = obs1.hasSpecificMask(BABYLON.PointerEventTypes.POINTERPICK) || obs2.hasSpecificMask(BABYLON.PointerEventTypes.POINTERPICK)
                    || obs1.hasSpecificMask(BABYLON.PointerEventTypes.POINTERTAP) || obs2.hasSpecificMask(BABYLON.PointerEventTypes.POINTERTAP)
                    || obs1.hasSpecificMask(BABYLON.PointerEventTypes.POINTERDOUBLETAP) || obs2.hasSpecificMask(BABYLON.PointerEventTypes.POINTERDOUBLETAP);
                if (!checkPicking && BABYLON.ActionManager && BABYLON.ActionManager.HasPickTriggers) {
                    act = _this._initActionManager(act, clickInfo);
                    if (act)
                        checkPicking = act.hasPickTriggers;
                }
                if (checkPicking) {
                    var btn = evt.button;
                    clickInfo.hasSwiped = Math.abs(_this._startingPointerPosition.x - _this._pointerX) > Scene.DragMovementThreshold ||
                        Math.abs(_this._startingPointerPosition.y - _this._pointerY) > Scene.DragMovementThreshold;
                    if (!clickInfo.hasSwiped) {
                        var checkSingleClickImmediately = !Scene.ExclusiveDoubleClickMode;
                        if (!checkSingleClickImmediately) {
                            checkSingleClickImmediately = !obs1.hasSpecificMask(BABYLON.PointerEventTypes.POINTERDOUBLETAP) &&
                                !obs2.hasSpecificMask(BABYLON.PointerEventTypes.POINTERDOUBLETAP);
                            if (checkSingleClickImmediately && !BABYLON.ActionManager.HasSpecificTrigger(BABYLON.ActionManager.OnDoublePickTrigger)) {
                                act = _this._initActionManager(act, clickInfo);
                                if (act)
                                    checkSingleClickImmediately = !act.hasSpecificTrigger(BABYLON.ActionManager.OnDoublePickTrigger);
                            }
                        }
                        if (checkSingleClickImmediately) {
                            // single click detected if double click delay is over or two different successive keys pressed without exclusive double click or no double click required
                            if (new Date().getTime() - _this._previousStartingPointerTime > Scene.DoubleClickDelay ||
                                btn !== _this._previousButtonPressed) {
                                clickInfo.singleClick = true;
                                cb(clickInfo, _this._currentPickResult);
                            }
                        }
                        else {
                            // wait that no double click has been raised during the double click delay
                            _this._previousDelayedSimpleClickTimeout = _this._delayedSimpleClickTimeout;
                            _this._delayedSimpleClickTimeout = window.setTimeout(_this._delayedSimpleClick.bind(_this, btn, clickInfo, cb), Scene.DoubleClickDelay);
                        }
                        var checkDoubleClick = obs1.hasSpecificMask(BABYLON.PointerEventTypes.POINTERDOUBLETAP) ||
                            obs2.hasSpecificMask(BABYLON.PointerEventTypes.POINTERDOUBLETAP);
                        if (!checkDoubleClick && BABYLON.ActionManager.HasSpecificTrigger(BABYLON.ActionManager.OnDoublePickTrigger)) {
                            act = _this._initActionManager(act, clickInfo);
                            if (act)
                                checkDoubleClick = act.hasSpecificTrigger(BABYLON.ActionManager.OnDoublePickTrigger);
                        }
                        if (checkDoubleClick) {
                            // two successive keys pressed are equal, double click delay is not over and double click has not just occurred
                            if (btn === _this._previousButtonPressed &&
                                new Date().getTime() - _this._previousStartingPointerTime < Scene.DoubleClickDelay &&
                                !_this._doubleClickOccured) {
                                // pointer has not moved for 2 clicks, it's a double click
                                if (!clickInfo.hasSwiped &&
                                    Math.abs(_this._previousStartingPointerPosition.x - _this._startingPointerPosition.x) < Scene.DragMovementThreshold &&
                                    Math.abs(_this._previousStartingPointerPosition.y - _this._startingPointerPosition.y) < Scene.DragMovementThreshold) {
                                    _this._previousStartingPointerTime = 0;
                                    _this._doubleClickOccured = true;
                                    clickInfo.doubleClick = true;
                                    clickInfo.ignore = false;
                                    if (Scene.ExclusiveDoubleClickMode && _this._previousDelayedSimpleClickTimeout) {
                                        clearTimeout(_this._previousDelayedSimpleClickTimeout);
                                    }
                                    _this._previousDelayedSimpleClickTimeout = _this._delayedSimpleClickTimeout;
                                    cb(clickInfo, _this._currentPickResult);
                                }
                                else {
                                    _this._doubleClickOccured = false;
                                    _this._previousStartingPointerTime = _this._startingPointerTime;
                                    _this._previousStartingPointerPosition.x = _this._startingPointerPosition.x;
                                    _this._previousStartingPointerPosition.y = _this._startingPointerPosition.y;
                                    _this._previousButtonPressed = btn;
                                    if (Scene.ExclusiveDoubleClickMode) {
                                        if (_this._previousDelayedSimpleClickTimeout) {
                                            clearTimeout(_this._previousDelayedSimpleClickTimeout);
                                        }
                                        _this._previousDelayedSimpleClickTimeout = _this._delayedSimpleClickTimeout;
                                        cb(clickInfo, _this._previousPickResult);
                                    }
                                    else {
                                        cb(clickInfo, _this._currentPickResult);
                                    }
                                }
                            }
                            else {
                                _this._doubleClickOccured = false;
                                _this._previousStartingPointerTime = _this._startingPointerTime;
                                _this._previousStartingPointerPosition.x = _this._startingPointerPosition.x;
                                _this._previousStartingPointerPosition.y = _this._startingPointerPosition.y;
                                _this._previousButtonPressed = btn;
                            }
                        }
                    }
                }
                clickInfo.ignore = true;
                cb(clickInfo, _this._currentPickResult);
            };
            this._spritePredicate = function (sprite) {
                return sprite.isPickable && sprite.actionManager && sprite.actionManager.hasPointerTriggers;
            };
            this._onPointerMove = function (evt) {
                _this._updatePointerPosition(evt);
                // PreObservable support
                if (_this.onPrePointerObservable.hasObservers()) {
                    var type = evt.type === "mousewheel" || evt.type === "DOMMouseScroll" ? BABYLON.PointerEventTypes.POINTERWHEEL : BABYLON.PointerEventTypes.POINTERMOVE;
                    var pi = new BABYLON.PointerInfoPre(type, evt, _this._unTranslatedPointerX, _this._unTranslatedPointerY);
                    _this.onPrePointerObservable.notifyObservers(pi, type);
                    if (pi.skipOnPointerObservable) {
                        return;
                    }
                }
                if (!_this.cameraToUseForPointers && !_this.activeCamera) {
                    return;
                }
                if (!_this.pointerMovePredicate) {
                    _this.pointerMovePredicate = function (mesh) { return mesh.isPickable && mesh.isVisible && mesh.isReady() && mesh.isEnabled() && (mesh.enablePointerMoveEvents || _this.constantlyUpdateMeshUnderPointer || (mesh.actionManager !== null && mesh.actionManager !== undefined)); };
                }
                // Meshes
                var pickResult = _this.pick(_this._unTranslatedPointerX, _this._unTranslatedPointerY, _this.pointerMovePredicate, false, _this.cameraToUseForPointers);
                _this._processPointerMove(pickResult, evt);
            };
            this._onPointerDown = function (evt) {
                _this._totalPointersPressed++;
                _this._pickedDownMesh = null;
                _this._meshPickProceed = false;
                _this._updatePointerPosition(evt);
                if (_this.preventDefaultOnPointerDown && canvas) {
                    evt.preventDefault();
                    canvas.focus();
                }
                // PreObservable support
                if (_this.onPrePointerObservable.hasObservers()) {
                    var type = BABYLON.PointerEventTypes.POINTERDOWN;
                    var pi = new BABYLON.PointerInfoPre(type, evt, _this._unTranslatedPointerX, _this._unTranslatedPointerY);
                    _this.onPrePointerObservable.notifyObservers(pi, type);
                    if (pi.skipOnPointerObservable) {
                        return;
                    }
                }
                if (!_this.cameraToUseForPointers && !_this.activeCamera) {
                    return;
                }
                _this._startingPointerPosition.x = _this._pointerX;
                _this._startingPointerPosition.y = _this._pointerY;
                _this._startingPointerTime = new Date().getTime();
                if (!_this.pointerDownPredicate) {
                    _this.pointerDownPredicate = function (mesh) {
                        return mesh.isPickable && mesh.isVisible && mesh.isReady() && mesh.isEnabled();
                    };
                }
                // Meshes
                _this._pickedDownMesh = null;
                var pickResult = _this.pick(_this._unTranslatedPointerX, _this._unTranslatedPointerY, _this.pointerDownPredicate, false, _this.cameraToUseForPointers);
                _this._processPointerDown(pickResult, evt);
                // Sprites
                _this._pickedDownSprite = null;
                if (_this.spriteManagers.length > 0) {
                    pickResult = _this.pickSprite(_this._unTranslatedPointerX, _this._unTranslatedPointerY, _this._spritePredicate, false, _this.cameraToUseForPointers || undefined);
                    if (pickResult && pickResult.hit && pickResult.pickedSprite) {
                        if (pickResult.pickedSprite.actionManager) {
                            _this._pickedDownSprite = pickResult.pickedSprite;
                            switch (evt.button) {
                                case 0:
                                    pickResult.pickedSprite.actionManager.processTrigger(BABYLON.ActionManager.OnLeftPickTrigger, BABYLON.ActionEvent.CreateNewFromSprite(pickResult.pickedSprite, _this, evt));
                                    break;
                                case 1:
                                    pickResult.pickedSprite.actionManager.processTrigger(BABYLON.ActionManager.OnCenterPickTrigger, BABYLON.ActionEvent.CreateNewFromSprite(pickResult.pickedSprite, _this, evt));
                                    break;
                                case 2:
                                    pickResult.pickedSprite.actionManager.processTrigger(BABYLON.ActionManager.OnRightPickTrigger, BABYLON.ActionEvent.CreateNewFromSprite(pickResult.pickedSprite, _this, evt));
                                    break;
                            }
                            if (pickResult.pickedSprite.actionManager) {
                                pickResult.pickedSprite.actionManager.processTrigger(BABYLON.ActionManager.OnPickDownTrigger, BABYLON.ActionEvent.CreateNewFromSprite(pickResult.pickedSprite, _this, evt));
                            }
                        }
                    }
                }
            };
            this._onPointerUp = function (evt) {
                if (_this._totalPointersPressed === 0) {
                    return; // So we need to test it the pointer down was pressed before.
                }
                _this._totalPointersPressed--;
                _this._pickedUpMesh = null;
                _this._meshPickProceed = false;
                _this._updatePointerPosition(evt);
                _this._initClickEvent(_this.onPrePointerObservable, _this.onPointerObservable, evt, function (clickInfo, pickResult) {
                    // PreObservable support
                    if (_this.onPrePointerObservable.hasObservers()) {
                        if (!clickInfo.ignore) {
                            if (!clickInfo.hasSwiped) {
                                if (clickInfo.singleClick && _this.onPrePointerObservable.hasSpecificMask(BABYLON.PointerEventTypes.POINTERTAP)) {
                                    var type = BABYLON.PointerEventTypes.POINTERTAP;
                                    var pi = new BABYLON.PointerInfoPre(type, evt, _this._unTranslatedPointerX, _this._unTranslatedPointerY);
                                    _this.onPrePointerObservable.notifyObservers(pi, type);
                                    if (pi.skipOnPointerObservable) {
                                        return;
                                    }
                                }
                                if (clickInfo.doubleClick && _this.onPrePointerObservable.hasSpecificMask(BABYLON.PointerEventTypes.POINTERDOUBLETAP)) {
                                    var type = BABYLON.PointerEventTypes.POINTERDOUBLETAP;
                                    var pi = new BABYLON.PointerInfoPre(type, evt, _this._unTranslatedPointerX, _this._unTranslatedPointerY);
                                    _this.onPrePointerObservable.notifyObservers(pi, type);
                                    if (pi.skipOnPointerObservable) {
                                        return;
                                    }
                                }
                            }
                        }
                        else {
                            var type = BABYLON.PointerEventTypes.POINTERUP;
                            var pi = new BABYLON.PointerInfoPre(type, evt, _this._unTranslatedPointerX, _this._unTranslatedPointerY);
                            _this.onPrePointerObservable.notifyObservers(pi, type);
                            if (pi.skipOnPointerObservable) {
                                return;
                            }
                        }
                    }
                    if (!_this.cameraToUseForPointers && !_this.activeCamera) {
                        return;
                    }
                    if (!_this.pointerUpPredicate) {
                        _this.pointerUpPredicate = function (mesh) {
                            return mesh.isPickable && mesh.isVisible && mesh.isReady() && mesh.isEnabled();
                        };
                    }
                    // Meshes
                    if (!_this._meshPickProceed && (BABYLON.ActionManager && BABYLON.ActionManager.HasTriggers || _this.onPointerObservable.hasObservers())) {
                        _this._initActionManager(null, clickInfo);
                    }
                    if (!pickResult) {
                        pickResult = _this._currentPickResult;
                    }
                    _this._processPointerUp(pickResult, evt, clickInfo);
                    // Sprites
                    if (_this.spriteManagers.length > 0) {
                        var spritePickResult = _this.pickSprite(_this._unTranslatedPointerX, _this._unTranslatedPointerY, _this._spritePredicate, false, _this.cameraToUseForPointers || undefined);
                        if (spritePickResult) {
                            if (spritePickResult.hit && spritePickResult.pickedSprite) {
                                if (spritePickResult.pickedSprite.actionManager) {
                                    spritePickResult.pickedSprite.actionManager.processTrigger(BABYLON.ActionManager.OnPickUpTrigger, BABYLON.ActionEvent.CreateNewFromSprite(spritePickResult.pickedSprite, _this, evt));
                                    if (spritePickResult.pickedSprite.actionManager) {
                                        if (Math.abs(_this._startingPointerPosition.x - _this._pointerX) < Scene.DragMovementThreshold && Math.abs(_this._startingPointerPosition.y - _this._pointerY) < Scene.DragMovementThreshold) {
                                            spritePickResult.pickedSprite.actionManager.processTrigger(BABYLON.ActionManager.OnPickTrigger, BABYLON.ActionEvent.CreateNewFromSprite(spritePickResult.pickedSprite, _this, evt));
                                        }
                                    }
                                }
                            }
                            if (_this._pickedDownSprite && _this._pickedDownSprite.actionManager && _this._pickedDownSprite !== spritePickResult.pickedSprite) {
                                _this._pickedDownSprite.actionManager.processTrigger(BABYLON.ActionManager.OnPickOutTrigger, BABYLON.ActionEvent.CreateNewFromSprite(_this._pickedDownSprite, _this, evt));
                            }
                        }
                    }
                    _this._previousPickResult = _this._currentPickResult;
                });
            };
            this._onKeyDown = function (evt) {
                var type = BABYLON.KeyboardEventTypes.KEYDOWN;
                if (_this.onPreKeyboardObservable.hasObservers()) {
                    var pi = new BABYLON.KeyboardInfoPre(type, evt);
                    _this.onPreKeyboardObservable.notifyObservers(pi, type);
                    if (pi.skipOnPointerObservable) {
                        return;
                    }
                }
                if (_this.onKeyboardObservable.hasObservers()) {
                    var pi = new BABYLON.KeyboardInfo(type, evt);
                    _this.onKeyboardObservable.notifyObservers(pi, type);
                }
                if (_this.actionManager) {
                    _this.actionManager.processTrigger(BABYLON.ActionManager.OnKeyDownTrigger, BABYLON.ActionEvent.CreateNewFromScene(_this, evt));
                }
            };
            this._onKeyUp = function (evt) {
                var type = BABYLON.KeyboardEventTypes.KEYUP;
                if (_this.onPreKeyboardObservable.hasObservers()) {
                    var pi = new BABYLON.KeyboardInfoPre(type, evt);
                    _this.onPreKeyboardObservable.notifyObservers(pi, type);
                    if (pi.skipOnPointerObservable) {
                        return;
                    }
                }
                if (_this.onKeyboardObservable.hasObservers()) {
                    var pi = new BABYLON.KeyboardInfo(type, evt);
                    _this.onKeyboardObservable.notifyObservers(pi, type);
                }
                if (_this.actionManager) {
                    _this.actionManager.processTrigger(BABYLON.ActionManager.OnKeyUpTrigger, BABYLON.ActionEvent.CreateNewFromScene(_this, evt));
                }
            };
            var engine = this.getEngine();
            this._onCanvasFocusObserver = engine.onCanvasFocusObservable.add(function () {
                if (!canvas) {
                    return;
                }
                canvas.addEventListener("keydown", _this._onKeyDown, false);
                canvas.addEventListener("keyup", _this._onKeyUp, false);
            });
            this._onCanvasBlurObserver = engine.onCanvasBlurObservable.add(function () {
                if (!canvas) {
                    return;
                }
                canvas.removeEventListener("keydown", _this._onKeyDown);
                canvas.removeEventListener("keyup", _this._onKeyUp);
            });
            var eventPrefix = BABYLON.Tools.GetPointerPrefix();
            var canvas = this._engine.getRenderingCanvas();
            if (!canvas) {
                return;
            }
            if (attachMove) {
                canvas.addEventListener(eventPrefix + "move", this._onPointerMove, false);
                // Wheel
                canvas.addEventListener('mousewheel', this._onPointerMove, false);
                canvas.addEventListener('DOMMouseScroll', this._onPointerMove, false);
            }
            if (attachDown) {
                canvas.addEventListener(eventPrefix + "down", this._onPointerDown, false);
            }
            if (attachUp) {
                window.addEventListener(eventPrefix + "up", this._onPointerUp, false);
            }
            canvas.tabIndex = 1;
        };
        Scene.prototype.detachControl = function () {
            var engine = this.getEngine();
            var eventPrefix = BABYLON.Tools.GetPointerPrefix();
            var canvas = engine.getRenderingCanvas();
            if (!canvas) {
                return;
            }
            canvas.removeEventListener(eventPrefix + "move", this._onPointerMove);
            canvas.removeEventListener(eventPrefix + "down", this._onPointerDown);
            window.removeEventListener(eventPrefix + "up", this._onPointerUp);
            if (this._onCanvasBlurObserver) {
                engine.onCanvasBlurObservable.remove(this._onCanvasBlurObserver);
            }
            if (this._onCanvasFocusObserver) {
                engine.onCanvasFocusObservable.remove(this._onCanvasFocusObserver);
            }
            // Wheel
            canvas.removeEventListener('mousewheel', this._onPointerMove);
            canvas.removeEventListener('DOMMouseScroll', this._onPointerMove);
            // Keyboard
            canvas.removeEventListener("keydown", this._onKeyDown);
            canvas.removeEventListener("keyup", this._onKeyUp);
            // Observables
            this.onKeyboardObservable.clear();
            this.onPreKeyboardObservable.clear();
            this.onPointerObservable.clear();
            this.onPrePointerObservable.clear();
        };
        // Ready
        Scene.prototype.isReady = function () {
            if (this._isDisposed) {
                return false;
            }
            if (this._pendingData.length > 0) {
                return false;
            }
            var index;
            // Geometries
            for (index = 0; index < this._geometries.length; index++) {
                var geometry = this._geometries[index];
                if (geometry.delayLoadState === BABYLON.Engine.DELAYLOADSTATE_LOADING) {
                    return false;
                }
            }
            // Meshes
            for (index = 0; index < this.meshes.length; index++) {
                var mesh = this.meshes[index];
                if (!mesh.isEnabled()) {
                    continue;
                }
                if (!mesh.subMeshes || mesh.subMeshes.length === 0) {
                    continue;
                }
                if (!mesh.isReady()) {
                    return false;
                }
                var mat = mesh.material;
                if (mat) {
                    if (!mat.isReady(mesh)) {
                        return false;
                    }
                }
            }
            return true;
        };
        Scene.prototype.resetCachedMaterial = function () {
            this._cachedMaterial = null;
            this._cachedEffect = null;
            this._cachedVisibility = null;
        };
        Scene.prototype.registerBeforeRender = function (func) {
            this.onBeforeRenderObservable.add(func);
        };
        Scene.prototype.unregisterBeforeRender = function (func) {
            this.onBeforeRenderObservable.removeCallback(func);
        };
        Scene.prototype.registerAfterRender = function (func) {
            this.onAfterRenderObservable.add(func);
        };
        Scene.prototype.unregisterAfterRender = function (func) {
            this.onAfterRenderObservable.removeCallback(func);
        };
        Scene.prototype._addPendingData = function (data) {
            this._pendingData.push(data);
        };
        Scene.prototype._removePendingData = function (data) {
            var wasLoading = this.isLoading;
            var index = this._pendingData.indexOf(data);
            if (index !== -1) {
                this._pendingData.splice(index, 1);
            }
            if (wasLoading && !this.isLoading) {
                this.onDataLoadedObservable.notifyObservers(this);
            }
        };
        Scene.prototype.getWaitingItemsCount = function () {
            return this._pendingData.length;
        };
        Object.defineProperty(Scene.prototype, "isLoading", {
            get: function () {
                return this._pendingData.length > 0;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * Registers a function to be executed when the scene is ready.
         * @param {Function} func - the function to be executed.
         */
        Scene.prototype.executeWhenReady = function (func) {
            var _this = this;
            this.onReadyObservable.add(func);
            if (this._executeWhenReadyTimeoutId !== -1) {
                return;
            }
            this._executeWhenReadyTimeoutId = setTimeout(function () {
                _this._checkIsReady();
            }, 150);
        };
        Scene.prototype._checkIsReady = function () {
            var _this = this;
            if (this.isReady()) {
                this.onReadyObservable.notifyObservers(this);
                this.onReadyObservable.clear();
                this._executeWhenReadyTimeoutId = -1;
                return;
            }
            this._executeWhenReadyTimeoutId = setTimeout(function () {
                _this._checkIsReady();
            }, 150);
        };
        // Animations
        /**
         * Will start the animation sequence of a given target
         * @param target - the target
         * @param {number} from - from which frame should animation start
         * @param {number} to - till which frame should animation run.
         * @param {boolean} [loop] - should the animation loop
         * @param {number} [speedRatio] - the speed in which to run the animation
         * @param {Function} [onAnimationEnd] function to be executed when the animation ended.
         * @param {BABYLON.Animatable} [animatable] an animatable object. If not provided a new one will be created from the given params.
         * Returns {BABYLON.Animatable} the animatable object created for this animation
         * See BABYLON.Animatable
         */
        Scene.prototype.beginAnimation = function (target, from, to, loop, speedRatio, onAnimationEnd, animatable) {
            if (speedRatio === void 0) { speedRatio = 1.0; }
            if (from > to && speedRatio > 0) {
                speedRatio *= -1;
            }
            this.stopAnimation(target);
            if (!animatable) {
                animatable = new BABYLON.Animatable(this, target, from, to, loop, speedRatio, onAnimationEnd);
            }
            // Local animations
            if (target.animations) {
                animatable.appendAnimations(target, target.animations);
            }
            // Children animations
            if (target.getAnimatables) {
                var animatables = target.getAnimatables();
                for (var index = 0; index < animatables.length; index++) {
                    this.beginAnimation(animatables[index], from, to, loop, speedRatio, onAnimationEnd, animatable);
                }
            }
            animatable.reset();
            return animatable;
        };
        Scene.prototype.beginDirectAnimation = function (target, animations, from, to, loop, speedRatio, onAnimationEnd) {
            if (speedRatio === undefined) {
                speedRatio = 1.0;
            }
            var animatable = new BABYLON.Animatable(this, target, from, to, loop, speedRatio, onAnimationEnd, animations);
            return animatable;
        };
        Scene.prototype.getAnimatableByTarget = function (target) {
            for (var index = 0; index < this._activeAnimatables.length; index++) {
                if (this._activeAnimatables[index].target === target) {
                    return this._activeAnimatables[index];
                }
            }
            return null;
        };
        Object.defineProperty(Scene.prototype, "Animatables", {
            get: function () {
                return this._activeAnimatables;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * Will stop the animation of the given target
         * @param target - the target
         * @param animationName - the name of the animation to stop (all animations will be stopped is empty)
         * @see beginAnimation
         */
        Scene.prototype.stopAnimation = function (target, animationName) {
            var animatable = this.getAnimatableByTarget(target);
            if (animatable) {
                animatable.stop(animationName);
            }
        };
        /**
         * Stops and removes all animations that have been applied to the scene
         */
        Scene.prototype.stopAllAnimations = function () {
            if (this._activeAnimatables) {
                for (var i = 0; i < this._activeAnimatables.length; i++) {
                    this._activeAnimatables[i].stop();
                }
                this._activeAnimatables = [];
            }
        };
        Scene.prototype._animate = function () {
            if (!this.animationsEnabled || this._activeAnimatables.length === 0) {
                return;
            }
            // Getting time
            var now = BABYLON.Tools.Now;
            if (!this._animationTimeLast) {
                if (this._pendingData.length > 0) {
                    return;
                }
                this._animationTimeLast = now;
            }
            var deltaTime = this.useConstantAnimationDeltaTime ? 16.0 : (now - this._animationTimeLast) * this.animationTimeScale;
            this._animationTime += deltaTime;
            this._animationTimeLast = now;
            for (var index = 0; index < this._activeAnimatables.length; index++) {
                this._activeAnimatables[index]._animate(this._animationTime);
            }
        };
        // Matrix
        Scene.prototype._switchToAlternateCameraConfiguration = function (active) {
            this._useAlternateCameraConfiguration = active;
        };
        Scene.prototype.getViewMatrix = function () {
            return this._useAlternateCameraConfiguration ? this._alternateViewMatrix : this._viewMatrix;
        };
        Scene.prototype.getProjectionMatrix = function () {
            return this._useAlternateCameraConfiguration ? this._alternateProjectionMatrix : this._projectionMatrix;
        };
        Scene.prototype.getTransformMatrix = function () {
            return this._useAlternateCameraConfiguration ? this._alternateTransformMatrix : this._transformMatrix;
        };
        Scene.prototype.setTransformMatrix = function (view, projection) {
            if (this._viewUpdateFlag === view.updateFlag && this._projectionUpdateFlag === projection.updateFlag) {
                return;
            }
            this._viewUpdateFlag = view.updateFlag;
            this._projectionUpdateFlag = projection.updateFlag;
            this._viewMatrix = view;
            this._projectionMatrix = projection;
            this._viewMatrix.multiplyToRef(this._projectionMatrix, this._transformMatrix);
            // Update frustum
            if (!this._frustumPlanes) {
                this._frustumPlanes = BABYLON.Frustum.GetPlanes(this._transformMatrix);
            }
            else {
                BABYLON.Frustum.GetPlanesToRef(this._transformMatrix, this._frustumPlanes);
            }
            if (this.activeCamera && this.activeCamera._alternateCamera) {
                var otherCamera = this.activeCamera._alternateCamera;
                otherCamera.getViewMatrix().multiplyToRef(otherCamera.getProjectionMatrix(), BABYLON.Tmp.Matrix[0]);
                BABYLON.Frustum.GetRightPlaneToRef(BABYLON.Tmp.Matrix[0], this._frustumPlanes[3]); // Replace right plane by second camera right plane
            }
            if (this._sceneUbo.useUbo) {
                this._sceneUbo.updateMatrix("viewProjection", this._transformMatrix);
                this._sceneUbo.updateMatrix("view", this._viewMatrix);
                this._sceneUbo.update();
            }
        };
        Scene.prototype._setAlternateTransformMatrix = function (view, projection) {
            if (this._alternateViewUpdateFlag === view.updateFlag && this._alternateProjectionUpdateFlag === projection.updateFlag) {
                return;
            }
            this._alternateViewUpdateFlag = view.updateFlag;
            this._alternateProjectionUpdateFlag = projection.updateFlag;
            this._alternateViewMatrix = view;
            this._alternateProjectionMatrix = projection;
            if (!this._alternateTransformMatrix) {
                this._alternateTransformMatrix = BABYLON.Matrix.Zero();
            }
            this._alternateViewMatrix.multiplyToRef(this._alternateProjectionMatrix, this._alternateTransformMatrix);
            if (!this._alternateSceneUbo) {
                this._createAlternateUbo();
            }
            if (this._alternateSceneUbo.useUbo) {
                this._alternateSceneUbo.updateMatrix("viewProjection", this._alternateTransformMatrix);
                this._alternateSceneUbo.updateMatrix("view", this._alternateViewMatrix);
                this._alternateSceneUbo.update();
            }
        };
        Scene.prototype.getSceneUniformBuffer = function () {
            return this._useAlternateCameraConfiguration ? this._alternateSceneUbo : this._sceneUbo;
        };
        // Methods
        Scene.prototype.getUniqueId = function () {
            var result = Scene._uniqueIdCounter;
            Scene._uniqueIdCounter++;
            return result;
        };
        Scene.prototype.addMesh = function (newMesh) {
            this.meshes.push(newMesh);
            //notify the collision coordinator
            if (this.collisionCoordinator) {
                this.collisionCoordinator.onMeshAdded(newMesh);
            }
            this.onNewMeshAddedObservable.notifyObservers(newMesh);
        };
        Scene.prototype.removeMesh = function (toRemove) {
            var index = this.meshes.indexOf(toRemove);
            if (index !== -1) {
                // Remove from the scene if mesh found
                this.meshes.splice(index, 1);
            }
            this.onMeshRemovedObservable.notifyObservers(toRemove);
            return index;
        };
        Scene.prototype.addTransformNode = function (newTransformNode) {
            this.transformNodes.push(newTransformNode);
            this.onNewTransformNodeAddedObservable.notifyObservers(newTransformNode);
        };
        Scene.prototype.removeTransformNode = function (toRemove) {
            var index = this.transformNodes.indexOf(toRemove);
            if (index !== -1) {
                // Remove from the scene if found
                this.transformNodes.splice(index, 1);
            }
            this.onTransformNodeRemovedObservable.notifyObservers(toRemove);
            return index;
        };
        Scene.prototype.removeSkeleton = function (toRemove) {
            var index = this.skeletons.indexOf(toRemove);
            if (index !== -1) {
                // Remove from the scene if found
                this.skeletons.splice(index, 1);
            }
            return index;
        };
        Scene.prototype.removeMorphTargetManager = function (toRemove) {
            var index = this.morphTargetManagers.indexOf(toRemove);
            if (index !== -1) {
                // Remove from the scene if found
                this.morphTargetManagers.splice(index, 1);
            }
            return index;
        };
        Scene.prototype.removeLight = function (toRemove) {
            var index = this.lights.indexOf(toRemove);
            if (index !== -1) {
                // Remove from the scene if mesh found
                this.lights.splice(index, 1);
                this.sortLightsByPriority();
            }
            this.onLightRemovedObservable.notifyObservers(toRemove);
            return index;
        };
        Scene.prototype.removeCamera = function (toRemove) {
            var index = this.cameras.indexOf(toRemove);
            if (index !== -1) {
                // Remove from the scene if mesh found
                this.cameras.splice(index, 1);
            }
            // Remove from activeCameras
            var index2 = this.activeCameras.indexOf(toRemove);
            if (index2 !== -1) {
                // Remove from the scene if mesh found
                this.activeCameras.splice(index2, 1);
            }
            // Reset the activeCamera
            if (this.activeCamera === toRemove) {
                if (this.cameras.length > 0) {
                    this.activeCamera = this.cameras[0];
                }
                else {
                    this.activeCamera = null;
                }
            }
            this.onCameraRemovedObservable.notifyObservers(toRemove);
            return index;
        };
        Scene.prototype.addLight = function (newLight) {
            this.lights.push(newLight);
            this.sortLightsByPriority();
            this.onNewLightAddedObservable.notifyObservers(newLight);
        };
        Scene.prototype.sortLightsByPriority = function () {
            if (this.requireLightSorting) {
                this.lights.sort(BABYLON.Light.compareLightsPriority);
            }
        };
        Scene.prototype.addCamera = function (newCamera) {
            this.cameras.push(newCamera);
            this.onNewCameraAddedObservable.notifyObservers(newCamera);
        };
        /**
         * Switch active camera
         * @param {Camera} newCamera - new active camera
         * @param {boolean} attachControl - call attachControl for the new active camera (default: true)
         */
        Scene.prototype.switchActiveCamera = function (newCamera, attachControl) {
            if (attachControl === void 0) { attachControl = true; }
            var canvas = this._engine.getRenderingCanvas();
            if (!canvas) {
                return;
            }
            if (this.activeCamera) {
                this.activeCamera.detachControl(canvas);
            }
            this.activeCamera = newCamera;
            if (attachControl) {
                newCamera.attachControl(canvas);
            }
        };
        /**
         * sets the active camera of the scene using its ID
         * @param {string} id - the camera's ID
         * @return {BABYLON.Camera|null} the new active camera or null if none found.
         * @see activeCamera
         */
        Scene.prototype.setActiveCameraByID = function (id) {
            var camera = this.getCameraByID(id);
            if (camera) {
                this.activeCamera = camera;
                return camera;
            }
            return null;
        };
        /**
         * sets the active camera of the scene using its name
         * @param {string} name - the camera's name
         * @return {BABYLON.Camera|null} the new active camera or null if none found.
         * @see activeCamera
         */
        Scene.prototype.setActiveCameraByName = function (name) {
            var camera = this.getCameraByName(name);
            if (camera) {
                this.activeCamera = camera;
                return camera;
            }
            return null;
        };
        /**
         * get a material using its id
         * @param {string} the material's ID
         * @return {BABYLON.Material|null} the material or null if none found.
         */
        Scene.prototype.getMaterialByID = function (id) {
            for (var index = 0; index < this.materials.length; index++) {
                if (this.materials[index].id === id) {
                    return this.materials[index];
                }
            }
            return null;
        };
        /**
         * get a material using its name
         * @param {string} the material's name
         * @return {BABYLON.Material|null} the material or null if none found.
         */
        Scene.prototype.getMaterialByName = function (name) {
            for (var index = 0; index < this.materials.length; index++) {
                if (this.materials[index].name === name) {
                    return this.materials[index];
                }
            }
            return null;
        };
        Scene.prototype.getLensFlareSystemByName = function (name) {
            for (var index = 0; index < this.lensFlareSystems.length; index++) {
                if (this.lensFlareSystems[index].name === name) {
                    return this.lensFlareSystems[index];
                }
            }
            return null;
        };
        Scene.prototype.getLensFlareSystemByID = function (id) {
            for (var index = 0; index < this.lensFlareSystems.length; index++) {
                if (this.lensFlareSystems[index].id === id) {
                    return this.lensFlareSystems[index];
                }
            }
            return null;
        };
        Scene.prototype.getCameraByID = function (id) {
            for (var index = 0; index < this.cameras.length; index++) {
                if (this.cameras[index].id === id) {
                    return this.cameras[index];
                }
            }
            return null;
        };
        Scene.prototype.getCameraByUniqueID = function (uniqueId) {
            for (var index = 0; index < this.cameras.length; index++) {
                if (this.cameras[index].uniqueId === uniqueId) {
                    return this.cameras[index];
                }
            }
            return null;
        };
        /**
         * get a camera using its name
         * @param {string} the camera's name
         * @return {BABYLON.Camera|null} the camera or null if none found.
         */
        Scene.prototype.getCameraByName = function (name) {
            for (var index = 0; index < this.cameras.length; index++) {
                if (this.cameras[index].name === name) {
                    return this.cameras[index];
                }
            }
            return null;
        };
        /**
         * get a bone using its id
         * @param {string} the bone's id
         * @return {BABYLON.Bone|null} the bone or null if not found
         */
        Scene.prototype.getBoneByID = function (id) {
            for (var skeletonIndex = 0; skeletonIndex < this.skeletons.length; skeletonIndex++) {
                var skeleton = this.skeletons[skeletonIndex];
                for (var boneIndex = 0; boneIndex < skeleton.bones.length; boneIndex++) {
                    if (skeleton.bones[boneIndex].id === id) {
                        return skeleton.bones[boneIndex];
                    }
                }
            }
            return null;
        };
        /**
        * get a bone using its id
        * @param {string} the bone's name
        * @return {BABYLON.Bone|null} the bone or null if not found
        */
        Scene.prototype.getBoneByName = function (name) {
            for (var skeletonIndex = 0; skeletonIndex < this.skeletons.length; skeletonIndex++) {
                var skeleton = this.skeletons[skeletonIndex];
                for (var boneIndex = 0; boneIndex < skeleton.bones.length; boneIndex++) {
                    if (skeleton.bones[boneIndex].name === name) {
                        return skeleton.bones[boneIndex];
                    }
                }
            }
            return null;
        };
        /**
         * get a light node using its name
         * @param {string} the light's name
         * @return {BABYLON.Light|null} the light or null if none found.
         */
        Scene.prototype.getLightByName = function (name) {
            for (var index = 0; index < this.lights.length; index++) {
                if (this.lights[index].name === name) {
                    return this.lights[index];
                }
            }
            return null;
        };
        /**
         * get a light node using its ID
         * @param {string} the light's id
         * @return {BABYLON.Light|null} the light or null if none found.
         */
        Scene.prototype.getLightByID = function (id) {
            for (var index = 0; index < this.lights.length; index++) {
                if (this.lights[index].id === id) {
                    return this.lights[index];
                }
            }
            return null;
        };
        /**
         * get a light node using its scene-generated unique ID
         * @param {number} the light's unique id
         * @return {BABYLON.Light|null} the light or null if none found.
         */
        Scene.prototype.getLightByUniqueID = function (uniqueId) {
            for (var index = 0; index < this.lights.length; index++) {
                if (this.lights[index].uniqueId === uniqueId) {
                    return this.lights[index];
                }
            }
            return null;
        };
        /**
         * get a particle system by id
         * @param id {number} the particle system id
         * @return {BABYLON.IParticleSystem|null} the corresponding system or null if none found.
         */
        Scene.prototype.getParticleSystemByID = function (id) {
            for (var index = 0; index < this.particleSystems.length; index++) {
                if (this.particleSystems[index].id === id) {
                    return this.particleSystems[index];
                }
            }
            return null;
        };
        /**
         * get a geometry using its ID
         * @param {string} the geometry's id
         * @return {BABYLON.Geometry|null} the geometry or null if none found.
         */
        Scene.prototype.getGeometryByID = function (id) {
            for (var index = 0; index < this._geometries.length; index++) {
                if (this._geometries[index].id === id) {
                    return this._geometries[index];
                }
            }
            return null;
        };
        /**
         * add a new geometry to this scene.
         * @param {BABYLON.Geometry} geometry - the geometry to be added to the scene.
         * @param {boolean} [force] - force addition, even if a geometry with this ID already exists
         * @return {boolean} was the geometry added or not
         */
        Scene.prototype.pushGeometry = function (geometry, force) {
            if (!force && this.getGeometryByID(geometry.id)) {
                return false;
            }
            this._geometries.push(geometry);
            //notify the collision coordinator
            if (this.collisionCoordinator) {
                this.collisionCoordinator.onGeometryAdded(geometry);
            }
            this.onNewGeometryAddedObservable.notifyObservers(geometry);
            return true;
        };
        /**
         * Removes an existing geometry
         * @param {BABYLON.Geometry} geometry - the geometry to be removed from the scene.
         * @return {boolean} was the geometry removed or not
         */
        Scene.prototype.removeGeometry = function (geometry) {
            var index = this._geometries.indexOf(geometry);
            if (index > -1) {
                this._geometries.splice(index, 1);
                //notify the collision coordinator
                if (this.collisionCoordinator) {
                    this.collisionCoordinator.onGeometryDeleted(geometry);
                }
                this.onGeometryRemovedObservable.notifyObservers(geometry);
                return true;
            }
            return false;
        };
        Scene.prototype.getGeometries = function () {
            return this._geometries;
        };
        /**
         * Get the first added mesh found of a given ID
         * @param {string} id - the id to search for
         * @return {BABYLON.AbstractMesh|null} the mesh found or null if not found at all.
         */
        Scene.prototype.getMeshByID = function (id) {
            for (var index = 0; index < this.meshes.length; index++) {
                if (this.meshes[index].id === id) {
                    return this.meshes[index];
                }
            }
            return null;
        };
        Scene.prototype.getMeshesByID = function (id) {
            return this.meshes.filter(function (m) {
                return m.id === id;
            });
        };
        /**
         * Get the first added transform node found of a given ID
         * @param {string} id - the id to search for
         * @return {BABYLON.TransformNode|null} the transform node found or null if not found at all.
         */
        Scene.prototype.getTransformNodeByID = function (id) {
            for (var index = 0; index < this.transformNodes.length; index++) {
                if (this.transformNodes[index].id === id) {
                    return this.transformNodes[index];
                }
            }
            return null;
        };
        Scene.prototype.getTransformNodesByID = function (id) {
            return this.transformNodes.filter(function (m) {
                return m.id === id;
            });
        };
        /**
         * Get a mesh with its auto-generated unique id
         * @param {number} uniqueId - the unique id to search for
         * @return {BABYLON.AbstractMesh|null} the mesh found or null if not found at all.
         */
        Scene.prototype.getMeshByUniqueID = function (uniqueId) {
            for (var index = 0; index < this.meshes.length; index++) {
                if (this.meshes[index].uniqueId === uniqueId) {
                    return this.meshes[index];
                }
            }
            return null;
        };
        /**
         * Get a the last added mesh found of a given ID
         * @param {string} id - the id to search for
         * @return {BABYLON.AbstractMesh|null} the mesh found or null if not found at all.
         */
        Scene.prototype.getLastMeshByID = function (id) {
            for (var index = this.meshes.length - 1; index >= 0; index--) {
                if (this.meshes[index].id === id) {
                    return this.meshes[index];
                }
            }
            return null;
        };
        /**
         * Get a the last added node (Mesh, Camera, Light) found of a given ID
         * @param {string} id - the id to search for
         * @return {BABYLON.Node|null} the node found or null if not found at all.
         */
        Scene.prototype.getLastEntryByID = function (id) {
            var index;
            for (index = this.meshes.length - 1; index >= 0; index--) {
                if (this.meshes[index].id === id) {
                    return this.meshes[index];
                }
            }
            for (index = this.transformNodes.length - 1; index >= 0; index--) {
                if (this.transformNodes[index].id === id) {
                    return this.transformNodes[index];
                }
            }
            for (index = this.cameras.length - 1; index >= 0; index--) {
                if (this.cameras[index].id === id) {
                    return this.cameras[index];
                }
            }
            for (index = this.lights.length - 1; index >= 0; index--) {
                if (this.lights[index].id === id) {
                    return this.lights[index];
                }
            }
            return null;
        };
        Scene.prototype.getNodeByID = function (id) {
            var mesh = this.getMeshByID(id);
            if (mesh) {
                return mesh;
            }
            var light = this.getLightByID(id);
            if (light) {
                return light;
            }
            var camera = this.getCameraByID(id);
            if (camera) {
                return camera;
            }
            var bone = this.getBoneByID(id);
            return bone;
        };
        Scene.prototype.getNodeByName = function (name) {
            var mesh = this.getMeshByName(name);
            if (mesh) {
                return mesh;
            }
            var light = this.getLightByName(name);
            if (light) {
                return light;
            }
            var camera = this.getCameraByName(name);
            if (camera) {
                return camera;
            }
            var bone = this.getBoneByName(name);
            return bone;
        };
        Scene.prototype.getMeshByName = function (name) {
            for (var index = 0; index < this.meshes.length; index++) {
                if (this.meshes[index].name === name) {
                    return this.meshes[index];
                }
            }
            return null;
        };
        Scene.prototype.getTransformNodeByName = function (name) {
            for (var index = 0; index < this.transformNodes.length; index++) {
                if (this.transformNodes[index].name === name) {
                    return this.transformNodes[index];
                }
            }
            return null;
        };
        Scene.prototype.getSoundByName = function (name) {
            var index;
            if (BABYLON.AudioEngine) {
                for (index = 0; index < this.mainSoundTrack.soundCollection.length; index++) {
                    if (this.mainSoundTrack.soundCollection[index].name === name) {
                        return this.mainSoundTrack.soundCollection[index];
                    }
                }
                for (var sdIndex = 0; sdIndex < this.soundTracks.length; sdIndex++) {
                    for (index = 0; index < this.soundTracks[sdIndex].soundCollection.length; index++) {
                        if (this.soundTracks[sdIndex].soundCollection[index].name === name) {
                            return this.soundTracks[sdIndex].soundCollection[index];
                        }
                    }
                }
            }
            return null;
        };
        Scene.prototype.getLastSkeletonByID = function (id) {
            for (var index = this.skeletons.length - 1; index >= 0; index--) {
                if (this.skeletons[index].id === id) {
                    return this.skeletons[index];
                }
            }
            return null;
        };
        Scene.prototype.getSkeletonById = function (id) {
            for (var index = 0; index < this.skeletons.length; index++) {
                if (this.skeletons[index].id === id) {
                    return this.skeletons[index];
                }
            }
            return null;
        };
        Scene.prototype.getSkeletonByName = function (name) {
            for (var index = 0; index < this.skeletons.length; index++) {
                if (this.skeletons[index].name === name) {
                    return this.skeletons[index];
                }
            }
            return null;
        };
        Scene.prototype.getMorphTargetManagerById = function (id) {
            for (var index = 0; index < this.morphTargetManagers.length; index++) {
                if (this.morphTargetManagers[index].uniqueId === id) {
                    return this.morphTargetManagers[index];
                }
            }
            return null;
        };
        Scene.prototype.isActiveMesh = function (mesh) {
            return (this._activeMeshes.indexOf(mesh) !== -1);
        };
        /**
         * Return a the first highlight layer of the scene with a given name.
         * @param name The name of the highlight layer to look for.
         * @return The highlight layer if found otherwise null.
         */
        Scene.prototype.getHighlightLayerByName = function (name) {
            for (var index = 0; index < this.highlightLayers.length; index++) {
                if (this.highlightLayers[index].name === name) {
                    return this.highlightLayers[index];
                }
            }
            return null;
        };
        Object.defineProperty(Scene.prototype, "uid", {
            /**
             * Return a unique id as a string which can serve as an identifier for the scene
             */
            get: function () {
                if (!this._uid) {
                    this._uid = BABYLON.Tools.RandomId();
                }
                return this._uid;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * Add an externaly attached data from its key.
         * This method call will fail and return false, if such key already exists.
         * If you don't care and just want to get the data no matter what, use the more convenient getOrAddExternalDataWithFactory() method.
         * @param key the unique key that identifies the data
         * @param data the data object to associate to the key for this Engine instance
         * @return true if no such key were already present and the data was added successfully, false otherwise
         */
        Scene.prototype.addExternalData = function (key, data) {
            if (!this._externalData) {
                this._externalData = new BABYLON.StringDictionary();
            }
            return this._externalData.add(key, data);
        };
        /**
         * Get an externaly attached data from its key
         * @param key the unique key that identifies the data
         * @return the associated data, if present (can be null), or undefined if not present
         */
        Scene.prototype.getExternalData = function (key) {
            if (!this._externalData) {
                return null;
            }
            return this._externalData.get(key);
        };
        /**
         * Get an externaly attached data from its key, create it using a factory if it's not already present
         * @param key the unique key that identifies the data
         * @param factory the factory that will be called to create the instance if and only if it doesn't exists
         * @return the associated data, can be null if the factory returned null.
         */
        Scene.prototype.getOrAddExternalDataWithFactory = function (key, factory) {
            if (!this._externalData) {
                this._externalData = new BABYLON.StringDictionary();
            }
            return this._externalData.getOrAddWithFactory(key, factory);
        };
        /**
         * Remove an externaly attached data from the Engine instance
         * @param key the unique key that identifies the data
         * @return true if the data was successfully removed, false if it doesn't exist
         */
        Scene.prototype.removeExternalData = function (key) {
            return this._externalData.remove(key);
        };
        Scene.prototype._evaluateSubMesh = function (subMesh, mesh) {
            if (mesh.alwaysSelectAsActiveMesh || mesh.subMeshes.length === 1 || subMesh.isInFrustum(this._frustumPlanes)) {
                var material = subMesh.getMaterial();
                if (mesh.showSubMeshesBoundingBox) {
                    var boundingInfo = subMesh.getBoundingInfo();
                    this.getBoundingBoxRenderer().renderList.push(boundingInfo.boundingBox);
                }
                if (material) {
                    // Render targets
                    if (material.getRenderTargetTextures) {
                        if (this._processedMaterials.indexOf(material) === -1) {
                            this._processedMaterials.push(material);
                            this._renderTargets.concatWithNoDuplicate(material.getRenderTargetTextures());
                        }
                    }
                    // Dispatch
                    this._activeIndices.addCount(subMesh.indexCount, false);
                    this._renderingManager.dispatch(subMesh);
                }
            }
        };
        Scene.prototype._isInIntermediateRendering = function () {
            return this._intermediateRendering;
        };
        /**
         * Use this function to stop evaluating active meshes. The current list will be keep alive between frames
         */
        Scene.prototype.freezeActiveMeshes = function () {
            this._evaluateActiveMeshes();
            this._activeMeshesFrozen = true;
            return this;
        };
        /**
         * Use this function to restart evaluating active meshes on every frame
         */
        Scene.prototype.unfreezeActiveMeshes = function () {
            this._activeMeshesFrozen = false;
            return this;
        };
        Scene.prototype._evaluateActiveMeshes = function () {
            if (this._activeMeshesFrozen && this._activeMeshes.length) {
                return;
            }
            if (!this.activeCamera) {
                return;
            }
            this.onBeforeActiveMeshesEvaluationObservable.notifyObservers(this);
            this.activeCamera._activeMeshes.reset();
            this._activeMeshes.reset();
            this._renderingManager.reset();
            this._processedMaterials.reset();
            this._activeParticleSystems.reset();
            this._activeSkeletons.reset();
            this._softwareSkinnedMeshes.reset();
            if (this._boundingBoxRenderer) {
                this._boundingBoxRenderer.reset();
            }
            // Meshes
            var meshes;
            var len;
            if (this._selectionOctree) {
                var selection = this._selectionOctree.select(this._frustumPlanes);
                meshes = selection.data;
                len = selection.length;
            }
            else {
                len = this.meshes.length;
                meshes = this.meshes;
            }
            for (var meshIndex = 0; meshIndex < len; meshIndex++) {
                var mesh = meshes[meshIndex];
                if (mesh.isBlocked) {
                    continue;
                }
                this._totalVertices.addCount(mesh.getTotalVertices(), false);
                if (!mesh.isReady() || !mesh.isEnabled()) {
                    continue;
                }
                mesh.computeWorldMatrix();
                // Intersections
                if (mesh.actionManager && mesh.actionManager.hasSpecificTriggers([BABYLON.ActionManager.OnIntersectionEnterTrigger, BABYLON.ActionManager.OnIntersectionExitTrigger])) {
                    this._meshesForIntersections.pushNoDuplicate(mesh);
                }
                // Switch to current LOD
                var meshLOD = mesh.getLOD(this.activeCamera);
                if (!meshLOD) {
                    continue;
                }
                mesh._preActivate();
                if (mesh.alwaysSelectAsActiveMesh || mesh.isVisible && mesh.visibility > 0 && ((mesh.layerMask & this.activeCamera.layerMask) !== 0) && mesh.isInFrustum(this._frustumPlanes)) {
                    this._activeMeshes.push(mesh);
                    this.activeCamera._activeMeshes.push(mesh);
                    mesh._activate(this._renderId);
                    if (meshLOD !== mesh) {
                        meshLOD._activate(this._renderId);
                    }
                    this._activeMesh(mesh, meshLOD);
                }
            }
            this.onAfterActiveMeshesEvaluationObservable.notifyObservers(this);
            // Particle systems
            if (this.particlesEnabled) {
                this.onBeforeParticlesRenderingObservable.notifyObservers(this);
                for (var particleIndex = 0; particleIndex < this.particleSystems.length; particleIndex++) {
                    var particleSystem = this.particleSystems[particleIndex];
                    if (!particleSystem.isStarted() || !particleSystem.emitter) {
                        continue;
                    }
                    var emitter = particleSystem.emitter;
                    if (!emitter.position || emitter.isEnabled()) {
                        this._activeParticleSystems.push(particleSystem);
                        particleSystem.animate();
                        this._renderingManager.dispatchParticles(particleSystem);
                    }
                }
                this.onAfterParticlesRenderingObservable.notifyObservers(this);
            }
        };
        Scene.prototype._activeMesh = function (sourceMesh, mesh) {
            if (mesh.skeleton && this.skeletonsEnabled) {
                if (this._activeSkeletons.pushNoDuplicate(mesh.skeleton)) {
                    mesh.skeleton.prepare();
                }
                if (!mesh.computeBonesUsingShaders) {
                    this._softwareSkinnedMeshes.pushNoDuplicate(mesh);
                }
            }
            if (sourceMesh.showBoundingBox || this.forceShowBoundingBoxes) {
                var boundingInfo = sourceMesh.getBoundingInfo();
                this.getBoundingBoxRenderer().renderList.push(boundingInfo.boundingBox);
            }
            if (mesh && mesh.subMeshes) {
                // Submeshes Octrees
                var len;
                var subMeshes;
                if (mesh._submeshesOctree && mesh.useOctreeForRenderingSelection) {
                    var intersections = mesh._submeshesOctree.select(this._frustumPlanes);
                    len = intersections.length;
                    subMeshes = intersections.data;
                }
                else {
                    subMeshes = mesh.subMeshes;
                    len = subMeshes.length;
                }
                for (var subIndex = 0; subIndex < len; subIndex++) {
                    var subMesh = subMeshes[subIndex];
                    this._evaluateSubMesh(subMesh, mesh);
                }
            }
        };
        Scene.prototype.updateTransformMatrix = function (force) {
            if (!this.activeCamera) {
                return;
            }
            this.setTransformMatrix(this.activeCamera.getViewMatrix(), this.activeCamera.getProjectionMatrix(force));
        };
        Scene.prototype.updateAlternateTransformMatrix = function (alternateCamera) {
            this._setAlternateTransformMatrix(alternateCamera.getViewMatrix(), alternateCamera.getProjectionMatrix());
        };
        Scene.prototype._renderForCamera = function (camera) {
            if (camera && camera._skipRendering) {
                return;
            }
            var engine = this._engine;
            this.activeCamera = camera;
            if (!this.activeCamera)
                throw new Error("Active camera not set");
            BABYLON.Tools.StartPerformanceCounter("Rendering camera " + this.activeCamera.name);
            // Viewport
            engine.setViewport(this.activeCamera.viewport);
            // Camera
            this.resetCachedMaterial();
            this._renderId++;
            this.activeCamera.update();
            this.updateTransformMatrix();
            if (camera._alternateCamera) {
                this.updateAlternateTransformMatrix(camera._alternateCamera);
                this._alternateRendering = true;
            }
            this.onBeforeCameraRenderObservable.notifyObservers(this.activeCamera);
            // Meshes
            this._evaluateActiveMeshes();
            // Software skinning
            for (var softwareSkinnedMeshIndex = 0; softwareSkinnedMeshIndex < this._softwareSkinnedMeshes.length; softwareSkinnedMeshIndex++) {
                var mesh = this._softwareSkinnedMeshes.data[softwareSkinnedMeshIndex];
                mesh.applySkeleton(mesh.skeleton);
            }
            // Render targets
            this.OnBeforeRenderTargetsRenderObservable.notifyObservers(this);
            var needsRestoreFrameBuffer = false;
            if (camera.customRenderTargets && camera.customRenderTargets.length > 0) {
                this._renderTargets.concatWithNoDuplicate(camera.customRenderTargets);
            }
            if (this.renderTargetsEnabled && this._renderTargets.length > 0) {
                this._intermediateRendering = true;
                BABYLON.Tools.StartPerformanceCounter("Render targets", this._renderTargets.length > 0);
                for (var renderIndex = 0; renderIndex < this._renderTargets.length; renderIndex++) {
                    var renderTarget = this._renderTargets.data[renderIndex];
                    if (renderTarget._shouldRender()) {
                        this._renderId++;
                        var hasSpecialRenderTargetCamera = renderTarget.activeCamera && renderTarget.activeCamera !== this.activeCamera;
                        renderTarget.render(hasSpecialRenderTargetCamera, this.dumpNextRenderTargets);
                    }
                }
                BABYLON.Tools.EndPerformanceCounter("Render targets", this._renderTargets.length > 0);
                this._intermediateRendering = false;
                this._renderId++;
                needsRestoreFrameBuffer = true; // Restore back buffer
            }
            // Render HighlightLayer Texture
            var stencilState = this._engine.getStencilBuffer();
            var renderhighlights = false;
            if (this.renderTargetsEnabled && this.highlightLayers && this.highlightLayers.length > 0) {
                this._intermediateRendering = true;
                for (var i = 0; i < this.highlightLayers.length; i++) {
                    var highlightLayer = this.highlightLayers[i];
                    if (highlightLayer.shouldRender() &&
                        (!highlightLayer.camera ||
                            (highlightLayer.camera.cameraRigMode === BABYLON.Camera.RIG_MODE_NONE && camera === highlightLayer.camera) ||
                            (highlightLayer.camera.cameraRigMode !== BABYLON.Camera.RIG_MODE_NONE && highlightLayer.camera._rigCameras.indexOf(camera) > -1))) {
                        renderhighlights = true;
                        var renderTarget = highlightLayer._mainTexture;
                        if (renderTarget._shouldRender()) {
                            this._renderId++;
                            renderTarget.render(false, false);
                            needsRestoreFrameBuffer = true;
                        }
                    }
                }
                this._intermediateRendering = false;
                this._renderId++;
            }
            if (needsRestoreFrameBuffer) {
                engine.restoreDefaultFramebuffer(); // Restore back buffer
            }
            this.OnAfterRenderTargetsRenderObservable.notifyObservers(this);
            // Prepare Frame
            this.postProcessManager._prepareFrame();
            // Backgrounds
            var layerIndex;
            var layer;
            if (this.layers.length) {
                engine.setDepthBuffer(false);
                for (layerIndex = 0; layerIndex < this.layers.length; layerIndex++) {
                    layer = this.layers[layerIndex];
                    if (layer.isBackground && ((layer.layerMask & this.activeCamera.layerMask) !== 0)) {
                        layer.render();
                    }
                }
                engine.setDepthBuffer(true);
            }
            // Activate HighlightLayer stencil
            if (renderhighlights) {
                this._engine.setStencilBuffer(true);
            }
            // Render
            this.onBeforeDrawPhaseObservable.notifyObservers(this);
            this._renderingManager.render(null, null, true, true);
            this.onAfterDrawPhaseObservable.notifyObservers(this);
            // Restore HighlightLayer stencil
            if (renderhighlights) {
                this._engine.setStencilBuffer(stencilState);
            }
            // Bounding boxes
            if (this._boundingBoxRenderer) {
                this._boundingBoxRenderer.render();
            }
            // Lens flares
            if (this.lensFlaresEnabled) {
                BABYLON.Tools.StartPerformanceCounter("Lens flares", this.lensFlareSystems.length > 0);
                for (var lensFlareSystemIndex = 0; lensFlareSystemIndex < this.lensFlareSystems.length; lensFlareSystemIndex++) {
                    var lensFlareSystem = this.lensFlareSystems[lensFlareSystemIndex];
                    if ((camera.layerMask & lensFlareSystem.layerMask) !== 0) {
                        lensFlareSystem.render();
                    }
                }
                BABYLON.Tools.EndPerformanceCounter("Lens flares", this.lensFlareSystems.length > 0);
            }
            // Foregrounds
            if (this.layers.length) {
                engine.setDepthBuffer(false);
                for (layerIndex = 0; layerIndex < this.layers.length; layerIndex++) {
                    layer = this.layers[layerIndex];
                    if (!layer.isBackground && ((layer.layerMask & this.activeCamera.layerMask) !== 0)) {
                        layer.render();
                    }
                }
                engine.setDepthBuffer(true);
            }
            // Highlight Layer
            if (renderhighlights) {
                engine.setDepthBuffer(false);
                for (var i = 0; i < this.highlightLayers.length; i++) {
                    if (this.highlightLayers[i].shouldRender()) {
                        this.highlightLayers[i].render();
                    }
                }
                engine.setDepthBuffer(true);
            }
            // Finalize frame
            this.postProcessManager._finalizeFrame(camera.isIntermediate);
            // Reset some special arrays
            this._renderTargets.reset();
            this._alternateRendering = false;
            this.onAfterCameraRenderObservable.notifyObservers(this.activeCamera);
            BABYLON.Tools.EndPerformanceCounter("Rendering camera " + this.activeCamera.name);
        };
        Scene.prototype._processSubCameras = function (camera) {
            if (camera.cameraRigMode === BABYLON.Camera.RIG_MODE_NONE) {
                this._renderForCamera(camera);
                return;
            }
            // Update camera
            if (this.activeCamera) {
                this.activeCamera.update();
            }
            // rig cameras
            for (var index = 0; index < camera._rigCameras.length; index++) {
                this._renderForCamera(camera._rigCameras[index]);
            }
            this.activeCamera = camera;
            this.setTransformMatrix(this.activeCamera.getViewMatrix(), this.activeCamera.getProjectionMatrix());
        };
        Scene.prototype._checkIntersections = function () {
            for (var index = 0; index < this._meshesForIntersections.length; index++) {
                var sourceMesh = this._meshesForIntersections.data[index];
                if (!sourceMesh.actionManager) {
                    continue;
                }
                for (var actionIndex = 0; actionIndex < sourceMesh.actionManager.actions.length; actionIndex++) {
                    var action = sourceMesh.actionManager.actions[actionIndex];
                    if (action.trigger === BABYLON.ActionManager.OnIntersectionEnterTrigger || action.trigger === BABYLON.ActionManager.OnIntersectionExitTrigger) {
                        var parameters = action.getTriggerParameter();
                        var otherMesh = parameters instanceof BABYLON.AbstractMesh ? parameters : parameters.mesh;
                        var areIntersecting = otherMesh.intersectsMesh(sourceMesh, parameters.usePreciseIntersection);
                        var currentIntersectionInProgress = sourceMesh._intersectionsInProgress.indexOf(otherMesh);
                        if (areIntersecting && currentIntersectionInProgress === -1) {
                            if (action.trigger === BABYLON.ActionManager.OnIntersectionEnterTrigger) {
                                action._executeCurrent(BABYLON.ActionEvent.CreateNew(sourceMesh, undefined, otherMesh));
                                sourceMesh._intersectionsInProgress.push(otherMesh);
                            }
                            else if (action.trigger === BABYLON.ActionManager.OnIntersectionExitTrigger) {
                                sourceMesh._intersectionsInProgress.push(otherMesh);
                            }
                        }
                        else if (!areIntersecting && currentIntersectionInProgress > -1) {
                            //They intersected, and now they don't.
                            //is this trigger an exit trigger? execute an event.
                            if (action.trigger === BABYLON.ActionManager.OnIntersectionExitTrigger) {
                                action._executeCurrent(BABYLON.ActionEvent.CreateNew(sourceMesh, undefined, otherMesh));
                            }
                            //if this is an exit trigger, or no exit trigger exists, remove the id from the intersection in progress array.
                            if (!sourceMesh.actionManager.hasSpecificTrigger(BABYLON.ActionManager.OnIntersectionExitTrigger) || action.trigger === BABYLON.ActionManager.OnIntersectionExitTrigger) {
                                sourceMesh._intersectionsInProgress.splice(currentIntersectionInProgress, 1);
                            }
                        }
                    }
                }
            }
        };
        Scene.prototype.render = function () {
            if (this.isDisposed) {
                return;
            }
            this._activeParticles.fetchNewFrame();
            this._totalVertices.fetchNewFrame();
            this._activeIndices.fetchNewFrame();
            this._activeBones.fetchNewFrame();
            this._meshesForIntersections.reset();
            this.resetCachedMaterial();
            this.onBeforeAnimationsObservable.notifyObservers(this);
            // Actions
            if (this.actionManager) {
                this.actionManager.processTrigger(BABYLON.ActionManager.OnEveryFrameTrigger);
            }
            //Simplification Queue
            if (this.simplificationQueue && !this.simplificationQueue.running) {
                this.simplificationQueue.executeNext();
            }
            if (this._engine.isDeterministicLockStep()) {
                var deltaTime = Math.max(Scene.MinDeltaTime, Math.min(this._engine.getDeltaTime(), Scene.MaxDeltaTime)) + this._timeAccumulator;
                var defaultFPS = (60.0 / 1000.0);
                var defaultFrameTime = 1000 / 60; // frame time in MS
                if (this._physicsEngine) {
                    defaultFrameTime = this._physicsEngine.getTimeStep() * 1000;
                }
                var stepsTaken = 0;
                var maxSubSteps = this._engine.getLockstepMaxSteps();
                var internalSteps = Math.floor(deltaTime / (1000 * defaultFPS));
                internalSteps = Math.min(internalSteps, maxSubSteps);
                do {
                    this.onBeforeStepObservable.notifyObservers(this);
                    // Animations
                    this._animationRatio = defaultFrameTime * defaultFPS;
                    this._animate();
                    this.onAfterAnimationsObservable.notifyObservers(this);
                    // Physics
                    if (this._physicsEngine) {
                        this.onBeforePhysicsObservable.notifyObservers(this);
                        this._physicsEngine._step(defaultFrameTime / 1000);
                        this.onAfterPhysicsObservable.notifyObservers(this);
                    }
                    this.onAfterStepObservable.notifyObservers(this);
                    this._currentStepId++;
                    stepsTaken++;
                    deltaTime -= defaultFrameTime;
                } while (deltaTime > 0 && stepsTaken < internalSteps);
                this._timeAccumulator = deltaTime < 0 ? 0 : deltaTime;
            }
            else {
                // Animations
                var deltaTime = this.useConstantAnimationDeltaTime ? 16 : Math.max(Scene.MinDeltaTime, Math.min(this._engine.getDeltaTime(), Scene.MaxDeltaTime));
                this._animationRatio = deltaTime * (60.0 / 1000.0);
                this._animate();
                this.onAfterAnimationsObservable.notifyObservers(this);
                // Physics
                if (this._physicsEngine) {
                    this.onBeforePhysicsObservable.notifyObservers(this);
                    this._physicsEngine._step(deltaTime / 1000.0);
                    this.onAfterPhysicsObservable.notifyObservers(this);
                }
            }
            // update gamepad manager
            if (this._gamepadManager && this._gamepadManager._isMonitoring) {
                this._gamepadManager._checkGamepadsStatus();
            }
            // Before render
            this.onBeforeRenderObservable.notifyObservers(this);
            // Customs render targets
            this.OnBeforeRenderTargetsRenderObservable.notifyObservers(this);
            var engine = this.getEngine();
            var currentActiveCamera = this.activeCamera;
            if (this.renderTargetsEnabled) {
                BABYLON.Tools.StartPerformanceCounter("Custom render targets", this.customRenderTargets.length > 0);
                this._intermediateRendering = true;
                for (var customIndex = 0; customIndex < this.customRenderTargets.length; customIndex++) {
                    var renderTarget = this.customRenderTargets[customIndex];
                    if (renderTarget._shouldRender()) {
                        this._renderId++;
                        this.activeCamera = renderTarget.activeCamera || this.activeCamera;
                        if (!this.activeCamera)
                            throw new Error("Active camera not set");
                        // Viewport
                        engine.setViewport(this.activeCamera.viewport);
                        // Camera
                        this.updateTransformMatrix();
                        renderTarget.render(currentActiveCamera !== this.activeCamera, this.dumpNextRenderTargets);
                    }
                }
                BABYLON.Tools.EndPerformanceCounter("Custom render targets", this.customRenderTargets.length > 0);
                this._intermediateRendering = false;
                this._renderId++;
            }
            // Restore back buffer
            if (this.customRenderTargets.length > 0) {
                engine.restoreDefaultFramebuffer();
            }
            this.OnAfterRenderTargetsRenderObservable.notifyObservers(this);
            this.activeCamera = currentActiveCamera;
            // Procedural textures
            if (this.proceduralTexturesEnabled) {
                BABYLON.Tools.StartPerformanceCounter("Procedural textures", this._proceduralTextures.length > 0);
                for (var proceduralIndex = 0; proceduralIndex < this._proceduralTextures.length; proceduralIndex++) {
                    var proceduralTexture = this._proceduralTextures[proceduralIndex];
                    if (proceduralTexture._shouldRender()) {
                        proceduralTexture.render();
                    }
                }
                BABYLON.Tools.EndPerformanceCounter("Procedural textures", this._proceduralTextures.length > 0);
            }
            // Clear
            if (this.autoClearDepthAndStencil || this.autoClear) {
                this._engine.clear(this.clearColor, this.autoClear || this.forceWireframe || this.forcePointsCloud, this.autoClearDepthAndStencil, this.autoClearDepthAndStencil);
            }
            // Shadows
            if (this.shadowsEnabled) {
                for (var lightIndex = 0; lightIndex < this.lights.length; lightIndex++) {
                    var light = this.lights[lightIndex];
                    var shadowGenerator = light.getShadowGenerator();
                    if (light.isEnabled() && light.shadowEnabled && shadowGenerator) {
                        var shadowMap = (shadowGenerator.getShadowMap());
                        if (this.textures.indexOf(shadowMap) !== -1) {
                            this._renderTargets.push(shadowMap);
                        }
                    }
                }
            }
            // Depth renderer
            if (this._depthRenderer) {
                this._renderTargets.push(this._depthRenderer.getDepthMap());
            }
            // Geometry renderer
            if (this._geometryBufferRenderer) {
                this._renderTargets.push(this._geometryBufferRenderer.getGBuffer());
            }
            // RenderPipeline
            if (this._postProcessRenderPipelineManager) {
                this._postProcessRenderPipelineManager.update();
            }
            // Multi-cameras?
            if (this.activeCameras.length > 0) {
                for (var cameraIndex = 0; cameraIndex < this.activeCameras.length; cameraIndex++) {
                    if (cameraIndex > 0) {
                        this._engine.clear(null, false, true, true);
                    }
                    this._processSubCameras(this.activeCameras[cameraIndex]);
                }
            }
            else {
                if (!this.activeCamera) {
                    throw new Error("No camera defined");
                }
                this._processSubCameras(this.activeCamera);
            }
            // Intersection checks
            this._checkIntersections();
            // Update the audio listener attached to the camera
            if (BABYLON.AudioEngine) {
                this._updateAudioParameters();
            }
            // After render
            if (this.afterRender) {
                this.afterRender();
            }
            this.onAfterRenderObservable.notifyObservers(this);
            // Cleaning
            for (var index = 0; index < this._toBeDisposed.length; index++) {
                var data = this._toBeDisposed.data[index];
                if (data) {
                    data.dispose();
                }
                this._toBeDisposed[index] = null;
            }
            this._toBeDisposed.reset();
            if (this.dumpNextRenderTargets) {
                this.dumpNextRenderTargets = false;
            }
            this._activeBones.addCount(0, true);
            this._activeIndices.addCount(0, true);
            this._activeParticles.addCount(0, true);
        };
        Scene.prototype._updateAudioParameters = function () {
            if (!this.audioEnabled || !this._mainSoundTrack || (this._mainSoundTrack.soundCollection.length === 0 && this.soundTracks.length === 1)) {
                return;
            }
            var listeningCamera;
            var audioEngine = BABYLON.Engine.audioEngine;
            if (this.activeCameras.length > 0) {
                listeningCamera = this.activeCameras[0];
            }
            else {
                listeningCamera = this.activeCamera;
            }
            if (listeningCamera && audioEngine.canUseWebAudio && audioEngine.audioContext) {
                audioEngine.audioContext.listener.setPosition(listeningCamera.position.x, listeningCamera.position.y, listeningCamera.position.z);
                // for VR cameras
                if (listeningCamera.rigCameras && listeningCamera.rigCameras.length > 0) {
                    listeningCamera = listeningCamera.rigCameras[0];
                }
                var mat = BABYLON.Matrix.Invert(listeningCamera.getViewMatrix());
                var cameraDirection = BABYLON.Vector3.TransformNormal(new BABYLON.Vector3(0, 0, -1), mat);
                cameraDirection.normalize();
                // To avoid some errors on GearVR
                if (!isNaN(cameraDirection.x) && !isNaN(cameraDirection.y) && !isNaN(cameraDirection.z)) {
                    audioEngine.audioContext.listener.setOrientation(cameraDirection.x, cameraDirection.y, cameraDirection.z, 0, 1, 0);
                }
                var i;
                for (i = 0; i < this.mainSoundTrack.soundCollection.length; i++) {
                    var sound = this.mainSoundTrack.soundCollection[i];
                    if (sound.useCustomAttenuation) {
                        sound.updateDistanceFromListener();
                    }
                }
                for (i = 0; i < this.soundTracks.length; i++) {
                    for (var j = 0; j < this.soundTracks[i].soundCollection.length; j++) {
                        sound = this.soundTracks[i].soundCollection[j];
                        if (sound.useCustomAttenuation) {
                            sound.updateDistanceFromListener();
                        }
                    }
                }
            }
        };
        Object.defineProperty(Scene.prototype, "audioEnabled", {
            // Audio
            get: function () {
                return this._audioEnabled;
            },
            set: function (value) {
                this._audioEnabled = value;
                if (BABYLON.AudioEngine) {
                    if (this._audioEnabled) {
                        this._enableAudio();
                    }
                    else {
                        this._disableAudio();
                    }
                }
            },
            enumerable: true,
            configurable: true
        });
        Scene.prototype._disableAudio = function () {
            var i;
            for (i = 0; i < this.mainSoundTrack.soundCollection.length; i++) {
                this.mainSoundTrack.soundCollection[i].pause();
            }
            for (i = 0; i < this.soundTracks.length; i++) {
                for (var j = 0; j < this.soundTracks[i].soundCollection.length; j++) {
                    this.soundTracks[i].soundCollection[j].pause();
                }
            }
        };
        Scene.prototype._enableAudio = function () {
            var i;
            for (i = 0; i < this.mainSoundTrack.soundCollection.length; i++) {
                if (this.mainSoundTrack.soundCollection[i].isPaused) {
                    this.mainSoundTrack.soundCollection[i].play();
                }
            }
            for (i = 0; i < this.soundTracks.length; i++) {
                for (var j = 0; j < this.soundTracks[i].soundCollection.length; j++) {
                    if (this.soundTracks[i].soundCollection[j].isPaused) {
                        this.soundTracks[i].soundCollection[j].play();
                    }
                }
            }
        };
        Object.defineProperty(Scene.prototype, "headphone", {
            get: function () {
                return this._headphone;
            },
            set: function (value) {
                this._headphone = value;
                if (BABYLON.AudioEngine) {
                    if (this._headphone) {
                        this._switchAudioModeForHeadphones();
                    }
                    else {
                        this._switchAudioModeForNormalSpeakers();
                    }
                }
            },
            enumerable: true,
            configurable: true
        });
        Scene.prototype._switchAudioModeForHeadphones = function () {
            this.mainSoundTrack.switchPanningModelToHRTF();
            for (var i = 0; i < this.soundTracks.length; i++) {
                this.soundTracks[i].switchPanningModelToHRTF();
            }
        };
        Scene.prototype._switchAudioModeForNormalSpeakers = function () {
            this.mainSoundTrack.switchPanningModelToEqualPower();
            for (var i = 0; i < this.soundTracks.length; i++) {
                this.soundTracks[i].switchPanningModelToEqualPower();
            }
        };
        Scene.prototype.enableDepthRenderer = function () {
            if (this._depthRenderer) {
                return this._depthRenderer;
            }
            this._depthRenderer = new BABYLON.DepthRenderer(this);
            return this._depthRenderer;
        };
        Scene.prototype.disableDepthRenderer = function () {
            if (!this._depthRenderer) {
                return;
            }
            this._depthRenderer.dispose();
            this._depthRenderer = null;
        };
        Scene.prototype.enableGeometryBufferRenderer = function (ratio) {
            if (ratio === void 0) { ratio = 1; }
            if (this._geometryBufferRenderer) {
                return this._geometryBufferRenderer;
            }
            this._geometryBufferRenderer = new BABYLON.GeometryBufferRenderer(this, ratio);
            if (!this._geometryBufferRenderer.isSupported) {
                this._geometryBufferRenderer = null;
            }
            return this._geometryBufferRenderer;
        };
        Scene.prototype.disableGeometryBufferRenderer = function () {
            if (!this._geometryBufferRenderer) {
                return;
            }
            this._geometryBufferRenderer.dispose();
            this._geometryBufferRenderer = null;
        };
        Scene.prototype.freezeMaterials = function () {
            for (var i = 0; i < this.materials.length; i++) {
                this.materials[i].freeze();
            }
        };
        Scene.prototype.unfreezeMaterials = function () {
            for (var i = 0; i < this.materials.length; i++) {
                this.materials[i].unfreeze();
            }
        };
        Scene.prototype.dispose = function () {
            this.beforeRender = null;
            this.afterRender = null;
            this.skeletons = [];
            this.morphTargetManagers = [];
            this.importedMeshesFiles = new Array();
            this.stopAllAnimations();
            this.resetCachedMaterial();
            if (this._depthRenderer) {
                this._depthRenderer.dispose();
            }
            if (this._gamepadManager) {
                this._gamepadManager.dispose();
                this._gamepadManager = null;
            }
            // Smart arrays
            if (this.activeCamera) {
                this.activeCamera._activeMeshes.dispose();
                this.activeCamera = null;
            }
            this._activeMeshes.dispose();
            this._renderingManager.dispose();
            this._processedMaterials.dispose();
            this._activeParticleSystems.dispose();
            this._activeSkeletons.dispose();
            this._softwareSkinnedMeshes.dispose();
            this._renderTargets.dispose();
            if (this._boundingBoxRenderer) {
                this._boundingBoxRenderer.dispose();
            }
            this._meshesForIntersections.dispose();
            this._toBeDisposed.dispose();
            // Debug layer
            if (this._debugLayer) {
                this._debugLayer.hide();
            }
            // Events
            this.onDisposeObservable.notifyObservers(this);
            this.onDisposeObservable.clear();
            this.onBeforeRenderObservable.clear();
            this.onAfterRenderObservable.clear();
            this.OnBeforeRenderTargetsRenderObservable.clear();
            this.OnAfterRenderTargetsRenderObservable.clear();
            this.onAfterStepObservable.clear();
            this.onBeforeStepObservable.clear();
            this.onBeforeActiveMeshesEvaluationObservable.clear();
            this.onAfterActiveMeshesEvaluationObservable.clear();
            this.onBeforeParticlesRenderingObservable.clear();
            this.onAfterParticlesRenderingObservable.clear();
            this.onBeforeSpritesRenderingObservable.clear();
            this.onAfterSpritesRenderingObservable.clear();
            this.onBeforeDrawPhaseObservable.clear();
            this.onAfterDrawPhaseObservable.clear();
            this.onBeforePhysicsObservable.clear();
            this.onAfterPhysicsObservable.clear();
            this.onBeforeAnimationsObservable.clear();
            this.onAfterAnimationsObservable.clear();
            this.onDataLoadedObservable.clear();
            this.detachControl();
            // Release sounds & sounds tracks
            if (BABYLON.AudioEngine) {
                this.disposeSounds();
            }
            // VR Helper
            if (this.VRHelper) {
                this.VRHelper.dispose();
            }
            // Detach cameras
            var canvas = this._engine.getRenderingCanvas();
            if (canvas) {
                var index;
                for (index = 0; index < this.cameras.length; index++) {
                    this.cameras[index].detachControl(canvas);
                }
            }
            // Release lights
            while (this.lights.length) {
                this.lights[0].dispose();
            }
            // Release meshes
            while (this.meshes.length) {
                this.meshes[0].dispose(true);
            }
            while (this.transformNodes.length) {
                this.removeTransformNode(this.transformNodes[0]);
            }
            // Release cameras
            while (this.cameras.length) {
                this.cameras[0].dispose();
            }
            // Release materials
            if (this.defaultMaterial) {
                this.defaultMaterial.dispose();
            }
            while (this.multiMaterials.length) {
                this.multiMaterials[0].dispose();
            }
            while (this.materials.length) {
                this.materials[0].dispose();
            }
            // Release particles
            while (this.particleSystems.length) {
                this.particleSystems[0].dispose();
            }
            // Release sprites
            while (this.spriteManagers.length) {
                this.spriteManagers[0].dispose();
            }
            // Release postProcesses
            while (this.postProcesses.length) {
                this.postProcesses[0].dispose();
            }
            // Release layers
            while (this.layers.length) {
                this.layers[0].dispose();
            }
            while (this.highlightLayers.length) {
                this.highlightLayers[0].dispose();
            }
            // Release textures
            while (this.textures.length) {
                this.textures[0].dispose();
            }
            // Release UBO
            this._sceneUbo.dispose();
            if (this._alternateSceneUbo) {
                this._alternateSceneUbo.dispose();
            }
            // Post-processes
            this.postProcessManager.dispose();
            if (this._postProcessRenderPipelineManager) {
                this._postProcessRenderPipelineManager.dispose();
            }
            // Physics
            if (this._physicsEngine) {
                this.disablePhysicsEngine();
            }
            // Remove from engine
            index = this._engine.scenes.indexOf(this);
            if (index > -1) {
                this._engine.scenes.splice(index, 1);
            }
            this._engine.wipeCaches();
            this._isDisposed = true;
        };
        Object.defineProperty(Scene.prototype, "isDisposed", {
            get: function () {
                return this._isDisposed;
            },
            enumerable: true,
            configurable: true
        });
        // Release sounds & sounds tracks
        Scene.prototype.disposeSounds = function () {
            if (!this._mainSoundTrack) {
                return;
            }
            this.mainSoundTrack.dispose();
            for (var scIndex = 0; scIndex < this.soundTracks.length; scIndex++) {
                this.soundTracks[scIndex].dispose();
            }
        };
        // Octrees
        Scene.prototype.getWorldExtends = function () {
            var min = new BABYLON.Vector3(Number.MAX_VALUE, Number.MAX_VALUE, Number.MAX_VALUE);
            var max = new BABYLON.Vector3(-Number.MAX_VALUE, -Number.MAX_VALUE, -Number.MAX_VALUE);
            for (var index = 0; index < this.meshes.length; index++) {
                var mesh = this.meshes[index];
                if (!mesh.subMeshes || mesh.subMeshes.length === 0 || mesh.infiniteDistance) {
                    continue;
                }
                mesh.computeWorldMatrix(true);
                var boundingInfo = mesh.getBoundingInfo();
                var minBox = boundingInfo.boundingBox.minimumWorld;
                var maxBox = boundingInfo.boundingBox.maximumWorld;
                BABYLON.Tools.CheckExtends(minBox, min, max);
                BABYLON.Tools.CheckExtends(maxBox, min, max);
            }
            return {
                min: min,
                max: max
            };
        };
        Scene.prototype.createOrUpdateSelectionOctree = function (maxCapacity, maxDepth) {
            if (maxCapacity === void 0) { maxCapacity = 64; }
            if (maxDepth === void 0) { maxDepth = 2; }
            if (!this._selectionOctree) {
                this._selectionOctree = new BABYLON.Octree(BABYLON.Octree.CreationFuncForMeshes, maxCapacity, maxDepth);
            }
            var worldExtends = this.getWorldExtends();
            // Update octree
            this._selectionOctree.update(worldExtends.min, worldExtends.max, this.meshes);
            return this._selectionOctree;
        };
        // Picking
        Scene.prototype.createPickingRay = function (x, y, world, camera, cameraViewSpace) {
            if (cameraViewSpace === void 0) { cameraViewSpace = false; }
            var result = BABYLON.Ray.Zero();
            this.createPickingRayToRef(x, y, world, result, camera, cameraViewSpace);
            return result;
        };
        Scene.prototype.createPickingRayToRef = function (x, y, world, result, camera, cameraViewSpace) {
            if (cameraViewSpace === void 0) { cameraViewSpace = false; }
            var engine = this._engine;
            if (!camera) {
                if (!this.activeCamera)
                    throw new Error("Active camera not set");
                camera = this.activeCamera;
            }
            var cameraViewport = camera.viewport;
            var viewport = cameraViewport.toGlobal(engine.getRenderWidth(), engine.getRenderHeight());
            // Moving coordinates to local viewport world
            x = x / this._engine.getHardwareScalingLevel() - viewport.x;
            y = y / this._engine.getHardwareScalingLevel() - (this._engine.getRenderHeight() - viewport.y - viewport.height);
            result.update(x, y, viewport.width, viewport.height, world ? world : BABYLON.Matrix.Identity(), cameraViewSpace ? BABYLON.Matrix.Identity() : camera.getViewMatrix(), camera.getProjectionMatrix());
            return this;
        };
        Scene.prototype.createPickingRayInCameraSpace = function (x, y, camera) {
            var result = BABYLON.Ray.Zero();
            this.createPickingRayInCameraSpaceToRef(x, y, result, camera);
            return result;
        };
        Scene.prototype.createPickingRayInCameraSpaceToRef = function (x, y, result, camera) {
            if (!BABYLON.PickingInfo) {
                return this;
            }
            var engine = this._engine;
            if (!camera) {
                if (!this.activeCamera)
                    throw new Error("Active camera not set");
                camera = this.activeCamera;
            }
            var cameraViewport = camera.viewport;
            var viewport = cameraViewport.toGlobal(engine.getRenderWidth(), engine.getRenderHeight());
            var identity = BABYLON.Matrix.Identity();
            // Moving coordinates to local viewport world
            x = x / this._engine.getHardwareScalingLevel() - viewport.x;
            y = y / this._engine.getHardwareScalingLevel() - (this._engine.getRenderHeight() - viewport.y - viewport.height);
            result.update(x, y, viewport.width, viewport.height, identity, identity, camera.getProjectionMatrix());
            return this;
        };
        Scene.prototype._internalPick = function (rayFunction, predicate, fastCheck) {
            if (!BABYLON.PickingInfo) {
                return null;
            }
            var pickingInfo = null;
            for (var meshIndex = 0; meshIndex < this.meshes.length; meshIndex++) {
                var mesh = this.meshes[meshIndex];
                if (predicate) {
                    if (!predicate(mesh)) {
                        continue;
                    }
                }
                else if (!mesh.isEnabled() || !mesh.isVisible || !mesh.isPickable) {
                    continue;
                }
                var world = mesh.getWorldMatrix();
                var ray = rayFunction(world);
                var result = mesh.intersects(ray, fastCheck);
                if (!result || !result.hit)
                    continue;
                if (!fastCheck && pickingInfo != null && result.distance >= pickingInfo.distance)
                    continue;
                pickingInfo = result;
                if (fastCheck) {
                    break;
                }
            }
            return pickingInfo || new BABYLON.PickingInfo();
        };
        Scene.prototype._internalMultiPick = function (rayFunction, predicate) {
            if (!BABYLON.PickingInfo) {
                return null;
            }
            var pickingInfos = new Array();
            for (var meshIndex = 0; meshIndex < this.meshes.length; meshIndex++) {
                var mesh = this.meshes[meshIndex];
                if (predicate) {
                    if (!predicate(mesh)) {
                        continue;
                    }
                }
                else if (!mesh.isEnabled() || !mesh.isVisible || !mesh.isPickable) {
                    continue;
                }
                var world = mesh.getWorldMatrix();
                var ray = rayFunction(world);
                var result = mesh.intersects(ray, false);
                if (!result || !result.hit)
                    continue;
                pickingInfos.push(result);
            }
            return pickingInfos;
        };
        Scene.prototype._internalPickSprites = function (ray, predicate, fastCheck, camera) {
            if (!BABYLON.PickingInfo) {
                return null;
            }
            var pickingInfo = null;
            if (!camera) {
                if (!this.activeCamera) {
                    return null;
                }
                camera = this.activeCamera;
            }
            if (this.spriteManagers.length > 0) {
                for (var spriteIndex = 0; spriteIndex < this.spriteManagers.length; spriteIndex++) {
                    var spriteManager = this.spriteManagers[spriteIndex];
                    if (!spriteManager.isPickable) {
                        continue;
                    }
                    var result = spriteManager.intersects(ray, camera, predicate, fastCheck);
                    if (!result || !result.hit)
                        continue;
                    if (!fastCheck && pickingInfo != null && result.distance >= pickingInfo.distance)
                        continue;
                    pickingInfo = result;
                    if (fastCheck) {
                        break;
                    }
                }
            }
            return pickingInfo || new BABYLON.PickingInfo();
        };
        /** Launch a ray to try to pick a mesh in the scene
         * @param x position on screen
         * @param y position on screen
         * @param predicate Predicate function used to determine eligible meshes. Can be set to null. In this case, a mesh must be enabled, visible and with isPickable set to true
         * @param fastCheck Launch a fast check only using the bounding boxes. Can be set to null.
         * @param camera to use for computing the picking ray. Can be set to null. In this case, the scene.activeCamera will be used
         */
        Scene.prototype.pick = function (x, y, predicate, fastCheck, camera) {
            var _this = this;
            if (!BABYLON.PickingInfo) {
                return null;
            }
            return this._internalPick(function (world) {
                _this.createPickingRayToRef(x, y, world, _this._tempPickingRay, camera || null);
                return _this._tempPickingRay;
            }, predicate, fastCheck);
        };
        /** Launch a ray to try to pick a sprite in the scene
         * @param x position on screen
         * @param y position on screen
         * @param predicate Predicate function used to determine eligible sprites. Can be set to null. In this case, a sprite must have isPickable set to true
         * @param fastCheck Launch a fast check only using the bounding boxes. Can be set to null.
         * @param camera camera to use for computing the picking ray. Can be set to null. In this case, the scene.activeCamera will be used
         */
        Scene.prototype.pickSprite = function (x, y, predicate, fastCheck, camera) {
            this.createPickingRayInCameraSpaceToRef(x, y, this._tempPickingRay, camera);
            return this._internalPickSprites(this._tempPickingRay, predicate, fastCheck, camera);
        };
        /** Use the given ray to pick a mesh in the scene
         * @param ray The ray to use to pick meshes
         * @param predicate Predicate function used to determine eligible sprites. Can be set to null. In this case, a sprite must have isPickable set to true
         * @param fastCheck Launch a fast check only using the bounding boxes. Can be set to null.
         */
        Scene.prototype.pickWithRay = function (ray, predicate, fastCheck) {
            var _this = this;
            return this._internalPick(function (world) {
                if (!_this._pickWithRayInverseMatrix) {
                    _this._pickWithRayInverseMatrix = BABYLON.Matrix.Identity();
                }
                world.invertToRef(_this._pickWithRayInverseMatrix);
                if (!_this._cachedRayForTransform) {
                    _this._cachedRayForTransform = BABYLON.Ray.Zero();
                }
                BABYLON.Ray.TransformToRef(ray, _this._pickWithRayInverseMatrix, _this._cachedRayForTransform);
                return _this._cachedRayForTransform;
            }, predicate, fastCheck);
        };
        /**
         * Launch a ray to try to pick a mesh in the scene
         * @param x X position on screen
         * @param y Y position on screen
         * @param predicate Predicate function used to determine eligible meshes. Can be set to null. In this case, a mesh must be enabled, visible and with isPickable set to true
         * @param camera camera to use for computing the picking ray. Can be set to null. In this case, the scene.activeCamera will be used
         */
        Scene.prototype.multiPick = function (x, y, predicate, camera) {
            var _this = this;
            return this._internalMultiPick(function (world) { return _this.createPickingRay(x, y, world, camera || null); }, predicate);
        };
        /**
         * Launch a ray to try to pick a mesh in the scene
         * @param ray Ray to use
         * @param predicate Predicate function used to determine eligible meshes. Can be set to null. In this case, a mesh must be enabled, visible and with isPickable set to true
         */
        Scene.prototype.multiPickWithRay = function (ray, predicate) {
            var _this = this;
            return this._internalMultiPick(function (world) {
                if (!_this._pickWithRayInverseMatrix) {
                    _this._pickWithRayInverseMatrix = BABYLON.Matrix.Identity();
                }
                world.invertToRef(_this._pickWithRayInverseMatrix);
                if (!_this._cachedRayForTransform) {
                    _this._cachedRayForTransform = BABYLON.Ray.Zero();
                }
                BABYLON.Ray.TransformToRef(ray, _this._pickWithRayInverseMatrix, _this._cachedRayForTransform);
                return _this._cachedRayForTransform;
            }, predicate);
        };
        Scene.prototype.setPointerOverMesh = function (mesh) {
            if (this._pointerOverMesh === mesh) {
                return;
            }
            if (this._pointerOverMesh && this._pointerOverMesh.actionManager) {
                this._pointerOverMesh.actionManager.processTrigger(BABYLON.ActionManager.OnPointerOutTrigger, BABYLON.ActionEvent.CreateNew(this._pointerOverMesh));
            }
            this._pointerOverMesh = mesh;
            if (this._pointerOverMesh && this._pointerOverMesh.actionManager) {
                this._pointerOverMesh.actionManager.processTrigger(BABYLON.ActionManager.OnPointerOverTrigger, BABYLON.ActionEvent.CreateNew(this._pointerOverMesh));
            }
        };
        Scene.prototype.getPointerOverMesh = function () {
            return this._pointerOverMesh;
        };
        Scene.prototype.setPointerOverSprite = function (sprite) {
            if (this._pointerOverSprite === sprite) {
                return;
            }
            if (this._pointerOverSprite && this._pointerOverSprite.actionManager) {
                this._pointerOverSprite.actionManager.processTrigger(BABYLON.ActionManager.OnPointerOutTrigger, BABYLON.ActionEvent.CreateNewFromSprite(this._pointerOverSprite, this));
            }
            this._pointerOverSprite = sprite;
            if (this._pointerOverSprite && this._pointerOverSprite.actionManager) {
                this._pointerOverSprite.actionManager.processTrigger(BABYLON.ActionManager.OnPointerOverTrigger, BABYLON.ActionEvent.CreateNewFromSprite(this._pointerOverSprite, this));
            }
        };
        Scene.prototype.getPointerOverSprite = function () {
            return this._pointerOverSprite;
        };
        // Physics
        Scene.prototype.getPhysicsEngine = function () {
            return this._physicsEngine;
        };
        /**
         * Enables physics to the current scene
         * @param {BABYLON.Vector3} [gravity] - the scene's gravity for the physics engine
         * @param {BABYLON.IPhysicsEnginePlugin} [plugin] - The physics engine to be used. defaults to OimoJS.
         * @return {boolean} was the physics engine initialized
         */
        Scene.prototype.enablePhysics = function (gravity, plugin) {
            if (gravity === void 0) { gravity = null; }
            if (this._physicsEngine) {
                return true;
            }
            try {
                this._physicsEngine = new BABYLON.PhysicsEngine(gravity, plugin);
                return true;
            }
            catch (e) {
                BABYLON.Tools.Error(e.message);
                return false;
            }
        };
        Scene.prototype.disablePhysicsEngine = function () {
            if (!this._physicsEngine) {
                return;
            }
            this._physicsEngine.dispose();
            this._physicsEngine = null;
        };
        Scene.prototype.isPhysicsEnabled = function () {
            return this._physicsEngine !== undefined;
        };
        Scene.prototype.deleteCompoundImpostor = function (compound) {
            var mesh = compound.parts[0].mesh;
            if (mesh.physicsImpostor) {
                mesh.physicsImpostor.dispose();
                mesh.physicsImpostor = null;
            }
        };
        // Misc.
        Scene.prototype._rebuildGeometries = function () {
            for (var _i = 0, _a = this._geometries; _i < _a.length; _i++) {
                var geometry = _a[_i];
                geometry._rebuild();
            }
            for (var _b = 0, _c = this.meshes; _b < _c.length; _b++) {
                var mesh = _c[_b];
                mesh._rebuild();
            }
            if (this.postProcessManager) {
                this.postProcessManager._rebuild();
            }
            for (var _d = 0, _e = this.layers; _d < _e.length; _d++) {
                var layer = _e[_d];
                layer._rebuild();
            }
            for (var _f = 0, _g = this.highlightLayers; _f < _g.length; _f++) {
                var highlightLayer = _g[_f];
                highlightLayer._rebuild();
            }
            if (this._boundingBoxRenderer) {
                this._boundingBoxRenderer._rebuild();
            }
            for (var _h = 0, _j = this.particleSystems; _h < _j.length; _h++) {
                var system = _j[_h];
                system.rebuild();
            }
            if (this._postProcessRenderPipelineManager) {
                this._postProcessRenderPipelineManager._rebuild();
            }
        };
        Scene.prototype._rebuildTextures = function () {
            for (var _i = 0, _a = this.textures; _i < _a.length; _i++) {
                var texture = _a[_i];
                texture._rebuild();
            }
            this.markAllMaterialsAsDirty(BABYLON.Material.TextureDirtyFlag);
        };
        Scene.prototype.createDefaultCameraOrLight = function (createArcRotateCamera, replace, attachCameraControls) {
            if (createArcRotateCamera === void 0) { createArcRotateCamera = false; }
            if (replace === void 0) { replace = false; }
            if (attachCameraControls === void 0) { attachCameraControls = false; }
            // Dispose existing camera or light in replace mode.
            if (replace) {
                if (this.activeCamera) {
                    this.activeCamera.dispose();
                    this.activeCamera = null;
                }
                if (this.lights) {
                    for (var i = 0; i < this.lights.length; i++) {
                        this.lights[i].dispose();
                    }
                }
            }
            // Light
            if (this.lights.length === 0) {
                new BABYLON.HemisphericLight("default light", BABYLON.Vector3.Up(), this);
            }
            // Camera
            if (!this.activeCamera) {
                var worldExtends = this.getWorldExtends();
                var worldSize = worldExtends.max.subtract(worldExtends.min);
                var worldCenter = worldExtends.min.add(worldSize.scale(0.5));
                var camera;
                var radius = worldSize.length() * 1.5;
                if (createArcRotateCamera) {
                    var arcRotateCamera = new BABYLON.ArcRotateCamera("default camera", -(Math.PI / 2), Math.PI / 2, radius, worldCenter, this);
                    arcRotateCamera.lowerRadiusLimit = radius * 0.01;
                    arcRotateCamera.wheelPrecision = 100 / radius;
                    camera = arcRotateCamera;
                }
                else {
                    var freeCamera = new BABYLON.FreeCamera("default camera", new BABYLON.Vector3(worldCenter.x, worldCenter.y, -radius), this);
                    freeCamera.setTarget(worldCenter);
                    camera = freeCamera;
                }
                camera.minZ = radius * 0.01;
                camera.maxZ = radius * 100;
                camera.speed = radius * 0.2;
                this.activeCamera = camera;
                var canvas = this.getEngine().getRenderingCanvas();
                if (attachCameraControls && canvas) {
                    camera.attachControl(canvas);
                }
            }
        };
        Scene.prototype.createDefaultSkybox = function (environmentTexture, pbr, scale, blur) {
            if (pbr === void 0) { pbr = false; }
            if (scale === void 0) { scale = 1000; }
            if (blur === void 0) { blur = 0; }
            if (environmentTexture) {
                this.environmentTexture = environmentTexture;
            }
            if (!this.environmentTexture) {
                BABYLON.Tools.Warn("Can not create default skybox without environment texture.");
                return null;
            }
            // Skybox
            var hdrSkybox = BABYLON.Mesh.CreateBox("hdrSkyBox", scale, this);
            if (pbr) {
                var hdrSkyboxMaterial = new BABYLON.PBRMaterial("skyBox", this);
                hdrSkyboxMaterial.backFaceCulling = false;
                hdrSkyboxMaterial.reflectionTexture = this.environmentTexture.clone();
                if (hdrSkyboxMaterial.reflectionTexture) {
                    hdrSkyboxMaterial.reflectionTexture.coordinatesMode = BABYLON.Texture.SKYBOX_MODE;
                }
                hdrSkyboxMaterial.microSurface = 1.0 - blur;
                hdrSkyboxMaterial.disableLighting = true;
                hdrSkyboxMaterial.twoSidedLighting = true;
                hdrSkybox.infiniteDistance = true;
                hdrSkybox.material = hdrSkyboxMaterial;
            }
            else {
                var skyboxMaterial = new BABYLON.StandardMaterial("skyBox", this);
                skyboxMaterial.backFaceCulling = false;
                skyboxMaterial.reflectionTexture = this.environmentTexture.clone();
                if (skyboxMaterial.reflectionTexture) {
                    skyboxMaterial.reflectionTexture.coordinatesMode = BABYLON.Texture.SKYBOX_MODE;
                }
                skyboxMaterial.disableLighting = true;
                hdrSkybox.infiniteDistance = true;
                hdrSkybox.material = skyboxMaterial;
            }
            return hdrSkybox;
        };
        Scene.prototype.createDefaultEnvironment = function (options) {
            if (BABYLON.EnvironmentHelper) {
                return new BABYLON.EnvironmentHelper(options, this);
            }
            return null;
        };
        Scene.prototype.createDefaultVRExperience = function (webVROptions) {
            if (webVROptions === void 0) { webVROptions = {}; }
            return new BABYLON.VRExperienceHelper(this, webVROptions);
        };
        // Tags
        Scene.prototype._getByTags = function (list, tagsQuery, forEach) {
            if (tagsQuery === undefined) {
                // returns the complete list (could be done with BABYLON.Tags.MatchesQuery but no need to have a for-loop here)
                return list;
            }
            var listByTags = [];
            forEach = forEach || (function (item) { return; });
            for (var i in list) {
                var item = list[i];
                if (BABYLON.Tags && BABYLON.Tags.MatchesQuery(item, tagsQuery)) {
                    listByTags.push(item);
                    forEach(item);
                }
            }
            return listByTags;
        };
        Scene.prototype.getMeshesByTags = function (tagsQuery, forEach) {
            return this._getByTags(this.meshes, tagsQuery, forEach);
        };
        Scene.prototype.getCamerasByTags = function (tagsQuery, forEach) {
            return this._getByTags(this.cameras, tagsQuery, forEach);
        };
        Scene.prototype.getLightsByTags = function (tagsQuery, forEach) {
            return this._getByTags(this.lights, tagsQuery, forEach);
        };
        Scene.prototype.getMaterialByTags = function (tagsQuery, forEach) {
            return this._getByTags(this.materials, tagsQuery, forEach).concat(this._getByTags(this.multiMaterials, tagsQuery, forEach));
        };
        /**
         * Overrides the default sort function applied in the renderging group to prepare the meshes.
         * This allowed control for front to back rendering or reversly depending of the special needs.
         *
         * @param renderingGroupId The rendering group id corresponding to its index
         * @param opaqueSortCompareFn The opaque queue comparison function use to sort.
         * @param alphaTestSortCompareFn The alpha test queue comparison function use to sort.
         * @param transparentSortCompareFn The transparent queue comparison function use to sort.
         */
        Scene.prototype.setRenderingOrder = function (renderingGroupId, opaqueSortCompareFn, alphaTestSortCompareFn, transparentSortCompareFn) {
            if (opaqueSortCompareFn === void 0) { opaqueSortCompareFn = null; }
            if (alphaTestSortCompareFn === void 0) { alphaTestSortCompareFn = null; }
            if (transparentSortCompareFn === void 0) { transparentSortCompareFn = null; }
            this._renderingManager.setRenderingOrder(renderingGroupId, opaqueSortCompareFn, alphaTestSortCompareFn, transparentSortCompareFn);
        };
        /**
         * Specifies whether or not the stencil and depth buffer are cleared between two rendering groups.
         *
         * @param renderingGroupId The rendering group id corresponding to its index
         * @param autoClearDepthStencil Automatically clears depth and stencil between groups if true.
         * @param depth Automatically clears depth between groups if true and autoClear is true.
         * @param stencil Automatically clears stencil between groups if true and autoClear is true.
         */
        Scene.prototype.setRenderingAutoClearDepthStencil = function (renderingGroupId, autoClearDepthStencil, depth, stencil) {
            if (depth === void 0) { depth = true; }
            if (stencil === void 0) { stencil = true; }
            this._renderingManager.setRenderingAutoClearDepthStencil(renderingGroupId, autoClearDepthStencil, depth, stencil);
        };
        /**
         * Will flag all materials as dirty to trigger new shader compilation
         * @param predicate If not null, it will be used to specifiy if a material has to be marked as dirty
         */
        Scene.prototype.markAllMaterialsAsDirty = function (flag, predicate) {
            for (var _i = 0, _a = this.materials; _i < _a.length; _i++) {
                var material = _a[_i];
                if (predicate && !predicate(material)) {
                    continue;
                }
                material.markAsDirty(flag);
            }
        };
        // Statics
        Scene._FOGMODE_NONE = 0;
        Scene._FOGMODE_EXP = 1;
        Scene._FOGMODE_EXP2 = 2;
        Scene._FOGMODE_LINEAR = 3;
        Scene._uniqueIdCounter = 0;
        Scene.MinDeltaTime = 1.0;
        Scene.MaxDeltaTime = 1000.0;
        /** The distance in pixel that you have to move to prevent some events */
        Scene.DragMovementThreshold = 10; // in pixels
        /** Time in milliseconds to wait to raise long press events if button is still pressed */
        Scene.LongPressDelay = 500; // in milliseconds
        /** Time in milliseconds with two consecutive clicks will be considered as a double click */
        Scene.DoubleClickDelay = 300; // in milliseconds
        /** If you need to check double click without raising a single click at first click, enable this flag */
        Scene.ExclusiveDoubleClickMode = false;
        return Scene;
    }());
    BABYLON.Scene = Scene;
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.scene.js.map

var BABYLON;
(function (BABYLON) {
    var Buffer = /** @class */ (function () {
        function Buffer(engine, data, updatable, stride, postponeInternalCreation, instanced) {
            if (instanced === void 0) { instanced = false; }
            if (engine instanceof BABYLON.Mesh) {
                this._engine = engine.getScene().getEngine();
            }
            else {
                this._engine = engine;
            }
            this._updatable = updatable;
            this._data = data;
            this._strideSize = stride;
            if (!postponeInternalCreation) {
                this.create();
            }
            this._instanced = instanced;
            this._instanceDivisor = instanced ? 1 : 0;
        }
        Buffer.prototype.createVertexBuffer = function (kind, offset, size, stride) {
            // a lot of these parameters are ignored as they are overriden by the buffer
            return new BABYLON.VertexBuffer(this._engine, this, kind, this._updatable, true, stride ? stride : this._strideSize, this._instanced, offset, size);
        };
        // Properties
        Buffer.prototype.isUpdatable = function () {
            return this._updatable;
        };
        Buffer.prototype.getData = function () {
            return this._data;
        };
        Buffer.prototype.getBuffer = function () {
            return this._buffer;
        };
        Buffer.prototype.getStrideSize = function () {
            return this._strideSize;
        };
        Buffer.prototype.getIsInstanced = function () {
            return this._instanced;
        };
        Object.defineProperty(Buffer.prototype, "instanceDivisor", {
            get: function () {
                return this._instanceDivisor;
            },
            set: function (value) {
                this._instanceDivisor = value;
                if (value == 0) {
                    this._instanced = false;
                }
                else {
                    this._instanced = true;
                }
            },
            enumerable: true,
            configurable: true
        });
        // Methods
        Buffer.prototype.create = function (data) {
            if (data === void 0) { data = null; }
            if (!data && this._buffer) {
                return; // nothing to do
            }
            data = data || this._data;
            if (!data) {
                return;
            }
            if (!this._buffer) {
                if (this._updatable) {
                    this._buffer = this._engine.createDynamicVertexBuffer(data);
                    this._data = data;
                }
                else {
                    this._buffer = this._engine.createVertexBuffer(data);
                }
            }
            else if (this._updatable) {
                this._engine.updateDynamicVertexBuffer(this._buffer, data);
                this._data = data;
            }
        };
        Buffer.prototype._rebuild = function () {
            this._buffer = null;
            this.create(this._data);
        };
        Buffer.prototype.update = function (data) {
            this.create(data);
        };
        Buffer.prototype.updateDirectly = function (data, offset, vertexCount) {
            if (!this._buffer) {
                return;
            }
            if (this._updatable) {
                this._engine.updateDynamicVertexBuffer(this._buffer, data, offset, (vertexCount ? vertexCount * this.getStrideSize() : undefined));
                this._data = null;
            }
        };
        Buffer.prototype.dispose = function () {
            if (!this._buffer) {
                return;
            }
            if (this._engine._releaseBuffer(this._buffer)) {
                this._buffer = null;
            }
        };
        return Buffer;
    }());
    BABYLON.Buffer = Buffer;
})(BABYLON || (BABYLON = {}));

//# sourceMappingURL=babylon.buffer.js.map

var BABYLON;
(function (BABYLON) {
    var VertexBuffer = /** @class */ (function () {
        function VertexBuffer(engine, data, kind, updatable, postponeInternalCreation, stride, instanced, offset, size) {
            if (!stride) {
                // Deduce stride from kind
                switch (kind) {
                    case VertexBuffer.PositionKind:
                        stride = 3;
                        break;
                    case VertexBuffer.NormalKind:
                        stride = 3;
                        break;
                    case VertexBuffer.UVKind:
                    case VertexBuffer.UV2Kind:
                    case VertexBuffer.UV3Kind:
                    case VertexBuffer.UV4Kind:
                    case VertexBuffer.UV5Kind:
                    case VertexBuffer.UV6Kind:
                        stride = 2;
                        break;
                    case VertexBuffer.TangentKind:
                    case VertexBuffer.ColorKind:
                        stride = 4;
                        break;
                    case VertexBuffer.MatricesIndicesKind:
                    case VertexBuffer.MatricesIndicesExtraKind:
                        stride = 4;
                        break;
                    case VertexBuffer.MatricesWeightsKind:
                    case VertexBuffer.MatricesWeightsExtraKind:
                    default:
                        stride = 4;
                        break;
                }
            }
            if (data instanceof BABYLON.Buffer) {
                if (!stride) {
                    stride = data.getStrideSize();
                }
                this._buffer = data;
                this._ownsBuffer = false;
            }
            else {
                this._buffer = new BABYLON.Buffer(engine, data, updatable, stride, postponeInternalCreation, instanced);
                this._ownsBuffer = true;
            }
            this._stride = stride;
            this._offset = offset ? offset : 0;
            this._size = si